/*
 * Decompiled with CFR 0.152.
 */
package drivers.satel;

import com.hsyco.userBase;
import drivers.satel.Driver;
import drivers.satel.LogEvent;
import drivers.satel.LogEventRequest;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Monitor
extends Thread {
    private static final long MAX_RESPONSE_TIMOUT = 3500L;
    private final Driver driver;
    private final InputStream in;
    boolean run = true;
    private long onlineMap = 0L;
    private int[] latestEventIndex;
    private int[] prevLatestEventIndex;
    private Stack<LogEvent> logStack = new Stack();
    private LogEvent lastLogEvent;
    private Map<Integer, String> partitionNames = new HashMap<Integer, String>();
    private Map<Integer, String> zoneNames = new HashMap<Integer, String>();
    private boolean integra256;
    private boolean integra24_32;
    private boolean sysArmed;
    private boolean sysGt10;
    private boolean sysLt10;

    Monitor(Driver driver, InputStream in) {
        this.driver = driver;
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int state = 0;
        int cmd = 0;
        ArrayList<Integer> data = null;
        while (this.run) {
            try {
                int b2 = this.in.read();
                if (b2 == -1) break;
                if (state == 0) {
                    if (b2 != 254) continue;
                    state = 1;
                    continue;
                }
                if (state == 1) {
                    if (b2 != 254) continue;
                    state = 2;
                    continue;
                }
                if (state == 2) {
                    if (b2 == 254) continue;
                    cmd = b2;
                    data = new ArrayList<Integer>();
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    if (b2 == 254) {
                        state = 4;
                        continue;
                    }
                    data.add(b2);
                    continue;
                }
                if (state != 4) continue;
                if (b2 == 240) {
                    data.add(254);
                    state = 3;
                    continue;
                }
                if (b2 == 13) {
                    if (this.process(cmd, data)) {
                        this.driver.heartbeat = System.currentTimeMillis();
                    }
                    Monitor monitor = this;
                    synchronized (monitor) {
                        this.notifyAll();
                    }
                    data = null;
                    state = 0;
                    continue;
                }
                state = 2;
            }
            catch (SocketTimeoutException b2) {
            }
            catch (Exception e2) {
                this.driver.errorLog("Exception in monitor loop: " + e2);
                if (!(e2 instanceof SocketException)) continue;
                this.run = false;
            }
        }
        this.run = false;
    }

    private boolean process(int cmd, List<Integer> data) {
        if (!this.checkCrc(cmd, data)) {
            this.driver.errorLog("Received corrupted frame: " + cmd + " " + data);
            return false;
        }
        switch (cmd) {
            case 126: {
                String version = this.getVersionString(data);
                this.driver.messageLog("Panel version: " + version);
                break;
            }
            case 0: {
                this.setZones(data, "open");
                break;
            }
            case 1: {
                this.setZones(data, "tamper");
                break;
            }
            case 2: {
                this.setZones(data, "alarm");
                break;
            }
            case 3: {
                boolean sysAlarmTamper = this.setZones(data, "alarm.tamper");
                this.set("alarm.tamper", sysAlarmTamper ? 1 : 0);
                break;
            }
            case 4: {
                this.setZones(data, "alarm.mem");
                break;
            }
            case 5: {
                boolean sysAlarmTamperMem = this.setZones(data, "alarm.tamper.mem");
                this.set("alarm.tamper.mem", sysAlarmTamperMem ? 1 : 0);
                break;
            }
            case 6: {
                this.setZones(data, "bypassed");
                break;
            }
            case 7: {
                this.setZones(data, "trouble");
                break;
            }
            case 8: {
                this.setZones(data, "trouble.long");
                break;
            }
            case 9: {
                this.setPartitions(data, "armed.suppressed");
                break;
            }
            case 10: {
                this.sysArmed = this.setPartitions(data, "armed");
                this.set("armed", this.sysArmed ? 1 : 0);
                break;
            }
            case 11: {
                this.setPartitions(data, "armed2");
                break;
            }
            case 12: {
                this.setPartitions(data, "armed3");
                break;
            }
            case 13: {
                this.setPartitions(data, "code");
                break;
            }
            case 14: {
                this.setPartitions(data, "entry");
                break;
            }
            case 15: {
                this.sysGt10 = this.setPartitions(data, "exit.gt10");
                break;
            }
            case 16: {
                this.sysLt10 = this.setPartitions(data, "exit.lt10");
                break;
            }
            case 17: {
                this.setPartitions(data, "blocked.temp");
                break;
            }
            case 18: {
                this.setPartitions(data, "blocked.guard");
                break;
            }
            case 19: {
                boolean sysAlarm = this.setPartitions(data, "alarm");
                this.set("alarm", sysAlarm ? 1 : 0);
                break;
            }
            case 20: {
                boolean sysAlarmFire = this.setPartitions(data, "alarm.fire");
                this.set("alarm.fire", sysAlarmFire ? 1 : 0);
                break;
            }
            case 21: {
                boolean sysAlarmMem = this.setPartitions(data, "alarm.mem");
                this.set("alarm.mem", sysAlarmMem ? 1 : 0);
                break;
            }
            case 22: {
                boolean sysAlarmFireMem = this.setPartitions(data, "alarm.fire.mem");
                this.set("alarm.fire.mem", sysAlarmFireMem ? 1 : 0);
                break;
            }
            case 23: {
                this.setOutputs(data, "on");
                break;
            }
            case 24: {
                this.setDoors(data, "open");
                break;
            }
            case 25: {
                this.setDoors(data, "open.long");
                break;
            }
            case 26: {
                String YYh = Integer.toHexString(data.get(0) | 0x100).substring(1);
                String YYl = Integer.toHexString(data.get(1) | 0x100).substring(1);
                String MM = Integer.toHexString(data.get(2) | 0x100).substring(1);
                String DD = Integer.toHexString(data.get(3) | 0x100).substring(1);
                String hh = Integer.toHexString(data.get(4) | 0x100).substring(1);
                String mm = Integer.toHexString(data.get(5) | 0x100).substring(1);
                String ss = Integer.toHexString(data.get(6) | 0x100).substring(1);
                int b2 = data.get(7);
                this.driver.ioWrite("time", YYh + YYl + "-" + MM + "-" + DD + " " + hh + ":" + mm + ":" + ss);
                this.set("trouble", b2 >>> 6);
                this.set("service", b2 >>> 7);
                b2 = data.get(8);
                this.set("trouble.mem", b2 >>> 5);
                break;
            }
            case 27: {
                this.setTroubles(1, data);
                break;
            }
            case 28: {
                this.setTroubles(2, data);
                break;
            }
            case 29: {
                this.setTroubles(3, data);
                break;
            }
            case 30: {
                this.setTroubles(4, data);
                break;
            }
            case 31: {
                this.setTroubles(5, data);
                break;
            }
            case 32: {
                this.setTroublesMem(1, data);
                break;
            }
            case 33: {
                this.setTroublesMem(2, data);
                break;
            }
            case 34: {
                this.setTroublesMem(3, data);
                break;
            }
            case 35: {
                this.setTroublesMem(4, data);
                break;
            }
            case 36: {
                this.setTroublesMem(5, data);
                break;
            }
            case 37: {
                this.setPartitions(data, "open");
                break;
            }
            case 38: {
                this.setZones(data, "isolated");
                break;
            }
            case 39: {
                this.setPartitions(data, "alarm.verified");
                break;
            }
            case 40: {
                this.setZones(data, "masked");
                break;
            }
            case 41: {
                this.setZones(data, "masked.mem");
                break;
            }
            case 42: {
                this.setPartitions(data, "armed1");
                break;
            }
            case 43: {
                this.setPartitions(data, "warning");
                break;
            }
            case 44: {
                this.setTroubles(6, data);
                break;
            }
            case 45: {
                this.setTroubles(7, data);
                break;
            }
            case 46: {
                this.setTroublesMem(6, data);
                break;
            }
            case 47: {
                this.setTroublesMem(7, data);
                break;
            }
            case 140: {
                this.processLogEvent(data);
                break;
            }
            case 143: {
                this.getLogEventText(data);
                break;
            }
            case 238: {
                this.setDeviceName(data);
                break;
            }
            case 239: {
                this.driver.cmdResult = data.get(0);
                break;
            }
            default: {
                return false;
            }
        }
        if (!this.driver.online && cmd <= 47) {
            this.onlineMap |= 1L << cmd;
            if (this.onlineMap == 0xFFFFFFFFFFFFL) {
                this.driver.online = true;
                this.driver.genEvent = true;
                this.driver.ioWrite("connection", "online");
                this.driver.securityLog("HSYCO ONLINE", null, null, null);
                this.driver.uiSet("connection.offline", "visible", "false");
                this.driver.uiSet("connection.online", "visible", "true");
                this.updatePartitionsList();
                this.updateZonesList();
            }
        }
        if (this.sysArmed) {
            this.driver.uiSet("armed.1", "blink", "false");
        } else if (this.sysLt10 || this.sysGt10) {
            this.driver.uiSet("armed.1", "blink", "true");
            this.driver.uiSet("armed.1", "visible", "true");
        }
        return true;
    }

    private void setTroubles(int part, List<Integer> data) {
        switch (part) {
            case 1: {
                this.setMap(data, "tz", "trouble", 0, 16, -1, 1);
                this.setMap(data, "e", "trouble.ac", 16, 8, -1, 1);
                this.setMap(data, "e", "trouble.batt", 24, 8, -1, 1);
                this.setMap(data, "e", "trouble.nobatt", 32, 8, -1, 1);
                int b2 = data.get(40);
                this.set("trouble.out1", b2);
                this.set("trouble.out2", b2 >>> 1);
                this.set("trouble.out3", b2 >>> 2);
                this.set("trouble.out4", b2 >>> 3);
                this.set("trouble.kpd", b2 >>> 4);
                this.set("trouble.ex", b2 >>> 5);
                this.set("trouble.batt", b2 >>> 6);
                this.set("trouble.ac", b2 >>> 7);
                b2 = data.get(41);
                this.set("trouble.dt1", b2);
                this.set("trouble.dt2", b2 >>> 1);
                this.set("trouble.dtm", b2 >>> 2);
                this.set("trouble.rtc", b2 >>> 3);
                this.set("trouble.nodtr", b2 >>> 4);
                this.set("trouble.nobatt", b2 >>> 5);
                this.set("trouble.modem.init", b2 >>> 6);
                this.set("trouble.modem.comm", b2 >>> 7);
                b2 = data.get(42);
                this.set("trouble.aux", b2);
                this.set("trouble.tel.badsig", b2 >>> 1);
                this.set("trouble.tel.nosig", b2 >>> 2);
                this.set("trouble.st1", b2 >>> 3);
                this.set("trouble.st2", b2 >>> 4);
                this.set("trouble.eeprom", b2 >>> 5);
                this.set("trouble.ram", b2 >>> 6);
                this.set("trouble.mem.restart", b2 >>> 7);
                this.setMap(data, "ptsa", "trouble.ac", 43, 1, -1, 1);
                this.setMap(data, "ptsa", "trouble.batt", 44, 1, -1, 1);
                this.setMap(data, "ptsa", "trouble.nobatt", 45, 1, -1, 1);
                this.setMap(data, "ethm", "trouble", 46, 1, -1, 1);
                break;
            }
            case 2: {
                this.setMap(data, "r", "trouble.head.a", 0, 8, -1, 1);
                this.setMap(data, "r", "trouble.head.b", 8, 8, -1, 1);
                this.setMap(data, "e", "trouble.overload", 16, 8, -1, 1);
                this.setMap(data, "e", "trouble.shortcirc", 24, 2, -1, 1);
                break;
            }
            case 3: {
                this.setMap(data, "acu", "trouble.jam", 0, 15, -1, 1);
                this.setMap(data, "rd", "trouble.batt", 15, 15, -1, 1);
                this.setMap(data, "rd", "trouble.comm", 30, 15, -1, 1);
                this.setMap(data, "ro", "trouble.comm", 45, 15, -1, 1);
                break;
            }
            case 4: {
                this.setMap(data, "e", "trouble.comm", 0, 8, -1, 1);
                this.setMap(data, "e", "trouble.switch", 8, 8, -1, 1);
                this.setMap(data, "k", "trouble.comm", 16, 1, -1, 1);
                this.setMap(data, "k", "trouble.switch", 17, 1, -1, 1);
                this.setMap(data, "ethm", "trouble.lan", 18, 1, -1, 1);
                this.setMap(data, "e", "tamper", 19, 8, -1, 1);
                this.setMap(data, "k", "tamper", 27, 1, -1, 1);
                this.setMap(data, "k", "trouble.init", 28, 1, -1, 1);
                this.setMap(data, "stm", "trouble", 29, 1, -1, 1);
                break;
            }
            case 5: {
                this.setMap(data, "mkf", "trouble.batt", 0, 1, -1, 1);
                this.setMap(data, "ukf", "trouble.batt", 1, 30, -1, 1);
                break;
            }
            case 6: {
                this.setMap(data, "rd", "trouble.batt", 0, 15, -1, 121);
                this.setMap(data, "rd", "trouble.comm", 15, 15, -1, 121);
                this.setMap(data, "ro", "trouble.comm", 30, 15, -1, 121);
                break;
            }
            case 7: {
                this.setMap(data, "tz", "trouble", 0, 16, -1, 129);
                this.setMap(data, "tz", "trouble.mem", 16, 16, -1, 129);
                this.setMap(data, "acu", "trouble.jam", 32, 15, -1, 121);
                break;
            }
        }
    }

    private void setTroublesMem(int part, List<Integer> data) {
        switch (part) {
            case 1: {
                this.setMap(data, "tz", "trouble.mem", 0, 16, -1, 1);
                this.setMap(data, "e", "trouble.ac.mem", 16, 8, -1, 1);
                this.setMap(data, "e", "trouble.batt.mem", 24, 8, -1, 1);
                this.setMap(data, "e", "trouble.nobatt.mem", 32, 8, -1, 1);
                int b2 = data.get(40);
                this.set("trouble.out1.mem", b2);
                this.set("trouble.out2.mem", b2 >>> 1);
                this.set("trouble.out3.mem", b2 >>> 2);
                this.set("trouble.out4.mem", b2 >>> 3);
                this.set("trouble.kpd.mem", b2 >>> 4);
                this.set("trouble.ex.mem", b2 >>> 5);
                this.set("trouble.batt.mem", b2 >>> 6);
                this.set("trouble.ac.mem", b2 >>> 7);
                b2 = data.get(41);
                this.set("trouble.dt1.mem", b2);
                this.set("trouble.dt2.mem", b2 >>> 1);
                this.set("trouble.dtm.mem", b2 >>> 2);
                this.set("trouble.rtc.mem", b2 >>> 3);
                this.set("trouble.nodtr.mem", b2 >>> 4);
                this.set("trouble.nobatt.mem", b2 >>> 5);
                this.set("trouble.modem.init.mem", b2 >>> 6);
                this.set("trouble.modem.comm.mem", b2 >>> 7);
                b2 = data.get(42);
                this.set("trouble.aux.mem", b2);
                this.set("trouble.tel.badsig.mem", b2 >>> 1);
                this.set("trouble.tel.nosig.mem", b2 >>> 2);
                this.set("trouble.st1.mem", b2 >>> 3);
                this.set("trouble.st2.mem", b2 >>> 4);
                this.set("trouble.eeprom.mem", b2 >>> 5);
                this.set("trouble.ram.mem", b2 >>> 6);
                this.set("trouble.mem.restart.mem", b2 >>> 7);
                this.setMap(data, "ptsa", "trouble.ac.mem", 43, 1, -1, 1);
                this.setMap(data, "ptsa", "trouble.batt.mem", 44, 1, -1, 1);
                this.setMap(data, "ptsa", "trouble.nobatt.mem", 45, 1, -1, 1);
                this.setMap(data, "ethm", "trouble.mem", 46, 1, -1, 1);
                break;
            }
            case 2: {
                this.setMap(data, "r", "trouble.head.a.mem", 0, 8, -1, 1);
                this.setMap(data, "r", "trouble.head.b.mem", 8, 8, -1, 1);
                this.setMap(data, "e", "trouble.overload.mem", 16, 8, -1, 1);
                this.setMap(data, "e", "trouble.shortcirc.mem", 24, 2, -1, 1);
                this.setMap(data, "k", "trouble.restart.mem", 26, 1, -1, 1);
                this.setMap(data, "e", "trouble.restart.mem", 27, 8, -1, 1);
                int h2 = data.get(35);
                int l2 = data.get(36);
                this.driver.ioWrite("gsm.trouble.code", "" + (h2 << 8 | l2));
                h2 = data.get(37);
                l2 = data.get(38);
                this.driver.ioWrite("gsm.trouble.code.mem", "" + (h2 << 8 | l2));
                break;
            }
            case 3: {
                if (this.integra256) {
                    this.setMap(data, "e", "trouble.shortcirc", 0, 2, -1, 17);
                    this.setMap(data, "e", "trouble.shortcirc.mem", 2, 2, -1, 17);
                }
                this.setMap(data, "rd", "trouble.batt.mem", 15, 15, -1, 1);
                this.setMap(data, "rd", "trouble.comm.mem", 30, 15, -1, 1);
                this.setMap(data, "ro", "trouble.comm.mem", 45, 15, -1, 1);
                break;
            }
            case 4: {
                this.setMap(data, "e", "trouble.comm.mem", 0, 8, -1, 1);
                this.setMap(data, "e", "trouble.switch.mem", 8, 8, -1, 1);
                this.setMap(data, "k", "trouble.comm.mem", 16, 1, -1, 1);
                this.setMap(data, "k", "trouble.switch.mem", 17, 1, -1, 1);
                this.setMap(data, "ethm", "trouble.lan.mem", 18, 1, -1, 1);
                this.setMap(data, "e", "tamper.mem", 19, 8, -1, 1);
                this.setMap(data, "k", "tamper.mem", 27, 1, -1, 1);
                this.setMap(data, "k", "trouble.init.mem", 28, 1, -1, 1);
                this.setMap(data, "stm", "trouble.mem", 29, 1, -1, 1);
                break;
            }
            case 5: {
                this.setMap(data, "z", "trouble.long.mem", 0, 16, this.driver.maxZone, 1);
                this.setMap(data, "z", "trouble.mem", 16, 16, this.driver.maxZone, 1);
                this.setMap(data, "z", "tamper.mem", 32, 16, this.driver.maxZone, 1);
                break;
            }
            case 6: {
                this.setMap(data, "rd", "trouble.batt.mem", 0, 15, -1, 121);
                this.setMap(data, "rd", "trouble.comm.mem", 15, 15, -1, 121);
                this.setMap(data, "ro", "trouble.comm.mem", 30, 15, -1, 121);
                break;
            }
            case 7: {
                this.setMap(data, "z", "trouble.long.mem", 0, 16, this.driver.maxZone, 129);
                this.setMap(data, "z", "trouble.mem", 16, 16, this.driver.maxZone, 129);
                this.setMap(data, "z", "tamper.mem", 32, 16, this.driver.maxZone, 129);
                break;
            }
        }
    }

    private void setDeviceName(List<Integer> data) {
        int num = data.get(1);
        StringBuilder sb = new StringBuilder();
        int i2 = 3;
        while (i2 < 19) {
            sb.append((char)data.get(i2).intValue());
            ++i2;
        }
        String name = sb.toString().trim().replaceAll("\\s+", " ");
        switch (data.get(0)) {
            case 0: {
                this.partitionNames.put(num, name);
                this.driver.ioWrite("p" + num + ".name", name);
                this.driver.uiSet("p" + num + ".name", "value", name);
                break;
            }
            case 1: {
                this.zoneNames.put(num, name);
                this.driver.ioWrite("z" + num + ".name", name);
                this.driver.uiSet("z" + num + ".name", "value", name);
                break;
            }
        }
    }

    private void getLogEventText(List<Integer> data) {
        int b2 = data.get(0);
        int r = b2 >>> 2 & 1;
        int ch = b2 & 3;
        int c2 = (ch << 8) + data.get(1);
        StringBuilder sb = new StringBuilder();
        int i2 = 5;
        while (i2 < data.size() - 2) {
            sb.append((char)data.get(i2).intValue());
            ++i2;
        }
        String text = sb.toString().trim();
        Map<Integer, String> rs = LogEvent.LOG_EVENTS_TEXT_CACHE.get(c2);
        if (rs == null) {
            rs = new HashMap<Integer, String>();
            LogEvent.LOG_EVENTS_TEXT_CACHE.put(c2, rs);
        }
        rs.put(r, text);
        if (this.lastLogEvent != null && this.lastLogEvent.message == null) {
            this.lastLogEvent.message = text;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processLogEvent(List<Integer> data) {
        block10: {
            block12: {
                block11: {
                    b = data.get(0);
                    z = b >>> 5 & 1;
                    if (z != 1) break block10;
                    eventIndex = new int[]{data.get(8), data.get(9), data.get(10)};
                    reqestedEventIndex = new int[]{data.get(11), data.get(12), data.get(13)};
                    isNew = false;
                    if (reqestedEventIndex[0] != 255 || reqestedEventIndex[1] != 255 || reqestedEventIndex[2] != 255) break block11;
                    if (this.latestEventIndex != null && (eventIndex[0] != this.latestEventIndex[0] || eventIndex[1] != this.latestEventIndex[1] || eventIndex[2] != this.latestEventIndex[2])) {
                        isNew = true;
                    }
                    this.prevLatestEventIndex = this.latestEventIndex;
                    this.latestEventIndex = eventIndex;
                    break block12;
                }
                if (eventIndex[0] == this.prevLatestEventIndex[0] && eventIndex[1] == this.prevLatestEventIndex[1] && eventIndex[2] == this.prevLatestEventIndex[2]) ** GOTO lbl25
                isNew = true;
                break block12;
lbl-1000:
                // 1 sources

                {
                    le = this.logStack.pop();
                    if (le.extrasOk) {
                        message = String.valueOf(le.message) + " - " + le.extras;
                        extras = null;
                    } else {
                        message = le.message;
                        extras = le.extras;
                    }
                    this.driver.securityLog(message, extras, "" + le.code, le.date);
lbl25:
                    // 2 sources

                    ** while (!this.logStack.isEmpty())
                }
            }
            if (isNew) {
                this.lastLogEvent = new LogEvent(data, this.integra256, this.integra24_32);
                this.logStack.push(this.lastLogEvent);
                if (this.lastLogEvent.message == null) {
                    h = 128 | this.lastLogEvent.restore << 2 | this.lastLogEvent.code >>> 8;
                    l = this.lastLogEvent.code & 255;
                    req = new LogEventRequest(143, new int[]{h, l});
                    try {
                        this.driver.logEventsQ.put(req);
                    }
                    catch (InterruptedException var10_13) {
                        // empty catch block
                    }
                }
                req = new LogEventRequest(140, eventIndex);
                try {
                    this.driver.logEventsQ.put(req);
                }
                catch (InterruptedException var8_11) {
                    // empty catch block
                }
            }
        }
    }

    private boolean setZones(List<Integer> data, String attribute) {
        boolean set = this.setMap(data, "z", attribute, this.driver.maxZone);
        this.updateZonesList();
        return set;
    }

    private void updateZonesList() {
        if (this.driver.online) {
            StringBuilder labels = new StringBuilder();
            int i2 = 1;
            while (i2 <= this.driver.maxZone) {
                String name = this.zoneNames.get(i2);
                if (name == null) {
                    name = "Zone " + i2;
                }
                StringBuilder l2 = new StringBuilder(name);
                l2.append('|');
                if ("1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".open"))) {
                    l2.append("<img src=\"/$skin$/pic/satel/open.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if ("1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".alarm.mem"))) {
                    l2.append("<img src=\"/$skin$/pic/satel/alarm.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if ("1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".tamper.mem"))) {
                    l2.append("<img src=\"/$skin$/pic/satel/tamper.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if ("1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".bypassed"))) {
                    l2.append("<img src=\"/$skin$/pic/satel/bypass.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if ("1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".trouble")) || "1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".trouble.long")) || "1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".z" + i2 + ".masked.mem"))) {
                    l2.append("<img src=\"/$skin$/pic/satel/trouble.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                labels.append(',').append((CharSequence)l2);
                ++i2;
            }
            if (labels.length() > 1) {
                this.driver.uiSet("zones.list", "labels", labels.substring(1));
            }
        }
    }

    private boolean setPartitions(List<Integer> data, String attribute) {
        boolean set = this.setMap(data, "p", attribute, this.driver.maxPartition);
        this.updatePartitionsList();
        return set;
    }

    private void updatePartitionsList() {
        if (this.driver.online) {
            StringBuilder labels = new StringBuilder();
            int i2 = 1;
            while (i2 <= this.driver.maxPartition) {
                String l2 = this.partitionNames.get(i2);
                if (l2 == null) {
                    l2 = "Partition " + i2;
                }
                l2 = "1".equals(userBase.ioGet(String.valueOf(this.driver.name) + ".p" + i2 + ".armed")) ? String.valueOf(l2) + "|arm.png" : String.valueOf(l2) + "|disarm-tr.png";
                labels.append(',').append(l2);
                ++i2;
            }
            if (labels.length() > 1) {
                this.driver.uiSet("partitions.list", "labels", labels.substring(1));
            }
        }
    }

    private void setOutputs(List<Integer> data, String attribute) {
        this.setMap(data, "o", attribute, this.driver.maxOutput);
    }

    private void setDoors(List<Integer> data, String attribute) {
        this.setMap(data, "d", attribute, this.driver.maxDoor);
    }

    private boolean setMap(List<Integer> data, String prefix, String attribute, int max) {
        return this.setMap(data, prefix, attribute, 0, data.size() - 2, max, 1);
    }

    private boolean setMap(List<Integer> data, String prefix, String attribute, int start, int len, int maxIndex, int indexStart) {
        boolean set = false;
        int i2 = start;
        while (i2 < start + len) {
            int b2 = data.get(i2);
            int s = 0;
            while (s < 8) {
                int index = (i2 - start) * 8 + s + indexStart;
                if (maxIndex >= 0 && index > maxIndex) {
                    return set;
                }
                String id = String.valueOf(prefix) + index + "." + attribute;
                if (this.set(id, b2 >>> s)) {
                    set = true;
                }
                ++s;
            }
            ++i2;
        }
        return set;
    }

    private boolean set(String id, int bit) {
        if ((bit & 1) == 0) {
            this.driver.ioWrite(id, "0");
            this.driver.uiSet(String.valueOf(id) + ".0", "visible", "true");
            this.driver.uiSet(String.valueOf(id) + ".1", "visible", "false");
            return false;
        }
        this.driver.ioWrite(id, "1");
        this.driver.uiSet(String.valueOf(id) + ".1", "visible", "true");
        this.driver.uiSet(String.valueOf(id) + ".0", "visible", "false");
        return true;
    }

    private String getVersionString(List<Integer> data) {
        String model;
        switch (data.get(0)) {
            case 0: {
                model = "INTEGRA 24";
                this.integra24_32 = true;
                break;
            }
            case 1: {
                model = "INTEGRA 32";
                this.integra24_32 = true;
                break;
            }
            case 2: {
                model = "INTEGRA 64";
                break;
            }
            case 3: {
                model = "INTEGRA 128";
                break;
            }
            case 4: {
                model = "INTEGRA 128-WRL SIM300";
                break;
            }
            case 132: {
                model = "INTEGRA 128-WRL LEON";
                break;
            }
            case 66: {
                model = "INTEGRA 64 PLUS";
                break;
            }
            case 67: {
                model = "INTEGRA 128 PLUS";
                break;
            }
            case 72: {
                model = "INTEGRA 256 PLUS";
                this.integra256 = true;
                break;
            }
            default: {
                model = "Unknown";
            }
        }
        StringBuilder version = new StringBuilder();
        int i2 = 1;
        while (i2 <= 11) {
            if (i2 == 2) {
                version.append(".");
            } else if (i2 == 4) {
                version.append(" ");
            } else if (i2 == 8) {
                version.append("-");
            } else if (i2 == 10) {
                version.append("-");
            }
            version.append((char)data.get(i2).intValue());
            ++i2;
        }
        return String.valueOf(model) + " " + version.toString();
    }

    private boolean checkCrc(int cmd, List<Integer> dataAndCrc) {
        int[] data = new int[dataAndCrc.size() - 2];
        int i2 = 0;
        while (i2 < data.length) {
            data[i2] = dataAndCrc.get(i2);
            ++i2;
        }
        int crc = this.driver.getCrc(cmd, data);
        return (crc >>> 8 & 0xFF) == dataAndCrc.get(dataAndCrc.size() - 2) && (crc & 0xFF) == dataAndCrc.get(dataAndCrc.size() - 1);
    }

    public void quit() {
        this.run = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitResponse() throws InterruptedException {
        Monitor monitor = this;
        synchronized (monitor) {
            this.wait(3500L);
        }
    }
}

