/*
 * Decompiled with CFR 0.152.
 */
package drivers.satel;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.satel.LogEventRequest;
import drivers.satel.Monitor;
import drivers.satel.SessionCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final long LOOP_TIMEOUT = 5000L;
    private static final long STATE_REQ_INTERVAL = 60000L;
    private static final int[] EXTRA_BYTE = new int[1];
    private static final int[] FF_FF_FF = new int[]{255, 255, 255};
    public static final long STATE_COMMANDS_MAP = 0xFFFFFFFFFFFFL;
    String name;
    boolean genEvent = false;
    int maxZone = 256;
    int maxPartition = 32;
    int maxOutput = 256;
    int maxDoor = 64;
    int[] defaultUserCode;
    private int logSize = 20;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    boolean online;
    private Monitor monitor;
    long heartbeat;
    private long lastStateReq;
    ArrayBlockingQueue<LogEventRequest> logEventsQ = new ArrayBlockingQueue(5);
    int cmdResult;
    private Map<String, SessionCode> sessionCodes = new HashMap<String, SessionCode>();
    private DateFormat dateFormat;
    private long logTime;
    private Vector<String> logs;
    private String logVar;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            String host = config.get("host");
            String port = config.get("port");
            try {
                this.maxZone = Integer.parseInt(config.get("maxzone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxPartition = Integer.parseInt(config.get("maxpartition"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxOutput = Integer.parseInt(config.get("maxoutput"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxDoor = Integer.parseInt(config.get("maxdoor"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.defaultUserCode = Driver.userCodeToBytes(config.get("usercode"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.logSize = Integer.parseInt(config.get("logsize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.uiSet("zones.list", "panel", "false");
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
            this.uiSet("partitions.list", "panel", "false");
            this.uiSet("partitions.list", "multi", "true");
            this.uiSet("partitions.list", "autosend", "true");
            this.uiSet("zones.list", "panel", "false");
            this.uiSet("zones.list", "multi", "true");
            this.uiSet("zones.list", "autosend", "true");
            switch (Configuration.language) {
                case 1: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ITALIAN);
                    break;
                }
                case 2: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.FRENCH);
                    break;
                }
                default: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ENGLISH);
                }
            }
            this.loadLogs();
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(host, Integer.parseInt(port)), 10000);
            this.messageLog("Connecting to " + this.socket.getRemoteSocketAddress());
            this.socket.setSoTimeout(10000);
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            this.monitor = new Monitor(this, this.in);
            this.monitor.start();
            StringBuilder values = new StringBuilder();
            int i2 = 1;
            while (i2 <= this.maxPartition) {
                values.append(",").append(i2);
                ++i2;
            }
            this.uiSet("partitions.list", "values", values.substring(1));
            values = new StringBuilder();
            i2 = 1;
            while (i2 <= this.maxZone) {
                values.append(",").append(i2);
                ++i2;
            }
            this.uiSet("zones.list", "values", values.substring(1));
            this.writeAndWait(126, null);
            i2 = 1;
            while (i2 <= this.maxPartition) {
                int[] nArray = new int[2];
                nArray[1] = i2++;
                this.writeAndWait(238, nArray);
            }
            i2 = 1;
            while (i2 <= this.maxZone) {
                this.writeAndWait(238, new int[]{1, i2++});
            }
            int[] nArray = new int[12];
            nArray[0] = 255;
            nArray[1] = 255;
            nArray[2] = 255;
            nArray[3] = 255;
            nArray[4] = 255;
            nArray[5] = 255;
            this.writeAndWait(127, nArray);
            String startupevents = config.get("startupevents");
            if (startupevents != null) {
                this.genEvent = Boolean.parseBoolean(startupevents);
            }
            this.lastStateReq = this.heartbeat = System.currentTimeMillis();
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Initialization failed - " + e2.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void loadLogs() {
        this.logVar = "__HSYCO__SATEL_" + this.name + ".log!";
        ObjectInputStream ois = null;
        try {
            try {
                String s = userBase.varGet(this.logVar);
                if (s == null) {
                    this.logs = new Vector(this.logSize);
                }
                byte[] data = Base64.decodeBase64(s);
                ois = new ObjectInputStream(new ByteArrayInputStream(data));
                this.logs = (Vector)ois.readObject();
            }
            catch (Exception e2) {
                this.logs = new Vector(this.logSize);
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception exception) {}
        }
    }

    private static int[] userCodeToBytes(String uc) {
        int shift;
        int octect;
        int[] b2 = new int[8];
        int i2 = 0;
        while (i2 < uc.length()) {
            octect = i2 / 2;
            shift = i2 % 2 == 0 ? 4 : 0;
            int n2 = octect;
            b2[n2] = b2[n2] | Character.digit(uc.charAt(i2), 10) << shift;
            ++i2;
        }
        while (i2 < b2.length * 2) {
            octect = i2 / 2;
            shift = i2 % 2 == 0 ? 4 : 0;
            int n3 = octect;
            b2[n3] = b2[n3] | 15 << shift;
            ++i2;
        }
        return b2;
    }

    private synchronized void writeAndWait(int cmd, int[] data) throws IOException, InterruptedException {
        this.out.write(254);
        this.out.write(254);
        this.out.write(cmd);
        if (data != null) {
            int[] nArray = data;
            int n2 = data.length;
            int n3 = 0;
            while (n3 < n2) {
                int b2 = nArray[n3];
                this.out.write(b2);
                if (b2 == 254) {
                    this.out.write(240);
                }
                ++n3;
            }
        }
        int crc = this.getCrc(cmd, data);
        int b3 = crc >> 8 & 0xFF;
        this.out.write(b3);
        if (b3 == 254) {
            this.out.write(240);
        }
        b3 = crc & 0xFF;
        this.out.write(b3);
        if (b3 == 254) {
            this.out.write(240);
        }
        this.out.write(254);
        this.out.write(13);
        this.out.flush();
        this.monitor.waitResponse();
    }

    int getCrc(int cmd, int[] data) {
        int crc = 5242;
        crc = this.crc(crc, cmd);
        if (data != null) {
            int[] nArray = data;
            int n2 = data.length;
            int n3 = 0;
            while (n3 < n2) {
                int b2 = nArray[n3];
                crc = this.crc(crc, b2);
                ++n3;
            }
        }
        return crc;
    }

    private int crc(int crc, int b2) {
        crc = (crc >> 15 | crc << 1) & 0xFFFF;
        crc ^= 0xFFFF;
        crc += (crc >> 8 & 0xFF) + b2;
        return crc &= 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        try {
            LogEventRequest req = this.logEventsQ.poll(5000L, TimeUnit.MILLISECONDS);
            if (req == null) {
                req = new LogEventRequest(140, FF_FF_FF);
            }
            this.writeAndWait(req.command, req.data);
            if (System.currentTimeMillis() > this.lastStateReq + 60000L) {
                int cmd = 0;
                while (cmd <= 47) {
                    if ((0xFFFFFFFFFFFFL >>> cmd & 1L) == 1L) {
                        this.writeAndWait(cmd, EXTRA_BYTE);
                    }
                    ++cmd;
                }
                this.lastStateReq = System.currentTimeMillis();
            }
            Map<String, SessionCode> map = this.sessionCodes;
            synchronized (map) {
                Iterator<Map.Entry<String, SessionCode>> it = this.sessionCodes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, SessionCode> e2 = it.next();
                    if (System.currentTimeMillis() <= e2.getValue().ts + 120000L) continue;
                    this.uiSet(e2.getKey(), "object.container.keypad", "visible", "false");
                    it.remove();
                }
            }
            if (this.logTime != -1L && System.currentTimeMillis() > this.logTime + 5000L) {
                this.logTime = -1L;
                this.uiSet("log0", "value", "");
            }
            return this.monitor.run && this.heartbeat + 15000L > System.currentTimeMillis();
        }
        catch (Exception e3) {
            this.errorLog("Error in loop: " + e3);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean end() {
        String conn;
        if (this.monitor != null) {
            this.monitor.quit();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((conn = userBase.ioGet(String.valueOf(this.name) + ".connection")) == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog("HSYCO OFFLINE", null, null, null);
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        block20: {
            try {
                if (Configuration.verboseLog) {
                    this.messageLog("User command: " + id);
                }
                int sep = id.lastIndexOf(46);
                String cmd = id.substring(0, sep);
                String value = id.substring(sep + 1);
                if (cmd.equals("partitions.list") || cmd.equals("zones.list")) {
                    this.uiSet(session, cmd, "value", value);
                    break block20;
                }
                if (cmd.equals("arm")) {
                    String partitions = userBase.uiGet(session, String.valueOf(this.name) + ".partitions.list", "value");
                    if (partitions != null && !partitions.isEmpty()) {
                        String command = "p" + partitions.replace(',', '-') + ".armed";
                        this.uiSet(session, "object.command", "__hidden__", command);
                        this.uiSet(session, "object.command.val", "__hidden__", value);
                        this.uiSet(session, "object.container.keypad", "visible", "true");
                        this.uiSet(session, "keypad.code", "value", "_");
                        this.sessionCodes.remove(session);
                    }
                    break block20;
                }
                if (cmd.equals("bypass")) {
                    String zones = userBase.uiGet(session, String.valueOf(this.name) + ".zones.list", "value");
                    if (zones != null && !zones.isEmpty()) {
                        String command = "z" + zones.replace(',', '-') + ".bypassed";
                        this.uiSet(session, "object.command", "__hidden__", command);
                        this.uiSet(session, "object.command.val", "__hidden__", value);
                        this.uiSet(session, "object.container.keypad", "visible", "true");
                        this.uiSet(session, "keypad.code", "value", "_");
                        this.sessionCodes.remove(session);
                    }
                    break block20;
                }
                if (cmd.equals("digit")) {
                    SessionCode sc;
                    Object command = this.sessionCodes;
                    synchronized (command) {
                        sc = this.sessionCodes.get(session);
                        if (sc == null) {
                            sc = new SessionCode();
                            this.sessionCodes.put(session, sc);
                        }
                    }
                    if (value.equals("ok")) {
                        command = userBase.uiGet(session, String.valueOf(this.name) + ".object.command", "__hidden__");
                        String cVal = userBase.uiGet(session, String.valueOf(this.name) + ".object.command.val", "__hidden__");
                        if (sc.code.length() > 0) {
                            this.uiSet(session, "partitions.list", "value", "");
                            this.uiSet(session, "zones.list", "value", "");
                            this.uiSet(session, "object.container.keypad", "visible", "false");
                            this.command(String.valueOf(command) + "." + sc.code, cVal);
                        }
                    } else if (value.equals("c")) {
                        if (sc.code.length() == 0) {
                            this.uiSet(session, "object.container.keypad", "visible", "false");
                        } else {
                            sc.code = sc.code.substring(0, sc.code.length() - 1);
                        }
                    } else {
                        sc.code = String.valueOf(sc.code) + value;
                    }
                    this.uiSet(session, "keypad.code", "value", String.valueOf(sc.code.replaceAll("\\d", "\\*")) + "_");
                    break block20;
                }
                this.command(cmd, value);
            }
            catch (Exception e2) {
                this.errorLog("Error executing user command: " + e2.getLocalizedMessage());
            }
        }
        return "";
    }

    public void command(String name, String value) {
        block40: {
            try {
                String userCode2;
                name = name.toLowerCase();
                this.messageLog("Command: " + name + " = " + value);
                if (name.startsWith("trouble.mem") && value.equals("0")) {
                    String[] parts = name.split("\\.");
                    String userCode3 = parts.length > 2 ? parts[2] : null;
                    this.sendUserCodeCommand(139, 0, null, userCode3);
                    break block40;
                }
                if (name.startsWith("time")) {
                    if (value.equals("read")) {
                        this.writeAndWait(26, EXTRA_BYTE);
                    } else {
                        String[] parts = name.split("\\.");
                        String userCode4 = parts.length > 1 ? parts[1] : null;
                        byte[] data = value.replaceAll("\\D", "").getBytes(StandardCharsets.US_ASCII);
                        this.sendUserCodeCommand(142, 0, null, userCode4, data);
                    }
                    break block40;
                }
                String[] parts = name.split("\\.");
                String target = parts[0];
                String function = parts[1];
                String string = userCode2 = parts.length > 2 ? parts[2] : null;
                if (target.startsWith("p")) {
                    if (function.startsWith("armed")) {
                        if (value.equals("0")) {
                            this.sendUserCodeCommand(132, 4, target, userCode2);
                        } else if (function.endsWith("1")) {
                            if (value.endsWith("f")) {
                                this.sendUserCodeCommand(161, 4, target, userCode2);
                            } else {
                                this.sendUserCodeCommand(129, 4, target, userCode2);
                            }
                        } else if (function.endsWith("2")) {
                            if (value.endsWith("f")) {
                                this.sendUserCodeCommand(162, 4, target, userCode2);
                            } else {
                                this.sendUserCodeCommand(130, 4, target, userCode2);
                            }
                        } else if (function.endsWith("3")) {
                            if (value.endsWith("f")) {
                                this.sendUserCodeCommand(163, 4, target, userCode2);
                            } else {
                                this.sendUserCodeCommand(131, 4, target, userCode2);
                            }
                        } else if (value.endsWith("f")) {
                            this.sendUserCodeCommand(160, 4, target, userCode2);
                        } else {
                            this.sendUserCodeCommand(128, 4, target, userCode2);
                        }
                        break block40;
                    }
                    if (function.equals("alarm") && value.equals("clear")) {
                        this.sendUserCodeCommand(133, 4, target, userCode2);
                        break block40;
                    }
                    throw new Exception("unknown command");
                }
                if (target.startsWith("z")) {
                    if (function.startsWith("bypassed")) {
                        if (value.equals("1")) {
                            this.sendUserCodeCommand(134, 32, target, userCode2);
                        } else {
                            this.sendUserCodeCommand(135, 32, target, userCode2);
                        }
                        break block40;
                    }
                    if (function.startsWith("isolated")) {
                        if (value.equals("1")) {
                            this.sendUserCodeCommand(144, 32, target, userCode2);
                        }
                        break block40;
                    }
                    throw new Exception("unknown command");
                }
                if (target.startsWith("o")) {
                    if (function.startsWith("on")) {
                        if (value.equals("1")) {
                            this.sendUserCodeCommand(136, 32, target, userCode2);
                        } else if (value.equals("0")) {
                            this.sendUserCodeCommand(137, 32, target, userCode2);
                        } else {
                            this.sendUserCodeCommand(145, 32, target, userCode2);
                        }
                        break block40;
                    }
                    throw new Exception("unknown command");
                }
                if (target.startsWith("d")) {
                    if (function.startsWith("open")) {
                        if (value.equals("1")) {
                            this.sendUserCodeCommand(138, 32, target, userCode2);
                        }
                        break block40;
                    }
                    throw new Exception("unknown command");
                }
                throw new Exception("unknown command");
            }
            catch (Exception e2) {
                this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getMessage());
            }
        }
    }

    private void sendUserCodeCommand(int cmd, int mapSize, String target, String userCode2) throws Exception, InterruptedException {
        this.sendUserCodeCommand(cmd, mapSize, target, userCode2, null);
    }

    private synchronized void sendUserCodeCommand(int cmd, int mapSize, String target, String userCode2, byte[] extra) throws Exception, InterruptedException {
        int extraSize = extra == null ? 0 : extra.length;
        int[] data = new int[8 + mapSize + extraSize];
        this.addUserCode(data, userCode2);
        if (target != null) {
            this.addMap(data, target);
        }
        int i2 = 0;
        while (i2 < extraSize) {
            data[8 + mapSize + i2] = extra[i2];
            ++i2;
        }
        this.cmdResult = -1;
        this.writeAndWait(cmd, data);
        switch (this.cmdResult) {
            case -1: {
                throw new Exception("no response received");
            }
            case 0: 
            case 255: {
                return;
            }
            case 1: {
                throw new Exception("requesting user code not found");
            }
            case 2: {
                throw new Exception("no access");
            }
            case 3: {
                throw new Exception("selected user does not exist");
            }
            case 4: {
                throw new Exception("selected user already exists");
            }
            case 5: {
                throw new Exception("wrong code or code already exists");
            }
            case 6: {
                throw new Exception("telephone code already exists");
            }
            case 7: {
                throw new Exception("changed code is the same");
            }
            case 8: {
                throw new Exception("other error");
            }
            case 17: {
                throw new Exception("can not arm, but can use force arm");
            }
            case 18: {
                throw new Exception("can not arm");
            }
        }
        throw new Exception("other errors");
    }

    private void addUserCode(int[] data, String userCode2) throws Exception {
        int[] uc;
        if (userCode2 == null) {
            if (this.defaultUserCode == null) {
                throw new Exception("No user code set");
            }
            uc = this.defaultUserCode;
        } else {
            uc = Driver.userCodeToBytes(userCode2);
        }
        int i2 = 0;
        while (i2 < uc.length) {
            data[i2] = uc[i2];
            ++i2;
        }
    }

    private void addMap(int[] data, String name) {
        String[] ps;
        String[] stringArray = ps = name.substring(1).split("-");
        int n2 = ps.length;
        int n3 = 0;
        while (n3 < n2) {
            int octect;
            String p = stringArray[n3];
            int n4 = Integer.parseInt(p) - 1;
            int n5 = octect = n4 / 8 + 8;
            data[n5] = data[n5] | 1 << n4 % 8;
            ++n3;
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    void securityLog(String message, String extras, String code, String date) {
        String fileLog = date != null ? String.valueOf(date) + " - " : "";
        fileLog = String.valueOf(fileLog) + message;
        if (extras != null) {
            fileLog = String.valueOf(fileLog) + " - " + extras;
        }
        hsyco.securityLog(String.valueOf(this.name) + " - " + fileLog);
        this.logTime = System.currentTimeMillis();
        if (message == null) {
            message = "UNKNOWN";
        }
        String newEntry = String.valueOf(this.dateFormat.format(this.logTime).toUpperCase()) + "<br />" + message.toUpperCase();
        this.logs.add(0, newEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            String entry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(entry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.uiSet("log0", "value", message.toUpperCase());
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }
}

