/*
 * Decompiled with CFR 0.152.
 */
package drivers.samsungtv;

import com.hsyco.driverBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 55000;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final String THISAPPNAME = "hsyco.com";
    private static final byte[] RESPONSE_DATA_ACCESS_GRANTED;
    private static final int COMMAND_SEND_INTERVAL = 500;
    private InetSocketAddress address = null;
    private Socket sock = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private long timestamp = 0L;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 100;
        byArray[2] = 1;
        RESPONSE_DATA_ACCESS_GRANTED = byArray;
    }

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        try {
            this.address = new InetSocketAddress(config.get("host"), Integer.parseInt(config.get("port")));
            if (!this.connect()) {
                this.ioWrite("connection", "offline");
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean loop() {
        try {
            this.sleep(2000L);
            if (this.timestamp < System.currentTimeMillis() - 10000L) {
                this.sendKey("keepalive");
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean end() {
        this.disconnect();
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        try {
            String[] ida = id.split("/");
            if (ida.length == 1 || ida[1].equalsIgnoreCase("down")) {
                this.ioSet("send", ida[0]);
            } else if (ida[1].equalsIgnoreCase("repeat")) {
                int i2 = 0;
                while (i2 < 3) {
                    this.ioSet("send", ida[0]);
                    this.sleep(500L);
                    ++i2;
                }
            }
            return "";
        }
        catch (Exception e2) {
            return "nack";
        }
    }

    public void command(String name, String value) {
        try {
            if (name.equalsIgnoreCase("send")) {
                this.sendKey(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connect() {
        try {
            Driver driver = this;
            synchronized (driver) {
                this.sock = new Socket();
                this.sock.connect(this.address, 6000);
                this.sock.setSoTimeout(10000);
                this.in = new BufferedInputStream(this.sock.getInputStream());
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.out.write(0);
                this.out.write(this.frame(THISAPPNAME));
                this.out.write(this.registrationFrame());
                this.out.flush();
                if (!Arrays.equals(this.readResponse(), RESPONSE_DATA_ACCESS_GRANTED)) return false;
                this.ioWrite("connection", "online");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean disconnect() {
        if (this.connectionCheck()) {
            try {
                this.sock.close();
                this.ioWrite("connection", "offline");
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean connectionCheck() {
        return this.sock != null && !this.sock.isClosed() && this.sock.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendKey(String key) {
        if (this.connectionCheck() || this.connect()) {
            Driver driver = this;
            synchronized (driver) {
                try {
                    this.out.write(0);
                    this.out.write(this.frame(THISAPPNAME));
                    this.out.write(this.keyFrame("KEY_" + key.toUpperCase()));
                    this.out.flush();
                    byte[] data = this.readResponse();
                    if (data != null) {
                        this.timestamp = System.currentTimeMillis();
                    } else {
                        this.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.sleep(500L);
    }

    private byte[] readResponse() {
        try {
            byte[] data;
            int r;
            int i2 = this.in.read();
            if (i2 >= 0 && i2 <= 2 && (i2 = this.in.read()) > 0 && this.in.read() == 0 && (long)i2 == this.in.skip(i2) && (i2 = this.in.read()) > 0 && this.in.read() == 0 && (r = this.in.read(data = new byte[i2])) == i2) {
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private byte[] frame(byte[] data) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(data.length);
        bout.write(0);
        bout.write(data);
        return bout.toByteArray();
    }

    private byte[] frame(String text) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter sout = new OutputStreamWriter(bout);
        bout.write(text.length());
        bout.write(0);
        sout.write(text);
        sout.flush();
        return bout.toByteArray();
    }

    private byte[] frame64(String text) throws Exception {
        return this.frame(Base64.encodeBase64String(text.getBytes()));
    }

    private byte[] registrationFrame() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(100);
        bout.write(0);
        bout.write(this.frame64(this.sock.getLocalAddress().getHostAddress()));
        bout.write(this.frame64(this.getHardwareAddress()));
        bout.write(this.frame64("HSYCO "));
        return this.frame(bout.toByteArray());
    }

    private byte[] keyFrame(String key) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(0);
        bout.write(0);
        bout.write(0);
        bout.write(this.frame64(key));
        return this.frame(bout.toByteArray());
    }

    private String getHardwareAddress() throws Exception {
        Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
        while (eni.hasMoreElements()) {
            NetworkInterface ni = eni.nextElement();
            byte[] hw = ni.getHardwareAddress();
            if (ni.isLoopback() || hw == null) continue;
            Enumeration<InetAddress> eaddr = ni.getInetAddresses();
            while (eaddr.hasMoreElements()) {
                InetAddress addr = eaddr.nextElement();
                if (!addr.equals(this.sock.getLocalAddress())) continue;
                StringBuffer sb = new StringBuffer();
                int i2 = 0;
                while (i2 < hw.length) {
                    String b2;
                    if (i2 > 0) {
                        sb.append('-');
                    }
                    if ((b2 = Integer.toHexString(hw[i2] & 0xFF).toUpperCase()).length() == 1) {
                        sb.append('0');
                    }
                    sb.append(b2);
                    ++i2;
                }
                return sb.toString();
            }
        }
        return null;
    }
}

