/*
 * Decompiled with CFR 0.152.
 */
package drivers.rackpdu;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import com.hsyco.driverBase;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Vector;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 22;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static int MIN_POLL_TIME_MILLIS = 500;
    private String name = null;
    private String host = null;
    private int port = 22;
    private Connection connection = null;
    private Session session = null;
    private OutputStreamWriter stdin = null;
    private InputStreamReader stdout = null;
    private String user = null;
    private String password = null;
    private boolean startupevents = false;
    private boolean initialized = false;
    private int counter = 0;

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.host = config.get("host");
            String s = config.get("port");
            this.port = s == null ? 22 : Integer.parseInt(s);
            s = config.get("user");
            this.user = s == null ? "apc" : s;
            s = config.get("password");
            this.password = s == null ? "apc" : s;
            s = config.get("startupevents");
            if (s != null) {
                this.startupevents = Boolean.parseBoolean(s);
            }
            this.connection = new Connection(this.host, this.port);
            this.connection.connect(null, 6000, 6000);
            if (this.connection.authenticateWithPassword(this.user, this.password)) {
                String line;
                this.session = this.connection.openSession();
                this.stdin = new OutputStreamWriter(this.session.getStdin(), "UTF-8");
                this.stdout = new InputStreamReader(this.session.getStdout(), "UTF-8");
                this.session.startShell();
                while ((line = this.readOutLine(this.session, this.stdout)) != null) {
                    if (!line.equals("apc>")) continue;
                    return true;
                }
            } else {
                this.errorLog("ioMonitor - Authentication failed [" + name + "] - quit");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean loop() {
        try {
            long sleeptime;
            long t = System.currentTimeMillis();
            boolean ret = this.getStatus();
            if (ret && !this.initialized) {
                this.initialized = true;
                this.ioWrite("connection", "online");
            }
            if ((sleeptime = (long)MIN_POLL_TIME_MILLIS - (System.currentTimeMillis() - t)) > 0L) {
                this.sleep(sleeptime);
            }
            return ret;
        }
        catch (Exception exception) {
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        if (this.initialized) {
            this.ioWrite("connection", "offline");
        }
        try {
            this.stdin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void command(String name, String value) {
        int i2;
        Vector<String> response = null;
        if (name.equalsIgnoreCase("lcd")) {
            if (value.equalsIgnoreCase("on") || value.equals("1")) {
                response = this.command("lcd on");
            } else if (value.equalsIgnoreCase("off") || value.equals("0")) {
                response = this.command("lcd off");
            }
        } else if (name.equalsIgnoreCase("lcdblink") && (i2 = Integer.parseInt(value)) >= 1 && i2 <= 10) {
            response = this.command("lcdBlink " + value);
        }
        if (response == null) {
            this.errorLog("ioMonitor - command (" + name + "=" + value + ") error [" + this.name + "]");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readOutLine(Session session, InputStreamReader stdout) {
        sb = new StringBuffer();
        try {
            block11: {
                while (true) lbl-1000:
                // 3 sources

                {
                    if (!stdout.ready() && (session.waitForCondition(4, 3000L) & 4) == 0) {
                        if (sb.length() == 0) {
                            return null;
                        }
                        break block11;
                    }
                    ch = stdout.read();
                    switch (ch) {
                        case -1: {
                            if (sb.length() == 0) {
                                return null;
                            }
                            v0 = sb.toString();
                            return v0;
                        }
                        case 10: {
                            return sb.toString();
                        }
                        case 13: {
                            ** break;
                        }
                    }
                    sb.append((char)ch);
                    if (sb.toString().equals("apc>")) break;
                }
                return sb.toString();
            }
            v1 = sb.toString();
            return v1;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> command(String cmd) {
        Vector<String> response = new Vector<String>();
        boolean success = false;
        try {
            Connection connection = this.connection;
            synchronized (connection) {
                String line;
                this.stdin.write(cmd);
                this.stdin.flush();
                this.stdin.write("\n");
                this.stdin.flush();
                while ((line = this.readOutLine(this.session, this.stdout)) != null) {
                    if (line.equals("apc>")) {
                        return success ? response : null;
                    }
                    if (line.equalsIgnoreCase("E000: Success")) {
                        success = true;
                        continue;
                    }
                    if (line.equals(cmd) || line.length() <= 0) continue;
                    response.add(line);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean getStatus() {
        boolean ret = false;
        try {
            if (this.counter == 9) {
                this.counter = 0;
                ret |= this.parseResponseAndWrite("bkLowLoad", this.command("bkLowLoad all"));
                ret |= this.parseResponseAndWrite("bkNearOver", this.command("bkNearOver all"));
                ret |= this.parseResponseAndWrite("bkOverLoad", this.command("bkOverLoad all"));
                ret |= this.parseResponseAndWrite("devLowLoad", this.command("devLowLoad"));
                ret |= this.parseResponseAndWrite("devNearOver", this.command("devNearOver"));
                ret |= this.parseResponseAndWrite("devOverLoad", this.command("devOverLoad"));
                ret |= this.parseResponseAndWrite("humReading", this.command("humReading"));
                ret |= this.parseResponseAndWrite("phLowLoad", this.command("phLowLoad all"));
                ret |= this.parseResponseAndWrite("phNearOver", this.command("phNearOver all"));
                ret |= this.parseResponseAndWrite("phOverLoad", this.command("phOverLoad all"));
                ret |= this.parseResponseAndWrite("tempReading", this.command("tempReading C"));
            } else {
                ++this.counter;
                ret |= this.parseResponseAndWrite("bkPeakCurr", this.command("bkPeakCurr all"));
                ret |= this.parseResponseAndWrite("bkReading", this.command("bkReading all"));
                ret |= this.parseResponseAndWrite("devPeakLoad", this.command("devPeakLoad"));
                ret |= this.parseResponseAndWrite("devReading.power", this.command("devReading power"));
                ret |= this.parseResponseAndWrite("devReading.energy", this.command("devReading energy"));
                ret |= this.parseResponseAndWrite("devReading.appower", this.command("devReading appower"));
                ret |= this.parseResponseAndWrite("devReading.pf", this.command("devReading pf"));
                ret |= this.parseResponseAndWrite("phPeakCurr", this.command("phPeakCurr all"));
                ret |= this.parseResponseAndWrite("phReading.current", this.command("phReading all current"));
                ret |= this.parseResponseAndWrite("phReading.voltage", this.command("phReading all voltage"));
                ret |= this.parseResponseAndWrite("phReading.power", this.command("phReading all power"));
                ret |= this.parseResponseAndWrite("phReading.appower", this.command("phReading all appower"));
                ret |= this.parseResponseAndWrite("phReading.pf", this.command("phReading all pf"));
            }
            return ret;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean parseResponseAndWrite(String datapoint, Vector<String> response) {
        boolean ret = false;
        try {
            int i2 = 0;
            while (i2 < response.size()) {
                String[] sa = response.elementAt(i2).split("[:]");
                switch (sa.length) {
                    case 1: {
                        this.ioWriteConditionalEvents(datapoint.toLowerCase(), sa[0].split(" ")[0]);
                        ret = true;
                        break;
                    }
                    case 2: {
                        this.ioWriteConditionalEvents(String.valueOf(datapoint.toLowerCase()) + "." + sa[0].trim(), sa[1].trim().split(" ")[0]);
                        ret = true;
                    }
                }
                ++i2;
            }
            return ret;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void ioWriteConditionalEvents(String name, String value) {
        if (this.initialized || this.startupevents) {
            this.ioWrite(name, value);
        } else {
            this.ioWriteNoEvents(name, value);
        }
    }
}

