/*
 * Decompiled with CFR 0.152.
 */
package drivers.nmea;

import com.hsyco.driverBase;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 0;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private InetSocketAddress address = null;
    private Socket sock = null;
    private BufferedReader in = null;
    private boolean online = false;

    public boolean init(String name, HashMap<String, String> config) {
        block3: {
            super.init(name);
            try {
                this.address = new InetSocketAddress(config.get("host"), Integer.parseInt(config.get("port")));
                if (!this.connect()) break block3;
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        this.online = false;
        this.ioWrite("connection", "offline");
        return false;
    }

    public boolean loop() {
        String s;
        block8: {
            try {
                if (!this.connectionCheck()) {
                    this.connect();
                }
                if ((s = this.headersAndCRCStripper(this.in.readLine())) != null) break block8;
                return false;
            }
            catch (Exception e2) {
                this.disconnect();
                return false;
            }
        }
        if (s.charAt(0) == '$' && s.charAt(6) == ',') {
            this.ioWrite(s.substring(1, 6).toLowerCase(), s);
        } else if (s.charAt(0) == '!' && s.charAt(6) == ',') {
            this.ioWrite(s.substring(0, 6).toLowerCase(), s);
        }
        if (!this.online) {
            this.online = true;
            this.ioWrite("connection", "online");
        }
        return true;
    }

    public boolean end() {
        this.disconnect();
        return true;
    }

    private boolean connect() {
        try {
            this.sock = new Socket();
            this.sock.connect(this.address, 6000);
            this.sock.setSoTimeout(6000);
            this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean disconnect() {
        this.online = false;
        this.ioWrite("connection", "offline");
        if (this.connectionCheck()) {
            try {
                this.in.close();
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean connectionCheck() {
        return this.sock != null && !this.sock.isClosed();
    }

    private String headersAndCRCStripper(String sentence) {
        int checksum;
        block11: {
            checksum = 0;
            char startdelimiter = sentence.charAt(0);
            if (startdelimiter == '$' || startdelimiter == '!') break block11;
            int i1 = sentence.indexOf(36);
            int i2 = sentence.indexOf(33);
            if (i1 > 0 && i2 == -1) {
                sentence = sentence.substring(i1);
                break block11;
            }
            if (i1 == -1 && i2 > 0) {
                sentence = sentence.substring(i2);
                break block11;
            }
            if (i1 < i2) {
                sentence = sentence.substring(i1);
                break block11;
            }
            if (i1 > i2) {
                sentence = sentence.substring(i2);
                break block11;
            }
            return null;
        }
        try {
            if (sentence.charAt(sentence.length() - 3) == '*') {
                int i2 = 1;
                while (i2 < sentence.length() - 3) {
                    checksum ^= sentence.charAt(i2);
                    ++i2;
                }
                String hex = Integer.toHexString(checksum);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                if (hex.equalsIgnoreCase(sentence.substring(sentence.length() - 2))) {
                    return sentence.substring(0, sentence.length() - 3);
                }
                return null;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

