/*
 * Decompiled with CFR 0.152.
 */
package drivers.niko;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.niko.NikoAction;
import java.net.InetAddress;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase
implements MqttCallback {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String name = null;
    private boolean firstloop = true;
    public static Driver INSTANCE;
    private String host;
    private boolean startupevents;
    private boolean online = false;
    private boolean resubscribe = false;
    private MqttClient client;
    private String username;
    private String password;
    private boolean cleanSession;
    private int connectTimeout = 30;
    private int keepAlive = 60;
    private int messageQos = 0;
    private boolean messageRetain;
    private HashMap<String, NikoAction> nikoActions = new HashMap();
    private HashMap<String, Integer> actionNames = new HashMap();
    private HashMap<String, Integer> dimmerStates = new HashMap();
    MqttDefaultFilePersistence mdfp;
    private String[] topicsList = new String[]{"hobby/control/devices/rsp", "hobby/control/devices/evt", "hobby/control/devices/err"};
    public static final String[] WEBOBJECTS;

    static {
        WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage"};
    }

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            INSTANCE = this;
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                int port = Integer.parseInt(config.get("port"));
                this.host = String.valueOf(inet.getHostName()) + ":" + port;
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            this.username = config.get("user");
            this.password = config.get("password");
            this.cleanSession = Boolean.parseBoolean(config.get("cleansession"));
            String temp = config.get("connecttimeout");
            if (temp != null && Integer.parseInt(temp) >= 0) {
                this.connectTimeout = Integer.parseInt(temp);
            }
            if ((temp = config.get("keepalive")) != null && Integer.parseInt(temp) >= 0) {
                this.keepAlive = Integer.parseInt(temp);
            }
            this.mdfp = new MqttDefaultFilePersistence("qos2store/" + name + "-tcp" + this.host.replace(":", ""));
            this.client = new MqttClient("ssl://" + this.host, name, this.mdfp);
            MqttConnectOptions options = new MqttConnectOptions();
            if (this.username != null && this.password != null) {
                options.setUserName(this.username);
                options.setPassword(this.password.toCharArray());
            }
            options.setCleanSession(this.cleanSession);
            options.setAutomaticReconnect(true);
            options.setConnectionTimeout(this.connectTimeout);
            options.setKeepAliveInterval(this.keepAlive);
            this.verifyCertificateChain(options);
            this.client.setCallback(this);
            this.client.connect(options);
            this.makeSubscriptions();
            this.enableSystemtopoDiscovery();
            this.ioSet("publish.hobby/control/devices/cmd.devices.list", "{\"Method\":\"devices.list\"}");
            temp = config.get("messageqos");
            if (temp != null) {
                this.messageQos = Integer.parseInt(temp);
            }
            String[] splitPort = this.host.split(":");
            this.messageLog("NIKO - driver started with ip: " + splitPort[0] + " | port: " + splitPort[1] + " | " + "startupevents: " + this.startupevents + " | cleansession: " + this.cleanSession + " | connecttimeout: " + this.connectTimeout + " | keepalive: " + this.keepAlive + " | messageretain: " + this.messageRetain + " | messageqos: " + this.messageQos);
            return true;
        }
        catch (MqttException e3) {
            this.errorLog("Initialization failed - " + e3.getCause());
            this.end();
        }
        catch (Exception e4) {
            this.errorLog("Initialization failed - " + e4.getLocalizedMessage());
            this.end();
        }
        return false;
    }

    public boolean loop() {
        if (!this.client.isConnected()) {
            this.resubscribe = true;
            return false;
        }
        if (this.resubscribe) {
            this.makeSubscriptions();
            this.resubscribe = false;
        }
        if (!this.online) {
            this.online = true;
            this.ioWrite("connection", "online");
        }
        this.sleep(1000L);
        return true;
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        try {
            if (name.startsWith("publish.")) {
                String command = name.substring(8);
                String topic = command.split("\\.")[0];
                JSONObject json = null;
                if (command.equals("hobby/control/devices/cmd.devices.control")) {
                    json = this.sendCommand(value);
                } else if (command.equals("hobby/control/devices/cmd.devices.list")) {
                    json = new JSONObject(value);
                }
                MqttMessage message = new MqttMessage(json.toString().getBytes());
                message.setRetained(this.messageRetain);
                message.setQos(this.messageQos);
                this.client.publish(topic, message);
                this.ioWriteForced("publish", message.toString());
            } else if (name.startsWith("action.")) {
                this.controlDevicesFromUI(name.substring(7), value);
            }
        }
        catch (Exception e2) {
            this.errorLog("Command failed - " + e2.getLocalizedMessage());
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    public void connectionLost(Throwable arg0) {
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken arg0) {
    }

    @Override
    public void messageArrived(String arg0, MqttMessage arg1) throws Exception {
        if (arg0.equals("hobby/control/devices/rsp")) {
            this.ioWriteForced("devices.list", arg1.toString());
            this.getAllActions(arg1);
        } else if (arg0.equals("hobby/control/devices/evt")) {
            this.getStatus(arg1);
        } else if (arg0.equals("hobby/control/devices/err")) {
            this.getErrors(arg1);
        }
    }

    private void makeSubscriptions() {
        try {
            String[] stringArray = this.topicsList;
            int n2 = this.topicsList.length;
            int n3 = 0;
            while (n3 < n2) {
                String topic = stringArray[n3];
                this.client.subscribe(topic, this.messageQos);
                ++n3;
            }
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    private void verifyCertificateChain(MqttConnectOptions options) throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trustCerts = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1, Socket arg2) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1, Socket arg2) throws CertificateException {
                try {
                    int i2 = 0;
                    while (i2 < arg0.length - 1) {
                        X509Certificate cert = arg0[i2];
                        X509Certificate issuer = arg0[i2 + 1];
                        if (!cert.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) {
                            throw new CertificateException("exception while validating certificates - certificates do not chain");
                        }
                        arg0[i2].verify(arg0[i2 + 1].getPublicKey());
                        ++i2;
                    }
                    X509Certificate last = arg0[arg0.length - 1];
                    if (last.getIssuerX500Principal().equals(last.getSubjectX500Principal())) {
                        last.verify(last.getPublicKey());
                    }
                }
                catch (InvalidKeyException e2) {
                    throw new CertificateException("exception while validating certificates - " + e2.getLocalizedMessage());
                }
                catch (NoSuchAlgorithmException e3) {
                    throw new CertificateException("exception while validating certificates - " + e3.getLocalizedMessage());
                }
                catch (NoSuchProviderException e4) {
                    throw new CertificateException("exception while validating certificates - " + e4.getLocalizedMessage());
                }
                catch (SignatureException e5) {
                    throw new CertificateException("exception while validating certificates - " + e5.getLocalizedMessage());
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1, SSLEngine arg2) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustCerts, new SecureRandom());
        options.setSocketFactory(sc.getSocketFactory());
    }

    private void getAllActions(MqttMessage msg) {
        try {
            JSONObject json = new JSONObject(msg.toString());
            JSONArray jsonarray = json.getJSONArray("Params");
            json = jsonarray.getJSONObject(0);
            jsonarray = json.getJSONArray("Devices");
            int i2 = 0;
            while (i2 < jsonarray.length()) {
                json = jsonarray.getJSONObject(i2);
                String type = json.getString("Type");
                String model = json.getString("Model");
                if (type.equals("action") && (model.equals("light") || model.equals("dimmer"))) {
                    String uuid = json.getString("Uuid");
                    String newname = this.transformName(json.getString("Name"));
                    this.nikoActions.put(uuid, new NikoAction(json, newname));
                    this.controlDeviceFromNiko(json.getString("Model"), newname, json.getJSONArray("Properties"));
                    this.ioWrite("action." + newname + ".uuid", uuid);
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getStatus(MqttMessage msg) {
        try {
            JSONObject json = new JSONObject(msg.toString());
            JSONArray devices = json.getJSONArray("Params");
            json = devices.getJSONObject(0);
            devices = json.getJSONArray("Devices");
            int i2 = 0;
            while (i2 < devices.length()) {
                json = devices.getJSONObject(i2);
                String uuid = json.getString("Uuid");
                if (this.nikoActions.containsKey(uuid)) {
                    String name = this.nikoActions.get(uuid).getName();
                    String model = this.nikoActions.get(uuid).getModel();
                    JSONArray properties = json.getJSONArray("Properties");
                    this.controlDeviceFromNiko(model, name, properties);
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getErrors(MqttMessage msg) {
        try {
            JSONObject json = new JSONObject(msg.toString());
            String errMsg = json.getString("ErrMessage");
            String errCode = json.getString("ErrCode");
            this.ioWriteForced("error.message", errMsg);
            this.ioWriteForced("error.code", errCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONObject sendCommand(String msg) throws Exception {
        JSONObject json = null;
        try {
            json = new JSONObject();
            json.put("Method", "devices.control");
            JSONArray params = new JSONArray();
            JSONObject innerjson = new JSONObject(msg);
            JSONArray devices = innerjson.getJSONArray("Devices");
            int i2 = 0;
            while (i2 < devices.length()) {
                JSONObject temp = devices.getJSONObject(i2);
                String uuid = temp.getString("Uuid");
                if (!this.nikoActions.containsKey(uuid)) {
                    throw new Exception("uuid " + uuid + " - doesn't exist");
                }
                ++i2;
            }
            params.put(innerjson);
            json.put("Params", params);
            return json;
        }
        catch (Exception e2) {
            throw new Exception(e2.getLocalizedMessage());
        }
    }

    private String transformName(String old) {
        String newName;
        String temp = old.trim().toLowerCase().replace(' ', '_');
        if (this.actionNames.containsKey(temp)) {
            int occurrences = this.actionNames.get(temp);
            newName = String.valueOf(temp) + "_" + ++occurrences;
            this.actionNames.put(temp, occurrences);
        } else {
            newName = temp;
            this.actionNames.put(newName, 1);
        }
        return newName;
    }

    public void controlDevicesFromUI(String name, String value) {
        for (String uuid : this.nikoActions.keySet()) {
            NikoAction action = this.nikoActions.get(uuid);
            String actionName = action.getName();
            String model = action.getModel();
            if (!name.equals(actionName) || !model.equals("light") && !model.equals("dimmer")) continue;
            int deviceType = model.equals("light") ? 1 : 11;
            try {
                JSONObject json = new JSONObject();
                JSONArray devices = new JSONArray();
                JSONObject device = new JSONObject();
                device.put("Uuid", uuid);
                JSONArray properties = new JSONArray();
                JSONObject property = new JSONObject();
                if (value.equals("on")) {
                    Integer level = this.dimmerStates.get(name);
                    if (level == null || level == 0) {
                        this.deviceSet(deviceType, "action." + name, "100%", null);
                        property.put("Brightness", "100");
                        this.ioWriteForced("action." + name, "100%");
                    } else {
                        this.deviceSet(deviceType, "action." + name, level + "%", null);
                        property.put("Brightness", String.valueOf(level));
                        this.ioWriteForced("action." + name, level + "%");
                    }
                    properties.put(property);
                    property = new JSONObject();
                    property.put("Status", "On");
                    properties.put(property);
                } else if (value.equals("off")) {
                    this.deviceSet(deviceType, "action." + name, "off", null);
                    this.ioWriteForced("action." + name, "0");
                    property.put("Status", "Off");
                    properties.put(property);
                } else if (deviceType == 1) {
                    this.deviceSet(deviceType, "action." + name, value, null);
                    this.ioWriteForced("action." + name, value);
                    property.put("Status", value.equals("1") ? "On" : "Off");
                    properties.put(property);
                } else {
                    this.deviceSet(deviceType, "action." + name, String.valueOf(value) + "%", null);
                    this.dimmerStates.put(name, Integer.parseInt(value));
                    this.ioWrite("action." + name, String.valueOf(value) + (value.equals("0") ? "" : "%"));
                    property.put("Brightness", value);
                    properties.put(property);
                    property = new JSONObject();
                    property.put("Status", value.equals("0") ? "Off" : "On");
                    properties.put(property);
                }
                device.put("Properties", properties);
                devices.put(device);
                json.put("Devices", devices);
                this.ioSet("publish.hobby/control/devices/cmd.devices.control", json.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void controlDeviceFromNiko(String model, String name, JSONArray properties) {
        block11: {
            try {
                if (model.equals("light")) {
                    JSONObject property = properties.getJSONObject(0);
                    String status = property.getString("Status").equals("On") ? "1" : "0";
                    this.deviceSet(1, "action." + name, status, null);
                    this.ioWriteForced("action." + name, status);
                    break block11;
                }
                if (!model.equals("dimmer")) break block11;
                String brightness = null;
                String status = "Off";
                int i2 = 0;
                while (i2 < properties.length()) {
                    JSONObject property = properties.getJSONObject(i2);
                    try {
                        brightness = property.getString("Brightness");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        status = property.getString("Status");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i2;
                }
                if (brightness != null) {
                    this.dimmerStates.put(name, Integer.parseInt(brightness));
                }
                if (status.equals("On")) {
                    this.deviceSet(11, "action." + name, String.valueOf(brightness) + "%", null);
                    this.ioWriteForced("action." + name, String.valueOf(brightness) + "%");
                } else {
                    this.deviceSet(11, "action." + name, "0%", null);
                    this.ioWriteForced("action." + name, "0");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

