/*
 * Decompiled with CFR 0.152.
 */
package drivers.netio;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.net.InetAddress;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public boolean startupevents;
    public boolean firstloop = true;
    public String name;
    public String host;
    public String username;
    public String password;
    public int pollinterval = 1000;
    private Thread currentThread;
    public static final String[] WEBOBJECTS = new String[]{"button", "buttonicon", "buttonimage"};

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                this.host = inet.getHostName();
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.username = config.get("user");
            if (this.username == null) {
                this.messageLog(String.valueOf(name) + ": username ignored");
            }
            this.password = config.get("password");
            if (this.password == null) {
                this.messageLog(String.valueOf(name) + ": password ignored");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            try {
                int timer;
                String s = config.get("pollinterval");
                if (s != null && s.trim().length() > 0 && (timer = Integer.parseInt(s)) >= 100 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e3) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            this.enableSystemtopoDiscovery();
            String resp = Driver.urlGet("http://" + this.host + "/netio.json", this.username, this.password);
            if (resp == null || !resp.startsWith("200")) {
                return false;
            }
            this.readMessage(resp.substring(4));
        }
        catch (Exception e4) {
            this.errorLog("Initialization failed - " + e4.getLocalizedMessage() + " - " + name);
            this.end();
            return false;
        }
        this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval);
        return true;
    }

    public boolean loop() {
        this.currentThread = Thread.currentThread();
        try {
            String resp = Driver.urlGet("http://" + this.host + "/netio.json", this.username, this.password);
            if (resp == null) {
                throw new Exception("error in HTTP GET request");
            }
            if (resp.startsWith("400")) {
                throw new Exception("bad request - control command syntax error");
            }
            if (resp.startsWith("401")) {
                throw new Exception("unauthorized - invalid username or password");
            }
            if (resp.startsWith("403")) {
                throw new Exception("forbidden - read only");
            }
            if (resp.startsWith("500")) {
                throw new Exception("internal server error");
            }
            this.readMessage(resp.substring(4));
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e2) {
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e2.getMessage());
            }
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        try {
            int output = Integer.parseInt(name.substring(1));
            JSONObject json = new JSONObject();
            JSONArray jsonarray = new JSONArray();
            JSONObject jsonelement = new JSONObject();
            jsonelement.put("ID", output);
            int val = 0;
            if (value.contains("&")) {
                String[] fields = value.split("&");
                if ((value = fields[0]).equals("off")) {
                    val = 2;
                } else if (value.equals("on")) {
                    val = 3;
                }
                if (fields.length > 1) {
                    int delay = Integer.parseInt(fields[1]);
                    jsonelement.put("Delay", delay);
                }
            } else if (value.equals("on") || value.equals("1")) {
                val = 1;
            } else if (value.equals("off") || value.equals("0")) {
                val = 0;
            } else if (value.equals("flip")) {
                val = 4;
            } else {
                throw new Exception("invalid command");
            }
            jsonelement.put("Action", val);
            jsonarray.put(jsonelement);
            json.put("Outputs", jsonarray);
            String resp = Driver.urlPost("http://" + this.host + "/netio.json", "application/json", json.toString(), this.username, this.password);
            if (resp == null) {
                this.errorLog(String.valueOf(this.name) + " - error in HTTP POST request");
            } else if (!resp.startsWith("200")) {
                this.errorLog(String.valueOf(this.name) + " - " + resp.substring(4));
            } else {
                try {
                    this.currentThread.interrupt();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - command error - " + name + ", " + value + " - " + e2.getMessage());
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    private void readMessage(String rawMsg) throws Exception {
        try {
            JSONObject measure;
            JSONObject json = new JSONObject(rawMsg);
            JSONObject agent = json.getJSONObject("Agent");
            if (agent.has("DeviceName")) {
                String deviceName = agent.getString("DeviceName");
                this.ioWrite("name", deviceName);
            }
            if (agent.has("Model")) {
                String model = agent.getString("Model");
                this.ioWrite("model", model);
            }
            if (agent.has("NumOutputs")) {
                int numOutputs = agent.getInt("NumOutputs");
                this.ioWrite("numoutputs", "" + numOutputs);
            }
            if (agent.has("NumInputs")) {
                int numInputs = agent.getInt("NumInputs");
                this.ioWrite("numinputs", "" + numInputs);
            }
            if (agent.has("Version")) {
                String firmVersion = agent.getString("Version");
                this.ioWrite("fwversion", firmVersion);
            }
            if (agent.has("JSONVer")) {
                String protVersion = agent.getString("JSONVer");
                this.ioWrite("jsonversion", protVersion);
            }
            if (agent.has("MAC")) {
                String mac = agent.getString("MAC");
                this.ioWrite("macaddress", mac);
            }
            if (agent.has("SerialNumber")) {
                String serial = agent.getString("SerialNumber");
                this.ioWrite("serialnum", serial);
            }
            if (agent.has("Uptime")) {
                int uptime = agent.getInt("Uptime");
                this.ioWrite("uptime", "" + uptime / 60);
            }
            if ((measure = json.getJSONObject("GlobalMeasure")).has("Voltage")) {
                double voltage = measure.getDouble("Voltage");
                this.ioWrite("voltage", "" + voltage);
            }
            if (measure.has("Frequency")) {
                double frequency = measure.getDouble("Frequency");
                this.ioWrite("frequency", "" + frequency);
            }
            if (measure.has("TotalCurrent")) {
                int totalCurrent = measure.getInt("TotalCurrent");
                this.ioWrite("totcurrent", "" + totalCurrent);
            }
            if (measure.has("TotalEnergy")) {
                double totalEnergy = measure.getInt("TotalEnergy");
                this.ioWrite("totenergy", "" + totalEnergy);
            }
            if (measure.has("OverallPowerFactor")) {
                double opf = measure.getDouble("OverallPowerFactor");
                this.ioWrite("opf", "" + opf);
            }
            if (measure.has("Phase")) {
                double phase = measure.getDouble("Phase");
                this.ioWrite("phase", "" + phase);
            }
            if (measure.has("TotalLoad")) {
                int load = measure.getInt("TotalLoad");
                this.ioWrite("totload", "" + load);
            }
            if (measure.has("EnergyStart")) {
                String energyStart = measure.getString("EnergyStart");
                this.ioWrite("energystart", energyStart);
            }
            JSONArray outputs = json.getJSONArray("Outputs");
            int i2 = 0;
            while (i2 < outputs.length()) {
                JSONObject output = outputs.getJSONObject(i2);
                int outputNum = output.getInt("ID");
                if (output.has("Name")) {
                    String outputName = output.getString("Name");
                    this.ioWrite("o" + outputNum + ".name", outputName);
                }
                if (output.has("State")) {
                    int state = output.getInt("State");
                    this.deviceSet(1, "o" + outputNum, String.valueOf(state), "ON/OFF");
                    this.ioWrite("o" + outputNum, "" + state);
                }
                if (output.has("Delay")) {
                    int delay = output.getInt("Delay");
                    this.ioWrite("o" + outputNum + ".delay", "" + delay);
                }
                if (output.has("Current")) {
                    int current = output.getInt("Current");
                    this.ioWrite("o" + outputNum + ".current", "" + current);
                }
                if (output.has("Energy")) {
                    int energy = output.getInt("Energy");
                    this.ioWrite("o" + outputNum + ".energy", "" + energy);
                }
                if (output.has("PowerFactor")) {
                    double powerFactor = output.getDouble("PowerFactor");
                    this.ioWrite("o" + outputNum + ".pf", "" + powerFactor);
                }
                if (output.has("Phase")) {
                    double phase = output.getDouble("Phase");
                    this.ioWrite("o" + outputNum + ".phase", "" + phase);
                }
                if (output.has("Load")) {
                    int load = output.getInt("Load");
                    this.ioWrite("o" + outputNum + ".load", "" + load);
                }
                if (output.has("ReverseEnergy")) {
                    int reverseEnergy = output.getInt("ReverseEnergy");
                    this.ioWrite("o" + outputNum + ".rvenergy", "" + reverseEnergy);
                }
                ++i2;
            }
            if (json.has("Inputs")) {
                JSONArray inputs = json.getJSONArray("Inputs");
                int i3 = 0;
                while (i3 < inputs.length()) {
                    JSONObject input = inputs.getJSONObject(i3);
                    int inputNum = input.getInt("ID");
                    if (input.has("Name")) {
                        String name = input.getString("Name");
                        this.ioWrite("i" + inputNum + ".name", name);
                    }
                    if (input.has("State")) {
                        int stateIn = input.getInt("State");
                        this.ioWrite("i" + inputNum, "" + stateIn);
                    }
                    if (input.has("S0Counter")) {
                        int s0counter = input.getInt("S0Counter");
                        this.ioWrite("i" + inputNum + ".s0counter", "" + s0counter);
                    }
                    ++i3;
                }
            }
        }
        catch (Exception e2) {
            throw new Exception("JSON response format error");
        }
    }
}

