/*
 * Decompiled with CFR 0.152.
 */
package drivers.mews;

import drivers.mews.Customer;
import drivers.mews.Driver;
import drivers.mews.Room;
import drivers.mews.Utils;
import drivers.mews.apiCalls;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class genDatapoints {
    protected static void genHotelBasicInfoDataPoints(JSONObject obj, Driver driver) {
        JSONObject ent = obj.getJSONObject("Enterprise");
        JSONObject add = ent.getJSONObject("Address");
        String Name4 = ent.getString("Name");
        String LegalEnvironmentCode = ent.getString("LegalEnvironmentCode");
        String City = "null";
        String PostalCode = add.getString("PostalCode");
        String CountryCode = add.getString("CountryCode");
        try {
            City = add.getString("City");
        }
        catch (Exception exception) {
            // empty catch block
        }
        driver.ioWrite("info.name", Name4);
        driver.ioWrite("info.legalenvironmentcode", LegalEnvironmentCode);
        driver.ioWrite("info.location.city", City);
        driver.ioWrite("info.location.postalcode", PostalCode);
        driver.ioWrite("info.location.countrycode", CountryCode);
    }

    protected static void genHotelServicesDataPoints(JSONObject obj, Driver driver) {
        JSONArray services = obj.getJSONArray("Services");
        driver.bookableServices.clear();
        for (Object service : services) {
            JSONObject serviceJsonObj = (JSONObject)service;
            String Id = serviceJsonObj.getString("Id");
            String Name4 = serviceJsonObj.getString("Name");
            String IsActive = String.valueOf(serviceJsonObj.getBoolean("IsActive"));
            JSONObject Data2 = serviceJsonObj.getJSONObject("Data");
            String Discriminator = Data2.getString("Discriminator");
            if (Discriminator.equals("Bookable") && IsActive.equals("true")) {
                driver.bookableServices.add(Id);
            }
            driver.serviceIoToName.put(Id, Name4);
            driver.ioWrite("service." + Id + ".id", Id);
            driver.ioWrite("service." + Id + ".name", Name4);
            driver.ioWrite("service." + Id + ".isactive", IsActive);
        }
    }

    protected static void genHotelDepartmentsDataPoints(JSONObject obj, Driver driver) {
        JSONArray services = obj.getJSONArray("Departments");
        driver.bookableServices.clear();
        for (Object service : services) {
            JSONObject serviceJsonObj = (JSONObject)service;
            String Id = serviceJsonObj.getString("Id");
            String Name4 = serviceJsonObj.getString("Name");
            String IsActive = String.valueOf(serviceJsonObj.getBoolean("IsActive"));
            driver.ioWrite("department." + Id + ".id", Id);
            driver.ioWrite("department." + Id + ".name", Name4);
            driver.ioWrite("department." + Id + ".isactive", IsActive);
        }
    }

    protected static void genHotelResourcesDataPoints(JSONObject obj, Driver driver) {
        String roomId;
        String name = "";
        String state = "";
        Boolean isActive = null;
        String ParentResourceId = "";
        JSONArray res = obj.getJSONArray("Resources");
        for (Object resObj : res) {
            JSONObject resJsonObj = (JSONObject)resObj;
            String id = resJsonObj.getString("Id");
            name = resJsonObj.getString("Name");
            state = resJsonObj.getString("State");
            isActive = resJsonObj.getBoolean("IsActive");
            if (driver.rooms.containsKey(id)) continue;
            Room room = new Room(id, name, state, isActive);
            driver.rooms.put(id, room);
            driver.roomsIdToName.put(id, name);
            String roomId2 = id;
            if (!driver.idsAsDataPoints.booleanValue()) {
                roomId2 = name.replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
            }
            if (!driver.idsAsDataPoints.booleanValue()) {
                driver.ioWrite("resource." + roomId2 + ".id", id);
            } else {
                driver.ioWrite("resource." + roomId2 + ".name", name);
            }
            driver.ioWrite("resource." + roomId2 + ".state", state);
            driver.ioWrite("resource." + roomId2 + ".isactive", String.valueOf(isActive));
            driver.ioWrite("resource." + roomId2 + ".checkedin", "false");
            driver.ioWrite("resource." + roomId2 + ".checkedinby", "");
            driver.ioWrite("resource." + roomId2 + ".checkedinbyid", "");
            try {
                ParentResourceId = resJsonObj.getString("ParentResourceId");
                room.setParent(ParentResourceId);
                List<Object> parents = new ArrayList<String>();
                if (driver.roomsChildrens.containsKey(ParentResourceId)) {
                    parents = driver.roomsChildrens.get(ParentResourceId);
                    parents.add(roomId2);
                    driver.roomsChildrens.replace(ParentResourceId, parents);
                    continue;
                }
                parents.add(roomId2);
                driver.roomsChildrens.put(ParentResourceId, parents);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Room room : driver.rooms.values()) {
            if (room.getName() != name || room.getState() != state || room.getIsActive() != isActive) {
                roomId = room.getId();
                if (!driver.idsAsDataPoints.booleanValue()) {
                    roomId = room.getName().replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
                    driver.ioWrite("resource." + roomId + ".id", room.getId());
                } else {
                    driver.ioWrite("resource." + roomId + ".name", room.getName());
                }
                driver.ioWrite("resource." + roomId + ".state", room.getState());
                driver.ioWrite("resource." + roomId + ".isactive", String.valueOf(room.getIsActive()));
            }
            if ((ParentResourceId = room.getParent()) == null) continue;
            roomId = ParentResourceId;
            if (!driver.idsAsDataPoints.booleanValue()) {
                roomId = driver.roomsIdToName.get(ParentResourceId).replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
            }
            driver.ioWrite("resource." + roomId + ".children", driver.roomsChildrens.get(ParentResourceId).toString());
        }
        Iterator<Object> iterator = driver.reservedRooms.iterator();
        while (iterator.hasNext()) {
            String AssignedResourceId;
            roomId = AssignedResourceId = (String)iterator.next();
            if (!driver.idsAsDataPoints.booleanValue()) {
                roomId = driver.roomsIdToName.get(AssignedResourceId).replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
            }
            driver.ioWrite("resource." + roomId + ".checkedin", "true");
            driver.ioWrite("resource." + roomId + ".checkedinby", String.valueOf(driver.customerReservations.get(AssignedResourceId).getName()) + " " + driver.customerReservations.get(AssignedResourceId).getSurname());
            driver.ioWrite("resource." + roomId + ".checkedinbyid", driver.customerReservations.get(AssignedResourceId).getId());
            driver.reservedRoomsToRemove.add(AssignedResourceId);
        }
        int i2 = 0;
        while (i2 < driver.reservedRoomsToRemove.size()) {
            String AssignedResourceId;
            roomId = AssignedResourceId = driver.reservedRoomsToRemove.get(i2);
            if (!driver.idsAsDataPoints.booleanValue()) {
                roomId = driver.roomsIdToName.get(AssignedResourceId).replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
            }
            if (!driver.reservedRooms.contains(AssignedResourceId)) {
                driver.ioWrite("resource." + roomId + ".checkedin", "false");
                driver.ioWrite("resource." + roomId + ".checkedinby", "");
                driver.ioWrite("resource." + roomId + ".checkedinbyid", "");
                driver.reservedRoomsToRemove.remove(driver.reservedRoomsToRemove.indexOf(AssignedResourceId));
            }
            ++i2;
        }
        driver.customers.clear();
        driver.customerReservations.clear();
    }

    protected static void genHotelCustomersDataPoints(JSONObject obj, Driver driver) {
        driver.reservedRooms.clear();
        JSONArray custom = obj.getJSONArray("Customers");
        for (Object customObj : custom) {
            JSONObject customJsonObj = (JSONObject)customObj;
            String id = customJsonObj.getString("Id");
            String name = "";
            String lastname = "";
            String sex = "null";
            JSONObject reservation = null;
            try {
                name = customJsonObj.getString("FirstName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                lastname = customJsonObj.getString("LastName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sex = customJsonObj.getString("Sex");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                reservation = customJsonObj.getJSONObject("Reservation");
            }
            catch (Exception exception) {
                // empty catch block
            }
            driver.ioWrite("customer." + id + ".name", name);
            driver.ioWrite("customer." + id + ".lastname", lastname);
            Customer customer = new Customer(id, name, lastname, sex);
            if (reservation != null) {
                JSONObject reservationObj = reservation;
                String AssignedResourceId = reservationObj.getString("AssignedResourceId");
                driver.reservedRooms.add(AssignedResourceId);
                driver.customerReservations.put(AssignedResourceId, customer);
            }
            if (!driver.customers.keySet().contains(id)) {
                driver.customers.put(id, customer);
                Utils.addReservation(driver, id, reservation);
                continue;
            }
            Utils.addReservation(driver, id, reservation);
        }
        for (Customer customer : driver.customerReservations.values()) {
            if (customer.getReservations() == null) continue;
            JSONArray resArray = new JSONArray();
            int i2 = 0;
            while (i2 < customer.getReservations().size()) {
                JSONObject resObj = new JSONObject();
                JSONObject reservationObj = customer.getReservations().get(i2);
                String Id = reservationObj.getString("Id");
                String State2 = reservationObj.getString("State");
                String Purpose = "";
                String StartUtc = "";
                String EndUtc = "";
                String AssignedResourceId = reservationObj.getString("AssignedResourceId");
                String ServiceId = reservationObj.getString("ServiceId");
                String AdultCount = "";
                String ChildCount = "";
                JSONObject Options = reservationObj.getJSONObject("Options");
                Boolean OwnerCheckedIn = Options.getBoolean("OwnerCheckedIn");
                Boolean AllCompanionsCheckedIn = Options.getBoolean("AllCompanionsCheckedIn");
                Boolean AnyCompanionCheckedIn = Options.getBoolean("AnyCompanionCheckedIn");
                try {
                    Purpose = reservationObj.getString("Purpose");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    StartUtc = reservationObj.getString("StartUtc");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    EndUtc = reservationObj.getString("EndUtc");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    AdultCount = reservationObj.getString("AdultCount");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ChildCount = reservationObj.getString("ChildCount");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                resObj.put("id", Id);
                resObj.put("state", State2);
                resObj.put("purpose", Purpose);
                resObj.put("startutc", StartUtc);
                resObj.put("endutc", EndUtc);
                resObj.put("assignedresourceid", AssignedResourceId);
                resObj.put("adultcount", AdultCount);
                resObj.put("childcount", ChildCount);
                resObj.put("servicename", driver.serviceIoToName.get(ServiceId));
                JSONObject resOptObj = new JSONObject();
                resOptObj.put("ownercheckedin", OwnerCheckedIn);
                resOptObj.put("allcompanionscheckedin", AllCompanionsCheckedIn);
                resOptObj.put("anycompanioncheckedin", AnyCompanionCheckedIn);
                resObj.put("options", resOptObj);
                resArray.put(resObj);
                ++i2;
            }
            driver.ioWrite("customer." + customer.getId() + ".reservation", resArray.toString());
        }
    }

    protected static void genHotelReservationTodayTomorrow(Driver driver) throws KeyManagementException, ClientProtocolException, NoSuchAlgorithmException, KeyStoreException, JSONException, IOException, ParseException {
        String AssignedResourceId;
        JSONObject reservation2;
        JSONObject responseToday = apiCalls.getHotelReservations(driver, true);
        JSONObject responseTomorrow = apiCalls.getHotelReservations(driver, false);
        JSONArray ReservationsToday = responseToday.getJSONArray("Reservations");
        JSONArray ReservationsTomorrow = responseTomorrow.getJSONArray("Reservations");
        ArrayList<String> reservedRoomsToday = new ArrayList<String>();
        ArrayList<String> reservedRoomsTomorrow = new ArrayList<String>();
        for (Object resObj : ReservationsToday) {
            try {
                reservation2 = (JSONObject)resObj;
                AssignedResourceId = reservation2.getString("AssignedResourceId");
                reservedRoomsToday.add(AssignedResourceId);
            }
            catch (Exception reservation2) {
                // empty catch block
            }
        }
        for (Object resObj : ReservationsTomorrow) {
            try {
                reservation2 = (JSONObject)resObj;
                AssignedResourceId = reservation2.getString("AssignedResourceId");
                reservedRoomsTomorrow.add(AssignedResourceId);
            }
            catch (Exception reservation3) {
                // empty catch block
            }
        }
        Iterator<Object> iterator = driver.roomsIdToName.keySet().iterator();
        while (iterator.hasNext()) {
            String roomId;
            String roomName = roomId = (String)iterator.next();
            if (!driver.idsAsDataPoints.booleanValue()) {
                roomName = driver.roomsIdToName.get(roomId).replaceAll("[^a-zA-Z0-9]+", "-").toLowerCase();
            }
            if (reservedRoomsToday.contains(roomId)) {
                driver.ioWrite("resource." + roomName + ".reserved.today", "true");
            } else {
                driver.ioWrite("resource." + roomName + ".reserved.today", "false");
            }
            if (reservedRoomsTomorrow.contains(roomId)) {
                driver.ioWrite("resource." + roomName + ".reserved.tomorrow", "true");
                continue;
            }
            driver.ioWrite("resource." + roomName + ".reserved.tomorrow", "false");
        }
    }
}

