/*
 * Decompiled with CFR 0.152.
 */
package drivers.mews;

import com.hsyco.hsyco;
import drivers.mews.Driver;
import drivers.mews.apiUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.http.client.ClientProtocolException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class apiCalls {
    protected static JSONObject getHotelBasicInfo(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "configuration/get", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static JSONObject getHotelServices(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "services/getAll", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static JSONObject getHotelDepartments(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "departments/getAll", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static JSONObject newHotelTask(Driver driver, String name, String description, String deadline, String departmentId) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        params.put("Name", name);
        params.put("Description", description);
        params.put("DeadlineUtc", deadline);
        params.put("DepartmentId", departmentId);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "tasks/add", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static JSONObject getHotelResurces(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        JSONObject extent = new JSONObject();
        extent.put("Resources", true);
        extent.put("ResourceCategories", false);
        extent.put("ResourceCategoryAssignments", false);
        extent.put("ResourceCategoryImageAssignments", false);
        extent.put("ResourceFeatures", false);
        extent.put("ResourceFeatureAssignments", false);
        extent.put("Inactive", true);
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        params.put("Extent", extent);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "resources/getAll", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static JSONObject getHotelCustomers(Driver driver) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        JSONObject extent = new JSONObject();
        extent.put("Customers", true);
        extent.put("Documents", false);
        extent.put("Addresses", false);
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        params.put("Extent", extent);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "customers/search", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    protected static JSONObject getHotelReservations(Driver driver, Boolean today) throws ClientProtocolException, IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, JSONException, ParseException {
        JSONObject params = new JSONObject();
        JSONObject extent = new JSONObject();
        JSONArray ServiceIds = new JSONArray();
        for (String serviceId : driver.bookableServices) {
            if (serviceId == null && serviceId == "") continue;
            ServiceIds.put(serviceId.trim());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String dateStr = dateFormat.format(date);
        if (!today.booleanValue()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c2 = Calendar.getInstance();
            c2.setTime(sdf.parse(dateStr));
            c2.add(5, 1);
            dateStr = sdf.format(c2.getTime());
        }
        extent.put("Reservations", true);
        extent.put("ReservationGroups", true);
        extent.put("Customers", true);
        params.put("ClientToken", driver.clientToken);
        params.put("AccessToken", driver.accessToken);
        params.put("Client", driver.mewsClientId);
        params.put("StartUtc", String.valueOf(dateStr) + "T00:00:00Z");
        params.put("EndUtc", String.valueOf(dateStr) + "T23:59:00Z");
        params.put("ServiceIds", ServiceIds);
        params.put("Extent", extent);
        JSONObject obj = apiUtils.buildAPICallPOST(params, String.valueOf(driver.MEWSAPIURL) + "reservations/getAll", driver);
        try {
            if (obj.getString("Message") != null) {
                hsyco.errorLog(String.valueOf(driver.DriverName) + " - API ERROR : " + obj.getString("Message"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }
}

