/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.MType;
import drivers.lorawan.model.MacPayload;
import drivers.lorawan.model.MajorVersion;
import drivers.lorawan.model.MalformedPacketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PhyPayload {
    private byte mhdr;
    private MacPayload macPayload;
    private byte[] mic = new byte[4];

    public PhyPayload(ByteBuffer _raw) throws MalformedPacketException {
        _raw.order(ByteOrder.LITTLE_ENDIAN);
        if (_raw.remaining() < 12) {
            throw new MalformedPacketException();
        }
        this.mhdr = _raw.get();
        this.macPayload = new MacPayload(this, _raw);
        _raw.get(this.mic);
    }

    public PhyPayload() {
    }

    public MType getMType() throws MalformedPacketException {
        return MType.from(this.mhdr);
    }

    public MajorVersion getMajorVersion() throws MalformedPacketException {
        return MajorVersion.from(this.mhdr);
    }

    public byte getMHDR() {
        return this.mhdr;
    }

    public PhyPayload setMHDR(byte _mhdr) {
        this.mhdr = _mhdr;
        return this;
    }

    public MacPayload getMacPayload() {
        return this.macPayload;
    }

    public PhyPayload setMacPayload(MacPayload _macPayload) {
        this.macPayload = _macPayload;
        return this;
    }

    public int length() throws MalformedPacketException {
        return 1 + this.macPayload.length() + this.mic.length;
    }

    public void toRaw(ByteBuffer _bb) throws MalformedPacketException {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        _bb.put(this.mhdr);
        this.macPayload.toRaw(_bb);
        _bb.put(this.mic);
    }

    public byte[] getMic() {
        return this.mic;
    }

    public PhyPayload setMic(byte[] _mic) {
        this.mic = _mic;
        return this;
    }
}

