/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.FHDR;
import drivers.lorawan.model.FRMPayload;
import drivers.lorawan.model.MalformedPacketException;
import drivers.lorawan.model.PhyPayload;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MacPayload {
    private FHDR fhdr;
    private byte fPort;
    private FRMPayload payload;
    private PhyPayload phy;

    public MacPayload(PhyPayload _phy, ByteBuffer _raw) throws MalformedPacketException {
        this.phy = _phy;
        _raw.order(ByteOrder.LITTLE_ENDIAN);
        if (_raw.remaining() < 1) {
            throw new MalformedPacketException();
        }
        this.fhdr = new FHDR(_raw);
        if (_raw.remaining() > 4) {
            this.fPort = _raw.get();
            Class<? extends FRMPayload> mapper = this.phy.getMType().getMapper();
            try {
                this.payload = mapper.getConstructor(MacPayload.class, ByteBuffer.class).newInstance(this, _raw);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Could not create FRMPayload", ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException("Could not create FRMPayload", ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Could not create FRMPayload", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Could not create FRMPayload", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Could not create FRMPayload", ex);
            }
            catch (InvocationTargetException ex) {
                throw new MalformedPacketException(ex.getCause());
            }
        } else {
            this.fPort = 0;
            this.payload = null;
        }
    }

    public MacPayload(PhyPayload _phy) {
        this.phy = _phy;
        this.phy.setMacPayload(this);
    }

    public int length() throws MalformedPacketException {
        if (this.payload == null) {
            return this.fhdr.length();
        }
        return this.fhdr.length() + 1 + this.payload.length();
    }

    public void toRaw(ByteBuffer _bb) throws MalformedPacketException {
        this.fhdr.toRaw(_bb);
        if (this.payload != null) {
            _bb.put(this.fPort);
            this.payload.toRaw(_bb);
        }
    }

    public FHDR getFhdr() {
        return this.fhdr;
    }

    public MacPayload setFhdr(FHDR _fhdr) {
        this.fhdr = _fhdr;
        return this;
    }

    public byte getfPort() {
        return this.fPort;
    }

    public MacPayload setfPort(byte _fPort) {
        this.fPort = _fPort;
        return this;
    }

    public FRMPayload getPayload() {
        return this.payload;
    }

    public MacPayload setPayload(FRMPayload _payload) {
        this.payload = _payload;
        return this;
    }

    public PhyPayload getPhyPayload() {
        return this.phy;
    }

    public MacPayload setPhyPayload(PhyPayload _phy) {
        this.phy = _phy;
        return this;
    }
}

