/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.AesCmac;
import drivers.lorawan.model.FRMPayload;
import drivers.lorawan.model.MacPayload;
import drivers.lorawan.model.MalformedPacketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class JoinAcceptPayload
implements FRMPayload {
    private MacPayload mac;
    private byte[] payload;
    private JoinAcceptClearPayload clear;
    private byte[] appKey;

    public JoinAcceptPayload(MacPayload _mac, ByteBuffer _raw) throws MalformedPacketException {
        if (_raw.remaining() < 16) {
            throw new MalformedPacketException("length");
        }
        this.mac = _mac;
        _raw.order(ByteOrder.LITTLE_ENDIAN);
        this.payload = new byte[_raw.remaining() - 4];
        _raw.get(this.payload);
    }

    public JoinAcceptPayload(MacPayload _mac) {
        this.mac = _mac;
    }

    @Override
    public int length() {
        return this.payload.length;
    }

    @Override
    public void toRaw(ByteBuffer _bb) {
        _bb.put(this.payload);
    }

    public MacPayload getMac() {
        return this.mac;
    }

    public JoinAcceptPayload setMac(MacPayload _mac) {
        this.mac = _mac;
        this.encryptPayload();
        return this;
    }

    private void decryptPayload() {
        if (this.appKey == null) {
            throw new RuntimeException("undefined appKey");
        }
        ByteBuffer a2 = ByteBuffer.allocate(4 + this.length());
        a2.order(ByteOrder.LITTLE_ENDIAN);
        a2.put(this.payload);
        a2.put(this.mac.getPhyPayload().getMic());
        try {
            SecretKeySpec aesKey = new SecretKeySpec(this.appKey, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, aesKey);
            byte[] s = cipher.doFinal(a2.array());
            this.clear = new JoinAcceptClearPayload(s);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Could not decrypt payload", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new RuntimeException("Could not decrypt payload", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Could not decrypt payload", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new RuntimeException("Could not decrypt payload", ex);
        }
        catch (BadPaddingException ex) {
            throw new RuntimeException("Could not decrypt payload", ex);
        }
    }

    private void encryptPayload() {
        if (this.appKey == null) {
            throw new RuntimeException("undefined appKey");
        }
        ByteBuffer a2 = ByteBuffer.allocate(4 + this.clear.length());
        a2.order(ByteOrder.LITTLE_ENDIAN);
        this.clear.toRaw(a2);
        a2.put(this.clear.computeMic());
        try {
            SecretKeySpec aesKey = new SecretKeySpec(this.appKey, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, aesKey);
            byte[] s = cipher.doFinal(a2.array());
            this.payload = Arrays.copyOf(s, s.length - 4);
            this.mac.getPhyPayload().setMic(Arrays.copyOfRange(s, s.length - 4, s.length));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Could not encrypt payload", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new RuntimeException("Could not encrypt payload", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Could not encrypt payload", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new RuntimeException("Could not encrypt payload", ex);
        }
        catch (BadPaddingException ex) {
            throw new RuntimeException("Could not encrypt payload", ex);
        }
    }

    public JoinAcceptClearPayload getClearPayload() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (this.clear == null) {
            this.decryptPayload();
        }
        return this.clear;
    }

    public JoinAcceptPayload setAppKey(byte[] _appKey) {
        if (this.clear != null && this.payload != null) {
            throw new RuntimeException("Both encrypted and clear payloads exists. AppKey can not be changed");
        }
        this.appKey = _appKey;
        return this;
    }

    public byte[] getAppKey() {
        return this.appKey;
    }

    @Override
    public boolean validateMic(short fCntHighBits) {
        if (this.clear == null) {
            this.decryptPayload();
        }
        return Arrays.equals(this.clear.computeMic(), this.clear.mic);
    }

    public JoinAcceptClearPayload setNewClearPayload() {
        this.clear = new JoinAcceptClearPayload();
        this.encryptPayload();
        return this.clear;
    }

    public class JoinAcceptClearPayload {
        private byte[] appNonce = new byte[3];
        private byte[] netId = new byte[3];
        private byte[] devAddr = new byte[4];
        private byte dlSettings;
        private byte rxDelay;
        private byte[] cfList;
        private byte[] mic;

        public JoinAcceptClearPayload() {
        }

        public JoinAcceptClearPayload(byte[] _raw) {
            ByteBuffer bb = ByteBuffer.wrap(_raw);
            bb.get(this.appNonce);
            bb.get(this.netId);
            bb.get(this.devAddr);
            this.dlSettings = bb.get();
            this.rxDelay = bb.get();
            this.cfList = new byte[bb.remaining() - 4];
            bb.get(this.cfList);
            bb.get(this.mic);
        }

        public byte[] getAppNonce() {
            return this.appNonce;
        }

        public JoinAcceptClearPayload setAppNonce(byte[] _appNonce) {
            this.appNonce = _appNonce;
            JoinAcceptPayload.this.encryptPayload();
            return this;
        }

        public byte[] getNetId() {
            return this.netId;
        }

        public JoinAcceptClearPayload setNetId(byte[] _netId) {
            this.netId = _netId;
            JoinAcceptPayload.this.encryptPayload();
            return this;
        }

        public byte[] getDevAddr() {
            return this.devAddr;
        }

        public JoinAcceptClearPayload setDevAddr(byte[] _devAddr) {
            this.devAddr = _devAddr;
            JoinAcceptPayload.this.encryptPayload();
            return this;
        }

        public byte getDlSettings() {
            return this.dlSettings;
        }

        public JoinAcceptClearPayload setDlSettings(byte _dlSettings) {
            this.dlSettings = _dlSettings;
            JoinAcceptPayload.this.encryptPayload();
            return this;
        }

        public byte getRxDelay() {
            return this.rxDelay;
        }

        public JoinAcceptClearPayload setRxDelay(byte _rxDelay) {
            this.rxDelay = _rxDelay;
            JoinAcceptPayload.this.encryptPayload();
            return this;
        }

        public byte[] getCfList() {
            return this.cfList;
        }

        public JoinAcceptClearPayload setCfList(byte[] _cfList) throws MalformedPacketException {
            if (_cfList.length != 0 && _cfList.length != 16) {
                throw new MalformedPacketException("cfList size");
            }
            this.cfList = _cfList;
            JoinAcceptPayload.this.encryptPayload();
            return this;
        }

        public void toRaw(ByteBuffer _bb) {
            _bb.put(this.appNonce);
            _bb.put(this.netId);
            _bb.put(this.devAddr);
            _bb.put(this.dlSettings);
            _bb.put(this.rxDelay);
            _bb.put(this.cfList);
        }

        public int length() {
            return this.appNonce.length + this.netId.length + this.devAddr.length + 1 + 1 + this.cfList.length;
        }

        public byte[] computeMic() {
            if (JoinAcceptPayload.this.appKey == null) {
                throw new RuntimeException("undefined appKey");
            }
            ByteBuffer body = ByteBuffer.allocate(1 + this.length());
            body.order(ByteOrder.LITTLE_ENDIAN);
            this.toRaw(body);
            body.put(JoinAcceptPayload.this.mac.getPhyPayload().getMHDR());
            try {
                AesCmac aesCmac = new AesCmac();
                aesCmac.init(new SecretKeySpec(JoinAcceptPayload.this.appKey, "AES"));
                aesCmac.updateBlock(body.array());
                return Arrays.copyOfRange(aesCmac.doFinal(), 0, 4);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException("Could not compute AesCmac", ex);
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeException("Could not compute AesCmac", ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new RuntimeException("Could not compute AesCmac", ex);
            }
        }
    }
}

