/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan.model;

import drivers.lorawan.model.MalformedPacketException;
import java.nio.ByteBuffer;

public class FHDR {
    private byte[] devAddr = new byte[4];
    private byte fCtrl;
    private short fCnt;
    private byte[] fOpts;

    public FHDR() {
    }

    public FHDR(ByteBuffer _raw) throws MalformedPacketException {
        try {
            _raw.get(this.devAddr);
            this.fCtrl = _raw.get();
            this.fCnt = _raw.getShort();
            this.fOpts = new byte[this.fCtrl & 0xF];
            _raw.get(this.fOpts);
        }
        catch (Exception e2) {
            throw new MalformedPacketException("FHDR");
        }
    }

    public FHDR(byte[] devAddr, byte fCtrl, short fCnt) {
        this(devAddr, fCtrl, fCnt, new byte[0]);
    }

    public FHDR(byte[] devAddr, byte fCtrl, short fCnt, byte[] fOpts) {
        this.devAddr = devAddr;
        this.fCtrl = fCtrl;
        this.fCnt = fCnt;
        this.fOpts = fOpts;
    }

    public int length() {
        return this.devAddr.length + 1 + 2 + this.fOpts.length;
    }

    public void toRaw(ByteBuffer _bb) {
        _bb.put(this.devAddr);
        _bb.put(this.fCtrl);
        _bb.putShort(this.fCnt);
        _bb.put(this.fOpts);
    }

    public byte[] getDevAddr() {
        return this.devAddr;
    }

    public FHDR setDevAddr(byte[] _devAddr) {
        this.devAddr = _devAddr;
        return this;
    }

    public byte getfCtrl() {
        return this.fCtrl;
    }

    public FHDR setfCtrl(byte _fCtrl) {
        this.fCtrl = _fCtrl;
        return this;
    }

    public short getfCnt() {
        return this.fCnt;
    }

    public FHDR setfCnt(short _fCnt) {
        this.fCnt = _fCnt;
        return this;
    }

    public byte[] getfOpts() {
        return this.fOpts;
    }

    public FHDR setfOpts(byte[] _fOpts) {
        this.fOpts = _fOpts;
        return this;
    }
}

