/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.lorawan.Device;
import drivers.lorawan.DownlinkItem;
import drivers.lorawan.Entity;
import drivers.lorawan.Gateway;
import drivers.lorawan.NullProprietaryPayload;
import drivers.lorawan.NullRFUPayload;
import drivers.lorawan.model.DataPayload;
import drivers.lorawan.model.Direction;
import drivers.lorawan.model.FHDR;
import drivers.lorawan.model.FRMPayload;
import drivers.lorawan.model.MType;
import drivers.lorawan.model.MacPayload;
import drivers.lorawan.model.MalformedPacketException;
import drivers.lorawan.model.PhyPayload;
import drivers.lorawan.model.ProprietaryPayload;
import drivers.lorawan.model.RFUPayload;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final String[] WEBOBJECTS = new String[0];
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private static final byte PKT_ID_PUSH_DATA = 0;
    private static final byte PKT_ID_PUSH_ACK = 1;
    private static final byte PKT_ID_PULL_DATA = 2;
    private static final byte PKT_ID_PULL_RESP = 3;
    private static final byte PKT_ID_PULL_ACK = 4;
    private static final byte PKT_ID_TX_ACK = 5;
    private static final long TX_ACK_TIMEOUT = 1000L;
    private static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static Driver INSTANCE;
    private final File iniFile = new File("lorawan.ini");
    private long iniFileTs;
    String name;
    private boolean online;
    private DatagramSocket socket;
    private byte[] buf = new byte[4096];
    public Map<String, Gateway> gateways;
    public Map<String, Device> devices;
    public boolean discoveryGws;
    public boolean discoveryDevs;
    private boolean debug = false;
    private int downlinkPower = -1;
    private final ProprietaryPayload nullProprietaryPayloadMapper = new NullProprietaryPayload();
    private final RFUPayload nullRfuPayloadMapper = new NullRFUPayload();
    private final Random random = new Random();
    private static int ioLimitsReserved;

    static {
        ioLimitsReserved = 0;
    }

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            int localPort;
            try {
                this.debug = Boolean.parseBoolean(config.get("debug"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gateways = new ConcurrentHashMap<String, Gateway>();
            this.devices = new ConcurrentHashMap<String, Device>();
            INSTANCE = this;
            this.loadIniFile();
            this._DEBUGln("Gateways: " + this.gateways);
            this._DEBUGln("Devices: " + this.devices);
            if (this.gateways.size() > ioLimitsReserved) {
                ioLimitsReserved += this.ioLimitsReservationRequest(this.gateways.size() - ioLimitsReserved);
                if (this.gateways.size() > ioLimitsReserved) {
                    this.ioWrite("error.iolimit", "1", false);
                    throw new Exception("I/O limit exceeded");
                }
            }
            this.ioWrite("error.iolimit", "0", false);
            if (this.gateways.isEmpty() && this.devices.isEmpty()) {
                this.discoveryGws = true;
                this.discoveryDevs = true;
            }
            MType.setProprietaryPayloadMapper(this.nullProprietaryPayloadMapper.getClass());
            MType.setRfuPayloadMapper(this.nullRfuPayloadMapper.getClass());
            try {
                localPort = Integer.parseInt(config.get("localport"));
            }
            catch (Exception e2) {
                localPort = 1700;
            }
            this.socket = new DatagramSocket(localPort);
            this.socket.setSoTimeout(10000);
            try {
                this.downlinkPower = Integer.parseInt(config.get("downlinkpower"));
            }
            catch (Exception e3) {
                this.downlinkPower = -1;
            }
            this.iniFileTs = this.iniFile.lastModified();
            return true;
        }
        catch (Exception e4) {
            this.errorLog("Initialization failed - " + e4.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private void loadIniFile() throws Exception {
        BufferedReader r = null;
        try {
            try {
                String line;
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.iniFile), Charset.forName("UTF-8")));
                String prefix = String.valueOf(this.name) + ".";
                while ((line = r.readLine()) != null) {
                    String prmVal;
                    String prmName;
                    String[] prm_val;
                    String prm;
                    int n2;
                    int n3;
                    String[] stringArray;
                    String[] prms;
                    String id;
                    String[] id_prms;
                    if (!(line = line.trim()).startsWith(prefix)) continue;
                    if (line.startsWith("gw.", prefix.length())) {
                        id_prms = line.split(":");
                        id = id_prms[0].substring(prefix.length() + 3).trim();
                        Gateway g2 = new Gateway(this, id, false);
                        stringArray = prms = id_prms[1].split(",");
                        n3 = prms.length;
                        n2 = 0;
                        while (n2 < n3) {
                            prm = stringArray[n2];
                            prm_val = prm.split("=");
                            prmName = prm_val[0].trim();
                            prmVal = prm_val[1].trim();
                            if ("mac".equalsIgnoreCase(prmName)) {
                                g2.setMac(prmVal);
                            } else if ("ip".equalsIgnoreCase(prmName)) {
                                g2.setIp(prmVal);
                            }
                            ++n2;
                        }
                        if (g2.mac == null && g2.ip == null) {
                            throw new Exception("Gateway " + id + "has no MAC nor IP");
                        }
                        this.gateways.put(id, g2);
                        continue;
                    }
                    if (!line.startsWith("dev.", prefix.length())) continue;
                    id_prms = line.split(":");
                    id = id_prms[0].substring(prefix.length() + 4).trim();
                    Device d2 = new Device(this, id, false);
                    stringArray = prms = id_prms[1].split(",");
                    n3 = prms.length;
                    n2 = 0;
                    while (n2 < n3) {
                        prm = stringArray[n2];
                        prm_val = prm.split("=");
                        prmName = prm_val[0].trim();
                        prmVal = prm_val[1].trim();
                        if ("addr".equalsIgnoreCase(prmName)) {
                            d2.setAddr(prmVal);
                        } else if ("nwkSKey".equalsIgnoreCase(prmName)) {
                            d2.setNwkSKey(prmVal);
                        } else if ("appSKey".equalsIgnoreCase(prmName)) {
                            d2.setAppSKey(prmVal);
                        } else if ("deviceClass".equalsIgnoreCase(prmName)) {
                            d2.setDeviceClass(prmVal);
                        } else if ("fCntMaxGap".equalsIgnoreCase(prmName)) {
                            d2.setFCntMaxGap(prmVal);
                        } else if ("fCntAutoResetThreshold".equalsIgnoreCase(prmName)) {
                            d2.setFCntAutoResetThreshold(prmVal);
                        } else if ("cayenne".equalsIgnoreCase(prmName)) {
                            d2.setCayenne(prmVal);
                        } else if ("fCntCheck".equalsIgnoreCase(prmName)) {
                            d2.setFCntCheck(prmVal);
                        } else if ("micCheck".equalsIgnoreCase(prmName)) {
                            d2.setMicCheck(prmVal);
                        } else if ("downlinkPort".equalsIgnoreCase(prmName)) {
                            d2.setDownlinkPort(prmVal);
                        } else if ("downlinkAttempts".equalsIgnoreCase(prmName)) {
                            d2.setDownlinkAttempts(prmVal);
                        }
                        ++n2;
                    }
                    if (d2.addr == null) {
                        throw new Exception("Device " + id + " has no address");
                    }
                    String savedFCntUp32bits = this.varGet("__HSYCO__lorawan_" + this.name + ".dev." + id + ".fCntUp32bits!");
                    try {
                        long fCntUp32bits;
                        d2.fCntUp32bits = fCntUp32bits = Long.parseLong(savedFCntUp32bits);
                    }
                    catch (Exception fCntUp32bits) {
                        // empty catch block
                    }
                    d2.ioWrite("fcnt.up", "" + d2.fCntUp32bits, false);
                    String savedFCntDown = this.varGet("__HSYCO__lorawan_" + this.name + ".dev." + id + ".fCntDown!");
                    try {
                        long fCntDown;
                        d2.fCntDown = fCntDown = Long.parseLong(savedFCntDown);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    d2.ioWrite("fcnt.down", "" + d2.fCntDown, false);
                    this.devices.put(id, d2);
                }
            }
            catch (FileNotFoundException line) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception e2) {
                if (this.debug) {
                    e2.printStackTrace();
                }
                throw new Exception("Error loading 'lorawan.ini' file: " + e2, e2);
            }
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
    }

    public boolean loop() throws Exception {
        try {
            try {
                DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length);
                this.socket.receive(packet);
                this.processPacket(packet);
            }
            catch (SocketTimeoutException packet) {
                // empty catch block
            }
            for (Device d2 : this.devices.values()) {
                if (d2.deviceClass != Device.DeviceClass.C) continue;
                this.processDownlinkQueue(null, d2, Device.DeviceClass.C);
            }
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            if (this.debug) {
                e2.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        if (!this.online) {
            this.online = true;
            this.ioWrite("connection", "online");
            this.uiSet("connection.offline", "visible", "false");
            this.uiSet("connection.online", "visible", "true");
        }
        if (this.iniFileTs != this.iniFile.lastModified()) {
            this.end();
            throw new Exception("lorawan.ini file modified - restarting");
        }
        return true;
    }

    private void processPacket(DatagramPacket packet) throws Exception {
        long pckTs = System.currentTimeMillis();
        byte protocolVersion = this.buf[0];
        String gwMac = Driver.bytesToHex(this.buf, 4, 12);
        String gwIp = packet.getAddress().getHostAddress();
        this._DEBUGln("Packet: GW MAC: " + gwMac + " - GW IP: " + gwIp + " - protocol ver: " + protocolVersion);
        if (protocolVersion == 2) {
            Gateway g2 = null;
            for (Gateway gx : this.gateways.values()) {
                if (gwIp.equals(gx.ip) ? gx.mac != null && !gwMac.equals(gx.mac) : !gwMac.equals(gx.mac) || gx.ip != null && !gwIp.equals(gx.ip)) continue;
                g2 = gx;
                break;
            }
            if (g2 == null && this.discoveryGws && (g2 = this.addGatewayIoLimits(gwMac, true)) != null) {
                g2.setMac(gwMac);
                g2.setIp(gwIp);
            }
            if (g2 != null) {
                DatagramPacket ackPkt;
                byte id = this.buf[3];
                this._DEBUGln("Packet ID: " + id);
                if (id == 0) {
                    this.buf[3] = 1;
                    ackPkt = new DatagramPacket(this.buf, 4, packet.getAddress(), packet.getPort());
                    this.socket.send(ackPkt);
                    Set<Device> ds = this.processPushData(g2, packet, pckTs);
                    for (Device d2 : ds) {
                        this.processDownlinkQueue(g2, d2, Device.DeviceClass.A);
                    }
                } else if (id == 2) {
                    g2.pullDataAddress = packet.getAddress();
                    g2.pullDataPort = packet.getPort();
                    this.buf[3] = 4;
                    ackPkt = new DatagramPacket(this.buf, 4, packet.getAddress(), packet.getPort());
                    this.socket.send(ackPkt);
                    g2.ioWrite("lastpull", "" + pckTs, true);
                } else if (id == 5) {
                    Entity dAck = null;
                    DownlinkItem dli = null;
                    for (Device d3 : this.devices.values()) {
                        dli = d3.downlinkQueue.peek();
                        if (dli == null || dli.lastSendGw != g2 || dli.lastSendToken[0] != this.buf[1] || dli.lastSendToken[1] != this.buf[2]) continue;
                        dAck = d3;
                        break;
                    }
                    if (dAck != null) {
                        String error;
                        JSONObject txpk_ack;
                        JSONObject payload = this.getJsonPayload(packet);
                        boolean ok = true;
                        if (payload != null && (txpk_ack = payload.optJSONObject("txpk_ack")) != null && (error = txpk_ack.optString("error", null)) != null && !error.equals("NONE")) {
                            dAck.ioWrite("error.tx", error, true);
                            ok = false;
                        }
                        if (ok) {
                            ((Device)dAck).downlinkQueue.poll();
                            dAck.ioWrite("error.tx", "NONE", false);
                            dAck.ioWrite("queue.size", "" + ((Device)dAck).downlinkQueue.size(), true);
                        } else if (dli.attempts <= 0) {
                            ((Device)dAck).downlinkQueue.poll();
                            dAck.ioWrite("queue.size", "" + ((Device)dAck).downlinkQueue.size(), true);
                        }
                    }
                }
                g2.ioWrite("lastseen", "" + pckTs, true);
            }
        }
    }

    private void processDownlinkQueue(Gateway g2, Device d2, Device.DeviceClass deviceClass) throws Exception {
        String[] keys2;
        if (g2 == null && (g2 = d2.gateway) == null) {
            return;
        }
        if (g2.pullDataAddress == null) {
            return;
        }
        DownlinkItem dli = d2.downlinkQueue.peek();
        if (dli == null) {
            return;
        }
        if (System.currentTimeMillis() < dli.lastSendTs + 1000L) {
            return;
        }
        if (--dli.attempts < 0) {
            d2.downlinkQueue.poll();
            d2.ioWrite("queue.size", "" + d2.downlinkQueue.size(), true);
            this.processDownlinkQueue(g2, d2, deviceClass);
            return;
        }
        this._DEBUGln("DOWN " + d2.id);
        Object[] len_data = Driver.getDeviceUnconfirmedDownlinkData(d2, dli.port, dli.data);
        JSONObject txpk = dli.txpk == null ? new JSONObject() : ((keys2 = JSONObject.getNames(dli.txpk)) == null ? new JSONObject() : new JSONObject(dli.txpk, keys2));
        if (deviceClass == Device.DeviceClass.A) {
            try {
                txpk.putOnce("imme", false);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
            try {
                txpk.putOnce("tmst", d2.tmst + 1000000L);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
            try {
                txpk.putOnce("freq", d2.freq);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
            try {
                txpk.putOnce("datr", d2.datr);
            }
            catch (JSONException keys2) {}
        } else if (deviceClass == Device.DeviceClass.C) {
            try {
                txpk.putOnce("imme", true);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
            try {
                txpk.putOnce("freq", 869.525);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
            try {
                txpk.putOnce("datr", "SF12BW125");
            }
            catch (JSONException keys2) {
                // empty catch block
            }
        }
        try {
            txpk.putOnce("modu", d2.modu);
        }
        catch (JSONException keys2) {
            // empty catch block
        }
        if ("LORA".equals(d2.modu)) {
            try {
                txpk.putOnce("ipol", true);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
        }
        try {
            txpk.putOnce("codr", d2.codr);
        }
        catch (JSONException keys2) {
            // empty catch block
        }
        try {
            txpk.putOnce("rfch", 0);
        }
        catch (JSONException keys2) {
            // empty catch block
        }
        try {
            txpk.putOnce("size", (Integer)len_data[0]);
        }
        catch (JSONException keys2) {
            // empty catch block
        }
        try {
            txpk.putOnce("data", (String)len_data[1]);
        }
        catch (JSONException keys2) {
            // empty catch block
        }
        if (this.downlinkPower > 0) {
            try {
                txpk.putOnce("powe", this.downlinkPower);
            }
            catch (JSONException keys2) {
                // empty catch block
            }
        }
        JSONObject pullRespPayload = new JSONObject();
        pullRespPayload.put("txpk", txpk);
        String payloadStr = pullRespPayload.toString();
        this._DEBUGln(payloadStr);
        byte[] payloadBytes = payloadStr.getBytes("UTF-8");
        System.arraycopy(payloadBytes, 0, this.buf, 4, payloadBytes.length);
        this.buf[0] = 2;
        int tkn = this.random.nextInt(256);
        this.buf[1] = dli.lastSendToken[0] = (byte)tkn;
        this.buf[2] = dli.lastSendToken[1] = (byte)(tkn >>> 8);
        this.buf[3] = 3;
        DatagramPacket respPkt = new DatagramPacket(this.buf, 4 + payloadBytes.length, g2.pullDataAddress, g2.pullDataPort);
        this.socket.send(respPkt);
        dli.lastSendTs = System.currentTimeMillis();
        dli.lastSendGw = g2;
    }

    private Set<Device> processPushData(Gateway g2, DatagramPacket packet, long pckTs) throws Exception {
        this._DEBUGln("Processing push data");
        HashSet<Device> devs = new HashSet<Device>();
        JSONObject payload = this.getJsonPayload(packet);
        if (payload != null) {
            JSONArray rxpk;
            JSONObject stat = payload.optJSONObject("stat");
            if (stat != null) {
                Iterator<String> keys = stat.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    g2.ioWrite("stat." + key, stat.get(key).toString(), false);
                }
            }
            if ((rxpk = payload.optJSONArray("rxpk")) != null) {
                int i2 = 0;
                while (i2 < rxpk.length()) {
                    block10: {
                        JSONObject pk = rxpk.getJSONObject(i2);
                        int pkStat = pk.getInt("stat");
                        if (pkStat >= 0) {
                            String pkData = pk.getString("data");
                            try {
                                Device d2 = this.processDeviceUplinkData(pkData, g2, pckTs);
                                if (d2 != null) {
                                    d2.setGateway(g2);
                                    d2.setTmst(pk.optLong("tmst", d2.tmst));
                                    d2.setFreq(pk.optDouble("freq", d2.freq));
                                    d2.setDatr(pk.optString("datr", d2.datr));
                                    d2.setCodr(pk.optString("codr", d2.codr));
                                    d2.setLsnr(pk.optDouble("lsnr", d2.lsnr));
                                    d2.setRssi(pk.optInt("rssi", d2.rssi));
                                    d2.setModu(pk.optString("modu", d2.modu));
                                    d2.ioWrite("lastseen", "" + pckTs, true);
                                    devs.add(d2);
                                }
                                break block10;
                            }
                            catch (Exception e2) {
                                this.errorLog("Error processing push data: " + e2);
                                if (this.debug) {
                                    e2.printStackTrace();
                                }
                                break block10;
                            }
                        }
                        this._DEBUGln("Packet CRC error");
                    }
                    ++i2;
                }
            }
        }
        return devs;
    }

    private JSONObject getJsonPayload(DatagramPacket packet) throws Exception {
        int len = packet.getLength();
        if (len <= 13) {
            return null;
        }
        String payloadStr = new String(packet.getData(), 12, len - 12, "UTF-8");
        this._DEBUGln(payloadStr);
        payloadStr = payloadStr.trim();
        if (payloadStr.isEmpty()) {
            return null;
        }
        try {
            return new JSONObject(payloadStr);
        }
        catch (Exception e2) {
            throw new Exception("Error processing payload " + payloadStr, e2);
        }
    }

    static Object[] getDeviceUnconfirmedDownlinkData(Device d2, byte fPort, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, MalformedPacketException {
        byte[] devAddr = Driver.hexToBytes(d2.addr, true);
        MType mType = MType.UNCONF_DATA_DOWN;
        byte mhdr = (byte)(mType.getValue() << 5);
        d2.setFCntDown(d2.fCntDown + 1L);
        PhyPayload phyPayload = new PhyPayload();
        phyPayload.setMHDR(mhdr);
        FHDR fhdr = new FHDR(devAddr, 0, (short)d2.fCntDown);
        MacPayload macPayload = new MacPayload(phyPayload);
        macPayload.setFhdr(fhdr);
        macPayload.setfPort(fPort);
        DataPayload dataPayload = new DataPayload(macPayload);
        dataPayload.setNwkSKey(d2.nwkSKey);
        dataPayload.setAppSKey(d2.appSKey);
        dataPayload.setClearPayLoad(data, mType.getDirection(), devAddr, (int)d2.fCntDown);
        phyPayload.setMic(dataPayload.computeMic((short)(d2.fCntDown >> 16)));
        int len = phyPayload.length();
        ByteBuffer bb = ByteBuffer.allocate(len);
        phyPayload.toRaw(bb);
        return new Object[]{len, Base64.toBase64String(bb.array())};
    }

    private Device processDeviceUplinkData(String base64encodedData, Gateway gateway, long pckTs) throws Exception {
        FRMPayload frmPayload;
        this._DEBUGln("Processing device uplink data");
        byte[] decode = Base64.decode(base64encodedData);
        PhyPayload phyPayload = new PhyPayload(ByteBuffer.wrap(decode));
        MType mType = phyPayload.getMType();
        this._DEBUGln("mType: " + mType.getValue());
        if (mType.getDirection() == Direction.DOWN) {
            this._DEBUGln("Error: expecting uplink");
            return null;
        }
        MacPayload macPayload = phyPayload.getMacPayload();
        FHDR fhdr = macPayload.getFhdr();
        byte[] devAddrBytes = fhdr.getDevAddr();
        String devAddr = Driver.bytesToHex(devAddrBytes, 0, devAddrBytes.length, true);
        this._DEBUGln("devAddr: " + devAddr);
        Device d2 = null;
        for (Device dx : this.devices.values()) {
            if (!devAddr.equals(dx.addr)) continue;
            d2 = dx;
            break;
        }
        if (d2 == null) {
            if (this.discoveryDevs) {
                d2 = new Device(this, devAddr, true);
                d2.setAddr(devAddr);
                this.devices.put(devAddr, d2);
                this._DEBUGln("Discovered: " + devAddr);
            } else {
                return null;
            }
        }
        if ((frmPayload = macPayload.getPayload()) instanceof DataPayload) {
            byte[] clearPayLoad;
            boolean valid;
            int fCntWarn;
            boolean validMic;
            long fCntUp32bits;
            block37: {
                DataPayload dataPayload = (DataPayload)frmPayload;
                dataPayload.setNwkSKey(d2.nwkSKey);
                dataPayload.setAppSKey(d2.appSKey);
                d2.lastDataPayload = dataPayload;
                int fCnt = fhdr.getfCnt() & 0xFFFF;
                this._DEBUGln("fCnt: " + fCnt);
                fCntUp32bits = d2.fCntUp32bits < 0L ? (long)fCnt : d2.fCntUp32bits & 0xFFFF0000L | (long)fCnt;
                short fCntHighBits = (short)(fCntUp32bits >>> 16);
                if (d2.discovered) {
                    validMic = false;
                } else {
                    byte[] mic = dataPayload.getMac().getPhyPayload().getMic();
                    byte[] computedMic = dataPayload.computeMic(fCntHighBits);
                    if (this.debug) {
                        this._DEBUGln("mic: " + Driver.bytesToHex(mic, 0, mic.length));
                        this._DEBUGln("computedMic: " + Driver.bytesToHex(computedMic, 0, computedMic.length));
                    }
                    validMic = Arrays.equals(mic, computedMic);
                }
                fCntWarn = 0;
                if (fCntUp32bits == d2.fCntUp32bits) {
                    if (d2.gateway != gateway) {
                        this._DEBUGln("Duplicate discarded");
                        return null;
                    }
                    fCntWarn = 10;
                } else {
                    if (fCntUp32bits < d2.fCntUp32bits) {
                        if (validMic || d2.discovered) {
                            fCntWarn = 22;
                        } else {
                            long rollFCnt = fCntUp32bits + 65536L & 0xFFFFFFFFL;
                            if (rollFCnt < d2.fCntUp32bits) {
                                fCntWarn = 21;
                            } else if (!dataPayload.validateMic((short)(rollFCnt >>> 16))) {
                                fCntWarn = 23;
                            } else {
                                this._DEBUGln("fCntUp roll-over");
                                fCntUp32bits = rollFCnt;
                                fCntHighBits = (short)(fCntUp32bits >>> 16);
                                validMic = true;
                            }
                        }
                    }
                    if (fCntWarn == 0 && fCntUp32bits - d2.fCntUp32bits > (long)d2.fCntMaxGap) {
                        fCntWarn = 30;
                    }
                }
                this._DEBUGln("fCntUp32bits: " + fCntUp32bits);
                this._DEBUGln("d.fCntUp32bits: " + d2.fCntUp32bits);
                this._DEBUGln("validMic: " + validMic);
                this._DEBUGln("fCntWarn: " + fCntWarn);
                if (d2.fCntAutoResetThreshold > 0) {
                    long minItvl;
                    long itvl;
                    boolean possibleReset = false;
                    if (fCnt <= d2.fCntMaxGap && fCnt >= d2.fCntAutoResetLastFCnt) {
                        if (validMic) {
                            if (fCntWarn == 22 && fCntHighBits == 0) {
                                possibleReset = true;
                            }
                        } else if (dataPayload.validateMic((short)0)) {
                            possibleReset = true;
                        }
                    }
                    if (!possibleReset) {
                        d2.fCntAutoResetCount = 0;
                        d2.fCntAutoResetLastFCnt = -1;
                    } else if (fCnt > d2.fCntAutoResetLastFCnt) {
                        d2.fCntAutoResetLastFCnt = fCnt;
                        if (d2.fCntAutoResetCount == 0) {
                            d2.fCntAutoResetStartTs = pckTs;
                        }
                        ++d2.fCntAutoResetCount;
                        this._DEBUGln("Possible fCnt reset " + d2.fCntAutoResetCount);
                    }
                    if (d2.fCntAutoResetCount > d2.fCntAutoResetThreshold && (itvl = pckTs - d2.fCntAutoResetStartTs) >= (minItvl = d2.minFramesInterval * (long)d2.fCntAutoResetThreshold)) {
                        this._DEBUGln("fCnt reset");
                        d2.fCntAutoResetCount = 0;
                        d2.fCntAutoResetLastFCnt = -1;
                        validMic = true;
                        fCntWarn = 0;
                        fCntUp32bits = fCnt;
                        fCntHighBits = 0;
                    }
                }
                valid = !(!validMic && d2.micCheck || fCntWarn != 0 && d2.fCntCheck);
                try {
                    clearPayLoad = dataPayload.getClearPayLoad(fCntHighBits);
                    if (valid) {
                        d2.ioWrite("warning.data", "0", false);
                    }
                }
                catch (Exception e2) {
                    this._DEBUGln("Data error: " + e2.getMessage());
                    clearPayLoad = null;
                    if (!valid) break block37;
                    d2.ioWrite("warning.data", "1", false);
                }
            }
            d2.ioWrite("warning.fcnt", "" + fCntWarn, false);
            d2.ioWrite("warning.mic", validMic ? "0" : "1", false);
            int fPort = macPayload.getfPort() & 0xFF;
            JSONObject dataObj = d2.updateData(clearPayLoad, fPort, valid);
            JSONObject obj = new JSONObject();
            obj.put("time", DATE_TIME_FORMAT.format(pckTs));
            if (dataObj != null) {
                obj.put("data", dataObj);
            }
            obj.put("fPort", fPort);
            obj.put("fCnt", fCntUp32bits);
            obj.put("fCntWarn", fCntWarn);
            obj.put("mic", validMic);
            d2.ioWrite("frame.json", obj.toString(), true);
            if (valid) {
                long itvl;
                d2.setFCntUp32bits(fCntUp32bits);
                if (d2.lastValidFrameTs > 0L && (itvl = pckTs - d2.lastValidFrameTs) < d2.minFramesInterval) {
                    d2.minFramesInterval = itvl;
                }
                d2.lastValidFrameTs = pckTs;
                return d2;
            }
        }
        return null;
    }

    static byte[] hexToBytes(String hex) {
        return Driver.hexToBytes(hex, false);
    }

    static byte[] hexToBytes(String hex, boolean reverse) {
        int len = hex.length();
        byte[] bytes = new byte[len / 2];
        int i2 = 0;
        while (i2 < len) {
            int idx = reverse ? (len - i2) / 2 - 1 : i2 / 2;
            bytes[idx] = (byte)((Character.digit(hex.charAt(i2), 16) << 4) + Character.digit(hex.charAt(i2 + 1), 16));
            i2 += 2;
        }
        return bytes;
    }

    public static String bytesToHex(byte[] bytes, int fromIdx, int toIdx) {
        return Driver.bytesToHex(bytes, fromIdx, toIdx, false);
    }

    public static String bytesToHex(byte[] bytes, int fromIdx, int toIdx, boolean reverse) {
        StringBuilder hex = new StringBuilder();
        if (reverse) {
            int i2 = toIdx - 1;
            while (i2 >= fromIdx) {
                hex.append(Driver.byteToHex(bytes[i2]));
                --i2;
            }
        } else {
            int i3 = fromIdx;
            while (i3 < toIdx) {
                hex.append(Driver.byteToHex(bytes[i3]));
                ++i3;
            }
        }
        return hex.toString();
    }

    static String byteToHex(byte val) {
        return Integer.toHexString(val & 0xFF | 0x100).substring(1);
    }

    public boolean end() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        block21: {
            try {
                name = name.toLowerCase();
                this.messageLog("Command: " + name + " = " + value);
                String[] parts = name.split("\\.");
                if ("debug".equals(parts[0])) {
                    this.debug = Boolean.parseBoolean(value);
                } else if ("dev".equals(parts[0])) {
                    Device d2 = this.devices.get(parts[1]);
                    if (d2 == null) {
                        throw new Exception("unknown device");
                    }
                    if ("fcnt".equals(parts[2])) {
                        if ("up".equals(parts[3])) {
                            d2.setFCntUp32bits(Long.parseLong(value));
                        } else if ("down".equals(parts[3])) {
                            d2.setFCntDown(Long.parseLong(value));
                        }
                    } else if ("data".equals(parts[2])) {
                        String ch = parts[3];
                        if (ch.startsWith("ch") && "type".equals(parts[4])) {
                            int chNum = Integer.parseInt(ch.substring(2));
                            d2.setCayenneType(chNum, Integer.parseInt(value));
                        }
                    } else if ("queue".equals(parts[2])) {
                        if ("clear".equals(value)) {
                            d2.downlinkQueue.clear();
                        } else {
                            if (d2.appSKey == null || d2.nwkSKey == null) {
                                throw new Exception("device not configured");
                            }
                            if (parts.length > 3) {
                                String ch = parts[3];
                                if (ch.startsWith("ch")) {
                                    int chNum = Integer.parseInt(ch.substring(2));
                                    JSONObject obj = new JSONObject();
                                    JSONObject dataObj = new JSONObject();
                                    dataObj.put("channel", chNum);
                                    dataObj.put("value", value);
                                    obj.put("data", dataObj);
                                    value = obj.toString();
                                } else {
                                    throw new Exception("unknown command");
                                }
                            }
                            DownlinkItem dli = new DownlinkItem(d2, value);
                            d2.downlinkQueue.add(dli);
                        }
                        d2.ioWrite("queue.size", "" + d2.downlinkQueue.size(), true);
                    }
                }
            }
            catch (Exception e2) {
                this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getMessage());
                if (!this.debug) break block21;
                e2.printStackTrace();
            }
        }
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    protected void ioWrite(String name, String value, boolean forced) {
        if (forced) {
            super.ioWriteForced(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    public int ioLimitsAvailable() {
        if (this.gateways.size() < ioLimitsReserved) {
            return ioLimitsReserved - this.gateways.size() + this.ioLimitsReservationRequest(0);
        }
        return this.ioLimitsReservationRequest(0);
    }

    public Gateway addGatewayIoLimits(String id, boolean discovered) {
        if (ioLimitsReserved <= this.gateways.size() && this.ioLimitsReservationRequest(1) < 1) {
            this.ioWrite("error.iolimit", "1", false);
            return null;
        }
        this.ioWrite("error.iolimit", "0", false);
        Gateway g2 = new Gateway(this, id, discovered);
        this.gateways.put(g2.id, g2);
        if (ioLimitsReserved < this.gateways.size()) {
            ioLimitsReserved = this.gateways.size();
        }
        return g2;
    }

    @Override
    protected void varSet(String name, String value) {
        super.varSet(name, value);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    private void _DEBUGln(String string) {
        if (this.debug) {
            this.messageLog(string);
        }
    }
}

