/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan;

import drivers.lorawan.Device;
import drivers.lorawan.Driver;
import drivers.lorawan.Gateway;
import org.json.JSONException;
import org.json.JSONObject;

public class DownlinkItem {
    JSONObject txpk;
    byte port;
    byte[] data;
    int attempts;
    byte[] lastSendToken = new byte[2];
    long lastSendTs;
    Gateway lastSendGw;

    DownlinkItem(Device device, String value) throws Exception {
        value = value.trim();
        try {
            JSONObject obj = new JSONObject(value);
            this.port = (byte)obj.optInt("port", device.downlinkPort);
            Object data = obj.opt("data");
            if (data == null) {
                throw new Exception("No data specified");
            }
            if (data instanceof String) {
                this.data = Driver.hexToBytes((String)data);
            } else {
                JSONObject dataObj = (JSONObject)data;
                int cayChannel = dataObj.getInt("channel");
                String cayValue = "" + dataObj.getDouble("value");
                int cayType = dataObj.optInt("type", -1);
                if (cayType >= 0) {
                    device.setCayenneType(cayChannel, cayType);
                }
                this.data = Driver.hexToBytes(device.getCayenneData(cayChannel, cayValue));
            }
            this.attempts = obj.optInt("attempts", device.downlinkAttempts);
            this.txpk = obj.optJSONObject("txpk");
        }
        catch (JSONException e2) {
            this.data = Driver.hexToBytes(value);
            this.port = device.downlinkPort;
            this.attempts = device.downlinkAttempts;
        }
    }
}

