/*
 * Decompiled with CFR 0.152.
 */
package drivers.lorawan;

import drivers.lorawan.CayenneChannel;
import drivers.lorawan.DownlinkItem;
import drivers.lorawan.Driver;
import drivers.lorawan.Entity;
import drivers.lorawan.Gateway;
import drivers.lorawan.model.DataPayload;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;

public class Device
extends Entity {
    public String addr;
    public byte[] nwkSKey;
    public byte[] appSKey;
    public DeviceClass deviceClass = DeviceClass.A;
    public boolean fCntCheck = true;
    public int fCntMaxGap = 16384;
    public int fCntAutoResetThreshold = 0;
    public boolean micCheck = true;
    public boolean cayenne = false;
    public byte downlinkPort = (byte)2;
    public int downlinkAttempts = 3;
    Map<Integer, CayenneChannel> cayenneChans;
    public Gateway gateway;
    public long fCntUp32bits = -1L;
    public long fCntDown = -1L;
    public long tmst;
    public double freq;
    public String datr;
    public String codr;
    public String modu;
    public double lsnr;
    public int rssi;
    long lastValidFrameTs = 0L;
    long minFramesInterval = Long.MAX_VALUE;
    int fCntAutoResetCount = 0;
    long fCntAutoResetStartTs = 0L;
    int fCntAutoResetLastFCnt = -1;
    public DataPayload lastDataPayload;
    public ConcurrentLinkedQueue<DownlinkItem> downlinkQueue = new ConcurrentLinkedQueue();

    public Device(Driver driver, String id, boolean discovered) {
        super("dev.", driver, id, discovered);
    }

    JSONObject updateData(byte[] data, int fPort, boolean valid) throws JSONException {
        if (data == null) {
            return null;
        }
        String dataHex = Driver.bytesToHex(data, 0, data.length);
        if (valid) {
            this.ioWrite("data", dataHex, true);
        }
        JSONObject obj = new JSONObject();
        obj.put("raw", dataHex);
        if (this.cayenne) {
            JSONObject cayObj = new JSONObject();
            JSONObject cayChans = new JSONObject();
            try {
                int i2 = 0;
                while (i2 < data.length) {
                    CayenneChannel ch = new CayenneChannel();
                    ch.setNum(data[i2++] & 0xFF);
                    ch.setType(data[i2++] & 0xFF);
                    String val = ch.format.getValue(data, i2);
                    i2 += ch.format.getDataSize();
                    if (valid) {
                        String chDp = "data.ch" + ch.num;
                        this.ioWrite(chDp, val, true);
                        this.ioWrite(String.valueOf(chDp) + ".type", "" + ch.type, false);
                        this.cayenneChans.put(ch.num, ch);
                    }
                    JSONObject chObj = new JSONObject();
                    chObj.put("type", ch.type);
                    chObj.put("val", val);
                    cayChans.put("" + ch.num, chObj);
                }
                if (valid) {
                    this.ioWrite("error.data", "0", false);
                }
                cayObj.put("error", false);
            }
            catch (Exception e2) {
                if (valid) {
                    this.ioWrite("error.data", "1", true);
                }
                cayObj.put("error", true);
            }
            cayObj.put("channels", cayChans);
            obj.put("cayenne", cayObj);
        }
        return obj;
    }

    void setCayenneType(int chNum, int type) throws Exception {
        CayenneChannel ch;
        if (this.cayenneChans == null) {
            this.cayenneChans = new HashMap<Integer, CayenneChannel>();
        }
        if ((ch = this.cayenneChans.get(chNum)) == null) {
            ch = new CayenneChannel();
            this.cayenneChans.put(chNum, ch);
        }
        ch.setType(type);
        ch.setNum(chNum);
        this.ioWrite("data.ch" + ch.num + ".type", "" + ch.type, false);
    }

    String getCayenneData(int chNum, String value) throws Exception {
        if (this.cayenneChans == null) {
            throw new Exception("Not Cayenne");
        }
        CayenneChannel ch = this.cayenneChans.get(chNum);
        if (ch == null) {
            throw new Exception("No Cayenne channel " + chNum);
        }
        if (ch.format == null) {
            throw new Exception("No Cayenne type set");
        }
        return String.valueOf(Driver.byteToHex((byte)chNum)) + ch.format.getDownlinkData(value) + "ff";
    }

    public void setAddr(String addr) {
        addr = "00000000" + addr.toLowerCase(Locale.ENGLISH);
        this.addr = addr.substring(addr.length() - 8, addr.length());
    }

    public String getNwkSKeyHexString() {
        if (this.nwkSKey == null) {
            return null;
        }
        return Driver.bytesToHex(this.nwkSKey, 0, this.nwkSKey.length);
    }

    public String getAppSKeyHexString() {
        if (this.appSKey == null) {
            return null;
        }
        return Driver.bytesToHex(this.appSKey, 0, this.appSKey.length);
    }

    public void setNwkSKey(String nwkSKey) {
        nwkSKey = "00000000000000000000000000000000" + nwkSKey;
        this.nwkSKey = Driver.hexToBytes(nwkSKey.substring(nwkSKey.length() - 32, nwkSKey.length()));
    }

    public void setAppSKey(String appSKey) {
        appSKey = "00000000000000000000000000000000" + appSKey;
        this.appSKey = Driver.hexToBytes(appSKey.substring(appSKey.length() - 32, appSKey.length()));
    }

    public void setFCntMaxGap(String maxFCntGap) {
        this.setFCntMaxGap(Integer.parseInt(maxFCntGap));
    }

    public void setFCntMaxGap(int fCntMaxGap) {
        if (fCntMaxGap < 1) {
            throw new IllegalArgumentException("fCntMaxGap < 1");
        }
        this.fCntMaxGap = fCntMaxGap;
    }

    public void setFCntAutoResetThreshold(String fCntAutoResetThreshold) {
        this.setFCntAutoResetThreshold(Integer.parseInt(fCntAutoResetThreshold));
    }

    public void setFCntAutoResetThreshold(int fCntAutoResetThreshold) {
        this.fCntAutoResetThreshold = fCntAutoResetThreshold;
    }

    public void setDownlinkPort(String downlinkPort) {
        this.setDownlinkPort(Integer.parseInt(downlinkPort));
    }

    public void setDownlinkPort(int downlinkPort) {
        if (downlinkPort < 0) {
            throw new IllegalArgumentException("downlinkPort < 0");
        }
        if (downlinkPort > 224) {
            throw new IllegalArgumentException("downlinkPort > 224");
        }
        this.downlinkPort = (byte)downlinkPort;
    }

    public void setDownlinkAttempts(String downlinkAttempts) {
        this.setDownlinkAttempts(Integer.parseInt(downlinkAttempts));
    }

    public void setDownlinkAttempts(int downlinkAttempts) {
        this.downlinkAttempts = downlinkAttempts;
    }

    public void setFCntCheck(String fCntCheck) {
        this.setFCntCheck(Boolean.parseBoolean(fCntCheck));
    }

    public void setFCntCheck(boolean fCntCheck) {
        this.fCntCheck = fCntCheck;
    }

    public void setDeviceClass(String deviceClass) {
        this.setDeviceClass(DeviceClass.valueOf(deviceClass));
    }

    public void setDeviceClass(DeviceClass deviceClass) {
        this.deviceClass = deviceClass;
    }

    public void setMicCheck(String micCheck) {
        this.setMicCheck(Boolean.parseBoolean(micCheck));
    }

    public void setMicCheck(boolean micCheck) {
        this.micCheck = micCheck;
    }

    public void setCayenne(String cayenne) {
        this.setCayenne(Boolean.parseBoolean(cayenne));
    }

    public void setCayenne(boolean cayenne) {
        this.cayenne = cayenne;
        this.cayenneChans = this.cayenne ? new HashMap<Integer, CayenneChannel>() : null;
    }

    public void setFCntUp32bits(long fCntUp32bits) {
        this.fCntUp32bits = fCntUp32bits;
        String fCntUp32bitsStr = "" + fCntUp32bits;
        this.ioWrite("fcnt.up", fCntUp32bitsStr, true);
        if (!this.discovered) {
            this.driver.varSet("__HSYCO__lorawan_" + this.driver.name + ".dev." + this.id + ".fCntUp32bits!", fCntUp32bitsStr);
        }
    }

    public void setFCntDown(long fCntDown) {
        this.fCntDown = fCntDown;
        String fCntDownStr = "" + fCntDown;
        this.ioWrite("fcnt.down", fCntDownStr, true);
        this.driver.varSet("__HSYCO__lorawan_" + this.driver.name + ".dev." + this.id + ".fCntDown!", fCntDownStr);
    }

    void setTmst(long tmst) {
        this.tmst = tmst;
        this.ioWrite("tmst", "" + tmst, false);
    }

    void setFreq(double freq) {
        this.freq = freq;
        this.ioWrite("freq", "" + freq, false);
    }

    void setLsnr(double lsnr) {
        this.lsnr = lsnr;
        this.ioWrite("lsnr", "" + lsnr, false);
    }

    void setRssi(int rssi) {
        this.rssi = rssi;
        this.ioWrite("rssi", "" + rssi, false);
    }

    void setDatr(String datr) {
        this.datr = datr;
        this.ioWrite("datr", datr, false);
    }

    void setModu(String modu) {
        this.modu = modu;
    }

    void setCodr(String codr) {
        this.codr = codr;
        this.ioWrite("codr", codr, false);
    }

    void setGateway(Gateway gateway) {
        this.gateway = gateway;
        this.ioWrite("gw", gateway.id, false);
    }

    public String toString() {
        return "Device [id=" + this.id + ", addr=" + this.addr + ", nwkSKey=" + this.getNwkSKeyHexString() + ", appSKey=" + this.getAppSKeyHexString() + ", deviceClass=" + (Object)((Object)this.deviceClass) + ", fCntCheck=" + this.fCntCheck + ", fCntMaxGap=" + this.fCntMaxGap + ", micCheck=" + this.micCheck + ", cayenne=" + this.cayenne + ", downlinkPort=" + this.downlinkPort + ", downlinkAttempts=" + this.downlinkAttempts + "]";
    }

    public static enum DeviceClass {
        A,
        B,
        C;

    }
}

