/*
 * Decompiled with CFR 0.152.
 */
package drivers.ionopimax;

import ch.ethz.ssh2.Connection;
import com.hsyco.SSHutil;
import com.hsyco.driverBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final int SSH_TIMEOUT_SECONDS = 3;
    private static final long BATTERY_ALARM_INTERVAL_MILLIS = 10000L;
    private static final long TEMPERATURE_INTERVAL_MILLIS = 1000L;
    private static final int WATCHDOG_TIMEOUT_SHORT_SECONDS = 60;
    private static final int WATCHDOG_TIMEOUT_LONG_SECONDS = 3600;
    private static final File sysfs = new File("/sys/devices/virtual/ionopimax");
    private int sysfsPathnameLength = 0;
    private boolean quietOption = false;
    private int shutdownMinutesOption = -1;
    private int watchdogEnableOption = 2;
    private int dualSdSyncOption = 0;
    private boolean startupEvents = false;
    private long pollIntervalMillis = 200L;
    private long loopTimestamp = 0L;
    private boolean genEvents = false;
    private String[] dataPointsSkipList = null;
    private ArrayList<File> files = new ArrayList();
    private Boolean watchdogControlSemaphore = new Boolean(false);
    private boolean localMode = true;
    SSHutil ssh;
    Connection connection = null;
    String[] sshReadOnlyFiles = null;
    String[] sshReadWriteFiles = null;
    String[] sshPollingDataPoints = null;
    HashSet<String> sshReadWriteDataPoints = new HashSet();
    HashSet<String> sshWriteOnlyDataPoints = new HashSet();
    String sshPollingCommand = null;
    private int watchdogEnabledValue = -1;
    private int watchdogEnableModeValue = -1;
    private int watchdogExpiredValue = -1;
    private int watchdogHeartbeatValue = -1;
    private int watchdogTimeoutValue = -1;
    private int upsBatteryValue = -1;
    private int sd1EnabledValue = -1;
    private int sdSwitchValue = -1;
    private int temperatureValue = -1;
    private long batteryTimestamp = 0L;
    private long shutdownTimestamp = 0L;
    private long temperatureTimestamp = 0L;
    private long watchdogExpiredTimestamp = 0L;
    private int watchdogHeartbeatLastValue = -1;
    private String name = null;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        String host = config.get("host");
        if (host == null || host.isEmpty() || host.equals("127.0.0.1") || host.equals("localhost")) {
            this.localMode = true;
        } else {
            int port;
            try {
                port = Integer.parseInt(config.get("port"));
                if (port == 0) {
                    port = 22;
                }
            }
            catch (NumberFormatException e2) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - port");
                return false;
            }
            String user2 = config.get("user");
            if (user2 == null || user2.length() == 0) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - user");
                return false;
            }
            String password = config.get("password");
            if (password == null || password.length() == 0) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - password");
                return false;
            }
            this.localMode = false;
            this.ssh = new SSHutil();
            try {
                this.connection = this.ssh.connect(host, port, user2, password);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (this.connection == null) {
                this.errorLog("Iono Pi Max Driver - initialization error [" + name + "] - connection failed");
                return false;
            }
        }
        String s = config.get("pollinterval");
        if (s != null) {
            try {
                int i2 = Integer.parseInt(s);
                if (i2 < 10 || i2 > 30000) {
                    throw new Exception();
                }
                this.pollIntervalMillis = i2;
            }
            catch (Exception e3) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - pollintervalmillis ignored");
            }
        }
        if ((s = config.get("startupevents")) != null) {
            try {
                this.startupEvents = Boolean.parseBoolean(s);
            }
            catch (Exception e4) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - startupevents ignored");
            }
        }
        this.genEvents = this.startupEvents;
        s = config.get("quiet");
        if (s != null) {
            try {
                this.quietOption = Boolean.parseBoolean(s);
            }
            catch (Exception e5) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - quiet ignored");
            }
        }
        if ((s = config.get("skip")) != null) {
            try {
                Vector<String> v = new Vector<String>();
                String[] a2 = s.split("[ ,;]");
                int i3 = 0;
                while (i3 < a2.length) {
                    String dp = a2[i3].trim();
                    if (dp.length() > 0) {
                        v.add(dp);
                    }
                    ++i3;
                }
                this.dataPointsSkipList = v.toArray(new String[v.size()]);
            }
            catch (Exception e6) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - skip ignored");
            }
        }
        if (this.localMode) {
            block53: {
                s = config.get("shutdown_minutes");
                if (s != null) {
                    try {
                        int i4 = Integer.parseInt(s);
                        if (i4 >= 0) {
                            this.shutdownMinutesOption = i4;
                            break block53;
                        }
                        throw new Exception();
                    }
                    catch (Exception e7) {
                        this.errorLog("Iono Pi Max Driver - option error [" + name + "] - shutdown_minutes ignored");
                    }
                }
            }
            if ("false".equalsIgnoreCase(s = config.get("watchdog"))) {
                this.watchdogEnableOption = 0;
            } else if ("true".equalsIgnoreCase(s)) {
                this.watchdogEnableOption = 1;
            } else if ("always".equalsIgnoreCase(s)) {
                this.watchdogEnableOption = 2;
            } else if ("ignore".equalsIgnoreCase(s)) {
                this.watchdogEnableOption = -1;
            } else if (s != null) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - watchdog ignored");
            }
            s = config.get("dualsdsync");
            if ("false".equalsIgnoreCase(s)) {
                this.dualSdSyncOption = 0;
            } else if ("true".equalsIgnoreCase(s)) {
                this.dualSdSyncOption = 1;
            } else if ("manual".equalsIgnoreCase(s)) {
                this.dualSdSyncOption = 2;
            } else if (s != null) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - dualsdsync ignored");
            }
            if (this.watchdogEnableOption > 0) {
                this.registerMainLoopHeartbeat(true);
            }
            try {
                this.controlFileWrite("watchdog.timeout", this.watchdogEnableOption == 2 ? Integer.toString(3600) : null);
            }
            catch (Exception e8) {
                this.errorLog("Iono Pi Max Driver - option error [" + name + "] - failed to set watchdog timeout");
            }
            if (this.dualSdSyncOption == 1) {
                this.registerDualSdSync(true);
            }
            if (sysfs.isDirectory()) {
                this.sysfsPathnameLength = sysfs.getAbsolutePath().length();
                boolean b2 = this.scanDirectory(sysfs, 1);
                if (b2) {
                    this.ioWrite("connection", "online");
                }
                return b2;
            }
            return false;
        }
        if (this.initSSH()) {
            this.ioWrite("connection", "online");
            return true;
        }
        this.ssh.disconnect();
        this.errorLog("Iono Pi Max Driver - initialization error [" + name + "] - connection failed (stage 2)");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loop() {
        boolean r = false;
        long ts = System.nanoTime() / 1000000L;
        long loopInterval = ts - this.loopTimestamp;
        if (loopInterval < this.pollIntervalMillis) {
            this.sleep(this.pollIntervalMillis - loopInterval);
            this.loopTimestamp += this.pollIntervalMillis;
        } else {
            this.sleep(20L);
            this.loopTimestamp = ts + 20L;
        }
        if (!this.localMode) {
            r = this.pollSSH(this.genEvents);
            if (!r) return r;
            if (this.genEvents) return r;
            this.genEvents = true;
            return r;
        }
        if (this.loopTimestamp - this.temperatureTimestamp > 1000L) {
            this.temperatureTimestamp = this.loopTimestamp;
            this.temperature(this.genEvents);
        }
        int i2 = 0;
        while (i2 < this.files.size()) {
            r |= this.readFile(this.files.get(i2), this.genEvents);
            this.sleep(10L);
            ++i2;
        }
        if (r && !this.genEvents) {
            this.genEvents = true;
        }
        if (this.dualSdSyncOption != 0 && this.sd1EnabledValue != 2) {
            this.writeSysFs("sd.sd1_enabled", "2");
        }
        if (this.watchdogExpiredValue == 1 && this.watchdogExpiredTimestamp == 0L) {
            this.watchdogExpiredTimestamp = this.loopTimestamp;
            this.messageLog("Iono Pi Max Driver - watchdog timeout detected [" + this.name + "]");
            this.command("shutdown", "1");
        }
        if (this.watchdogHeartbeatValue != this.watchdogHeartbeatLastValue) {
            this.watchdogHeartbeatLastValue = this.watchdogHeartbeatValue;
            this.writeSysFs("led.l4_g", "50");
            this.sleep(10L);
            this.writeSysFs("led.l4_g", "0");
        }
        Boolean bl = this.watchdogControlSemaphore;
        synchronized (bl) {
            if (!this.watchdogControlSemaphore.booleanValue()) {
                switch (this.watchdogEnableOption) {
                    case 0: {
                        if (this.watchdogEnableModeValue != 68) {
                            if (!this.writeSysFs("watchdog.enable_mode", "D")) return false;
                            if (!this.writeSysFs("watchdog.timeout", Integer.toString(60))) return false;
                            if (!this.writeSysFs("mcu.config", "s")) {
                                return false;
                            }
                        }
                        if (this.watchdogEnabledValue == 0 || this.writeSysFs("watchdog.enabled", "0")) break;
                        return false;
                    }
                    case 1: {
                        if (this.watchdogEnableModeValue != 68) {
                            if (!this.writeSysFs("watchdog.enable_mode", "D")) return false;
                            if (!this.writeSysFs("watchdog.timeout", Integer.toString(60))) return false;
                            if (!this.writeSysFs("mcu.config", "s")) {
                                return false;
                            }
                        }
                        if (this.watchdogEnabledValue != 1 && !this.writeSysFs("watchdog.enabled", "1")) {
                            return false;
                        }
                        if (this.dualSdSyncOption > 0 && this.sdSwitchValue != 1) {
                            if (!this.writeSysFs("watchdog.sd_switch", "1")) return false;
                            if (!this.writeSysFs("mcu.config", "s")) {
                                return false;
                            }
                        }
                        if (this.watchdogTimeoutValue == 60 || this.writeSysFs("watchdog.timeout", Integer.toString(60))) break;
                        return false;
                    }
                    case 2: {
                        if (this.watchdogEnableModeValue != 65) {
                            if (!this.writeSysFs("watchdog.enable_mode", "A")) return false;
                            if (!this.writeSysFs("watchdog.timeout", Integer.toString(60))) return false;
                            if (!this.writeSysFs("mcu.config", "s")) {
                                return false;
                            }
                        }
                        if (this.dualSdSyncOption > 0 && this.sdSwitchValue != 2) {
                            if (!this.writeSysFs("watchdog.sd_switch", "2")) return false;
                            if (!this.writeSysFs("mcu.config", "s")) {
                                return false;
                            }
                        }
                        if (this.watchdogTimeoutValue == 60 || this.writeSysFs("watchdog.timeout", Integer.toString(60))) break;
                        return false;
                    }
                }
            }
        }
        if (!this.quietOption && this.upsBatteryValue == 1 && this.loopTimestamp - this.batteryTimestamp > 10000L) {
            this.batteryTimestamp = this.loopTimestamp;
            this.writeSysFs("buzzer.beep", "20 20 6");
        }
        if (this.shutdownMinutesOption == -1) return r;
        if (this.upsBatteryValue != 1) {
            if (this.shutdownTimestamp == 0L) return r;
            this.messageLog("Iono Pi Max Driver - power restored [" + this.name + "] - shutdown cancelled");
            this.shutdownTimestamp = 0L;
            return r;
        }
        if (this.shutdownTimestamp == 0L) {
            this.shutdownTimestamp = this.loopTimestamp;
            this.messageLog("Iono Pi Max Driver - power failure detected [" + this.name + "] - shutdown in " + this.shutdownMinutesOption + " minutes");
            return r;
        }
        if (this.loopTimestamp - this.shutdownTimestamp <= (long)(this.shutdownMinutesOption * 60000)) return r;
        this.shutdownMinutesOption = -1;
        this.messageLog("Iono Pi Max Driver - power failure detected [" + this.name + "] - shutdown now");
        this.command("shutdown", "1");
        return r;
    }

    public boolean end() {
        if (this.localMode) {
            if (this.dualSdSyncOption > 0) {
                this.registerDualSdSync(false);
            }
        } else {
            this.ssh.disconnect();
        }
        this.ioWrite("connection", "offline");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        block13: {
            try {
                if (!this.localMode) {
                    if (this.sshReadWriteDataPoints.contains(name) || this.sshWriteOnlyDataPoints.contains(name)) {
                        this.writeSSH(name, value);
                    }
                    return;
                }
                if (name.equals("shutdown")) {
                    if (!value.equals("1")) break block13;
                    this.writeSysFs("buzzer.beep", "3000");
                    Boolean bl = this.watchdogControlSemaphore;
                    synchronized (bl) {
                        this.watchdogControlSemaphore = true;
                        if (this.writeSysFs("power.down_enable_mode", "A") && this.writeSysFs("power.down_delay", "2") && this.writeSysFs("power.down_enabled", "1") && this.writeSysFs("watchdog.timeout", "60") && this.writeSysFs("watchdog.down_delay", "60") && this.writeSysFs("watchdog.enabled", "1")) {
                            this.messageLog("Iono Pi Max Driver - shutdown command [" + this.name + "] - shutdown now");
                            this.controlFileWrite("shutdown", "shutdown");
                            this.exit();
                        } else {
                            this.watchdogControlSemaphore = false;
                            this.errorLog("Iono Pi Max Driver - shutdown command [" + this.name + "] - failed. Exit aborted");
                        }
                        break block13;
                    }
                }
                if (name.equals("dualsdsync")) {
                    if (this.dualSdSyncOption == 2 && value.equals("1")) {
                        this.registerDualSdSync(true);
                        this.ioWrite("dualsdsync", "1");
                    }
                } else {
                    this.writeSysFs(name, value);
                }
            }
            catch (Exception e2) {
                this.errorLog("Iono Pi Max Driver - shutdown command [" + this.name + "] - exception [" + name + " = " + value + "]: " + e2.getLocalizedMessage());
            }
        }
    }

    public void dualSdSyncWriteStatus(long time, int status) {
        if (this.dualSdSyncOption == 2) {
            this.registerDualSdSync(false);
            this.ioWrite("dualsdsync", "0");
        }
        this.ioWriteForced("dualsdsync.time", Long.toString(time));
        this.ioWriteForced("dualsdsync.status", Integer.toString(status));
    }

    public void hearbeat() {
        this.writeSysFs("watchdog.heartbeat", "F");
    }

    private boolean scanDirectory(File d2, int depth) {
        String fn = null;
        boolean success = false;
        int sysfslen = sysfs.getPath().length() + 1;
        try {
            File[] fa = d2.listFiles();
            int i2 = 0;
            while (i2 < fa.length) {
                block20: {
                    fn = fa[i2].getName();
                    if (!(Files.isSymbolicLink(fa[i2].toPath()) || fn.startsWith(".") || fn.equals("uevent"))) {
                        if (fa[i2].isDirectory() && depth > 0) {
                            success |= this.scanDirectory(fa[i2], depth - 1);
                        } else if (fa[i2].canRead()) {
                            BufferedReader in = null;
                            try {
                                try {
                                    in = new BufferedReader(new FileReader(fa[i2]));
                                    String value = in.readLine();
                                    if (value != null) {
                                        if (!this.skipDataPoint(fa[i2].getPath().substring(sysfslen).replace('/', '.'))) {
                                            this.files.add(fa[i2]);
                                        }
                                        success = true;
                                    }
                                }
                                catch (Exception exception) {
                                    try {
                                        in.close();
                                    }
                                    catch (Exception exception2) {}
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++i2;
            }
            return success;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void controlFileWrite(String name, String value) throws Exception {
        if (value == null) {
            new File(".~" + name).delete();
        } else {
            FileOutputStream controlFileOutputStream = new FileOutputStream(".~" + name, false);
            OutputStreamWriter controlFileWriter = new OutputStreamWriter((OutputStream)controlFileOutputStream, "ASCII");
            controlFileWriter.write(value);
            controlFileWriter.close();
            controlFileOutputStream.close();
        }
    }

    private boolean writeSysFs(String name, String value) {
        try {
            File f2 = new File(sysfs, name.toLowerCase().replace('.', '/'));
            if (f2.canWrite()) {
                BufferedWriter out = new BufferedWriter(new FileWriter(f2));
                out.write(value);
                out.close();
                this.readFile(f2, true);
                return true;
            }
        }
        catch (Exception e2) {
            this.errorLog("Iono Pi Max Driver - SysFS command [" + this.name + "] - exception [" + name + " = " + value + "]: " + e2.getLocalizedMessage());
            return false;
        }
        this.errorLog("Iono Pi Max Driver - SysFS command [" + this.name + "] - error [" + name + " = " + value + "]");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(File f2, boolean events2) {
        try {
            if (!f2.canRead()) return false;
            BufferedReader in = null;
            try {
                block23: {
                    String dp;
                    String value;
                    block26: {
                        block24: {
                            block29: {
                                block28: {
                                    block27: {
                                        block25: {
                                            in = new BufferedReader(new FileReader(f2));
                                            value = in.readLine();
                                            if (value == null) break block23;
                                            dp = f2.getAbsolutePath().substring(this.sysfsPathnameLength + 1).replace('/', '.');
                                            if (!dp.startsWith("watchdog.")) break block24;
                                            if (!dp.endsWith("enabled")) break block25;
                                            this.watchdogEnabledValue = Integer.parseInt(value);
                                            break block26;
                                        }
                                        if (!dp.endsWith("enable_mode")) break block27;
                                        this.watchdogEnableModeValue = value.charAt(0);
                                        break block26;
                                    }
                                    if (!dp.endsWith("expired")) break block28;
                                    this.watchdogExpiredValue = Integer.parseInt(value);
                                    break block26;
                                }
                                if (!dp.endsWith("heartbeat")) break block29;
                                this.watchdogHeartbeatValue = Integer.parseInt(value);
                                break block26;
                            }
                            if (dp.endsWith("sd_switch")) {
                                this.sdSwitchValue = Integer.parseInt(value);
                                break block26;
                            } else if (dp.endsWith("timeout")) {
                                this.watchdogTimeoutValue = Integer.parseInt(value);
                            }
                            break block26;
                        }
                        if (dp.equals("ups.battery")) {
                            this.upsBatteryValue = Integer.parseInt(value);
                        } else if (dp.equals("sd.sd1_enabled")) {
                            this.sd1EnabledValue = Integer.parseInt(value);
                        }
                    }
                    if (events2) {
                        this.ioWrite(dp, value);
                        return true;
                    }
                    this.ioWriteNoEvents(dp, value);
                    return true;
                }
                this.errorLog("Iono Pi Max Driver - kernel module [" + this.name + "] - error reading " + f2.getAbsolutePath());
                return false;
            }
            catch (Exception exception) {
                return false;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean temperature(boolean events2) {
        try {
            FileReader tempfr = new FileReader(new File("/sys/class/thermal/thermal_zone0/temp"));
            BufferedReader tempbr = new BufferedReader(tempfr);
            int value = Math.round(Integer.parseInt(tempbr.readLine()) / 1000);
            tempbr.close();
            tempfr.close();
            if (this.temperatureValue != value) {
                this.temperatureValue = value;
                if (events2) {
                    this.ioWrite("cpu.temperature", Integer.toString(value));
                } else {
                    this.ioWriteNoEvents("cpu.temperature", Integer.toString(value));
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean initSSH() {
        StringBuffer sb = new StringBuffer();
        try {
            String file;
            String[] data = this.ssh.execToStringArray(sysfs.getPath(), "find . -mindepth 2 -maxdepth 2 -perm 220 -name \"*\" -print", 3);
            int i2 = 0;
            while (i2 < data.length) {
                this.sshWriteOnlyDataPoints.add(data[i2].substring(2).replace('/', '.'));
                ++i2;
            }
            data = this.ssh.execToStringArray(sysfs.getPath(), "find . -mindepth 2 -maxdepth 2 -perm 440 -name \"*\" -print", 3);
            Vector<String> v = new Vector<String>();
            i2 = 0;
            while (i2 < data.length) {
                file = data[i2].substring(2);
                if (!this.skipDataPoint(file.replace('/', '.'))) {
                    v.add(file);
                }
                ++i2;
            }
            this.sshReadOnlyFiles = v.toArray(new String[v.size()]);
            data = this.ssh.execToStringArray(sysfs.getPath(), "find . -mindepth 2 -maxdepth 2 -perm 660 -name \"*\" -print", 3);
            v = new Vector();
            i2 = 0;
            while (i2 < data.length) {
                file = data[i2].substring(2);
                if (!this.skipDataPoint(file.replace('/', '.'))) {
                    v.add(file);
                }
                ++i2;
            }
            this.sshReadWriteFiles = v.toArray(new String[v.size()]);
            this.sshPollingDataPoints = new String[this.sshReadOnlyFiles.length + this.sshReadWriteFiles.length];
            sb.append("cat");
            i2 = 0;
            while (i2 < this.sshReadOnlyFiles.length) {
                this.sshPollingDataPoints[i2] = this.sshReadOnlyFiles[i2].replace('/', '.');
                sb.append(' ');
                sb.append(this.sshReadOnlyFiles[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.sshReadWriteFiles.length) {
                String dp;
                this.sshPollingDataPoints[this.sshReadOnlyFiles.length + i2] = dp = this.sshReadWriteFiles[i2].replace('/', '.');
                this.sshReadWriteDataPoints.add(dp);
                sb.append(' ');
                sb.append(this.sshReadWriteFiles[i2]);
                ++i2;
            }
            sb.append(" 2>&1");
            this.sshPollingCommand = sb.toString();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean pollSSH(boolean events2) {
        try {
            String[] data = this.ssh.execToStringArray(sysfs.getPath(), this.sshPollingCommand, 3);
            if (data.length == this.sshPollingDataPoints.length) {
                int i2 = 0;
                while (i2 < data.length) {
                    if (!data[i2].startsWith("cat: ")) {
                        if (events2) {
                            this.ioWrite(this.sshPollingDataPoints[i2], data[i2]);
                        } else {
                            this.ioWriteNoEvents(this.sshPollingDataPoints[i2], data[i2]);
                        }
                    }
                    ++i2;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean writeSSH(String name, String value) {
        try {
            String file = name.replace('.', '/');
            String command = "echo \"" + value.replaceAll("\"", "\\\"") + "\" > " + file + "; cat " + file;
            String[] data = this.ssh.execToStringArray(sysfs.getPath(), command, 3);
            if (data.length == 1 && data[0].length() > 0) {
                this.ioWrite(name, data[0]);
            }
            return true;
        }
        catch (Exception exception) {
            this.errorLog("Iono Pi Max Driver - SSH command [" + this.name + "] - error [" + name + " = " + value + "]");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean skipDataPoint(String name) {
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.dataPointsSkipList.length) {
                    return false;
                }
                if (name.startsWith(this.dataPointsSkipList[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

