/*
 * Decompiled with CFR 0.152.
 */
package drivers.boschfpa;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import com.hsyco.hsyco;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private String driverid = null;
    private String comm = null;
    private Properties boschfpaini = null;
    private long boschfpainiLastCheck = 0L;
    private long boschfpainiLastModified = 0L;
    private boolean gui = true;
    private int language;
    private int logSize = 100;
    private boolean online = false;
    private int state = 0;
    private ByteArrayOutputStream messageBuffer;
    private long commtime = 0L;
    private byte[] commandData = null;
    private int commandRetryCounter = 0;
    private Hashtable<String, String> localizedStrings = new Hashtable();
    private LinkedList<String> logList = new LinkedList();
    private Hashtable<String, Integer> Lines = new Hashtable();
    private Hashtable<Integer, Boolean> Status = new Hashtable();
    private static final int[] STATUS_VALUES;
    private static final int STANDBY_STATE = 0;
    private static final int ENQ_STATE = 1;
    private static final int TEXT_STATE = 2;
    private static final int ACK0_STATE = 3;
    private static final int ACK1_STATE = 4;
    private static final int NAK_STATE = 5;
    private static final byte[] ACK0_MESSAGE;
    private static final byte[] ACK1_MESSAGE;
    private static final byte[] NACK_MESSAGE;
    private static final byte[] ENQ_MESSAGE;

    static {
        int[] nArray = new int[30];
        nArray[0] = 3;
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 20;
        nArray[4] = 30;
        nArray[6] = 16;
        nArray[7] = 15;
        nArray[8] = 14;
        nArray[9] = 5;
        nArray[10] = 12;
        nArray[11] = 90;
        nArray[12] = 13;
        nArray[13] = 11;
        nArray[14] = 10;
        nArray[15] = 92;
        nArray[16] = 24;
        nArray[17] = 27;
        nArray[18] = 28;
        nArray[19] = 29;
        nArray[20] = 7;
        nArray[21] = 69;
        nArray[22] = 68;
        nArray[23] = 48;
        nArray[24] = 37;
        nArray[25] = 44;
        nArray[26] = 38;
        nArray[27] = 43;
        nArray[28] = 42;
        nArray[29] = 39;
        STATUS_VALUES = nArray;
        ACK0_MESSAGE = new byte[]{16, 48};
        ACK1_MESSAGE = new byte[]{16, 49};
        NACK_MESSAGE = new byte[]{21};
        ENQ_MESSAGE = new byte[]{5};
    }

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.driverid = new String(name);
        this.comm = config.get("comm");
        if (this.comm == null) {
            this.offline();
            return false;
        }
        String s = config.get("gui");
        if (s != null) {
            this.gui = Boolean.parseBoolean(s);
        }
        if ((s = config.get("language")) == null) {
            this.language = Configuration.language;
        } else if (s.equalsIgnoreCase("it")) {
            this.language = 1;
        } else if (s.equalsIgnoreCase("de")) {
            this.language = 4;
        } else {
            hsyco.errorLog("ioMonitor - ioServersOption format error [" + name + "] - language ignored");
            this.language = Configuration.language;
        }
        s = config.get("logsize");
        if (s != null) {
            try {
                int n2 = Integer.parseInt(s);
                if (n2 >= 0) {
                    this.logSize = n2;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + name + "] - logsize ignored");
            }
        }
        this.langugeInit();
        this.logRestore();
        return true;
    }

    public boolean loop() {
        long now = System.currentTimeMillis();
        if (this.commtime + 60000L < now && this.online) {
            this.offline();
            this.state = 0;
            this.closeComm(this.comm);
        }
        if (this.boschfpainiLastCheck < now - 5000L) {
            this.boschfpainiLastCheck = now;
            File f2 = new File("boschfpa.ini");
            if (f2.isFile()) {
                long t = f2.lastModified();
                if (t != this.boschfpainiLastModified) {
                    try {
                        FileInputStream fis = new FileInputStream(f2);
                        this.boschfpaini = new Properties();
                        this.boschfpaini.load(fis);
                        fis.close();
                        this.boschfpainiLastModified = t;
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.boschfpaini = new Properties();
            }
        }
        switch (this.state) {
            case 0: {
                if (this.commandData == null) {
                    Byte b2 = this.readCommByte();
                    if (b2 == null || b2 != 5) break;
                    if (!this.online) {
                        this.online();
                    }
                    this.writeCommBytes(ACK0_MESSAGE);
                    this.state = 1;
                    this.commtime = now;
                    break;
                }
                if (this.commandRetryCounter < 5) {
                    ++this.commandRetryCounter;
                    this.writeCommBytes(ENQ_MESSAGE);
                    this.state = 3;
                    break;
                }
                hsyco.errorLog("ioMonitor - command error [" + this.driverid + "]: " + this.toHexString(this.commandData));
                this.commandRetryCounter = 0;
                this.commandData = null;
                break;
            }
            case 1: {
                Byte b3 = this.readCommByte();
                if (b3 != null && b3 == 2) {
                    this.state = 2;
                    this.messageBuffer = new ByteArrayOutputStream();
                    this.commtime = now;
                    break;
                }
                if (b3 != null && b3 == 4) {
                    this.state = 0;
                    this.commtime = now;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                while (this.state == 2) {
                    Byte b4 = this.readCommByte();
                    if (b4 == null) {
                        this.state = 0;
                        continue;
                    }
                    if (b4 == 3) {
                        b4 = this.readCommByte();
                        if (this.messageParser(b4)) {
                            this.writeCommBytes(ACK1_MESSAGE);
                            this.state = 0;
                            this.commtime = now;
                            continue;
                        }
                        this.writeCommBytes(NACK_MESSAGE);
                        this.state = 1;
                        continue;
                    }
                    this.messageBuffer.write(b4.byteValue());
                }
                break;
            }
            case 3: {
                Byte b5 = this.readCommByte();
                if (b5 != null && b5 == 16) {
                    b5 = this.readCommByte();
                    if (b5 != null && b5 == 48) {
                        ByteArrayOutputStream commandBuffer = new ByteArrayOutputStream();
                        int p = 0;
                        try {
                            commandBuffer.write(2);
                            commandBuffer.write(this.commandData);
                            commandBuffer.write(3);
                            int i2 = 0;
                            while (i2 < this.commandData.length) {
                                p = (byte)(p ^ this.commandData[i2]);
                                ++i2;
                            }
                            p = (byte)(p ^ 3);
                            commandBuffer.write(p);
                            this.writeCommBytes(commandBuffer.toByteArray());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.state = 4;
                        this.commtime = now;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            case 4: {
                Byte b6 = this.readCommByte();
                if (b6 != null && b6 == 16) {
                    b6 = this.readCommByte();
                    if (b6 != null && b6 == 49) {
                        this.commandRetryCounter = 0;
                        this.commandData = null;
                        this.state = 0;
                        this.commtime = now;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
        }
        return true;
    }

    public boolean end() {
        this.offline();
        return true;
    }

    public void command(String name, String value) {
        String lname = name.toLowerCase();
        try {
            while (this.state != 0 || this.commandData != null) {
                this.sleep(100L);
            }
            if (lname.equals("buzzer") && value.equalsIgnoreCase("off")) {
                byte[] c2 = new byte[]{50, 61};
                this.commandData = c2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Byte readCommByte() {
        byte[] ba = this.readCommBytes(this.comm, 1);
        if (ba != null && ba.length == 1) {
            return ba[0];
        }
        this.sleep(100L);
        return null;
    }

    private int writeCommBytes(byte[] data) {
        return this.writeCommBytes(this.comm, data);
    }

    private void online() {
        this.online = true;
        this.ioWrite("connection", "online");
    }

    private void offline() {
        this.online = false;
        this.ioWrite("connection", "offline");
    }

    private boolean messageParser(byte parity) {
        byte[] data = this.messageBuffer.toByteArray();
        byte p = 0;
        try {
            int i2 = 0;
            while (i2 < data.length) {
                p = (byte)(p ^ data[i2]);
                ++i2;
            }
            if ((p = (byte)((byte)(p ^ 3))) == parity && data.length % 2 == 0) {
                byte[] message = new byte[data.length / 2];
                int i3 = 0;
                while (i3 < message.length) {
                    message[i3] = (byte)((data[2 * i3] & 0xF) << 4 | data[2 * i3 + 1] & 0xF);
                    ++i3;
                }
                String messageString = this.toHexString(message).toLowerCase();
                if (messageString.equals("2d")) {
                    this.ioWriteForced("buzzer", "off");
                } else if (messageString.startsWith("42")) {
                    String address = String.valueOf((message[1] & 0xFF) + (message[2] & 0xFF) * 256) + "." + (message[6] & 0xFF);
                    int status = message[3] & 0xFF;
                    this.ioWrite("line." + address, this.statusKey(status));
                    Integer ls = this.Lines.get(address);
                    if (ls == null || ls != status) {
                        this.Lines.put(address, status);
                        this.logLineStatus(address, status);
                        int i4 = 0;
                        while (i4 < STATUS_VALUES.length) {
                            int c2 = STATUS_VALUES[i4];
                            Boolean is = this.Status.get(c2);
                            boolean ic = this.Lines.contains(c2);
                            if (is == null || is ^ ic) {
                                this.Status.put(c2, ic);
                                this.ioWrite("status." + this.statusKey(c2), ic ? "1" : "0");
                            }
                            ++i4;
                        }
                    }
                } else if (messageString.startsWith("11")) {
                    int hour = ((message[1] & 0xF0) >> 4) * 10 + (message[1] & 0xF);
                    int minutes = ((message[2] & 0xF0) >> 4) * 10 + (message[2] & 0xF);
                    int day = ((message[3] & 0xF0) >> 4) * 10 + (message[3] & 0xF);
                    int month = ((message[4] & 0xF0) >> 4) * 10 + (message[4] & 0xF);
                    int second = message[5] < 0 ? ((message[5] & 0x70) >> 4) * 10 + (message[5] & 0xF) : 0;
                    int year = ((message[6] & 0xF0) >> 4) * 10 + (message[6] & 0xF);
                    this.ioWrite("time", String.format("20%02d-%02d-%02d %02d:%02d:%02d", year, month, day, hour, minutes, second));
                } else {
                    this.ioWriteForced("raw", messageString);
                }
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.driverid) + ": RX TELEGRAM: " + messageString);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String toHexString(byte[] data) {
        if (data == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < data.length) {
            String b2 = Integer.toHexString(data[i2] & 0xFF).toUpperCase();
            if (b2.length() == 1) {
                sb.append('0');
            }
            sb.append(b2);
            ++i2;
        }
        return sb.toString();
    }

    private void logLineStatus(String address, int status) {
        String name = this.boschfpaini.getProperty(String.valueOf(this.driverid) + ".line." + address);
        if (name == null) {
            name = address;
        }
        this.logUpdate(String.valueOf(this.localizedStringGet("status." + this.statusKey(status))) + ": " + name);
    }

    private void logUpdate(String log) {
        hsyco.securityLog(String.valueOf(this.driverid) + " - " + log);
        if (this.gui && this.logSize > 0) {
            StringBuffer persistentlog = new StringBuffer();
            long now = System.currentTimeMillis();
            SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd MMM HH:mm:ss");
            String logEntry = String.valueOf(displayDateFormat.format(now).toUpperCase()) + " " + log.toUpperCase();
            StringBuffer logsb = new StringBuffer();
            if (this.logList.size() >= this.logSize) {
                this.logList.removeLast();
            }
            this.logList.addFirst(logEntry);
            int i2 = 0;
            while (i2 < this.logList.size()) {
                String line = this.logList.get(i2);
                if (logsb.length() > 0) {
                    logsb.append("<br>");
                }
                logsb.append(line);
                line = line.replace(";", ";;");
                if (line.length() > 0) {
                    if (persistentlog.length() > 0) {
                        persistentlog.append(';');
                    }
                    persistentlog.append(line);
                }
                ++i2;
            }
            this.uiSet("logs", "value", logsb.toString());
            this.varSet("__hsyco__boschfpa." + this.driverid + ".log!", persistentlog.toString());
        }
    }

    private void logRestore() {
        int i2;
        StringBuffer sb = new StringBuffer();
        boolean semicolon = false;
        try {
            String persistentlog = this.varGet("__hsyco__boschfpa." + this.driverid + ".log!");
            i2 = 0;
            while (i2 < persistentlog.length()) {
                char c2 = persistentlog.charAt(i2);
                if (semicolon) {
                    if (c2 == ';') {
                        sb.append(c2);
                    } else {
                        this.logList.add(sb.toString());
                        if (this.logList.size() >= this.logSize) break;
                        sb = new StringBuffer();
                        sb.append(c2);
                    }
                    semicolon = false;
                } else if (c2 == ';') {
                    semicolon = true;
                } else {
                    sb.append(c2);
                }
                ++i2;
            }
            if (this.logList.size() < this.logSize && sb.length() > 0) {
                this.logList.add(sb.toString());
            }
        }
        catch (Exception persistentlog) {
            // empty catch block
        }
        if (this.gui && this.logSize > 0) {
            StringBuffer logsb = new StringBuffer();
            i2 = 0;
            while (i2 < this.logList.size()) {
                String line = this.logList.get(i2);
                if (logsb.length() > 0) {
                    logsb.append("<br>");
                }
                logsb.append(line);
                ++i2;
            }
            this.uiSet("logs", "value", logsb.toString());
        }
    }

    private String statusKey(int status) {
        switch (status) {
            case 3: {
                return "bypass";
            }
            case 31: {
                return "blocked";
            }
            case 59: {
                return "warningthreshold";
            }
            case 20: {
                return "tamper";
            }
            case 30: {
                return "alarminvestigation";
            }
            case 0: {
                return "invalid";
            }
            case 16: {
                return "fire";
            }
            case 15: {
                return "fireprealarm";
            }
            case 14: {
                return "firedaymode";
            }
            case 5: {
                return "normal";
            }
            case 12: {
                return "trouble";
            }
            case 90: {
                return "troublelight";
            }
            case 13: {
                return "supervisorymonitorwater";
            }
            case 11: {
                return "off";
            }
            case 10: {
                return "on";
            }
            case 92: {
                return "paperout";
            }
            case 24: {
                return "normal";
            }
            case 27: {
                return "trouble";
            }
            case 28: {
                return "powerfail";
            }
            case 29: {
                return "trouble";
            }
            case 7: {
                return "activated";
            }
            case 69: {
                return "pollution";
            }
            case 68: {
                return "pollutionlight";
            }
            case 48: {
                return "walktestfire";
            }
            case 37: {
                return "walktestnormal";
            }
            case 44: {
                return "walktesttrouble";
            }
            case 38: {
                return "walktesttrouble";
            }
            case 43: {
                return "walktestoff";
            }
            case 42: {
                return "walkteston";
            }
            case 39: {
                return "walktestactivation";
            }
        }
        return Integer.toString(status);
    }

    private String localizedStringGet(String key) {
        String s = this.localizedStrings.get(key);
        return s == null || s.length() == 0 ? key : s;
    }

    private void langugeInit() {
        switch (this.language) {
            case 1: {
                this.localizedStrings.put("ok", "ok");
                this.localizedStrings.put("error", "errore");
                this.localizedStrings.put("status.bypass", "disabilitato");
                this.localizedStrings.put("status.blocked", "bloccato");
                this.localizedStrings.put("status.warningthreshold", "avviso soglia");
                this.localizedStrings.put("status.tamper", "manomissione");
                this.localizedStrings.put("status.alarminvestigation", "verifica allarme");
                this.localizedStrings.put("status.invalid", "non valido");
                this.localizedStrings.put("status.fire", "incendio");
                this.localizedStrings.put("status.fireprealarm", "preallarme incendio");
                this.localizedStrings.put("status.firedaymode", "incendio modo giorno");
                this.localizedStrings.put("status.normal", "normale");
                this.localizedStrings.put("status.trouble", "guasto");
                this.localizedStrings.put("status.troublelight", "guasto minore");
                this.localizedStrings.put("status.supervisorymonitorwater", "supervisione, monitor, acqua");
                this.localizedStrings.put("status.off", "off");
                this.localizedStrings.put("status.on", "on");
                this.localizedStrings.put("status.paperout", "manca carta");
                this.localizedStrings.put("status.powerfail", "manca alimentazione");
                this.localizedStrings.put("status.activated", "attivato");
                this.localizedStrings.put("status.pollution", "contaminazione");
                this.localizedStrings.put("status.pollutionlight", "contaminazione leggera");
                this.localizedStrings.put("status.walktestfire", "walk test incendio");
                this.localizedStrings.put("status.walktestnormal", "walk test normale");
                this.localizedStrings.put("status.walktesttrouble", "walk test guasto");
                this.localizedStrings.put("status.walktestoff", "walk test off");
                this.localizedStrings.put("status.walkteston", "walk test on");
                this.localizedStrings.put("status.walktestactivation", "walk test ");
                break;
            }
            case 4: {
                this.localizedStrings.put("ok", "ok");
                this.localizedStrings.put("error", "fehler");
                this.localizedStrings.put("status.bypass", "abschaltung");
                this.localizedStrings.put("status.blocked", "adresssperre");
                this.localizedStrings.put("status.warningthreshold", "alarmvorstufe");
                this.localizedStrings.put("status.tamper", "sabotage extern");
                this.localizedStrings.put("status.alarminvestigation", "alarmerkundung");
                this.localizedStrings.put("status.invalid", "fehlende gruppe");
                this.localizedStrings.put("status.fire", "feuer");
                this.localizedStrings.put("status.fireprealarm", "feuer voralarm");
                this.localizedStrings.put("status.firedaymode", "feuer intern");
                this.localizedStrings.put("status.normal", "ruhe");
                this.localizedStrings.put("status.trouble", "st\u00f6runng");
                this.localizedStrings.put("status.troublelight", "leichte st\u00f6rung");
                this.localizedStrings.put("status.supervisorymonitorwater", "notalarm / hausalarm");
                this.localizedStrings.put("status.off", "ung\u00fcltig");
                this.localizedStrings.put("status.on", "g\u00fcltig");
                this.localizedStrings.put("status.paperout", "papierende");
                this.localizedStrings.put("status.powerfail", "peripherie st\u00f6rung energie");
                this.localizedStrings.put("status.activated", "steuern ein");
                this.localizedStrings.put("status.pollution", "starke verschmutzng");
                this.localizedStrings.put("status.pollutionlight", "leichte verschmutzung, staubig");
                this.localizedStrings.put("status.walktestfire", "revision feuer");
                this.localizedStrings.put("status.walktestnormal", "revision ruhe");
                this.localizedStrings.put("status.walktesttrouble", "revision st\u00f6rung");
                this.localizedStrings.put("status.walktestoff", "revision ung\u00fcltig");
                this.localizedStrings.put("status.walkteston", "revision g\u00fcltig");
                this.localizedStrings.put("status.walktestactivation", "revision steuern ein");
                break;
            }
            default: {
                this.localizedStrings.put("ok", "ok");
                this.localizedStrings.put("error", "error");
                this.localizedStrings.put("status.bypass", "bypass");
                this.localizedStrings.put("status.blocked", "blocked");
                this.localizedStrings.put("status.warningthreshold", "threshold warning");
                this.localizedStrings.put("status.tamper", "tamper");
                this.localizedStrings.put("status.alarminvestigation", "alarm verification");
                this.localizedStrings.put("status.invalid", "invalid");
                this.localizedStrings.put("status.fire", "fire");
                this.localizedStrings.put("status.fireprealarm", "fire pre-alarm");
                this.localizedStrings.put("status.firedaymode", "fire day mode");
                this.localizedStrings.put("status.normal", "normal");
                this.localizedStrings.put("status.trouble", "fault");
                this.localizedStrings.put("status.troublelight", "minor fault");
                this.localizedStrings.put("status.supervisorymonitorwater", "supervisory, monitor, water");
                this.localizedStrings.put("status.off", "off");
                this.localizedStrings.put("status.on", "on");
                this.localizedStrings.put("status.paperout", "out of paper");
                this.localizedStrings.put("status.powerfail", "power fail");
                this.localizedStrings.put("status.activated", "activated");
                this.localizedStrings.put("status.pollution", "heavy contamination");
                this.localizedStrings.put("status.pollutionlight", "minor contamination");
                this.localizedStrings.put("status.walktestfire", "walk test fire");
                this.localizedStrings.put("status.walktestnormal", "walk test normal");
                this.localizedStrings.put("status.walktesttrouble", "walk test fault");
                this.localizedStrings.put("status.walktestoff", "walk test off");
                this.localizedStrings.put("status.walkteston", "walk test on");
                this.localizedStrings.put("status.walktestactivation", "walk test activation");
            }
        }
    }
}

