/*
 * Decompiled with CFR 0.152.
 */
package drivers.avigilon;

import com.hsyco.driverBase;
import drivers.avigilon.Listener;
import java.io.IOException;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private Listener listener;
    private String version = "0.6";
    private String name = null;
    public int port = 10001;
    public String host = "0.0.0.0";

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.name = name;
        try {
            this.port = Integer.parseInt(config.get("port"));
            this.host = config.get("host");
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host and port ignored");
        }
        if (this.isVerboseLog()) {
            if (this.host.equals("0.0.0.0")) {
                this.messageLog(String.valueOf(name) + ": started, on port " + this.port + " accepting connection from every host");
            } else {
                this.messageLog(String.valueOf(name) + ": started, on port " + this.port + " accepting connection from host: " + this.host);
            }
        }
        this.listener = new Listener(this.port, name, this.host);
        this.listener.start();
        this.ioWrite("connection", "online");
        this.messageLog(String.valueOf(name) + ": driver started, version " + this.version);
        return true;
    }

    public boolean loop() {
        if (this.listener.restart) {
            this.ioWrite("connection", "offline");
            return false;
        }
        this.sleep(10000L);
        return true;
    }

    public boolean end() {
        block2: {
            try {
                this.listener.writer.close();
                this.listener.socket.close();
            }
            catch (IOException e2) {
                if (!this.isVerboseLog()) break block2;
                this.messageLog(String.valueOf(this.name) + ": error in quitting driver " + e2.getMessage());
            }
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    public void command(String name, String value) {
        if (name.equalsIgnoreCase("write")) {
            if (this.listener.isConnected) {
                if (this.isVerboseLog()) {
                    this.messageLog(String.valueOf(this.name) + ": sending command: " + value);
                }
                this.listener.writer.println(value);
            }
        } else if (name.equalsIgnoreCase("writehex") && this.listener.isConnected) {
            if (this.isVerboseLog()) {
                this.messageLog(String.valueOf(this.name) + ": sending command: " + this.toHex(value));
            }
            this.listener.writer.println(this.toHex(value));
        }
    }

    public String toHex(String ascii) {
        char[] ch = ascii.toCharArray();
        StringBuilder builder = new StringBuilder();
        char[] cArray = ch;
        int n2 = ch.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2;
            char i2 = c2 = cArray[n3];
            builder.append(Integer.toHexString(i2).toUpperCase());
            ++n3;
        }
        return builder.toString();
    }
}

