/*
 * Decompiled with CFR 0.152.
 */
package drivers.artecooc;

import com.hsyco.Configuration;
import com.hsyco.driverBase;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 80;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = false;
    private static final String ESCAPE_CHARS = "<>&\"'";
    private static final List<String> ESCAPE_STRINGS = Collections.unmodifiableList(Arrays.asList("&lt;", "&gt;", "&amp;", "&quot;", "&apos;"));
    private static String UNICODE_LOW = " ";
    private static String UNICODE_HIGH = "\u007f";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private String name;
    private String user = null;
    private String password = null;
    private String connectorId = null;
    private String openConnectorEventURL = null;
    private String openConnectorIOURL = null;
    private long uniqueCounter = 0L;
    private int uniqueCounterDay = -1;
    private String sessionId = null;

    public boolean init(String name, HashMap<String, String> config) {
        String ret;
        block8: {
            block7: {
                super.init(name);
                this.name = name;
                this.uniqueCounter = 1L;
                try {
                    this.connectorId = config.get("connectorid");
                    if (this.connectorId == null || this.connectorId.length() == 0) {
                        this.errorLog("connectorid value not defined");
                    }
                    this.openConnectorEventURL = "http://" + config.get("host") + ":" + config.get("port") + "/arteco-mobile/event.fcgi";
                    this.openConnectorIOURL = "http://" + config.get("host") + ":" + config.get("port") + "/arteco-mobile/write.fcgi?";
                    String s = config.get("user");
                    this.user = s == null ? "admin" : s;
                    s = config.get("password");
                    this.password = s == null ? "arteco" : s;
                    ret = this.sendEvent("HSYCO Server started: " + Configuration.publicServerName, null);
                    if (ret != null) break block7;
                    this.errorLog("connection error: no response or unknown error");
                    this.ioWrite("connection", "offline");
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            if (!ret.startsWith("200:OK")) break block8;
            this.ioWrite("connection", "online");
            return true;
        }
        int i2 = ret.indexOf(58);
        if (i2 == -1) {
            this.errorLog("connection error: unknown error");
        } else {
            this.errorLog("connection error: " + ret.substring(0, i2));
        }
        this.ioWrite("connection", "offline");
        return false;
    }

    public boolean loop() {
        this.sleep(10000L);
        return true;
    }

    public boolean end() {
        return true;
    }

    public void command(String name, String value) {
        try {
            int status;
            String NAME = name.toUpperCase();
            if (NAME.equals("EVENT")) {
                int i2 = value.indexOf(60);
                String ret = i2 != -1 && value.indexOf(62) > i2 ? this.sendEvent(value.substring(0, i2), value.substring(i2)) : this.sendEvent(value, null);
                if (this.isVerboseLog()) {
                    this.messageLog("event notification sent: " + value + ": " + ret);
                }
                this.ioWrite("connection", ret != null && ret.startsWith("200:OK") ? "online" : "offline");
            } else if (NAME.startsWith("IO.") && ((status = Integer.parseInt(value)) == 0 || status == 1)) {
                int pin;
                String[] sa = name.split("[.]");
                int serverId = Integer.parseInt(sa[1]);
                boolean ret = this.sendIO(serverId, pin = Integer.parseInt(sa[2]), status);
                if (ret) {
                    this.ioWrite("connection", "online");
                    this.ioWrite("io." + serverId + "." + pin, Integer.toString(status));
                } else {
                    this.ioWrite("connection", "offline");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    private synchronized long getUniqueCounter() {
        Calendar now = Calendar.getInstance();
        int day = now.get(5);
        if (day != this.uniqueCounterDay) {
            this.uniqueCounterDay = day;
            this.uniqueCounter = 1L;
        }
        return this.uniqueCounter++;
    }

    private String sendEvent(String description, String xml) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            sb.append("<event xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" id=\"0\" xmlns=\"http://www.arteco-global.com/\">\n");
            sb.append("<number>");
            sb.append(this.getUniqueCounter());
            sb.append("</number>\n");
            sb.append("<description>\"");
            sb.append(Driver.xmlEscape(description));
            sb.append("\"</description>\n");
            sb.append("<client-time>");
            sb.append(df.format(System.currentTimeMillis()).replace(' ', 'T'));
            sb.append("</client-time>\n");
            sb.append("<connector id=\"");
            sb.append(this.connectorId);
            sb.append("\">\n");
            if (xml != null) {
                sb.append(xml);
                sb.append("\n");
            } else {
                sb.append("<cameras />\n");
                sb.append("<data-block position=\"0\">\n");
                sb.append("<text />\n");
                sb.append("<image>\n");
                sb.append("<url />\n");
                sb.append("<username />\n");
                sb.append("<password />\n");
                sb.append("</image>\n");
                sb.append("</data-block>\n");
                sb.append("<io />\n");
                sb.append("<web />\n");
            }
            sb.append("</connector>\n");
            sb.append("</event>");
            if (Configuration.verboseLog) {
                String s = sb.toString();
                String r = this.httpPost(this.openConnectorEventURL, "text/plain", s, this.user, this.password);
                this.messageLog(String.valueOf(r) + " - " + s);
                return r;
            }
            return this.httpPost(this.openConnectorEventURL, "text/plain", sb.toString(), this.user, this.password);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private boolean sendIO(int serverId, int pin, int status) {
        try {
            StringBuffer url = new StringBuffer();
            url.append(this.openConnectorIOURL);
            url.append("serverId=");
            url.append(serverId);
            url.append("&pin=");
            url.append(pin);
            url.append("&status=");
            url.append(status);
            String ret = Driver.urlGet(url.toString(), this.user, this.password);
            return ret != null && ret.startsWith("200:OK");
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static String xmlEscape(String content) {
        String result = content;
        if (content != null && content.length() > 0) {
            boolean modified = false;
            StringBuilder stringBuilder = new StringBuilder(content.length());
            int i2 = 0;
            int count = content.length();
            while (i2 < count) {
                String character = content.substring(i2, i2 + 1);
                int pos = ESCAPE_CHARS.indexOf(character);
                if (pos > -1) {
                    stringBuilder.append(ESCAPE_STRINGS.get(pos));
                    modified = true;
                } else if (character.compareTo(UNICODE_LOW) > -1 && character.compareTo(UNICODE_HIGH) < 1) {
                    stringBuilder.append(character);
                } else {
                    stringBuilder.append("&#" + character.charAt(0) + ";");
                    modified = true;
                }
                ++i2;
            }
            if (modified) {
                result = stringBuilder.toString();
            }
        }
        return result;
    }

    String httpPost(String url, String contenttype, String data, String user2, String password) {
        try {
            HttpResponse r = this.httpPostRead(new URL(url), contenttype, data, user2, password);
            if (r.code != -1) {
                return String.valueOf(r.code) + ":" + r.content;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    HttpResponse httpPostRead(URL url, String contenttype, String data, String user2, String password) {
        return this.httpPostRead(url, contenttype, data.getBytes(UTF8_CHARSET), user2, password);
    }

    HttpResponse httpPostRead(URL url, String contenttype, byte[] data, String user2, String password) {
        int code = -1;
        try {
            String basicAuth = user2 != null && password != null ? "Basic " + this.encodeBase64String(String.valueOf(user2) + ":" + password) : null;
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            uc.setConnectTimeout(10000);
            uc.setReadTimeout(30000);
            uc.setRequestMethod("POST");
            uc.setDoOutput(true);
            if (basicAuth != null) {
                uc.setRequestProperty("Authorization", basicAuth);
            }
            if (this.sessionId != null) {
                uc.setRequestProperty("Cookie", "SessionId=" + this.sessionId + ";");
            }
            if (contenttype != null) {
                uc.setRequestProperty("Content-Type", contenttype);
            }
            uc.setRequestProperty("Content-Length", Integer.toString(data.length));
            OutputStream outstream = uc.getOutputStream();
            outstream.write(data);
            outstream.flush();
            code = this.httpResponseCode(uc);
            if (code >= 200 && code < 300) {
                int b2;
                String cookie = this.getCookie(uc.getHeaderField("Set-Cookie"), "SessionId");
                if (cookie != null && !cookie.equals(this.sessionId)) {
                    this.sessionId = cookie;
                    if (this.isVerboseLog()) {
                        this.messageLog("SessionId: " + this.sessionId);
                    }
                }
                InputStream instream = uc.getInputStream();
                StringBuffer sb = new StringBuffer();
                while ((b2 = instream.read()) != -1) {
                    sb.append((char)b2);
                }
                outstream.close();
                instream.close();
                if (sb.length() > 0) {
                    return new HttpResponse(code, sb.toString());
                }
                return new HttpResponse(code, null);
            }
            if (code == 401) {
                String cookie = this.getCookie(uc.getHeaderField("Set-Cookie"), "SessionId");
                if (cookie != null && !cookie.equals(this.sessionId)) {
                    this.sessionId = cookie;
                    if (this.isVerboseLog()) {
                        this.messageLog("SessionId: " + this.sessionId);
                    }
                }
                outstream.close();
                DigestParams authparams = this.httpDigestAuth(uc.getHeaderField("WWW-Authenticate"), "POST", url.getFile(), user2, password);
                authparams = this.httpDigestAuth(authparams);
                if (authparams != null) {
                    uc = (HttpURLConnection)url.openConnection();
                    uc.setConnectTimeout(10000);
                    uc.setReadTimeout(30000);
                    uc.setRequestMethod("POST");
                    uc.setDoOutput(true);
                    uc.setRequestProperty("Authorization", authparams.authorization);
                    if (this.sessionId != null) {
                        uc.setRequestProperty("Cookie", "SessionId=" + this.sessionId + ";");
                    }
                    if (contenttype != null) {
                        uc.setRequestProperty("Content-Type", contenttype);
                    }
                    uc.setRequestProperty("Content-Length", Integer.toString(data.length));
                    outstream = uc.getOutputStream();
                    outstream.write(data);
                    outstream.flush();
                    code = this.httpResponseCode(uc);
                    if (code >= 200 && code < 300) {
                        int b3;
                        InputStream instream = uc.getInputStream();
                        StringBuffer sb = new StringBuffer();
                        while ((b3 = instream.read()) != -1) {
                            sb.append((char)b3);
                        }
                        outstream.close();
                        instream.close();
                        if (sb.length() > 0) {
                            return new HttpResponse(code, sb.toString());
                        }
                        return new HttpResponse(code, null);
                    }
                    return new HttpResponse(code, null);
                }
                return new HttpResponse(code, null);
            }
            InputStream instream = uc.getInputStream();
            int i2 = 0;
            while (i2 < 1000000 && instream.read() != -1) {
                ++i2;
            }
            outstream.close();
            instream.close();
            return new HttpResponse(code, null);
        }
        catch (Exception e2) {
            return new HttpResponse(code, null);
        }
    }

    DigestParams httpDigestAuth(String header, String method, String uri, String user2, String password) {
        DigestParams params = new DigestParams();
        try {
            if (header.startsWith("Digest")) {
                ArrayList<String> tokens = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                boolean quoted = false;
                int i2 = 6;
                while (i2 < header.length()) {
                    char c2 = header.charAt(i2);
                    switch (c2) {
                        case ',': {
                            if (quoted) {
                                sb.append(c2);
                                break;
                            }
                            tokens.add(sb.toString());
                            sb = new StringBuilder();
                            break;
                        }
                        case '\"': {
                            quoted = !quoted;
                        }
                        default: {
                            sb.append(c2);
                        }
                    }
                    ++i2;
                }
                if (sb.length() > 0) {
                    tokens.add(sb.toString());
                }
                for (String token : tokens) {
                    int eqidx = token.indexOf(61);
                    if (eqidx <= 0) continue;
                    String name = token.substring(0, eqidx).trim();
                    String value = token.substring(eqidx + 1).trim();
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if (name.equalsIgnoreCase("realm")) {
                        params.realm = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("qop")) {
                        params.qop = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("nonce")) {
                        params.nonce = value;
                        continue;
                    }
                    if (!name.equalsIgnoreCase("opaque")) continue;
                    params.opaque = value;
                }
                params.method = method.toUpperCase();
                params.uri = new String(uri);
                params.user = new String(user2);
                params.password = new String(password);
                params.counter = 0;
                params.authorization = null;
                return params;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    DigestParams httpDigestAuth(DigestParams params) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer();
            if (params.qop != null) break block12;
            ++params.counter;
            try {
                String ha1 = Driver.md5(String.valueOf(params.user) + ":" + params.realm + ":" + params.password);
                String ha2 = Driver.md5(String.valueOf(params.method) + ":" + params.uri);
                String n2 = Integer.toHexString(params.counter);
                int i2 = n2.length();
                while (i2 < 8) {
                    sb.append('0');
                    ++i2;
                }
                sb.append(n2);
                String nc = sb.toString();
                String cnonce = Driver.md5(Long.toString(System.currentTimeMillis())).substring(0, 8);
                sb = new StringBuffer(ha1);
                sb.append(':');
                sb.append(params.nonce);
                sb.append(':');
                sb.append(ha2);
                String response = Driver.md5(sb.toString());
                sb = new StringBuffer("Digest username=\"");
                sb.append(params.user);
                sb.append("\", realm=\"");
                sb.append(params.realm);
                sb.append("\", nonce=\"");
                sb.append(params.nonce);
                sb.append("\", uri=\"");
                sb.append(params.uri);
                sb.append("\", response=\"");
                sb.append(response);
                if (params.opaque != null) {
                    sb.append("\", opaque=\"");
                    sb.append(params.opaque);
                }
                sb.append('\"');
                params.authorization = sb.toString();
                return params;
            }
            catch (Exception e2) {
                return null;
            }
        }
        try {
            if (params.qop.equals("auth")) {
                ++params.counter;
                try {
                    String ha1 = Driver.md5(String.valueOf(params.user) + ":" + params.realm + ":" + params.password);
                    String ha2 = Driver.md5(String.valueOf(params.method) + ":" + params.uri);
                    String n3 = Integer.toHexString(params.counter);
                    int i3 = n3.length();
                    while (i3 < 8) {
                        sb.append('0');
                        ++i3;
                    }
                    sb.append(n3);
                    String nc = sb.toString();
                    String cnonce = Driver.md5(Long.toString(System.currentTimeMillis())).substring(0, 8);
                    sb = new StringBuffer(ha1);
                    sb.append(':');
                    sb.append(params.nonce);
                    sb.append(':');
                    sb.append(nc);
                    sb.append(':');
                    sb.append(cnonce);
                    sb.append(":auth:");
                    sb.append(ha2);
                    String response = Driver.md5(sb.toString());
                    sb = new StringBuffer("Digest username=\"");
                    sb.append(params.user);
                    sb.append("\", realm=\"");
                    sb.append(params.realm);
                    sb.append("\", nonce=\"");
                    sb.append(params.nonce);
                    sb.append("\", uri=\"");
                    sb.append(params.uri);
                    sb.append("\", response=\"");
                    sb.append(response);
                    sb.append("\", qop=auth, nc=");
                    sb.append(nc);
                    sb.append(", cnonce=\"");
                    sb.append(cnonce);
                    if (params.opaque != null) {
                        sb.append("\", opaque=\"");
                        sb.append(params.opaque);
                    }
                    sb.append('\"');
                    params.authorization = sb.toString();
                    return params;
                }
                catch (Exception e3) {
                    return null;
                }
            }
            return null;
        }
        catch (Exception e4) {
            return null;
        }
    }

    int httpResponseCode(URLConnection uc) {
        try {
            String header = uc.getHeaderField(0);
            int bx = header.indexOf(32) + 1;
            int ex = header.indexOf(32, bx);
            return Integer.parseInt(header.substring(bx, ex));
        }
        catch (Exception e2) {
            return -1;
        }
    }

    String getCookie(String cookieheader, String name) {
        try {
            String[] sa = cookieheader.split("[ ,;]+");
            int i2 = 0;
            while (i2 < sa.length) {
                String nv = sa[i2].trim();
                int eq = nv.indexOf(61);
                if (eq != -1 && nv.substring(0, eq).equals(name)) {
                    return nv.substring(eq + 1);
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String md5(String message) {
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(message.getBytes());
            int i2 = 0;
            while (i2 < digest.length) {
                String s = Integer.toHexString(digest[i2] & 0xFF);
                if (s.length() < 2) {
                    sb.append('0');
                }
                sb.append(s);
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    String encodeBase64String(String data) throws Exception {
        String s = Base64.encodeBase64String(data.getBytes());
        int i2 = s.lastIndexOf(13);
        return i2 != -1 ? s.substring(0, i2) : s;
    }

    String encodeBase64String(byte[] data) throws Exception {
        String s = Base64.encodeBase64String(data);
        int i2 = s.lastIndexOf(13);
        return i2 != -1 ? s.substring(0, i2) : s;
    }

    class DigestParams {
        String method;
        String uri;
        String user;
        String password;
        String realm;
        String qop;
        String nonce;
        String opaque;
        int counter;
        String authorization;

        DigestParams() {
        }
    }

    class HttpResponse {
        int code;
        String content;

        public HttpResponse(int code, String content) {
            this.code = code;
            this.content = content == null ? null : new String(content);
        }
    }
}

