/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CRLFOutputStream
extends FilterOutputStream {
    protected int lastb = -1;
    protected boolean atBOL = true;
    private static final byte[] newline = new byte[]{13, 10};

    public CRLFOutputStream(OutputStream os) {
        super(os);
    }

    public void write(int b2) throws IOException {
        if (b2 == 13) {
            this.writeln();
        } else if (b2 == 10) {
            if (this.lastb != 13) {
                this.writeln();
            }
        } else {
            this.out.write(b2);
            this.atBOL = false;
        }
        this.lastb = b2;
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        int start = off;
        len += off;
        for (int i2 = start; i2 < len; ++i2) {
            if (b2[i2] == 13) {
                this.out.write(b2, start, i2 - start);
                this.writeln();
                start = i2 + 1;
            } else if (b2[i2] == 10) {
                if (this.lastb != 13) {
                    this.out.write(b2, start, i2 - start);
                    this.writeln();
                }
                start = i2 + 1;
            }
            this.lastb = b2[i2];
        }
        if (len - start > 0) {
            this.out.write(b2, start, len - start);
            this.atBOL = false;
        }
    }

    public void writeln() throws IOException {
        this.out.write(newline);
        this.atBOL = true;
    }
}

