/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.upnp;

import com.philips.lighting.hue.sdk.PHAccessPoint;
import com.philips.lighting.hue.sdk.PHBridgeSearchManager;
import com.philips.lighting.hue.sdk.notification.impl.PHNotificationManagerImpl;
import com.philips.lighting.hue.sdk.upnp.PHIpAddressSearchManager;
import com.philips.lighting.hue.sdk.upnp.PHPortalSearchManager;
import com.philips.lighting.hue.sdk.upnp.PHUpnpManager;
import com.philips.lighting.hue.sdk.utilities.impl.PHHueHelper;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PHBridgeSearchManagerImpl
implements PHBridgeSearchManager {
    private static final String TAG = "PHBridgeSerachManagerImpl";
    private static final String IPBRIDGE = "IpBridge";
    private static final String LOCATION_TEXT = "LOCATION: http://";
    private static final String COLON = ":";
    private static final String LINE = "-";
    private static final String USN = "USN: uuid:";
    private static final String BRIDGE_ID = "hue-bridgeid:";
    private String portalAddress = null;

    @Override
    public void upnpSearch() {
        this.search(true, false, false);
    }

    @Override
    public void portalSearch() {
        this.search(false, true, false);
    }

    @Override
    public void ipAddressSearch() {
        this.search(false, false, true);
    }

    @Override
    public void search(boolean searchUpnp, boolean searchPortal) {
        this.search(searchUpnp, searchPortal, false);
    }

    @Override
    public void search(final boolean searchUpnp, final boolean searchPortal, final boolean searchIpAddress) {
        new Thread(){

            @Override
            public void run() {
                List<PHAccessPoint> ipAddressAccessPoints;
                List<PHAccessPoint> portalAccessPoints;
                ArrayList<PHAccessPoint> phAccessPointList = new ArrayList<PHAccessPoint>();
                PHNotificationManagerImpl notificationManager = PHNotificationManagerImpl.getNotificationManager();
                if (searchUpnp) {
                    PHUpnpManager manager = PHBridgeSearchManagerImpl.this.getUpnpManager();
                    PHLog.d(PHBridgeSearchManagerImpl.TAG, "Discovering Devices ...");
                    List<String> ssdpReceivedMessage = manager.startSearch();
                    for (String message : ssdpReceivedMessage) {
                        Pattern bridgeIdPattern;
                        Matcher bridgeIdMatcher;
                        Pattern uidPattern;
                        Matcher uidMatcher;
                        if (message.indexOf(PHBridgeSearchManagerImpl.IPBRIDGE) < 0) continue;
                        int locI = message.indexOf(PHBridgeSearchManagerImpl.LOCATION_TEXT);
                        if (message.length() <= locI + PHBridgeSearchManagerImpl.LOCATION_TEXT.length() + 15) continue;
                        String bridgeId = null;
                        String macString = null;
                        String ipString = null;
                        Pattern ipPattern = Pattern.compile("http:\\/\\/([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})");
                        Matcher ipMatcher = ipPattern.matcher(message);
                        if (ipMatcher.find()) {
                            ipString = ipMatcher.group(1);
                        }
                        if ((uidMatcher = (uidPattern = Pattern.compile("USN: uuid:.+-([0-9a-zA-Z]{12})")).matcher(message)).find()) {
                            macString = uidMatcher.group(1);
                        }
                        if ((bridgeIdMatcher = (bridgeIdPattern = Pattern.compile("hue-bridgeid:\\s*([0-9a-zA-Z]*)")).matcher(message)).find()) {
                            bridgeId = bridgeIdMatcher.group(1);
                        }
                        PHAccessPoint accessPoint = null;
                        if (macString != null) {
                            if (macString.length() < 12) continue;
                            if (macString.length() > 12) {
                                macString = macString.substring(0, 12);
                            }
                            accessPoint = new PHAccessPoint();
                            accessPoint.setMacAddress(PHHueHelper.formatMacAddress(macString.trim()));
                            accessPoint.setIpAddress(ipString.trim());
                            accessPoint.setBridgeId(bridgeId);
                        }
                        if (phAccessPointList.contains(accessPoint) || accessPoint == null) continue;
                        phAccessPointList.add(accessPoint);
                    }
                }
                if (searchPortal && (portalAccessPoints = PHBridgeSearchManagerImpl.this.getPortalSearchManager().searchPortal()) != null && portalAccessPoints.size() > 0) {
                    for (PHAccessPoint accessPoint : portalAccessPoints) {
                        if (PHBridgeSearchManagerImpl.this.verifyDuplicateMac(phAccessPointList, accessPoint) || phAccessPointList.contains(accessPoint)) continue;
                        phAccessPointList.add(accessPoint);
                    }
                }
                if (searchIpAddress && (ipAddressAccessPoints = PHBridgeSearchManagerImpl.this.getIpAddressSearchManager().startIpAddressSearch()) != null && !ipAddressAccessPoints.isEmpty()) {
                    for (PHAccessPoint accessPoint : ipAddressAccessPoints) {
                        if (PHBridgeSearchManagerImpl.this.verifyDuplicateMac(phAccessPointList, accessPoint) || phAccessPointList.contains(accessPoint)) continue;
                        phAccessPointList.add(accessPoint);
                    }
                }
                if (phAccessPointList == null || phAccessPointList.isEmpty()) {
                    String localBridgeNotFound = "No bridge found";
                    if (notificationManager != null) {
                        notificationManager.notifySDKError(1157, localBridgeNotFound);
                    }
                } else if (notificationManager != null) {
                    notificationManager.notifyBridgeSearchResult(phAccessPointList);
                }
            }
        }.start();
    }

    public PHUpnpManager getUpnpManager() {
        return new PHUpnpManager();
    }

    public PHPortalSearchManager getPortalSearchManager() {
        PHPortalSearchManager portalSearchManager = new PHPortalSearchManager();
        if (this.portalAddress != null) {
            portalSearchManager.setPortalAddress(this.portalAddress);
        }
        return portalSearchManager;
    }

    public PHIpAddressSearchManager getIpAddressSearchManager() {
        return new PHIpAddressSearchManager();
    }

    private boolean verifyDuplicateMac(ArrayList<PHAccessPoint> phAccessPointList, PHAccessPoint accessPoint) {
        for (int i2 = 0; i2 < phAccessPointList.size(); ++i2) {
            if (accessPoint == null || accessPoint.getMacAddress() == null || phAccessPointList.get(i2) == null || phAccessPointList.get(i2).getMacAddress() == null || !phAccessPointList.get(i2).getMacAddress().equals(accessPoint.getMacAddress())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPortalAddress(String address) {
        this.portalAddress = address;
    }

    @Override
    public String getPortalAddress() {
        return this.portalAddress;
    }
}

