/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.PHScheduleSerializer;
import com.philips.lighting.hue.sdk.clip.serialisation.PHCLIPParserBase;
import com.philips.lighting.hue.sdk.exception.PHHueException;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.utilities.PHDateTimePattern;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHSchedule;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHScheduleSerializer1
extends PHCLIPParserBase
implements PHScheduleSerializer {
    private static PHScheduleSerializer1 schedulesSerialisation1;

    public static synchronized PHScheduleSerializer1 getInstance() {
        if (schedulesSerialisation1 == null) {
            schedulesSerialisation1 = new PHScheduleSerializer1();
        }
        return schedulesSerialisation1;
    }

    @Override
    public List<PHSchedule> parseSchedules(JSONObject rootObject, String sTimeZone) {
        JSONArray schedulesArray;
        ArrayList<PHSchedule> schedulesList = new ArrayList<PHSchedule>();
        JSONObject schedules = rootObject.optJSONObject("schedules");
        if (schedules == null) {
            schedules = rootObject;
        }
        if (schedules != null && (schedulesArray = schedules.names()) != null) {
            for (int i2 = 0; i2 < schedulesArray.length(); ++i2) {
                String scheduleIdentifier = schedulesArray.optString(i2);
                try {
                    JSONObject scheduleObject = schedules.optJSONObject(scheduleIdentifier);
                    PHSchedule schedule = this.parseSingleSchedule(scheduleIdentifier, scheduleObject);
                    schedulesList.add(schedule);
                    continue;
                }
                catch (Exception e2) {
                    this.reportParsingError(64, scheduleIdentifier, "Schedule unparsable due to error: " + e2.getMessage(), schedules.optJSONObject(scheduleIdentifier));
                }
            }
        }
        return schedulesList;
    }

    protected PHSchedule parseSingleSchedule(String scheduleIdentifier, JSONObject scheduleObject) {
        PHDateTimePattern pattern;
        String time;
        String name = scheduleObject.optString("name");
        if (name == null || name.length() == 0) {
            throw new PHHueException("Schedule unparsable due to error: Name invalid");
        }
        PHSchedule schedule = new PHSchedule(name);
        schedule.setIdentifier(scheduleIdentifier);
        String description = scheduleObject.optString("description");
        schedule.setDescription(description);
        JSONObject commandObject = scheduleObject.optJSONObject("command");
        if (commandObject != null) {
            ArrayList<String> commandKeysNeeded = new ArrayList<String>();
            commandKeysNeeded.add("address");
            commandKeysNeeded.add("body");
            commandKeysNeeded.add("method");
            Iterator keyIterator = commandObject.keys();
            int keyCount = 0;
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                if (!commandKeysNeeded.contains(key)) continue;
                commandKeysNeeded.remove(key);
                ++keyCount;
            }
            if (keyCount != 3) {
                String missingKey = "";
                for (int j2 = 0; j2 < commandKeysNeeded.size(); ++j2) {
                    missingKey = missingKey + (String)commandKeysNeeded.get(j2) + ",";
                }
                missingKey = missingKey.substring(0, missingKey.length() - 1);
                throw new PHHueException("JSON is missing key : command(" + missingKey + ").");
            }
            String address = commandObject.optString("address");
            JSONObject bodyObject = commandObject.optJSONObject("body");
            String[] addressComponent = address.split("/");
            if (addressComponent.length > 4) {
                schedule.setOwner(addressComponent[2]);
                if (addressComponent[3].equals("groups")) {
                    String groupIdentifier = addressComponent[4];
                    schedule.setGroupIdentifier(groupIdentifier);
                } else if (addressComponent[3].equals("lights")) {
                    String lightIdentifier = addressComponent[4];
                    schedule.setLightIdentifier(lightIdentifier);
                }
            }
            if (bodyObject != null) {
                String sceneIdentifier = bodyObject.optString("scene");
                if (sceneIdentifier != null && sceneIdentifier.length() != 0) {
                    schedule.setSceneIdentifier(sceneIdentifier);
                } else {
                    PHLightState lightState = PHBridgeVersionManager.getInstance().getLightSerializer().parseLightState(bodyObject);
                    if (lightState != null) {
                        schedule.setLightState(lightState);
                    }
                }
            }
        }
        if ((time = scheduleObject.optString("time")) != null && (pattern = PHDateTimePattern.patternWithTimeString(time, TimeZone.getTimeZone("UTC"))) != null) {
            schedule.setDate(pattern.getDate());
        }
        return schedule;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule timer, String cmdAddress, String method, String timeZone) throws JSONException {
        Date date;
        JSONObject cmd = new JSONObject();
        if (cmdAddress != null) {
            cmd.putOpt("address", cmdAddress);
        }
        if (method != null) {
            cmd.putOpt("method", method);
        }
        if (timer.getLightState() != null) {
            cmd.putOpt("body", PHBridgeVersionManager.getInstance().getLightSerializer().createLightStatePacket(timer.getLightState()));
        }
        JSONObject toSend = new JSONObject();
        if (timer.getName() != null) {
            toSend.putOpt("name", timer.getName());
        }
        if (timer.getDescription() != null && timer.getDescription().length() != 0) {
            toSend.putOpt("description", timer.getDescription());
        }
        if (cmd != null) {
            toSend.putOpt("command", cmd);
        }
        if ((date = timer.getDate()) != null) {
            SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
            if (timeZone == null || timeZone.length() == 0) {
                timeZone = "UTC";
            }
            dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
            String timerTime = dateFormate.format(date);
            toSend.putOpt("time", timerTime);
        }
        return toSend;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule timer, String cmdAddress, String method) throws JSONException {
        return this.createSchedulePacket(timer, cmdAddress, method, "UTC");
    }

    @Override
    public JSONObject updateSchedulePacket(PHSchedule timer, String cmdAddress, String method, String timeZone) throws JSONException {
        return null;
    }

    @Override
    public JSONObject updateSchedulePacket(PHSchedule timer, String cmdAddress, String method) throws JSONException {
        return null;
    }

    @Override
    public boolean validateAPI(PHSchedule schedule) {
        if (schedule.getLocalTime() != null && schedule.getLocalTime().booleanValue()) {
            return false;
        }
        if (schedule.getRecurringDays() != PHSchedule.RecurringDay.RECURRING_NONE.getValue()) {
            return false;
        }
        return schedule.getRandomTime() == 0;
    }

    @Override
    public boolean canCreate() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean canFetchAll() {
        return false;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone, boolean autodeleteSchedules) throws JSONException {
        return null;
    }

    @Override
    public JSONObject createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, boolean autodeleteSchedules) throws JSONException {
        return null;
    }
}

