/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHSceneSerializer3;
import com.philips.lighting.hue.sdk.fbp.PHBridgeVersionManager;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.model.PHAppData;
import com.philips.lighting.model.PHLightState;
import com.philips.lighting.model.PHScene;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHSceneSerializer4
extends PHSceneSerializer3 {
    private static PHSceneSerializer4 sceneSerializer4;

    public static synchronized PHSceneSerializer4 getInstance() {
        if (sceneSerializer4 == null) {
            sceneSerializer4 = new PHSceneSerializer4();
        }
        return sceneSerializer4;
    }

    @Override
    public List<PHScene> parseScenes(JSONObject rootObject) {
        JSONArray scenesArray;
        List<PHScene> scenesList = super.parseScenes(rootObject);
        JSONObject scenes = rootObject.optJSONObject("scenes");
        if (scenes == null) {
            scenes = rootObject;
        }
        if (scenes != null && (scenesArray = scenes.names()) != null) {
            for (int i2 = 0; i2 < scenesArray.length(); ++i2) {
                String sceneIdentifier = scenesArray.optString(i2);
                JSONObject sceneObject = scenes.optJSONObject(sceneIdentifier);
                scenesList.get(i2).setLocked(sceneObject.optBoolean("false"));
                scenesList.get(i2).setRecycle(sceneObject.optBoolean("recycle"));
                Date lastUpdateDate = PHUtilities.stringToDate(sceneObject.optString("lastupdated"));
                scenesList.get(i2).setLastupdated(lastUpdateDate);
                scenesList.get(i2).setOwner(sceneObject.optString("owner"));
                scenesList.get(i2).setVersion(sceneObject.optInt("version"));
                scenesList.get(i2).setPicture(sceneObject.optString("picture"));
                if (!sceneObject.has("appdata")) continue;
                JSONObject appDataObject = sceneObject.getJSONObject("appdata");
                PHAppData appData = new PHAppData();
                if (appDataObject.has("version")) {
                    appData.setVersion(appDataObject.optInt("version"));
                }
                appData.setData(appDataObject.optString("data"));
                scenesList.get(i2).setAppData(appData);
            }
        }
        return scenesList;
    }

    @Override
    public PHScene parseSceneDetails(String sceneResponse, String sceneIdentifier) {
        JSONArray lightsArray;
        JSONObject sceneObject = new JSONObject(sceneResponse);
        PHScene scene = new PHScene();
        scene.setSceneIdentifier(sceneIdentifier);
        scene.setName(sceneObject.optString("name"));
        scene.setOwner(sceneObject.optString("owner"));
        scene.setLocked(sceneObject.optBoolean("locked"));
        scene.setRecycle(sceneObject.optBoolean("recycle"));
        scene.setVersion(sceneObject.optInt("version"));
        scene.setPicture(sceneObject.optString("picture"));
        Date lastUpdateDate = PHUtilities.stringToDate(sceneObject.optString("lastupdated"));
        scene.setLastupdated(lastUpdateDate);
        if (sceneObject.has("appdata")) {
            JSONObject appDataObject = sceneObject.getJSONObject("appdata");
            PHAppData appData = new PHAppData();
            if (appDataObject.has("version")) {
                appData.setVersion(appDataObject.optInt("version"));
            }
            appData.setData(appDataObject.optString("data"));
            scene.setAppData(appData);
        }
        if (sceneObject.has("lightstates")) {
            JSONObject lightStateObject = sceneObject.getJSONObject("lightstates");
            JSONArray lightsArray2 = lightStateObject.names();
            HashMap<String, PHLightState> sceneLightStatesMap = new HashMap<String, PHLightState>();
            if (lightsArray2 != null) {
                for (int i2 = 0; i2 < lightsArray2.length(); ++i2) {
                    String lightIdentifier = lightsArray2.optString(i2);
                    PHLightState lightState = PHBridgeVersionManager.getInstance().getLightSerializer().parseLightState(lightStateObject.optJSONObject(lightIdentifier));
                    sceneLightStatesMap.put(lightIdentifier, lightState);
                }
                scene.setLightStates(sceneLightStatesMap);
            }
        }
        if ((lightsArray = sceneObject.optJSONArray("lights")) != null) {
            ArrayList<String> lightsIdentifier = new ArrayList<String>();
            for (int lightcounter = 0; lightcounter < lightsArray.length(); ++lightcounter) {
                lightsIdentifier.add(lightsArray.optString(lightcounter));
            }
            scene.setLightIdentifiers(lightsIdentifier);
        }
        return scene;
    }

    @Override
    public JSONObject createScenePacket(PHScene scene, boolean isModify) throws JSONException {
        JSONObject toSend = super.createScenePacket(scene, isModify);
        if (scene.getAppData() != null) {
            JSONObject appDataObject = new JSONObject();
            appDataObject.put("version", scene.getAppData().getVersion());
            appDataObject.put("data", scene.getAppData().getData());
            toSend.put("appdata", appDataObject);
        }
        if (!scene.isRecycle() && !isModify) {
            toSend.put("recycle", false);
        }
        if (scene.getPicture() != null && !scene.getPicture().isEmpty()) {
            toSend.put("picture", scene.getPicture());
        }
        if (scene.getLightIdentifiers().isEmpty()) {
            toSend.remove("lights");
        }
        return toSend;
    }

    @Override
    public boolean isVersion2Scene() {
        return true;
    }

    @Override
    public boolean canDelete() {
        return true;
    }
}

