/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip.serialisation;

import com.philips.lighting.hue.sdk.clip.serialisation.PHGroupSerializer3;
import com.philips.lighting.model.PHGroup;
import java.util.List;
import org.json.hue.JSONArray;
import org.json.hue.JSONException;
import org.json.hue.JSONObject;

public class PHGroupSerializer4
extends PHGroupSerializer3 {
    private static PHGroupSerializer4 groupSerializer4;

    public static synchronized PHGroupSerializer4 getInstance() {
        if (groupSerializer4 == null) {
            groupSerializer4 = new PHGroupSerializer4();
        }
        return groupSerializer4;
    }

    @Override
    public List<PHGroup> parseGroups(JSONObject rootObject) {
        JSONArray groupsArray;
        List<PHGroup> groupsList = super.parseGroups(rootObject);
        JSONObject groups = rootObject.optJSONObject("groups");
        if (groups == null) {
            groups = rootObject;
        }
        if (groups != null && (groupsArray = groups.names()) != null) {
            for (int i2 = 0; i2 < groupsArray.length(); ++i2) {
                String groupIdentifier = groupsArray.optString(i2);
                JSONObject groupObject = groups.optJSONObject(groupIdentifier);
                String groupClass = groupObject.optString("class");
                groupsList.get(i2).setGroupClass(PHGroup.PHGroupClass.fromString(groupClass));
            }
        }
        return groupsList;
    }

    @Override
    public JSONObject createGroupPacket(PHGroup group) throws JSONException {
        JSONObject toSend = super.createGroupPacket(group);
        toSend.putOpt("class", (Object)group.getGroupClass());
        return toSend;
    }
}

