/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

class dmxMonitor
extends Thread {
    public long heartbeat = 0L;
    public boolean quit;
    private String serverName;
    private int dmxIndex;
    private Socket kissSocket = null;
    private InetSocketAddress kissInetAddress = null;
    private OutputStream out;
    private BufferedInputStream bin;
    private byte[] data = new byte[513];
    private int[] buffer = new int[513];
    private int[] filter = new int[513];
    private int offset;
    private int mergestatus = -1;

    public dmxMonitor(int dmxIndex) {
        this.dmxIndex = dmxIndex;
        this.serverName = Configuration.dmxServers.elementAt(dmxIndex);
        this.offset = dmxIndex * 1000;
        int i2 = 0;
        while (i2 < this.buffer.length) {
            this.buffer[i2] = -1;
            ++i2;
        }
    }

    @Override
    public void run() {
        String did = Configuration.dmxServersDeviceId.elementAt(this.dmxIndex);
        if (did == null && Configuration.dmxServersComm.elementAt(this.dmxIndex) == null) {
            this.runKiss();
        }
    }

    void runKiss() {
        try {
            this.kissInetAddress = Configuration.dmxServersTCPSocket.elementAt(this.dmxIndex);
        }
        catch (Exception e2) {
            hsyco.errorLog("dmxMonitor - Exception for DMX Server [" + this.serverName + "] - " + e2);
            return;
        }
        try {
            this.kissSocket = new Socket();
            this.kissSocket.connect(this.kissInetAddress, 3000);
            this.kissSocket.setSoTimeout(10000);
            this.out = this.kissSocket.getOutputStream();
            this.bin = new BufferedInputStream(this.kissSocket.getInputStream());
            this.out.write(174);
            this.quit = false;
        }
        catch (Exception e3) {
            hsyco.errorLog("dmxMonitor - Generic exception - " + e3.getLocalizedMessage());
            this.quit = true;
        }
        SystemState.dmxResetMerge();
        hsyco.messageLog("dmxMonitor [" + this.serverName + "] started");
        while (!this.quit) {
            try {
                if (Configuration.dmxBusMerged[this.dmxIndex] && this.mergestatus != 1) {
                    this.out.write(177);
                    this.out.write(172);
                    this.mergestatus = 1;
                } else if (!Configuration.dmxBusMerged[this.dmxIndex] && this.mergestatus == 1) {
                    this.out.write(178);
                    this.mergestatus = 0;
                } else {
                    this.out.write(175);
                }
                if (this.mergestatus == 1 || this.bin.available() > 0) {
                    int off = 0;
                    while (off < 513) {
                        int r = this.bin.read(this.data, off, this.data.length - off);
                        if (r == -1) {
                            this.bin.close();
                            return;
                        }
                        off += r;
                    }
                    int i2 = 1;
                    while (i2 <= 512) {
                        int c2 = i2 + this.offset;
                        if (SystemState.dmxGetMode(c2) == -3) {
                            int value = this.data[i2] & 0xFF;
                            if (value != this.buffer[i2]) {
                                this.buffer[i2] = value;
                                this.filter[i2] = userCode.DmxFilter(c2, value, true);
                            }
                            SystemState.dmxSetWhenMerged(c2, this.filter[i2]);
                        }
                        ++i2;
                    }
                } else {
                    Thread.sleep(1000L);
                }
                this.heartbeat = System.currentTimeMillis();
            }
            catch (SocketTimeoutException e4) {
                if (this.mergestatus != 1) continue;
                hsyco.errorLog("dmxMonitor - Generic exception [" + this.serverName + "] - " + e4.getLocalizedMessage());
                this.quit = true;
            }
            catch (Exception e5) {
                hsyco.errorLog("dmxMonitor - Generic exception [" + this.serverName + "] - " + e5.getLocalizedMessage());
                this.quit = true;
            }
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kissSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

