/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class YamahaRX {
    private String serverName;
    private InetSocketAddress serverSocket;
    private boolean guiSupport = true;
    private int pollInterval = 1000;
    private int model = 30;
    private boolean checkPartyMode = true;
    private ArrayBlockingQueue<String> ioqtx = null;
    private int online = -1;
    private int systemOn = -1;
    private int party = -1;
    private int mainPower = -1;
    private int mainSleep = -1;
    private int mainVolume = -1;
    private int mainMute = -1;
    private String mainInput = "";
    private String mainInputName = "";
    private int surroundStraight = -1;
    private int surroundEnhancer = -1;
    private String surroundProgram = "";
    private int[] zonePower = new int[]{-1, -1, -1};
    private int[] zoneSleep = new int[]{-1, -1, -1};
    private int[] zoneVolume = new int[]{-1, -1, -1};
    private int[] zoneMute = new int[]{-1, -1, -1};
    private String[] zoneInput = new String[]{"", "", ""};
    private String[] zoneInputName = new String[]{"", "", ""};
    private static final String replacePattern = "####";
    private static final String replaceZonePattern = "#ZZZ#";
    private static final String[] replacementZone = new String[]{"Zone_2", "Zone_3", "Zone_4"};
    private static final String getPowerCmd = "<YAMAHA_AV cmd=\"GET\"><System><Power_Control><Power>GetParam</Power></Power_Control></System></YAMAHA_AV>";
    private static final String getMainZoneStatusCmd = "<YAMAHA_AV cmd=\"GET\"><Main_Zone><Basic_Status>GetParam</Basic_Status></Main_Zone></YAMAHA_AV>";
    private static final String getZone2StatusCmd = "<YAMAHA_AV cmd=\"GET\"><Zone_2><Basic_Status>GetParam</Basic_Status></Zone_2></YAMAHA_AV>";
    private static final String getPartyModeCmd = "<YAMAHA_AV cmd=\"GET\"><System><Party_Mode><Mode>GetParam</Mode></Party_Mode></System></YAMAHA_AV>";
    private static final String getZone3StatusCmd = "<YAMAHA_AV cmd=\"GET\"><Zone_3><Basic_Status>GetParam</Basic_Status></Zone_3></YAMAHA_AV>";
    private static final String getZone4StatusCmd = "<YAMAHA_AV cmd=\"GET\"><Zone_4><Basic_Status>GetParam</Basic_Status></Zone_4></YAMAHA_AV>";
    private static final String setPowerOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><System><Power_Control><Power>On</Power></Power_Control></System></YAMAHA_AV>";
    private static final String setPowerOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><System><Power_Control><Power>Standby</Power></Power_Control></System></YAMAHA_AV>";
    private static final String setPartyOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><System><Party_Mode><Mode>On</Mode></Party_Mode></System></YAMAHA_AV>";
    private static final String setPartyOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><System><Party_Mode><Mode>Off</Mode></Party_Mode></System></YAMAHA_AV>";
    private static final String setMainOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Power_Control><Power>On</Power></Power_Control></Main_Zone></YAMAHA_AV>";
    private static final String setMainOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Power_Control><Power>Standby</Power></Power_Control></Main_Zone></YAMAHA_AV>";
    private static final String setMainSleepCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Power_Control><Sleep>####</Sleep></Power_Control></Main_Zone></YAMAHA_AV>";
    private static final String setMainVolumeCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Volume><Lvl><Val>####</Val><Exp>1</Exp><Unit>dB</Unit></Lvl></Volume></Main_Zone></YAMAHA_AV>";
    private static final String setMainMuteOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Volume><Mute>On</Mute></Volume></Main_Zone></YAMAHA_AV>";
    private static final String setMainMuteOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Volume><Mute>Off</Mute></Volume></Main_Zone></YAMAHA_AV>";
    private static final String setMainSourceCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Input><Input_Sel>####</Input_Sel></Input></Main_Zone></YAMAHA_AV>";
    private static final String setMainSceneCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Scene><Scene_Load>Scene ####</Scene_Load></Scene></Main_Zone></YAMAHA_AV>";
    private static final String setMainSurroundStraightOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Surround><Program_Sel><Current><Straight>On</Straight></Current></Program_Sel></Surround></Main_Zone></YAMAHA_AV>";
    private static final String setMainSurroundCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Surround><Program_Sel><Current><Straight>Off</Straight><Sound_Program>####</Sound_Program></Current></Program_Sel></Surround></Main_Zone></YAMAHA_AV>";
    private static final String setMainEnhancerOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Surround><Program_Sel><Current><Enhancer>On</Enhancer></Current></Program_Sel></Surround></Main_Zone></YAMAHA_AV>";
    private static final String setMainEnhancerOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><Main_Zone><Surround><Program_Sel><Current><Enhancer>Off</Enhancer></Current></Program_Sel></Surround></Main_Zone></YAMAHA_AV>";
    private static final String setZoneNOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Power_Control><Power>On</Power></Power_Control></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Power_Control><Power>Standby</Power></Power_Control></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNSleepCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Power_Control><Sleep>####</Sleep></Power_Control></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNMuteOnCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Volume><Mute>On</Mute></Volume></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNMuteOffCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Volume><Mute>Off</Mute></Volume></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNVolumeCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Volume><Lvl><Val>####</Val><Exp>1</Exp><Unit>dB</Unit></Lvl></Volume></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNSourceCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Input><Input_Sel>####</Input_Sel></Input></#ZZZ#></YAMAHA_AV>";
    private static final String setZoneNSceneCmd = "<?xml version=\"1.0\" encoding=\"utf-8\"?><YAMAHA_AV cmd=\"PUT\"><#ZZZ#><Scene><Scene_Load>Scene ####</Scene_Load></Scene></#ZZZ#></YAMAHA_AV>";

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.serverSocket = Configuration.ioServersTCPAddress.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "] - socket: " + this.serverSocket);
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        this.pollInterval = Integer.parseInt(value) * 1000;
                    }
                    catch (NumberFormatException e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 12, this);
        }
        me.heartbeat = System.currentTimeMillis();
        boolean error = false;
        while (!me.quit) {
            try {
                String item;
                String rsp = this.httpPostRead(getPowerCmd);
                if (rsp != null && !rsp.equals("") && rsp.startsWith("<YAMAHA_AV")) {
                    if (this.online != 1) {
                        this.online = 1;
                        this.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                        SystemState.ioServersInitializedSet(ioIndex, true);
                    }
                    if (!this.responseProcessor(rsp)) {
                        error = true;
                    }
                    if (this.systemOn == 1) {
                        rsp = this.httpPostRead(getMainZoneStatusCmd);
                        if (!this.responseProcessor(rsp)) {
                            error = true;
                        }
                        if (!this.responseProcessor(rsp = this.httpPostRead(getZone2StatusCmd))) {
                            error = true;
                        }
                        if (this.model > 10) {
                            rsp = this.httpPostRead(getZone3StatusCmd);
                            if (!this.responseProcessor(rsp)) {
                                error = true;
                            }
                            if (this.model > 20 && !this.responseProcessor(rsp = this.httpPostRead(getZone4StatusCmd))) {
                                error = true;
                            }
                        }
                        if (this.checkPartyMode && !this.responseProcessor(rsp = this.httpPostRead(getPartyModeCmd))) {
                            error = true;
                        }
                    }
                    if (!error) {
                        me.heartbeat = System.currentTimeMillis();
                    }
                    error = false;
                }
                if ((item = this.ioqtx.poll(this.pollInterval, TimeUnit.MILLISECONDS)) == null) continue;
                int pointidx = item.indexOf(46);
                int equalidx = item.indexOf(61, pointidx);
                if (!this.commandExecutor(item.substring(0, pointidx), item.substring(pointidx + 1, equalidx), item.substring(equalidx + 1))) continue;
                error = true;
            }
            catch (Exception e4) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e4);
                me.quit = true;
            }
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.online != 0) {
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.online = 0;
            this.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
        }
    }

    public String keypad(String id) {
        if (this.online == 1) {
            try {
                String[] keySp = id.split("\\.");
                if (keySp[0].equalsIgnoreCase("system")) {
                    if (keySp[1].equalsIgnoreCase("power")) {
                        switch (this.systemOn) {
                            case 0: {
                                this.ioSet("system.power", "1");
                                break;
                            }
                            case 1: {
                                this.ioSet("system.power", "0");
                            }
                        }
                    } else if (keySp[1].equalsIgnoreCase("on")) {
                        this.ioSet("system.power", "1");
                    } else if (keySp[1].equalsIgnoreCase("off")) {
                        this.ioSet("system.power", "0");
                    } else if (keySp[1].equalsIgnoreCase("party")) {
                        switch (this.party) {
                            case 0: {
                                this.ioSet("system.party", "1");
                                break;
                            }
                            case 1: {
                                this.ioSet("system.party", "0");
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (keySp[0].equalsIgnoreCase("main")) {
                    if (keySp[1].equalsIgnoreCase("power")) {
                        switch (this.mainPower) {
                            case 0: {
                                this.ioSet("main.power", "1");
                                break;
                            }
                            case 1: {
                                this.ioSet("main.power", "0");
                            }
                        }
                    } else if (keySp[1].equalsIgnoreCase("on")) {
                        this.ioSet("main.power", "1");
                    } else if (keySp[1].equalsIgnoreCase("off")) {
                        this.ioSet("main.power", "0");
                    } else if (keySp[1].equalsIgnoreCase("sleep")) {
                        switch (this.mainSleep) {
                            case 0: {
                                this.ioSet("main.sleep", "30");
                                break;
                            }
                            case 30: {
                                this.ioSet("main.sleep", "60");
                                break;
                            }
                            case 60: {
                                this.ioSet("main.sleep", "90");
                                break;
                            }
                            case 90: {
                                this.ioSet("main.sleep", "120");
                                break;
                            }
                            case 120: {
                                this.ioSet("main.sleep", "0");
                            }
                        }
                    } else if (keySp[1].equalsIgnoreCase("volume")) {
                        if (keySp[2].equalsIgnoreCase("0")) {
                            this.ioSet("main.mute", "1");
                        } else if (keySp[2].equalsIgnoreCase("up")) {
                            if (this.mainVolume <= 95) {
                                this.ioSet("main.volume", "" + (this.mainVolume + 5));
                            } else {
                                this.ioSet("main.volume", "100");
                            }
                        } else if (keySp[2].equalsIgnoreCase("down")) {
                            if (this.mainVolume >= 5) {
                                this.ioSet("main.volume", "" + (this.mainVolume - 5));
                            } else {
                                this.ioSet("main.volume", "0");
                            }
                        } else {
                            this.ioSet("main.volume", keySp[2]);
                        }
                    } else if (keySp[1].equalsIgnoreCase("mute")) {
                        if (keySp.length == 2) {
                            switch (this.mainMute) {
                                case 0: {
                                    this.ioSet("main.mute", "1");
                                    break;
                                }
                                case 1: {
                                    this.ioSet("main.mute", "0");
                                }
                            }
                        } else if (keySp[2].equalsIgnoreCase("off")) {
                            this.ioSet("main.mute", "0");
                        } else if (keySp[2].equalsIgnoreCase("on")) {
                            this.ioSet("main.mute", "1");
                        }
                    } else if (keySp[1].equalsIgnoreCase("source")) {
                        this.ioSet("main.source", keySp[2]);
                    } else if (keySp[1].equalsIgnoreCase("scene")) {
                        this.ioSet("main.scene", keySp[2]);
                    } else if (keySp[1].equalsIgnoreCase("surround")) {
                        this.ioSet("main.surround", keySp[2]);
                    } else if (keySp[1].equalsIgnoreCase("enhancer")) {
                        if (keySp.length == 2) {
                            switch (this.surroundEnhancer) {
                                case 0: {
                                    this.ioSet("main.enhancer", "1");
                                    break;
                                }
                                case 1: {
                                    this.ioSet("main.enhancer", "0");
                                }
                            }
                        } else if (keySp[2].equalsIgnoreCase("off")) {
                            this.ioSet("main.enhancer", "0");
                        } else if (keySp[2].equalsIgnoreCase("on")) {
                            this.ioSet("main.enhancer", "1");
                        }
                    }
                } else if (keySp[0].equalsIgnoreCase("z2") || keySp[0].equalsIgnoreCase("z3") || keySp[0].equalsIgnoreCase("z4")) {
                    int zoneNr = Integer.parseInt("" + keySp[0].charAt(1)) - 2;
                    if (keySp[1].equalsIgnoreCase("power")) {
                        switch (this.zonePower[zoneNr]) {
                            case 0: {
                                this.ioSet(String.valueOf(keySp[0]) + ".power", "1");
                                break;
                            }
                            case 1: {
                                this.ioSet(String.valueOf(keySp[0]) + ".power", "0");
                            }
                        }
                    } else if (keySp[1].equalsIgnoreCase("on")) {
                        this.ioSet(String.valueOf(keySp[0]) + ".power", "1");
                    } else if (keySp[1].equalsIgnoreCase("off")) {
                        this.ioSet(String.valueOf(keySp[0]) + ".power", "0");
                    } else if (keySp[1].equalsIgnoreCase("sleep")) {
                        switch (this.zoneSleep[zoneNr]) {
                            case 0: {
                                this.ioSet(String.valueOf(keySp[0]) + ".sleep", "30");
                                break;
                            }
                            case 30: {
                                this.ioSet(String.valueOf(keySp[0]) + ".sleep", "60");
                                break;
                            }
                            case 60: {
                                this.ioSet(String.valueOf(keySp[0]) + ".sleep", "90");
                                break;
                            }
                            case 90: {
                                this.ioSet(String.valueOf(keySp[0]) + ".sleep", "120");
                                break;
                            }
                            case 120: {
                                this.ioSet(String.valueOf(keySp[0]) + ".sleep", "0");
                            }
                        }
                    } else if (keySp[1].equalsIgnoreCase("volume")) {
                        if (keySp[2].equalsIgnoreCase("0")) {
                            this.ioSet(String.valueOf(keySp[0]) + ".mute", "1");
                        } else if (keySp[2].equalsIgnoreCase("up")) {
                            if (this.zoneVolume[zoneNr] <= 95) {
                                this.ioSet(String.valueOf(keySp[0]) + ".volume", "" + (this.zoneVolume[zoneNr] + 5));
                            } else {
                                this.ioSet(String.valueOf(keySp[0]) + ".volume", "100");
                            }
                        } else if (keySp[2].equalsIgnoreCase("down")) {
                            if (this.zoneVolume[zoneNr] >= 5) {
                                this.ioSet(String.valueOf(keySp[0]) + ".volume", "" + (this.zoneVolume[zoneNr] - 5));
                            } else {
                                this.ioSet(String.valueOf(keySp[0]) + ".volume", "0");
                            }
                        } else {
                            this.ioSet(String.valueOf(keySp[0]) + ".volume", keySp[2]);
                        }
                    } else if (keySp[1].equalsIgnoreCase("mute")) {
                        if (keySp.length == 2) {
                            switch (this.zoneMute[zoneNr]) {
                                case 0: {
                                    this.ioSet(String.valueOf(keySp[0]) + ".mute", "1");
                                    break;
                                }
                                case 1: {
                                    this.ioSet(String.valueOf(keySp[0]) + ".mute", "0");
                                }
                            }
                        } else if (keySp[2].equalsIgnoreCase("off")) {
                            this.ioSet(String.valueOf(keySp[0]) + ".mute", "0");
                        } else if (keySp[2].equalsIgnoreCase("on")) {
                            this.ioSet(String.valueOf(keySp[0]) + ".mute", "1");
                        }
                    } else if (keySp[1].equalsIgnoreCase("source")) {
                        this.ioSet(String.valueOf(keySp[0]) + ".source", keySp[2]);
                    } else if (keySp[1].equalsIgnoreCase("scene")) {
                        this.ioSet(String.valueOf(keySp[0]) + ".scene", keySp[2]);
                    }
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("keypad - Exception in thread [" + this.serverName + "] - " + e2);
                return null;
            }
        }
        return "";
    }

    private boolean commandExecutor(String address, String function, String value) {
        block75: {
            String addresslow = address.toLowerCase();
            String functionlow = function.toLowerCase();
            String valuelow = value.toLowerCase();
            String rsp = null;
            try {
                if (addresslow.equals("system")) {
                    if (functionlow.equals("power")) {
                        if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setPowerOffCmd);
                        } else if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setPowerOnCmd);
                        }
                    } else if (functionlow.equals("party")) {
                        if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setPartyOffCmd);
                        } else if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setPartyOnCmd);
                        }
                    }
                } else if (addresslow.equals("main")) {
                    if (functionlow.equals("power")) {
                        if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setMainOffCmd);
                        } else if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setMainOnCmd);
                        }
                    } else if (functionlow.equals("sleep")) {
                        rsp = valuelow.equals("0") || valuelow.equals("off") ? this.httpPostRead(setMainSleepCmd.replace(replacePattern, "Off")) : this.httpPostRead(setMainSleepCmd.replace(replacePattern, String.valueOf(valuelow) + " min"));
                    } else if (functionlow.equals("volume")) {
                        int val;
                        if (valuelow.equals("on")) {
                            rsp = this.httpPostRead(setMainMuteOffCmd);
                        } else if (valuelow.equals("off")) {
                            rsp = this.httpPostRead(setMainMuteOnCmd);
                        } else if (valuelow.equals("up")) {
                            val = this.mainVolume >= 100 ? 100 : (this.mainVolume + 1) * 970 / 100 - 805;
                            rsp = this.httpPostRead(setMainVolumeCmd.replace(replacePattern, "" + val));
                        } else if (valuelow.equals("down")) {
                            val = this.mainVolume <= 0 ? 0 : (this.mainVolume - 1) * 970 / 100 - 805;
                            rsp = this.httpPostRead(setMainVolumeCmd.replace(replacePattern, "" + val));
                        } else {
                            valuelow.replace("%", "");
                            int valdB = Integer.parseInt(valuelow) * 970 / 100 - 805;
                            valdB -= valdB % 5;
                            rsp = this.httpPostRead(setMainVolumeCmd.replace(replacePattern, "" + valdB));
                        }
                    } else if (functionlow.equals("mute")) {
                        if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setMainMuteOnCmd);
                        } else if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setMainMuteOffCmd);
                        }
                    } else if (functionlow.equals("source")) {
                        rsp = this.httpPostRead(setMainSourceCmd.replace(replacePattern, this.formatSource(value)));
                    } else if (functionlow.equals("scene")) {
                        rsp = this.httpPostRead(setMainSceneCmd.replace(replacePattern, valuelow));
                    } else if (function.equals("surround")) {
                        rsp = valuelow.equals("straight") ? this.httpPostRead(setMainSurroundStraightOnCmd) : this.httpPostRead(setMainSurroundCmd.replace(replacePattern, this.formatSurround(value)));
                    } else if (functionlow.equals("enhancer")) {
                        if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setMainEnhancerOnCmd);
                        } else if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setMainEnhancerOffCmd);
                        }
                    }
                } else if (addresslow.equals("z2") || addresslow.equals("z3") || addresslow.equals("z4")) {
                    int zoneNr = Integer.parseInt("" + addresslow.charAt(1)) - 2;
                    String zoneStr = replacementZone[zoneNr];
                    if (functionlow.equals("power")) {
                        if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setZoneNOffCmd.replace(replaceZonePattern, zoneStr));
                        } else if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setZoneNOnCmd.replace(replaceZonePattern, zoneStr));
                        }
                    } else if (functionlow.equals("sleep")) {
                        rsp = valuelow.equals("0") || valuelow.equals("off") ? this.httpPostRead(setZoneNSleepCmd.replace(replacePattern, "Off").replace(replaceZonePattern, zoneStr)) : this.httpPostRead(setZoneNSleepCmd.replace(replacePattern, String.valueOf(valuelow) + " min").replace(replaceZonePattern, zoneStr));
                    } else if (functionlow.equals("volume")) {
                        if (valuelow.equals("on")) {
                            rsp = this.httpPostRead(setZoneNMuteOffCmd.replace(replaceZonePattern, zoneStr));
                        } else if (valuelow.equals("off")) {
                            rsp = this.httpPostRead(setZoneNMuteOnCmd.replace(replaceZonePattern, zoneStr));
                        } else if (valuelow.equals("up")) {
                            int val = this.zoneVolume[zoneNr] >= 100 ? 100 : (this.mainVolume + 1) * 970 / 100 - 805;
                            rsp = this.httpPostRead(setMainVolumeCmd.replace(replacePattern, "" + val));
                        } else if (valuelow.equals("down")) {
                            int val = this.zoneVolume[zoneNr] <= 0 ? 0 : (this.mainVolume - 1) * 970 / 100 - 805;
                            rsp = this.httpPostRead(setMainVolumeCmd.replace(replacePattern, "" + val));
                        } else {
                            valuelow.replace("%", "");
                            int valdB = Integer.parseInt(valuelow) * 970 / 100 - 805;
                            valdB -= valdB % 5;
                            rsp = this.httpPostRead(setZoneNVolumeCmd.replace(replacePattern, "" + valdB).replace(replaceZonePattern, zoneStr));
                        }
                    } else if (functionlow.equals("mute")) {
                        if (valuelow.equals("1")) {
                            rsp = this.httpPostRead(setZoneNMuteOnCmd.replace(replaceZonePattern, zoneStr));
                        } else if (valuelow.equals("0")) {
                            rsp = this.httpPostRead(setZoneNMuteOffCmd.replace(replaceZonePattern, zoneStr));
                        }
                    } else if (functionlow.equals("source")) {
                        rsp = this.httpPostRead(setZoneNSourceCmd.replace(replacePattern, this.formatSource(value)).replace(replaceZonePattern, zoneStr));
                    } else if (functionlow.equals("scene")) {
                        rsp = this.httpPostRead(setZoneNSceneCmd.replace(replacePattern, valuelow).replace(replaceZonePattern, zoneStr));
                    }
                }
                if (rsp == null) break block75;
                if (!rsp.startsWith("<YAMAHA_AV rsp=\"PUT\" RC=\"0\">")) {
                    throw new Exception("error response");
                }
                return false;
            }
            catch (Exception e2) {
                hsyco.errorLog("commandExecutor - Exception in thread [" + this.serverName + "] - " + e2.getLocalizedMessage());
                return true;
            }
        }
        throw new Exception("null response");
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(name, value);
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (this.guiSupport) {
            if (name.equals(String.valueOf(this.serverName) + ".connection")) {
                if (value.equals("online")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "false");
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "true");
                return;
            }
            if (name.startsWith(String.valueOf(this.serverName) + ".system.")) {
                if (name.equals(String.valueOf(this.serverName) + ".system.power")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "ON");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".system.party", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".system.power.icon", "img", "on.png");
                        return;
                    }
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "OFF");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.party", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power.icon", "img", "off.png");
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".system.party")) {
                    if (value.equals("1")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".system.party", "value", "ON");
                        return;
                    }
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.party", "value", "OFF");
                    return;
                }
            }
            if (this.mainPower == 1 && name.startsWith(String.valueOf(this.serverName) + ".main.")) {
                if (name.equals(String.valueOf(this.serverName) + ".main.volume")) {
                    value = value.replace("%", "");
                    SystemState.uiSet(name, "value", value);
                    SystemState.uiSet(String.valueOf(name) + ".status", "value", String.valueOf(value) + "%");
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.mute")) {
                    value = value.equals("1") ? "off" : String.valueOf(this.mainVolume) + "%";
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.volume", "value", value);
                    value = value.equals("off") ? "MUTE" : String.valueOf(this.mainVolume) + "%";
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.volume.status", "value", value);
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.source")) {
                    SystemState.uiSet(name, "value", this.formatSource(value));
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.source.name")) {
                    SystemState.uiSet(name, "value", this.formatSource(value));
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.sleep")) {
                    value = value.equals("off") ? "OFF" : String.valueOf(value) + " min";
                    SystemState.uiSet(name, "value", value);
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.surround")) {
                    SystemState.uiSet(name, "value", this.formatSurround(value));
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.enhancer")) {
                    value = value.equals("1") ? "ON" : "OFF";
                    SystemState.uiSet(name, "value", value);
                    return;
                }
                if (name.equals(String.valueOf(this.serverName) + ".main.power")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.power", "value", "ON");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "ON");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.power.icon", "img", "on.png");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.volume", "value", String.valueOf(this.mainVolume) + "%");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.volume.status", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.sleep", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.surround", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.source", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.source.name", "visible", "true");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".main.enhancer", "visible", "true");
                    return;
                }
            } else if (name.equals(String.valueOf(this.serverName) + ".main.power")) {
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.power", "value", "OFF");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.power.icon", "img", "off.png");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.volume", "value", "off");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.volume.status", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.sleep", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.surround", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.source", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.source.name", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + ".main.enhancer", "visible", "false");
                return;
            }
            if (name.startsWith(String.valueOf(this.serverName) + ".z")) {
                int zoneNr;
                try {
                    zoneNr = Integer.parseInt("" + name.charAt((String.valueOf(this.serverName) + ".z").length()));
                }
                catch (Exception e2) {
                    return;
                }
                if (zoneNr < 2 || zoneNr > 4) {
                    return;
                }
                if (this.zonePower[zoneNr - 2] == 1) {
                    if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume")) {
                        value = value.replace("%", "");
                        SystemState.uiSet(name, "value", value);
                        SystemState.uiSet(String.valueOf(name) + ".status", "value", String.valueOf(value) + "%");
                        return;
                    }
                    if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".mute")) {
                        value = value.equals("1") ? "off" : String.valueOf(this.zoneVolume[zoneNr - 2]) + "%";
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume", "value", value);
                        value = value.equals("off") ? "MUTE" : String.valueOf(this.zoneVolume[zoneNr - 2]) + "%";
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume.status", "value", value);
                        return;
                    }
                    if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".source")) {
                        SystemState.uiSet(name, "value", this.formatSource(value));
                        return;
                    }
                    if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".source.name")) {
                        SystemState.uiSet(name, "value", this.formatSource(value));
                        return;
                    }
                    if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".sleep")) {
                        value = value.equals("off") ? "OFF" : String.valueOf(value) + " min";
                        SystemState.uiSet(name, "value", value);
                        return;
                    }
                    if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".power")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".power", "value", "ON");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".system.power", "value", "ON");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".power.icon", "img", "on.png");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume", "value", String.valueOf(this.mainVolume) + "%");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume.status", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".sleep", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".source", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".source.name", "visible", "true");
                        return;
                    }
                } else if (name.equals(String.valueOf(this.serverName) + ".z" + zoneNr + ".power")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".power", "value", "OFF");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".power.icon", "img", "off.png");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume", "value", "off");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".volume.status", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".sleep", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".source", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + ".z" + zoneNr + ".source.name", "visible", "false");
                    return;
                }
            }
        }
    }

    private void ioSet(String name, String value) {
        SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
    }

    private String getIP(InetSocketAddress socket) {
        String socketStr = socket.getAddress().toString();
        return socketStr.substring(1);
    }

    private String httpPostRead(String data) throws MalformedURLException {
        String resp = util.httpPostRead((URL)new URL((String)"http", (String)this.getIP((InetSocketAddress)this.serverSocket), (int)this.serverSocket.getPort(), (String)"/YamahaRemoteControl/ctrl"), (String)"text/xml", (String)data, null, null).content;
        if (resp == null) {
            return null;
        }
        return resp.trim();
    }

    private boolean responseProcessor(String data) {
        if (data == null) {
            return false;
        }
        if (data.startsWith("<YAMAHA_AV rsp=\"GET\" ")) {
            if (data.startsWith("RC=\"0\">", 21)) {
                if ((data = this.substringBetween(data, "<YAMAHA_AV rsp=\"GET\" RC=\"0\">", "</YAMAHA_AV>").trim()).startsWith("<Main_Zone>")) {
                    HashMap<String, String> prms = new HashMap<String, String>(17);
                    this.getParameters(data, "", prms);
                    if ("On".equalsIgnoreCase(prms.get(".Main_Zone.Basic_Status.Power_Control.Power"))) {
                        if (this.mainPower != 1) {
                            this.mainPower = 1;
                            this.ioWrite(String.valueOf(this.serverName) + ".main.power", "1");
                        }
                    } else if (this.mainPower != 0) {
                        this.mainPower = 0;
                        this.ioWrite(String.valueOf(this.serverName) + ".main.power", "0");
                    }
                    if (this.mainPower == 1) {
                        String inputName;
                        String input;
                        int valInt;
                        String volume;
                        String sleep = prms.get(".Main_Zone.Basic_Status.Power_Control.Sleep");
                        if (sleep != null) {
                            if ("Off".equalsIgnoreCase(sleep)) {
                                if (this.mainSleep != 0) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".main.sleep", "off");
                                    this.mainSleep = 0;
                                }
                            } else if ("30 min".equalsIgnoreCase(sleep)) {
                                if (this.mainSleep != 30) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".main.sleep", "30");
                                    this.mainSleep = 30;
                                }
                            } else if ("60 min".equalsIgnoreCase(sleep)) {
                                if (this.mainSleep != 60) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".main.sleep", "60");
                                    this.mainSleep = 60;
                                }
                            } else if ("90 min".equalsIgnoreCase(sleep)) {
                                if (this.mainSleep != 90) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".main.sleep", "90");
                                    this.mainSleep = 90;
                                }
                            } else if ("120 min".equalsIgnoreCase(sleep) && this.mainSleep != 120) {
                                this.ioWrite(String.valueOf(this.serverName) + ".main.sleep", "120");
                                this.mainSleep = 120;
                            }
                        }
                        if ((volume = prms.get(".Main_Zone.Basic_Status.Volume.Lvl.Val")) != null && (valInt = Integer.parseInt(volume)) >= -805 && valInt <= 165 && (valInt = (valInt + 805) * 100 / 970) != this.mainVolume) {
                            this.ioWrite(String.valueOf(this.serverName) + ".main.volume", String.valueOf(valInt) + "%");
                            this.mainVolume = valInt;
                        }
                        if ("On".equalsIgnoreCase(prms.get(".Main_Zone.Basic_Status.Volume.Mute"))) {
                            if (this.mainMute != 1) {
                                this.ioWrite(String.valueOf(this.serverName) + ".main.mute", "1");
                                this.mainMute = 1;
                            }
                        } else if (this.mainMute != 0) {
                            this.ioWrite(String.valueOf(this.serverName) + ".main.mute", "0");
                            this.mainMute = 0;
                        }
                        if ((input = prms.get(".Main_Zone.Basic_Status.Input.Input_Sel")) != null && !this.mainInput.equals(input = this.formatEvent(input))) {
                            this.ioWrite(String.valueOf(this.serverName) + ".main.source", input);
                            this.mainInput = input;
                        }
                        if ((inputName = prms.get(".Main_Zone.Basic_Status.Input.Current_Input_Sel_Item.Title")) == null) {
                            inputName = prms.get(".Main_Zone.Basic_Status.Input.Input_Sel_Item_Info.Title");
                        }
                        if (inputName != null && !this.mainInputName.equals(inputName)) {
                            this.ioWrite(String.valueOf(this.serverName) + ".main.source.name", inputName);
                            this.mainInputName = inputName;
                        }
                        if ("On".equalsIgnoreCase(prms.get(".Main_Zone.Basic_Status.Surround.Program_Sel.Current.Straight"))) {
                            if (this.surroundStraight != 1) {
                                this.ioWrite(String.valueOf(this.serverName) + ".main.surround", "straight");
                                this.surroundStraight = 1;
                            }
                        } else {
                            String surroundPrgm = prms.get(".Main_Zone.Basic_Status.Surround.Program_Sel.Current.Sound_Program");
                            if (surroundPrgm != null && !this.surroundProgram.equals(surroundPrgm = this.formatEvent(surroundPrgm))) {
                                this.ioWrite(String.valueOf(this.serverName) + ".main.surround", surroundPrgm);
                                this.surroundProgram = surroundPrgm;
                                this.surroundStraight = 0;
                            }
                        }
                        if ("On".equalsIgnoreCase(prms.get(".Main_Zone.Basic_Status.Surround.Program_Sel.Current.Enhancer"))) {
                            if (this.surroundEnhancer != 1) {
                                this.ioWrite(String.valueOf(this.serverName) + ".main.enhancer", "1");
                                this.surroundEnhancer = 1;
                            }
                        } else if (this.surroundEnhancer != 0) {
                            this.ioWrite(String.valueOf(this.serverName) + ".main.enhancer", "0");
                            this.surroundEnhancer = 0;
                        }
                    }
                } else if (data.startsWith("<Zone_")) {
                    int zoneNum = Integer.parseInt("" + data.charAt(6));
                    HashMap<String, String> prms = new HashMap<String, String>(14);
                    this.getParameters(data, "", prms);
                    if ("On".equalsIgnoreCase(prms.get(".Zone_" + zoneNum + ".Basic_Status.Power_Control.Power"))) {
                        if (this.zonePower[zoneNum - 2] != 1) {
                            this.zonePower[zoneNum - 2] = 1;
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".power", "1");
                        }
                    } else if (this.zonePower[zoneNum - 2] != 0) {
                        this.zonePower[zoneNum - 2] = 0;
                        this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".power", "0");
                    }
                    if (this.zonePower[zoneNum - 2] == 1) {
                        String inputName;
                        String input;
                        String mute;
                        int valInt;
                        String volume;
                        String sleep = prms.get(".Zone_" + zoneNum + ".Basic_Status.Power_Control.Sleep");
                        if (sleep != null) {
                            if ("Off".equalsIgnoreCase(sleep)) {
                                if (this.zoneSleep[zoneNum - 2] != 0) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".sleep", "off");
                                    this.zoneSleep[zoneNum - 2] = 0;
                                }
                            } else if ("30 min".equalsIgnoreCase(sleep)) {
                                if (this.zoneSleep[zoneNum - 2] != 30) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".sleep", "30");
                                    this.zoneSleep[zoneNum - 2] = 30;
                                }
                            } else if ("60 min".equalsIgnoreCase(sleep)) {
                                if (this.zoneSleep[zoneNum - 2] != 60) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".sleep", "60");
                                    this.zoneSleep[zoneNum - 2] = 60;
                                }
                            } else if ("90 min".equalsIgnoreCase(sleep)) {
                                if (this.zoneSleep[zoneNum - 2] != 90) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".sleep", "90");
                                    this.zoneSleep[zoneNum - 2] = 90;
                                }
                            } else if ("120 min".equalsIgnoreCase(sleep) && this.zoneSleep[zoneNum - 2] != 120) {
                                this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".sleep", "120");
                                this.zoneSleep[zoneNum - 2] = 120;
                            }
                        }
                        if ((volume = prms.get(".Zone_" + zoneNum + ".Basic_Status.Volume.Lvl.Val")) != null && (valInt = Integer.parseInt(volume)) >= -805 && valInt <= 165 && (valInt = (valInt + 805) * 100 / 970) != this.zoneVolume[zoneNum - 2]) {
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".volume", String.valueOf(valInt) + "%");
                            this.zoneVolume[zoneNum - 2] = valInt;
                        }
                        if ((mute = prms.get(".Zone_" + zoneNum + ".Basic_Status.Volume.Mute")) != null) {
                            if ("On".equalsIgnoreCase(mute)) {
                                if (this.zoneMute[zoneNum - 2] != 1) {
                                    this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".mute", "1");
                                    this.zoneMute[zoneNum - 2] = 1;
                                }
                            } else if (this.zoneMute[zoneNum - 2] != 0) {
                                this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".mute", "0");
                                this.zoneMute[zoneNum - 2] = 0;
                            }
                        }
                        if ((input = prms.get(".Zone_" + zoneNum + ".Basic_Status.Input.Input_Sel")) != null && !this.zoneInput[zoneNum - 2].equals(input = this.formatEvent(input))) {
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".source", input);
                            this.zoneInput[zoneNum - 2] = input;
                        }
                        if ((inputName = prms.get(".Zone_" + zoneNum + ".Basic_Status.Input.Current_Input_Sel_Item.Title")) == null) {
                            inputName = prms.get(".Zone_" + zoneNum + ".Basic_Status.Input.Input_Sel_Item_Info.Title");
                        }
                        if (inputName != null && !this.zoneInputName[zoneNum - 2].equals(inputName)) {
                            this.ioWrite(String.valueOf(this.serverName) + ".z" + zoneNum + ".source.name", inputName);
                            this.zoneInputName[zoneNum - 2] = inputName;
                        }
                    }
                } else if (data.startsWith("<System>")) {
                    if ((data = this.substringBetween(data, "<System>", "</System>").trim()).startsWith("<Power_Control>")) {
                        data = this.substringBetween(data, "<Power_Control>", "</Power_Control>").trim();
                        if ((data = this.substringBetween(data, "<Power>", "</Power>").trim()).equalsIgnoreCase("On")) {
                            if (this.systemOn != 1) {
                                this.systemOn = 1;
                                this.ioWrite(String.valueOf(this.serverName) + ".system.power", "1");
                            }
                        } else {
                            if (this.systemOn != 0) {
                                this.systemOn = 0;
                                this.ioWrite(String.valueOf(this.serverName) + ".system.power", "0");
                            }
                            if (this.mainPower != 0) {
                                this.mainPower = 0;
                                this.ioWrite(String.valueOf(this.serverName) + ".main.power", "0");
                            }
                            if (this.zonePower[0] != 0) {
                                this.zonePower[0] = 0;
                                this.ioWrite(String.valueOf(this.serverName) + ".z2.power", "0");
                            }
                            if (this.model >= 20) {
                                if (this.zonePower[1] != 0) {
                                    this.zonePower[1] = 0;
                                    this.ioWrite(String.valueOf(this.serverName) + ".z3.power", "0");
                                }
                                if (this.model > 20 && this.zonePower[2] != 0) {
                                    this.zonePower[2] = 0;
                                    this.ioWrite(String.valueOf(this.serverName) + ".z4.power", "0");
                                }
                            }
                        }
                    } else if (data.startsWith("<Party_Mode>") && (data = this.substringBetween(data, "<Party_Mode>", "</Party_Mode>").trim()).startsWith("<Mode>")) {
                        if ((data = this.substringBetween(data, "<Mode>", "</Mode>").trim()).equalsIgnoreCase("On")) {
                            if (this.party != 1) {
                                this.ioWrite(String.valueOf(this.serverName) + ".system.party", "1");
                                this.party = 1;
                            }
                        } else if (this.party != 0) {
                            this.ioWrite(String.valueOf(this.serverName) + ".system.party", "0");
                            this.party = 0;
                        }
                    }
                }
                return true;
            }
            if (data.startsWith("RC=\"2\">", 21)) {
                if ((data = this.substringBetween(data, "<YAMAHA_AV rsp=\"GET\" RC=\"2\">", "</YAMAHA_AV>").trim()).startsWith("<Zone_3><Basic_Status>")) {
                    this.model = 10;
                } else if (data.startsWith("<Zone_4><Basic_Status>")) {
                    this.model = 20;
                } else if (data.startsWith("<System><Party_Mode>")) {
                    this.checkPartyMode = false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private String substringBetween(String s, String start, String end) {
        int startIdx = s.indexOf(start) + start.length();
        int endIdx = s.indexOf(end);
        return s.substring(startIdx, endIdx);
    }

    private void getParameters(String cmd, String parent, HashMap<String, String> prms) {
        if (!(cmd = cmd.trim()).startsWith("<")) {
            prms.put(parent, cmd);
        } else {
            String innerBlock;
            String nextField;
            do {
                nextField = this.substringBetween(cmd, "<", ">");
                innerBlock = this.substringBetween(cmd, "<" + nextField + ">", "</" + nextField + ">");
                this.getParameters(innerBlock, String.valueOf(parent) + "." + nextField, prms);
            } while (!(cmd = cmd.substring(("<" + nextField + ">" + innerBlock + "</" + nextField + ">").length())).equals(""));
        }
    }

    private String formatSource(String source) {
        if (source.equalsIgnoreCase("vaux")) {
            return "V-AUX";
        }
        if (source.equalsIgnoreCase("multich")) {
            return "MULTI CH";
        }
        if (source.equalsIgnoreCase("ipod")) {
            return "iPod";
        }
        if (source.equalsIgnoreCase("netradio")) {
            return "NET RADIO";
        }
        return source.toUpperCase();
    }

    private String formatSurround(String mode) {
        if (mode.equalsIgnoreCase("hallinmunich")) {
            return "Hall in Munich";
        }
        if (mode.equalsIgnoreCase("hallinvienna")) {
            return "Hall in Vienna";
        }
        if (mode.equalsIgnoreCase("chamber")) {
            return "Chamber";
        }
        if (mode.equalsIgnoreCase("cellarclub")) {
            return "Cellar Club";
        }
        if (mode.equalsIgnoreCase("theroxytheatre")) {
            return "The Roxy Theatre";
        }
        if (mode.equalsIgnoreCase("thebottomline")) {
            return "The Bottom Line";
        }
        if (mode.equalsIgnoreCase("sports")) {
            return "Sports";
        }
        if (mode.equalsIgnoreCase("actiongame")) {
            return "Action Game";
        }
        if (mode.equalsIgnoreCase("roleplayinggame")) {
            return "Roleplaying Game";
        }
        if (mode.equalsIgnoreCase("musicvideo")) {
            return "Music Video";
        }
        if (mode.equalsIgnoreCase("standard")) {
            return "Standard";
        }
        if (mode.equalsIgnoreCase("spectacle")) {
            return "Spectacle";
        }
        if (mode.equalsIgnoreCase("scifi")) {
            return "Sci-Fi";
        }
        if (mode.equalsIgnoreCase("adventure")) {
            return "Adventure";
        }
        if (mode.equalsIgnoreCase("drama")) {
            return "Drama";
        }
        if (mode.equalsIgnoreCase("monomovie")) {
            return "Mono Movie";
        }
        if (mode.equalsIgnoreCase("2chstereo")) {
            return "2ch Stereo";
        }
        if (mode.equalsIgnoreCase("7chstereo")) {
            return "7ch Stereo";
        }
        if (mode.equalsIgnoreCase("surrounddecoder")) {
            return "Surround Decoder";
        }
        return mode;
    }

    private String formatEvent(String mode) {
        mode = mode.toLowerCase();
        mode = mode.replaceAll(" ", "");
        mode = mode.replaceAll("-", "");
        return mode;
    }
}

