/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Schedule;
import com.hsyco.State;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class UserScheduler {
    private static File schedulerFile = new File("scheduler.ini");
    private static Vector<Schedule> SchedulesList = new Vector();
    private static Hashtable<String, State> SchedulesState = new Hashtable();
    private static long stateTime = -1L;
    private static long calendarTime = -1L;
    private static final Executor exec = Executors.newCachedThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String read(long timestamp) throws Exception {
        boolean wait = false;
        StringBuffer sb = new StringBuffer();
        Vector<Schedule> vector = SchedulesList;
        synchronized (vector) {
            if (stateTime <= 0L) {
                sb.append("{\"calendar\":\"empty\"}");
            } else if (timestamp == stateTime) {
                sb.append("{\"statets\":");
                sb.append(stateTime);
                sb.append(",\"calendarts\":");
                sb.append(calendarTime);
                sb.append(",\"calendar\":\"null\"}");
                wait = true;
            } else {
                sb.append("{\"statets\":");
                sb.append(stateTime);
                sb.append(",\"calendarts\":");
                sb.append(calendarTime);
                sb.append(",\"calendar\":[");
                int i2 = 0;
                while (i2 < SchedulesList.size()) {
                    Schedule s = SchedulesList.elementAt(i2);
                    sb.append(i2 > 0 ? ",[\"" : "[\"");
                    sb.append(s.name);
                    sb.append("\",\"");
                    switch (s.state) {
                        case 0: {
                            sb.append("off");
                            break;
                        }
                        case 1: {
                            sb.append("on");
                            break;
                        }
                        default: {
                            sb.append("undef");
                        }
                    }
                    sb.append("\",\"");
                    sb.append(s.daily_mode);
                    sb.append("\",\"");
                    sb.append(s.date_from);
                    sb.append("\",\"");
                    sb.append(s.time_from);
                    sb.append("\",\"");
                    sb.append(s.date_to);
                    sb.append("\",\"");
                    sb.append(s.time_to);
                    sb.append("\",\"");
                    sb.append(s.dow);
                    sb.append("\",\"");
                    sb.append(s.repeat_on);
                    sb.append("\",\"");
                    sb.append(s.repeat_off);
                    sb.append("\",\"");
                    sb.append(s.lock);
                    sb.append("\",\"");
                    sb.append(s.enabled);
                    sb.append("\",\"");
                    sb.append(URLEncoder.encode(s.description, "UTF-8").replace('+', ' '));
                    sb.append("\"]");
                    ++i2;
                }
                sb.append("]}");
            }
        }
        if (wait) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String write(String query) {
        Vector<Schedule> vector = SchedulesList;
        synchronized (vector) {
            block12: {
                try {
                    String[] sa = query.split("[,]");
                    long ts = Long.parseLong(sa[0]);
                    if (ts != schedulerFile.lastModified()) {
                        return "error";
                    }
                    if (sa[1].equals("new")) {
                        int line = Integer.parseInt(sa[2]);
                        Schedule sched = new Schedule(sa[3], URLDecoder.decode(sa[4], "UTF-8"), Boolean.parseBoolean(sa[5]), sa[6], sa[8], sa[7], sa[9], sa[10], Integer.parseInt(sa[11]), Integer.parseInt(sa[12]), Boolean.parseBoolean(sa[13]), Boolean.parseBoolean(sa[14]));
                        SchedulesList.add(line - 1, sched);
                        UserScheduler.save();
                        break block12;
                    }
                    if (sa[1].equals("edit")) {
                        int line = Integer.parseInt(sa[2]);
                        Schedule sched = new Schedule(sa[3], URLDecoder.decode(sa[4], "UTF-8"), Boolean.parseBoolean(sa[5]), sa[6], sa[8], sa[7], sa[9], sa[10], Integer.parseInt(sa[11]), Integer.parseInt(sa[12]), Boolean.parseBoolean(sa[13]), Boolean.parseBoolean(sa[14]));
                        SchedulesList.set(line - 1, sched);
                        UserScheduler.save();
                        break block12;
                    }
                    if (sa[1].equals("move")) {
                        int line = Integer.parseInt(sa[4]);
                        int linefrom = Integer.parseInt(sa[2]);
                        Schedule sched = SchedulesList.get(linefrom - 1);
                        if (line <= 0) return "error";
                        if (line > SchedulesList.size()) return "error";
                        if (!sched.name.equals(sa[3])) {
                            return "error";
                        }
                        if (line == linefrom) return "error";
                        SchedulesList.remove(linefrom - 1);
                        SchedulesList.insertElementAt(sched, line - 1);
                        UserScheduler.save();
                    } else {
                        if (!sa[1].equals("delete")) return "error";
                        int line = Integer.parseInt(sa[2]);
                        Schedule sched = SchedulesList.get(line - 1);
                        if (!sched.name.equals(sa[3])) {
                            return "error";
                        }
                        SchedulesList.remove(line - 1);
                        UserScheduler.save();
                    }
                }
                catch (Exception e2) {
                    return "error";
                }
            }
            return "ack";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int state(String name) {
        Vector<Schedule> vector = SchedulesList;
        synchronized (vector) {
            try {
                return UserScheduler.SchedulesState.get((Object)name).state;
            }
            catch (Exception e2) {
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute() {
        Calendar now = Calendar.getInstance();
        long nowmillis = now.getTimeInMillis();
        Vector<Schedule> vector = SchedulesList;
        synchronized (vector) {
            State state;
            UserScheduler.load();
            Enumeration<String> e2 = SchedulesState.keys();
            while (e2.hasMoreElements()) {
                state = SchedulesState.get(e2.nextElement());
                state.matched = false;
                state.date_match = false;
            }
            int i2 = 0;
            while (i2 < SchedulesList.size()) {
                int newstate;
                Schedule schedule = SchedulesList.get(i2);
                if (schedule.enabled) {
                    state = SchedulesState.get(schedule.name);
                    if (state == null) {
                        state = new State(schedule.trigger_mode);
                        SchedulesState.put(schedule.name, state);
                    }
                    if (!state.matched) {
                        if (schedule.match(now)) {
                            if (schedule.trigger_mode) {
                                if (state.date_match && schedule.date_from.equals("*") && schedule.date_to.equals("*")) {
                                    newstate = 0;
                                } else {
                                    newstate = 1;
                                    if (state.state != 1) {
                                        try {
                                            if (userCode.UserTimerEvent(schedule.name, true)) {
                                                stateTime = nowmillis;
                                                state.state = 1;
                                                state.line = i2 + 1;
                                                UserScheduler.onevent(schedule.name, i2 + 1);
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            } else {
                                state.matched = true;
                                if (schedule.lock) {
                                    newstate = 0;
                                    if (state.state == 1) {
                                        try {
                                            if (userCode.UserTimerEvent(schedule.name, false)) {
                                                stateTime = nowmillis;
                                                state.state = 0;
                                                UserScheduler.offevent(schedule.name, i2 + 1);
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                } else {
                                    newstate = 1;
                                    if (state.state != 1) {
                                        try {
                                            if (userCode.UserTimerEvent(schedule.name, true)) {
                                                stateTime = nowmillis;
                                                state.state = 1;
                                                state.line = i2 + 1;
                                                UserScheduler.onevent(schedule.name, i2 + 1);
                                            }
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        } else {
                            newstate = 0;
                        }
                    } else {
                        newstate = 0;
                    }
                    if (schedule.daterangematch(now)) {
                        state.date_match = true;
                    }
                } else {
                    newstate = 0;
                }
                if (newstate != schedule.state) {
                    schedule.state = newstate;
                    stateTime = nowmillis;
                }
                ++i2;
            }
            e = SchedulesState.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                state = SchedulesState.get(name);
                if (state.matched || state.state != 1) continue;
                if (state.trigger_mode) {
                    stateTime = nowmillis;
                    state.state = 0;
                    continue;
                }
                try {
                    if (!userCode.UserTimerEvent(name, false)) continue;
                    stateTime = nowmillis;
                    state.state = 0;
                    UserScheduler.offevent(name, state.line);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void onevent(String name, int line) {
        hsyco.messageLog("SCHEDULER TIMER ACTIVATION: " + name + " LINE: " + line);
        final String s = new String(name);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                events.eventsExec("TIMER" + s, 1, 0, null);
            }
        };
        exec.execute(task);
    }

    private static void offevent(String name, int line) {
        if (line > 0) {
            hsyco.messageLog("SCHEDULER TIMER RESET: " + name + " LINE: " + line);
        } else {
            hsyco.messageLog("SCHEDULER TIMER RESET: " + name);
        }
        final String s = new String(name);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                events.eventsExec("TIMER" + s, 0, 0, null);
            }
        };
        exec.execute(task);
    }

    static void load() {
        block27: {
            int line = 0;
            String name = null;
            String description = null;
            boolean daily_mode = false;
            String date_from = null;
            String date_to = null;
            String time_from = null;
            String time_to = null;
            String dow = null;
            int repeat_on = 0;
            int repeat_off = 0;
            boolean lock = false;
            boolean enabled = true;
            try {
                long t = schedulerFile.lastModified();
                if (t == calendarTime) break block27;
                if (t > 0L) {
                    String fl;
                    BufferedReader fis = new BufferedReader(new FileReader(schedulerFile));
                    SchedulesList.clear();
                    while ((fl = fis.readLine()) != null) {
                        boolean skipthisline = false;
                        ++line;
                        if ((fl = util.trimComments(fl)).length() > 0) {
                            String[] sa = fl.split(";");
                            if (sa.length != 12) {
                                hsyco.errorLog("Error reading scheduler.ini file: syntax error, line: " + line + " [" + fl + "]");
                                skipthisline = true;
                            } else {
                                name = sa[0].trim();
                                if (name.length() == 0 || name.indexOf(32) != -1) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid name, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                description = sa[1].trim();
                                try {
                                    daily_mode = Boolean.parseBoolean(sa[2].trim());
                                }
                                catch (Exception e2) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid daily mode flag, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                date_from = sa[3].trim();
                                if (!date_from.equals("*") && !UserScheduler.isValidDate(date_from)) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid start date, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                if (!(time_from = sa[4].trim()).equals("*") && !UserScheduler.isValidTime(time_from)) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid start time, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                if (!(date_to = sa[5].trim()).equals("*") && !UserScheduler.isValidDate(date_to)) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid end date, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                if (!((time_to = sa[6].trim()).equals("*") || time_to.equals("-") || UserScheduler.isValidTime(time_to))) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid end time, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                if (!(dow = sa[7].trim()).equals("*") && !UserScheduler.isValidDow(dow)) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid days of week, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                try {
                                    repeat_on = Integer.parseInt(sa[8].trim());
                                    if (repeat_on < 0) {
                                        hsyco.errorLog("Error reading scheduler.ini file: invalid repeat on time, line: " + line + " [" + fl + "]");
                                        skipthisline = true;
                                    }
                                }
                                catch (Exception e3) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid repeat on time, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                try {
                                    repeat_off = Integer.parseInt(sa[9].trim());
                                    if (repeat_off < 0) {
                                        hsyco.errorLog("Error reading scheduler.ini file: invalid repeat off time, line: " + line + " [" + fl + "]");
                                        skipthisline = true;
                                    }
                                }
                                catch (Exception e4) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid repeat off time, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                try {
                                    lock = Boolean.parseBoolean(sa[10].trim());
                                }
                                catch (Exception e5) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid lock flag, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                                try {
                                    enabled = Boolean.parseBoolean(sa[11].trim());
                                }
                                catch (Exception e6) {
                                    hsyco.errorLog("Error reading scheduler.ini file: invalid enabled flag, line: " + line + " [" + fl + "]");
                                    skipthisline = true;
                                }
                            }
                        }
                        if (skipthisline) continue;
                        try {
                            SchedulesList.add(new Schedule(name, description, daily_mode, date_from, date_to, time_from, time_to, dow, repeat_on, repeat_off, lock, enabled));
                        }
                        catch (Exception e7) {
                            hsyco.errorLog("Error reading scheduler.ini file: data error, line: " + line + " [" + fl + "]");
                            skipthisline = true;
                        }
                    }
                    calendarTime = t;
                    stateTime = System.currentTimeMillis();
                    fis.close();
                    SystemState.haFilesChangeNotify();
                    hsyco.messageLog("ALERT: scheduler.ini file reloaded");
                    break block27;
                }
                SchedulesList.clear();
                calendarTime = 0L;
                stateTime = System.currentTimeMillis();
                SystemState.haFilesChangeNotify();
                hsyco.messageLog("ALERT: scheduler.ini file deleted");
            }
            catch (Exception e8) {
                calendarTime = -1L;
            }
        }
    }

    private static void save() {
        File destFile = new File("scheduler.ini");
        File tempFile = new File(util.isWindows ? "_scheduler.ini" : ".~scheduler.ini");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(tempFile)));
            int i2 = 0;
            while (i2 < SchedulesList.size()) {
                StringBuffer sb = new StringBuffer();
                Schedule s = SchedulesList.elementAt(i2);
                sb.append(s.name);
                sb.append(';');
                sb.append(s.description);
                sb.append(';');
                sb.append(s.daily_mode);
                sb.append(';');
                sb.append(s.date_from);
                sb.append(';');
                sb.append(s.time_from);
                sb.append(';');
                sb.append(s.date_to);
                sb.append(';');
                sb.append(s.time_to);
                sb.append(';');
                sb.append(s.dow);
                sb.append(';');
                sb.append(s.repeat_on);
                sb.append(';');
                sb.append(s.repeat_off);
                sb.append(';');
                sb.append(s.lock);
                sb.append(';');
                sb.append(s.enabled);
                out.println(sb.toString());
                ++i2;
            }
            out.flush();
            out.close();
            if (util.isWindows) {
                destFile.delete();
            }
            tempFile.renameTo(destFile);
            destFile.setWritable(true, false);
            calendarTime = destFile.lastModified();
            stateTime = System.currentTimeMillis();
            SystemState.haFilesChangeNotify();
            hsyco.messageLog("ALERT: scheduler.ini file saved");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean isValidDate(String date) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setLenient(false);
            if (date.startsWith("*")) {
                cal.set(1, Integer.parseInt(date.substring(1, 5)));
                cal.set(2, Integer.parseInt(date.substring(5, 7)) - 1);
                cal.set(5, Integer.parseInt(date.substring(7)));
            } else {
                cal.set(1, Integer.parseInt(date.substring(0, 4)));
                cal.set(2, Integer.parseInt(date.substring(4, 6)) - 1);
                cal.set(5, Integer.parseInt(date.substring(6)));
            }
            cal.getTimeInMillis();
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    static boolean isValidTime(String time) {
        try {
            int hour = Integer.parseInt(time.substring(0, 2));
            int minute = Integer.parseInt(time.substring(2));
            return hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static boolean isValidDow(String dow) {
        try {
            int l2 = dow.length();
            if (l2 > 0 && l2 < 8) {
                int i2 = 0;
                while (i2 < l2) {
                    char c2 = dow.charAt(i2);
                    if (c2 < '1' || c2 > '7') {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }
}

