/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Tlab {
    private static final int NUM_ZF_WEB80 = 40;
    private static final int NUM_ZF_WEB144 = 104;
    private static final int[] NUM_ZF = new int[]{40, 104};
    private static final int NUM_ZR = 40;
    private static final int NUM_KEYB = 8;
    private static final int NUM_USR_WEB80 = 16;
    private static final int NUM_USR_WEB144 = 64;
    private static final int[] NUM_USR = new int[]{16, 64};
    private static final int NUM_EXP_WEB80 = 4;
    private static final int NUM_EXP_WEB144 = 12;
    private static final int[] NUM_EXP = new int[]{4, 12};
    private static final int NUM_LOG = 200;
    private static final int OUTLNGHT_WEB80 = 42;
    private static final int OUTLNGHT_WEB144 = 56;
    private static final int[] OUTLNGHT = new int[]{42, 56};
    private static final int NOME_LNGHT = 16;
    private static final int ZN_STRCT_LNGHT = 46;
    private static final int SYS_STRCT_LNGHT = 16;
    private static final int EXP_LNGHT_WEB80 = 128;
    private static final int EXP_LNGHT_WEB144 = 170;
    private static final int[] EXP_LNGHT = new int[]{128, 170};
    private static final int AREE_GRU_LNGHT = 4;
    private static final int KEYB_LNGHT = 24;
    private static final int USR_LNGHT = 32;
    private static final int INS_ALL_LNGHT = 6;
    private static final int RFTX_LNGHT_WEB80 = 32;
    private static final int RFTX_LNGHT_WEB144 = 44;
    private static final int CPU_LNGHT_WEB80 = 126;
    private static final int CPU_LNGHT_WEB144 = 168;
    private static final int EM_MED_LNGHT = 18;
    private static final int TMR_LNGHT_WEB80 = 32;
    private static final int TMR_LNGHT_WEB144 = 36;
    private static final int LOG_LNGHT = 16;
    private static final int ZF01EEADDR = 16;
    private static final int ZR01EEADDR_WEB80 = 1856;
    private static final int ZR01EEADDR_WEB144 = 4800;
    private static final int[] ZR01EEADDR = new int[]{1856, 4800};
    private static final int SystemAddr_WEB80 = 3696;
    private static final int SystemAddr_WEB144 = 6640;
    private static final int AREA1ADDR_WEB80 = 3712;
    private static final int AREA1ADDR_WEB144 = 6656;
    private static final int[] AREA1ADDR = new int[]{3712, 6656};
    private static final int A4GruppoDAddr_WEB80 = 4016;
    private static final int A4GruppoDAddr_WEB144 = 6960;
    private static final int ExpAddr_WEB80 = 4032;
    private static final int ExpAddr_WEB144 = 6976;
    private static final int[] ExpAddr = new int[]{4032, 6976};
    private static final int AreeGruppiAddr_WEB80 = 4544;
    private static final int AreeGruppiAddr_WEB144 = 9016;
    private static final int[] AreeGruppiAddr = new int[]{4544, 9016};
    private static final int Tast1_8Addr_WEB80 = 4548;
    private static final int Tast1_8Addr_WEB144 = 9020;
    private static final int UserAddr_WEB80 = 4740;
    private static final int UserAddr_WEB144 = 9212;
    private static final int[] UserAddr = new int[]{4740, 9212};
    private static final int InsAllAddr_WEB80 = 5252;
    private static final int InsAllAddr_WEB144 = 11260;
    private static final int[] InsAllAddr = new int[]{5252, 11260};
    private static final int RFTX_Addr_WEB80 = 5258;
    private static final int RFTX_Addr_WEB144 = 11266;
    private static final int CPUAddr_WEB80 = 5514;
    private static final int CPUAddr_WEB144 = 11618;
    private static final int[] CPUAddr = new int[]{5514, 11618};
    private static final int EmMedicaAddr_WEB80 = 5640;
    private static final int EmMedicaAddr_WEB144 = 11786;
    private static final int TmrAddr_WEB80 = 5784;
    private static final int TmrAddr_WEB144 = 11930;
    private static final int LogAddr_WEB80 = 6040;
    private static final int LogAddr_WEB144 = 12218;
    private static final int[] LogAddr = new int[]{6040, 12218};
    private static final int IdxLogAddr_WEB80 = 9240;
    private static final int IdxLogAddr_WEB144 = 15418;
    private static final int[] IdxLogAddr = new int[]{9240, 15418};
    private static final char[] PREFIX_LETTERS = new char[]{'t', 'a', 'b', 'c', 'd'};
    private static final String[] ARMED = new String[]{"Armed - ", "Inserimento - ", "Insertion - "};
    private static final String[] DISARMED = new String[]{"Disarmed - ", "Disinserimento - ", "D\ufffdsarmant - "};
    private static final String[] KEYPAD = new String[]{"Keypad ", "Tastiera ", "Clavier "};
    private static final String[] CONCENTRATOR = new String[]{"Concentrator ", "Concentratore ", "Concentrateur "};
    private static final String[] QUICK_ARM = new String[]{"Quick arm", "Inserimento rapido", "Insertion rapide"};
    private static final String[] KEY_POINT = new String[]{"Key point ", "Punto chiave ", "Point cl\ufffd "};
    private static final String[] TIMER = new String[]{"Timer ", "Timer ", "Timer "};
    private static final String[] READER = new String[]{"Reader ", "Lettore ", "Lecteur "};
    private static final String[] SMS = new String[]{"SMS", "SMS", "SMS"};
    private static final String[] SOFTWARE = new String[]{"Software", "Software", "Software"};
    private static final String[] ALARM = new String[]{"Alarm - ", "Allarme - ", "Alarme - "};
    private static final String[] TAMPER = new String[]{"Tamper - ", "Manomissione - ", "Falsification - "};
    private static final String[] ROBBERY = new String[]{"Robbery - ", "Rapina - ", "Brigantage - "};
    private static final String[] TECHNICIAN = new String[]{"Technician - ", "Tecnico - ", "Technique - "};
    private static final String[] TECH_FAULT = new String[]{"Technical fault - ", "Guasto tecnico - ", "D\ufffdfectueux Technique - "};
    private static final String[] FIRE = new String[]{"Fire - ", "Incendio - ", "Feu - "};
    private static final String[] MEDICAL_EM = new String[]{"Medical emergency - ", "Emergenza medica - ", "M\ufffddicaux Urgence - "};
    private static final String[] FLOODING = new String[]{"Flooding - ", "Allagamento - ", "Inondation - "};
    private static final String[] COERCION = new String[]{"Coercion - ", "Coercizione - ", "Coercition - "};
    private static final String[] INTERFERENCE = new String[]{"RF interference", "Interferenza RF", "Ing\ufffdrence RF"};
    private static final String[] SUPERV = new String[]{"Radio zone supervision - ", "Supervisione zona radio - ", "Surveillance Zone Radio - "};
    private static final String[] NO_LINE = new String[]{"No line", "No rete", "No R\ufffdseau"};
    private static final String[] LOW_BATT = new String[]{"Low battery - ", "Batteria scarica - ", "Batterie D\ufffdcharger - "};
    private static final String[] MAINTENANCE = new String[]{"Maintenance", "Manutenzione", "Entretien"};
    private static final String[] SYSTEM = new String[]{"System", "Sistema", "Syst\ufffdme"};
    private static final String[] PSTN_FAULT = new String[]{"PSTN fault", "Anomalia PSTN", "Anomalie PSTN"};
    private static final String[] GSM_FAULT = new String[]{"GSM fault", "Anomalia GSM", "Anomalie GSM"};
    private static final String[] GSM_CREDIT = new String[]{"GSM credit", "Credito GSM", "Cr\ufffddit GSM"};
    private static final String[] RESET_CPU = new String[]{"CPU reset", "Reset CPU", "Reset CPU"};
    private static final String[] ADDR_ERROR = new String[]{"Address error", "Errore indirizzo", "Erreur Adresse"};
    private String serverName;
    private String commPort;
    private ArrayBlockingQueue<String> ioqtx;
    private int language;
    private boolean guiSupport = true;
    private boolean genEvents = false;
    private long pollinterval = 1000L;
    private int panel_version = 1;
    private HashMap<Integer, WiredZone> wiredZones = new HashMap();
    private HashMap<Integer, RadioZone> radioZones = new HashMap();
    private HashMap<Integer, Area> areas = new HashMap(4);
    private HashMap<Integer, User> users = new HashMap();
    private HashMap<Integer, Expander> expanders = new HashMap();
    private String[] cpuOutNames = new String[3];
    private static final byte[] STATUS_REQ;
    private final byte[] EEPROM_READ_REQ;
    private final byte[] GROUP_SET_ARMED;
    private final byte[] ZONE_SET_BYPASSED;
    private final byte[] OUTPUT_SET;
    private int exitDelay;
    private int gsmFault;
    private int pstnFault;
    private int lineFault;
    private int rfi;
    private int batteryFault;
    private int tamper;
    private int coercion;
    private int supervision;
    private int lowCredit;
    private int output1;
    private int output2;
    private int output3;
    private int sys_alarm;
    private int sys_alarm_mem;
    private int sys_armed;
    private int lastLogEntry;
    private long logTime;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 64;
        byArray[1] = 83;
        byArray[3] = 83;
        STATUS_REQ = byArray;
    }

    public Tlab() {
        byte[] byArray = new byte[6];
        byArray[0] = 64;
        byArray[1] = 82;
        this.EEPROM_READ_REQ = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[0] = 64;
        byArray2[1] = 77;
        this.GROUP_SET_ARMED = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[0] = 64;
        byArray3[1] = 77;
        byArray3[5] = -128;
        this.ZONE_SET_BYPASSED = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[0] = 64;
        byArray4[1] = 87;
        byArray4[2] = 6;
        byArray4[4] = 4;
        byArray4[5] = 5;
        byArray4[6] = 9;
        this.OUTPUT_SET = byArray4;
        this.exitDelay = -2;
        this.gsmFault = -2;
        this.pstnFault = -2;
        this.lineFault = -2;
        this.rfi = -2;
        this.batteryFault = -2;
        this.tamper = -2;
        this.coercion = -2;
        this.supervision = -2;
        this.lowCredit = -2;
        this.output1 = -2;
        this.output2 = -2;
        this.output3 = -2;
        this.sys_alarm = -2;
        this.sys_alarm_mem = -2;
        this.sys_armed = -2;
    }

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl * 1000;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                }
            }
            ++i2;
        }
        switch (Configuration.language) {
            case 1: {
                this.language = 1;
                break;
            }
            case 2: {
                this.language = 2;
                break;
            }
            default: {
                this.language = 0;
            }
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 29, this);
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init();
            boolean ok = this.polling();
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
            this.uiSet("log", "HSYCO ONLINE");
            Logger.log(Logger.Mode.SECURITY, "HSYCO ONLINE", this.serverName);
            this.genEvents = true;
            String cmd = null;
            while (!me.quit) {
                cmd = this.ioqtx.poll(this.pollinterval, TimeUnit.MILLISECONDS);
                if (cmd != null) {
                    do {
                        if (this.processCommand(cmd)) continue;
                        ok = false;
                    } while ((cmd = this.ioqtx.poll()) != null);
                }
                if (!this.polling()) {
                    ok = false;
                }
                this.uiUpdate();
                if (ok) {
                    me.heartbeat = System.currentTimeMillis();
                }
                ok = true;
            }
        }
        catch (Exception e4) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e4.getLocalizedMessage(), this.serverName);
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.ioWrite(true, "connection", "offline");
        this.uiSet("log", "HSYCO OFFLINE");
        Logger.log(Logger.Mode.SECURITY, "HSYCO OFFLINE", this.serverName);
    }

    private void init() throws Exception {
        try {
            byte[] resp;
            int addr;
            this.EEPROM_READ_REQ[4] = 46;
            int i2 = 0;
            while (i2 < NUM_ZF[this.panel_version]) {
                addr = 16 + i2 * 46;
                this.EEPROM_READ_REQ[3] = (byte)(addr >>> 8 & 0xFF);
                this.EEPROM_READ_REQ[2] = (byte)(addr & 0xFF);
                this.addCRC(this.EEPROM_READ_REQ);
                resp = this.send(this.EEPROM_READ_REQ, 52);
                if (resp == null) {
                    throw new Exception("wired zone " + i2 + " status request fail");
                }
                this.processWiredZone(i2 + 1, resp);
                ++i2;
            }
            i2 = 0;
            while (i2 < 40) {
                addr = ZR01EEADDR[this.panel_version] + i2 * 46;
                this.EEPROM_READ_REQ[3] = (byte)(addr >>> 8 & 0xFF);
                this.EEPROM_READ_REQ[2] = (byte)(addr & 0xFF);
                this.addCRC(this.EEPROM_READ_REQ);
                resp = this.send(this.EEPROM_READ_REQ, 52);
                if (resp == null) {
                    throw new Exception("radio zone " + i2 + " status request fail");
                }
                this.processRadioZone(i2 + 1, resp);
                ++i2;
            }
            i2 = 0;
            while (i2 < 4) {
                this.EEPROM_READ_REQ[4] = 1;
                addr = AreeGruppiAddr[this.panel_version] + i2;
                this.EEPROM_READ_REQ[3] = (byte)(addr >>> 8 & 0xFF);
                this.EEPROM_READ_REQ[2] = (byte)(addr & 0xFF);
                this.addCRC(this.EEPROM_READ_REQ);
                resp = this.send(this.EEPROM_READ_REQ, 7);
                if (resp == null) {
                    throw new Exception("Area " + i2 + " status request fail");
                }
                if ((resp[5] & 0x1F) > 0) {
                    this.EEPROM_READ_REQ[4] = 80;
                    int nameAddr = AREA1ADDR[this.panel_version] + i2 * 16 * 5;
                    this.EEPROM_READ_REQ[3] = (byte)(nameAddr >>> 8 & 0xFF);
                    this.EEPROM_READ_REQ[2] = (byte)(nameAddr & 0xFF);
                    this.addCRC(this.EEPROM_READ_REQ);
                    byte[] nameResp = this.send(this.EEPROM_READ_REQ, 86);
                    if (nameResp == null) {
                        throw new Exception("Area " + i2 + " name request fail");
                    }
                    this.processArea(i2 + 1, resp[5], nameResp);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < NUM_EXP[this.panel_version]) {
                this.EEPROM_READ_REQ[4] = 1;
                addr = ExpAddr[this.panel_version] + i2 * EXP_LNGHT[this.panel_version] + 1;
                this.EEPROM_READ_REQ[3] = (byte)(addr >>> 8 & 0xFF);
                this.EEPROM_READ_REQ[2] = (byte)(addr & 0xFF);
                this.addCRC(this.EEPROM_READ_REQ);
                resp = this.send(this.EEPROM_READ_REQ, 7);
                if (resp == null) {
                    throw new Exception("expander " + i2 + " status request fail");
                }
                if (resp[5] != 0) {
                    this.EEPROM_READ_REQ[4] = 16;
                    byte[][] namesResp = new byte[3][];
                    int o2 = 0;
                    while (o2 < 3) {
                        int nameAddr = addr + 1 + o2 * OUTLNGHT[this.panel_version];
                        this.EEPROM_READ_REQ[3] = (byte)(nameAddr >>> 8 & 0xFF);
                        this.EEPROM_READ_REQ[2] = (byte)(nameAddr & 0xFF);
                        this.addCRC(this.EEPROM_READ_REQ);
                        namesResp[o2] = this.send(this.EEPROM_READ_REQ, 22);
                        ++o2;
                    }
                    this.processExpander(i2 + 1, namesResp);
                }
                ++i2;
            }
            this.EEPROM_READ_REQ[4] = 32;
            i2 = 0;
            while (i2 < NUM_USR[this.panel_version]) {
                addr = UserAddr[this.panel_version] + i2 * 32;
                this.EEPROM_READ_REQ[3] = (byte)(addr >>> 8 & 0xFF);
                this.EEPROM_READ_REQ[2] = (byte)(addr & 0xFF);
                this.addCRC(this.EEPROM_READ_REQ);
                resp = this.send(this.EEPROM_READ_REQ, 38);
                if (resp == null) {
                    throw new Exception("user " + i2 + " status request fail");
                }
                this.processUser(i2 + 1, resp);
                ++i2;
            }
            this.EEPROM_READ_REQ[4] = (byte)OUTLNGHT[this.panel_version];
            i2 = 0;
            while (i2 < 3) {
                addr = CPUAddr[this.panel_version] + i2 * OUTLNGHT[this.panel_version];
                this.EEPROM_READ_REQ[3] = (byte)(addr >>> 8 & 0xFF);
                this.EEPROM_READ_REQ[2] = (byte)(addr & 0xFF);
                this.addCRC(this.EEPROM_READ_REQ);
                resp = this.send(this.EEPROM_READ_REQ, OUTLNGHT[this.panel_version] + 6);
                if (resp == null) {
                    throw new Exception("CPU out " + i2 + " status request fail");
                }
                this.processCPUOut(i2, resp);
                ++i2;
            }
            String savedIndex = userBase.varGet("_tlab." + this.serverName + ".lastlogentry!");
            try {
                this.lastLogEntry = Integer.parseInt(savedIndex);
                if (this.lastLogEntry < LogAddr[this.panel_version] - 16) {
                    this.lastLogEntry = LogAddr[this.panel_version] - 16;
                }
            }
            catch (Exception e2) {
                this.lastLogEntry = LogAddr[this.panel_version] - 16;
            }
        }
        catch (Exception e3) {
            throw new Exception("Initialization error: " + e3.getLocalizedMessage());
        }
    }

    private void processExpander(int index, byte[][] data) {
        Expander e2 = new Expander(index);
        int i2 = 0;
        while (i2 < 3) {
            StringBuffer name = new StringBuffer();
            int c2 = 5;
            while (c2 < 21) {
                name.append((char)data[i2][c2]);
                ++c2;
            }
            e2.setOutputName(i2 + 1, name.toString());
            ++i2;
        }
        this.expanders.put(index, e2);
    }

    private void processCPUOut(int index, byte[] data) {
        StringBuffer name = new StringBuffer();
        int c2 = 5;
        while (c2 < 21) {
            name.append((char)data[c2]);
            ++c2;
        }
        this.cpuOutNames[index] = name.toString();
        this.ioWrite(this.genEvents, "out" + (index + 1) + ".name", name.toString());
    }

    private void processUser(int index, byte[] data) {
        if ((data[31] & 0x80) == 128) {
            StringBuffer name = new StringBuffer();
            int i2 = 5;
            while (i2 < 21) {
                name.append((char)data[i2]);
                ++i2;
            }
            this.users.put(index, new User(index, name.toString()));
        }
    }

    private void processArea(int index, byte groupsData, byte[] nameData) {
        int i2;
        StringBuffer name;
        StringBuffer areaName = new StringBuffer();
        int i3 = 5;
        while (i3 < 21) {
            areaName.append((char)nameData[i3]);
            ++i3;
        }
        Area a2 = new Area(index, areaName.toString());
        this.areas.put(index, a2);
        if ((groupsData & 1) == 1) {
            a2.addGroup(0, areaName.toString());
        }
        if ((groupsData >>> 1 & 1) == 1) {
            name = new StringBuffer();
            i2 = 21;
            while (i2 < 37) {
                name.append((char)nameData[i2]);
                ++i2;
            }
            a2.addGroup(1, name.toString());
        }
        if ((groupsData >>> 2 & 1) == 1) {
            name = new StringBuffer();
            i2 = 37;
            while (i2 < 53) {
                name.append((char)nameData[i2]);
                ++i2;
            }
            a2.addGroup(2, name.toString());
        }
        if ((groupsData >>> 2 & 1) == 1) {
            name = new StringBuffer();
            i2 = 53;
            while (i2 < 69) {
                name.append((char)nameData[i2]);
                ++i2;
            }
            a2.addGroup(3, name.toString());
        }
        if ((groupsData >>> 2 & 1) == 1) {
            name = new StringBuffer();
            i2 = 69;
            while (i2 < 85) {
                name.append((char)nameData[i2]);
                ++i2;
            }
            a2.addGroup(4, name.toString());
        }
    }

    private void processWiredZone(int index, byte[] data) {
        if ((data[27] & 0x80) == 128) {
            StringBuffer name = new StringBuffer();
            int i2 = 5;
            while (i2 < 21) {
                name.append((char)data[i2]);
                ++i2;
            }
            this.wiredZones.put(index, new WiredZone(index, name.toString()));
        }
    }

    private void processRadioZone(int index, byte[] data) {
        if ((data[27] & 0x80) == 128) {
            StringBuffer name = new StringBuffer();
            int i2 = 5;
            while (i2 < 21) {
                name.append((char)data[i2]);
                ++i2;
            }
            StringBuffer extName = new StringBuffer();
            int i3 = 31;
            while (i3 < 47) {
                extName.append((char)data[i3]);
                ++i3;
            }
            this.radioZones.put(index, new RadioZone(index, name.toString(), extName.toString()));
        }
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private boolean polling() {
        boolean ok = true;
        byte[] resp = this.send(STATUS_REQ, 170);
        if (resp == null) {
            ok = false;
        } else {
            int out3;
            int out2;
            int out1;
            int cred;
            int sup;
            int rf;
            int coer;
            int tamp;
            int batt;
            int line;
            int pstn;
            int gsm;
            for (WiredZone wiredZone : this.wiredZones.values()) {
                wiredZone.setStatus(resp[wiredZone.index + 2]);
            }
            for (RadioZone radioZone : this.radioZones.values()) {
                radioZone.setStatus(resp[radioZone.index + NUM_ZF[this.panel_version] + 2]);
            }
            for (Area area : this.areas.values()) {
                area.setStatus(resp[area.index + 146]);
            }
            int n2 = resp[152] & 0xFF;
            if (this.exitDelay != n2) {
                this.exitDelay = n2;
                this.ioWrite(this.genEvents, "exit.delay", "" + this.exitDelay);
            }
            if (this.gsmFault != (gsm = resp[153] & 1)) {
                this.gsmFault = gsm;
                this.ioWrite(this.genEvents, "gsm.fault", "" + this.gsmFault);
            }
            if (this.pstnFault != (pstn = resp[153] >>> 1 & 1)) {
                this.pstnFault = pstn;
                this.ioWrite(this.genEvents, "pstn.fault", "" + this.pstnFault);
            }
            if (this.lineFault != (line = resp[153] >>> 2 & 1)) {
                this.lineFault = line;
                this.ioWrite(this.genEvents, "line.fault", "" + this.lineFault);
            }
            if ((batt = resp[153] >>> 3 & 1) == 0) {
                if (this.batteryFault != -1) {
                    this.batteryFault = -1;
                    this.ioWrite(this.genEvents, "battery.fault", "0");
                }
            } else {
                batt = resp[155] & 0xFF;
                if (this.batteryFault != batt) {
                    this.batteryFault = batt;
                    if (this.batteryFault >= 104 && this.batteryFault <= 143) {
                        this.ioWrite(this.genEvents, "battery.fault", "rz" + (this.batteryFault - 103));
                    } else if (this.batteryFault == 255) {
                        this.ioWrite(this.genEvents, "battery.fault", "p");
                    }
                }
            }
            if ((tamp = resp[153] >>> 4 & 1) == 0) {
                if (this.tamper != -1) {
                    this.tamper = -1;
                    this.ioWrite(this.genEvents, "tamper", "0");
                }
            } else {
                tamp = resp[156] & 0xFF;
                if (this.tamper != tamp) {
                    this.tamper = tamp;
                    if (this.tamper >= 144 && this.tamper <= 151) {
                        this.ioWrite(this.genEvents, "tamper", "k" + (this.tamper - 143));
                    } else if (this.tamper >= 152 && this.tamper <= 163) {
                        this.ioWrite(this.genEvents, "tamper", "e" + (this.tamper - 151));
                    } else if (this.tamper >= 164 && this.tamper <= 171) {
                        this.ioWrite(this.genEvents, "tamper", "r" + (this.tamper - 163));
                    } else if (this.tamper == 255) {
                        this.ioWrite(this.genEvents, "tamper", "p");
                    }
                }
            }
            if ((coer = resp[153] >>> 5 & 1) == 1) {
                coer = (resp[154] & 0xFF) + 1;
            }
            if (this.coercion != coer) {
                this.coercion = coer;
                this.ioWrite(this.genEvents, "coercion", "" + this.coercion);
            }
            if (this.rfi != (rf = resp[153] >>> 6 & 1)) {
                this.rfi = rf;
                this.ioWrite(this.genEvents, "rfi", "" + this.rfi);
            }
            if ((sup = resp[153] >>> 7 & 1) == 0) {
                if (this.supervision != -1) {
                    this.supervision = -1;
                    this.ioWrite(this.genEvents, "supervision", "0");
                }
            } else {
                sup = resp[157] & 0xFF;
                if (this.supervision != sup) {
                    this.supervision = sup;
                    if (this.supervision >= 104 && this.supervision <= 143) {
                        this.ioWrite(this.genEvents, "supervision", "rz" + (this.supervision - 103));
                    }
                }
            }
            if (this.lowCredit != (cred = resp[158] & 1)) {
                this.lowCredit = cred;
                this.ioWrite(this.genEvents, "credit.low", "" + this.lowCredit);
            }
            if (this.output1 != (out1 = resp[159] & 1)) {
                this.output1 = out1;
                this.ioWrite(this.genEvents, "out1", "" + this.output1);
            }
            if (this.output2 != (out2 = resp[159] >>> 1 & 1)) {
                this.output2 = out2;
                this.ioWrite(this.genEvents, "out2", "" + this.output2);
            }
            if (this.output3 != (out3 = resp[159] >>> 2 & 1)) {
                this.output3 = out3;
                this.ioWrite(this.genEvents, "out3", "" + this.output3);
            }
            int b2 = 0;
            while (b2 < 6) {
                int n22 = 0;
                while (n22 < 2) {
                    int st = resp[161 + b2] >>> n22 * 4 & 0xF;
                    Expander e2 = this.expanders.get(b2 * 2 + n22 + 1);
                    if (e2 != null) {
                        e2.setOutputsStatus(st & 1, st >>> 1 & 1, st >>> 2 & 1);
                    }
                    ++n22;
                }
                ++b2;
            }
        }
        this.EEPROM_READ_REQ[4] = 2;
        this.EEPROM_READ_REQ[3] = (byte)(IdxLogAddr[this.panel_version] >>> 8 & 0xFF);
        this.EEPROM_READ_REQ[2] = (byte)(IdxLogAddr[this.panel_version] & 0xFF);
        this.addCRC(this.EEPROM_READ_REQ);
        resp = this.send(this.EEPROM_READ_REQ, 8);
        if (resp == null) {
            ok = false;
        } else {
            int n3 = ((resp[6] & 0xFF) << 8) + (resp[5] & 0xFF);
            if (n3 < this.lastLogEntry) {
                while (this.lastLogEntry < IdxLogAddr[this.panel_version] - 16) {
                    if (this.readLogEntry()) continue;
                    ok = false;
                }
                this.lastLogEntry = LogAddr[this.panel_version] - 16;
                userBase.varSet("_tlab." + this.serverName + ".lastlogentry!", "" + this.lastLogEntry);
            }
            while (this.lastLogEntry < n3) {
                if (this.readLogEntry()) continue;
                ok = false;
            }
        }
        return ok;
    }

    private boolean readLogEntry() {
        boolean ok = true;
        this.lastLogEntry += 16;
        userBase.varSet("_tlab." + this.serverName + ".lastlogentry!", "" + this.lastLogEntry);
        this.EEPROM_READ_REQ[4] = 16;
        this.EEPROM_READ_REQ[3] = (byte)(this.lastLogEntry >>> 8 & 0xFF);
        this.EEPROM_READ_REQ[2] = (byte)(this.lastLogEntry & 0xFF);
        this.addCRC(this.EEPROM_READ_REQ);
        int att = 0;
        do {
            byte[] resp;
            if ((resp = this.send(this.EEPROM_READ_REQ, 22)) != null) {
                this.processLogEntry(resp);
                continue;
            }
            ok = false;
            ++att;
        } while (!ok && att < 4);
        return ok;
    }

    private void processLogEntry(byte[] log) {
        int year;
        int month;
        int day;
        int min;
        int hour;
        StringBuffer date = new StringBuffer();
        StringBuffer e2 = new StringBuffer();
        if (log[5] == 0 || log[5] == 1) {
            hour = log[15] & 0xFF;
            min = log[16] & 0xFF;
            day = log[17] & 0xFF;
            month = log[18] & 0xFF;
            year = ((log[20] & 0xFF) << 8) + (log[19] & 0xFF);
        } else if (log[5] == 32 || log[5] == 33) {
            hour = log[11] & 0xFF;
            min = log[12] & 0xFF;
            day = log[13] & 0xFF;
            month = log[14] & 0xFF;
            year = ((log[16] & 0xFF) << 8) + (log[15] & 0xFF);
        } else {
            hour = log[7] & 0xFF;
            min = log[8] & 0xFF;
            day = log[9] & 0xFF;
            month = log[10] & 0xFF;
            year = ((log[12] & 0xFF) << 8) + (log[11] & 0xFF);
        }
        date.append(year).append("/").append(month).append("/").append(day).append(" ").append(hour).append(":").append(min).append(" ");
        if (log[5] == 0 || log[5] == 1) {
            if (log[5] == 0) {
                e2.append(ARMED[this.language]);
            } else {
                e2.append(DISARMED[this.language]);
            }
            if (log[7] == 0) {
                e2.append(KEYPAD[this.language]).append((log[8] & 0xFF) + 1).append(", ");
                if (log[6] == -1) {
                    e2.append(QUICK_ARM[this.language]);
                } else if (log[6] < 64) {
                    e2.append(this.users.get((log[6] & 0xFF) + 1).name);
                }
            } else if (log[7] == 1) {
                e2.append(KEY_POINT[this.language]).append((log[6] & 0xFF) + 1);
            } else if (log[7] == 2) {
                e2.append(TIMER[this.language]).append((log[6] & 0xFF) + 1);
            } else if (log[7] == 4) {
                e2.append(READER[this.language]).append((log[8] & 0xFF) + 1).append(", ");
                e2.append(this.users.get((log[6] & 0xFF) + 1).name);
            } else if (log[7] == 8) {
                e2.append(SMS[this.language]).append(", ");
                e2.append(this.users.get((log[6] & 0xFF) + 1).name);
            } else if (log[7] == 16) {
                e2.append(SOFTWARE[this.language]);
            }
            e2.append(",");
            for (Area a2 : this.areas.values()) {
                e2.append(" ").append(a2.name).append("[");
                byte as = log[8 + a2.index];
                if ((as & 1) == 1) {
                    e2.append("T");
                }
                if ((as >>> 1 & 1) == 1) {
                    e2.append("A");
                }
                if ((as >>> 2 & 1) == 1) {
                    e2.append("B");
                }
                if ((as >>> 3 & 1) == 1) {
                    e2.append("C");
                }
                if ((as >>> 4 & 1) == 1) {
                    e2.append("D");
                }
                e2.append("]");
            }
        } else if (log[5] >= 2 && log[5] <= 9) {
            String zName;
            if (log[5] == 2) {
                e2.append(ALARM[this.language]);
            } else if (log[5] == 3) {
                e2.append(TAMPER[this.language]);
            } else if (log[5] == 4) {
                e2.append(ROBBERY[this.language]);
            } else if (log[5] == 5) {
                e2.append(TECHNICIAN[this.language]);
            } else if (log[5] == 6) {
                e2.append(TECH_FAULT[this.language]);
            } else if (log[5] == 7) {
                e2.append(FIRE[this.language]);
            } else if (log[5] == 8) {
                e2.append(MEDICAL_EM[this.language]);
            } else if (log[5] == 9) {
                e2.append(FLOODING[this.language]);
            }
            int idx = (log[6] & 0xFF) + 1;
            if (idx <= NUM_ZF[this.panel_version]) {
                WiredZone z = this.wiredZones.get(idx);
                zName = z.name;
            } else {
                RadioZone z = this.radioZones.get(idx - NUM_ZF[this.panel_version]);
                zName = log[19] == 16 ? z.extName : z.name;
            }
            e2.append(zName);
        } else if (log[5] == 10) {
            e2.append(COERCION[this.language]);
            e2.append(this.users.get((log[6] & 0xFF) + 1).name);
        } else if (log[5] == 11) {
            e2.append(INTERFERENCE[this.language]);
        } else if (log[5] == 12) {
            String zName;
            e2.append(SUPERV[this.language]);
            int idx = (log[6] & 0xFF) + 1;
            if (idx <= NUM_ZF[this.panel_version]) {
                WiredZone z = this.wiredZones.get(idx);
                zName = z.name;
            } else {
                RadioZone z = this.radioZones.get(idx - NUM_ZF[this.panel_version]);
                zName = log[19] == 16 ? z.extName : z.name;
            }
            e2.append(zName);
        } else if (log[5] == 13) {
            e2.append(NO_LINE[this.language]);
        } else if (log[5] == 14) {
            e2.append(LOW_BATT[this.language]);
            if (log[6] == -1) {
                e2.append(SYSTEM[this.language]);
            } else {
                e2.append(this.radioZones.get((log[6] & 0xFF) + 1 - NUM_ZF[this.panel_version]));
            }
        } else if (log[5] == 15) {
            e2.append(MAINTENANCE[this.language]);
        } else if (log[5] == 16) {
            e2.append(TAMPER[this.language]);
            if (log[6] == -1) {
                e2.append(SYSTEM[this.language]);
            } else if (log[6] < 8) {
                e2.append(KEYPAD[this.language]).append((log[6] & 0xFF) + 1);
            } else if (log[6] >= 8 && log[6] < 20) {
                e2.append(CONCENTRATOR[this.language]).append((log[6] & 0xFF) + 1);
            } else {
                e2.append(READER[this.language]).append((log[6] & 0xFF) + 1);
            }
        } else if (log[5] == 17) {
            e2.append(PSTN_FAULT[this.language]);
        } else if (log[5] == 18) {
            e2.append(GSM_FAULT[this.language]);
        } else if (log[5] == 19) {
            e2.append(GSM_CREDIT[this.language]);
        } else if (log[5] == 32) {
            e2.append(RESET_CPU[this.language]);
        } else if (log[5] == 33) {
            e2.append(ADDR_ERROR[this.language]);
        }
        this.uiSet("log", e2.toString());
        Logger.log(Logger.Mode.SECURITY, date.append(e2).toString(), this.serverName);
    }

    private byte[] send(byte[] data, int respLen) {
        util.readComm(this.commPort, 0);
        if (util.writeCommBytes(this.commPort, data) != data.length) {
            return null;
        }
        byte[] resp = util.readCommBytes(this.commPort, respLen);
        if (resp == null || resp.length != respLen || !this.checkCRC(resp)) {
            return null;
        }
        return resp;
    }

    private boolean processCommand(String cmd) {
        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd, this.serverName);
        cmd = cmd.toLowerCase();
        try {
            String[] id_val = cmd.split("=");
            String id = id_val[0];
            String val = id_val[1];
            int dot = id.indexOf(46);
            if (dot == -1) {
                return this.commandExecutor(cmd, Cmd.GLOBAL, 0, '\u0000', id, val);
            }
            String prefix = id.substring(0, dot);
            String func = id.substring(dot + 1);
            if (prefix.startsWith("a")) {
                int a2 = Integer.parseInt(prefix.replace("a", ""));
                char g2 = func.charAt(0);
                func = func.substring(2);
                return this.commandExecutor(cmd, Cmd.AREA, a2, g2, func, val);
            }
            if (prefix.startsWith("wz")) {
                int z = Integer.parseInt(prefix.replace("wz", ""));
                return this.commandExecutor(cmd, Cmd.WIRED_ZONE, z, '\u0000', func, val);
            }
            if (prefix.startsWith("rz")) {
                int z = Integer.parseInt(prefix.replace("rz", ""));
                return this.commandExecutor(cmd, Cmd.RADIO_ZONE, z, '\u0000', func, val);
            }
            if (prefix.startsWith("e")) {
                int e2 = Integer.parseInt(prefix.replace("e", ""));
                return this.commandExecutor(cmd, Cmd.EXPANDER, e2, '\u0000', func, val);
            }
            return false;
        }
        catch (Exception e3) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e3.getLocalizedMessage(), this.serverName);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean commandExecutor(String cmd, Cmd type, int index, char group, String function, String value) throws Exception {
        if (type == Cmd.AREA) {
            if (!function.equals("armed")) throw new Exception("invalid command");
            int addr = InsAllAddr[this.panel_version] + (index - 1);
            this.GROUP_SET_ARMED[3] = (byte)(addr >>> 8 & 0xFF);
            this.GROUP_SET_ARMED[2] = (byte)(addr & 0xFF);
            int mask = 0;
            if (group == 't') {
                mask = 31;
            } else if (group == 'a') {
                mask = 2;
            } else if (group == 'b') {
                mask = 4;
            } else if (group == 'c') {
                mask = 8;
            } else {
                if (group != 'd') throw new Exception("invalid group");
                mask = 16;
            }
            this.GROUP_SET_ARMED[4] = mask;
            if (value.equals("1")) {
                this.GROUP_SET_ARMED[6] = -1;
            } else {
                if (!value.equals("0")) throw new Exception("invalid value");
                this.GROUP_SET_ARMED[6] = 0;
            }
            this.addCRC(this.GROUP_SET_ARMED);
            byte[] resp = this.send(this.GROUP_SET_ARMED, 6);
            if (resp == null) {
                throw new Exception("null response");
            }
            if (resp[4] == 0) return true;
            Logger.log(Logger.Mode.EVENT, "commandExecutor - command '" + cmd + "' failed", this.serverName);
            return true;
        } else if (type == Cmd.WIRED_ZONE || type == Cmd.RADIO_ZONE) {
            if (!function.equals("bypassed")) throw new Exception("invalid command");
            int addr = type == Cmd.WIRED_ZONE ? 16 + (index - 1) * 46 + 24 : ZR01EEADDR[this.panel_version] + (index - 1) * 46 + 24;
            this.ZONE_SET_BYPASSED[3] = (byte)(addr >>> 8 & 0xFF);
            this.ZONE_SET_BYPASSED[2] = (byte)(addr & 0xFF);
            if (value.equals("1")) {
                this.ZONE_SET_BYPASSED[7] = -1;
            } else {
                if (!value.equals("0")) throw new Exception("invalid value");
                this.ZONE_SET_BYPASSED[7] = 0;
            }
            this.addCRC(this.ZONE_SET_BYPASSED);
            byte[] resp = this.send(this.ZONE_SET_BYPASSED, 6);
            if (resp == null) {
                throw new Exception("null response");
            }
            if (resp[4] == 0) return true;
            Logger.log(Logger.Mode.EVENT, "commandExecutor - command '" + cmd + "' failed", this.serverName);
            return true;
        } else if (type == Cmd.EXPANDER) {
            if (!function.startsWith("out")) throw new Exception("invalid command");
            int o2 = Integer.parseInt("" + function.charAt(3));
            if (o2 < 1 || o2 > 3) {
                throw new Exception("invalid output number");
            }
            this.OUTPUT_SET[7] = (byte)(index * 4 + o2 - 1);
            if (value.equals("1")) {
                this.OUTPUT_SET[8] = 1;
            } else {
                if (!value.equals("0")) throw new Exception("invalid value");
                this.OUTPUT_SET[8] = 0;
            }
            this.addCRC(this.OUTPUT_SET);
            byte[] resp = this.send(this.OUTPUT_SET, 6);
            if (resp == null) {
                throw new Exception("null response");
            }
            if (resp[4] == 0) return true;
            Logger.log(Logger.Mode.EVENT, "commandExecutor - command '" + cmd + "' failed", this.serverName);
            return true;
        } else {
            if (type != Cmd.GLOBAL) return true;
            if (!function.startsWith("out")) throw new Exception("invalid command");
            int o3 = Integer.parseInt("" + function.charAt(3));
            if (o3 < 1 || o3 > 3) {
                throw new Exception("invalid output number");
            }
            this.OUTPUT_SET[7] = (byte)(o3 - 1);
            if (value.equals("1")) {
                this.OUTPUT_SET[8] = 1;
            } else {
                if (!value.equals("0")) throw new Exception("invalid value");
                this.OUTPUT_SET[8] = 0;
            }
            this.addCRC(this.OUTPUT_SET);
            byte[] resp = this.send(this.OUTPUT_SET, 6);
            if (resp == null) {
                throw new Exception("null response");
            }
            if (resp[4] == 0) return true;
            Logger.log(Logger.Mode.EVENT, "commandExecutor - command '" + cmd + "' failed", this.serverName);
        }
        return true;
    }

    private void setSysAlarm(int val) {
        if (this.sys_alarm != val) {
            if (val == 1) {
                this.sys_alarm = 1;
                this.ioWrite(this.genEvents, "alarm", "1");
            } else {
                for (Zone zone : this.wiredZones.values()) {
                    if (zone.alarm == 0) continue;
                    return;
                }
                for (Zone zone : this.radioZones.values()) {
                    if (zone.alarm == 0) continue;
                    return;
                }
                this.sys_alarm = 0;
                this.ioWrite(this.genEvents, "alarm", "0");
            }
        }
    }

    private void setSysAlarmMem(int val) {
        if (this.sys_alarm_mem != val) {
            if (val == 1) {
                this.sys_alarm_mem = 1;
                this.ioWrite(this.genEvents, "alarm.mem", "1");
            } else {
                for (Zone zone : this.wiredZones.values()) {
                    if (zone.alarm == 0) continue;
                    return;
                }
                for (Zone zone : this.radioZones.values()) {
                    if (zone.alarm == 0) continue;
                    return;
                }
                this.sys_alarm_mem = 0;
                this.ioWrite(this.genEvents, "alarm.mem", "0");
            }
        }
    }

    private void setSysArmed(int val) {
        if (this.sys_armed != val) {
            if (val == 1) {
                this.sys_armed = 1;
                this.ioWrite(this.genEvents, "armed", "1");
            } else {
                for (Area a2 : this.areas.values()) {
                    if (a2.armed == 0) continue;
                    return;
                }
                this.sys_armed = 0;
                this.ioWrite(this.genEvents, "armed", "0");
            }
        }
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (name.equals("log")) {
            value = value.toUpperCase();
            this.logTime = System.currentTimeMillis();
            SimpleDateFormat displayDateFormat = new SimpleDateFormat("dd MMM HH:mm:ss");
            String logEntry = String.valueOf(displayDateFormat.format(this.logTime).toUpperCase()) + " " + value;
            int i2 = 20;
            while (i2 >= 2) {
                try {
                    String le = userBase.varGet("_tlab." + this.serverName + ".log" + (i2 - 1) + "!");
                    userBase.uiSet(String.valueOf(this.serverName) + ".log" + i2, "value", le);
                    userBase.varSet("_tlab." + this.serverName + ".log" + i2 + "!", le);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i2;
            }
            userBase.uiSet(String.valueOf(this.serverName) + ".log1", "value", logEntry);
            userBase.varSet("_tlab." + this.serverName + ".log1!", logEntry);
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", value);
        } else if (name.equals("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(this.serverName) + ".connection.label", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + ".connection.label", "visible", "true");
            }
        } else if (name.endsWith(".name")) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + name, "value", value);
        } else if (name.endsWith("armed") || name.endsWith("alarm") || name.endsWith("alarm.mem") || name.endsWith("tamper") || name.endsWith("fault") || name.startsWith("out")) {
            if (value.equals("0")) {
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "true");
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
            } else {
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
                user.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
            }
        }
    }

    private void uiUpdate() {
        if (!this.guiSupport) {
            return;
        }
        if (System.currentTimeMillis() > this.logTime + 10000L) {
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", "");
        }
    }

    private boolean checkCRC(byte[] data) {
        byte crc = 0;
        int i2 = 1;
        while (i2 < data.length - 1) {
            crc = (byte)(crc + data[i2]);
            ++i2;
        }
        return data[data.length - 1] == crc;
    }

    private void addCRC(byte[] data) {
        byte crc = 0;
        int i2 = 1;
        while (i2 < data.length - 1) {
            crc = (byte)(crc + data[i2]);
            ++i2;
        }
        data[data.length - 1] = crc;
    }

    private class Area {
        private final int index;
        private final String name;
        private final String prefix;
        private Vector<Group> groups = new Vector(5);
        private int armed = -2;

        public Area(int index, String name) {
            this.index = index;
            this.name = name;
            this.prefix = "a" + index + ".";
            Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "name", name);
        }

        public void addGroup(int grIdx, String name) {
            this.groups.add(new Group(this.index, grIdx, name));
        }

        public void setStatus(byte status) {
            for (Group g2 : this.groups) {
                g2.setArmed((status >>> g2.idx & 1) == 1);
            }
            for (Group g2 : this.groups) {
                if (g2.armed != 1) continue;
                if (this.armed != 1) {
                    this.armed = 1;
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "armed", "1");
                    Tlab.this.setSysArmed(1);
                }
                return;
            }
            if (this.armed != 0) {
                this.armed = 0;
                Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "armed", "0");
                Tlab.this.setSysArmed(0);
            }
        }
    }

    private static enum Cmd {
        GLOBAL,
        AREA,
        WIRED_ZONE,
        RADIO_ZONE,
        EXPANDER;

    }

    private class Expander {
        private final String prefix;
        private int[] outputs = new int[3];

        public Expander(int index) {
            this.outputs[0] = -2;
            this.outputs[1] = -2;
            this.outputs[2] = -2;
            this.prefix = "e" + index + ".";
        }

        public void setOutputName(int outIndex, String name) {
            Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "out" + outIndex + ".name", name);
        }

        public void setOutputsStatus(int ... outputs) {
            int i2 = 0;
            while (i2 < 3) {
                if (this.outputs[i2] != outputs[i2]) {
                    this.outputs[i2] = outputs[i2];
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "out" + (i2 + 1), "" + this.outputs[i2]);
                }
                ++i2;
            }
        }
    }

    private class Group {
        private final int idx;
        private final String prefix;
        private int armed = -2;

        public Group(int area, int idx, String name) {
            this.idx = idx;
            this.prefix = "a" + area + "." + PREFIX_LETTERS[idx] + ".";
            Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "name", name);
        }

        public void setArmed(boolean armed) {
            if (armed) {
                if (this.armed != 1) {
                    this.armed = 1;
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "armed", "1");
                }
            } else if (this.armed != 0) {
                this.armed = 0;
                Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "armed", "0");
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class RadioZone
    extends Zone {
        private final String extName;
        private int openExt;

        public RadioZone(int index, String name, String extName) {
            super("rz", index, name);
            this.openExt = -1;
            this.extName = extName;
            Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + index + ".name.ext", extName);
        }

        @Override
        public void setStatus(byte status) {
            super.setStatus(status);
            if ((status >>> 4 & 1) == 1) {
                if (this.openExt != 1) {
                    this.openExt = 1;
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + this.index + ".open.ext", "1");
                }
            } else if (this.openExt != 0) {
                this.openExt = 0;
                Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + this.index + ".open.ext", "0");
            }
        }
    }

    private class User {
        private final String name;

        public User(int index, String name) {
            this.name = name;
            Tlab.this.ioWrite(Tlab.this.genEvents, "usr" + index + ".name", name);
        }
    }

    private class WiredZone
    extends Zone {
        public WiredZone(int index, String name) {
            super("wz", index, name);
        }
    }

    private abstract class Zone {
        protected final String prefix;
        protected final int index;
        final String name;
        private byte status = (byte)16;
        private int alarm = -1;
        private int bypassed = -1;
        private int alarmMem = -1;

        public Zone(String prefix, int index, String name) {
            this.prefix = String.valueOf(prefix) + index + ".";
            this.index = index;
            this.name = name;
            Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "name", name);
        }

        public void setStatus(byte status) {
            byte nb = (byte)(status & 0xF);
            if (this.status != nb) {
                this.status = nb;
                if (nb == 15) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "normal");
                } else if (nb == 0) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "open");
                } else if (nb == 1) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "tamper");
                } else if (nb == 2) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "robbery");
                } else if (nb == 3) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "tech");
                } else if (nb == 4) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "failure");
                } else if (nb == 5) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "fire");
                } else if (nb == 6) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "emergency");
                } else if (nb == 7) {
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "status", "flood");
                }
            }
            if ((status >>> 7 & 1) == 1) {
                if (this.alarm != 1) {
                    this.alarm = 1;
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "alarm", "1");
                    Tlab.this.setSysAlarm(1);
                }
            } else if (this.alarm != 0) {
                this.alarm = 0;
                Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "alarm", "0");
                Tlab.this.setSysAlarm(0);
            }
            if ((status >>> 6 & 1) == 1) {
                if (this.bypassed != 1) {
                    this.bypassed = 1;
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "bypassed", "1");
                }
            } else if (this.bypassed != 0) {
                this.bypassed = 0;
                Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "bypassed", "0");
            }
            if ((status >>> 5 & 1) == 1) {
                if (this.alarmMem != 1) {
                    this.alarmMem = 1;
                    Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "alarm.mem", "1");
                    Tlab.this.setSysAlarmMem(1);
                }
            } else if (this.alarmMem != 0) {
                this.alarmMem = 0;
                Tlab.this.ioWrite(Tlab.this.genEvents, String.valueOf(this.prefix) + "alarm.mem", "0");
                Tlab.this.setSysAlarmMem(0);
            }
        }
    }
}

