/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import java.net.InetAddress;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.control.TrackControl;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPManager;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;

public class RTPServer
implements ControllerListener {
    private boolean realized;
    private boolean configured;
    private boolean finished;
    private boolean error;
    private InetAddress multicastAddress;
    private int multicastPort;
    String sourceUri;
    RTPManager rtpMgr;

    public void play(String multicastAddress, int multicastPort, String sourceUri) throws Exception {
        this.multicastAddress = InetAddress.getByName(multicastAddress);
        this.multicastPort = multicastPort;
        this.rtpMgr = RTPManager.newInstance();
        this.rtpMgr.initialize(new SessionAddress());
        this.error = false;
        this.finished = false;
        this.configured = false;
        this.realized = false;
        if (!"false".equals(System.getProperty("java.awt.headless"))) {
            System.setProperty("java.awt.headless", "false");
        }
        MediaLocator mediasource = new MediaLocator(sourceUri);
        Processor p = Manager.createProcessor(mediasource);
        p.addControllerListener(this);
        p.configure();
        int i2 = 0;
        while (!this.configured && i2 < 100) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.setTrackFormat(p);
        p.setContentDescriptor(new ContentDescriptor("raw.rtp"));
        p.realize();
        i2 = 0;
        while (!this.realized && i2 < 255) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.transmit(p);
    }

    private boolean setTrackFormat(Processor p) {
        boolean atLeastOneTrack = false;
        TrackControl[] tracks = p.getTrackControls();
        if (tracks == null || tracks.length < 1) {
            return false;
        }
        p.setContentDescriptor(new ContentDescriptor("raw.rtp"));
        int i2 = 0;
        while (i2 < tracks.length) {
            if (tracks[i2].isEnabled()) {
                Format[] supported = tracks[i2].getSupportedFormats();
                boolean formatFound = false;
                int j2 = 0;
                while (j2 < supported.length) {
                    if ("ulaw/rtp".equalsIgnoreCase(supported[j2].getEncoding())) {
                        Format chosen = supported[j2];
                        tracks[i2].setFormat(chosen);
                        atLeastOneTrack = true;
                        formatFound = true;
                        break;
                    }
                    ++j2;
                }
                if (!formatFound) {
                    tracks[i2].setEnabled(false);
                }
            } else {
                tracks[i2].setEnabled(false);
            }
            ++i2;
        }
        return atLeastOneTrack;
    }

    private void transmit(Processor p) throws Exception {
        DataSource output = p.getDataOutput();
        SessionAddress destAddr = new SessionAddress(this.multicastAddress, this.multicastPort);
        this.rtpMgr.addTarget(destAddr);
        SendStream sendStream = this.rtpMgr.createSendStream(output, 0);
        sendStream.start();
        p.start();
        while (!this.finished && !this.error) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof RealizeCompleteEvent) {
            this.realized = true;
        } else if (evt instanceof ConfigureCompleteEvent) {
            this.configured = true;
        } else if (evt instanceof EndOfMediaEvent) {
            this.finished = true;
        } else if (evt instanceof ControllerErrorEvent) {
            this.error = true;
        }
    }
}

