/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;

public class PowerOne {
    private String serverName;
    private String commPort;
    private boolean guiSupport = true;
    private long pollInterval = 20000L;
    private int maxAddr = 2;
    private int[] addr = new int[]{2};
    private int online = -1;
    private float[] gridPower;
    private float[] gridPowerGlob;
    private float[] powerpeak;
    private float[] powerpeaktoday;
    private long[] dayenergy;
    private long[] weekenergy;
    private long[] monthenergy;
    private long[] yearenergy;
    private long[] totenergy;
    private long[] partenergy;
    private static final int MIN_ADDR = 2;
    private byte[] GRID_POWER_CMD;
    private byte[] GRID_POWER_GLOBAL_CMD;
    private byte[] POWER_PEAK_CMD;
    private byte[] POWER_PEAK_TODAY_CMD;
    private byte[] DAY_ENERGY_CMD;
    private byte[] WEEK_ENERGY_CMD;
    private byte[] MONTH_ENERGY_CMD;
    private byte[] YEAR_ENERGY_CMD;
    private byte[] TOTAL_ENERGY_CMD;
    private byte[] PARTIAL_ENERGY_CMD;

    public PowerOne() {
        byte[] byArray = new byte[10];
        byArray[0] = 1;
        byArray[1] = 59;
        byArray[2] = 3;
        this.GRID_POWER_CMD = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = 1;
        byArray2[1] = 59;
        byArray2[2] = 3;
        byArray2[3] = 1;
        this.GRID_POWER_GLOBAL_CMD = byArray2;
        byte[] byArray3 = new byte[10];
        byArray3[0] = 1;
        byArray3[1] = 59;
        byArray3[2] = 34;
        this.POWER_PEAK_CMD = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[0] = 1;
        byArray4[1] = 59;
        byArray4[2] = 35;
        this.POWER_PEAK_TODAY_CMD = byArray4;
        byte[] byArray5 = new byte[10];
        byArray5[0] = 1;
        byArray5[1] = 78;
        this.DAY_ENERGY_CMD = byArray5;
        byte[] byArray6 = new byte[10];
        byArray6[0] = 1;
        byArray6[1] = 78;
        byArray6[2] = 1;
        this.WEEK_ENERGY_CMD = byArray6;
        byte[] byArray7 = new byte[10];
        byArray7[0] = 1;
        byArray7[1] = 78;
        byArray7[2] = 3;
        this.MONTH_ENERGY_CMD = byArray7;
        byte[] byArray8 = new byte[10];
        byArray8[0] = 1;
        byArray8[1] = 78;
        byArray8[2] = 4;
        this.YEAR_ENERGY_CMD = byArray8;
        byte[] byArray9 = new byte[10];
        byArray9[0] = 1;
        byArray9[1] = 78;
        byArray9[2] = 5;
        this.TOTAL_ENERGY_CMD = byArray9;
        byte[] byArray10 = new byte[10];
        byArray10[0] = 1;
        byArray10[1] = 78;
        byArray10[2] = 6;
        this.PARTIAL_ENERGY_CMD = byArray10;
    }

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        this.pollInterval = Integer.parseInt(value) * 1000;
                        if (this.pollInterval < 1L) {
                            this.pollInterval = 20000L;
                            throw new Exception();
                        }
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("addr")) {
                    try {
                        String[] as = value.split("/");
                        this.addr = new int[as.length];
                        int a2 = 0;
                        while (a2 < as.length) {
                            this.addr[a2] = Integer.parseInt(as[a2]);
                            if (this.addr[a2] > this.maxAddr) {
                                this.maxAddr = this.addr[a2];
                            }
                            ++a2;
                        }
                    }
                    catch (Exception e3) {
                        this.maxAddr = 2;
                        this.addr = new int[1];
                        this.addr[0] = 2;
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - addr ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        this.gridPower = new float[this.maxAddr + 1];
        this.gridPowerGlob = new float[this.maxAddr + 1];
        this.powerpeak = new float[this.maxAddr + 1];
        this.powerpeaktoday = new float[this.maxAddr + 1];
        this.dayenergy = new long[this.maxAddr + 1];
        this.weekenergy = new long[this.maxAddr + 1];
        this.monthenergy = new long[this.maxAddr + 1];
        this.yearenergy = new long[this.maxAddr + 1];
        this.totenergy = new long[this.maxAddr + 1];
        this.partenergy = new long[this.maxAddr + 1];
        int ad = 0;
        while (ad <= this.maxAddr) {
            this.gridPower[ad] = -1.0f;
            this.gridPowerGlob[ad] = -1.0f;
            this.powerpeak[ad] = -1.0f;
            this.powerpeaktoday[ad] = -1.0f;
            this.dayenergy[ad] = -1L;
            this.weekenergy[ad] = -1L;
            this.monthenergy[ad] = -1L;
            this.yearenergy[ad] = -1L;
            this.totenergy[ad] = -1L;
            this.partenergy[ad] = -1L;
            ++ad;
        }
        boolean ok = true;
        me.heartbeat = System.currentTimeMillis();
        while (!me.quit) {
            try {
                int[] nArray = this.addr;
                int n2 = this.addr.length;
                int n3 = 0;
                while (n3 < n2) {
                    int ad2 = nArray[n3];
                    this.GRID_POWER_CMD[0] = (byte)ad2;
                    this.GRID_POWER_GLOBAL_CMD[0] = (byte)ad2;
                    this.POWER_PEAK_CMD[0] = (byte)ad2;
                    this.POWER_PEAK_TODAY_CMD[0] = (byte)ad2;
                    this.DAY_ENERGY_CMD[0] = (byte)ad2;
                    this.WEEK_ENERGY_CMD[0] = (byte)ad2;
                    this.MONTH_ENERGY_CMD[0] = (byte)ad2;
                    this.YEAR_ENERGY_CMD[0] = (byte)ad2;
                    this.TOTAL_ENERGY_CMD[0] = (byte)ad2;
                    this.PARTIAL_ENERGY_CMD[0] = (byte)ad2;
                    this.calculateCheckSum(this.GRID_POWER_CMD);
                    this.calculateCheckSum(this.GRID_POWER_GLOBAL_CMD);
                    this.calculateCheckSum(this.POWER_PEAK_CMD);
                    this.calculateCheckSum(this.POWER_PEAK_TODAY_CMD);
                    this.calculateCheckSum(this.DAY_ENERGY_CMD);
                    this.calculateCheckSum(this.WEEK_ENERGY_CMD);
                    this.calculateCheckSum(this.MONTH_ENERGY_CMD);
                    this.calculateCheckSum(this.YEAR_ENERGY_CMD);
                    this.calculateCheckSum(this.TOTAL_ENERGY_CMD);
                    this.calculateCheckSum(this.PARTIAL_ENERGY_CMD);
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.GRID_POWER_CMD) != 0) {
                        if (!this.processResponse59(this.GRID_POWER_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.GRID_POWER_GLOBAL_CMD) != 0) {
                        if (!this.processResponse59(this.GRID_POWER_GLOBAL_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.POWER_PEAK_CMD) != 0) {
                        if (!this.processResponse59(this.POWER_PEAK_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.POWER_PEAK_TODAY_CMD) != 0) {
                        if (!this.processResponse59(this.POWER_PEAK_TODAY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.DAY_ENERGY_CMD) != 0) {
                        if (!this.processResponse78(this.DAY_ENERGY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.WEEK_ENERGY_CMD) != 0) {
                        if (!this.processResponse78(this.WEEK_ENERGY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.MONTH_ENERGY_CMD) != 0) {
                        if (!this.processResponse78(this.MONTH_ENERGY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.YEAR_ENERGY_CMD) != 0) {
                        if (!this.processResponse78(this.YEAR_ENERGY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.TOTAL_ENERGY_CMD) != 0) {
                        if (!this.processResponse78(this.TOTAL_ENERGY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    util.readCommBytes(this.commPort, 0);
                    ioMonitor.sleep(50L);
                    if (util.writeCommBytes(this.commPort, this.PARTIAL_ENERGY_CMD) != 0) {
                        if (!this.processResponse78(this.PARTIAL_ENERGY_CMD, util.readCommBytes(this.commPort, 8))) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                    ++n3;
                }
                if (ok) {
                    me.heartbeat = System.currentTimeMillis();
                    if (this.online != 1) {
                        this.online = 1;
                        this.ioWrite("connection", "online");
                        SystemState.ioServersInitializedSet(ioIndex, true);
                    }
                }
                ok = true;
                ioMonitor.sleep(this.pollInterval);
            }
            catch (Exception e5) {
                e5.printStackTrace();
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e5);
                me.quit = true;
            }
        }
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.online != 0) {
            this.online = 0;
            SystemState.ioServersInitializedSet(ioIndex, false);
            this.ioWrite("connection", "offline");
        }
    }

    private void ioWrite(String name, String value) {
        SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (this.guiSupport) {
            if (name.equals("connection")) {
                if (value.equals("online")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "false");
                    int ad = 2;
                    while (ad <= this.maxAddr) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".gridpower", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".gridpowerglob", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".powerpeak", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".powerpeaktoday", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".dayenergy", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".weekenergy", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".monthenergy", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".yearenergy", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".totenergy", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".partenergy", "visible", "true");
                        ++ad;
                    }
                    return;
                }
                SystemState.uiSet(String.valueOf(this.serverName) + ".connection", "visible", "true");
                int ad = 2;
                while (ad <= this.maxAddr) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".gridpower", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".gridpowerglob", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".powerpeak", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".powerpeaktoday", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".dayenergy", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".weekenergy", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".monthenergy", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".yearenergy", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".totenergy", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + ad + ".partenergy", "visible", "false");
                    ++ad;
                }
                return;
            }
            if (name.matches("(\\d){0,3}\\.(gridpower|gridpowerglob|powerpeak|powerpeaktoday)")) {
                double v = Double.parseDouble(value);
                v /= 1000.0;
                v = (double)Math.round(v * 100.0) / 100.0;
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "" + v);
                return;
            }
            if (name.matches("(\\d){0,3}\\.(dayenergy|weekenergy|monthenergy|yearenergy|totenergy|partenergy)")) {
                double v = Integer.parseInt(value);
                v /= 1000.0;
                v = (double)Math.round(v * 100.0) / 100.0;
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name, "value", "" + v);
                return;
            }
        }
    }

    boolean processResponse59(byte[] cmdType, byte[] response) {
        if (!this.checkResponse(response)) {
            return false;
        }
        int addr = cmdType[0] & 0xFF;
        byte[] val = new byte[]{response[2], response[3], response[4], response[5]};
        float flVal = this.byte4ToFloat(val);
        if (cmdType[1] == this.GRID_POWER_CMD[1] && cmdType[2] == this.GRID_POWER_CMD[2] && cmdType[3] == this.GRID_POWER_CMD[3]) {
            if (this.gridPower[addr] != flVal) {
                this.gridPower[addr] = flVal;
                this.ioWrite(String.valueOf(addr) + ".gridpower", "" + flVal);
            }
            return true;
        }
        if (cmdType[1] == this.GRID_POWER_GLOBAL_CMD[1] && cmdType[2] == this.GRID_POWER_GLOBAL_CMD[2] && cmdType[3] == this.GRID_POWER_GLOBAL_CMD[3]) {
            if (this.gridPowerGlob[addr] != flVal) {
                this.gridPowerGlob[addr] = flVal;
                this.ioWrite(String.valueOf(addr) + ".gridpowerglob", "" + flVal);
            }
            return true;
        }
        if (cmdType[1] == this.POWER_PEAK_CMD[1] && cmdType[2] == this.POWER_PEAK_CMD[2]) {
            if (this.powerpeak[addr] != flVal) {
                this.powerpeak[addr] = flVal;
                this.ioWrite(String.valueOf(addr) + ".powerpeak", "" + flVal);
            }
            return true;
        }
        if (cmdType[1] == this.POWER_PEAK_TODAY_CMD[1] && cmdType[2] == this.POWER_PEAK_TODAY_CMD[2]) {
            if (this.powerpeaktoday[addr] != flVal) {
                this.powerpeaktoday[addr] = flVal;
                this.ioWrite(String.valueOf(addr) + ".powerpeaktoday", "" + flVal);
            }
            return true;
        }
        return false;
    }

    private boolean processResponse78(byte[] cmdType, byte[] response) {
        if (!this.checkResponse(response)) {
            return false;
        }
        int addr = cmdType[0] & 0xFF;
        long val = (response[2] & 0xFF) * 0x1000000 + (response[3] & 0xFF) * 65536 + (response[4] & 0xFF) * 256 + (response[5] & 0xFF);
        if (cmdType[1] == this.DAY_ENERGY_CMD[1] && cmdType[2] == this.DAY_ENERGY_CMD[2]) {
            if (this.dayenergy[addr] != val) {
                this.dayenergy[addr] = val;
                this.ioWrite(String.valueOf(addr) + ".dayenergy", "" + val);
            }
            return true;
        }
        if (cmdType[1] == this.WEEK_ENERGY_CMD[1] && cmdType[2] == this.WEEK_ENERGY_CMD[2]) {
            if (this.weekenergy[addr] != val) {
                this.weekenergy[addr] = val;
                this.ioWrite(String.valueOf(addr) + ".weekenergy", "" + val);
            }
            return true;
        }
        if (cmdType[1] == this.MONTH_ENERGY_CMD[1] && cmdType[2] == this.MONTH_ENERGY_CMD[2]) {
            if (this.monthenergy[addr] != val) {
                this.monthenergy[addr] = val;
                this.ioWrite(String.valueOf(addr) + ".monthenergy", "" + val);
            }
            return true;
        }
        if (cmdType[1] == this.YEAR_ENERGY_CMD[1] && cmdType[2] == this.YEAR_ENERGY_CMD[2]) {
            if (this.yearenergy[addr] != val) {
                this.yearenergy[addr] = val;
                this.ioWrite(String.valueOf(addr) + ".yearenergy", "" + val);
            }
            return true;
        }
        if (cmdType[1] == this.TOTAL_ENERGY_CMD[1] && cmdType[2] == this.TOTAL_ENERGY_CMD[2]) {
            if (this.totenergy[addr] != val) {
                this.totenergy[addr] = val;
                this.ioWrite(String.valueOf(addr) + ".totenergy", "" + val);
            }
            return true;
        }
        if (cmdType[1] == this.PARTIAL_ENERGY_CMD[1] && cmdType[2] == this.PARTIAL_ENERGY_CMD[2]) {
            if (this.partenergy[addr] != val) {
                this.partenergy[addr] = val;
                this.ioWrite(String.valueOf(addr) + ".partenergy", "" + val);
            }
            return true;
        }
        return false;
    }

    private float byte4ToFloat(byte[] b2) {
        if (b2.length != 4) {
            return -1.0f;
        }
        int bits = 0;
        int i2 = 0;
        int shifter = 3;
        while (shifter >= 0) {
            bits |= (b2[i2] & 0xFF) << shifter * 8;
            ++i2;
            --shifter;
        }
        return Float.intBitsToFloat(bits);
    }

    boolean checkResponse(byte[] response) {
        if (response == null || response.length != 8 || response[0] != 0) {
            return false;
        }
        int bccLo = 255;
        int bccHi = 255;
        int i2 = 0;
        while (i2 < 6) {
            int n2 = (response[i2] ^ bccLo) & 0xFF;
            int tmp = n2 << 4 & 0xFF;
            n2 = (tmp ^ n2) & 0xFF;
            tmp = n2 >> 5 & 0xFF;
            bccLo = bccHi & 0xFF;
            bccHi = (n2 ^ tmp) & 0xFF;
            tmp = n2 << 3 & 0xFF;
            bccLo = (bccLo ^ tmp) & 0xFF;
            tmp = n2 >> 4 & 0xFF;
            bccLo = (bccLo ^ tmp) & 0xFF;
            ++i2;
        }
        return (byte)(~bccLo & 0xFF) == response[6] && (byte)(~bccHi & 0xFF) == response[7];
    }

    void calculateCheckSum(byte[] data) {
        int bccLo = 255;
        int bccHi = 255;
        int i2 = 0;
        while (i2 < 8) {
            int n2 = (data[i2] ^ bccLo) & 0xFF;
            int tmp = n2 << 4 & 0xFF;
            n2 = (tmp ^ n2) & 0xFF;
            tmp = n2 >> 5 & 0xFF;
            bccLo = bccHi & 0xFF;
            bccHi = (n2 ^ tmp) & 0xFF;
            tmp = n2 << 3 & 0xFF;
            bccLo = (bccLo ^ tmp) & 0xFF;
            tmp = n2 >> 4 & 0xFF;
            bccLo = (bccLo ^ tmp) & 0xFF;
            ++i2;
        }
        data[8] = (byte)(~bccLo & 0xFF);
        data[9] = (byte)(~bccHi & 0xFF);
    }
}

