/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.Modbus;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class NOTIFIER {
    public static final String[] WebObjects = null;
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private int unitModbusId = 1;
    private DateFormat dateFormat;
    private boolean guiSupport = true;
    private boolean startupEvents = false;
    private int pollinterval = 1000;
    private int lastZone = 150;
    private int logLines = 100;
    private boolean protocolNew = true;
    private String[] string = new String[200];
    private static final long ABORT_DELAY = 30000L;
    private static final int LOG_MESSAGE = 0;
    private static final int LOG_EVENT = 1;
    private static final int LOG_VERBOSE = 2;
    private static final int LOG_ERROR = 3;
    private boolean initialized = false;
    private long logTime;
    private LinkedList<String> logEntries = new LinkedList();
    private boolean[] loopConfig = new boolean[17];
    private short[][] sensorConfig = new short[17][100];
    private short[][] moduleConfig = new short[17][100];
    private boolean[] lcdConfig = new boolean[17];
    private boolean[][] annunciatorConfig = new boolean[17][5];
    private short panelFireNormal = (short)-1;
    private short panelFireExclusions = (short)-1;
    private short panelFireTest = (short)-1;
    private short panelFireFault = (short)-1;
    private short panelFireAlarm = (short)-1;
    private short panelFireAlarmSilent = (short)-1;
    private short panelFireUnknown = (short)-1;
    private short panelTechNormal = (short)-1;
    private short panelTechExclusions = (short)-1;
    private short panelTechTest = (short)-1;
    private short panelTechFault = (short)-1;
    private short panelTechAlarm = (short)-1;
    private short panelTechAck = (short)-1;
    private short ideFltBattDiscon = (short)-1;
    private short ideFltPower = (short)-1;
    private short ideFtlBattUnbal = (short)-1;
    private short ideFltBattFail = (short)-1;
    private short ideFltBex = (short)-1;
    private short ideFltEarth = (short)-1;
    private short ideFltUndervoltage = (short)-1;
    private short ideFltOvervoltage = (short)-1;
    private short ideFltLcopen = (short)-1;
    private short ideFltLcshort = (short)-1;
    private short ideFltFuse = (short)-1;
    private short ideFltBattChargerUv = (short)-1;
    private short ideFltBattChargerOv = (short)-1;
    private short ideFilesysClearError = (short)-1;
    private short ideFilesysInitError = (short)-1;
    private short ideReliabParMod = (short)-1;
    private short ideHardkeyEna = (short)-1;
    private short idePowerOn = (short)-1;
    private short ideWdtReset = (short)-1;
    private short ideCfgError = (short)-1;
    private short ideFilesystemErr = (short)-1;
    private short ideFltHardClock = (short)-1;
    private short ideFltArchFull = (short)-1;
    private short ideFltArchFullWrng = (short)-1;
    private short ideFltZoneDefault = (short)-1;
    private short ideSibOffline = (short)-1;
    private short ideSibNotPrg = (short)-1;
    private short idePcInvalidCmd = (short)-1;
    private short ideFltArchDisabled = (short)-1;
    private short egOfflTerm = (short)-1;
    private short egAnMain = (short)-1;
    private short egAnAux = (short)-1;
    private short egDBatt = (short)-1;
    private short egSconAus = (short)-1;
    private short egConAus = (short)-1;
    private short[] ideLibOffline;
    private short[] ideLibCfgError;
    private short[] ideLibNotPrg;
    private short[] loopStatus;
    private short[] loopDisabled;
    private short[] lcdStatus;
    private short[][] annunciatorStatus;
    private short[] zoneStatus;
    private short[][] sensorStatus;
    private short[][] sensorAnalog;
    private short[][] moduleStatus;
    private short[][] moduleAnalog;

    public NOTIFIER() {
        short[] sArray = new short[5];
        sArray[1] = -1;
        sArray[2] = -1;
        sArray[3] = -1;
        sArray[4] = -1;
        this.ideLibOffline = sArray;
        short[] sArray2 = new short[5];
        sArray2[1] = -1;
        sArray2[2] = -1;
        sArray2[3] = -1;
        sArray2[4] = -1;
        this.ideLibCfgError = sArray2;
        short[] sArray3 = new short[5];
        sArray3[1] = -1;
        sArray3[2] = -1;
        sArray3[3] = -1;
        sArray3[4] = -1;
        this.ideLibNotPrg = sArray3;
        this.loopStatus = new short[17];
        this.loopDisabled = new short[17];
        this.lcdStatus = new short[17];
        this.annunciatorStatus = new short[17][5];
        this.zoneStatus = new short[151];
        this.sensorStatus = new short[17][100];
        this.sensorAnalog = new short[17][100];
        this.moduleStatus = new short[17][100];
        this.moduleAnalog = new short[17][100];
    }

    void monitor(int ioIndex, ioMonitor me) {
        int pollingExceptionsCounter = 0;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb;
            if (sa[i2].length() > 0 && (sb = sa[i2].split("=")).length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                        this.logLines = 0;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equals("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.startupEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.startupEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equals("address")) {
                    int v = Integer.parseInt(value);
                    if (v > 0 && v < 256) {
                        this.unitModbusId = v;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - address ignored");
                    }
                } else if (param.equals("lastzone")) {
                    int v = Integer.parseInt(value);
                    if (v >= -1 && v <= 150) {
                        this.lastZone = v;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - zonelimit ignored");
                    }
                } else if (param.equals("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl * 1000;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equals("loglines")) {
                    int v = Integer.parseInt(value);
                    if (v >= 0) {
                        this.logLines = v;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - loglines ignored");
                    }
                } else if (param.equals("protocolversion")) {
                    if (value.equals("1")) {
                        this.protocolNew = false;
                    } else if (value.equals("2")) {
                        this.protocolNew = true;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - protocolversion ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 42, this);
            switch (Configuration.language) {
                case 1: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ITALIAN);
                    break;
                }
                case 2: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.FRENCH);
                    break;
                }
                default: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ENGLISH);
                }
            }
        }
        try {
            this.init(me);
            this.polling(me, this.startupEvents);
            this.initialized = true;
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
            this.uiLog("ONLINE");
        }
        catch (Exception e4) {
            this.log(3, "ioMonitor - Initializzation error - " + e4.getLocalizedMessage());
            NOTIFIER.sleep(30000L);
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        try {
            String cmd = null;
            while (!me.quit) {
                block56: {
                    cmd = this.ioqtx.poll(this.pollinterval, TimeUnit.MILLISECONDS);
                    if (cmd != null) {
                        int counter = 0;
                        do {
                            this.processCommand(cmd);
                        } while ((cmd = this.ioqtx.poll()) != null && counter++ < 10);
                    }
                    try {
                        this.polling(me, true);
                        if (pollingExceptionsCounter > 0) {
                            --pollingExceptionsCounter;
                        }
                    }
                    catch (Exception e5) {
                        if (++pollingExceptionsCounter < 10) break block56;
                        throw new Exception(String.valueOf(e5.getLocalizedMessage()) + " (too many errors)");
                    }
                }
                this.uiUpdate();
                me.heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception e6) {
            this.log(3, "ioMonitor - Polling loop fatal error - " + e6.getLocalizedMessage());
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        if (this.initialized) {
            this.ioWrite(true, "connection", "offline");
            this.uiLog("OFFLINE");
        }
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            try {
                int pointidx = id.lastIndexOf(46);
                String name = id.substring(0, pointidx).trim();
                String value = id.substring(pointidx + 1).trim();
                this.log(1, "keypad - processing command: " + name + " = " + value);
                SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
            }
            catch (Exception e2) {
                this.log(3, "keypad - exception processing command: " + id);
                return null;
            }
        }
        return "";
    }

    private void init(ioMonitor me) throws Exception {
        short t;
        StringBuffer sb;
        byte[] d2;
        int i2;
        int j2;
        long discoverytime = System.currentTimeMillis() + 200000L;
        int i3 = 0;
        while (i3 < this.zoneStatus.length) {
            this.zoneStatus[i3] = -1;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.sensorStatus.length) {
            j2 = 0;
            while (j2 < this.sensorStatus[0].length) {
                this.sensorStatus[i3][j2] = -1;
                this.sensorAnalog[i3][j2] = -1;
                ++j2;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.moduleStatus.length) {
            j2 = 0;
            while (j2 < this.moduleStatus[0].length) {
                this.moduleStatus[i3][j2] = -1;
                this.moduleAnalog[i3][j2] = -1;
                ++j2;
            }
            ++i3;
        }
        if (this.guiSupport) {
            this.langugeInit();
            String log = SystemState.varGet("_notifier." + this.serverName + ".log!");
            if (log != null) {
                String[] la = log.split("<br>");
                i2 = 0;
                while (i2 < la.length) {
                    this.logEntries.add(la[i2]);
                    ++i2;
                }
            }
            this.uiLog();
        }
        while (System.currentTimeMillis() < discoverytime) {
            me.heartbeat = System.currentTimeMillis();
            if (this.protocolNew) {
                d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 18, 1);
                if (d2 == null || d2.length != 4) {
                    throw new Exception("Initialization error: offline");
                }
                if (d2[2] != 0 || d2[3] != 0) {
                    throw new Exception("Initialization error: HARDKEY_ENA");
                }
            } else {
                d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 75, 1);
                if (d2 == null || d2.length != 4) {
                    throw new Exception("Initialization error: offline");
                }
                if (d2[2] != 0 || d2[3] != 0) {
                    throw new Exception("Initialization error: EG_JUMPPRG");
                }
            }
            NOTIFIER.sleep(this.pollinterval);
        }
        if (this.protocolNew) {
            d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 43, 16);
            if (d2 == null || d2.length != 34) {
                throw new Exception("Initialization error: loops discovery failed");
            }
            sb = new StringBuffer();
            i = 1;
            while (i <= 16) {
                if ((d2[1 + 2 * i] & 1) != 0) {
                    this.loopConfig[i] = true;
                    sb.append(' ');
                    sb.append(i);
                } else {
                    this.loopConfig[i] = false;
                }
                ++i;
            }
            if (sb.length() > 0) {
                String s = sb.toString();
                this.log(0, "Detected loops:" + s);
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.loops", s);
            } else {
                this.log(0, "Detected loops: --");
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.loops", "");
            }
        } else {
            d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 82, 16);
            if (d2 == null || d2.length != 34) {
                throw new Exception("Initialization error: loops discovery failed");
            }
            sb = new StringBuffer();
            i = 1;
            while (i <= 16) {
                if (d2[1 + 2 * i] == 0) {
                    this.loopConfig[i] = true;
                    sb.append(' ');
                    sb.append(i);
                } else {
                    this.loopConfig[i] = false;
                }
                ++i;
            }
            if (sb.length() > 0) {
                String s = sb.toString();
                this.log(0, "Detected loops:" + s);
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.loops", s);
            } else {
                this.log(0, "Detected loops: --");
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.loops", "");
            }
        }
        me.heartbeat = System.currentTimeMillis();
        int l2 = 1;
        while (l2 <= 16) {
            if (this.loopConfig[l2] || !this.protocolNew) {
                sb = new StringBuffer();
                int p = 0;
                while (p < 5) {
                    d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 5001 + 100 * (l2 - 1) + 20 * p, 20);
                    if (d2 == null) {
                        throw new Exception("Initialization error: sensors discovery failed");
                    }
                    i2 = 0;
                    while (i2 < (d2.length - 2) / 2) {
                        t = (short)(d2[3 + i2 * 2] & 0xFF);
                        int s = p * 20 + i2 + 1;
                        if (t != 0) {
                            this.loopConfig[l2] = true;
                            this.sensorConfig[l2][s] = t;
                            sb.append(' ');
                            sb.append(s);
                            sb.append(':');
                            sb.append(this.decodeSensorType(t));
                        }
                        ++i2;
                    }
                    me.heartbeat = System.currentTimeMillis();
                    ++p;
                }
                if (this.loopConfig[l2]) {
                    if (sb.length() > 0) {
                        String s = sb.toString();
                        this.log(0, "Detected sensors [loop " + l2 + "]:" + s);
                        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.sensors." + l2, s.trim().toLowerCase());
                    } else {
                        this.log(0, "Detected sensors [loop " + l2 + "]: --");
                        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.sensors." + l2, "");
                    }
                }
            }
            ++l2;
        }
        l2 = 1;
        while (l2 <= 16) {
            if (this.loopConfig[l2] || !this.protocolNew) {
                sb = new StringBuffer();
                int p = 0;
                while (p < 5) {
                    d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 14001 + 100 * (l2 - 1) + 20 * p, 20);
                    if (d2 == null || d2.length != 42) {
                        throw new Exception("Initialization error: modules discovery failed");
                    }
                    i2 = 0;
                    while (i2 < 20) {
                        t = (short)(d2[3 + i2 * 2] & 0xFF);
                        int m2 = p * 20 + i2 + 1;
                        if (t != 0) {
                            this.loopConfig[l2] = true;
                            this.moduleConfig[l2][m2] = t;
                            sb.append(' ');
                            sb.append(m2);
                            sb.append(':');
                            sb.append(this.decodeModuleType(t));
                        }
                        ++i2;
                    }
                    me.heartbeat = System.currentTimeMillis();
                    ++p;
                }
                if (this.loopConfig[l2]) {
                    if (sb.length() > 0) {
                        String s = sb.toString();
                        this.log(0, "Detected modules [loop " + l2 + "]:" + s);
                        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.modules." + l2, s.trim().toLowerCase());
                    } else {
                        this.log(0, "Detected modules [loop " + l2 + "]: --");
                        SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.modules." + l2, "");
                    }
                }
            }
            ++l2;
        }
        if (this.protocolNew) {
            sb = new StringBuffer();
            d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 59, 16);
            if (d2 != null) {
                i = 0;
                while (i < (d2.length - 2) / 2) {
                    short l3 = (short)(d2[3 + i * 2] & 0xFF);
                    if (l3 != 0) {
                        this.lcdConfig[i + 1] = true;
                        sb.append(' ');
                        sb.append(l3);
                    }
                    ++i;
                }
            }
            me.heartbeat = System.currentTimeMillis();
            if (sb.length() > 0) {
                String s = sb.toString();
                this.log(0, "Detected LCDs:" + s);
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.lcds", s.trim());
            } else {
                this.log(0, "Detected LCDs: --");
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.lcds", "");
            }
        }
        if (this.protocolNew) {
            sb = new StringBuffer();
            int p = 1;
            while (p <= 16) {
                d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 70 + 5 * p, 5);
                if (d2 != null) {
                    int i4 = 1;
                    while (i4 <= (d2.length - 2) / 2) {
                        short a2 = (short)(d2[1 + i4 * 2] & 0xFF);
                        if (a2 != 0) {
                            this.annunciatorConfig[p][i4] = true;
                            sb.append(' ');
                            sb.append(p);
                            if (i4 != 0) {
                                sb.append('.');
                                sb.append(i4);
                            }
                        }
                        ++i4;
                    }
                }
                me.heartbeat = System.currentTimeMillis();
                ++p;
            }
            if (sb.length() > 0) {
                String s = sb.toString();
                this.log(0, "Detected annunciators:" + s);
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.annunciators", s.trim());
            } else {
                this.log(0, "Detected annunciators: --");
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.annunciators", "");
            }
        }
    }

    private void polling(ioMonitor me, boolean events2) throws Exception {
        if (this.protocolNew) {
            int i2;
            short v;
            byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 0, 20);
            if (d2 == null || d2.length != 42) {
                throw new Exception("read failed, stage 1");
            }
            me.heartbeat = System.currentTimeMillis();
            short s = v = d2[3] == 0 ? (short)1 : 0;
            if (this.panelFireNormal != v) {
                this.panelFireNormal = v;
                this.ioWrite(events2, "panel.fire.normal", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[10]);
                }
            }
            short s2 = v = (d2[3] & 1) == 0 ? (short)0 : 1;
            if (this.panelFireExclusions != v) {
                this.panelFireExclusions = v;
                this.ioWrite(events2, "panel.fire.exclusions", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[30]);
                }
            }
            short s3 = v = (d2[3] & 2) == 0 ? (short)0 : 1;
            if (this.panelFireTest != v) {
                this.panelFireTest = v;
                this.ioWrite(events2, "panel.fire.test", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[31]);
                }
            }
            short s4 = v = (d2[3] & 4) == 0 ? (short)0 : 1;
            if (this.panelFireFault != v) {
                this.panelFireFault = v;
                this.ioWrite(events2, "panel.fire.fault", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[13]);
                }
            }
            short s5 = v = (d2[3] & 8) == 0 ? (short)0 : 1;
            if (this.panelFireAlarm != v) {
                this.panelFireAlarm = v;
                this.ioWrite(events2, "panel.fire.alarm", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[12]);
                }
            }
            short s6 = v = (d2[3] & 0x10) == 0 ? (short)0 : 1;
            if (this.panelFireAlarmSilent != v) {
                this.panelFireAlarmSilent = v;
                this.ioWrite(events2, "panel.fire.alarm.silent", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[12] + " " + this.string[32]);
                }
            }
            short s7 = v = (d2[3] & 0x20) == 0 ? (short)0 : 1;
            if (this.panelFireUnknown != v) {
                this.panelFireUnknown = v;
                this.ioWrite(events2, "panel.fire.ack", Integer.toString(v));
            }
            short s8 = v = d2[5] == 0 ? (short)1 : 0;
            if (this.panelTechNormal != v) {
                this.panelTechNormal = v;
                this.ioWrite(events2, "panel.tech.normal", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[2] + " " + this.string[10]);
                }
            }
            short s9 = v = (d2[5] & 1) == 0 ? (short)0 : 1;
            if (this.panelTechExclusions != v) {
                this.panelTechExclusions = v;
                this.ioWrite(events2, "panel.tech.exclusions", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[2] + " " + this.string[30]);
                }
            }
            short s10 = v = (d2[5] & 2) == 0 ? (short)0 : 1;
            if (this.panelTechTest != v) {
                this.panelTechTest = v;
                this.ioWrite(events2, "panel.tech.test", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[2] + " " + this.string[31]);
                }
            }
            short s11 = v = (d2[5] & 4) == 0 ? (short)0 : 1;
            if (this.panelTechFault != v) {
                this.panelTechFault = v;
                this.ioWrite(events2, "panel.tech.fault", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[2] + " " + this.string[13]);
                }
            }
            short s12 = v = (d2[5] & 8) == 0 ? (short)0 : 1;
            if (this.panelTechAlarm != v) {
                this.panelTechAlarm = v;
                this.ioWrite(events2, "panel.tech.alarm", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[2] + " " + this.string[12]);
                }
            }
            short s13 = v = (d2[5] & 0x20) == 0 ? (short)0 : 1;
            if (this.panelTechAck != v) {
                this.panelTechAck = v;
                this.ioWrite(events2, "panel.tech.ack", Integer.toString(v));
            }
            short s14 = v = d2[7] == 0 ? (short)0 : 1;
            if (this.ideFltBattDiscon != v) {
                this.ideFltBattDiscon = v;
                this.ioWrite(events2, "panel.fault.batt.disconn", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 2");
            }
            short s15 = v = d2[9] == 0 ? (short)0 : 1;
            if (this.ideFltPower != v) {
                this.ideFltPower = v;
                this.ioWrite(events2, "panel.fault.power", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 3");
            }
            short s16 = v = d2[11] == 0 ? (short)0 : 1;
            if (this.ideFtlBattUnbal != v) {
                this.ideFtlBattUnbal = v;
                this.ioWrite(events2, "panel.fault.batt.unbal", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 4");
            }
            short s17 = v = d2[13] == 0 ? (short)0 : 1;
            if (this.ideFltBattFail != v) {
                this.ideFltBattFail = v;
                this.ioWrite(events2, "panel.fault.batt.fail", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 5");
            }
            short s18 = v = d2[15] == 0 ? (short)0 : 1;
            if (this.ideFltBex != v) {
                this.ideFltBex = v;
                this.ioWrite(events2, "panel.fault.bex", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 6");
            }
            short s19 = v = d2[17] == 0 ? (short)0 : 1;
            if (this.ideFltEarth != v) {
                this.ideFltEarth = v;
                this.ioWrite(events2, "panel.fault.earth", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 7");
            }
            short s20 = v = d2[19] == 0 ? (short)0 : 1;
            if (this.ideFltUndervoltage != v) {
                this.ideFltUndervoltage = v;
                this.ioWrite(events2, "panel.fault.undervoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 8");
            }
            short s21 = v = d2[21] == 0 ? (short)0 : 1;
            if (this.ideFltOvervoltage != v) {
                this.ideFltOvervoltage = v;
                this.ioWrite(events2, "panel.fault.overvoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 9");
            }
            short s22 = v = d2[23] == 0 ? (short)0 : 1;
            if (this.ideFltLcopen != v) {
                this.ideFltLcopen = v;
                this.ioWrite(events2, "panel.fault.siren.open", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 10");
            }
            short s23 = v = d2[25] == 0 ? (short)0 : 1;
            if (this.ideFltLcshort != v) {
                this.ideFltLcshort = v;
                this.ioWrite(events2, "panel.fault.siren.short", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 11");
            }
            short s24 = v = d2[27] == 0 ? (short)0 : 1;
            if (this.ideFltFuse != v) {
                this.ideFltFuse = v;
                this.ioWrite(events2, "panel.fault.fuse", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 12");
            }
            short s25 = v = d2[29] == 0 ? (short)0 : 1;
            if (this.ideFltBattChargerUv != v) {
                this.ideFltBattChargerUv = v;
                this.ioWrite(events2, "panel.fault.batt.charger.undervoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 13");
            }
            short s26 = v = d2[31] == 0 ? (short)0 : 1;
            if (this.ideFltBattChargerOv != v) {
                this.ideFltBattChargerOv = v;
                this.ioWrite(events2, "panel.fault.batt.charger.overvoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 14");
            }
            short s27 = v = d2[33] == 0 ? (short)0 : 1;
            if (this.ideFilesysClearError != v) {
                this.ideFilesysClearError = v;
                this.ioWrite(events2, "panel.filesystem.clear.error", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 15");
            }
            short s28 = v = d2[35] == 0 ? (short)0 : 1;
            if (this.ideFilesysInitError != v) {
                this.ideFilesysInitError = v;
                this.ioWrite(events2, "panel.filesystem.init.error", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 16");
            }
            short s29 = v = d2[37] == 0 ? (short)0 : 1;
            if (this.ideReliabParMod != v) {
                this.ideReliabParMod = v;
                this.ioWrite(events2, "panel.reliab.par.mod", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 17");
            }
            short s30 = v = d2[39] == 0 ? (short)0 : 1;
            if (this.ideHardkeyEna != v) {
                this.ideHardkeyEna = v;
                this.ioWrite(events2, "panel.hardkey.enabled", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 18");
                if (this.ideHardkeyEna == 1) {
                    me.quit = true;
                }
            }
            short s31 = v = d2[41] == 0 ? (short)0 : 1;
            if (this.idePowerOn != v) {
                this.idePowerOn = v;
                this.ioWrite(events2, "panel.power.on", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 19");
            }
            if ((d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 20, 11)) == null || d2.length != 24) {
                throw new Exception("read failed, stage 2");
            }
            me.heartbeat = System.currentTimeMillis();
            short s32 = v = d2[3] == 0 ? (short)0 : 1;
            if (this.ideWdtReset != v) {
                this.ideWdtReset = v;
                this.ioWrite(events2, "panel.wdt.reset", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 20");
            }
            short s33 = v = d2[5] == 0 ? (short)0 : 1;
            if (this.ideCfgError != v) {
                this.ideCfgError = v;
                this.ioWrite(events2, "panel.cfg.error", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 21");
            }
            short s34 = v = d2[7] == 0 ? (short)0 : 1;
            if (this.ideFilesystemErr != v) {
                this.ideFilesystemErr = v;
                this.ioWrite(events2, "panel.filesystem.error", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 22");
            }
            short s35 = v = d2[9] == 0 ? (short)0 : 1;
            if (this.ideFltHardClock != v) {
                this.ideFltHardClock = v;
                this.ioWrite(events2, "panel.hard.clock", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 23");
            }
            short s36 = v = d2[11] == 0 ? (short)0 : 1;
            if (this.ideFltArchFull != v) {
                this.ideFltArchFull = v;
                this.ioWrite(events2, "panel.arch.full", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 24");
            }
            short s37 = v = d2[13] == 0 ? (short)0 : 1;
            if (this.ideFltArchFullWrng != v) {
                this.ideFltArchFullWrng = v;
                this.ioWrite(events2, "panel.arch.full.warning", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 25");
            }
            short s38 = v = d2[15] == 0 ? (short)0 : 1;
            if (this.ideFltZoneDefault != v) {
                this.ideFltZoneDefault = v;
                this.ioWrite(events2, "panel.zone.default", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 26");
            }
            short s39 = v = d2[17] == 0 ? (short)0 : 1;
            if (this.ideSibOffline != v) {
                this.ideSibOffline = v;
                this.ioWrite(events2, "panel.sib.offline", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 27");
            }
            short s40 = v = d2[19] == 0 ? (short)0 : 1;
            if (this.ideSibNotPrg != v) {
                this.ideSibNotPrg = v;
                this.ioWrite(events2, "panel.sib.not.prg", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 28");
            }
            short s41 = v = d2[21] == 0 ? (short)0 : 1;
            if (this.idePcInvalidCmd != v) {
                this.idePcInvalidCmd = v;
                this.ioWrite(events2, "panel.pc.invalid.cmd", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 29");
            }
            short s42 = v = d2[23] == 0 ? (short)0 : 1;
            if (this.ideFltArchDisabled != v) {
                this.ideFltArchDisabled = v;
                this.ioWrite(events2, "panel.arch.disabled", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 30");
            }
            if ((d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 31, 12)) == null || d2.length != 26) {
                throw new Exception("read failed, stage 3");
            }
            me.heartbeat = System.currentTimeMillis();
            int lib = 1;
            while (lib <= 4) {
                short s43 = v = d2[1 + lib * 2] == 0 ? (short)0 : 1;
                if (this.ideLibOffline[lib] != v) {
                    this.ideLibOffline[lib] = v;
                    this.ioWrite(events2, "panel.lib." + lib + ".offline", Integer.toString(v));
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[35] + " " + lib + " " + (v == 1 ? this.string[28] : this.string[27]));
                }
                short s44 = v = d2[9 + lib * 2] == 0 ? (short)0 : 1;
                if (this.ideLibCfgError[lib] != v) {
                    this.ideLibCfgError[lib] = v;
                    this.ioWrite(events2, "panel.lib." + lib + ".cfg.error", Integer.toString(v));
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[35] + " " + lib + " " + (v == 1 ? this.string[36] : this.string[37]));
                }
                short s45 = v = d2[17 + lib * 2] == 0 ? (short)0 : 1;
                if (this.ideLibNotPrg[lib] != v) {
                    this.ideLibNotPrg[lib] = v;
                    this.ioWrite(events2, "panel.lib." + lib + ".not.prg", Integer.toString(v));
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[35] + " " + lib + " " + (v == 1 ? this.string[41] : this.string[40]));
                }
                ++lib;
            }
            int to = 0;
            int from = 0;
            int i3 = 1;
            while (i3 <= 16) {
                if (this.loopConfig[i3]) {
                    if (from == 0) {
                        from = to = i3;
                    } else {
                        to = i3;
                    }
                } else if (from != 0) {
                    this.pollLoops(events2, from, to);
                    me.heartbeat = System.currentTimeMillis();
                    to = 0;
                    from = 0;
                }
                ++i3;
            }
            if (from != 0) {
                this.pollLoops(events2, from, to);
                me.heartbeat = System.currentTimeMillis();
            }
            to = 0;
            from = 0;
            i3 = 1;
            while (i3 <= 16) {
                if (this.lcdConfig[i3]) {
                    if (from == 0) {
                        from = to = i3;
                    } else {
                        to = i3;
                    }
                } else if (from != 0) {
                    this.pollLCDs(events2, from, to);
                    me.heartbeat = System.currentTimeMillis();
                    to = 0;
                    from = 0;
                }
                ++i3;
            }
            if (from != 0) {
                this.pollLCDs(events2, from, to);
                me.heartbeat = System.currentTimeMillis();
            }
            to = 0;
            from = 0;
            i3 = 1;
            while (i3 <= 80) {
                if (this.annunciatorConfig[1 + (i3 - 1) / 5][i3 % 5]) {
                    if (from == 0) {
                        from = to = i3;
                    } else if (i3 - from < 20) {
                        to = i3;
                    } else {
                        this.pollAnnunciators(events2, from, to);
                        me.heartbeat = System.currentTimeMillis();
                        from = to = i3;
                    }
                } else if (from != 0) {
                    this.pollAnnunciators(events2, from, to);
                    me.heartbeat = System.currentTimeMillis();
                    to = 0;
                    from = 0;
                }
                ++i3;
            }
            if (from != 0) {
                this.pollAnnunciators(events2, from, to);
                me.heartbeat = System.currentTimeMillis();
            }
            to = -1;
            from = -1;
            i3 = 1;
            while (i3 <= this.lastZone) {
                if (from == -1) {
                    from = to = i3;
                } else if (i3 - from < 20) {
                    to = i3;
                } else {
                    this.pollZones(events2, from, to);
                    me.heartbeat = System.currentTimeMillis();
                    from = to = i3;
                }
                ++i3;
            }
            if (from != -1) {
                this.pollZones(events2, from, to);
                me.heartbeat = System.currentTimeMillis();
            }
            int l2 = 1;
            while (l2 <= 16) {
                if (this.loopConfig[l2]) {
                    to = 0;
                    from = 0;
                    i2 = 1;
                    while (i2 <= 99) {
                        if (this.sensorConfig[l2][i2] != 0) {
                            if (from == 0) {
                                from = to = i2;
                            } else if (i2 - from < 20) {
                                to = i2;
                            } else {
                                this.pollSensors(events2, l2, from, to);
                                me.heartbeat = System.currentTimeMillis();
                                from = to = i2;
                            }
                        } else if (from != 0) {
                            this.pollSensors(events2, l2, from, to);
                            me.heartbeat = System.currentTimeMillis();
                            to = 0;
                            from = 0;
                        }
                        ++i2;
                    }
                    if (from != 0) {
                        this.pollSensors(events2, l2, from, to);
                        me.heartbeat = System.currentTimeMillis();
                    }
                }
                ++l2;
            }
            l2 = 1;
            while (l2 <= 16) {
                if (this.loopConfig[l2]) {
                    to = 0;
                    from = 0;
                    i2 = 1;
                    while (i2 <= 99) {
                        if (this.moduleConfig[l2][i2] != 0) {
                            if (from == 0) {
                                from = to = i2;
                            } else if (i2 - from < 20) {
                                to = i2;
                            } else {
                                this.pollModules(events2, l2, from, to);
                                me.heartbeat = System.currentTimeMillis();
                                from = to = i2;
                            }
                        } else if (from != 0) {
                            this.pollModules(events2, l2, from, to);
                            me.heartbeat = System.currentTimeMillis();
                            to = 0;
                            from = 0;
                        }
                        ++i2;
                    }
                    if (from != 0) {
                        this.pollModules(events2, l2, from, to);
                        me.heartbeat = System.currentTimeMillis();
                    }
                }
                ++l2;
            }
        } else {
            int i4;
            short v;
            byte[] d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 0, 19);
            if (d3 == null || d3.length != 40) {
                throw new Exception("read failed, stage 1");
            }
            me.heartbeat = System.currentTimeMillis();
            short s = v = d3[3] == 0 ? (short)1 : 0;
            if (this.panelFireNormal != v) {
                this.panelFireNormal = v;
                this.ioWrite(events2, "panel.fire.normal", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[10]);
                }
            }
            short s46 = v = (d3[3] & 1) == 0 ? (short)0 : 1;
            if (this.panelFireExclusions != v) {
                this.panelFireExclusions = v;
                this.ioWrite(events2, "panel.fire.exclusions", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[30]);
                }
            }
            short s47 = v = (d3[3] & 2) == 0 ? (short)0 : 1;
            if (this.panelFireTest != v) {
                this.panelFireTest = v;
                this.ioWrite(events2, "panel.fire.test", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[31]);
                }
            }
            short s48 = v = (d3[3] & 4) == 0 ? (short)0 : 1;
            if (this.panelFireFault != v) {
                this.panelFireFault = v;
                this.ioWrite(events2, "panel.fire.fault", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[13]);
                }
            }
            short s49 = v = (d3[3] & 8) == 0 ? (short)0 : 1;
            if (this.panelFireAlarm != v) {
                this.panelFireAlarm = v;
                this.ioWrite(events2, "panel.fire.alarm", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[12]);
                }
            }
            short s50 = v = (d3[3] & 0x10) == 0 ? (short)0 : 1;
            if (this.panelFireAlarmSilent != v) {
                this.panelFireAlarmSilent = v;
                this.ioWrite(events2, "panel.fire.alarm.silent", Integer.toString(v));
                if (v == 1) {
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[1] + " " + this.string[12] + " " + this.string[32]);
                }
            }
            short s51 = v = (d3[3] & 0x20) == 0 ? (short)0 : 1;
            if (this.panelFireUnknown != v) {
                this.panelFireUnknown = v;
                this.ioWrite(events2, "panel.fire.ack", Integer.toString(v));
            }
            short s52 = v = d3[25] == 0 ? (short)0 : 1;
            if (this.ideFltBattDiscon != v) {
                this.ideFltBattDiscon = v;
                this.ioWrite(events2, "panel.fault.batt.disconn", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 11");
            }
            short s53 = v = d3[5] == 0 ? (short)0 : 1;
            if (this.ideFltPower != v) {
                this.ideFltPower = v;
                this.ioWrite(events2, "panel.fault.power", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 1");
            }
            short s54 = v = d3[29] == 0 ? (short)0 : 1;
            if (this.ideFtlBattUnbal != v) {
                this.ideFtlBattUnbal = v;
                this.ioWrite(events2, "panel.fault.batt.unbal", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 13");
            }
            short s55 = v = d3[23] == 0 ? (short)0 : 1;
            if (this.ideFltBattFail != v) {
                this.ideFltBattFail = v;
                this.ioWrite(events2, "panel.fault.batt.fail", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 10");
            }
            short s56 = v = d3[27] == 0 ? (short)0 : 1;
            if (this.ideFltBex != v) {
                this.ideFltBex = v;
                this.ioWrite(events2, "panel.fault.bex", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 12");
            }
            short s57 = v = d3[39] == 0 ? (short)0 : 1;
            if (this.ideFltEarth != v) {
                this.ideFltEarth = v;
                this.ioWrite(events2, "panel.fault.earth", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 18");
            }
            short s58 = v = d3[7] == 0 && d3[9] == 0 ? (short)0 : 1;
            if (this.ideFltUndervoltage != v) {
                this.ideFltUndervoltage = v;
                this.ioWrite(events2, "panel.fault.undervoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 2/3");
            }
            short s59 = v = d3[13] == 0 && d3[15] == 0 ? (short)0 : 1;
            if (this.ideFltOvervoltage != v) {
                this.ideFltOvervoltage = v;
                this.ioWrite(events2, "panel.fault.overvoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 5/6");
            }
            short s60 = v = d3[33] == 0 && d3[35] == 0 && d3[37] == 0 ? (short)0 : 1;
            if (this.ideFltFuse != v) {
                this.ideFltFuse = v;
                this.ioWrite(events2, "panel.fault.fuse", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 15/16/17");
            }
            short s61 = v = d3[11] == 0 ? (short)0 : 1;
            if (this.ideFltBattChargerUv != v) {
                this.ideFltBattChargerUv = v;
                this.ioWrite(events2, "panel.fault.batt.charger.undervoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 4");
            }
            short s62 = v = d3[17] == 0 ? (short)0 : 1;
            if (this.ideFltBattChargerOv != v) {
                this.ideFltBattChargerOv = v;
                this.ioWrite(events2, "panel.fault.batt.charger.overvoltage", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 7");
            }
            short s63 = v = d3[19] == 0 ? (short)0 : 1;
            if (this.egAnMain != v) {
                this.egAnMain = v;
                this.ioWrite(events2, "panel.fault.supply.main", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 8");
            }
            short s64 = v = d3[21] == 0 ? (short)0 : 1;
            if (this.egAnAux != v) {
                this.egAnAux = v;
                this.ioWrite(events2, "panel.fault.supply.aux", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 9");
            }
            short s65 = v = d3[31] == 0 ? (short)0 : 1;
            if (this.egSconAus != v) {
                this.egSconAus = v;
                this.ioWrite(events2, "panel.fault.supply.aux.disc", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 14");
            }
            if ((d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 19, 3)) == null || d3.length != 8) {
                throw new Exception("read failed, stage 1.1");
            }
            short s66 = v = d3[3] == 0 ? (short)0 : 1;
            if (this.ideFltLcopen != v) {
                this.ideFltLcopen = v;
                this.ioWrite(events2, "panel.fault.siren.open", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 19");
            }
            short s67 = v = d3[5] == 0 ? (short)0 : 1;
            if (this.ideFltLcshort != v) {
                this.ideFltLcshort = v;
                this.ioWrite(events2, "panel.fault.siren.short", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 20");
            }
            short s68 = v = d3[7] == 0 ? (short)0 : 1;
            if (this.egDBatt != v) {
                this.egDBatt = v;
                this.ioWrite(events2, "panel.fault.batt.low", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 21");
            }
            if ((d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 75, 4)) == null || d3.length != 10) {
                throw new Exception("read failed, stage 1.2");
            }
            short s69 = v = d3[3] == 0 ? (short)0 : 1;
            if (this.ideHardkeyEna != v) {
                this.ideHardkeyEna = v;
                this.ioWrite(events2, "panel.hardkey.enabled", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 75");
                if (this.ideHardkeyEna == 1) {
                    me.quit = true;
                }
            }
            short s70 = v = d3[5] == 0 ? (short)0 : 1;
            if (this.idePowerOn != v) {
                this.idePowerOn = v;
                this.ioWrite(events2, "panel.power.on", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 76");
            }
            short s71 = v = d3[7] == 0 ? (short)0 : 1;
            if (this.ideWdtReset != v) {
                this.ideWdtReset = v;
                this.ioWrite(events2, "panel.wdt.reset", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 77");
            }
            short s72 = v = d3[9] == 0 ? (short)0 : 1;
            if (this.egOfflTerm != v) {
                this.egOfflTerm = v;
                this.ioWrite(events2, "lcd.offline", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[7]) + " " + (v == 1 ? this.string[28] : this.string[27]) + ": 78");
            }
            if ((d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 162, 1)) == null || d3.length != 4) {
                throw new Exception("read failed, stage 1.3");
            }
            short s73 = v = d3[3] == 0 ? (short)0 : 1;
            if (this.ideReliabParMod != v) {
                this.ideReliabParMod = v;
                this.ioWrite(events2, "panel.reliab.par.mod", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 162");
            }
            if ((d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 166, 2)) == null || d3.length != 6) {
                throw new Exception("read failed, stage 1.4");
            }
            short s74 = v = d3[3] == 0 ? (short)0 : 1;
            if (this.ideFltArchDisabled != v) {
                this.ideFltArchDisabled = v;
                this.ioWrite(events2, "panel.arch.disabled", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 166");
            }
            short s75 = v = d3[5] == 0 ? (short)0 : 1;
            if (this.egConAus != v) {
                this.egConAus = v;
                this.ioWrite(events2, "panel.fault.supply.aux.not.prg", Integer.toString(v));
                this.uiLog(String.valueOf(this.string[0]) + " " + (v == 1 ? this.string[13] : this.string[34]) + ": 167");
            }
            if ((d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 55, 3)) == null || d3.length != 8) {
                throw new Exception("read failed, stage 1.5");
            }
            int lib = 1;
            while (lib <= 3) {
                short s76 = v = d3[1 + lib * 2] == 0 ? (short)0 : 1;
                if (this.ideLibOffline[lib] != v) {
                    this.ideLibOffline[lib] = v;
                    this.ioWrite(events2, "panel.lib." + lib + ".offline", Integer.toString(v));
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[35] + " " + lib + " " + (v == 1 ? this.string[28] : this.string[27]));
                }
                ++lib;
            }
            d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 79, 3);
            if (d3 == null || d3.length != 8) {
                throw new Exception("read failed, stage 1.6");
            }
            lib = 1;
            while (lib <= 3) {
                short s77 = v = d3[1 + lib * 2] == 0 ? (short)0 : 1;
                if (this.ideLibCfgError[lib] != v) {
                    this.ideLibCfgError[lib] = v;
                    this.ioWrite(events2, "panel.lib." + lib + ".cfg.error", Integer.toString(v));
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[35] + " " + lib + " " + (v == 1 ? this.string[36] : this.string[37]));
                }
                ++lib;
            }
            d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 163, 3);
            if (d3 == null || d3.length != 8) {
                throw new Exception("read failed, stage 1.7");
            }
            lib = 1;
            while (lib <= 3) {
                short s78 = v = d3[1 + lib * 2] == 0 ? (short)0 : 1;
                if (this.ideLibNotPrg[lib] != v) {
                    this.ideLibNotPrg[lib] = v;
                    this.ioWrite(events2, "panel.lib." + lib + ".not.prg", Integer.toString(v));
                    this.uiLog(String.valueOf(this.string[0]) + " " + this.string[35] + " " + lib + " " + (v == 1 ? this.string[41] : this.string[40]));
                }
                ++lib;
            }
            int to = 0;
            int from = 0;
            int i5 = 1;
            while (i5 <= 16) {
                if (this.loopConfig[i5]) {
                    if (from == 0) {
                        from = to = i5;
                    } else {
                        to = i5;
                    }
                } else if (from != 0) {
                    this.pollLoops(events2, from, to);
                    me.heartbeat = System.currentTimeMillis();
                    to = 0;
                    from = 0;
                }
                ++i5;
            }
            if (from != 0) {
                this.pollLoops(events2, from, to);
                me.heartbeat = System.currentTimeMillis();
            }
            this.pollAnnunciators(events2, 0, 0);
            to = -1;
            from = -1;
            i5 = 1;
            while (i5 <= this.lastZone) {
                if (from == -1) {
                    from = to = i5;
                } else if (i5 - from < 20) {
                    to = i5;
                } else {
                    this.pollZones(events2, from, to);
                    me.heartbeat = System.currentTimeMillis();
                    from = to = i5;
                }
                ++i5;
            }
            if (from != -1) {
                this.pollZones(events2, from, to);
                me.heartbeat = System.currentTimeMillis();
            }
            int l3 = 1;
            while (l3 <= 16) {
                if (this.loopConfig[l3]) {
                    to = 0;
                    from = 0;
                    i4 = 1;
                    while (i4 <= 99) {
                        if (this.sensorConfig[l3][i4] != 0) {
                            if (from == 0) {
                                from = to = i4;
                            } else if (i4 - from < 20) {
                                to = i4;
                            } else {
                                this.pollSensors(events2, l3, from, to);
                                me.heartbeat = System.currentTimeMillis();
                                from = to = i4;
                            }
                        } else if (from != 0) {
                            this.pollSensors(events2, l3, from, to);
                            me.heartbeat = System.currentTimeMillis();
                            to = 0;
                            from = 0;
                        }
                        ++i4;
                    }
                    if (from != 0) {
                        this.pollSensors(events2, l3, from, to);
                        me.heartbeat = System.currentTimeMillis();
                    }
                }
                ++l3;
            }
            l3 = 1;
            while (l3 <= 16) {
                if (this.loopConfig[l3]) {
                    to = 0;
                    from = 0;
                    i4 = 1;
                    while (i4 <= 99) {
                        if (this.moduleConfig[l3][i4] != 0) {
                            if (from == 0) {
                                from = to = i4;
                            } else if (i4 - from < 20) {
                                to = i4;
                            } else {
                                this.pollModules(events2, l3, from, to);
                                me.heartbeat = System.currentTimeMillis();
                                from = to = i4;
                            }
                        } else if (from != 0) {
                            this.pollModules(events2, l3, from, to);
                            me.heartbeat = System.currentTimeMillis();
                            to = 0;
                            from = 0;
                        }
                        ++i4;
                    }
                    if (from != 0) {
                        this.pollModules(events2, l3, from, to);
                        me.heartbeat = System.currentTimeMillis();
                    }
                }
                ++l3;
            }
        }
    }

    private void pollLoops(boolean events2, int from, int to) throws Exception {
        if (this.protocolNew) {
            byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 42 + from, to - from + 1);
            if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
                throw new Exception("read failed, stage 4");
            }
            int i2 = from;
            while (i2 <= to) {
                short v = d2[3 + 2 * (i2 - from)];
                if (v != this.loopStatus[i2]) {
                    this.loopStatus[i2] = v;
                    this.ioWrite(events2, "loop." + i2 + ".short", (v & 2) != 0 ? "1" : "0");
                    this.ioWrite(events2, "loop." + i2 + ".open", (v & 4) != 0 ? "1" : "0");
                    this.ioWrite(events2, "loop." + i2 + ".voltage", (v & 8) != 0 ? "1" : "0");
                    if (this.logLines > 0) {
                        String s = String.valueOf(this.string[3]) + " " + i2 + ": ";
                        if (v == 0) {
                            this.uiLog(String.valueOf(s) + this.string[10]);
                        } else {
                            if ((v & 2) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[24]);
                            }
                            if ((v & 4) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[25]);
                            }
                            if ((v & 8) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[26]);
                            }
                        }
                    }
                }
                ++i2;
            }
        } else {
            short v;
            byte[] d3 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 82, 16);
            if (d3 == null || d3.length != 34) {
                throw new Exception("read failed, stage 4.0");
            }
            int i3 = 1;
            while (i3 <= 16) {
                v = d3[1 + 2 * i3];
                if (v != this.loopDisabled[i3]) {
                    this.loopDisabled[i3] = v;
                    this.ioWrite(events2, "loop." + i3 + ".disabled", v != 0 ? "1" : "0");
                    if (this.logLines > 0) {
                        this.uiLog(String.valueOf(this.string[3]) + " " + i3 + ": " + (v != 0 ? this.string[17] : this.string[16]));
                    }
                }
                ++i3;
            }
            byte[] d1 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 21 + from, to - from + 1);
            if (d1 == null || d1.length != 2 + 2 * (to - from + 1)) {
                throw new Exception("read failed, stage 4.1");
            }
            byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 37 + from, to - from + 1);
            if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
                throw new Exception("read failed, stage 4.2");
            }
            byte[] d32 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 57 + from, to - from + 1);
            if (d32 == null || d32.length != 2 + 2 * (to - from + 1)) {
                throw new Exception("read failed, stage 4.3");
            }
            int i4 = from;
            while (i4 <= to) {
                v = (short)((d1[3 + 2 * (i4 - from)] != 0 ? 4 : 0) + (d2[3 + 2 * (i4 - from)] != 0 ? 2 : 0) + (d32[3 + 2 * (i4 - from)] != 0 ? 8 : 0));
                if (v != this.loopStatus[i4]) {
                    this.loopStatus[i4] = v;
                    this.ioWrite(events2, "loop." + i4 + ".short", (v & 2) != 0 ? "1" : "0");
                    this.ioWrite(events2, "loop." + i4 + ".open", (v & 4) != 0 ? "1" : "0");
                    this.ioWrite(events2, "loop." + i4 + ".voltage", (v & 8) != 0 ? "1" : "0");
                    if (this.logLines > 0) {
                        String s = String.valueOf(this.string[3]) + " " + i4 + ": ";
                        if (v == 0) {
                            this.uiLog(String.valueOf(s) + this.string[10]);
                        } else {
                            if ((v & 2) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[24]);
                            }
                            if ((v & 4) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[25]);
                            }
                            if ((v & 8) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[26]);
                            }
                        }
                    }
                }
                ++i4;
            }
        }
    }

    private void pollLCDs(boolean events2, int from, int to) throws Exception {
        byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 58 + from, to - from + 1);
        if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
            throw new Exception("read failed, stage 5");
        }
        int i2 = from;
        while (i2 <= to) {
            short v = d2[3 + 2 * (i2 - from)];
            if (v != this.lcdStatus[i2]) {
                this.lcdStatus[i2] = v;
                this.ioWrite(events2, "lcd." + i2 + ".offline", (v & 2) != 0 ? "1" : "0");
                this.ioWrite(events2, "lcd." + i2 + ".fault", (v & 4) != 0 ? "1" : "0");
                this.ioWrite(events2, "lcd." + i2 + ".cfg.error", (v & 8) != 0 ? "1" : "0");
                if (this.logLines > 0) {
                    String s = String.valueOf(this.string[7]) + " " + i2 + ": ";
                    if (v == 0) {
                        this.uiLog(String.valueOf(s) + this.string[10]);
                    } else {
                        if ((v & 2) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[28]);
                        }
                        if ((v & 4) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[13]);
                        }
                        if ((v & 8) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[29]);
                        }
                    }
                }
            }
            ++i2;
        }
    }

    private void pollAnnunciators(boolean events2, int from, int to) throws Exception {
        if (this.protocolNew) {
            byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 74 + from, to - from + 1);
            if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
                throw new Exception("read failed, stage 6");
            }
            int i2 = from;
            while (i2 <= to) {
                short v = d2[3 + 2 * (i2 - from)];
                int x = 1 + (i2 - 1) / 5;
                int y = i2 % 5;
                if (v != this.annunciatorStatus[x][y]) {
                    String name = y == 0 ? Integer.toString(x) : String.valueOf(x) + "." + y;
                    this.annunciatorStatus[x][y] = v;
                    this.ioWrite(events2, "annunciator." + name + ".offline", (v & 2) != 0 ? "1" : "0");
                    this.ioWrite(events2, "annunciator." + name + ".fault", (v & 4) != 0 ? "1" : "0");
                    this.ioWrite(events2, "annunciator." + name + ".cfg.error", (v & 8) != 0 ? "1" : "0");
                    if (this.logLines > 0) {
                        String s = String.valueOf(this.string[8]) + " " + name + ": ";
                        if (v == 0) {
                            this.uiLog(String.valueOf(s) + this.string[10]);
                        } else {
                            if ((v & 2) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[28]);
                            }
                            if ((v & 4) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[13]);
                            }
                            if ((v & 8) != 0) {
                                this.uiLog(String.valueOf(s) + this.string[29]);
                            }
                        }
                    }
                }
                ++i2;
            }
        } else {
            byte[][] d3 = new byte[4][];
            int i3 = 0;
            while (i3 < 4) {
                d3[i3] = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 98 + 16 * i3, 16);
                if (d3[i3] == null || d3[i3].length != 34) {
                    throw new Exception("read failed, stage 6." + (i3 + 1));
                }
                ++i3;
            }
            i3 = 1;
            while (i3 <= 32) {
                int x = (i3 - 1) / 16;
                int y = (i3 - 1) % 16;
                short v = d3[x][3 + 2 * y];
                if (v != this.annunciatorStatus[y][x]) {
                    this.annunciatorStatus[y][x] = v;
                    this.ioWrite(events2, "annunciator." + i3 + ".offline", v != 0 ? "1" : "0");
                    if (this.logLines > 0) {
                        this.uiLog(String.valueOf(this.string[8]) + " " + i3 + ": " + (v == 0 ? this.string[27] : this.string[28]));
                    }
                }
                if (v == 0 && (v = d3[2 + x][3 + 2 * y]) != this.annunciatorStatus[y][2 + x]) {
                    this.annunciatorStatus[y][2 + x] = v;
                    this.ioWrite(events2, "annunciator." + i3 + ".trouble", v != 0 ? "1" : "0");
                    if (this.logLines > 0) {
                        this.uiLog(String.valueOf(this.string[8]) + " " + i3 + ": " + (v == 0 ? this.string[10] : this.string[13]));
                    }
                }
                ++i3;
            }
        }
    }

    private void pollZones(boolean events2, int from, int to) throws Exception {
        byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, (this.protocolNew ? 400 : 200) + from, to - from + 1);
        if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
            throw new Exception("read failed, stage 7");
        }
        int i2 = from;
        while (i2 <= to) {
            short v = d2[3 + 2 * (i2 - from)];
            if (v != this.zoneStatus[i2]) {
                this.zoneStatus[i2] = v;
                this.ioWrite(events2, "zone." + i2 + ".normal", v == 0 ? "1" : "0");
                this.ioWrite(events2, "zone." + i2 + ".disabled", (v & 1) != 0 ? "1" : "0");
                this.ioWrite(events2, "zone." + i2 + ".fault", (v & 2) != 0 ? "1" : "0");
                this.ioWrite(events2, "zone." + i2 + ".alarm", (v & 4) != 0 ? "1" : "0");
                if (this.logLines > 0) {
                    String s = String.valueOf(this.string[4]) + " " + i2 + ": ";
                    if (v == 0) {
                        this.uiLog(String.valueOf(s) + this.string[10]);
                    } else {
                        if ((v & 1) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[18]);
                        }
                        if ((v & 2) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[14]);
                        }
                        if ((v & 4) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[12]);
                        }
                    }
                }
            }
            ++i2;
        }
    }

    private void pollSensors(boolean events2, int loop, int from, int to) throws Exception {
        short v;
        byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 900 + loop * 100 + from, to - from + 1);
        if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
            throw new Exception("read failed, stage 8");
        }
        int i2 = from;
        while (i2 <= to) {
            v = (short)(d2[3 + 2 * (i2 - from)] & 0xFF);
            if (v != this.sensorStatus[loop][i2]) {
                this.sensorStatus[loop][i2] = v;
                switch (this.protocolNew ? this.sensorConfig[loop][i2] : 0) {
                    case 39: {
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".normal", v == 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".disabled", (v & 2) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".prealarm.1", (v & 0x10) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".prealarm.2", (v & 0x20) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".alarm", (v & 0x80) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".fault", Integer.toString(v & 0xD));
                        if (this.logLines <= 0) break;
                        String s = String.valueOf(this.string[5]) + " " + i2 + " " + this.string[3] + " " + loop + ": ";
                        if (v == 0) {
                            this.uiLog(String.valueOf(s) + this.string[10]);
                            break;
                        }
                        if ((v & 2) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[17]);
                        }
                        if ((v & 0x10) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[19] + " 1");
                        }
                        if ((v & 0x20) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[19] + " 2");
                        }
                        if ((v & 0x80) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[12]);
                        }
                        if ((v & 0xD) == 0) break;
                        this.uiLog(String.valueOf(s) + this.string[13]);
                        break;
                    }
                    case 40: {
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".normal", v == 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".disabled", (v & 2) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".alarm.low", (v & 0x10) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".alarm.high", (v & 0x20) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".fault", Integer.toString(v & 0xD));
                        if (this.logLines <= 0) break;
                        String s = String.valueOf(this.string[5]) + " " + i2 + " " + this.string[3] + " " + loop + ": ";
                        if (v == 0) {
                            this.uiLog(String.valueOf(s) + this.string[10]);
                            break;
                        }
                        if ((v & 2) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[17]);
                        }
                        if ((v & 0x10) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[19] + " " + this.string[20]);
                        }
                        if ((v & 0x20) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[19] + " " + this.string[21]);
                        }
                        if ((v & 0xD) == 0) break;
                        this.uiLog(String.valueOf(s) + this.string[13]);
                        break;
                    }
                    default: {
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".normal", v == 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".disabled", (v & 2) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".alarm", (v & 0x80) != 0 ? "1" : "0");
                        this.ioWrite(events2, "sensor." + loop + "." + i2 + ".fault", Integer.toString(v & 0x7D));
                        if (this.logLines <= 0) break;
                        String s = String.valueOf(this.string[5]) + " " + i2 + " " + this.string[3] + " " + loop + ": ";
                        if (v == 0) {
                            this.uiLog(String.valueOf(s) + this.string[10]);
                            break;
                        }
                        if ((v & 2) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[17]);
                        }
                        if ((v & 0x80) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[12]);
                        }
                        if ((v & 0xD) == 0) break;
                        this.uiLog(String.valueOf(s) + this.string[13]);
                    }
                }
            }
            ++i2;
        }
        d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 2900 + loop * 100 + from, to - from + 1);
        if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
            throw new Exception("read failed, stage 9");
        }
        i2 = from;
        while (i2 <= to) {
            v = (short)(d2[3 + 2 * (i2 - from)] & 0xFF);
            if (v != this.sensorAnalog[loop][i2]) {
                this.sensorAnalog[loop][i2] = v;
                this.ioWrite(events2, "sensor." + loop + "." + i2 + ".analog", Short.toString(v));
            }
            ++i2;
        }
    }

    private void pollModules(boolean events2, int loop, int from, int to) throws Exception {
        short v;
        byte[] d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 9900 + loop * 100 + from, to - from + 1);
        if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
            throw new Exception("read failed, stage 10");
        }
        int i2 = from;
        while (i2 <= to) {
            v = (short)(d2[3 + 2 * (i2 - from)] & 0xFF);
            if (v != this.moduleStatus[loop][i2]) {
                this.moduleStatus[loop][i2] = v;
                this.ioWrite(events2, "module." + loop + "." + i2 + ".normal", (v & 0xEF) == 0 ? "1" : "0");
                this.ioWrite(events2, "module." + loop + "." + i2 + ".disabled", (v & 2) != 0 ? "1" : "0");
                this.ioWrite(events2, "module." + loop + "." + i2 + ".out", (v & 0x10) != 0 ? "1" : "0");
                this.ioWrite(events2, "module." + loop + "." + i2 + ".alarm", (v & 0x80) != 0 ? "1" : "0");
                this.ioWrite(events2, "module." + loop + "." + i2 + ".fault", Integer.toString(v & 0x6D));
                if (this.logLines > 0) {
                    String s = String.valueOf(this.string[6]) + " " + i2 + " " + this.string[3] + " " + loop + ": ";
                    if ((v & 0xFF) == 0) {
                        this.uiLog(String.valueOf(s) + this.string[10]);
                    } else {
                        if ((v & 2) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[17]);
                        }
                        if ((v & 0x10) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[22]);
                        }
                        if ((v & 0x80) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[12]);
                        }
                        if ((v & 0xD) != 0) {
                            this.uiLog(String.valueOf(s) + this.string[13]);
                        }
                    }
                }
            }
            ++i2;
        }
        d2 = Modbus.readHoldingRegisters(this.commPort, this.unitModbusId, 11900 + loop * 100 + from, to - from + 1);
        if (d2 == null || d2.length != 2 + 2 * (to - from + 1)) {
            throw new Exception("read failed, stage 11");
        }
        i2 = from;
        while (i2 <= to) {
            v = (short)(d2[3 + 2 * (i2 - from)] & 0xFF);
            if (v != this.moduleAnalog[loop][i2]) {
                this.moduleAnalog[loop][i2] = v;
                this.ioWrite(events2, "module." + loop + "." + i2 + ".analog", Short.toString(v));
            }
            ++i2;
        }
    }

    private void processCommand(String command) throws Exception {
        command = command.toLowerCase();
        this.log(2, "commandExecutor - processing command: " + command);
        try {
            int idx = command.indexOf(61);
            String name = command.substring(0, idx).trim();
            String value = command.substring(idx + 1).trim();
            if (name.equals("panel.fire")) {
                if (value.equals("silence")) {
                    this.modbusWrite(0, 1);
                    return;
                }
                if (value.equals("reset")) {
                    this.modbusWrite(0, 2);
                    return;
                }
                if (value.equals("activate")) {
                    this.modbusWrite(0, 3);
                    return;
                }
                if (value.equals("ack")) {
                    this.modbusWrite(0, 4);
                    return;
                }
            } else if (name.equals("panel.tech")) {
                if (value.equals("silence")) {
                    this.modbusWrite(1, 1);
                    return;
                }
                if (value.equals("reset")) {
                    this.modbusWrite(1, 2);
                    return;
                }
                if (value.equals("activate")) {
                    this.modbusWrite(1, 3);
                    return;
                }
                if (value.equals("ack")) {
                    this.modbusWrite(1, 4);
                    return;
                }
            } else {
                String[] sa = name.split("[.]");
                if (sa.length == 3) {
                    if (sa[0].equals("zone") && sa[2].equals("disabled")) {
                        int zone = Integer.parseInt(sa[1]);
                        int vint = Integer.parseInt(value);
                        if (zone > 0 && zone <= this.lastZone) {
                            switch (vint) {
                                case 0: {
                                    this.modbusWrite((this.protocolNew ? 400 : 200) + zone, 1);
                                    return;
                                }
                                case 1: {
                                    this.modbusWrite((this.protocolNew ? 400 : 200) + zone, 0);
                                    return;
                                }
                            }
                        }
                    }
                } else if (sa.length == 4) {
                    if (sa[0].equals("sensor")) {
                        if (sa[3].equals("disabled")) {
                            int loop = Integer.parseInt(sa[1]);
                            int sensor = Integer.parseInt(sa[2]);
                            int vint = Integer.parseInt(value);
                            if (this.sensorConfig[loop][sensor] != 0) {
                                switch (vint) {
                                    case 0: {
                                        this.modbusWrite(900 + 100 * loop + sensor, 1);
                                        return;
                                    }
                                    case 1: {
                                        this.modbusWrite(900 + 100 * loop + sensor, 0);
                                        return;
                                    }
                                }
                            }
                        }
                    } else if (sa[0].equals("module")) {
                        if (sa[3].equals("disabled")) {
                            int loop = Integer.parseInt(sa[1]);
                            int module = Integer.parseInt(sa[2]);
                            int vint = Integer.parseInt(value);
                            if (this.moduleConfig[loop][module] != 0) {
                                switch (vint) {
                                    case 0: {
                                        this.modbusWrite(9900 + 100 * loop + module, 1);
                                        return;
                                    }
                                    case 1: {
                                        this.modbusWrite(9900 + 100 * loop + module, 0);
                                        return;
                                    }
                                }
                            }
                        } else if (sa[3].equals("out")) {
                            int loop = Integer.parseInt(sa[1]);
                            int module = Integer.parseInt(sa[2]);
                            int vint = Integer.parseInt(value);
                            if (this.moduleConfig[loop][module] != 0) {
                                switch (vint) {
                                    case 0: {
                                        this.modbusWrite(9900 + 100 * loop + module, 3);
                                        return;
                                    }
                                    case 1: {
                                        this.modbusWrite(9900 + 100 * loop + module, 2);
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.log(3, "commandExecutor - error processing command '" + command + "'");
        }
        catch (Exception e2) {
            this.log(3, "commandExecutor - exception processing command '" + command + "': " + e2.getLocalizedMessage());
        }
    }

    private void modbusWrite(int address, int value) {
        byte[] d2 = null;
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(value & 0xFF);
        byte[] WORD = byArray;
        try {
            int i2 = 0;
            while (i2 < 4) {
                d2 = Modbus.writeSingleRegister(this.commPort, this.unitModbusId, address, WORD);
                if (d2[0] == 6) {
                    return;
                }
                Thread.sleep(500L);
                ++i2;
            }
            this.log(3, "commandExecutor - error on Modbus write " + address + "=" + value + " : " + (d2 == null ? "null" : Integer.toString(d2[0] & 0xFF)));
        }
        catch (Exception e2) {
            this.log(3, "commandExecutor - exception on Modbus write " + address + "=" + value + " : " + e2.getLocalizedMessage());
        }
    }

    private void ioWrite(boolean event, String name, String value) {
        String evName = String.valueOf(this.serverName) + "." + name;
        if (event) {
            SystemState.ioWrite(evName, value);
        } else {
            SystemState.ioWriteNoEvents(evName, value);
        }
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (name.equals("connection")) {
            SystemState.uiSet(String.valueOf(this.serverName) + ".offline.label", "visible", value.equals("online") ? "false" : "true");
        } else if (name.startsWith("annunciator.") || name.startsWith("lcd.") || name.startsWith("loop.") || name.startsWith("zone.")) {
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", value.equals("0") ? "false" : "true");
        } else if (name.startsWith("sensor.") || name.startsWith("module.")) {
            if (!name.endsWith(".analog")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", value.equals("0") ? "false" : "true");
            }
        } else if ((name.startsWith("panel.fire.") || name.startsWith("tech.fire.")) && (name.endsWith(".normal") || name.endsWith(".exclusions") || name.endsWith(".test") || name.endsWith(".fault") || name.endsWith(".alarm"))) {
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", value.equals("0") ? "false" : "true");
        }
    }

    private void uiLog(String entry) {
        if (!this.guiSupport || !this.initialized) {
            return;
        }
        this.logTime = System.currentTimeMillis();
        this.logEntries.addFirst(String.valueOf(this.dateFormat.format(this.logTime).toUpperCase()) + " " + entry.toUpperCase());
        if (this.logEntries.size() > this.logLines) {
            this.logEntries.removeLast();
        }
        this.uiLog();
    }

    private void uiLog() {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < this.logEntries.size()) {
            sb.append(this.logEntries.get(i2));
            sb.append("<br>");
            ++i2;
        }
        String log = sb.toString();
        if (this.logEntries.size() > 0) {
            SystemState.uiSet(String.valueOf(this.serverName) + ".log0", "value", this.logEntries.get(0));
        }
        SystemState.uiSet(String.valueOf(this.serverName) + ".log", "value", log);
        user.varSet("_notifier." + this.serverName + ".log!", log);
    }

    private void uiUpdate() {
        if (!this.guiSupport) {
            return;
        }
        if (System.currentTimeMillis() > this.logTime + 10000L) {
            SystemState.uiSet(String.valueOf(this.serverName) + ".log0", "value", "");
        }
    }

    private void log(int mode, String msg) {
        switch (mode) {
            case 0: {
                hsyco.messageLog(String.valueOf(msg) + " [" + this.serverName + "]");
                break;
            }
            case 1: {
                if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                hsyco.messageLog(String.valueOf(msg) + " [" + this.serverName + "]");
                break;
            }
            case 2: {
                if (!Configuration.verboseLog) break;
                hsyco.messageLog(String.valueOf(msg) + " [" + this.serverName + "]");
                break;
            }
            case 3: {
                hsyco.errorLog(String.valueOf(msg) + " [" + this.serverName + "]");
            }
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String decodeSensorType(short type) {
        switch (type) {
            case 32: {
                return "ION";
            }
            case 33: {
                return "IOND";
            }
            case 34: {
                return "FPHT";
            }
            case 35: {
                return "FTHR";
            }
            case 36: {
                return "PHOT";
            }
            case 37: {
                return "THER";
            }
            case 38: {
                return "OMNI";
            }
            case 39: {
                return "GASS";
            }
            case 40: {
                return "OXY";
            }
            case 41: {
                return "PINN";
            }
        }
        return null;
    }

    private String decodeModuleType(short type) {
        if (this.protocolNew) {
            switch (type) {
                case 48: {
                    return "APND";
                }
                case 49: {
                    return "GAC";
                }
                case 50: {
                    return "GAS";
                }
                case 51: {
                    return "GPND";
                }
                case 52: {
                    return "GCT";
                }
                case 53: {
                    return "PWRC";
                }
                case 54: {
                    return "TPND";
                }
                case 55: {
                    return "TRS";
                }
                case 56: {
                    return "CON";
                }
                case 57: {
                    return "FORC";
                }
                case 58: {
                    return "EXT";
                }
                case 69: {
                    return "GTS";
                }
                case 70: {
                    return "HORN";
                }
                case 71: {
                    return "ZDIS";
                }
                case 72: {
                    return "UDS1";
                }
                case 80: {
                    return "MON";
                }
                case 81: {
                    return "NCMN";
                }
                case 82: {
                    return "NONA";
                }
                case 83: {
                    return "SCON";
                }
                case 84: {
                    return "PULL";
                }
                case 94: {
                    return "MTRB";
                }
                case 96: {
                    return "STAT";
                }
                case 97: {
                    return "MACK";
                }
                case 98: {
                    return "MTAC";
                }
                case 99: {
                    return "MRES";
                }
                case 100: {
                    return "SCO2";
                }
                case 101: {
                    return "MON3";
                }
                case 102: {
                    return "UDS2";
                }
            }
            return null;
        }
        switch (type) {
            case 48: {
                return "APND";
            }
            case 49: {
                return "DACT";
            }
            case 50: {
                return "GAC";
            }
            case 51: {
                return "GAS";
            }
            case 52: {
                return "GPND";
            }
            case 53: {
                return "GTC";
            }
            case 54: {
                return "PAGE";
            }
            case 55: {
                return "PWRC";
            }
            case 56: {
                return "SSC";
            }
            case 57: {
                return "TELE";
            }
            case 58: {
                return "TPND";
            }
            case 59: {
                return "TRC";
            }
            case 60: {
                return "TRS";
            }
            case 61: {
                return "WFC";
            }
            case 62: {
                return "WFS";
            }
            case 63: {
                return "CMXC";
            }
            case 64: {
                return "CMXS";
            }
            case 65: {
                return "CON";
            }
            case 66: {
                return "FORC";
            }
            case 67: {
                return "FRCM";
            }
            case 68: {
                return "SPKR";
            }
            case 69: {
                return "EVGA";
            }
            case 70: {
                return "GTS";
            }
            case 80: {
                return "MON";
            }
            case 81: {
                return "MPUL";
            }
            case 82: {
                return "NCMN";
            }
            case 83: {
                return "NOA";
            }
            case 84: {
                return "NONA";
            }
            case 85: {
                return "PULL";
            }
            case 86: {
                return "SCON";
            }
            case 87: {
                return "WAT";
            }
            case 88: {
                return "SACM";
            }
            case 89: {
                return "SARM";
            }
            case 90: {
                return "SEQM";
            }
            case 91: {
                return "SPSU";
            }
            case 92: {
                return "SSYM";
            }
            case 93: {
                return "SUPR";
            }
            case 94: {
                return "MTRB";
            }
            case 95: {
                return "MPAG";
            }
            case 96: {
                return "STAT";
            }
            case 97: {
                return "MACK";
            }
            case 98: {
                return "MTAC";
            }
            case 99: {
                return "MRES";
            }
            case 100: {
                return "SCO2";
            }
        }
        return null;
    }

    private void langugeInit() {
        switch (Configuration.language) {
            case 1: {
                this.string[0] = "centrale";
                this.string[1] = "incendio";
                this.string[2] = "tecnico";
                this.string[3] = "linea";
                this.string[4] = "zona";
                this.string[5] = "sensore";
                this.string[6] = "modulo";
                this.string[7] = "lcd";
                this.string[8] = "annunciator";
                this.string[10] = "ok";
                this.string[11] = "errore";
                this.string[12] = "allarme";
                this.string[13] = "guasto";
                this.string[14] = "guasta";
                this.string[15] = "abilitato";
                this.string[16] = "abilitata";
                this.string[17] = "disabilitato";
                this.string[18] = "disabilitata";
                this.string[19] = "preallarme";
                this.string[20] = "basso";
                this.string[21] = "alto";
                this.string[22] = "on";
                this.string[23] = "off";
                this.string[24] = "cortocircuito";
                this.string[25] = "interrotto";
                this.string[26] = "tensione";
                this.string[27] = "online";
                this.string[28] = "offline";
                this.string[29] = "configurazione";
                this.string[30] = "esclusioni";
                this.string[31] = "test";
                this.string[32] = "tacitato";
                this.string[33] = "tacitata";
                this.string[34] = "fine guasto";
                this.string[35] = "lib";
                this.string[36] = "errore configurazione";
                this.string[37] = "fine errore configurazione";
                this.string[38] = "programmato";
                this.string[39] = "non programmato";
                this.string[40] = "programmata";
                this.string[41] = "non programmata";
                break;
            }
            case 2: {
                this.string[0] = "central de commande";
                this.string[1] = "incendie";
                this.string[2] = "technique";
                this.string[3] = "ligne";
                this.string[4] = "zone";
                this.string[5] = "senseur";
                this.string[6] = "module";
                this.string[7] = "lcd";
                this.string[8] = "sir\u00e8ne";
                this.string[10] = "ok";
                this.string[11] = "erreur";
                this.string[12] = "alarme";
                this.string[13] = "en panne";
                this.string[14] = "en panne";
                this.string[15] = "activ\u00e9";
                this.string[16] = "activ\u00e9e";
                this.string[17] = "deactiv\u00e9";
                this.string[18] = "deactiv\u00e9\u00e9";
                this.string[19] = "pre alarm";
                this.string[20] = "bas";
                this.string[21] = "haut";
                this.string[22] = "on";
                this.string[23] = "off";
                this.string[24] = "court-circuit";
                this.string[25] = "interrompu";
                this.string[26] = "voltage";
                this.string[27] = "en ligne";
                this.string[28] = "d\u00e9connect\u00e9";
                this.string[29] = "configuration";
                this.string[30] = "exclusions";
                this.string[31] = "test";
                this.string[32] = "silencieux";
                this.string[33] = "silencieuse";
                this.string[34] = "fonctionnement normal";
                this.string[35] = "lib";
                this.string[36] = "erreur de configuration";
                this.string[37] = "fin de l'erreur de configuration";
                this.string[38] = "programm\u00e9";
                this.string[39] = "pas programm\u00e9";
                this.string[40] = "programm\u00e9e";
                this.string[41] = "pas programm\u00e9e";
                break;
            }
            default: {
                this.string[0] = "panel";
                this.string[1] = "fire";
                this.string[2] = "tech";
                this.string[3] = "loop";
                this.string[4] = "zone";
                this.string[5] = "sensor";
                this.string[6] = "module";
                this.string[7] = "lcd";
                this.string[8] = "annunciator";
                this.string[10] = "ok";
                this.string[11] = "error";
                this.string[12] = "alarm";
                this.string[13] = "fault";
                this.string[14] = "fault";
                this.string[15] = "enabled";
                this.string[16] = "enabled";
                this.string[17] = "disabled";
                this.string[18] = "disabled";
                this.string[19] = "pre-alarm";
                this.string[20] = "low";
                this.string[21] = "high";
                this.string[22] = "on";
                this.string[23] = "off";
                this.string[24] = "shorted";
                this.string[25] = "open";
                this.string[26] = "voltage";
                this.string[27] = "online";
                this.string[28] = "offline";
                this.string[29] = "configuration";
                this.string[30] = "exclusions";
                this.string[31] = "test";
                this.string[32] = "silent";
                this.string[33] = "silent";
                this.string[34] = "end of fault";
                this.string[35] = "lib";
                this.string[36] = "configuration error";
                this.string[37] = "end of configuration error";
                this.string[38] = "programmed";
                this.string[39] = "not programmed";
                this.string[40] = "programmed";
                this.string[41] = "not programmed";
            }
        }
    }
}

