/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.user;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class NLP {
    private static final int TYPE_VERBS = 0;
    private static final int TYPE_AREAS = 2;
    private static final int TYPE_KEYWORDS = 3;
    private File dictionaryFile;
    private long dictionaryFileTimestamp = 0L;
    private String language = null;
    private HashMap<String, ArrayList<String>> verbs;
    private HashMap<String, ArrayList<String>> areas;
    private HashMap<String, ArrayList<String>> keywords;
    private HashMap<String, ArrayList<String>> commands;
    private String devicesDefaultCommand = null;
    private static final Executor exec = Executors.newCachedThreadPool();

    public NLP(String dictionaryFileName) {
        this.dictionaryFile = new File(dictionaryFileName);
    }

    public boolean init() {
        int line = 1;
        int section = -1;
        this.devicesDefaultCommand = null;
        this.verbs = new HashMap();
        this.areas = new HashMap();
        this.keywords = new HashMap();
        this.commands = new HashMap();
        try {
            if (this.dictionaryFile.canRead()) {
                String fl;
                String name = this.dictionaryFile.getName();
                if (name.startsWith("nlpdictionary") && (name.charAt(13) == '_' || name.charAt(13) == '-') && name.endsWith(".txt")) {
                    this.language = name.substring(14, name.length() - 4);
                }
                BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dictionaryFile), "UTF-8"));
                while ((fl = fis.readLine()) != null) {
                    block27: {
                        try {
                            int x = fl.indexOf(35);
                            String l2 = NLP.textNormalizerBasic(x >= 0 ? fl.substring(0, x) : fl);
                            if (l2.startsWith("(") && l2.endsWith(")")) {
                                String sectionName = l2.substring(1, l2.length() - 1).trim();
                                if (sectionName.equals("verbs")) {
                                    section = 0;
                                } else if (sectionName.equals("areas")) {
                                    section = 1;
                                } else if (sectionName.equals("keywords")) {
                                    section = 2;
                                } else if (sectionName.equals("commands")) {
                                    section = 3;
                                } else {
                                    section = -1;
                                    this.errorLog("unsupported section name, line: " + line);
                                }
                                break block27;
                            }
                            if (l2.length() <= 0) break block27;
                            x = l2.indexOf(58);
                            String id = l2.substring(0, x).trim();
                            String[] right = section != 3 ? l2.substring(x + 1).split(";") : l2.substring(x + 1).split(";", -1);
                            ArrayList<String> tok = new ArrayList<String>();
                            int i2 = 0;
                            while (i2 < right.length) {
                                tok.add(right[i2].trim());
                                ++i2;
                            }
                            switch (section) {
                                case 0: {
                                    this.verbs.put(id, tok);
                                    break;
                                }
                                case 1: {
                                    this.areas.put(id, tok);
                                    break;
                                }
                                case 2: {
                                    this.keywords.put(id, tok);
                                    break;
                                }
                                case 3: {
                                    if (tok.size() == 1 && ((String)tok.get(0)).equals("*")) {
                                        if (id.startsWith("user ")) {
                                            this.devicesDefaultCommand = id;
                                        }
                                        break;
                                    }
                                    this.commands.put(id, tok);
                                }
                            }
                        }
                        catch (Exception e2) {
                            this.errorLog("format error, line: " + line);
                        }
                    }
                    ++line;
                }
                fis.close();
            }
            this.dictionaryFileTimestamp = this.dictionaryFile.lastModified();
            if (this.dictionaryFileAutoComplete()) {
                this.messageLog("missing keywords added");
            } else {
                this.messageLog("ALERT: file changed");
            }
            return true;
        }
        catch (Exception e3) {
            this.errorLog("initialization exception");
            return false;
        }
    }

    public void dictionaryFileCheckLoad() {
        if (this.dictionaryFile.lastModified() != this.dictionaryFileTimestamp) {
            this.init();
        }
    }

    public String process(String session, String userid, String text, ArrayList<String> recursiveCommands, ArrayList<String> recursiveExecutedCommands) {
        String topVerb;
        int topScore;
        block56: {
            HashMap<String, Integer> keywordsMatch;
            ArrayList<String> topCommandGroup;
            ArrayList<String> topCommand;
            HashMap<String, String> commandsMatch;
            block57: {
                ArrayList<Integer> v;
                commandsMatch = new HashMap<String, String>();
                topScore = 0;
                topCommand = null;
                topCommandGroup = null;
                topVerb = null;
                String[] textTokens = NLP.textNormalizer(text).split(" ");
                if (recursiveCommands == null && (v = this.verbsFinder(textTokens)) != null && v.size() > 1) {
                    StringBuffer sb = new StringBuffer();
                    String ret = "error";
                    if (v.get(0) == 0) {
                        int j2 = 0;
                        int i2 = 0;
                        while (i2 < textTokens.length) {
                            if (v.get(j2) == i2) {
                                if (j2 < v.size() - 1) {
                                    ++j2;
                                }
                                if (sb.length() > 0) {
                                    ret = this.process(session, userid, sb.toString(), null, null);
                                }
                                sb = new StringBuffer();
                            }
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(textTokens[i2]);
                            ++i2;
                        }
                        if (sb.length() > 0) {
                            ret = this.process(session, userid, sb.toString(), null, null);
                        }
                    } else {
                        int j3 = 0;
                        int i3 = 0;
                        while (i3 < textTokens.length) {
                            if (v.get(j3) == i3) {
                                if (j3 < v.size() - 1) {
                                    ++j3;
                                }
                                if (sb.length() > 0) {
                                    sb.append(' ');
                                    sb.append(textTokens[i3]);
                                    ret = this.process(session, userid, sb.toString(), null, null);
                                }
                                sb = new StringBuffer();
                            } else {
                                if (sb.length() > 0) {
                                    sb.append(' ');
                                }
                                sb.append(textTokens[i3]);
                            }
                            ++i3;
                        }
                        if (sb.length() > 0) {
                            ret = this.process(session, userid, sb.toString(), null, null);
                        }
                    }
                    return ret;
                }
                HashMap<String, Integer> verbsMatch = this.tokenMatch(textTokens, 0);
                HashMap<String, Integer> areasMatch = this.tokenMatch(textTokens, 2);
                keywordsMatch = this.tokenMatch(textTokens, 3);
                if (verbsMatch.size() <= 0 || areasMatch.size() <= 0 && keywordsMatch.size() <= 0) break block56;
                Iterator<String> keys = this.commands.keySet().iterator();
                while (keys.hasNext()) {
                    int i4;
                    String[] va;
                    int score = 0;
                    String verb = null;
                    boolean ambiguity = false;
                    String deviceId = keys.next();
                    ArrayList<String> deviceAttributes = this.commands.get(deviceId);
                    for (Map.Entry<String, Integer> entry : areasMatch.entrySet()) {
                        if (!entry.getKey().equals(deviceAttributes.get(0))) continue;
                        score += entry.getValue().intValue();
                    }
                    for (Map.Entry<String, Integer> entry : keywordsMatch.entrySet()) {
                        va = deviceAttributes.get(1).split(" ");
                        i4 = 0;
                        while (i4 < va.length) {
                            if (entry.getKey().equals(va[i4])) {
                                score += entry.getValue().intValue();
                            }
                            ++i4;
                        }
                    }
                    for (Map.Entry<String, Integer> entry : verbsMatch.entrySet()) {
                        va = deviceAttributes.get(3).split(" ");
                        i4 = 0;
                        while (i4 < va.length) {
                            if (entry.getKey().equals(va[i4])) {
                                if (verb == null) {
                                    verb = entry.getKey();
                                } else {
                                    ambiguity = true;
                                }
                            }
                            ++i4;
                        }
                    }
                    if (ambiguity || score <= 0 || verb == null) continue;
                    commandsMatch.put(deviceId, String.valueOf(score) + ";" + deviceAttributes.get(2) + ";" + verb);
                }
                for (Map.Entry entry : commandsMatch.entrySet()) {
                    String[] sa = ((String)entry.getValue()).split(";");
                    int score = Integer.parseInt(sa[0]);
                    if (score > topScore) {
                        topScore = score;
                        topCommand = new ArrayList<String>();
                        topCommand.add((String)entry.getKey());
                        topCommandGroup = new ArrayList<String>();
                        topCommandGroup.add(sa[1]);
                        topVerb = sa[2];
                        continue;
                    }
                    if (score != topScore) continue;
                    topCommand.add((String)entry.getKey());
                    topCommandGroup.add(sa[1]);
                }
                if (topCommand == null || topCommand.size() != 1) break block57;
                if (!(recursiveCommands != null && !recursiveCommands.contains(topCommand.get(0)) || recursiveExecutedCommands != null && recursiveExecutedCommands.contains(topCommand.get(0)))) {
                    ArrayList<String> executedCommands;
                    ArrayList<String> sortedCommands;
                    this.commandLog(String.valueOf(text) + ": " + (String)topCommand.get(0) + ", " + topScore + ", " + topVerb, recursiveCommands != null);
                    String ret = this.command(session, userid, (String)topCommand.get(0), topVerb, text);
                    if (recursiveCommands == null) {
                        sortedCommands = this.commandsMatchSort(commandsMatch);
                        executedCommands = new ArrayList();
                    } else {
                        sortedCommands = recursiveCommands;
                        executedCommands = recursiveExecutedCommands;
                    }
                    String notch = this.keywordsNotchFilter(text, keywordsMatch, sortedCommands, topCommand);
                    sortedCommands.removeAll(topCommand);
                    executedCommands.add(topCommand.get(0));
                    if (notch != null && sortedCommands.size() > 0) {
                        this.process(session, userid, notch, sortedCommands, executedCommands);
                    }
                    return ret;
                }
                return "error";
            }
            try {
                if (topCommand == null || topCommand.size() <= 1) break block56;
                HashSet<String> group = null;
                boolean ambiguity = false;
                int i5 = 0;
                while (i5 < topCommand.size() && !ambiguity) {
                    HashSet<String> gh;
                    HashSet<String> hashSet = gh = ((String)topCommandGroup.get(i5)).length() > 0 ? new HashSet<String>(Arrays.asList(((String)topCommandGroup.get(i5)).split(" "))) : new HashSet();
                    if (gh.size() > 0) {
                        if (group == null) {
                            group = gh;
                        } else {
                            Object[] entries = group.toArray();
                            int j4 = 0;
                            while (j4 < entries.length) {
                                if (!gh.contains(entries[j4])) {
                                    group.remove(entries[j4]);
                                }
                                ++j4;
                            }
                            if (group.size() == 0) {
                                ambiguity = true;
                            }
                        }
                    } else {
                        ambiguity = true;
                    }
                    ++i5;
                }
                if (!ambiguity) {
                    StringBuffer sb = new StringBuffer();
                    String ret = "error";
                    int i6 = 0;
                    while (i6 < topCommand.size()) {
                        if (recursiveExecutedCommands != null && recursiveExecutedCommands.contains(topCommand.get(i6))) {
                            return ret;
                        }
                        ++i6;
                    }
                    i6 = 0;
                    while (i6 < topCommand.size()) {
                        if (recursiveCommands == null || recursiveCommands.contains(topCommand.get(i6))) {
                            sb.append(" ");
                            sb.append((String)topCommand.get(i6));
                            ret = this.command(session, userid, topCommand.get(i6), topVerb, text);
                        }
                        ++i6;
                    }
                    if (sb.length() > 0) {
                        ArrayList<String> executedCommands;
                        ArrayList<String> sortedCommands;
                        this.commandLog(String.valueOf(text) + ":" + sb.toString() + ", " + topScore + ", " + topVerb, recursiveCommands != null);
                        if (recursiveCommands == null) {
                            sortedCommands = this.commandsMatchSort(commandsMatch);
                            executedCommands = new ArrayList();
                        } else {
                            sortedCommands = recursiveCommands;
                            executedCommands = recursiveExecutedCommands;
                        }
                        String notch = this.keywordsNotchFilter(text, keywordsMatch, sortedCommands, topCommand);
                        sortedCommands.removeAll(topCommand);
                        executedCommands.addAll(topCommand);
                        if (notch != null && sortedCommands.size() > 0) {
                            this.process(session, userid, notch, sortedCommands, executedCommands);
                        }
                    }
                    return ret;
                }
                StringBuffer sb = new StringBuffer();
                int i7 = 0;
                while (i7 < topCommand.size()) {
                    sb.append(" ");
                    sb.append((String)topCommand.get(i7));
                    ++i7;
                }
                this.errorLog("command ambiguity: " + text + ":" + sb.toString());
                return "error";
            }
            catch (Exception e2) {
                this.errorLog("processor exception: " + text);
                return "error";
            }
        }
        if (recursiveCommands == null) {
            if (this.devicesDefaultCommand != null) {
                this.commandLog(String.valueOf(text) + ": (default), " + topScore + ", " + topVerb, recursiveCommands != null);
                return this.command(session, userid, this.devicesDefaultCommand, null, text);
            }
            this.errorLog("no match: " + text);
            return "error";
        }
        return "error";
    }

    private String keywordsNotchFilter(String text, HashMap<String, Integer> keywordsMatch, ArrayList<String> sortedCommands, ArrayList<String> topCommand) {
        try {
            ArrayList<String> notchKeywords = new ArrayList<String>();
            Iterator<String> keywordsIterator = keywordsMatch.keySet().iterator();
            while (keywordsIterator.hasNext()) {
                boolean found = false;
                String keyword = keywordsIterator.next();
                int i2 = 0;
                while (i2 < topCommand.size()) {
                    if (Arrays.asList(this.commands.get(sortedCommands.get(i2)).get(1).split(" ")).contains(keyword)) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (!found) continue;
                found = false;
                i2 = topCommand.size();
                while (i2 < sortedCommands.size()) {
                    if (Arrays.asList(this.commands.get(sortedCommands.get(i2)).get(1).split(" ")).contains(keyword)) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (found) continue;
                notchKeywords.add(keyword);
            }
            ArrayList<String> textList = new ArrayList<String>(Arrays.asList(NLP.textNormalizer(text).split(" ")));
            int textListOriginalSize = textList.size();
            int i3 = 0;
            while (i3 < notchKeywords.size()) {
                ArrayList<String> keyswordsList = this.keywords.get(notchKeywords.get(i3));
                int j2 = 0;
                while (j2 < keyswordsList.size()) {
                    String[] keyworda = keyswordsList.get(j2).split(" ");
                    int x = 0;
                    int k2 = 0;
                    while (k2 < textList.size() && x < keyworda.length) {
                        if (keyworda[x].equals(textList.get(k2))) {
                            if (++x >= keyworda.length) {
                                int r = k2;
                                while (r > k2 - x) {
                                    textList.remove(r);
                                    --r;
                                }
                            }
                        } else {
                            x = 0;
                        }
                        ++k2;
                    }
                    ++j2;
                }
                ++i3;
            }
            if (textList.size() != textListOriginalSize && textList.size() > 0) {
                StringBuffer sb = new StringBuffer();
                int i4 = 0;
                while (i4 < textList.size()) {
                    if (i4 > 0) {
                        sb.append(' ');
                    }
                    sb.append(textList.get(i4));
                    ++i4;
                }
                return sb.toString();
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private ArrayList<String> commandsMatchSort(HashMap<String, String> commandsMatch) throws Exception {
        ArrayList<String> sortedCommands = new ArrayList<String>();
        for (String command : commandsMatch.keySet()) {
            int score = Integer.parseInt(commandsMatch.get(command).split(";")[0]);
            boolean added = false;
            int i2 = 0;
            while (i2 < sortedCommands.size()) {
                if (score > Integer.parseInt(commandsMatch.get(sortedCommands.get(i2)).split(";")[0])) {
                    sortedCommands.add(i2, command);
                    added = true;
                    break;
                }
                ++i2;
            }
            if (added) continue;
            sortedCommands.add(command);
        }
        int maxScore = Integer.parseInt(commandsMatch.get(sortedCommands.get(0)).split(";")[0]);
        int i3 = sortedCommands.size() - 1;
        while (i3 > 0) {
            if ((double)Integer.parseInt(commandsMatch.get(sortedCommands.get(i3)).split(";")[0]) < (double)maxScore * 0.8) {
                sortedCommands.remove(i3);
            }
            --i3;
        }
        return sortedCommands;
    }

    public int languageMatch(String text) {
        HashMap<String, Integer> match = null;
        int score = 0;
        try {
            String[] textTokens = NLP.textNormalizer(text).split(" ");
            int i2 = 0;
            while (i2 < 3) {
                switch (i2) {
                    case 0: {
                        match = this.tokenMatch(textTokens, 0);
                        break;
                    }
                    case 1: {
                        match = this.tokenMatch(textTokens, 2);
                        break;
                    }
                    case 2: {
                        match = this.tokenMatch(textTokens, 3);
                    }
                }
                Iterator values = match.values().iterator();
                while (values.hasNext()) {
                    score += ((Integer)values.next()).intValue();
                }
                ++i2;
            }
            return score;
        }
        catch (Exception e2) {
            return -1;
        }
    }

    public String language() {
        return this.language;
    }

    private HashMap<String, Integer> tokenMatch(String[] text, int tokenType) {
        HashMap<String, ArrayList<String>> tokenGroup;
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        switch (tokenType) {
            case 0: {
                tokenGroup = this.verbs;
                break;
            }
            case 2: {
                tokenGroup = this.areas;
                break;
            }
            case 3: {
                tokenGroup = this.keywords;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            int matchLengthTotal = 0;
            for (String string : tokenGroup.keySet()) {
                int matchLength = 0;
                ArrayList<String> tokens = tokenGroup.get(string);
                int i2 = 0;
                while (i2 < tokens.size()) {
                    String[] tokena = tokens.get(i2).split(" ");
                    int x = 0;
                    int l2 = 0;
                    int j2 = 0;
                    while (j2 < text.length && x < tokena.length) {
                        if (tokena[x].equals(text[j2])) {
                            if (++x >= tokena.length && (l2 += tokena[x].length()) > matchLength) {
                                matchLength = l2;
                            }
                        } else {
                            x = 0;
                            l2 = 0;
                        }
                        ++j2;
                    }
                    ++i2;
                }
                if (matchLength <= 0) continue;
                matchLengthTotal += matchLength;
                results.put(string, matchLength);
            }
            for (Map.Entry entry : results.entrySet()) {
                entry.setValue(100 * (Integer)entry.getValue() / matchLengthTotal);
            }
            return results;
        }
        catch (Exception e2) {
            return new HashMap<String, Integer>();
        }
    }

    private ArrayList<Integer> verbsFinder(String[] text) {
        ArrayList<Integer> verbsIndex = new ArrayList<Integer>();
        try {
            for (String key : this.verbs.keySet()) {
                int matchLength = 0;
                int index = -1;
                ArrayList<String> tokens = this.verbs.get(key);
                int i2 = 0;
                while (i2 < tokens.size()) {
                    String[] tokena = tokens.get(i2).split(" ");
                    int x = 0;
                    int l2 = 0;
                    int j2 = 0;
                    while (j2 < text.length && x < tokena.length) {
                        if (tokena[x].equals(text[j2])) {
                            if (++x >= tokena.length && (l2 += tokena[x].length()) > matchLength) {
                                matchLength = l2;
                                index = j2 - tokena.length + 1;
                            }
                        } else {
                            x = 0;
                            l2 = 0;
                        }
                        ++j2;
                    }
                    ++i2;
                }
                if (matchLength <= 0) continue;
                verbsIndex.add(index);
            }
            Collections.sort(verbsIndex);
            return verbsIndex;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String textNormalizer(String s) {
        StringBuffer sb = new StringBuffer();
        int state = 1;
        if (s != null) {
            int i2 = 0;
            while (i2 < s.length()) {
                char c2 = Character.toLowerCase(s.charAt(i2));
                if (!Character.isLetterOrDigit(c2) && c2 != '%') {
                    c2 = ' ';
                }
                switch (state) {
                    case 1: {
                        if (c2 == 32) break;
                        state = 0;
                        sb.append(c2);
                        break;
                    }
                    case 0: {
                        if (c2 == ' ') {
                            state = 1;
                        }
                        sb.append(c2);
                    }
                }
                ++i2;
            }
            return state == 1 && sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
        }
        return null;
    }

    private static String textNormalizerBasic(String s) {
        StringBuffer sb = new StringBuffer();
        int state = 1;
        if (s != null) {
            int i2 = 0;
            while (i2 < s.length()) {
                char c2 = Character.toLowerCase(s.charAt(i2));
                switch (state) {
                    case 1: {
                        if (c2 == ' ') break;
                        state = 0;
                        sb.append(c2);
                        break;
                    }
                    case 0: {
                        if (c2 == ' ') {
                            state = 1;
                        }
                        sb.append(c2);
                    }
                }
                ++i2;
            }
            return state == 1 && sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb.toString();
        }
        return null;
    }

    private boolean dictionaryFileAutoComplete() {
        HashSet<String> newAreas = new HashSet<String>();
        HashSet<String> newKeywords = new HashSet<String>();
        HashSet<String> newVerbs = new HashSet<String>();
        ArrayList newAreasSorted = null;
        ArrayList newKeywordsSorted = null;
        ArrayList newVerbsSorted = null;
        try {
            for (String key : this.commands.keySet()) {
                ArrayList<String> command = this.commands.get(key);
                String[] commandAreas = command.get(0).split(" ");
                int i2 = 0;
                while (i2 < commandAreas.length) {
                    if (commandAreas[i2].length() > 0 && !this.areas.containsKey(commandAreas[i2])) {
                        newAreas.add(commandAreas[i2]);
                    }
                    ++i2;
                }
                if (newAreas.size() > 0) {
                    newAreasSorted = new ArrayList(newAreas);
                    Collections.sort(newAreasSorted);
                }
                String[] commandKeywords = command.get(1).split(" ");
                int i3 = 0;
                while (i3 < commandKeywords.length) {
                    if (commandKeywords[i3].length() > 0 && !this.keywords.containsKey(commandKeywords[i3])) {
                        newKeywords.add(commandKeywords[i3]);
                    }
                    ++i3;
                }
                if (newKeywords.size() > 0) {
                    newKeywordsSorted = new ArrayList(newKeywords);
                    Collections.sort(newKeywordsSorted);
                }
                String[] commandVerbs = command.get(3).split(" ");
                int i4 = 0;
                while (i4 < commandVerbs.length) {
                    if (commandVerbs[i4].length() > 0 && !this.verbs.containsKey(commandVerbs[i4])) {
                        newVerbs.add(commandVerbs[i4]);
                    }
                    ++i4;
                }
                if (newVerbs.size() <= 0) continue;
                newVerbsSorted = new ArrayList(newVerbs);
                Collections.sort(newVerbsSorted);
            }
            if (newAreasSorted != null || newKeywordsSorted != null || newVerbsSorted != null) {
                String k2;
                String fl;
                File newFile = new File(this.dictionaryFile.getParentFile(), String.valueOf(util.isWindows ? "_" : ".~") + this.dictionaryFile.getName());
                BufferedReader fis = new BufferedReader(new FileReader(this.dictionaryFile));
                BufferedWriter fos = new BufferedWriter(new FileWriter(newFile));
                while ((fl = fis.readLine()) != null) {
                    int i5;
                    fos.write(fl);
                    fos.newLine();
                    int x = fl.indexOf(35);
                    String l2 = NLP.textNormalizerBasic(x >= 0 ? fl.substring(0, x) : fl);
                    if (!l2.startsWith("(") || !l2.endsWith(")")) continue;
                    String sectionName = l2.substring(1, l2.length() - 1).trim();
                    if (newVerbsSorted != null && sectionName.equals("verbs")) {
                        i5 = 0;
                        while (i5 < newVerbsSorted.size()) {
                            k2 = (String)newVerbsSorted.get(i5);
                            fos.write(String.valueOf(k2) + " : " + k2);
                            fos.newLine();
                            ++i5;
                        }
                        newVerbsSorted = null;
                        continue;
                    }
                    if (newAreasSorted != null && sectionName.equals("areas")) {
                        i5 = 0;
                        while (i5 < newAreasSorted.size()) {
                            k2 = (String)newAreasSorted.get(i5);
                            fos.write(String.valueOf(k2) + " : " + k2);
                            fos.newLine();
                            ++i5;
                        }
                        newAreasSorted = null;
                        continue;
                    }
                    if (newKeywordsSorted == null || !sectionName.equals("keywords")) continue;
                    i5 = 0;
                    while (i5 < newKeywordsSorted.size()) {
                        k2 = (String)newKeywordsSorted.get(i5);
                        fos.write(String.valueOf(k2) + " : " + k2);
                        fos.newLine();
                        ++i5;
                    }
                    newKeywordsSorted = null;
                }
                if (newVerbsSorted != null) {
                    fos.newLine();
                    fos.write("(verbs)");
                    fos.newLine();
                    int i6 = 0;
                    while (i6 < newVerbsSorted.size()) {
                        k2 = (String)newVerbsSorted.get(i6);
                        fos.write(String.valueOf(k2) + " : " + k2);
                        fos.newLine();
                        ++i6;
                    }
                }
                if (newAreasSorted != null) {
                    fos.newLine();
                    fos.write("(areas)");
                    fos.newLine();
                    int i7 = 0;
                    while (i7 < newAreasSorted.size()) {
                        k2 = (String)newAreasSorted.get(i7);
                        fos.write(String.valueOf(k2) + " : " + k2);
                        fos.newLine();
                        ++i7;
                    }
                }
                if (newKeywordsSorted != null) {
                    fos.newLine();
                    fos.write("(keywords)");
                    fos.newLine();
                    int i8 = 0;
                    while (i8 < newKeywordsSorted.size()) {
                        k2 = (String)newKeywordsSorted.get(i8);
                        fos.write(String.valueOf(k2) + " : " + k2);
                        fos.newLine();
                        ++i8;
                    }
                }
                fos.close();
                fis.close();
                if (util.isWindows) {
                    this.dictionaryFile.delete();
                }
                newFile.renameTo(this.dictionaryFile);
                this.dictionaryFile.setWritable(true, false);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void commandLog(String s, boolean recursive) {
        if (recursive) {
            hsyco.messageLog("NLP [" + this.dictionaryFile.getName() + "] COMMAND(R): " + s);
        } else {
            hsyco.messageLog("NLP [" + this.dictionaryFile.getName() + "] COMMAND: " + s);
        }
    }

    private void errorLog(String s) {
        hsyco.errorLog("NLP [" + this.dictionaryFile.getName() + "] ERROR: " + s);
    }

    private void messageLog(String s) {
        hsyco.messageLog("NLP [" + this.dictionaryFile.getName() + "]: " + s);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String command(String session, String userid, String id, String value, String text) {
        try {
            if (id.startsWith("user ")) {
                String idparam;
                int virtualRemoteRet = 0;
                boolean noLog = false;
                boolean noEvent = false;
                String retMessage = "ack";
                String[] sa = id.substring(5).split("=");
                String remparam = sa[0].trim();
                if (sa[1].trim().equals("*")) {
                    idparam = NLP.textNormalizer(text);
                } else if (sa[1].trim().equals("?")) {
                    idparam = this.numberFinder(text);
                    if (idparam == null) {
                        return "error";
                    }
                } else {
                    idparam = sa[1].trim();
                }
                String userRet = PluginsWrapper.interceptUserKeys(session, userid, remparam, idparam, null);
                if (userRet == null) {
                    switch (Configuration.userCommandMode) {
                        case 1: {
                            userRet = user.userCommand(remparam, idparam);
                            break;
                        }
                        case 2: {
                            userRet = user.userCommand(userid, remparam, idparam);
                            break;
                        }
                        case 3: 
                        case 4: {
                            userRet = user.userCommand(session, userid, remparam, idparam);
                            break;
                        }
                        default: {
                            userRet = null;
                            virtualRemoteRet = user.virtualRemote(remparam, idparam);
                            if (virtualRemoteRet >= 0) break;
                            noLog = true;
                        }
                    }
                    String pluginRet = userCode.userCommand(session, userid, remparam, idparam);
                    if (pluginRet != null && (userRet == null || userRet.length() == 0)) {
                        userRet = pluginRet;
                    }
                } else {
                    noEvent = true;
                }
                if (userRet != null) {
                    if (userRet.startsWith("!")) {
                        userRet = userRet.substring(1);
                        noLog = true;
                    }
                    if (userRet.equalsIgnoreCase("error")) {
                        retMessage = "error";
                    } else if (userRet.startsWith("{") && userRet.endsWith("}")) {
                        noEvent = true;
                        retMessage = "ack" + userRet;
                    }
                }
                if (!noEvent) {
                    final String r = new String(remparam);
                    final String i2 = new String(idparam);
                    final String s = session == null ? null : new String(session);
                    final boolean b2 = noLog;
                    final boolean ret = userRet != null || virtualRemoteRet != 0;
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int eventsRet = events.eventsExec("USER" + r, 0, 0, i2, s);
                                if (!b2) {
                                    hsyco.messageLog("NLP COMMAND [" + r + "]: " + i2 + (ret || eventsRet != 0 ? " [OK]" : " [ERROR]"));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    exec.execute(task);
                }
                return retMessage;
            }
            if (value.equals("up") || value.equals("down")) {
                try {
                    if (SystemState.deviceFunctionGet(id) == 11) {
                        String iostate = SystemState.ioGet(id);
                        int iostatevalue = iostate.equals("off") ? 0 : (iostate.endsWith("%") ? Integer.parseInt(iostate.substring(0, iostate.length() - 1)) : Integer.parseInt(iostate));
                        value = (iostatevalue += value.equals("up") ? 20 : -20) <= 0 ? "off" : (iostatevalue >= 100 ? "100%" : String.valueOf(iostatevalue) + "%");
                    }
                }
                catch (Exception iostate) {
                    // empty catch block
                }
                SystemState.ioSet(id, value);
                return "ack";
            }
            if (!value.equals("set")) {
                SystemState.ioSet(id, value);
                return "ack";
            }
            value = this.numberFinder(text);
            if (value != null) {
                SystemState.ioSet(id, value);
                return "ack";
            }
            return "error";
        }
        catch (Exception e2) {
            return "error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String numberFinder(String str) {
        StringBuffer sb = new StringBuffer();
        int state = 0;
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= str.length()) {
                    if (state != 0) break;
                    return null;
                }
                char c2 = str.charAt(i2);
                switch (state) {
                    case 0: {
                        if (!Character.isDigit(c2)) break;
                        state = 1;
                        sb.append(c2);
                        break;
                    }
                    case 1: {
                        if (Character.isDigit(c2)) {
                            sb.append(c2);
                            break;
                        }
                        if (c2 == '%') {
                            sb.append(c2);
                            state = 3;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (Character.isDigit(c2)) {
                            return null;
                        }
                        if (c2 == '%') {
                            sb.append(c2);
                            state = 3;
                            break;
                        }
                        if (c2 == ' ') break;
                        state = 3;
                        break;
                    }
                    default: {
                        if (!Character.isDigit(c2)) break;
                        return null;
                    }
                }
                ++i2;
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

