/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class INIM {
    public static final String[] WebObjects = new String[]{"inim"};
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private boolean guiSupport = true;
    private boolean genEvents = false;
    private int pollinterval = 4;
    private int logSize = 20;
    private int pinTimeout = 10000;
    private boolean multiCommand = false;
    private CentralUnit cu = null;
    private byte[] pin = null;
    private long pinInputTime;
    private byte[] keypadPin = new byte[6];
    private byte keypadPinIndex = (byte)-1;
    private long logTime;
    private DateFormat dateFormat;
    private Vector<String> logs;
    private static final long TS_01012000;
    private HashMap<Integer, Vector<String>> zoneSessions = new HashMap();

    static {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2000);
        cal.set(6, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        TS_01012000 = cal.getTimeInMillis();
    }

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("mod")) {
                    if (value.equalsIgnoreCase("515")) {
                        this.cu = new SmartLiving515();
                    } else if (value.equalsIgnoreCase("1050")) {
                        this.cu = new SmartLiving1050();
                    } else if (value.equalsIgnoreCase("10100")) {
                        this.cu = new SmartLiving10100();
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - mod ignored");
                    }
                } else if (param.equalsIgnoreCase("pin")) {
                    try {
                        byte[] pinTemp = new byte[value.length()];
                        int c2 = 0;
                        while (c2 < value.length()) {
                            byte d2;
                            pinTemp[c2] = d2 = Byte.parseByte("" + value.charAt(c2));
                            ++c2;
                        }
                        this.pin = pinTemp;
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pin ignored");
                    }
                } else if (param.equalsIgnoreCase("logsize")) {
                    try {
                        int l2 = Integer.parseInt(value);
                        if (l2 < 0) {
                            throw new Exception();
                        }
                        this.logSize = l2;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - logsize ignored");
                    }
                } else if (param.equalsIgnoreCase("pintimeout")) {
                    try {
                        int l3 = Integer.parseInt(value);
                        if (l3 <= 0) {
                            throw new Exception();
                        }
                        this.pinTimeout = l3 * 1000;
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pintimeout ignored");
                    }
                } else if (param.equalsIgnoreCase("multicommand")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.multiCommand = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.multiCommand = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - multicommand ignored");
                    }
                }
            }
            ++i2;
        }
        this.loadLogs();
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 39, this);
            switch (Configuration.language) {
                case 1: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ITALIAN);
                    break;
                }
                case 2: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.FRENCH);
                    break;
                }
                default: {
                    this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ENGLISH);
                }
            }
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "panel", "false");
        }
        if (this.cu == null) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Central unit model must be specified!", this.serverName);
            me.quit = true;
            return;
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.cu.init();
            this.cu.polling();
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
            Logger.log(Logger.Mode.SECURITY, "HSYCO - ONLINE", this.serverName);
            this.uiSet("log", "HSYCO - ONLINE");
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e6) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e6);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            if (this.guiSupport) {
                this.updateZonesList();
            }
            this.genEvents = true;
        }
        catch (Exception e7) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initializzation error - " + e7.getLocalizedMessage(), this.serverName);
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        String cmd = null;
        int fastLoops = 0;
        try {
            while (!me.quit) {
                cmd = this.ioqtx.poll(fastLoops > 0 ? 0 : this.pollinterval, TimeUnit.SECONDS);
                if (cmd != null) {
                    do {
                        this.processCommand(cmd);
                    } while ((cmd = this.ioqtx.poll()) != null);
                    fastLoops = 4;
                }
                --fastLoops;
                try {
                    this.cu.polling();
                    me.heartbeat = System.currentTimeMillis();
                }
                catch (IOException e8) {
                    Logger.log(Logger.Mode.ERROR, "polling error - " + e8.getMessage(), this.serverName);
                }
                this.uiUpdate();
            }
        }
        catch (Exception e9) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e9.getLocalizedMessage(), this.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        String conn = SystemState.ioGet(String.valueOf(this.serverName) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite(true, "connection", "offline");
            Logger.log(Logger.Mode.SECURITY, "HSYCO - OFFLINE", this.serverName);
            this.uiSet("log", "HSYCO - OFFLINE");
        }
    }

    protected String getIniFile() {
        return "inim.ini";
    }

    private void loadLogs() {
        try {
            StringBuilder sb = new StringBuilder();
            this.logs = new Vector(this.logSize);
            String persistentlog = SystemState.varGet("__hsyco__inim." + this.serverName + ".log!");
            if (persistentlog != null) {
                int i2 = 0;
                while (i2 < persistentlog.length()) {
                    char c2 = persistentlog.charAt(i2);
                    if (c2 != ';') {
                        sb.append(c2);
                    } else if (i2 + 1 < persistentlog.length() && persistentlog.charAt(i2 + 1) == ';') {
                        sb.append(c2);
                        ++i2;
                    } else {
                        this.logs.add(sb.toString());
                        if (this.logs.size() >= this.logSize) break;
                        sb = new StringBuilder();
                    }
                    ++i2;
                }
                if (this.logs.size() < this.logSize && sb.length() > 0) {
                    this.logs.add(sb.toString());
                }
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error loading saved logs", this.serverName);
        }
    }

    private void saveLogs() {
        try {
            StringBuilder persistentlog = new StringBuilder();
            int i2 = 0;
            while (i2 < this.logs.size()) {
                String line = this.logs.get(i2).replace(";", ";;");
                if (line.length() > 0) {
                    if (persistentlog.length() > 0) {
                        persistentlog.append(';');
                    }
                    persistentlog.append(line);
                }
                ++i2;
            }
            SystemState.varSet("__hsyco__inim." + this.serverName + ".log!", persistentlog.toString());
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error saving logs", this.serverName);
        }
    }

    public String keypad(String session, String userId, String id) {
        if (this.guiSupport) {
            String value;
            String name;
            block26: {
                String zoneId;
                block25: {
                    block24: {
                        Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
                        try {
                            int val_idx = id.lastIndexOf(46);
                            name = id.substring(0, val_idx);
                            value = id.substring(val_idx + 1);
                            if (!name.equals("digit")) break block24;
                            this.pinInputTime = System.currentTimeMillis();
                            if (value.equals("c")) {
                                if (this.keypadPinIndex >= 0) {
                                    this.keypadPinIndex = (byte)(this.keypadPinIndex - 1);
                                }
                            } else if (this.keypadPinIndex < 5) {
                                this.keypadPinIndex = (byte)(this.keypadPinIndex + 1);
                                this.keypadPin[this.keypadPinIndex] = Byte.parseByte(value);
                            }
                            this.uiSet(name, null);
                            return "";
                        }
                        catch (Exception e2) {
                            Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                            return null;
                        }
                    }
                    if (!name.equals("zones.list")) break block25;
                    CentralUnit.Zone z = this.cu.zones.get(Integer.parseInt(value));
                    if (z != null) {
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.cont", "visible", "true");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value", Integer.toString(z.idx));
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.name", "value", z.name);
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.warning.label", "visible", z.state == 0 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.open.label", "visible", z.state == 2 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.tamper.label", "visible", z.state == 3 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.alarm.label", "visible", z.alarmMem == 1 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.bypassed.label", "visible", z.bypassed == 0 ? "true" : "false");
                        Vector<String> s = this.zoneSessions.get(z.idx);
                        if (s == null) {
                            s = new Vector();
                        }
                        s.add(session);
                        this.zoneSessions.put(z.idx, s);
                    }
                    return "";
                }
                if (!name.equals("zone.sel")) break block26;
                if (value.equals("close")) {
                    int idx;
                    Vector<String> s;
                    String currId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value", "");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.cont", "visible", "false");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.name", "value", "--");
                    if (currId != null && (s = this.zoneSessions.get(idx = Integer.parseInt(currId))) != null) {
                        s.remove(session);
                        if (s.isEmpty()) {
                            this.zoneSessions.remove(idx);
                        }
                    }
                } else if (value.equals("bypass")) {
                    String zoneId2 = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                    if (zoneId2 != null && !zoneId2.equals("")) {
                        int zId = Integer.parseInt(zoneId2);
                        if (zId > this.cu.numZones) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".gui.z" + (zId -= this.cu.numZones) + "d.bypassed", "1");
                        } else {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".gui.z" + zId + ".bypassed", "1");
                        }
                    }
                } else if (value.equals("unbypass") && (zoneId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value")) != null && !zoneId.equals("")) {
                    int zId = Integer.parseInt(zoneId);
                    if (zId > this.cu.numZones) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".gui.z" + (zId -= this.cu.numZones) + "d.bypassed", "0");
                    } else {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".gui.z" + zId + ".bypassed", "0");
                    }
                }
                return "";
            }
            SystemState.ioSet(String.valueOf(this.serverName) + ".gui." + name, value);
        }
        return "";
    }

    private byte[] writeCommand(byte[] data) throws Exception {
        byte[] resp = this.write(data, 1, false);
        byte sum = 0;
        int i2 = 8;
        while (i2 < data.length) {
            sum = (byte)(sum + data[i2]);
            ++i2;
        }
        if (sum != resp[0]) {
            throw new Exception("sum response error");
        }
        return this.write(this.cu.COM_READ_ESITO_COM_PC, 1, false);
    }

    private byte[] write(byte[] data, int respLen, boolean addChecksum) throws IOException {
        byte[] resp;
        if (addChecksum) {
            this.addChecksum(data);
        }
        if (!this.checksum(resp = this.send(data, respLen))) {
            throw new IOException("checksum error");
        }
        return resp;
    }

    protected byte[] send(byte[] data, int respLen) throws IOException {
        util.readComm(this.commPort, 0);
        if (util.writeCommBytes(this.commPort, data) != data.length) {
            throw new IOException("write comm error");
        }
        byte[] resp = util.readCommBytes(this.commPort, respLen);
        if (resp == null) {
            throw new IOException("read comm error: null");
        }
        if (resp.length != respLen) {
            throw new IOException("read comm error: length " + resp.length + "!=" + respLen);
        }
        return resp;
    }

    private void addChecksum(byte[] data) {
        byte sum = 0;
        int i2 = 0;
        while (i2 < data.length - 1) {
            sum = (byte)(sum + data[i2]);
            ++i2;
        }
        data[data.length - 1] = sum;
    }

    private boolean checksum(byte[] data) {
        byte sum = data[0];
        int i2 = 1;
        while (i2 < data.length - 1) {
            sum = (byte)(sum + data[i2]);
            ++i2;
        }
        return sum == data[data.length - 1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCommand(String cmd) {
        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - processing command: " + cmd, this.serverName);
        cmd = cmd.toLowerCase();
        byte[] currPin = null;
        try {
            String errorMsg;
            String[] func_val = cmd.split("=");
            String func = func_val[0];
            String val = func_val[1];
            if (func.startsWith("gui.")) {
                func = func.substring(4);
                currPin = new byte[this.keypadPinIndex + 1];
                int i2 = 0;
                while (i2 < currPin.length) {
                    currPin[i2] = this.keypadPin[i2];
                    ++i2;
                }
                if (!this.multiCommand) {
                    this.keypadPinIndex = (byte)-1;
                }
                this.uiSet("digit", null);
            } else {
                int valDot = val.indexOf(46);
                if (valDot > 0) {
                    try {
                        String valPin = val.substring(valDot + 1, val.length());
                        currPin = new byte[valPin.length()];
                        int i3 = 0;
                        while (i3 < currPin.length) {
                            currPin[i3] = Byte.parseByte("" + valPin.charAt(i3));
                            ++i3;
                        }
                        val = val.substring(0, valDot);
                    }
                    catch (Exception e2) {
                        currPin = null;
                    }
                } else {
                    currPin = this.pin;
                }
            }
            if (currPin == null || currPin.length == 0) {
                throw new Exception("PIN not set");
            }
            int dot = func.indexOf(46);
            if (dot > 0) {
                String prefix = func.substring(0, dot);
                func = func.substring(dot + 1);
                if (prefix.startsWith("a")) {
                    int idx = Integer.parseInt(prefix.substring(1));
                    errorMsg = this.cu.areaCommand(idx, func, val, currPin);
                } else if (prefix.startsWith("z")) {
                    boolean doubleZone = false;
                    if (prefix.endsWith("d")) {
                        doubleZone = true;
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    int idx = Integer.parseInt(prefix.substring(1));
                    errorMsg = this.cu.zoneCommand(idx, func, val, currPin, doubleZone);
                } else {
                    if (!prefix.startsWith("t")) throw new Exception("unknown command");
                    boolean doubleZone = false;
                    if (prefix.endsWith("d")) {
                        doubleZone = true;
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    int idx = Integer.parseInt(prefix.substring(1));
                    errorMsg = this.cu.terminalCommand(idx, func, val, currPin, doubleZone);
                }
            } else if (func.equals("or")) {
                errorMsg = this.cu.terminalCommand(this.cu.or.terminal, "active", val, currPin, false);
            } else if (func.equals("oc1")) {
                errorMsg = this.cu.terminalCommand(this.cu.oc1.terminal, "active", val, currPin, false);
            } else if (func.equals("oc2")) {
                errorMsg = this.cu.terminalCommand(this.cu.oc2.terminal, "active", val, currPin, false);
            } else {
                if (!func.startsWith("o")) throw new Exception("unknown command");
                int o2 = Integer.parseInt(func.substring(1));
                errorMsg = this.cu.outputCommand(o2, val, currPin);
            }
            if (errorMsg != null) {
                Logger.log(Logger.Mode.EVENT, "commandExecutor - command '" + cmd + "' not executed: " + errorMsg, this.serverName);
                return;
            } else {
                Logger.log(Logger.Mode.EVENT, "commandExecutor - command '" + cmd + "': OK", this.serverName);
            }
            return;
        }
        catch (Exception e3) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e3.getLocalizedMessage(), this.serverName);
        }
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        this.uiSet(name, value);
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (name.equals("digit")) {
            int i2 = 0;
            while (i2 < this.keypadPinIndex + 1) {
                SystemState.uiSet(String.valueOf(this.serverName) + ".pin." + i2, "value", "*");
                ++i2;
            }
            while (i2 < 6) {
                SystemState.uiSet(String.valueOf(this.serverName) + ".pin." + i2, "value", "_");
                ++i2;
            }
        } else if (name.equals("log")) {
            this.logTime = System.currentTimeMillis();
            value = value.toUpperCase();
            String logEntry = "<div style=\"padding:3px\">" + this.dateFormat.format(this.logTime).toUpperCase() + "<br />" + value + "</div>";
            while (this.logs.size() >= this.logSize) {
                this.logs.remove(this.logSize - 1);
            }
            this.logs.add(0, logEntry);
            StringBuilder text = new StringBuilder();
            int i3 = 0;
            while (i3 < this.logs.size()) {
                text.append(this.logs.get(i3));
                ++i3;
            }
            userBase.uiSet(String.valueOf(this.serverName) + ".log", "value", text.toString());
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", value);
            this.ioWrite(this.genEvents, "log0", value);
            this.saveLogs();
        } else if (name.equals("connection")) {
            if (value.equals("online")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "false");
            } else {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label", "visible", "true");
            }
        } else if (name.endsWith("armed")) {
            if (value.equals("0")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.away", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.stay", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.inst", "visible", "false");
            } else if (value.equals("1")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
            } else if (value.equals("away")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.away", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.stay", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.inst", "visible", "false");
            } else if (value.equals("stay")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.away", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.stay", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.inst", "visible", "false");
            } else if (value.equals("inst")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.away", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.stay", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.inst", "visible", "true");
            }
        } else if (name.endsWith("state")) {
            if (value.equals("short")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.short", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.closed", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.open", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.tamper", "visible", "false");
            } else if (value.equals("closed")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.short", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.closed", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.open", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.tamper", "visible", "false");
            } else if (value.equals("open")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.short", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.closed", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.open", "visible", "true");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.tamper", "visible", "false");
            } else if (value.equals("tamper")) {
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.short", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.closed", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.open", "visible", "false");
                SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.tamper", "visible", "true");
            }
        } else if (value.equals("1")) {
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "true");
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "false");
        } else if (value.equals("0")) {
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.1", "visible", "false");
            SystemState.uiSet(String.valueOf(this.serverName) + "." + name + ".label.0", "visible", "true");
        }
    }

    private void uiUpdate() {
        if (!this.guiSupport) {
            return;
        }
        if (this.logTime != -1L && System.currentTimeMillis() > this.logTime + 5000L) {
            this.logTime = -1L;
            SystemState.uiSet(String.valueOf(this.serverName) + ".log0", "value", "");
        }
        if (this.pinInputTime != -1L && System.currentTimeMillis() > this.pinInputTime + (long)this.pinTimeout) {
            this.pinInputTime = -1L;
            this.keypadPinIndex = (byte)-1;
            this.uiSet("digit", null);
        }
    }

    private void updateZonesList() {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        ArrayList<CentralUnit.Zone> set = new ArrayList<CentralUnit.Zone>(this.cu.zones.values());
        Collections.sort(set, new Comparator<CentralUnit.Zone>(){

            @Override
            public int compare(CentralUnit.Zone z1, CentralUnit.Zone z2) {
                return z1.name.toLowerCase().compareTo(z2.name.toLowerCase());
            }
        });
        for (CentralUnit.Zone z : set) {
            values.append(",").append(z.idx);
            labels.append(",").append(z.getListLabel());
        }
        if (values.length() > 1) {
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "values", values.substring(1));
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "labels", labels.substring(1));
        }
    }

    private abstract class CentralUnit {
        public final byte[] COM_READ_LOGGER_HEAD;
        public final byte[] COM_READ_LOGGER_ELEMENT;
        public final byte[] COM_READ_STATO_AREE;
        public final byte[] COM_READ_TR_ZONE;
        public final byte[] COM_READ_INC_TEST_ZONE;
        public final byte[] COM_READ_MEM_ZONE_OUT;
        public final byte[] COM_READ_FAULTS_BATT;
        public final byte[] COM_READ_ESITO_COM_PC;
        public final byte[] COM_WRITE_INSDIS_AREE_PC;
        public final byte[] COM_WRITE_ONOFF_USCITE_PC;
        public final byte[] COM_WRITE_RESET_AREE_PC;
        public final byte[] COM_WRITE_BYPASS_ZONE_PC;
        protected final Area[] areas;
        protected HashMap<Integer, Zone> zones;
        protected HashMap<Integer, Output> outputs;
        protected final Output or;
        protected final Output oc1;
        protected final Output oc2;
        protected final int numZones;
        protected final int numExpanders;
        protected final int numKeypads;
        protected final int maxLogEntries;
        private int faultFuseZones;
        private int faultFuseIBUS;
        private int faultBatteryIneff;
        private int faultMains;
        private int faultPhone;
        private int faultJamming;
        private int faultRadioZoneBatteryLow;
        private int faultRadioZoneLoss;
        private int batteryVolts;
        private int tamperPanel;
        private int tamperCover;
        private int tamperReader;
        private int tamperKeypad;
        private int tamperExpander;
        private int reset;
        private int armed;
        private int internet;
        private int service;
        private int program;
        private int voice;
        private int logHead;

        public CentralUnit(byte[] COM_READ_STATO_AREE, byte[] COM_READ_TR_ZONE, byte[] COM_READ_INC_TEST_ZONE, byte[] COM_READ_MEM_ZONE_OUT, int numAreas, int numZones, int numExpanders, int numKeypads, int maxLogEntries) {
            byte[] byArray = new byte[8];
            byArray[3] = 31;
            byArray[4] = -2;
            byArray[6] = 4;
            byArray[7] = 33;
            this.COM_READ_LOGGER_HEAD = byArray;
            byte[] byArray2 = new byte[8];
            byArray2[3] = 31;
            byArray2[4] = -1;
            this.COM_READ_LOGGER_ELEMENT = byArray2;
            byte[] byArray3 = new byte[8];
            byArray3[3] = 32;
            byArray3[4] = 5;
            byArray3[6] = 6;
            byArray3[7] = 43;
            this.COM_READ_FAULTS_BATT = byArray3;
            byte[] byArray4 = new byte[8];
            byArray4[3] = 32;
            byArray4[4] = 4;
            byArray4[6] = 1;
            byArray4[7] = 37;
            this.COM_READ_ESITO_COM_PC = byArray4;
            byte[] byArray5 = new byte[22];
            byArray5[0] = 1;
            byArray5[3] = 32;
            byArray5[4] = 6;
            byArray5[6] = 14;
            byArray5[7] = 53;
            this.COM_WRITE_INSDIS_AREE_PC = byArray5;
            byte[] byArray6 = new byte[16];
            byArray6[0] = 1;
            byArray6[3] = 32;
            byArray6[4] = 7;
            byArray6[6] = 8;
            byArray6[7] = 48;
            this.COM_WRITE_ONOFF_USCITE_PC = byArray6;
            byte[] byArray7 = new byte[16];
            byArray7[0] = 1;
            byArray7[3] = 32;
            byArray7[4] = 8;
            byArray7[6] = 8;
            byArray7[7] = 49;
            this.COM_WRITE_RESET_AREE_PC = byArray7;
            byte[] byArray8 = new byte[17];
            byArray8[0] = 1;
            byArray8[3] = 32;
            byArray8[4] = 9;
            byArray8[6] = 9;
            byArray8[7] = 51;
            this.COM_WRITE_BYPASS_ZONE_PC = byArray8;
            this.zones = new HashMap();
            this.outputs = new HashMap();
            this.or = new Output("r", 0);
            this.oc1 = new Output("c1", 1);
            this.oc2 = new Output("c2", 2);
            this.faultFuseZones = -1;
            this.faultFuseIBUS = -1;
            this.faultBatteryIneff = -1;
            this.faultMains = -1;
            this.faultPhone = -1;
            this.faultJamming = -1;
            this.faultRadioZoneBatteryLow = -1;
            this.faultRadioZoneLoss = -1;
            this.batteryVolts = -1;
            this.tamperPanel = -1;
            this.tamperCover = -1;
            this.tamperReader = -1;
            this.tamperKeypad = -1;
            this.tamperExpander = -1;
            this.reset = -1;
            this.armed = -1;
            this.internet = -1;
            this.service = -1;
            this.program = -1;
            this.voice = -1;
            this.logHead = 0;
            this.COM_READ_STATO_AREE = COM_READ_STATO_AREE;
            this.COM_READ_TR_ZONE = COM_READ_TR_ZONE;
            this.COM_READ_INC_TEST_ZONE = COM_READ_INC_TEST_ZONE;
            this.COM_READ_MEM_ZONE_OUT = COM_READ_MEM_ZONE_OUT;
            this.areas = new Area[numAreas];
            int i2 = 0;
            while (i2 < numAreas) {
                this.areas[i2] = new Area(i2 + 1);
                ++i2;
            }
            this.numZones = numZones;
            this.numExpanders = numExpanders;
            this.numKeypads = numKeypads;
            this.maxLogEntries = maxLogEntries;
        }

        public void init() throws Exception {
            this.loadIniFile();
            if (this.zones.isEmpty() && this.outputs.isEmpty()) {
                int i2 = 1;
                while (i2 <= this.numZones) {
                    this.zones.put(i2, new Zone(i2));
                    ++i2;
                }
                Logger.log(Logger.Mode.EVENT, "ioMonitor - default configuration loaded", INIM.this.serverName);
            } else {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - custom configuration loaded", INIM.this.serverName);
            }
            byte[] resp = INIM.this.write(this.COM_READ_LOGGER_HEAD, 5, false);
            this.logHead = (resp[0] & 0xFF) + ((resp[1] & 0xFF) << 8);
        }

        private void loadIniFile() throws Exception {
            BufferedReader br = null;
            String iniFile = INIM.this.getIniFile();
            try {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - loading '" + iniFile + "'", INIM.this.serverName);
                File f2 = new File(iniFile);
                try {
                    br = new BufferedReader(new FileReader(f2));
                }
                catch (FileNotFoundException e2) {
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - file '" + iniFile + "' not found. Will use default configuration", INIM.this.serverName);
                    try {
                        br.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                try {
                    String line;
                    int l2 = 1;
                    Vector<Integer> definedTerminals = new Vector<Integer>();
                    while ((line = br.readLine()) != null) {
                        try {
                            line = line.trim();
                            if (line.startsWith(String.valueOf(INIM.this.serverName) + ".")) {
                                String[] targets;
                                int t;
                                String[] term_targets_name = line.split("=");
                                String trm = term_targets_name[0].trim().replace(String.valueOf(INIM.this.serverName) + ".", "");
                                String trgts = term_targets_name[1].trim();
                                String[] names = null;
                                if (term_targets_name.length > 2) {
                                    names = term_targets_name[2].trim().split(",");
                                }
                                if (trm.startsWith("t")) {
                                    t = Integer.parseInt(trm.substring(1));
                                    if (t < 1 || t > 10) {
                                        throw new Exception("terminal number out of range: " + t);
                                    }
                                    --t;
                                } else if (trm.startsWith("e")) {
                                    String[] exp_term = trm.split("\\.");
                                    int exp = Integer.parseInt(exp_term[0].substring(1));
                                    if (exp < 1 || exp > this.numExpanders) {
                                        throw new Exception("expander number out of range: " + exp);
                                    }
                                    t = Integer.parseInt(exp_term[1].replace("t", ""));
                                    if (t < 1 || t > 5) {
                                        throw new Exception("terminal number out of range: " + t);
                                    }
                                    t += 9 + (exp - 1) * 5;
                                } else if (trm.startsWith("k")) {
                                    String[] kpd_term = trm.split("\\.");
                                    int kpd = Integer.parseInt(kpd_term[0].substring(1));
                                    if (kpd < 1 || kpd > this.numKeypads) {
                                        throw new Exception("keypad number out of range: " + kpd);
                                    }
                                    t = Integer.parseInt(kpd_term[1].replace("t", ""));
                                    if (t < 1 || t > 2) {
                                        throw new Exception("terminal number out of range: " + t);
                                    }
                                    t += 9 + this.numExpanders * 5 + (kpd - 1) * 2;
                                } else {
                                    throw new Exception("termninal syntax error");
                                }
                                if (definedTerminals.contains(t)) {
                                    throw new Exception("terminal number already defined: " + t);
                                }
                                definedTerminals.add(t);
                                String[] stringArray = targets = trgts.split(",");
                                int n2 = targets.length;
                                int n3 = 0;
                                while (n3 < n2) {
                                    String target = stringArray[n3];
                                    if ((target = target.trim()).startsWith("z")) {
                                        int z;
                                        boolean doubleZone = false;
                                        if (target.endsWith("d")) {
                                            doubleZone = true;
                                            target = target.substring(0, target.length() - 1);
                                        }
                                        if ((z = Integer.parseInt(target.substring(1))) < 1 || z > this.numZones) {
                                            throw new Exception("zone number out of range: " + z);
                                        }
                                        this.zones.put(z, new Zone(z, t, false, names == null ? null : names[0].trim()));
                                        if (doubleZone) {
                                            this.zones.put(z + this.numZones, new Zone(z, t, true, names == null ? null : (names.length > 1 ? names[1].trim() : names[0].trim())));
                                        }
                                    } else if (target.startsWith("o")) {
                                        int o2 = Integer.parseInt(target.substring(1));
                                        if (o2 < 1 || o2 > this.numZones) {
                                            throw new Exception("output number out of range: " + o2);
                                        }
                                        this.outputs.put(o2, new Output(o2, t));
                                    } else {
                                        throw new Exception("zone/output syntax error");
                                    }
                                    ++n3;
                                }
                            }
                        }
                        catch (Exception e3) {
                            throw new Exception("line " + l2 + ": " + e3.getMessage());
                        }
                        ++l2;
                    }
                }
                catch (Exception e4) {
                    throw new Exception("error loading '" + iniFile + "' " + e4.getLocalizedMessage());
                }
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }

        public void polling() throws Exception {
            this.checkAreas();
            this.checkZonesState();
            this.checkZonesBypassTest();
            this.checkZonesMemTerminalsOuts();
            this.checkFaults();
            this.checkLog();
        }

        protected abstract void checkAreas() throws Exception;

        protected abstract void checkZonesState() throws Exception;

        protected abstract void checkZonesBypassTest() throws Exception;

        protected abstract void checkZonesMemTerminalsOuts() throws Exception;

        private void checkFaults() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_FAULTS_BATT, 7, false);
            int val = resp[0] & 1;
            if (this.faultFuseZones != val) {
                this.faultFuseZones = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.fuse.zones", "" + val);
            }
            if (this.faultFuseIBUS != (val = resp[0] >>> 1 & 1)) {
                this.faultFuseIBUS = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.fuse.ibus", "" + val);
            }
            if (this.faultBatteryIneff != (val = resp[0] >>> 2 & 1)) {
                this.faultBatteryIneff = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.battery", "" + val);
            }
            if (this.faultMains != (val = resp[0] >>> 3 & 1)) {
                this.faultMains = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.mains", "" + val);
            }
            if (this.faultPhone != (val = resp[0] >>> 4 & 1)) {
                this.faultPhone = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.phone", "" + val);
            }
            if (this.faultJamming != (val = resp[0] >>> 5 & 1)) {
                this.faultJamming = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.jamming", "" + val);
            }
            if (this.faultRadioZoneBatteryLow != (val = resp[0] >>> 6 & 1)) {
                this.faultRadioZoneBatteryLow = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.radio.battery", "" + val);
            }
            if (this.faultRadioZoneLoss != (val = resp[0] >>> 7 & 1)) {
                this.faultRadioZoneLoss = val;
                INIM.this.ioWrite(INIM.this.genEvents, "fault.radio.loss", "" + val);
            }
            if (this.batteryVolts != (val = resp[2] + ((resp[3] & 3) << 8))) {
                this.batteryVolts = val;
                INIM.this.ioWrite(INIM.this.genEvents, "battery.volts", String.format("%.2f", (double)val * 0.01516));
            }
            if (this.tamperPanel != (val = resp[4] >>> 4 & 1)) {
                this.tamperPanel = val;
                INIM.this.ioWrite(INIM.this.genEvents, "tamper.panel", "" + val);
            }
            if (this.tamperCover != (val = resp[4] >>> 5 & 1)) {
                this.tamperCover = val;
                INIM.this.ioWrite(INIM.this.genEvents, "tamper.cover", "" + val);
            }
            if (this.tamperReader != (val = resp[4] >>> 6 & 1)) {
                this.tamperReader = val;
                INIM.this.ioWrite(INIM.this.genEvents, "tamper.reader", "" + val);
            }
            if (this.tamperKeypad != (val = resp[4] >>> 7 & 1)) {
                this.tamperKeypad = val;
                INIM.this.ioWrite(INIM.this.genEvents, "tamper.keypad", "" + val);
            }
            if (this.tamperExpander != (val = resp[5] & 1)) {
                this.tamperExpander = val;
                INIM.this.ioWrite(INIM.this.genEvents, "tamper.expander", "" + val);
            }
            if (this.reset != (val = resp[5] >>> 1 & 1)) {
                this.reset = val;
                INIM.this.ioWrite(INIM.this.genEvents, "reset", "" + val);
            }
            if (this.armed != (val = resp[5] >>> 3 & 1)) {
                this.armed = val;
                if (val == 0) {
                    INIM.this.ioWrite(INIM.this.genEvents, "armed", "1");
                } else {
                    INIM.this.ioWrite(INIM.this.genEvents, "armed", "0");
                }
            }
            if (this.internet != (val = resp[5] >>> 4 & 1)) {
                this.internet = val;
                INIM.this.ioWrite(INIM.this.genEvents, "internet", "" + val);
            }
            if (this.service != (val = resp[5] >>> 5 & 1)) {
                this.service = val;
                INIM.this.ioWrite(INIM.this.genEvents, "service", "" + val);
            }
            if (this.program != (val = resp[5] >>> 6 & 1)) {
                this.program = val;
                INIM.this.ioWrite(INIM.this.genEvents, "program", "" + val);
            }
            if (this.voice != (val = resp[5] >>> 7 & 1)) {
                this.voice = val;
                INIM.this.ioWrite(INIM.this.genEvents, "voice", "" + val);
            }
        }

        private void checkLog() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_LOGGER_HEAD, 5, false);
            int val = (resp[0] & 0xFF) + ((resp[1] & 0xFF) << 8);
            boolean wrap = false;
            if (this.logHead != val) {
                if (val < this.logHead) {
                    val = this.maxLogEntries;
                    wrap = true;
                }
                int i2 = this.logHead;
                while (i2 < val) {
                    String sec;
                    String min;
                    String hour;
                    String day;
                    this.COM_READ_LOGGER_ELEMENT[5] = (byte)(i2 >>> 8);
                    this.COM_READ_LOGGER_ELEMENT[6] = (byte)i2;
                    resp = INIM.this.write(this.COM_READ_LOGGER_ELEMENT, 367, true);
                    long secs = (resp[0] & 0xFF) + ((resp[1] & 0xFF) << 8) + ((resp[2] & 0xFF) << 16) + ((resp[3] & 0xFF) << 24);
                    int mask = (resp[4] & 0xFF) + ((resp[5] & 0xFF) << 8);
                    StringBuilder descr = new StringBuilder();
                    int c2 = 6;
                    while (c2 < 22) {
                        descr.append((char)(resp[c2] & 0xFF));
                        ++c2;
                    }
                    StringBuilder agent = new StringBuilder();
                    boolean ok = false;
                    int c3 = 26;
                    while (c3 < 42) {
                        if (resp[c3] != -1 && resp[c3] != 32) {
                            ok = true;
                        }
                        agent.append((char)(resp[c3] & 0xFF));
                        ++c3;
                    }
                    if (!ok) {
                        agent = null;
                    }
                    StringBuilder location = new StringBuilder();
                    ok = false;
                    int c4 = 46;
                    while (c4 < 62) {
                        if (resp[c4] != -1 && resp[c4] != 32) {
                            ok = true;
                        }
                        location.append((char)(resp[c4] & 0xFF));
                        ++c4;
                    }
                    if (!ok) {
                        location = null;
                    }
                    StringBuilder areasDescr = new StringBuilder();
                    ok = false;
                    int a2 = 0;
                    while (a2 < this.areas.length) {
                        if ((mask >>> a2 & 1) == 1) {
                            int start;
                            ok = true;
                            int c5 = start = 66 + a2 * 20;
                            while (c5 < start + 16) {
                                areasDescr.append((char)(resp[c5] & 0xFF));
                                ++c5;
                            }
                            areasDescr.append(", ");
                        }
                        ++a2;
                    }
                    if (ok) {
                        areasDescr.delete(areasDescr.length() - 2, areasDescr.length());
                    } else {
                        areasDescr = null;
                    }
                    long ts = TS_01012000 + secs * 1000L;
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(ts);
                    String year = "" + cal.get(1);
                    String month = "" + (cal.get(2) + 1);
                    if (month.length() < 2) {
                        month = "0" + month;
                    }
                    if ((day = "" + cal.get(5)).length() < 2) {
                        day = "0" + day;
                    }
                    if ((hour = "" + cal.get(11)).length() < 2) {
                        hour = "0" + hour;
                    }
                    if ((min = "" + cal.get(12)).length() < 2) {
                        min = "0" + min;
                    }
                    if ((sec = "" + cal.get(13)).length() < 2) {
                        sec = "0" + sec;
                    }
                    StringBuilder time = new StringBuilder();
                    time.append(year).append("/").append(month).append("/").append(day).append(" ").append(hour).append(":").append(min).append(":").append(sec);
                    StringBuilder event = new StringBuilder();
                    event.append(descr.toString().trim());
                    if (agent != null) {
                        event.append(" - ").append(agent.toString().trim());
                    }
                    if (location != null) {
                        event.append(" - ").append(location.toString().trim());
                    }
                    if (areasDescr != null) {
                        event.append(" - ").append(areasDescr.toString().trim());
                    }
                    INIM.this.uiSet("log", event.toString());
                    Logger.log(Logger.Mode.SECURITY, "[" + i2 + "] " + time.append(" - ").append((CharSequence)event).toString(), INIM.this.serverName);
                    this.logHead = i2++;
                }
                this.logHead = wrap ? 0 : val & 0xFFFF;
            }
        }

        public String areaCommand(int idx, String func, String val, byte[] pin) throws Exception {
            if (func.equals("armed")) {
                int action;
                if (val.equals("away")) {
                    action = 1;
                } else if (val.equals("stay")) {
                    action = 2;
                } else if (val.equals("inst")) {
                    action = 3;
                } else if (val.equals("0")) {
                    action = 4;
                } else {
                    throw new Exception("illegal value");
                }
                byte[] cmd = this.COM_WRITE_INSDIS_AREE_PC;
                int i2 = 0;
                while (i2 < pin.length) {
                    cmd[i2 + 8] = pin[i2];
                    ++i2;
                }
                while (i2 < 6) {
                    cmd[i2 + 8] = -1;
                    ++i2;
                }
                int b2 = 14 + --idx / 2;
                cmd[b2] = (byte)(idx % 2 == 0 ? action : action << 4);
                byte[] resp = INIM.this.writeCommand(cmd);
                switch (resp[0]) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return "PIN not valid";
                    }
                    case 2: {
                        return "zones not ready";
                    }
                    case 3: {
                        return "not allowed";
                    }
                }
                throw new Exception("unknown command response");
            }
            if (func.equals("reset")) {
                if (val.equals("1")) {
                    byte[] cmd = this.COM_WRITE_RESET_AREE_PC;
                    int i3 = 0;
                    while (i3 < pin.length) {
                        cmd[i3 + 8] = pin[i3];
                        ++i3;
                    }
                    while (i3 < 6) {
                        cmd[i3 + 8] = -1;
                        ++i3;
                    }
                    int b3 = 14 + --idx / 8;
                    cmd[b3] = (byte)(1 << idx % 8);
                    byte[] resp = INIM.this.writeCommand(cmd);
                    switch (resp[0]) {
                        case 0: {
                            return null;
                        }
                        case 1: {
                            return "PIN not valid";
                        }
                        case 2: {
                            return "not allowed";
                        }
                    }
                    throw new Exception("unknown command response");
                }
                throw new Exception("illegal value");
            }
            throw new Exception("illegal function");
        }

        public String zoneCommand(int idx, String func, String val, byte[] currPin, boolean doubleZone) throws Exception {
            if (func.equals("bypassed")) {
                Zone z = this.zones.get(idx);
                if (z == null) {
                    throw new Exception("no terminal number defined for zone " + idx);
                }
                return this.terminalCommand(z.terminal, func, val, currPin, doubleZone);
            }
            throw new Exception("illegal function");
        }

        public String outputCommand(int idx, String val, byte[] currPin) throws Exception {
            Output o2 = this.outputs.get(idx);
            if (o2 == null) {
                throw new Exception("no terminal number defined for output " + idx);
            }
            return this.terminalCommand(o2.terminal, "active", val, currPin, false);
        }

        public String terminalCommand(int idx, String func, String val, byte[] pin, boolean doubleZone) throws Exception {
            if (func.equals("bypassed")) {
                byte v;
                if (val.equals("1")) {
                    v = 1;
                } else if (val.equals("0")) {
                    v = 0;
                } else {
                    throw new Exception("illegal value");
                }
                byte[] cmd = this.COM_WRITE_BYPASS_ZONE_PC;
                int i2 = 0;
                while (i2 < pin.length) {
                    cmd[i2 + 8] = pin[i2];
                    ++i2;
                }
                while (i2 < 6) {
                    cmd[i2 + 8] = -1;
                    ++i2;
                }
                cmd[14] = (byte)idx;
                cmd[15] = (byte)(doubleZone ? 1 : 0);
                cmd[16] = v;
                byte[] resp = INIM.this.writeCommand(cmd);
                switch (resp[0]) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return "PIN not valid";
                    }
                    case 2: {
                        return "zone already set";
                    }
                    case 3: {
                        return "terminal index out of range (" + idx + ")";
                    }
                    case 4: {
                        return "terminal not used (" + idx + ")";
                    }
                    case 5: {
                        return "terminal is not a zone input (" + idx + ")";
                    }
                    case 6: {
                        return "bypass not allowed";
                    }
                    case 7: {
                        return "PIN code not qualified";
                    }
                    case 8: {
                        return "not a double terminal (" + idx + ")";
                    }
                }
                throw new Exception("unknown command response");
            }
            if (func.equals("active")) {
                byte v;
                if (val.equals("1")) {
                    v = 1;
                } else if (val.equals("0")) {
                    v = 0;
                } else {
                    throw new Exception("illegal value");
                }
                byte[] cmd = this.COM_WRITE_ONOFF_USCITE_PC;
                int i3 = 0;
                while (i3 < pin.length) {
                    cmd[i3 + 8] = pin[i3];
                    ++i3;
                }
                while (i3 < 6) {
                    cmd[i3 + 8] = -1;
                    ++i3;
                }
                cmd[14] = (byte)idx;
                cmd[15] = v;
                byte[] resp = INIM.this.writeCommand(cmd);
                switch (resp[0]) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return "PIN not valid";
                    }
                    case 2: {
                        return "output already set";
                    }
                    case 3: {
                        return "terminal index out of range (" + idx + ")";
                    }
                    case 4: {
                        return "terminal not used (" + idx + ")";
                    }
                    case 5: {
                        return "terminal is not an output (" + idx + ")";
                    }
                    case 6: {
                        return "not allowed";
                    }
                    case 7: {
                        return "not allowed - system armed";
                    }
                }
                throw new Exception("unknown command response");
            }
            throw new Exception("illegal function");
        }

        private class Area {
            private final String prefix;
            private int armed = -1;
            private int alarm = -1;
            private int tamper = -1;
            private int alarmMem = -1;
            private int tamperMem = -1;
            private int auto = -1;

            public Area(int idx) {
                this.prefix = "a" + idx + ".";
            }

            public void setArmed(int val) throws Exception {
                if (this.armed != val) {
                    this.armed = val;
                    switch (val) {
                        case 1: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "armed", "away");
                            break;
                        }
                        case 2: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "armed", "stay");
                            break;
                        }
                        case 3: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "armed", "inst");
                            break;
                        }
                        case 4: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "armed", "0");
                            break;
                        }
                        default: {
                            throw new Exception("unknown area armed value: " + val);
                        }
                    }
                }
            }

            public void setAlarm(int val) {
                if (this.alarm != val) {
                    this.alarm = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "alarm", "" + val);
                }
            }

            public void setTamper(int val) {
                if (this.tamper != val) {
                    this.tamper = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "tamper", "" + val);
                }
            }

            public void setAlarmMem(int val) {
                if (this.alarmMem != val) {
                    this.alarmMem = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "alarm.mem", "" + val);
                }
            }

            public void setTamperMem(int val) {
                if (this.tamperMem != val) {
                    this.tamperMem = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "tamper.mem", "" + val);
                }
            }

            public void setAutoArm(int val) {
                if (this.auto != val) {
                    this.auto = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "auto", "" + val);
                }
            }
        }

        class Output {
            private final String prefix;
            private final int terminal;
            private int active = -1;

            public Output(int idx, int terminal) {
                this.prefix = "o" + idx;
                this.terminal = terminal;
            }

            public Output(String idx, int terminal) {
                this.prefix = "o" + idx;
                this.terminal = terminal;
            }

            public void setActive(int val) {
                if (this.active != val) {
                    this.active = val;
                    INIM.this.ioWrite(INIM.this.genEvents, this.prefix, "" + val);
                }
            }
        }

        class Zone {
            private final int idx;
            private final String name;
            private final String prefix;
            private final int terminal;
            private int state = -1;
            private int bypassed = -1;
            private int test = -1;
            private int alarmMem = -1;
            private int tamperMem = -1;

            public Zone(int idx) {
                this(idx, idx - 1, false, null);
            }

            public String getListLabel() {
                StringBuilder imgs = new StringBuilder();
                if (this.state == 0) {
                    imgs.append("<img src=\"/$skin$/pic/inim/inim-alert.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if (this.state == 2) {
                    imgs.append("<img src=\"/$skin$/pic/inim/inim-dooropen.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if (this.state == 3) {
                    imgs.append("<img src=\"/$skin$/pic/inim/inim-scissors.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if (this.bypassed == 0) {
                    imgs.append("<img src=\"/$skin$/pic/inim/inim-block.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                if (this.alarmMem == 1) {
                    imgs.append("<img src=\"/$skin$/pic/inim/inim-alarm.png\" alt=\"\" width=\"20px\" height=\"20px\" style=\"vertical-align:-4px;\">");
                }
                String row = "<table cellpadding=\"0\" cellspacing=\"0\" style=\"table-layout:fixed; width:100%\"><tr>";
                row = String.valueOf(row) + "<td><div style=\"max-width:100%; text-overflow:ellipsis; overflow:hidden; white-space:nowrap; padding-right:10px\">" + this.name + "</div></td>";
                row = String.valueOf(row) + "<td style=\"text-align:right; width:100px; padding-right:5px\">" + imgs.toString() + "</td>";
                row = String.valueOf(row) + "</tr></table>";
                return row;
            }

            public Zone(int idx, int terminal, boolean isDouble, String name) {
                this.prefix = isDouble ? "z" + idx + "d." : "z" + idx + ".";
                this.idx = isDouble ? idx + CentralUnit.this.numZones : idx;
                this.terminal = terminal;
                this.name = name != null ? name : (isDouble ? String.valueOf(idx) + "d" : "" + idx);
                SystemState.uiSet(String.valueOf(INIM.this.serverName) + "." + this.prefix + "name", "value", this.name);
            }

            public void setState(int val) throws Exception {
                if (this.state != val) {
                    this.state = val;
                    switch (val) {
                        case 0: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "state", "short");
                            break;
                        }
                        case 1: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "state", "closed");
                            break;
                        }
                        case 2: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "state", "open");
                            break;
                        }
                        case 3: {
                            INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "state", "tamper");
                            break;
                        }
                        default: {
                            throw new Exception("unknown zone state value: " + val);
                        }
                    }
                    if (INIM.this.guiSupport) {
                        Vector s = (Vector)INIM.this.zoneSessions.get(this.idx);
                        if (s != null) {
                            for (String session : s) {
                                userBase.uiSet(session, String.valueOf(INIM.this.serverName) + ".zone.sel.warning.label", "visible", val == 0 ? "true" : "false");
                                userBase.uiSet(session, String.valueOf(INIM.this.serverName) + ".zone.sel.open.label", "visible", val == 2 ? "true" : "false");
                                userBase.uiSet(session, String.valueOf(INIM.this.serverName) + ".zone.sel.tamper.label", "visible", val == 3 ? "true" : "false");
                            }
                        }
                        INIM.this.updateZonesList();
                    }
                }
            }

            public void setBypass(int val) {
                if (this.bypassed != val) {
                    this.bypassed = val;
                    if (val == 1) {
                        INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "bypassed", "0");
                    } else {
                        INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "bypassed", "1");
                    }
                    if (INIM.this.guiSupport) {
                        Vector s = (Vector)INIM.this.zoneSessions.get(this.idx);
                        if (s != null) {
                            for (String session : s) {
                                userBase.uiSet(session, String.valueOf(INIM.this.serverName) + ".zone.sel.bypassed.label", "visible", val == 0 ? "true" : "false");
                            }
                        }
                        INIM.this.updateZonesList();
                    }
                }
            }

            public void setTest(int val) {
                if (this.test != val) {
                    this.test = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "test", "" + val);
                }
            }

            public void setAlarmMem(int val) {
                if (this.alarmMem != val) {
                    this.alarmMem = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "alarm.mem", "" + val);
                    if (INIM.this.guiSupport) {
                        Vector s = (Vector)INIM.this.zoneSessions.get(this.idx);
                        if (s != null) {
                            for (String session : s) {
                                userBase.uiSet(session, String.valueOf(INIM.this.serverName) + ".zone.sel.alarm.label", "visible", val == 1 ? "true" : "false");
                            }
                        }
                        INIM.this.updateZonesList();
                    }
                }
            }

            public void setTamperMem(int val) {
                if (this.tamperMem != val) {
                    this.tamperMem = val;
                    INIM.this.ioWrite(INIM.this.genEvents, String.valueOf(this.prefix) + "tamper.mem", "" + val);
                }
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class SmartLiving10100
    extends CentralUnit {
        public SmartLiving10100() {
            byte[] byArray = new byte[8];
            byArray[3] = 32;
            byArray[6] = 18;
            byArray[7] = 50;
            byte[] byArray2 = new byte[8];
            byArray2[3] = 32;
            byArray2[4] = 1;
            byArray2[6] = 51;
            byArray2[7] = 84;
            byte[] byArray3 = new byte[8];
            byArray3[3] = 32;
            byArray3[4] = 2;
            byArray3[6] = 52;
            byArray3[7] = 86;
            byte[] byArray4 = new byte[8];
            byArray4[3] = 32;
            byArray4[4] = 3;
            byArray4[6] = 53;
            byArray4[7] = 88;
            super(byArray, byArray2, byArray3, byArray4, 15, 100, 40, 15, 1000);
        }

        @Override
        protected void checkAreas() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_STATO_AREE, 19, false);
            int i2 = 0;
            while (i2 < 8) {
                int n2 = 0;
                while (n2 < 2) {
                    int idx = i2 * 2 + n2;
                    if (idx < this.areas.length) {
                        this.areas[idx].setArmed(resp[i2] >>> n2 * 4 & 0xF);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setAlarm(resp[8] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                this.areas[i2 + 8].setAlarm(resp[9] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setTamper(resp[10] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                this.areas[i2 + 8].setTamper(resp[11] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setAlarmMem(resp[12] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                this.areas[i2 + 8].setAlarmMem(resp[13] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setTamperMem(resp[14] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                this.areas[i2 + 8].setTamperMem(resp[15] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setAutoArm(resp[16] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                this.areas[i2 + 8].setAutoArm(resp[17] >>> i2 & 1);
                ++i2;
            }
        }

        @Override
        protected void checkZonesState() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_TR_ZONE, 52, false);
            int i2 = 0;
            while (i2 < 50) {
                int n2 = 0;
                while (n2 < 4) {
                    int idx = i2 * 4 + n2 + 1;
                    CentralUnit.Zone z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setState(resp[i2] >>> n2 * 2 & 3);
                    }
                    ++n2;
                }
                ++i2;
            }
        }

        @Override
        protected void checkZonesBypassTest() throws Exception {
            CentralUnit.Zone z;
            int idx;
            int n2;
            byte[] resp = INIM.this.write(this.COM_READ_INC_TEST_ZONE, 53, false);
            int i2 = 0;
            while (i2 < 25) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setBypass(resp[i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 25) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setTest(resp[26 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
        }

        @Override
        protected void checkZonesMemTerminalsOuts() throws Exception {
            CentralUnit.Zone z;
            int idx;
            int n2;
            byte[] resp = INIM.this.write(this.COM_READ_MEM_ZONE_OUT, 54, false);
            int i2 = 0;
            while (i2 < 25) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setAlarmMem(resp[i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 13) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setTamperMem(resp[26 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 13) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    CentralUnit.Output o2 = (CentralUnit.Output)this.outputs.get(idx);
                    if (o2 != null) {
                        o2.setActive(resp[39 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            this.or.setActive(resp[51] >>> 4 & 1);
            this.oc1.setActive(resp[51] >>> 5 & 1);
            this.oc2.setActive(resp[51] >>> 6 & 1);
        }
    }

    private class SmartLiving1050
    extends CentralUnit {
        public SmartLiving1050() {
            byte[] byArray = new byte[8];
            byArray[3] = 32;
            byArray[6] = 16;
            byArray[7] = 48;
            byte[] byArray2 = new byte[8];
            byArray2[3] = 32;
            byArray2[4] = 1;
            byArray2[6] = 26;
            byArray2[7] = 59;
            byte[] byArray3 = new byte[8];
            byArray3[3] = 32;
            byArray3[4] = 2;
            byArray3[6] = 26;
            byArray3[7] = 60;
            byte[] byArray4 = new byte[8];
            byArray4[3] = 32;
            byArray4[4] = 3;
            byArray4[6] = 28;
            byArray4[7] = 63;
            super(byArray, byArray2, byArray3, byArray4, 10, 50, 20, 10, 500);
        }

        @Override
        protected void checkAreas() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_STATO_AREE, 17, false);
            int i2 = 0;
            while (i2 < 5) {
                int n2 = 0;
                while (n2 < 2) {
                    int idx = i2 * 2 + n2;
                    this.areas[idx].setArmed(resp[i2] >>> n2 * 4 & 0xF);
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setAlarm(resp[6] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 2) {
                this.areas[i2 + 8].setAlarm(resp[7] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setTamper(resp[8] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 2) {
                this.areas[i2 + 8].setTamper(resp[9] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setAlarmMem(resp[10] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 2) {
                this.areas[i2 + 8].setAlarmMem(resp[11] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setTamperMem(resp[12] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 2) {
                this.areas[i2 + 8].setTamperMem(resp[13] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 8) {
                this.areas[i2].setAutoArm(resp[14] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 2) {
                this.areas[i2 + 8].setAutoArm(resp[15] >>> i2 & 1);
                ++i2;
            }
        }

        @Override
        protected void checkZonesState() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_TR_ZONE, 27, false);
            int i2 = 0;
            while (i2 < 25) {
                int n2 = 0;
                while (n2 < 4) {
                    int idx = i2 * 4 + n2 + 1;
                    CentralUnit.Zone z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setState(resp[i2] >>> n2 * 2 & 3);
                    }
                    ++n2;
                }
                ++i2;
            }
        }

        @Override
        protected void checkZonesBypassTest() throws Exception {
            CentralUnit.Zone z;
            int idx;
            int n2;
            byte[] resp = INIM.this.write(this.COM_READ_INC_TEST_ZONE, 27, false);
            int i2 = 0;
            while (i2 < 13) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setBypass(resp[i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 13) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setTest(resp[13 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
        }

        @Override
        protected void checkZonesMemTerminalsOuts() throws Exception {
            CentralUnit.Zone z;
            int idx;
            int n2;
            byte[] resp = INIM.this.write(this.COM_READ_MEM_ZONE_OUT, 29, false);
            int i2 = 0;
            while (i2 < 13) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setAlarmMem(resp[i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setTamperMem(resp[13 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 7) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    CentralUnit.Output o2 = (CentralUnit.Output)this.outputs.get(idx);
                    if (o2 != null) {
                        o2.setActive(resp[20 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            this.or.setActive(resp[26] >>> 2 & 1);
            this.oc1.setActive(resp[26] >>> 3 & 1);
            this.oc2.setActive(resp[26] >>> 4 & 1);
        }
    }

    private class SmartLiving515
    extends CentralUnit {
        public SmartLiving515() {
            byte[] byArray = new byte[8];
            byArray[3] = 32;
            byArray[6] = 13;
            byArray[7] = 45;
            byte[] byArray2 = new byte[8];
            byArray2[3] = 32;
            byArray2[4] = 1;
            byArray2[6] = 11;
            byArray2[7] = 44;
            byte[] byArray3 = new byte[8];
            byArray3[3] = 32;
            byArray3[4] = 2;
            byArray3[6] = 12;
            byArray3[7] = 46;
            byte[] byArray4 = new byte[8];
            byArray4[3] = 32;
            byArray4[4] = 3;
            byArray4[6] = 13;
            byArray4[7] = 48;
            super(byArray, byArray2, byArray3, byArray4, 5, 20, 10, 5, 500);
        }

        @Override
        protected void checkAreas() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_STATO_AREE, 14, false);
            int i2 = 0;
            while (i2 < 3) {
                int n2 = 0;
                while (n2 < 2) {
                    int idx = i2 * 2 + n2;
                    if (idx < this.areas.length) {
                        this.areas[idx].setArmed(resp[i2] >>> n2 * 4 & 0xF);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                this.areas[i2].setAlarm(resp[3] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                this.areas[i2].setTamper(resp[5] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                this.areas[i2].setAlarmMem(resp[7] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                this.areas[i2].setTamperMem(resp[9] >>> i2 & 1);
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                this.areas[i2].setAutoArm(resp[11] >>> i2 & 1);
                ++i2;
            }
        }

        @Override
        protected void checkZonesState() throws Exception {
            byte[] resp = INIM.this.write(this.COM_READ_TR_ZONE, 12, false);
            int i2 = 0;
            while (i2 < 10) {
                int n2 = 0;
                while (n2 < 4) {
                    int idx = i2 * 4 + n2 + 1;
                    CentralUnit.Zone z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setState(resp[i2] >>> n2 * 2 & 3);
                    }
                    ++n2;
                }
                ++i2;
            }
        }

        @Override
        protected void checkZonesBypassTest() throws Exception {
            CentralUnit.Zone z;
            int idx;
            int n2;
            byte[] resp = INIM.this.write(this.COM_READ_INC_TEST_ZONE, 13, false);
            int i2 = 0;
            while (i2 < 5) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setBypass(resp[i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setTest(resp[6 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
        }

        @Override
        protected void checkZonesMemTerminalsOuts() throws Exception {
            CentralUnit.Zone z;
            int idx;
            int n2;
            byte[] resp = INIM.this.write(this.COM_READ_MEM_ZONE_OUT, 14, false);
            int i2 = 0;
            while (i2 < 5) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setAlarmMem(resp[i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    z = (CentralUnit.Zone)this.zones.get(idx);
                    if (z != null) {
                        z.setTamperMem(resp[6 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                n2 = 0;
                while (n2 < 8) {
                    idx = i2 * 8 + n2 + 1;
                    CentralUnit.Output o2 = (CentralUnit.Output)this.outputs.get(idx);
                    if (o2 != null) {
                        o2.setActive(resp[9 + i2] >>> n2 & 1);
                    }
                    ++n2;
                }
                ++i2;
            }
            this.or.setActive(resp[11] >>> 4 & 1);
            this.oc1.setActive(resp[11] >>> 5 & 1);
            this.oc2.setActive(resp[11] >>> 6 & 1);
        }
    }
}

