/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

public class HsycoTimer {
    private String _name;
    private boolean _on = false;
    private boolean _active = false;
    private int _hour;
    private int _min;
    private int _duration;
    private boolean[] _days = new boolean[7];
    private String[] _devices;
    private long _timestamp;

    public HsycoTimer(String name, String[] devices) {
        this._name = new String(name);
        this._hour = 0;
        this._min = 0;
        this._duration = 0;
        if (devices == null) {
            this._devices = null;
        } else {
            this._devices = new String[devices.length];
            System.arraycopy(devices, 0, this._devices, 0, devices.length);
        }
        this._timestamp = 1L;
    }

    public void HsycoTimerSet(int hour, int min, int duration, boolean[] days, long timestamp) {
        this._hour = hour;
        this._min = min;
        this._duration = duration;
        this._days = (boolean[])days.clone();
        this._timestamp = timestamp;
    }

    public void HsycoTimerSetMode(boolean on, long timestamp) {
        this._on = on;
        this._timestamp = timestamp;
    }

    public void HsycoTimerSetState(boolean active, long timestamp) {
        this._active = active;
        this._timestamp = timestamp;
    }

    public String getName() {
        return this._name;
    }

    public boolean getMode() {
        return this._on;
    }

    public boolean getState() {
        return this._active;
    }

    public int getHour() {
        return this._hour;
    }

    public int getMin() {
        return this._min;
    }

    public int getDuration() {
        return this._duration;
    }

    public boolean[] getDays() {
        return this._days;
    }

    public String[] getDevices() {
        return this._devices;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._on ? "1," : "0,");
        sb.append(String.valueOf(Integer.toString(this._hour)) + ",");
        sb.append(String.valueOf(Integer.toString(this._min)) + ",");
        sb.append(String.valueOf(Integer.toString(this._duration)) + ",");
        int d2 = 0;
        int j2 = 0;
        while (j2 < this._days.length) {
            if (this._days[j2]) {
                d2 = d2 * 10 + j2 + 1;
            }
            ++j2;
        }
        sb.append(Integer.toString(d2));
        return sb.toString();
    }
}

