/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.HsycoFile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class Graphics {
    public static byte[] draw2D(int width, int height, String code, String format) {
        block42: {
            try {
                int imageHeight;
                int imageWidth;
                Statement[] slist = Graphics.parser(code);
                if (slist == null) break block42;
                try {
                    if (slist[0].function.equalsIgnoreCase("size")) {
                        imageWidth = Integer.parseInt(slist[0].params[0]);
                        imageHeight = Integer.parseInt(slist[0].params[1]);
                    } else if (slist[0].function.equalsIgnoreCase("scale") && slist[1].function.equalsIgnoreCase("size")) {
                        imageWidth = (int)Math.ceil(Double.parseDouble(slist[0].params[0]) * (double)Integer.parseInt(slist[1].params[0]));
                        imageHeight = (int)Math.ceil(Double.parseDouble(slist[0].params[1]) * (double)Integer.parseInt(slist[1].params[1]));
                    } else {
                        imageWidth = width;
                        imageHeight = height;
                    }
                }
                catch (Exception e2) {
                    imageWidth = width;
                    imageHeight = height;
                }
                BufferedImage resized = new BufferedImage(imageWidth, imageHeight, 2);
                Graphics2D gr = resized.createGraphics();
                gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gr.setStroke(new BasicStroke(3.0f));
                int i2 = 0;
                while (i2 < slist.length) {
                    try {
                        Object[] y;
                        String function = slist[i2].function;
                        String[] params = slist[i2].params;
                        if (function.equalsIgnoreCase("arc")) {
                            int itype = params[6].equalsIgnoreCase("pie") ? 2 : (params[6].equalsIgnoreCase("chord") ? 1 : 0);
                            Arc2D.Float shape = new Arc2D.Float(Float.parseFloat(params[0]), Float.parseFloat(params[1]), Float.parseFloat(params[2]), Float.parseFloat(params[3]), Float.parseFloat(params[4]), Float.parseFloat(params[5]), itype);
                            gr.setColor(Graphics.getColor(params[7]));
                            gr.draw(shape);
                            gr.setColor(Graphics.getColor(params[8]));
                            gr.fill(shape);
                        } else if (function.equalsIgnoreCase("ellipse")) {
                            Ellipse2D.Float shape = new Ellipse2D.Float(Float.parseFloat(params[0]), Float.parseFloat(params[1]), Float.parseFloat(params[2]), Float.parseFloat(params[3]));
                            gr.setColor(Graphics.getColor(params[4]));
                            gr.draw(shape);
                            gr.setColor(Graphics.getColor(params[5]));
                            gr.fill(shape);
                        } else if (function.equalsIgnoreCase("fill")) {
                            if (params.length != 1) {
                                gr.setBackground(Graphics.getColor("transparent"));
                            } else {
                                gr.setBackground(Graphics.getColor(params[0]));
                            }
                            gr.clearRect(0, 0, imageWidth, imageHeight);
                        } else if (function.equalsIgnoreCase("image")) {
                            int p;
                            HsycoFile file = new HsycoFile("www", params[0]);
                            byte[] data = file.getBytes();
                            if (data == null && (p = params[0].indexOf("/img/")) > 0) {
                                file = new HsycoFile("www", params[0].substring(p));
                                data = file.getBytes();
                            }
                            BufferedImage img = ImageIO.read(new MemoryCacheImageInputStream(new ByteArrayInputStream(data)));
                            gr.drawImage(img, null, Integer.parseInt(params[1]), Integer.parseInt(params[2]));
                        } else if (function.equalsIgnoreCase("string")) {
                            int istyle = params[4].equalsIgnoreCase("bold") ? 1 : (params[4].equalsIgnoreCase("italic") ? 2 : (params[4].equalsIgnoreCase("bolditalic") ? 3 : 0));
                            gr.setFont(new Font(params[3], istyle, Integer.parseInt(params[5])));
                            gr.setPaint(Graphics.getColor(params[6]));
                            gr.drawString(params[0], Integer.parseInt(params[1]), Integer.parseInt(params[2]));
                        } else if (function.equalsIgnoreCase("rectangle")) {
                            Rectangle shape = new Rectangle(Integer.parseInt(params[0]), Integer.parseInt(params[1]), Integer.parseInt(params[2]), Integer.parseInt(params[3]));
                            gr.setColor(Graphics.getColor(params[4]));
                            gr.draw(shape);
                            gr.setColor(Graphics.getColor(params[5]));
                            gr.fill(shape);
                        } else if (function.equalsIgnoreCase("line")) {
                            int[] x = new int[(params.length - 1) / 2];
                            y = new int[(params.length - 1) / 2];
                            int k2 = 0;
                            while (k2 < x.length) {
                                x[k2] = Integer.parseInt(params[2 * k2]);
                                y[k2] = Integer.parseInt(params[2 * k2 + 1]);
                                ++k2;
                            }
                            gr.setColor(Graphics.getColor(params[params.length - 1]));
                            gr.drawPolyline(x, (int[])y, x.length);
                        } else if (function.equalsIgnoreCase("spline")) {
                            double[] x = new double[(params.length - 1) / 2];
                            y = new double[(params.length - 1) / 2];
                            int k3 = 0;
                            while (k3 < x.length) {
                                x[k3] = Double.parseDouble(params[2 * k3]);
                                y[k3] = (int)Double.parseDouble(params[2 * k3 + 1]);
                                ++k3;
                            }
                            SplineInterpolator si = new SplineInterpolator();
                            PolynomialSplineFunction spline = si.interpolate(x, (double[])y);
                            Path2D.Double p = new Path2D.Double();
                            p.moveTo(x[0], y[0]);
                            double k4 = x[0] + 1.0;
                            while (k4 < x[x.length - 1]) {
                                p.lineTo(k4, spline.value(k4));
                                k4 += 1.0;
                            }
                            gr.setColor(Graphics.getColor(params[params.length - 1]));
                            gr.draw(p);
                        } else if (function.equalsIgnoreCase("rotate")) {
                            gr.rotate(Math.toRadians(Double.parseDouble(params[0])));
                        } else if (function.equalsIgnoreCase("scale")) {
                            gr.scale(Double.parseDouble(params[0]), Double.parseDouble(params[1]));
                        } else if (function.equalsIgnoreCase("translate")) {
                            gr.translate(Double.parseDouble(params[0]), Double.parseDouble(params[1]));
                        } else if (function.equalsIgnoreCase("stroke")) {
                            gr.setStroke(new BasicStroke(Float.parseFloat(params[0])));
                        }
                    }
                    catch (Exception function) {
                        // empty catch block
                    }
                    ++i2;
                }
                ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
                ImageWriteParam writerparam = writer.getDefaultWriteParam();
                try {
                    writerparam.setCompressionMode(2);
                    writerparam.setCompressionQuality(1.0f);
                }
                catch (Exception params) {
                    // empty catch block
                }
                ByteArrayOutputStream imgout = new ByteArrayOutputStream();
                ImageOutputStream ios = ImageIO.createImageOutputStream(imgout);
                writer.setOutput(ios);
                IIOImage image = new IIOImage(resized, null, null);
                writer.write(null, image, writerparam);
                return imgout.toByteArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Color getColor(String str) {
        String[] sa = str.split(",");
        if (sa.length == 3) {
            return new Color(Float.parseFloat(sa[0]) / 255.0f, Float.parseFloat(sa[1]) / 255.0f, Float.parseFloat(sa[2]) / 255.0f);
        }
        if (sa.length == 4) {
            return new Color(Float.parseFloat(sa[0]) / 255.0f, Float.parseFloat(sa[1]) / 255.0f, Float.parseFloat(sa[2]) / 255.0f, Float.parseFloat(sa[3]) / 100.0f);
        }
        if ("transparent".equalsIgnoreCase(str)) {
            return new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
        try {
            Field field = Color.class.getField(str);
            return (Color)field.get(null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Statement[] parser(String code) {
        Vector<Statement> slist = new Vector<Statement>();
        String function = null;
        Vector<String> params = new Vector<String>();
        StringBuffer token = new StringBuffer();
        int state = 0;
        boolean escape = false;
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= code.length()) {
                    if (state != 0) break;
                    return slist.toArray(new Statement[slist.size()]);
                }
                char c2 = code.charAt(i2);
                block1 : switch (state) {
                    case 0: {
                        switch (c2) {
                            case '\"': 
                            case '\'': 
                            case '(': 
                            case ')': 
                            case ',': 
                            case '\\': {
                                return null;
                            }
                            case ' ': 
                            case ';': {
                                break block1;
                            }
                        }
                        token.append(c2);
                        state = 1;
                        break;
                    }
                    case 1: {
                        switch (c2) {
                            case '\"': 
                            case '\'': 
                            case ')': 
                            case ',': 
                            case '\\': {
                                return null;
                            }
                            case '(': {
                                if (token.length() <= 0) {
                                    return null;
                                }
                                function = token.toString();
                                token = new StringBuffer();
                                state = 3;
                                break block1;
                            }
                            case ' ': {
                                if (token.length() <= 0) {
                                    return null;
                                }
                                function = token.toString();
                                token = new StringBuffer();
                                state = 2;
                                break block1;
                            }
                        }
                        token.append(c2);
                        break;
                    }
                    case 2: {
                        switch (c2) {
                            case '(': {
                                state = 3;
                                break block1;
                            }
                            case ' ': {
                                break block1;
                            }
                        }
                        return null;
                    }
                    case 3: {
                        switch (c2) {
                            case '(': 
                            case ',': 
                            case '\\': {
                                return null;
                            }
                            case ')': {
                                slist.add(new Statement(function, params.toArray(new String[params.size()])));
                                params = new Vector();
                                state = 0;
                            }
                            case ' ': {
                                break block1;
                            }
                            case '\'': {
                                state = 5;
                                break block1;
                            }
                            case '\"': {
                                state = 6;
                                break block1;
                            }
                        }
                        state = 4;
                        token.append(c2);
                        break;
                    }
                    case 4: {
                        switch (c2) {
                            case '\"': 
                            case '\'': 
                            case '(': 
                            case '\\': {
                                return null;
                            }
                            case ',': {
                                params.add(token.toString());
                                token = new StringBuffer();
                                state = 3;
                                break block1;
                            }
                            case ' ': {
                                params.add(token.toString());
                                token = new StringBuffer();
                                state = 7;
                                break block1;
                            }
                            case ')': {
                                params.add(token.toString());
                                token = new StringBuffer();
                                slist.add(new Statement(function, params.toArray(new String[params.size()])));
                                params = new Vector();
                                state = 0;
                                break block1;
                            }
                        }
                        token.append(c2);
                        break;
                    }
                    case 5: {
                        switch (c2) {
                            case '\\': {
                                if (escape) {
                                    escape = false;
                                    token.append(c2);
                                } else {
                                    escape = true;
                                }
                            }
                            case '\'': {
                                params.add(token.toString());
                                token = new StringBuffer();
                                state = 7;
                                break block1;
                            }
                        }
                        token.append(c2);
                        break;
                    }
                    case 6: {
                        switch (c2) {
                            case '\\': {
                                if (escape) {
                                    escape = false;
                                    token.append(c2);
                                } else {
                                    escape = true;
                                }
                            }
                            case '\"': {
                                params.add(token.toString());
                                token = new StringBuffer();
                                state = 7;
                                break block1;
                            }
                        }
                        token.append(c2);
                        break;
                    }
                    case 7: {
                        switch (c2) {
                            case ',': {
                                state = 3;
                                break block1;
                            }
                            case ')': {
                                slist.add(new Statement(function, params.toArray(new String[params.size()])));
                                params = new Vector();
                                state = 0;
                                break block1;
                            }
                            case ' ': {
                                break block1;
                            }
                        }
                        return null;
                    }
                }
                ++i2;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static class Statement {
        String function;
        String[] params;

        Statement(String function, String[] params) {
            this.function = function;
            this.params = params;
        }
    }
}

