/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GKBus {
    public static final String[] WebObjects = new String[]{"tempmini"};
    private static final String INI_FILE = "gkbus.ini";
    private String serverName;
    private ArrayBlockingQueue<String> ioqtx;
    private String commPort;
    private boolean guiSupport = true;
    private boolean genEvents = true;
    private int pollinterval = 20;
    private static final int item_season = 29249;
    private static final int item_ext_temp = 98;
    private static final int item_t1_winter = 21026;
    private static final int item_t2_winter = 21027;
    private static final int item_lim_winter = 21028;
    private static final int item_set_winter = 29250;
    private static final int item_set_summer = 29251;
    private static final int item_kpm_in_temp = 9;
    private static final int item_kpm_out_temp = 10;
    private static final int item_kpm_pump_status = 13;
    private static final int item_kpm_valve_pos = 18;
    private static final int item_kpm_setpoint = 26;
    private static final int item_ts_temp = 1;
    private static final int item_ts_setpoint = 3;
    private static final int item_ts_status = 6;
    private static final int item_ts_humidity = 22;
    private static final int item_ts_mode = 6;
    private static final int item_ts_setpoint_hum = 36;
    private int season = -99999;
    private int external_temp = -99999;
    private int t1_winter = -99999;
    private int t2_winter = -99999;
    private int lim_winter = -99999;
    private int set_winter = -99999;
    private int set_summer = -99999;
    private HashMap<Integer, KPM20> kpm20s = new HashMap();
    private HashMap<String, IOCommandSet> keypadCmds = new HashMap();

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                }
            }
            ++i2;
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e3) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e3);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 45, this);
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.uiSet("connection.label.offline", "visible", "true");
            this.uiSet("connection.label.online", "visible", "false");
            this.loadIniFile();
            for (KPM20 k2 : this.kpm20s.values()) {
                for (KPM20.K483 t : k2.k483s.values()) {
                    this.uiSet(String.valueOf(t.sub_prefix) + "fan.group", "visible", "false");
                    this.uiSet(String.valueOf(t.sub_prefix) + "status.label.heating", "visible", "false");
                }
            }
            if (!this.polling(me)) {
                throw new Exception("first polling failed");
            }
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
            this.uiSet("connection.label.offline", "visible", "false");
            this.uiSet("connection.label.online", "visible", "true");
            this.genEvents = true;
        }
        catch (Exception e4) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initializzation error - " + e4.getLocalizedMessage(), this.serverName);
            me.quit = true;
        }
        me.heartbeat = System.currentTimeMillis();
        String cmd = null;
        try {
            while (!me.quit) {
                cmd = this.ioqtx.poll(this.pollinterval, TimeUnit.SECONDS);
                if (cmd != null) {
                    do {
                        this.processCommand(cmd);
                    } while ((cmd = this.ioqtx.poll()) != null);
                }
                if (!this.polling(me)) continue;
                me.heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception e5) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e5.getLocalizedMessage(), this.serverName);
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        this.ioWrite(true, "connection", "offline");
        this.uiSet("connection.label.offline", "visible", "true");
        this.uiSet("connection.label.online", "visible", "false");
    }

    private void loadIniFile() throws Exception {
        Logger.log(Logger.Mode.EVENT, "ioMonitor - loading 'gkbus.ini'", this.serverName);
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(new File(INI_FILE)));
            int l2 = 1;
            while ((line = br.readLine()) != null) {
                try {
                    line = line.trim();
                    if (line.toLowerCase().startsWith(String.valueOf(this.serverName) + ".k")) {
                        KPM20 kpm;
                        String[] id_name = line.split("=");
                        String[] addr_saddr = id_name[0].trim().substring(this.serverName.length() + 2).split("\\.");
                        int addr = Integer.parseInt(addr_saddr[0]);
                        int sub_addr = Integer.parseInt(addr_saddr[1]);
                        String name = null;
                        if (id_name.length > 1) {
                            name = id_name[1].trim();
                        }
                        if ((kpm = this.kpm20s.get(addr)) == null) {
                            kpm = new KPM20(addr);
                            this.kpm20s.put(addr, kpm);
                        }
                        kpm.addK483(sub_addr, name);
                    }
                }
                catch (Exception e2) {
                    throw new Exception("error in 'gkbus.ini', line " + l2 + ": " + e2.getMessage());
                }
                ++l2;
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean polling(ioMonitor me) throws Exception {
        int temp;
        byte[] resp;
        boolean ok = false;
        try {
            resp = this.writeRequest(128, 29249);
            int s = resp[0] & 1;
            if (this.season != s) {
                this.season = s;
                if (s == 0) {
                    this.ioWrite(this.genEvents, "season", "summer");
                    this.uiSet("season.label.summer", "visible", "true");
                    this.uiSet("season.label.winter", "visible", "false");
                    for (KPM20 k2 : this.kpm20s.values()) {
                        for (KPM20.K483 t : k2.k483s.values()) {
                            this.uiSet(String.valueOf(t.sub_prefix) + "mode.label.summer", "visible", "true");
                            this.uiSet(String.valueOf(t.sub_prefix) + "mode.label.winter", "visible", "false");
                        }
                    }
                } else {
                    this.ioWrite(this.genEvents, "season", "winter");
                    this.uiSet("season.label.summer", "visible", "false");
                    this.uiSet("season.label.winter", "visible", "true");
                    for (KPM20 k2 : this.kpm20s.values()) {
                        for (KPM20.K483 t : k2.k483s.values()) {
                            this.uiSet(String.valueOf(t.sub_prefix) + "mode.label.summer", "visible", "false");
                            this.uiSet(String.valueOf(t.sub_prefix) + "mode.label.winter", "visible", "true");
                        }
                    }
                }
            }
            ok = true;
        }
        catch (IOException e2) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (1): " + e2.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        try {
            resp = this.writeRequest(128, 98);
            temp = Math.round(this.bytesToFloat(resp) * 10.0f);
            if (this.external_temp != temp) {
                this.external_temp = temp;
                this.ioWrite(this.genEvents, "ext.temp", Integer.toString(temp));
                this.uiSet("ext.temp", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)temp / 10.0f))) + " &deg;C");
            }
            ok = true;
        }
        catch (IOException e3) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (2): " + e3.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        try {
            resp = this.writeRequest(128, 21026);
            temp = Math.round(this.bytesToFloat(resp) * 10.0f);
            if (this.t1_winter != temp) {
                this.t1_winter = temp;
                this.ioWrite(this.genEvents, "t1.winter", Integer.toString(temp));
                this.uiSet("t1.winter", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)temp / 10.0f))) + " &deg;C");
            }
            ok = true;
        }
        catch (IOException e4) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (3): " + e4.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        try {
            resp = this.writeRequest(128, 21027);
            temp = Math.round(this.bytesToFloat(resp) * 10.0f);
            if (this.t2_winter != temp) {
                this.t2_winter = temp;
                this.ioWrite(this.genEvents, "t2.winter", Integer.toString(temp));
                this.uiSet("t2.winter", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)temp / 10.0f))) + " &deg;C");
            }
            ok = true;
        }
        catch (IOException e5) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (4): " + e5.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        try {
            resp = this.writeRequest(128, 21028);
            temp = Math.round(this.bytesToFloat(resp) * 10.0f);
            if (this.lim_winter != temp) {
                this.lim_winter = temp;
                this.ioWrite(this.genEvents, "lim.winter", Integer.toString(temp));
                this.uiSet("lim.winter", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)temp / 10.0f))) + " &deg;C");
            }
            ok = true;
        }
        catch (IOException e6) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (5): " + e6.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        try {
            resp = this.writeRequest(128, 29250);
            temp = Math.round(this.bytesToFloat(resp) * 10.0f);
            if (this.set_winter != temp) {
                this.set_winter = temp;
                this.ioWrite(this.genEvents, "setpoint.winter", Integer.toString(temp));
                this.uiSet("setpoint.winter", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)temp / 10.0f))) + " &deg;C");
            }
            ok = true;
        }
        catch (IOException e7) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (6): " + e7.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        try {
            resp = this.writeRequest(128, 29251);
            temp = Math.round(this.bytesToFloat(resp) * 10.0f);
            if (this.set_summer != temp) {
                this.set_summer = temp;
                this.ioWrite(this.genEvents, "setpoint.summer", Integer.toString(temp));
                this.uiSet("setpoint.summer", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)temp / 10.0f))) + " &deg;C");
            }
            ok = true;
        }
        catch (IOException e8) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error (7): " + e8.getLocalizedMessage(), this.serverName);
        }
        if (me.quit) {
            return false;
        }
        this.processCommand(this.ioqtx.poll());
        for (KPM20 kpm : this.kpm20s.values()) {
            if (kpm.poll()) {
                ok = true;
            }
            if (me.quit) {
                return false;
            }
            this.processCommand(this.ioqtx.poll());
            for (KPM20.K483 ts : kpm.k483s.values()) {
                if (ts.poll()) {
                    ok = true;
                }
                if (me.quit) {
                    return false;
                }
                this.processCommand(this.ioqtx.poll());
            }
        }
        return ok;
    }

    private void processCommand(String cmd) {
        block35: {
            if (cmd == null) {
                return;
            }
            Logger.log(Logger.Mode.EVENT, "commandExecutor - processing command: " + cmd, this.serverName);
            cmd = cmd.toLowerCase();
            try {
                String[] func_val = cmd.split("=");
                String func = func_val[0];
                String val = func_val[1];
                if (func.startsWith("k")) {
                    KPM20.K483 k483;
                    KPM20 kpm20;
                    int sub_addr;
                    int addr;
                    int dot = func.indexOf(46);
                    try {
                        addr = Integer.parseInt(func.substring(1, dot));
                    }
                    catch (NumberFormatException e2) {
                        throw new Exception("unknown function");
                    }
                    func = func.substring(dot + 1);
                    dot = func.indexOf(46);
                    try {
                        sub_addr = Integer.parseInt(func.substring(0, dot));
                    }
                    catch (NumberFormatException e3) {
                        throw new Exception("unknown function");
                    }
                    func = func.substring(dot + 1);
                    if (func.equals("setpoint.temp")) {
                        float temp = (float)Integer.parseInt(val) / 10.0f;
                        kpm20 = this.kpm20s.get(addr);
                        if (kpm20 == null) {
                            throw new Exception("Illegal KPM20 address: " + addr);
                        }
                        k483 = (KPM20.K483)kpm20.k483s.get(sub_addr);
                        if (k483 == null) {
                            throw new Exception("Illegal K483 sub-address: " + sub_addr);
                        }
                        k483.writeSetpoint(temp);
                    }
                    if (func.equals("setpoint.humidity")) {
                        float hum = (float)Integer.parseInt(val) / 10.0f;
                        Logger.log(Logger.Mode.VERBOSE, "ioMonitor - new humidity setpoint: '" + hum, this.serverName);
                        kpm20 = this.kpm20s.get(addr);
                        if (kpm20 == null) {
                            throw new Exception("Illegal KPM20 address: " + addr);
                        }
                        k483 = (KPM20.K483)kpm20.k483s.get(sub_addr);
                        if (k483 == null) {
                            throw new Exception("Illegal K483 sub-address: " + sub_addr);
                        }
                        k483.writeSetpointHumidity(hum);
                        break block35;
                    }
                    if (func.equals("mode")) {
                        KPM20 kpm202 = this.kpm20s.get(addr);
                        if (kpm202 == null) {
                            throw new Exception("Illegal KPM20 address: " + addr);
                        }
                        KPM20.K483 k4832 = (KPM20.K483)kpm202.k483s.get(sub_addr);
                        if (k4832 == null) {
                            throw new Exception("Illegal K483 sub-address: " + sub_addr);
                        }
                        k4832.writeMode(val);
                        break block35;
                    }
                    throw new Exception("unknown function");
                }
                if (func.equals("setpoint.temp")) {
                    float temp = (float)Integer.parseInt(val) / 10.0f;
                    for (KPM20 kpm20 : this.kpm20s.values()) {
                        for (KPM20.K483 k483 : kpm20.k483s.values()) {
                            k483.writeSetpoint(temp);
                        }
                    }
                    break block35;
                }
                if (func.equals("setpoint.humidity")) {
                    float hum = (float)Integer.parseInt(val) / 10.0f;
                    for (KPM20 kpm20 : this.kpm20s.values()) {
                        for (KPM20.K483 k483 : kpm20.k483s.values()) {
                            k483.writeSetpointHumidity(hum);
                        }
                    }
                    break block35;
                }
                if (func.equals("mode")) {
                    for (KPM20 kpm20 : this.kpm20s.values()) {
                        for (KPM20.K483 k483 : kpm20.k483s.values()) {
                            k483.writeMode(val);
                        }
                    }
                    break block35;
                }
                if (func.equals("season")) {
                    if (val.equals("summer")) {
                        this.writeConfigCommand(29249, new byte[1]);
                        break block35;
                    }
                    if (val.equals("winter")) {
                        this.writeConfigCommand(29249, new byte[]{1});
                        break block35;
                    }
                    throw new Exception("illegal value");
                }
                if (func.equals("t1.winter")) {
                    float temp = (float)Integer.parseInt(val) / 10.0f;
                    this.writeConfigCommand(21026, this.floatToBytes(temp));
                    break block35;
                }
                if (func.equals("t2.winter")) {
                    float temp = (float)Integer.parseInt(val) / 10.0f;
                    this.writeConfigCommand(21027, this.floatToBytes(temp));
                    break block35;
                }
                if (func.equals("lim.winter")) {
                    float temp = (float)Integer.parseInt(val) / 10.0f;
                    this.writeConfigCommand(21028, this.floatToBytes(temp));
                    break block35;
                }
                if (func.startsWith("setpoint.")) {
                    float temp = (float)Integer.parseInt(val) / 10.0f;
                    if (func.endsWith("winter")) {
                        this.writeConfigCommand(29250, this.floatToBytes(temp));
                        break block35;
                    }
                    if (func.endsWith("summer")) {
                        this.writeConfigCommand(29251, this.floatToBytes(temp));
                        break block35;
                    }
                    throw new Exception("unknown function");
                }
                throw new Exception("unknown function");
            }
            catch (Exception e4) {
                Logger.log(Logger.Mode.ERROR, "commandExecutor - error processing command '" + cmd + "': " + e4.getLocalizedMessage(), this.serverName);
            }
        }
    }

    private void writeConfigCommand(int item, byte[] data) throws Exception {
        this.writeCommand2(128, 3, new byte[]{1});
        this.writeCommand(128, item, data);
        this.writeCommand2(128, 3, new byte[]{2});
    }

    private void writeCommand2(int addr, int item, byte[] data) throws Exception {
        byte[] block = new byte[data.length + 4];
        block[0] = (byte)addr;
        block[1] = -59;
        block[2] = (byte)item;
        block[3] = (byte)(item >>> 8);
        System.arraycopy(data, 0, block, 4, data.length);
        this.write(block);
    }

    private void writeTermostatCommand(int addr, int sub_addr, int item, byte[] data) throws Exception {
        item = (item & 0xFF) + (sub_addr + 8 << 8);
        this.writeCommand(addr, item, data);
    }

    private void writeCommand(int addr, int item, byte[] data) throws Exception {
        byte[] block = new byte[data.length + 4];
        block[0] = (byte)addr;
        block[1] = -60;
        block[2] = (byte)item;
        block[3] = (byte)(item >>> 8);
        System.arraycopy(data, 0, block, 4, data.length);
        this.write(block);
    }

    private byte[] writeTermostatRequest(int addr, int sub_addr, int item) throws Exception {
        item = (item & 0xFF) + (sub_addr + 8 << 8);
        return this.writeRequest(addr, item);
    }

    private byte[] writeRequest(int addr, int item) throws Exception {
        byte[] block = new byte[]{(byte)addr, -124, (byte)item, (byte)(item >>> 8)};
        return this.write(block);
    }

    private byte[] write(byte[] block) throws Exception {
        block = this.addChecksum(this.bytesToAscii(this.addBCC(block)));
        byte[] pack = new byte[block.length + 2];
        pack[0] = 62;
        pack[pack.length - 1] = 13;
        int i2 = 0;
        while (i2 < block.length) {
            pack[i2 + 1] = block[i2];
            ++i2;
        }
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                util.readComm(this.commPort, 0);
                if (util.writeCommBytes(this.commPort, pack) != pack.length) {
                    throw new IOException("write comm error");
                }
                return this.read();
            }
            catch (IOException e2) {
                if (attempt > 5) {
                    throw e2;
                }
                Logger.log(Logger.Mode.VERBOSE, "error writing command (" + e2.getLocalizedMessage() + "). Retrying...", this.serverName);
                Thread.sleep(500L);
                continue;
            }
            break;
        }
    }

    private byte[] read() throws Exception {
        byte[] b2;
        ByteBuffer resp = ByteBuffer.allocate(124);
        do {
            if ((b2 = util.readCommBytes(this.commPort, 1)) == null) {
                throw new IOException("read comm error: null");
            }
            if (b2.length != 1) {
                throw new IOException("read comm error: length " + b2.length);
            }
            try {
                resp.put(b2[0]);
            }
            catch (BufferOverflowException e2) {
                throw new IOException("received message exceeded maximum length");
            }
        } while (b2[0] != 13);
        resp.position(resp.position() - 1);
        byte ack = resp.get(0);
        if (ack == 78) {
            byte[] err = this.asciiToBytes(resp, 1);
            switch (err[0]) {
                case 1: {
                    throw new Exception("error response: not existing command code");
                }
                case -128: {
                    throw new Exception("error response: data not matching the item type");
                }
                case -127: {
                    throw new Exception("error response: not existing item");
                }
                case -126: {
                    throw new IOException("error response: temporarily impossible to access the EEPROM memory");
                }
                case -125: {
                    throw new Exception("error response: not programmable item");
                }
            }
            throw new IOException("error response: unknown error (" + (err[0] & 0xFF) + ")");
        }
        if (ack != 65) {
            throw new IOException("error ack response");
        }
        if (resp.position() < 2) {
            return new byte[]{65};
        }
        if (!this.checkSum(resp, 1)) {
            throw new IOException("response checksum error");
        }
        resp.position(resp.position() - 2);
        byte[] bytes = this.asciiToBytes(resp, 1);
        if (!this.checkBCC(bytes)) {
            throw new IOException("response BCC error");
        }
        byte[] data = new byte[bytes.length - 2];
        int i2 = 0;
        while (i2 < data.length) {
            data[i2] = bytes[i2];
            ++i2;
        }
        return data;
    }

    private float bytesToFloat(byte[] bytes) {
        int data = bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8;
        return this.bitsToFloat(data);
    }

    private float bitsToFloat(int bits) {
        int fraction = bits & 0x7FF;
        if (fraction == 0) {
            return 0.0f;
        }
        int sign = (bits >>> 11 & 1) == 0 ? 1 : -1;
        int exp = bits >>> 12 & 0xF;
        float val = (float)((double)sign * Math.pow(2.0, exp) * (double)fraction * Math.pow(2.0, -11.0));
        return val;
    }

    private byte[] floatToBytes(float value) {
        int bits = this.floatToBits(value);
        byte[] bytes = new byte[]{(byte)bits, (byte)(bits >>> 8)};
        return bytes;
    }

    private int floatToBits(float value) {
        if (value == 0.0f) {
            return 0;
        }
        int sign = 0;
        if (value < 0.0f) {
            sign = 1;
            value *= -1.0f;
        }
        int bits = (int)value;
        float fractional = value - (float)bits;
        int exp = 32 - Integer.numberOfLeadingZeros(bits);
        if (exp > 15) {
            if (sign == 0) {
                return 63487;
            }
            return 65535;
        }
        int shift = 11 - exp;
        if (shift <= 0) {
            bits >>>= -shift;
        } else {
            int i2 = 0;
            while (i2 < shift) {
                int bit = (int)(fractional *= 2.0f);
                fractional -= (float)bit;
                bits = bits << 1 | bit;
                ++i2;
            }
        }
        bits |= sign << 11;
        return bits |= exp << 12;
    }

    private boolean checkBCC(byte[] bytes) {
        int s1 = 0;
        int s2 = 0;
        int i2 = 0;
        while (i2 < bytes.length - 2) {
            if ((s1 += bytes[i2] & 0xFF) >= 256) {
                s1 -= 255;
            }
            if ((s2 += s1) >= 256) {
                s2 -= 255;
            }
            ++i2;
        }
        int sum = s1 + s2;
        if (sum >= 256) {
            sum -= 255;
        }
        byte bcc1 = (byte)(~sum);
        byte bcc2 = (byte)s2;
        return bytes[bytes.length - 2] == bcc1 && bytes[bytes.length - 1] == bcc2;
    }

    private byte[] addBCC(byte[] block) {
        int s1 = 0;
        int s2 = 0;
        byte[] ret = new byte[block.length + 2];
        int i2 = 0;
        while (i2 < block.length) {
            ret[i2] = block[i2];
            if ((s1 += block[i2] & 0xFF) >= 256) {
                s1 -= 255;
            }
            if ((s2 += s1) >= 256) {
                s2 -= 255;
            }
            ++i2;
        }
        int sum = s1 + s2;
        if (sum >= 256) {
            sum -= 255;
        }
        byte bcc1 = (byte)(~sum);
        byte bcc2 = (byte)s2;
        ret[ret.length - 2] = bcc1;
        ret[ret.length - 1] = bcc2;
        return ret;
    }

    private boolean checkSum(ByteBuffer resp, int offset) {
        byte[] sum = new byte[1];
        int i2 = offset;
        while (i2 < resp.position() - 2) {
            sum[0] = (byte)(sum[0] + resp.get(i2));
            ++i2;
        }
        byte[] asciiSum = this.bytesToAscii(sum);
        return resp.get(resp.position() - 2) == asciiSum[0] && resp.get(resp.position() - 1) == asciiSum[1];
    }

    private byte[] addChecksum(byte[] block) {
        byte[] ret = new byte[block.length + 2];
        byte[] sum = new byte[1];
        int i2 = 0;
        while (i2 < block.length) {
            sum[0] = (byte)(sum[0] + block[i2]);
            ret[i2] = block[i2];
            ++i2;
        }
        byte[] asciiSum = this.bytesToAscii(sum);
        ret[ret.length - 2] = asciiSum[0];
        ret[ret.length - 1] = asciiSum[1];
        return ret;
    }

    private byte[] asciiToBytes(ByteBuffer ascii, int offset) {
        byte[] bytes = new byte[(ascii.position() - offset) / 2];
        int i2 = 0;
        while (i2 < bytes.length) {
            char high = (char)(ascii.get(i2 * 2 + offset) & 0xFF);
            char low = (char)(ascii.get(i2 * 2 + 1 + offset) & 0xFF);
            String hex = String.valueOf(high) + low;
            bytes[i2] = (byte)Integer.parseInt(hex, 16);
            ++i2;
        }
        return bytes;
    }

    private byte[] bytesToAscii(byte[] bytes) {
        byte[] ascii = new byte[bytes.length * 2];
        int i2 = 0;
        while (i2 < bytes.length) {
            ascii[i2 * 2] = (byte)Integer.toHexString(bytes[i2] >>> 4 & 0xF).toUpperCase().charAt(0);
            ascii[i2 * 2 + 1] = (byte)Integer.toHexString(bytes[i2] & 0xF).toUpperCase().charAt(0);
            ++i2;
        }
        return ascii;
    }

    public String keypad(String id) {
        if (this.guiSupport) {
            Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id, this.serverName);
            try {
                int val_idx = id.lastIndexOf(46);
                String name = id.substring(0, val_idx);
                String value = id.substring(val_idx + 1);
                if (name.endsWith(".setpoint.temp") && (value.equals("up") || value.equals("down"))) {
                    int v;
                    IOCommandSet cs = this.keypadCmds.get(name);
                    if (cs == null) {
                        String vStr = this.uiGet(name, "value").replace("&deg;C", "").trim();
                        v = (int)(Float.parseFloat(vStr) * 10.0f);
                    } else {
                        cs.interrupt();
                        v = Integer.parseInt(cs.value);
                    }
                    v = value.equals("up") ? v / 5 * 5 + 5 : (v + 4) / 5 * 5 - 5;
                    this.uiSet(name, "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + " &deg;C");
                    this.keypadCmds.put(name, new IOCommandSet(name, Integer.toString(v)));
                } else if (name.endsWith(".setpoint") && value.equals("mode")) {
                    String v;
                    IOCommandSet cs = this.keypadCmds.get(name);
                    if (cs == null) {
                        v = this.uiGet(String.valueOf(name) + ".mode", "value").toLowerCase();
                    } else {
                        cs.interrupt();
                        v = cs.value;
                    }
                    v = v.equals("com") ? "off" : (v.equals("off") ? "ngt" : (v.equals("ngt") ? "stb" : "com"));
                    this.uiSet(String.valueOf(name) + ".mode", "value", v.toUpperCase());
                    this.keypadCmds.put(name, new IOCommandSet(name.replace(".setpoint", ".mode"), v));
                } else {
                    SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
                }
            }
            catch (Exception e2) {
                Logger.log(Logger.Mode.ERROR, "keypad - error processing command '" + id + "': " + e2.getLocalizedMessage(), this.serverName);
                return null;
            }
        }
        return "";
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
    }

    private void uiSet(String id, String attr, String value) {
        if (this.guiSupport) {
            userBase.uiSet(String.valueOf(this.serverName) + "." + id, attr, value);
        }
    }

    private String uiGet(String id, String attr) {
        return userBase.uiGet(String.valueOf(this.serverName) + "." + id, attr);
    }

    private class IOCommandSet
    extends Thread {
        final String value;
        final String name;

        public IOCommandSet(String name, String value) {
            this.name = name;
            this.value = value;
            this.start();
        }

        @Override
        public void run() {
            try {
                IOCommandSet.sleep(2000L);
                GKBus.this.keypadCmds.remove(this.name);
                SystemState.ioSet(String.valueOf(GKBus.this.serverName) + "." + this.name, this.value);
                if (this.name.startsWith("k")) {
                    int dot = this.name.indexOf(46);
                    int addr = Integer.parseInt(this.name.substring(1, dot));
                    String func = this.name.substring(dot + 1);
                    dot = func.indexOf(46);
                    int sub_addr = Integer.parseInt(func.substring(0, dot));
                    if ((func = func.substring(dot + 1)).equals("setpoint.temp")) {
                        ((KPM20.K483)((KPM20)GKBus.this.kpm20s.get(addr)).k483s.get(sub_addr)).ts_setPoint = -9999;
                    } else if (func.equals("mode")) {
                        ((KPM20.K483)((KPM20)GKBus.this.kpm20s.get(addr)).k483s.get(sub_addr)).ts_mode = -9999;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class KPM20 {
        private final int addr;
        private final String prefix;
        private int inTemp = -9999;
        private int outTemp = -9999;
        private int pumpStatus = -9999;
        private int setPoint = -9999;
        private int valvePos = -9999;
        private HashMap<Integer, K483> k483s = new HashMap();

        KPM20(int addr) {
            this.addr = addr;
            this.prefix = "k" + addr + ".";
            this.k483s = new HashMap();
        }

        public boolean poll() throws Exception {
            byte[] resp;
            boolean ok = false;
            try {
                resp = GKBus.this.writeRequest(this.addr, 9);
                this.setInTemp(resp);
                ok = true;
            }
            catch (IOException e2) {
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + this.addr + " (1): " + e2.getLocalizedMessage(), GKBus.this.serverName);
            }
            try {
                resp = GKBus.this.writeRequest(this.addr, 10);
                this.setOutTemp(resp);
                ok = true;
            }
            catch (IOException e3) {
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + this.addr + " (2): " + e3.getLocalizedMessage(), GKBus.this.serverName);
            }
            try {
                resp = GKBus.this.writeRequest(this.addr, 13);
                this.setPumpStatus(resp);
                ok = true;
            }
            catch (IOException e4) {
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + this.addr + " (3): " + e4.getLocalizedMessage(), GKBus.this.serverName);
            }
            try {
                resp = GKBus.this.writeRequest(this.addr, 18);
                this.setValvePos(resp);
                ok = true;
            }
            catch (IOException e5) {
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + this.addr + " (4): " + e5.getLocalizedMessage(), GKBus.this.serverName);
            }
            try {
                resp = GKBus.this.writeRequest(this.addr, 26);
                this.setSetPoint(resp);
                ok = true;
            }
            catch (IOException e6) {
                Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + this.addr + " (5): " + e6.getLocalizedMessage(), GKBus.this.serverName);
            }
            return ok;
        }

        void addK483(int sub_addr, String name) {
            this.k483s.put(sub_addr, new K483(sub_addr, name));
        }

        void setInTemp(byte[] val) {
            int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
            if (this.inTemp != v) {
                this.inTemp = v;
                GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.prefix) + "in.temp", Integer.toString(v));
                GKBus.this.uiSet(String.valueOf(this.prefix) + "in.temp", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + " &deg;C");
            }
        }

        void setOutTemp(byte[] val) {
            int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
            if (this.outTemp != v) {
                this.outTemp = v;
                GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.prefix) + "out.temp", Integer.toString(v));
                GKBus.this.uiSet(String.valueOf(this.prefix) + "out.temp", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + " &deg;C");
            }
        }

        void setSetPoint(byte[] val) {
            int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
            if (this.setPoint != v) {
                this.setPoint = v;
                GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.prefix) + "setpoint.temp", Integer.toString(v));
                GKBus.this.uiSet(String.valueOf(this.prefix) + "setpoint.temp", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + " &deg;C");
            }
        }

        void setValvePos(byte[] val) {
            int v = Math.round(GKBus.this.bytesToFloat(val));
            if (this.valvePos != v) {
                this.valvePos = v;
                GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.prefix) + "valve", Integer.toString(v));
                GKBus.this.uiSet(String.valueOf(this.prefix) + "valve", "value", String.valueOf(v) + "%");
            }
        }

        void setPumpStatus(byte[] val) {
            int v = val[0] & 1;
            if (this.pumpStatus != v) {
                this.pumpStatus = v;
                if (v == 0) {
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.prefix) + "pump", "0");
                    GKBus.this.uiSet(String.valueOf(this.prefix) + "pump.label.0", "visible", "true");
                    GKBus.this.uiSet(String.valueOf(this.prefix) + "pump.label.1", "visible", "false");
                } else {
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.prefix) + "pump", "1");
                    GKBus.this.uiSet(String.valueOf(this.prefix) + "pump.label.0", "visible", "false");
                    GKBus.this.uiSet(String.valueOf(this.prefix) + "pump.label.1", "visible", "true");
                }
            }
        }

        private class K483 {
            private final int sub_addr;
            private final String sub_prefix;
            private int ts_temp = -9999;
            private int ts_setPoint = -9999;
            private int ts_setPointHum = -9999;
            private int ts_humidity = -9999;
            private int ts_status = -9999;
            private int ts_mode = -9999;

            K483(int addr, String name) {
                this.sub_addr = addr;
                this.sub_prefix = String.valueOf(KPM20.this.prefix) + this.sub_addr + ".";
                if (name != null) {
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "name", name);
                    GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "name", "value", name);
                }
            }

            public void writeMode(String val) throws Exception {
                if (val.equals("com")) {
                    byte[] byArray = new byte[2];
                    byArray[0] = 2;
                    GKBus.this.writeTermostatCommand(KPM20.this.addr, this.sub_addr, 6, byArray);
                } else if (val.equals("stb")) {
                    byte[] byArray = new byte[2];
                    byArray[0] = 1;
                    GKBus.this.writeTermostatCommand(KPM20.this.addr, this.sub_addr, 6, byArray);
                } else if (val.equals("ngt")) {
                    GKBus.this.writeTermostatCommand(KPM20.this.addr, this.sub_addr, 6, new byte[2]);
                } else if (val.equals("off")) {
                    byte[] byArray = new byte[2];
                    byArray[0] = 3;
                    GKBus.this.writeTermostatCommand(KPM20.this.addr, this.sub_addr, 6, byArray);
                } else {
                    throw new Exception("illegal value");
                }
                this.poll();
            }

            public void writeSetpoint(float temp) throws Exception {
                GKBus.this.writeTermostatCommand(KPM20.this.addr, this.sub_addr, 3, GKBus.this.floatToBytes(temp));
                this.poll();
            }

            public void writeSetpointHumidity(float hum) throws Exception {
                GKBus.this.writeTermostatCommand(KPM20.this.addr, this.sub_addr, 36, GKBus.this.floatToBytes(hum));
                this.poll();
            }

            public boolean poll() throws Exception {
                byte[] resp;
                boolean ok = false;
                try {
                    resp = GKBus.this.writeTermostatRequest(KPM20.this.addr, this.sub_addr, 3);
                    this.setSetPoint(resp);
                    ok = true;
                }
                catch (IOException e2) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + KPM20.this.addr + ", K483 " + this.sub_addr + " (1): " + e2.getLocalizedMessage(), GKBus.this.serverName);
                }
                try {
                    resp = GKBus.this.writeTermostatRequest(KPM20.this.addr, this.sub_addr, 6);
                    this.setMode(resp);
                    ok = true;
                }
                catch (IOException e3) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + KPM20.this.addr + ", K483 " + this.sub_addr + " (2): " + e3.getLocalizedMessage(), GKBus.this.serverName);
                }
                try {
                    resp = GKBus.this.writeTermostatRequest(KPM20.this.addr, this.sub_addr, 6);
                    this.setStatus(resp);
                    ok = true;
                }
                catch (IOException e4) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + KPM20.this.addr + ", K483 " + this.sub_addr + " (3): " + e4.getLocalizedMessage(), GKBus.this.serverName);
                }
                try {
                    resp = GKBus.this.writeTermostatRequest(KPM20.this.addr, this.sub_addr, 1);
                    this.setTemp(resp);
                    ok = true;
                }
                catch (IOException e5) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + KPM20.this.addr + ", K483 " + this.sub_addr + " (4): " + e5.getLocalizedMessage(), GKBus.this.serverName);
                }
                try {
                    resp = GKBus.this.writeTermostatRequest(KPM20.this.addr, this.sub_addr, 22);
                    this.setHumidity(resp);
                    ok = true;
                }
                catch (IOException e6) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + KPM20.this.addr + ", K483 " + this.sub_addr + " (5): " + e6.getLocalizedMessage(), GKBus.this.serverName);
                }
                try {
                    resp = GKBus.this.writeTermostatRequest(KPM20.this.addr, this.sub_addr, 36);
                    this.setSetPointHum(resp);
                    ok = true;
                }
                catch (IOException e7) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - polling error KPM20 " + KPM20.this.addr + ", K483 " + this.sub_addr + " (6): " + e7.getLocalizedMessage(), GKBus.this.serverName);
                }
                return ok;
            }

            void setTemp(byte[] val) {
                int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
                if (this.ts_temp != v) {
                    this.ts_temp = v;
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "temp", Integer.toString(v));
                    GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "temp", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + " &deg;C");
                }
            }

            void setSetPoint(byte[] val) {
                int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
                if (this.ts_setPoint != v) {
                    this.ts_setPoint = v;
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "setpoint.temp", Integer.toString(v));
                    GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "setpoint.temp", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + " &deg;C");
                }
            }

            void setSetPointHum(byte[] val) {
                int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
                if (this.ts_setPointHum != v) {
                    this.ts_setPointHum = v;
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "setpoint.humidity", Integer.toString(v));
                    GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "setpoint.humidity", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + "%");
                }
            }

            void setHumidity(byte[] val) {
                int v = Math.round(GKBus.this.bytesToFloat(val) * 10.0f);
                if (this.ts_humidity != v) {
                    this.ts_humidity = v;
                    GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "humidity", Integer.toString(v));
                    GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "humidity", "value", String.valueOf(String.format("%.1f", Float.valueOf((float)v / 10.0f))) + "%");
                }
            }

            void setStatus(byte[] val) {
                int v = val[0] >>> 6 & 1;
                if (this.ts_status != v) {
                    this.ts_status = v;
                    if (v == 0) {
                        GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "relay", "0");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "relay.label.0", "visible", "true");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "relay.label.1", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "status.label.cooling", "visible", "false");
                    } else {
                        GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "relay", "1");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "relay.label.0", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "relay.label.1", "visible", "true");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "status.label.cooling", "visible", "true");
                    }
                }
            }

            void setMode(byte[] val) {
                int v = val[0] & 3;
                if (this.ts_mode != v) {
                    this.ts_mode = v;
                    if (this.ts_mode == 2) {
                        GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "mode", "com");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "setpoint.mode", "value", "COM");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.com", "visible", "true");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.stb", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.ngt", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.off", "visible", "false");
                    } else if (this.ts_mode == 1) {
                        GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "mode", "stb");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "setpoint.mode", "value", "STB");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.com", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.stb", "visible", "true");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.ngt", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.off", "visible", "false");
                    } else if (this.ts_mode == 0) {
                        GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "mode", "ngt");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "setpoint.mode", "value", "NGT");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.com", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.stb", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.ngt", "visible", "true");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.off", "visible", "false");
                    } else {
                        GKBus.this.ioWrite(GKBus.this.genEvents, String.valueOf(this.sub_prefix) + "mode", "off");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "setpoint.mode", "value", "OFF");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.com", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.stb", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.ngt", "visible", "false");
                        GKBus.this.uiSet(String.valueOf(this.sub_prefix) + "mode.label.off", "visible", "true");
                    }
                }
            }
        }
    }

    private static abstract class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg, String serverName) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(String.valueOf(msg) + " [" + serverName + "]");
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(String.valueOf(serverName) + " - " + msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }
}

