/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.HsycoFile;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.json.JSONObject;

class FileServer {
    public static final boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    private static final long SIZE_LIMIT = 100000000L;
    static final Comparator<File> FILES_COMPARE = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
        }
    };

    FileServer() {
    }

    static String ls(String path, int depth) {
        int n2 = depth = depth == 0 ? -1 : depth + 1;
        if (path.length() == 0 || path.equals(".")) {
            try {
                return FileServer.ls(new File(".").getCanonicalFile(), depth);
            }
            catch (Exception e2) {
                return null;
            }
        }
        return FileServer.ls(new File(path), depth);
    }

    private static String ls(File path, int depth) {
        StringBuffer sb;
        block11: {
            sb = new StringBuffer();
            FileServer.pathSanityCheck(path, false);
            if (depth != 0) break block11;
            return "";
        }
        try {
            String name = path.getName();
            if (!name.startsWith(".") && !name.equals("lost+found")) {
                name = JSONObject.quote(name);
                if (path.isDirectory()) {
                    sb.append("[");
                    sb.append(name);
                    sb.append(",\"d\",[");
                    if (depth != 1) {
                        File[] fa = path.listFiles();
                        Arrays.sort(fa, FILES_COMPARE);
                        String node = "";
                        int i2 = 0;
                        while (i2 < fa.length) {
                            String newnode = FileServer.ls(fa[i2], depth - 1);
                            if (newnode != null) {
                                if (node.length() > 0) {
                                    sb.append(',');
                                }
                                node = newnode;
                                sb.append(node);
                            }
                            ++i2;
                        }
                    }
                    sb.append("],\"");
                    long time = path.lastModified();
                    sb.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(time));
                    sb.append("\",");
                    sb.append(time);
                    sb.append(']');
                } else if (path.isFile()) {
                    sb.append("[");
                    sb.append(name);
                    sb.append(",\"f\",");
                    sb.append(path.length());
                    sb.append(",\"");
                    long time = path.lastModified();
                    sb.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(time));
                    sb.append("\",");
                    sb.append(time);
                    sb.append(']');
                }
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    static void zip(ZipOutputStream out, File path, File basepath, String[] exclude) throws Exception {
        String basename;
        int FILEBUFFER = 2048;
        String canonical = null;
        String string = basename = basepath != null ? basepath.getPath() : "";
        if (!(!path.isDirectory() || path.getName().equals("lost+found") || path.getName().startsWith(".") && !path.getName().equals(".") || path.getName().startsWith("~"))) {
            canonical = path.getCanonicalPath();
            if (canonical != null && exclude != null) {
                int i2 = 0;
                while (i2 < exclude.length) {
                    if (canonical.equals(new File(exclude[i2]).getCanonicalPath())) {
                        return;
                    }
                    ++i2;
                }
            }
            File[] fa = path.listFiles();
            byte[] data = new byte[2048];
            int i3 = 0;
            while (i3 < fa.length) {
                if (!(!fa[i3].isFile() || fa[i3].getName().startsWith(".") || fa[i3].getName().startsWith("~") || fa[i3].getPath().equals("./hsyco.jar") || fa[i3].getPath().startsWith("./hs_err_pid"))) {
                    int counter = 0;
                    BufferedInputStream source = new BufferedInputStream(new FileInputStream(fa[i3]), 2048);
                    String entryname = fa[i3].getPath();
                    if (basename.length() > 0 && entryname.startsWith(basename)) {
                        entryname = entryname.substring(basename.length() + 1);
                    }
                    out.putNextEntry(new ZipEntry(entryname));
                    while ((counter = source.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, counter);
                    }
                    source.close();
                } else {
                    FileServer.zip(out, fa[i3], basepath, exclude);
                }
                ++i3;
            }
        }
    }

    static long zipSize(File path, String[] exclude) throws Exception {
        String canonical = null;
        long size = 0L;
        if (path.isDirectory()) {
            if (path.getCanonicalPath().equals(new File(".").getCanonicalPath())) {
                canonical = path.getCanonicalPath();
            }
            if (canonical != null && exclude != null) {
                int i2 = 0;
                while (i2 < exclude.length) {
                    if (canonical.equals(new File(exclude[i2]).getCanonicalPath())) {
                        return 0L;
                    }
                    ++i2;
                }
            }
            File[] fa = path.listFiles();
            int i3 = 0;
            while (i3 < fa.length) {
                if (fa[i3].isFile() && !fa[i3].getName().startsWith(".") && !fa[i3].getPath().equals("./hsyco.jar")) {
                    size += fa[i3].isFile() ? fa[i3].length() : FileServer.zipSize(fa[i3], exclude);
                }
                ++i3;
            }
        }
        return size;
    }

    static String open(String path, int lines) {
        StringBuffer sb = new StringBuffer();
        int linecounter = lines > 0 ? lines : Integer.MAX_VALUE;
        try {
            File f2 = new File(path);
            FileServer.pathSanityCheck(f2, false);
            if (f2.canRead() && f2.isFile()) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f2), "UTF-8"));
                sb.append("Content:");
                while ((line = in.readLine()) != null && linecounter-- > 0) {
                    sb.append(line);
                    sb.append("\r\n");
                }
                in.close();
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    static byte[] byteOpen(String path) {
        try {
            File f2 = new File(path);
            FileServer.pathSanityCheck(f2, false);
            if (f2.canRead()) {
                if (f2.isFile()) {
                    return new HsycoFile(".", path).getBytes();
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(bout));
                String[] exclude = new String[]{"./logs", "./motion"};
                FileServer.zip(zout, f2, f2.getParentFile(), exclude);
                zout.close();
                byte[] data = bout.toByteArray();
                return data;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    static boolean delete(String path) {
        try {
            File f2 = new File(path);
            FileServer.pathSanityCheck(f2, false);
            FileServer.setParentModified(f2);
            return f2.delete();
        }
        catch (Exception e2) {
            return false;
        }
    }

    static boolean delete(String[] paths) {
        boolean ret = false;
        try {
            int i2 = 0;
            while (i2 < paths.length) {
                ret |= FileServer.delete(paths[i2]);
                ++i2;
            }
            return ret;
        }
        catch (Exception e2) {
            return false;
        }
    }

    static boolean delete(File path, boolean recursive) {
        try {
            if (recursive) {
                FileServer.pathSanityCheck(path, true);
                if (path.isDirectory()) {
                    File[] files = path.listFiles();
                    int i2 = 0;
                    while (i2 < files.length) {
                        FileServer.delete(files[i2], true);
                        ++i2;
                    }
                }
                FileServer.setParentModified(path);
                return path.delete();
            }
            FileServer.pathSanityCheck(path, false);
            FileServer.setParentModified(path);
            return path.delete();
        }
        catch (Exception e2) {
            return false;
        }
    }

    static boolean delete(String path, boolean recursive) {
        return FileServer.delete(new File(path), recursive);
    }

    static boolean delete(String[] paths, boolean recursive) {
        boolean ret = false;
        try {
            int i2 = 0;
            while (i2 < paths.length) {
                ret |= FileServer.delete(paths[i2], recursive);
                ++i2;
            }
            return ret;
        }
        catch (Exception e2) {
            return false;
        }
    }

    static boolean mkdir(String path) {
        File f2;
        block4: {
            try {
                f2 = new File(path);
                FileServer.pathSanityCheck(f2, true);
                if (!f2.isDirectory()) break block4;
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        if (f2.mkdir()) {
            f2.setWritable(true, false);
            FileServer.setParentModified(f2);
            return true;
        }
        return false;
    }

    static int upload(String path, String data) {
        try {
            String line;
            File destFile = new File(path);
            FileServer.pathSanityCheck(destFile, false);
            File parent = destFile.getParentFile();
            if (parent != null && !parent.isDirectory() && parent.mkdir()) {
                parent.setWritable(true, false);
                FileServer.setParentModified(parent);
            }
            File tempFile = new File(parent, String.valueOf(isWindows ? "_" : ".~") + destFile.getName());
            PrintWriter out = new PrintWriter(tempFile, "UTF-8");
            BufferedReader in = new BufferedReader(new StringReader(data));
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    out.println();
                } else {
                    firstLine = false;
                }
                out.print(line);
            }
            in.close();
            out.close();
            if (isWindows) {
                destFile.delete();
            }
            tempFile.renameTo(destFile);
            destFile.setWritable(true, false);
            FileServer.setParentModified(destFile);
            FileServer.fileEvents(path);
            return data.length();
        }
        catch (Exception e2) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int upload(String path, byte[] post, boolean expand, String session, String userid, String rem) {
        String boundary = "\r\n";
        String header = "";
        int state = 0;
        int fileBegin = 0;
        int fileEnd = 0;
        try {
            File destPath = new File(path);
            FileServer.pathSanityCheck(destPath, false);
            int i2 = 0;
            while (true) {
                if (i2 >= post.length) {
                    return post.length;
                }
                switch (state) {
                    case 0: {
                        if (post[i2] == 13) {
                            if (post[i2 + 1] != 10) {
                                return -1;
                            }
                            state = 1;
                            ++i2;
                            break;
                        }
                        boundary = String.valueOf(boundary) + (char)post[i2];
                        break;
                    }
                    case 1: {
                        if (post[i2] == 13 && post[i2 + 1] == 10 && post[i2 + 2] == 13 && post[i2 + 3] == 10) {
                            fileBegin = i2 + 4;
                            state = 2;
                            i2 += 4;
                            break;
                        }
                        header = String.valueOf(header) + (char)post[i2];
                        break;
                    }
                    case 2: {
                        int p = 0;
                        while (p < boundary.length()) {
                            if ((char)post[i2 + p] == boundary.charAt(p)) {
                                state = 3;
                                ++p;
                                continue;
                            }
                            state = 2;
                            break;
                        }
                        if (state != 3) break;
                        fileEnd = i2 - 1;
                        ++i2;
                        if (fileBegin <= fileEnd) {
                            int nb = header.indexOf("filename=\"");
                            if (nb == -1) {
                                return -1;
                            }
                            String filename = header.substring(nb += 10, header.indexOf(34, nb));
                            int ps1 = filename.lastIndexOf(47);
                            int ps2 = filename.lastIndexOf(92);
                            if (ps1 != -1 || ps2 != -1) {
                                filename = filename.substring((ps1 >= ps2 ? ps1 : ps2) + 1);
                            }
                            File tempFile = new File(destPath, String.valueOf(isWindows ? "_" : ".~") + filename);
                            File destFile = new File(destPath, filename);
                            FileServer.pathSanityCheck(destFile, false);
                            File parent = destFile.getParentFile();
                            if (!parent.isDirectory() && parent.mkdir()) {
                                parent.setWritable(true, false);
                                FileServer.setParentModified(parent);
                            }
                            if (!expand || !FileServer.unzip(destFile, new ByteArrayInputStream(post, fileBegin, fileEnd - fileBegin + 1))) {
                                FileOutputStream fos = new FileOutputStream(tempFile);
                                fos.write(post, fileBegin, fileEnd - fileBegin + 1);
                                fos.close();
                                if (isWindows) {
                                    destFile.delete();
                                }
                                tempFile.renameTo(destFile);
                                destFile.setWritable(true, false);
                                FileServer.setParentModified(destFile);
                                FileServer.fileEvents(destFile.getPath());
                                if (session != null && userid != null && rem != null) {
                                    userCode.userCommand(session, userid, rem, filename);
                                }
                            }
                        }
                        state = 0;
                        boundary = "\r\n";
                        header = "";
                        break;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return -1;
        }
    }

    static boolean unzip(File zipfile, ByteArrayInputStream data) {
        int filetype;
        String zipname;
        byte[] buffer;
        block15: {
            buffer = new byte[4096];
            zipname = zipfile.getName();
            String zipnamelower = zipname.toLowerCase();
            if (zipnamelower.endsWith(".zip")) {
                filetype = 1;
                break block15;
            }
            if (zipnamelower.endsWith(".hsp")) {
                filetype = 2;
                break block15;
            }
            return false;
        }
        try {
            int len;
            String zipbasepath;
            String basepath;
            if (filetype == 1) {
                basepath = zipfile.getParent();
                zipbasepath = zipname.substring(0, zipname.length() - 4);
            } else {
                basepath = ".";
                zipbasepath = null;
            }
            File tempZipFile = new File(basepath, String.valueOf(isWindows ? "_" : ".~") + zipname);
            FileOutputStream zos = new FileOutputStream(tempZipFile);
            while ((len = data.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zos.close();
            if (isWindows) {
                zipfile.delete();
            }
            tempZipFile.renameTo(zipfile);
            try {
                ZipFile z = new ZipFile(zipfile);
                Enumeration<? extends ZipEntry> entries = z.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (filetype != 2 && !entry.getName().startsWith(zipbasepath) || entry.isDirectory()) continue;
                    File entryfile = new File(basepath, entry.getName());
                    FileServer.mkdir(entryfile.getParentFile());
                    if (isWindows) {
                        entryfile.delete();
                    }
                    FileOutputStream fos = new FileOutputStream(entryfile);
                    InputStream zin = z.getInputStream(entry);
                    while ((len = zin.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    zin.close();
                    entryfile.setWritable(true, false);
                    FileServer.setParentModified(entryfile);
                }
                z.close();
            }
            finally {
                zipfile.delete();
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    static String modified(String[] path, long[] timestamp) {
        boolean enough = false;
        StringBuffer sb = new StringBuffer();
        try {
            long[] ts = new long[path.length];
            int s = 0;
            while (s < 10) {
                int i2 = 0;
                while (i2 < path.length) {
                    if (path[i2].equals("runts")) {
                        ts[i2] = SystemState.runTimeStampGet();
                    } else if (path[i2].equals("startts")) {
                        ts[i2] = SystemState.startTimeStampGet();
                    } else {
                        File f2 = new File(path[i2]);
                        if (s == 0) {
                            FileServer.pathSanityCheck(f2, false);
                        }
                        ts[i2] = f2.lastModified();
                    }
                    if (timestamp[i2] != ts[i2]) {
                        enough = true;
                    }
                    ++i2;
                }
                if (enough) break;
                Thread.sleep(1000L);
                ++s;
            }
            sb.append(ts[0]);
            int i3 = 1;
            while (i3 < ts.length) {
                sb.append(',');
                sb.append(ts[i3]);
                ++i3;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    static boolean rename(String from, String to) {
        try {
            File ffrom = new File(from);
            File fto = new File(to);
            FileServer.pathSanityCheck(ffrom, true);
            FileServer.pathSanityCheck(fto, true);
            return ffrom.renameTo(fto);
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int move(String[] from, String to, boolean overwrite) {
        int n2 = 0;
        try {
            File[] ffrom = new File[from.length];
            File[] fdest = new File[from.length];
            File fto = new File(to);
            FileServer.pathSanityCheck(fto, false);
            if (!fto.isDirectory() || !fto.canWrite()) {
                return 0;
            }
            int i2 = 0;
            while (i2 < ffrom.length) {
                ffrom[i2] = new File(from[i2]).getCanonicalFile();
                FileServer.pathSanityCheck(ffrom[i2], false);
                fdest[i2] = new File(fto, ffrom[i2].getName()).getCanonicalFile();
                FileServer.pathSanityCheck(fdest[i2], false);
                if (ffrom[i2].equals(fdest[i2])) {
                    return -2;
                }
                if (fdest[i2].exists()) {
                    if (!overwrite) {
                        return -1;
                    }
                    FileServer.delete(fdest[i2].getCanonicalPath(), true);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < ffrom.length) {
                try {
                    if (ffrom[i2].renameTo(fdest[i2])) {
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i2;
            }
            return n2;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int copy(String[] from, String to, boolean overwrite) {
        int n2 = 0;
        long size = 0L;
        try {
            File[] ffrom = new File[from.length];
            File[] fdest = new File[from.length];
            File fto = new File(to);
            FileServer.pathSanityCheck(fto, false);
            if (!fto.isDirectory() || !fto.canWrite()) {
                return 0;
            }
            int i2 = 0;
            while (i2 < ffrom.length) {
                ffrom[i2] = new File(from[i2]).getCanonicalFile();
                FileServer.pathSanityCheck(ffrom[i2], false);
                fdest[i2] = new File(fto, ffrom[i2].getName()).getCanonicalFile();
                FileServer.pathSanityCheck(fdest[i2], false);
                if (ffrom[i2].equals(fdest[i2])) {
                    return -2;
                }
                if (!overwrite && fdest[i2].exists()) {
                    return -1;
                }
                long r = FileServer.recursiveFileSize(ffrom[i2].getPath(), 100000000L - size);
                if (r < 0L || (size += r) > 100000000L) {
                    return -3;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < ffrom.length) {
                n2 += FileServer.copy(ffrom[i2], fdest[i2]);
                ++i2;
            }
            return n2;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static int copy(File from, File to) throws Exception {
        int n2 = 1;
        try {
            if (!from.isHidden()) {
                if (from.isDirectory()) {
                    if (to.getCanonicalPath().startsWith(String.valueOf(from.getCanonicalPath()) + File.separator)) {
                        return 0;
                    }
                    if (!to.isDirectory()) {
                        FileServer.mkdir(to);
                    }
                    File[] fa = from.listFiles();
                    int i2 = 0;
                    while (i2 < fa.length) {
                        n2 += FileServer.copy(fa[i2], new File(to, fa[i2].getName()));
                        ++i2;
                    }
                    return n2;
                }
                if (from.isFile()) {
                    if (isWindows) {
                        to.delete();
                    }
                    FileInputStream ins = new FileInputStream(from);
                    FileOutputStream outs = new FileOutputStream(to);
                    FileChannel in = ins.getChannel();
                    FileChannel out = outs.getChannel();
                    in.transferTo(0L, in.size(), out);
                    ins.close();
                    outs.close();
                    to.setWritable(true, false);
                }
                return n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    static int duplicate(String from, String to) {
        File fto;
        File ffrom;
        block7: {
            block6: {
                try {
                    ffrom = new File(from);
                    fto = new File(to);
                    FileServer.pathSanityCheck(ffrom, false);
                    FileServer.pathSanityCheck(fto, false);
                    if (!fto.exists()) break block6;
                    return -1;
                }
                catch (Exception e2) {
                    return 0;
                }
            }
            if (!ffrom.isDirectory()) break block7;
            if (FileServer.recursiveFileSize(from, 100000000L) >= 0L) {
                return FileServer.copy(ffrom, fto);
            }
            return -3;
        }
        if (ffrom.isFile()) {
            return FileServer.copy(ffrom, fto);
        }
        return 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static long recursiveFileSize(String pathname, long limit) {
        try {
            File f2 = new File(pathname);
            if (f2.isDirectory()) {
                long size = 0L;
                File[] fa = f2.listFiles();
                int i2 = 0;
                while (i2 < fa.length) {
                    long r = FileServer.recursiveFileSize(fa[i2].getPath(), limit - size);
                    if (r < 0L) {
                        return r;
                    }
                    if ((size += r) > limit) {
                        return -2L;
                    }
                    ++i2;
                }
                return size;
            }
            if (f2.isFile()) {
                return f2.length();
            }
            return 0L;
        }
        catch (Exception e2) {
            return -1L;
        }
    }

    private static void pathSanityCheck(File f2, boolean rootExclusion) throws Exception {
        String r;
        String p;
        File root = new File(".");
        if (hsyco.JAVA_VERSION <= 6) {
            p = f2.getCanonicalPath();
            r = root.getCanonicalPath();
        } else {
            p = f2.toPath().toAbsolutePath().normalize().toString();
            r = root.toPath().toAbsolutePath().normalize().toString();
        }
        if (!p.startsWith(r)) {
            throw new SecurityException("FileServer - pathSanityCheck Violation");
        }
        if (rootExclusion && p.equals(r)) {
            throw new SecurityException("FileServer - pathSanityCheck Root Violation");
        }
    }

    private static void setParentModified(File f2) {
        try {
            f2.getAbsoluteFile().getParentFile().setLastModified(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void mkdir(File f2) {
        try {
            if (f2 != null) {
                FileServer.mkdir(f2.getParentFile());
                if (f2.mkdir()) {
                    f2.setWritable(true, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fileEvents(String path) {
        if (path.endsWith(".txt") && path.contains("events")) {
            events.eventsFileCheckLoad();
        }
    }
}

