/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HTTPServer;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DummyIO {
    public static final String[] WebObjects = new String[]{"3button", "button", "buttonicon", "buttonimage", "dimmer"};
    private static final int LIGHT = 1;
    private static final int AUTOM = 2;
    private static final int DIMMER = 11;
    private String serverName;
    int ioIndex;
    boolean isMonitorThread;
    private ArrayBlockingQueue<String> ioqtx = null;
    private boolean discovery = true;
    private boolean cmdstate = false;
    private boolean persistent = false;
    private int lights = 0;
    private int dimmers = 0;
    private int automations = 0;
    private int httpcalltimeoutmillis = 0;
    private long httpcalltimestampmillis = 0L;
    private Boolean httpcallonline = null;
    private Hashtable<String, Integer> dimmerStates = new Hashtable();
    private Hashtable<String, Long> automTimestamp = new Hashtable();
    private HashSet<String> persistentDataPointExists = new HashSet();
    private Connection hsycoDatabaseConnection = null;
    private PreparedStatement persistentInsertStatement = null;
    private PreparedStatement persistentUpdateStatement = null;
    private boolean dbErrorFlag = false;

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        me.dispatcher = false;
        SystemState.ioServersSocket[ioIndex] = null;
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            try {
                int n2;
                String value;
                String[] sb = sa[i2].split("=");
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equals("discovery")) {
                    this.discovery = value.equals("true");
                } else if (param.equals("commandstate")) {
                    this.cmdstate = value.equals("true");
                } else if (param.equals("persistent")) {
                    this.persistent = value.equals("true");
                } else if (param.equalsIgnoreCase("lights")) {
                    n2 = Integer.parseInt(value);
                    if (n2 >= 0 && n2 < 10000) {
                        this.lights = n2;
                    }
                } else if (param.equalsIgnoreCase("dimmers")) {
                    n2 = Integer.parseInt(value);
                    if (n2 >= 0 && n2 < 10000) {
                        this.dimmers = n2;
                    }
                } else if (param.equalsIgnoreCase("automations")) {
                    n2 = Integer.parseInt(value);
                    if (n2 >= 0 && n2 < 10000) {
                        this.automations = n2;
                    }
                } else if (param.equalsIgnoreCase("httpcallpassword")) {
                    HTTPServer.registerDummyHook(this.serverName, sb[1].trim());
                } else if (param.equalsIgnoreCase("httpcalltimeoutseconds") && (n2 = Integer.parseInt(value)) > 0) {
                    this.httpcalltimeoutmillis = n2 * 1000;
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
            }
            ++i2;
        }
        if (this.persistent) {
            try {
                this.hsycoDatabaseConnection = SystemState.getHsycoDBConnection();
                Statement stmt = this.hsycoDatabaseConnection.createStatement();
                try {
                    stmt.execute("create cached table dummyiostate (drivername varchar(1024), name varchar(1024), value varchar(65536))");
                    stmt.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    stmt.execute("create unique index dummyiostate_key on dummyiostate (drivername, name)");
                    stmt.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.persistentInsertStatement = this.hsycoDatabaseConnection.prepareStatement("insert into dummyiostate (drivername, name, value) values (?, ?, ?)");
                this.persistentUpdateStatement = this.hsycoDatabaseConnection.prepareStatement("update dummyiostate set value=? where drivername=? and name=?");
                this.ioWritePersistentFromStorage();
            }
            catch (Exception e3) {
                this.dbErrorFlag = true;
                hsyco.errorLog("ioMonitor - Exception while enabling persistent storage [" + this.serverName + "] - " + e3.getLocalizedMessage());
            }
        }
        if (this.discovery) {
            Configuration.systemtopoDiscovery = true;
            int i3 = 1;
            while (i3 <= this.lights) {
                String fullname = String.valueOf(this.serverName) + ".light." + i3;
                this.ioWritePersistent(fullname, "0", false, true, "DUMMY");
                ++i3;
            }
            i3 = 1;
            while (i3 <= this.dimmers) {
                String fullname = String.valueOf(this.serverName) + ".dimmer." + i3;
                this.ioWritePersistent(fullname, "off", false, true, "DUMMY");
                ++i3;
            }
            i3 = 1;
            while (i3 <= this.automations) {
                String fullname = String.valueOf(this.serverName) + ".autom." + i3;
                this.ioWritePersistent(fullname, "unknown", false, true, "DUMMY");
                ++i3;
            }
        }
        PluginsWrapper.register(this.serverName, 23, this);
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e4) {
            hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e4);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.httpcalltimeoutmillis == 0) {
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
        }
        SystemState.ioServersInitializedSet(ioIndex, true);
        me.dispatcher = true;
        me.heartbeat = this.httpcalltimestampmillis = System.currentTimeMillis();
        while (!me.quit && !this.dbErrorFlag) {
            try {
                block76: {
                    String item = this.ioqtx.poll(1L, TimeUnit.SECONDS);
                    me.heartbeat = System.currentTimeMillis();
                    if (this.httpcalltimeoutmillis != 0 && me.heartbeat - this.httpcalltimestampmillis > (long)this.httpcalltimeoutmillis && (this.httpcallonline == null || this.httpcallonline.booleanValue())) {
                        this.httpcallonline = false;
                        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
                    }
                    if (item != null) {
                        this.httpcalltimestampmillis = me.heartbeat;
                        int equalidx = item.indexOf(61);
                        String name = item.substring(0, equalidx);
                        String fullname = String.valueOf(this.serverName) + "." + name;
                        String value = item.substring(equalidx + 1).toLowerCase();
                        if (this.cmdstate) {
                            if (name.toLowerCase().endsWith(".state")) {
                                name = name.substring(0, name.length() - 6);
                                fullname = String.valueOf(this.serverName) + "." + name;
                            } else {
                                if (name.toLowerCase().endsWith(".cmd")) continue;
                                SystemState.ioWriteForced(String.valueOf(fullname) + ".cmd", value);
                                continue;
                            }
                        }
                        if (name.startsWith("dimmer")) {
                            if (value.equals("off")) {
                                this.ioWritePersistent(fullname, "0", true, false, null);
                            } else if (value.equals("on") || value.equals("1")) {
                                Integer level = this.dimmerStates.get(name);
                                if (level == null || level == 0) {
                                    this.ioWritePersistent(fullname, "100%", true, false, null);
                                } else {
                                    this.ioWritePersistent(fullname, level + "%", true, false, null);
                                }
                            } else {
                                try {
                                    int level = Integer.parseInt(value.endsWith("%") ? value.substring(0, value.length() - 1) : value);
                                    if (level == 0) {
                                        this.ioWritePersistent(fullname, "0", true, false, null);
                                        break block76;
                                    }
                                    this.dimmerStates.put(name, level);
                                    this.ioWritePersistent(fullname, String.valueOf(level) + "%", true, false, null);
                                }
                                catch (Exception level) {}
                            }
                        } else if (name.startsWith("autom")) {
                            if (value.equals("stop") || value.equals("off")) {
                                String state = SystemState.ioGet(fullname);
                                if ("up".equals(state)) {
                                    this.ioWritePersistent(fullname, "offup", true, false, null);
                                    this.automTimestamp.remove(name);
                                } else if ("down".equals(state)) {
                                    this.ioWritePersistent(fullname, "offdown", true, false, null);
                                    this.automTimestamp.remove(name);
                                }
                            } else {
                                this.ioWritePersistent(fullname, value, true, false, null);
                                this.automTimestamp.put(name, System.currentTimeMillis() + 30000L);
                            }
                        } else if (name.equals("__httpcall__") && value.equals("heartbeat")) {
                            if (this.httpcalltimeoutmillis != 0) {
                                if (this.httpcallonline == null || !this.httpcallonline.booleanValue()) {
                                    this.httpcallonline = true;
                                    SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
                                }
                                this.httpcalltimestampmillis = me.heartbeat;
                            }
                        } else if (value.equals("off")) {
                            this.ioWritePersistent(fullname, "0", true, false, null);
                        } else if (value.equals("on")) {
                            this.ioWritePersistent(fullname, "1", true, false, null);
                        } else {
                            this.ioWritePersistent(fullname, value, true, false, null);
                        }
                    }
                }
                Enumeration<String> e5 = this.automTimestamp.keys();
                while (e5.hasMoreElements()) {
                    String key = e5.nextElement().toString();
                    if (me.heartbeat <= this.automTimestamp.get(key)) continue;
                    SystemState.ioSet(String.valueOf(this.serverName) + "." + key, "stop");
                    this.automTimestamp.remove(key);
                }
            }
            catch (Exception e6) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e6.getLocalizedMessage());
                me.quit = true;
            }
        }
        try {
            this.persistentInsertStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.persistentUpdateStatement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    public String keypad(String id) {
        String key = id.toLowerCase();
        try {
            String[] sa = key.split("[.]+");
            if (sa[0].equals("temp")) {
                if (sa[1].equals("command")) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".temp.command", key.substring(13));
                } else if (sa[2].equals("setpoint")) {
                    if (sa[3].equals("temp")) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", sa[4]);
                    } else if (sa[3].equals("mode")) {
                        String mode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint.mode");
                        String cumode = SystemState.ioGet(String.valueOf(this.serverName) + ".temp.setpoint.mode");
                        if (mode.equals("man")) {
                            if (cumode.equals("man")) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "protection");
                            } else {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "auto");
                            }
                        } else if (mode.equals("auto")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "protection");
                        } else if (mode.equals("protection")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "off");
                        } else if (mode.equals("off")) {
                            if (cumode.equals("off") || cumode.equals("protection")) {
                                int temp = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".temp")) / 5 * 5;
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", Integer.toString(temp));
                            } else {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".temp." + sa[1] + ".setpoint", "auto");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private void ioWritePersistent(String name, String value, boolean events2, boolean insertOnly, String comment) {
        block14: {
            boolean updated = false;
            try {
                if (this.persistent) {
                    if (this.persistentDataPointExists.contains(name)) {
                        if (!insertOnly) {
                            this.persistentUpdateStatement.setString(1, value);
                            this.persistentUpdateStatement.setString(2, this.serverName);
                            this.persistentUpdateStatement.setString(3, name);
                            this.persistentUpdateStatement.execute();
                            updated = true;
                        }
                    } else {
                        this.persistentDataPointExists.add(name);
                        this.persistentInsertStatement.setString(1, this.serverName);
                        this.persistentInsertStatement.setString(2, name);
                        this.persistentInsertStatement.setString(3, value);
                        this.persistentInsertStatement.execute();
                        updated = true;
                    }
                } else {
                    updated = true;
                }
                if (updated) {
                    if (events2) {
                        SystemState.ioWrite(name, value);
                    } else {
                        SystemState.ioWriteNoEvents(name, value);
                    }
                    if (name.startsWith(String.valueOf(this.serverName) + ".dimmer.")) {
                        SystemState.deviceSet(false, 11, name, value, comment);
                    } else if (name.startsWith(String.valueOf(this.serverName) + ".autom.")) {
                        SystemState.deviceSet(false, 2, name, value, comment);
                    } else {
                        SystemState.deviceSet(false, 1, name, value, comment);
                    }
                }
            }
            catch (SQLException e2) {
                if (this.dbErrorFlag) break block14;
                this.dbErrorFlag = true;
                hsyco.errorLog("ioMonitor - Exception writing to persistent storage [" + this.serverName + "] - " + e2.getLocalizedMessage());
            }
        }
    }

    private void ioWritePersistentFromStorage() {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = this.hsycoDatabaseConnection.prepareStatement("select name, value from dummyiostate where drivername = ?");
                pstmt.setString(1, this.serverName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    String value = rs.getString(2);
                    this.persistentDataPointExists.add(name);
                    SystemState.ioWrite(name, value);
                    if (name.startsWith(String.valueOf(this.serverName) + ".dimmer.")) {
                        SystemState.deviceSet(false, 11, name, value, this.discovery ? "DIMMER" : null);
                        continue;
                    }
                    if (name.startsWith(String.valueOf(this.serverName) + ".autom.")) {
                        SystemState.deviceSet(false, 2, name, value, this.discovery ? "AUTOM" : null);
                        continue;
                    }
                    SystemState.deviceSet(false, 1, name, value, this.discovery ? "LIGHT" : null);
                }
            }
            catch (SQLException e2) {
                if (!this.dbErrorFlag) {
                    this.dbErrorFlag = true;
                    hsyco.errorLog("ioMonitor - Exception reading from persistent storage [" + this.serverName + "] - " + e2.getLocalizedMessage());
                }
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
            }
            catch (Exception exception) {}
        }
    }
}

