/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HTTPServer;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;

class Domino {
    public static final String[] WebObjects = new String[]{"3button", "button", "buttonicon", "buttonimage", "dimmer", "temp", "tempmini"};
    private static final int UNDEF = -1;
    private static final int LIGHT = 1;
    private static final int AUTOM = 2;
    private static final int DIMMER = 11;
    private String commPort;
    private String commPortMain;
    private String commPortFailover;
    private boolean commFailoverActive = false;
    private String serverName;
    private int language = Configuration.language <= 2 ? Configuration.language : 0;
    private int gatewayID = -1;
    private Hashtable<String, String> states = new Hashtable();
    private Hashtable<Integer, Device> inputDevices = new Hashtable();
    private Hashtable<Integer, Device> outputDevices = new Hashtable();
    private boolean[] emDevices = new boolean[3];
    private Hashtable<Integer, int[]> emDevicesParams = new Hashtable();
    private Hashtable<Integer, Integer[][]> emDevicesPartialData = new Hashtable();
    private BitSet dftpPositionEnabled = new BitSet(256);
    private BitSet dftz2FanEnabled = new BitSet(256);
    private Hashtable<Integer, Integer> dfdali64GroupAddress = new Hashtable();
    private HashSet<Integer> dfdali64Group = new HashSet();
    private Vector<MemoryRange> inputRanges = new Vector();
    private Vector<MemoryRange> outputRanges = new Vector();
    private MemoryRange energyRange = null;
    private MemoryRange virtualData = null;
    private MemoryRange[] registersData = null;
    private MemoryRange[] countersData = null;
    private MemoryRange inputModulesFaultData = null;
    private MemoryRange outputModulesFaultData = null;
    private int powerDisplayAddress = -1;
    private int powerPollingInterval = 1000;
    private int powerSensivity = 50;
    private int powerValue = -2147483647;
    ArrayBlockingQueue<String> ioqtx = null;
    private boolean startupevents = false;
    private boolean inputdiscovery = false;
    private boolean virtualdiscovery = false;
    private boolean outputdiscovery = true;
    private boolean detectevents = false;
    private int gwvirtuals = -1;
    private int gwregisters = -1;
    private int gwcounters = -1;
    private long writeRawMessageTimeMillis = 0L;
    private long commandErrorLogTimeMillis = 0L;
    private long commandErrorLogCounter = 0L;
    private long toolsCommand = 0L;
    private boolean bootMode = false;
    private boolean synchronousEvents;
    private long modulesFaultNextPollingTimestampMillis = 0L;
    private long faultNextPollingTimestampMillis = 0L;
    private int busFault = -1;
    private int moduleFault = -1;
    private static final String[][] TEXT = new String[][]{{"ON", "OFF", "SUMMER", "WINTER", "AUTO", "MAN", "FAULT", "MIN", "MED", "MAX", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN", "COM", "ECO"}, {"ON", "OFF", "ESTATE", "INVERNO", "AUTO", "MAN", "GUASTO", "MIN", "MED", "MAX", "LUN", "MAR", "MER", "GIO", "VEN", "SAB", "DOM", "COM", "ECO"}, {"ON", "OFF", "&Eacute;T&Eacute;", "HIVER", "AUTO", "MAN", "FAUTE", "MIN", "MED", "MAX", "LUN", "MAR", "MER", "JEU", "VEN", "SAM", "DIM", "COM", "ECO"}};

    Domino() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void monitor(int ioIndex, ioMonitor me) {
        int ranges;
        long energytime = 0L;
        String errorlabel = null;
        boolean pflagin = true;
        boolean pflagout = true;
        boolean pflagvirt = true;
        boolean pflagreg = true;
        boolean pflagcnt = true;
        boolean pflagene = true;
        boolean pflagfault = true;
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        me.dispatcher = false;
        String[] sap = Configuration.ioServersComm.elementAt(ioIndex).trim().split("[ ,;]+");
        this.commPort = this.commPortMain = sap[0];
        this.commPortFailover = sap.length == 2 ? sap[1] : null;
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            block76: {
                errorlabel = null;
                try {
                    String value;
                    String[] sb = sa[i2].split("=");
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim();
                    if (param.equals("startupevents")) {
                        this.startupevents = value.equalsIgnoreCase("true");
                        break block76;
                    }
                    if (param.equals("detectevents")) {
                        this.detectevents = value.equalsIgnoreCase("true");
                        break block76;
                    }
                    if (param.equals("toolspassword")) {
                        HTTPServer.registerDominoHook(String.valueOf(this.serverName) + ":" + value, this);
                        break block76;
                    }
                    if (param.equals("inputdiscovery")) {
                        this.inputdiscovery = value.equalsIgnoreCase("true");
                        break block76;
                    }
                    if (param.equals("virtualdiscovery")) {
                        this.virtualdiscovery = value.equalsIgnoreCase("true");
                        break block76;
                    }
                    if (param.equals("outputdiscovery")) {
                        this.outputdiscovery = value.equalsIgnoreCase("true");
                        break block76;
                    }
                    if (param.equals("virtualpoints")) {
                        try {
                            int v = Integer.parseInt(value);
                            if (v > 0 && v <= 2032) {
                                this.gwvirtuals = v;
                                break block76;
                            }
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        catch (Exception e2) {
                            this.gwvirtuals = value.equalsIgnoreCase("true") ? 2032 : -1;
                        }
                        break block76;
                    }
                    if (param.equals("registers")) {
                        try {
                            int r = Integer.parseInt(value);
                            if (r >= 0 && r <= 1023) {
                                this.gwregisters = r;
                                break block76;
                            }
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        catch (Exception e3) {
                            this.gwregisters = value.equalsIgnoreCase("true") ? 127 : -1;
                        }
                        break block76;
                    }
                    if (param.equals("counters")) {
                        try {
                            int c2 = Integer.parseInt(value);
                            if (c2 >= 0 && c2 <= 1023) {
                                this.gwcounters = c2;
                                break block76;
                            }
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        catch (Exception e4) {
                            this.gwcounters = value.equalsIgnoreCase("true") ? 127 : -1;
                        }
                        break block76;
                    }
                    if (param.equals("powerdisplay")) {
                        errorlabel = param;
                        this.powerDisplayAddress = value.equalsIgnoreCase("false") ? -1 : (value.equalsIgnoreCase("true") ? 0 : Integer.parseInt(value));
                    } else if (param.equals("powersensivity")) {
                        errorlabel = param;
                        int v = Integer.parseInt(value);
                        if (v <= 0) throw new Exception();
                        this.powerSensivity = v;
                    } else if (param.equals("powerinterval")) {
                        errorlabel = param;
                        int v = Integer.parseInt(value);
                        if (v <= 0) throw new Exception();
                        this.powerPollingInterval = v * 1000;
                    } else if (param.equals("language")) {
                        if (value.equalsIgnoreCase("en")) {
                            this.language = 0;
                        } else if (value.equalsIgnoreCase("it")) {
                            this.language = 1;
                        } else if (value.equalsIgnoreCase("fr")) {
                            this.language = 2;
                        }
                    }
                }
                catch (Exception e5) {
                    if (errorlabel == null) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                    }
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + errorlabel + " ignored");
                }
            }
            ++i2;
        }
        if (this.inputdiscovery || this.virtualdiscovery || this.outputdiscovery) {
            Configuration.systemtopoDiscovery = true;
        }
        if (this.gwvirtuals != -1) {
            this.virtualData = new MemoryRange(2306, 254);
        }
        if (this.gwregisters != -1) {
            ranges = this.gwregisters / 128;
            this.registersData = new MemoryRange[ranges + 1];
            int r = 0;
            while (r <= ranges) {
                this.registersData[r] = new MemoryRange(4096 + r * 256, 256);
                ++r;
            }
        }
        if (this.gwcounters != -1) {
            ranges = this.gwcounters / 128;
            this.countersData = new MemoryRange[ranges + 1];
            int r = 0;
            while (r <= ranges) {
                this.countersData[r] = new MemoryRange(6144 + r * 256, 256);
                ++r;
            }
        }
        this.synchronousEvents = true;
        if (this.isInBootMode()) {
            this.bootMode = true;
            this.toolsCommand = System.currentTimeMillis() + 300000L;
            hsyco.messageLog("ioMonitor - starting in boot mode [" + this.serverName + "]");
        } else if (!this.modulesDiscovery()) {
            hsyco.messageLog("ioMonitor - failed to initialize [" + this.serverName + "]");
            me.quit = true;
        } else if (this.inputPolling(this.startupevents) && this.outputPolling(this.startupevents) && this.modulesFaultPolling(this.startupevents) && this.faultPolling(this.startupevents) && (this.gwvirtuals == -1 || this.virtualPointsPolling(this.startupevents)) && (this.gwregisters == -1 || this.registersPolling(this.startupevents)) && (this.gwcounters == -1 || this.countersPolling(this.startupevents))) {
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
            SystemState.ioServersInitializedSet(ioIndex, true);
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e6) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e6);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        } else {
            me.quit = true;
        }
        PluginsWrapper.register(this.serverName, 8, this);
        this.synchronousEvents = false;
        while (!me.quit && this.toolsCommand != -1L) {
            try {
                long t = System.currentTimeMillis();
                if (this.writeRawMessageTimeMillis + 1000L > t) {
                    Thread.sleep(600L);
                } else if (t < me.heartbeat + 20L) {
                    Thread.sleep(100L);
                }
                if (this.toolsCommand > t) {
                    me.heartbeat = t;
                    Thread.sleep(1000L);
                    continue;
                }
                if (this.bootMode) {
                    hsyco.messageLog("ioMonitor - leaving boot mode and restarting [" + this.serverName + "]");
                    me.quit = true;
                    continue;
                }
                if (this.gatewayID == 1 && !SystemState.haActiveStateGet()) {
                    if (this.faultNextPollingTimestampMillis < t && this.faultPolling(true)) {
                        this.faultNextPollingTimestampMillis = t + 10000L;
                    }
                    me.heartbeat = t;
                    Thread.sleep(1000L);
                    continue;
                }
                this.commandPolling();
                if (this.inputRanges.size() > 0 && (pflagin = this.inputPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.outputRanges.size() > 0 && (pflagout = this.outputPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.gwvirtuals != -1 && (pflagvirt = this.virtualPointsPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.gwregisters != -1 && (pflagreg = this.registersPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.gwcounters != -1 && (pflagcnt = this.countersPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.modulesFaultNextPollingTimestampMillis < t && (pflagfault = this.modulesFaultPolling(true))) {
                    this.modulesFaultNextPollingTimestampMillis = t + 10000L;
                }
                if (this.faultNextPollingTimestampMillis < t && this.faultPolling(true)) {
                    this.faultNextPollingTimestampMillis = t + 10000L;
                }
                if (this.energyRange != null && t > energytime + (long)this.powerPollingInterval) {
                    energytime = t;
                    pflagene = this.energyPolling();
                    if (pflagene) {
                        me.heartbeat = t;
                    }
                }
                if (!Configuration.verboseLog || pflagin && pflagout && pflagvirt && pflagreg && pflagcnt && pflagene && pflagfault) continue;
                StringBuffer sb = new StringBuffer("ioMonitor - Error in thread loop [" + this.serverName + "] -");
                if (!pflagin) {
                    sb.append(" INPUT");
                }
                if (!pflagout) {
                    sb.append(" OUTPUT");
                }
                if (!pflagvirt) {
                    sb.append(" VIRTUAL");
                }
                if (!pflagreg) {
                    sb.append(" REGISTERS");
                }
                if (!pflagcnt) {
                    sb.append(" COUNTERS");
                }
                if (!pflagene) {
                    sb.append(" ENERGY");
                }
                if (!pflagfault) {
                    sb.append(" FAULT");
                }
                hsyco.errorLog(sb.toString());
            }
            catch (Exception e7) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e7.getMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    private synchronized void writeOutput(int address, int mask, int state) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 121;
        byArray[2] = 6;
        byArray[4] = 1;
        byte[] command = byArray;
        command[3] = (byte)(address & 0xFF);
        command[5] = (byte)((state & 0xFF00) >>> 8);
        command[6] = (byte)(state & 0xFF);
        command[7] = (byte)((mask & 0xFF00) >>> 8);
        command[8] = (byte)(mask & 0xFF);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(121);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        this.logWriteError(command);
        throw new IOException();
    }

    private synchronized void writeVirtual(int address, boolean state) throws Exception {
        byte[] byArray = new byte[8];
        byArray[1] = 120;
        byArray[2] = 3;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF00) >>> 8);
        command[4] = (byte)(address & 0xFF);
        command[5] = (byte)(state ? 1 : 0);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(120);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        this.logWriteError(command);
        throw new IOException();
    }

    private synchronized void writeRegister(int register, int value) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 126;
        byArray[2] = 6;
        byArray[6] = 2;
        byte[] command = byArray;
        if (register <= this.gwregisters) {
            int address = this.registersData[0].from + 2 * register;
            command[4] = (byte)((address & 0xFF00) >>> 8);
            command[5] = (byte)(address & 0xFF);
            command[7] = (byte)((value & 0xFF00) >>> 8);
            command[8] = (byte)(value & 0xFF);
            Domino.cksfiller(command);
            int i2 = 0;
            while (i2 < 6) {
                if (util.writeCommBytes(this.commPort, command) == command.length) {
                    byte[] data = this.read(126);
                    if (data != null && data.length == 1 && data[0] == -1) {
                        return;
                    }
                    this.closeComm();
                }
                if (i2 == 3) {
                    this.failoverSwitch();
                }
                ++i2;
            }
            this.logWriteError(command);
            throw new IOException();
        }
    }

    private synchronized void writeCounter(int register, int value) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 126;
        byArray[2] = 6;
        byArray[6] = 2;
        byte[] command = byArray;
        if (register <= this.gwcounters) {
            int address = this.countersData[0].from + 2 * register;
            command[4] = (byte)((address & 0xFF00) >>> 8);
            command[5] = (byte)(address & 0xFF);
            command[7] = (byte)((value & 0xFF00) >>> 8);
            command[8] = (byte)(value & 0xFF);
            Domino.cksfiller(command);
            int i2 = 0;
            while (i2 < 6) {
                if (util.writeCommBytes(this.commPort, command) == command.length) {
                    byte[] data = this.read(126);
                    if (data != null && data.length == 1 && data[0] == -1) {
                        return;
                    }
                    this.closeComm();
                }
                if (i2 == 3) {
                    this.failoverSwitch();
                }
                ++i2;
            }
            this.logWriteError(command);
            throw new IOException();
        }
    }

    private boolean isInBootMode() {
        byte[] data = this.readId();
        return data != null && data.length == 68 && data[0] == 0 && data[1] == 0;
    }

    private synchronized byte[] readId() {
        byte[] byArray = new byte[7];
        byArray[1] = 112;
        byArray[2] = 2;
        byArray[3] = 73;
        byArray[4] = 68;
        byte[] command = byArray;
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(112);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readAuxId() {
        byte[] byArray = new byte[7];
        byArray[1] = 115;
        byArray[2] = 2;
        byArray[3] = 73;
        byArray[4] = 68;
        byte[] command = byArray;
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(115);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readRAM(int address, int len) {
        byte[] byArray = new byte[9];
        byArray[1] = 127;
        byArray[2] = 4;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)(len & 0xFF);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(127);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readIRAM(int address, int len) {
        byte[] byArray = new byte[9];
        byArray[1] = 125;
        byArray[2] = 4;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)(len & 0xFF);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(125);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readModuleRAM(int device, int address) {
        byte[] byArray = new byte[9];
        byArray[1] = 93;
        byArray[2] = 4;
        byArray[3] = 94;
        byte[] command = byArray;
        command[4] = (byte)(device & 0xFF);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)((address & 0xFF00) >>> 8);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(93);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readModuleEEPROM(int device, int address, boolean input) {
        byte[] byArray = new byte[9];
        byArray[1] = 93;
        byArray[2] = 4;
        byArray[3] = input ? 96 : 97;
        byArray[6] = 51;
        byte[] command = byArray;
        command[4] = (byte)(device & 0xFF);
        command[5] = (byte)(address & 0xFF);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(93);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] writeModuleEEPROM(int device, int address, byte value) {
        byte[] byArray = new byte[9];
        byArray[1] = 93;
        byArray[2] = 4;
        byArray[3] = 102;
        byArray[6] = value;
        byte[] command = byArray;
        boolean iofail = true;
        command[4] = (byte)(device & 0xFF);
        command[5] = (byte)(address & 0xFF);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(93);
                if (data != null) {
                    if (data[0] != 0) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return data;
                    }
                    iofail = false;
                } else {
                    this.closeComm();
                }
            }
            if (i2 == 3 && iofail) {
                this.failoverSwitch();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.logWriteError(command);
        return null;
    }

    private synchronized byte[] readModuleEEPROM2(int device, int address) {
        byte[] byArray = new byte[9];
        byArray[1] = 93;
        byArray[2] = 4;
        byArray[3] = 70;
        byte[] command = byArray;
        command[4] = (byte)(device & 0xFF);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)(address >> 8 & 0xFF);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(93);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] writeModuleEEPROM2(int device, int address, byte value) {
        byte[] byArray = new byte[9];
        byArray[1] = 93;
        byArray[2] = 4;
        byArray[3] = 70;
        byte[] rcommand = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[1] = 93;
        byArray2[2] = 4;
        byArray2[3] = 71;
        byArray2[6] = value;
        byte[] wcommand = byArray2;
        boolean iofail = true;
        rcommand[4] = wcommand[4] = (byte)(device & 0xFF);
        rcommand[5] = wcommand[5] = (byte)(address & 0xFF);
        rcommand[6] = (byte)(address >> 8 & 0xFF);
        Domino.cksfiller(rcommand);
        Domino.cksfiller(wcommand);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, rcommand) == rcommand.length) {
                byte[] data = this.read(93);
                if (data != null) {
                    if (util.writeCommBytes(this.commPort, wcommand) == wcommand.length && (data = this.read(93)) != null) {
                        if (data[0] != 0) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return data;
                        }
                        iofail = false;
                    }
                } else {
                    this.closeComm();
                }
            }
            if (i2 == 3 && iofail) {
                this.failoverSwitch();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.logWriteError(wcommand);
        return null;
    }

    byte[] writeRawMessage(byte[] command) {
        if (command != null && command.length == 6 && command[1] == 64 && command[2] == 1) {
            byte[] response = new byte[6];
            response[0] = command[0];
            response[1] = 64;
            response[2] = 1;
            switch (command[3]) {
                case 1: {
                    this.toolsCommand = System.currentTimeMillis() + 300000L;
                    response[3] = -1;
                    break;
                }
                case 2: {
                    this.toolsCommand = 0L;
                    response[3] = -1;
                    break;
                }
                case 3: {
                    this.toolsCommand = -1L;
                    response[3] = -1;
                    break;
                }
                default: {
                    response[3] = 0;
                }
            }
            Domino.cksfiller(response);
            if (Configuration.verboseLog) {
                hsyco.messageLog("ioMonitor - Raw FXP-XT traffic: " + util.decodeHex(command) + " > " + (response == null ? "NULL" : util.decodeHex(response)) + " [" + this.serverName + "]");
            }
            return response;
        }
        if (command.length == 9 && command[1] == 107 && command[2] == 4) {
            this.writeRawMessageTimeMillis = System.currentTimeMillis();
            return this.writeRawMessageSynchronized(command, true);
        }
        this.writeRawMessageTimeMillis = System.currentTimeMillis();
        return this.writeRawMessageSynchronized(command, false);
    }

    private synchronized byte[] writeRawMessageSynchronized(byte[] command, boolean longtimeout) {
        block6: {
            try {
                util.readCommBytes(this.commPort, 0);
                long t = System.currentTimeMillis();
                if (util.writeCommBytes(this.commPort, command) == command.length) {
                    byte[] header;
                    this.writeRawMessageTimeMillis = System.currentTimeMillis();
                    do {
                        if ((header = util.readCommBytes(this.commPort, 3)) == null || header.length != 3) continue;
                        int bodylength = (header[2] == 0 ? 256 : header[2] & 0xFF) + 2;
                        byte[] body = util.readCommBytes(this.commPort, bodylength);
                        byte[] response = Arrays.copyOf(header, header.length + body.length);
                        System.arraycopy(body, 0, response, header.length, body.length);
                        if (Configuration.verboseLog) {
                            hsyco.messageLog("ioMonitor - Raw FXP-XT traffic [" + (System.currentTimeMillis() - t) + "ms]: " + util.decodeHex(command) + " > " + (response == null ? "NULL" : util.decodeHex(response)) + " [" + this.serverName + "]");
                        }
                        return response;
                    } while (System.currentTimeMillis() < this.writeRawMessageTimeMillis + (long)(longtimeout ? 25000 : 5000));
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("ioMonitor - Raw FXP-XT traffic [" + (System.currentTimeMillis() - t) + "ms]: " + util.decodeHex(command) + " > ERROR " + (header == null ? "NULL" : util.decodeHex(header)) + " [" + this.serverName + "]");
                    }
                }
            }
            catch (Exception e2) {
                if (!Configuration.verboseLog) break block6;
                hsyco.messageLog("ioMonitor - Raw FXP-XT traffic: " + util.decodeHex(command) + " > Exception [" + this.serverName + "]");
            }
        }
        return null;
    }

    private void failoverSwitch() {
        if (this.commPortFailover != null) {
            if (this.commFailoverActive) {
                this.commFailoverActive = false;
                this.commPort = this.commPortMain;
                hsyco.errorLog("ioMonitor - failover warning [" + this.serverName + "] - switching to main port");
            } else {
                this.commFailoverActive = true;
                this.commPort = this.commPortFailover;
                hsyco.errorLog("ioMonitor - failover warning [" + this.serverName + "] - switching to failover port");
            }
        }
    }

    private void closeComm() {
        util.closeComm(this.commPort);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readModulesInfo(boolean input) {
        int length = 1;
        int pagestartaddress = 0;
        try {
            int page = 0;
            block10: while (true) {
                byte[] data;
                if (page >= 4) {
                    return true;
                }
                switch (this.gatewayID) {
                    case 0: {
                        int address = (input ? 59392 : 60416) + page * 256;
                        data = this.readRAM(address, 0);
                        break;
                    }
                    case 1: {
                        int address = (input ? 2048 : 3072) + page * 256;
                        data = this.readIRAM(address, 0);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                int i2 = pagestartaddress;
                while (true) {
                    block20: {
                        block21: {
                            if (i2 >= 64) {
                                ++page;
                                continue block10;
                            }
                            int type = data[i2 * 4] & 0xFF;
                            if (type <= 0) break block21;
                            if (input) {
                                switch (type) {
                                    case 121: {
                                        length = this.readDFANASize(i2 + page * 64);
                                        break;
                                    }
                                    case 229: {
                                        length = this.readDFANASize(i2 + page * 64);
                                        break;
                                    }
                                    default: {
                                        length = this.inputDeviceSize(type);
                                    }
                                }
                                if (length > 0) {
                                    this.inputDevices.put(i2 + page * 64, new Device(i2 + page * 64, type, length, true));
                                    break block20;
                                } else {
                                    length = 1;
                                    hsyco.messageLog("ioMonitor - ignored input device: " + (i2 + page * 64) + " = " + this.decodeDeviceType(type) + " [" + this.serverName + "]");
                                }
                                break block20;
                            } else {
                                length = this.outputDeviceSize(type);
                                if (length > 0) {
                                    this.outputDevices.put(i2 + page * 64, new Device(i2 + page * 64, type, length, false));
                                    break block20;
                                } else {
                                    length = 1;
                                    hsyco.messageLog("ioMonitor - ignored output device: " + (i2 + page * 64) + " = " + this.decodeDeviceType(type) + " [" + this.serverName + "]");
                                }
                            }
                            break block20;
                        }
                        length = 1;
                    }
                    pagestartaddress = i2 + length > 64 ? i2 + length - 64 : 0;
                    i2 += length;
                }
                break;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readEnergyMetersInfo() {
        try {
            byte[] data = this.readRAM(61952, 1);
            int i2 = 0;
            while (i2 < this.emDevices.length) {
                this.emDevices[i2] = (data[0] & 1 << i2) > 0;
                ++i2;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private int readDFANASize(int device) {
        try {
            byte[] data = this.readModuleEEPROM(device, 1, true);
            if (data != null && data.length == 4 && data[0] == -32 && data[1] == (byte)device && data[2] == 1) {
                return data[3];
            }
            return 0;
        }
        catch (Exception e2) {
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readDFANAInfo(int device) {
        try {
            int size = this.readDFANASize(device);
            if (size > 0 && size < 21) {
                int[] params = new int[20];
                int i2 = 0;
                while (i2 < size) {
                    byte[] data = this.readModuleEEPROM(device, 16 + i2 * 2, true);
                    if (data != null && data.length == 4 && data[0] == -32 && data[1] == (byte)device) {
                        params[i2] = data[3] & 0xFF;
                        data = this.readModuleEEPROM(device, 17 + i2 * 2, true);
                        if (data != null && data.length == 4 && data[0] == -32 && data[1] == (byte)device) {
                            int n2 = i2++;
                            params[n2] = params[n2] | (data[3] & 0xFF) << 8;
                            continue;
                        }
                        return false;
                    }
                    return false;
                }
                this.emDevicesParams.put(device, params);
                Integer[][] pdata = new Integer[4][3];
                int i3 = 0;
                while (i3 < 4) {
                    int j2 = 0;
                    while (j2 < 3) {
                        pdata[i3][j2] = null;
                        ++j2;
                    }
                    ++i3;
                }
                this.emDevicesPartialData.put(device, pdata);
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private void writeAllEnergyMetersPartialData(boolean events2) {
        Enumeration<Integer> entries = this.emDevicesPartialData.keys();
        while (entries.hasMoreElements()) {
            Integer address = entries.nextElement();
            Integer[][] pdata = this.emDevicesPartialData.get(address);
            if (pdata[0][0] != null && pdata[0][1] != null && pdata[0][2] != null) {
                this.ioWrite(events2, -1, "i", address, "energy.active", Double.toString((double)pdata[0][0].intValue() * 65536.0 + (double)pdata[0][1].intValue() + (double)pdata[0][2].intValue() / 1000.0));
                pdata[0][2] = null;
                pdata[0][1] = null;
                pdata[0][0] = null;
            }
            if (pdata[1][0] != null && pdata[1][1] != null && pdata[1][2] != null) {
                this.ioWrite(events2, -1, "i", address, "energy.activeneg", Double.toString((double)pdata[1][0].intValue() * 65536.0 + (double)pdata[1][1].intValue() + (double)pdata[1][2].intValue() / 1000.0));
                pdata[1][2] = null;
                pdata[1][1] = null;
                pdata[1][0] = null;
            }
            if (pdata[2][0] != null && pdata[2][1] != null && pdata[2][2] != null) {
                this.ioWrite(events2, -1, "i", address, "energy.reactive", Double.toString((double)pdata[2][0].intValue() * 65536.0 + (double)pdata[2][1].intValue() + (double)pdata[2][2].intValue() / 1000.0));
                pdata[2][2] = null;
                pdata[2][1] = null;
                pdata[2][0] = null;
            }
            if (pdata[3][0] == null || pdata[3][1] == null || pdata[3][2] == null) continue;
            this.ioWrite(events2, -1, "i", address, "energy.reactiveneg", Double.toString((double)pdata[3][0].intValue() * 65536.0 + (double)pdata[3][1].intValue() + (double)pdata[3][2].intValue() / 1000.0));
            pdata[3][2] = null;
            pdata[3][1] = null;
            pdata[3][0] = null;
        }
    }

    private boolean readDMXStatus(boolean events2, int device) {
        try {
            int i2 = 1;
            while (i2 <= 64) {
                byte[] data = this.readModuleRAM(device, i2 + 255);
                if (data != null && data[0] == -34 && data[1] == (byte)(device & 0xFF) && data[2] == i2 - 1) {
                    int level = data[3] & 0xFF;
                    int index = Configuration.dmxServersDeviceId.indexOf(String.valueOf(this.serverName) + "." + "o" + device);
                    this.ioStore("o", device, String.valueOf(i2) + ".memory", Integer.toString(level));
                    this.ioWrite(events2, -1, "o", device, Integer.toString(i2), Integer.toString(level));
                    if (index != -1) {
                        SystemState.dmxSetInit(1000 * index + i2, level);
                    }
                }
                ++i2;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readDALIStatus(boolean events2, boolean init, int device) {
        boolean found = false;
        try {
            int i2 = 1;
            while (i2 <= 32) {
                byte[] data = this.readModuleRAM(device, i2 + 255);
                if (data != null && data[0] == -34 && data[1] == (byte)(device & 0xFF) && data[2] == i2 - 1) {
                    int level = data[3] & 0xFF;
                    switch (level) {
                        case 128: {
                            found = true;
                            this.ioWrite(events2, 11, "o", device, Integer.toString(i2), "fault");
                            break;
                        }
                        case 255: {
                            break;
                        }
                        default: {
                            found = true;
                            if (level > 0) {
                                this.ioStore("o", device, String.valueOf(i2) + ".memory", Integer.toString(level));
                            }
                            this.ioWrite(events2, 11, "o", device, Integer.toString(i2), level == 0 ? "off" : String.valueOf(level) + "%");
                        }
                    }
                }
                ++i2;
            }
            if (init && found) {
                this.ioWrite(events2, 11, "o", device, "all", "unknown");
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readDALI64Status(boolean events2, boolean init, int device) {
        boolean found = false;
        try {
            int i2 = 1;
            while (i2 <= 16) {
                byte[] data = this.readModuleRAM(device, i2 + 255);
                if (data != null && data[0] == -34 && data[1] == (byte)(device & 0xFF) && data[2] == i2 - 1) {
                    int level = data[3] & 0xFF;
                    if (level == 0) {
                        found = true;
                        this.ioWrite(events2, 11, "o", device, "group." + i2, "off");
                    } else if (level > 0 && level <= 100) {
                        found = true;
                        this.ioStore("o", device, "group." + i2 + ".memory", Integer.toString(level));
                        this.ioWrite(events2, 11, "o", device, "group." + i2, String.valueOf(level) + "%");
                    }
                }
                ++i2;
            }
            if (init && found) {
                this.ioWrite(events2, 11, "o", device, "all", "unknown");
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readDFCTProgram(boolean events2, int device, int day, boolean winter) {
        StringBuffer sb = new StringBuffer();
        int baseaddress = (day - 1) * 12 + (winter ? 88 : 172);
        try {
            String program;
            int i2 = 0;
            while (true) {
                if (i2 >= 12) {
                    program = sb.toString();
                }
                byte[] data = this.readModuleEEPROM(device, i2 + baseaddress, true);
                if (data == null || data[0] != -32 && data[0] != -31 || data[1] != (byte)(device & 0xFF) || data[2] != (byte)(i2 + baseaddress & 0xFF)) break;
                sb.append(data[3] & 3);
                sb.append((data[3] & 0xC) >> 2);
                sb.append((data[3] & 0x30) >> 4);
                sb.append((data[3] & 0xC0) >> 6);
                ++i2;
            }
            return false;
            this.ioStore("o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory", program);
            this.ioWrite(events2, -1, "o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day, program);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeDFCTProgram(int device, int period, int day, boolean winter, int value) {
        int address = period / 4 + (day - 1) * 12 + (winter ? 88 : 172);
        try {
            byte newvalue;
            byte[] data = this.readModuleEEPROM(device, address, true);
            if (data == null) return false;
            if (data[0] != -32) {
                if (data[0] != -31) return false;
            }
            if (data[1] != (byte)(device & 0xFF)) return false;
            if (data[2] != (byte)(address & 0xFF)) return false;
            switch (period % 4) {
                case 0: {
                    newvalue = (byte)(data[3] & 0xFC | value);
                    break;
                }
                case 1: {
                    newvalue = (byte)(data[3] & 0xF3 | value << 2);
                    break;
                }
                case 2: {
                    newvalue = (byte)(data[3] & 0xCF | value << 4);
                    break;
                }
                case 3: {
                    newvalue = (byte)(data[3] & 0x3F | value << 6);
                    break;
                }
                default: {
                    return false;
                }
            }
            data = this.writeModuleEEPROM(device, address, newvalue);
            if (data == null) return false;
            if (data[0] != -32) {
                if (data[0] != -31) return false;
            }
            if (data[1] != (byte)(device & 0xFF)) return false;
            if (data[2] != (byte)(address & 0xFF)) return false;
            if (data[3] != newvalue) return false;
            String datapoint = String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory";
            String program = this.ioRead("o", device, datapoint);
            if (program == null) return true;
            StringBuffer sb = new StringBuffer(program);
            sb.setCharAt(period, (char)(48 + value));
            program = sb.toString();
            this.ioStore("o", device, datapoint, program);
            this.ioWrite(true, -1, "o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day, program);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeDFCTProgram(int device, int day, boolean winter, String program) {
        int baseaddress = (day - 1) * 12 + (winter ? 88 : 172);
        try {
            if (program.length() != 48) {
                return false;
            }
            int i2 = 0;
            while (i2 < 48) {
                char c2 = program.charAt(i2);
                if (c2 < '0' || c2 > '3') {
                    return false;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 12) {
                byte newvalue = (byte)(program.charAt(3 + 4 * i2) - 48);
                newvalue = (byte)(newvalue << 2 | program.charAt(2 + 4 * i2) - 48);
                newvalue = (byte)(newvalue << 2 | program.charAt(1 + 4 * i2) - 48);
                byte[] data = this.writeModuleEEPROM(device, i2 + baseaddress, newvalue = (byte)(newvalue << 2 | program.charAt(4 * i2) - 48));
                if (data == null || data[0] != -32 && data[0] != -31 || data[1] != (byte)(device & 0xFF) || data[2] != (byte)(i2 + baseaddress & 0xFF) || data[3] != newvalue) {
                    this.readDFCTProgram(true, device, day, winter);
                    return false;
                }
                ++i2;
            }
            this.ioStore("o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory", program);
            this.ioWrite(true, -1, "o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day, program);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readDF8RITProgram(boolean events2, int device, int day, boolean winter) {
        StringBuffer sb = new StringBuffer();
        int baseaddress = (day - 1) * 12 + (winter ? 856 : 940);
        try {
            String program;
            int i2 = 0;
            while (true) {
                if (i2 >= 12) {
                    program = sb.toString();
                }
                byte[] data = this.readModuleEEPROM2(device, i2 + baseaddress);
                if (data == null || data[0] != -58 || data[1] != (byte)(device & 0xFF) || data[2] != (byte)(i2 + baseaddress & 0xFF)) break;
                sb.append(data[3] & 3);
                sb.append((data[3] & 0xC) >> 2);
                sb.append((data[3] & 0x30) >> 4);
                sb.append((data[3] & 0xC0) >> 6);
                ++i2;
            }
            return false;
            this.ioStore("o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory", program);
            this.ioWrite(events2, -1, "o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day, program);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeDF8RITProgram(int device, int period, int day, boolean winter, int value) {
        int address = period / 4 + (day - 1) * 12 + (winter ? 856 : 940);
        try {
            byte newvalue;
            byte[] data = this.readModuleEEPROM2(device, address);
            if (data == null) return false;
            if (data[0] != -58) return false;
            if (data[1] != (byte)(device & 0xFF)) return false;
            if (data[2] != (byte)(address & 0xFF)) return false;
            switch (period % 4) {
                case 0: {
                    newvalue = (byte)(data[3] & 0xFC | value);
                    break;
                }
                case 1: {
                    newvalue = (byte)(data[3] & 0xF3 | value << 2);
                    break;
                }
                case 2: {
                    newvalue = (byte)(data[3] & 0xCF | value << 4);
                    break;
                }
                case 3: {
                    newvalue = (byte)(data[3] & 0x3F | value << 6);
                    break;
                }
                default: {
                    return false;
                }
            }
            data = this.writeModuleEEPROM2(device, address, newvalue);
            if (data == null) return false;
            if (data[0] != -58) return false;
            if (data[1] != (byte)(device & 0xFF)) return false;
            if (data[2] != (byte)(address & 0xFF)) return false;
            if (data[3] != newvalue) return false;
            String datapoint = String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory";
            String program = this.ioRead("o", device, datapoint);
            if (program == null) return true;
            StringBuffer sb = new StringBuffer(program);
            sb.setCharAt(period, (char)(48 + value));
            program = sb.toString();
            this.ioStore("o", device, datapoint, program);
            this.ioWrite(true, -1, "o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day, program);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeDF8RITProgram(int device, int day, boolean winter, String program) {
        int baseaddress = (day - 1) * 12 + (winter ? 856 : 940);
        try {
            if (program.length() != 48) {
                return false;
            }
            int i2 = 0;
            while (i2 < 48) {
                char c2 = program.charAt(i2);
                if (c2 < '0' || c2 > '3') {
                    return false;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 12) {
                byte newvalue = (byte)(program.charAt(3 + 4 * i2) - 48);
                newvalue = (byte)(newvalue << 2 | program.charAt(2 + 4 * i2) - 48);
                newvalue = (byte)(newvalue << 2 | program.charAt(1 + 4 * i2) - 48);
                byte[] data = this.writeModuleEEPROM2(device, i2 + baseaddress, newvalue = (byte)(newvalue << 2 | program.charAt(4 * i2) - 48));
                if (data == null || data[0] != -58 || data[1] != (byte)(device & 0xFF) || data[2] != (byte)(i2 + baseaddress & 0xFF) || data[3] != newvalue) {
                    this.readDF8RITProgram(true, device, day, winter);
                    return false;
                }
                ++i2;
            }
            this.ioStore("o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory", program);
            this.ioWrite(true, -1, "o", device, String.valueOf(winter ? "program.winter." : "program.summer.") + day, program);
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readDFTPConfiguration(int device) {
        try {
            byte[] data = this.readModuleEEPROM(device, 13, false);
            if (data != null && data.length == 4 && data[0] == -31 && data[1] == (byte)device && data[2] == 13) {
                if ((data[3] & 1) != 0) {
                    this.dftpPositionEnabled.set(device - 1);
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readDFDALI64Configuration(int device) {
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= 16) {
                    return true;
                }
                byte[] data = this.readModuleEEPROM2(device, 496 + i2);
                if (data != null && data.length == 4 && data[0] == -58) {
                    if (data[3] != 0) {
                        this.dfdali64GroupAddress.put(device + 2 + i2, device * 100 + data[3]);
                        this.dfdali64Group.add(device * 100 + data[3]);
                    }
                } else {
                    return false;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readDFTZ2Configuration(int device) {
        try {
            byte[] data = this.readModuleEEPROM(device, 1, true);
            if (data != null && data.length == 4 && data[0] == -32) {
                if ((data[3] & 8) == 0) {
                    this.dftz2FanEnabled.set(device - 1);
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean ckscheck(int address, int code, int size, byte[] body, byte[] checksum) {
        int cks = (address & 0xFF) + (code & 0xFF) + (size & 0xFF);
        int i2 = 0;
        while (i2 < body.length) {
            cks = cks + (body[i2] & 0xFF) & 0xFFFF;
            ++i2;
        }
        int c2 = ~(((checksum[0] & 0xFF) << 8) + (checksum[1] & 0xFF)) & 0xFFFF;
        return cks == c2;
    }

    private static void cksfiller(byte[] data) {
        int cks = 0;
        int i2 = 0;
        while (i2 < data.length - 2) {
            cks = cks + (data[i2] & 0xFF) & 0xFFFF;
            ++i2;
        }
        data[data.length - 2] = (byte)(~cks >>> 8 & 0xFF);
        data[data.length - 1] = (byte)(~cks & 0xFF);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] read(int command) {
        byte address = 0;
        boolean waitforaddress = true;
        try {
            int i2 = 0;
            while (i2 < 1024) {
                byte[] b2 = util.readCommBytes(this.commPort, 1);
                if (b2 != null && b2.length == 1) {
                    if (waitforaddress) {
                        address = b2[0];
                        waitforaddress = false;
                    } else {
                        if ((byte)(command & 0xFF) == b2[0]) break;
                        address = b2[0];
                        waitforaddress = true;
                    }
                } else {
                    return null;
                }
                ++i2;
            }
            byte[] sizeheader = util.readCommBytes(this.commPort, 1);
            int size = sizeheader[0] == 0 ? 256 : sizeheader[0] & 0xFF;
            byte[] body = util.readCommBytes(this.commPort, size);
            byte[] checksum = util.readCommBytes(this.commPort, 2);
            if (this.ckscheck(address, command, sizeheader[0], body, checksum)) {
                return body;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private boolean modulesDiscovery() {
        int length;
        Device device;
        boolean energy = false;
        try {
            String sid = new String(this.readAuxId());
            if (sid.equals("DFCP    ") || sid.equals("DFCP4   ")) {
                this.gatewayID = 0;
                this.inputModulesFaultData = new MemoryRange(61440, 256);
                this.outputModulesFaultData = new MemoryRange(61696, 256);
            } else if (sid.equals("DFH     ")) {
                this.gatewayID = 1;
                this.inputModulesFaultData = new MemoryRange(58368, 256);
                this.outputModulesFaultData = new MemoryRange(58624, 256);
            }
        }
        catch (Exception e2) {
            return false;
        }
        if (!this.readModulesInfo(true) || !this.readModulesInfo(false)) {
            return false;
        }
        if (!this.readEnergyMetersInfo()) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.emDevices.length) {
            if (this.emDevices[i2]) {
                energy = true;
                hsyco.messageLog("ioMonitor - detected input device: energy meter " + (i2 + 1) + " [" + this.serverName + "]");
            }
            ++i2;
        }
        if (energy) {
            this.energyRange = new MemoryRange(3872, 48);
        }
        int size = 0;
        int from = 0;
        i2 = 1;
        while (i2 < 256) {
            if (this.inputDevices.containsKey(i2)) {
                device = this.inputDevices.get(i2);
                length = device.size;
                hsyco.messageLog("ioMonitor - detected input device: " + i2 + "/" + length + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                if (this.detectevents) {
                    SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.input." + device.address + "." + length, this.decodeDeviceType(device.type).toLowerCase());
                }
                if (from == 0) {
                    from = i2;
                    size = length;
                } else if (i2 - from + length > 128 || i2 - from - size > 32) {
                    this.inputRanges.add(new MemoryRange(from * 2, 2 * size));
                    from = i2;
                    size = length;
                } else {
                    size = i2 - from + length;
                }
                if (device.type == 121 || device.type == 229) {
                    if (this.readDFANAInfo(i2)) {
                        hsyco.messageLog("ioMonitor - input device configuration acquired: " + i2 + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                    } else {
                        hsyco.errorLog("ioMonitor - input device configuration not acquired: " + i2 + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                    }
                } else if (device.type == 179) {
                    if (this.readDFDALI64Configuration(i2)) {
                        hsyco.messageLog("ioMonitor - input device configuration acquired: " + i2 + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                    } else {
                        hsyco.errorLog("ioMonitor - input device configuration not acquired: " + i2 + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                    }
                } else if (device.type == 170) {
                    this.readDFTZ2Configuration(i2);
                    if (!this.dftz2FanEnabled.get(i2 - 1)) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + i2 + ".fan.group", "visible", "false");
                    }
                }
            }
            ++i2;
        }
        if (from > 0) {
            this.inputRanges.add(new MemoryRange(from * 2, 2 * size));
        }
        size = 0;
        from = 0;
        i2 = 1;
        while (i2 < 256) {
            if (this.outputDevices.containsKey(i2)) {
                device = this.outputDevices.get(i2);
                length = device.size;
                hsyco.messageLog("ioMonitor - detected output device: " + i2 + "/" + length + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                if (this.detectevents) {
                    SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.output." + device.address + "." + length, this.decodeDeviceType(device.type).toLowerCase());
                }
                if (from == 0) {
                    from = i2;
                    size = length;
                } else if (i2 - from + length > 128 || i2 - from - size > 32) {
                    this.outputRanges.add(new MemoryRange(1024 + from * 2, 2 * size));
                    from = i2;
                    size = length;
                } else {
                    size = i2 - from + length;
                }
                if (device.type == 147) {
                    this.readDMXStatus(this.startupevents, i2);
                } else if (device.type == 163) {
                    this.readDALIStatus(this.startupevents, true, i2);
                } else if (device.type == 179) {
                    this.readDALI64Status(this.startupevents, true, i2);
                } else if (device.type == 36 || device.type == 68) {
                    if (this.readDFTPConfiguration(i2)) {
                        hsyco.messageLog("ioMonitor - output device configuration acquired: " + i2 + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                    } else {
                        hsyco.errorLog("ioMonitor - output device configuration not acquired: " + i2 + " = " + this.decodeDeviceType(device.type) + " [" + this.serverName + "]");
                    }
                }
            }
            ++i2;
        }
        if (from > 0) {
            this.outputRanges.add(new MemoryRange(1024 + from * 2, 2 * size));
        }
        return true;
    }

    private void commandPolling() {
        int counter = 0;
        try {
            String item;
            while (counter++ < 10 && (item = this.ioqtx.poll()) != null) {
                int equalidx;
                int pointidx = item.indexOf(46);
                if (pointidx == -1) {
                    equalidx = item.indexOf(61);
                    this.deviceCommand(item.substring(0, equalidx), null, item.substring(equalidx + 1));
                    continue;
                }
                equalidx = item.indexOf(61, pointidx);
                this.deviceCommand(item.substring(0, pointidx), item.substring(pointidx + 1, equalidx), item.substring(equalidx + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean inputPolling(boolean events2) {
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.inputRanges.size()) {
                    this.writeAllEnergyMetersPartialData(events2);
                    return true;
                }
                this.commandPolling();
                MemoryRange range = this.inputRanges.elementAt(i2);
                byte[] data = this.readRAM(range.from, range.size);
                if (data == null) {
                    return false;
                }
                if (!range.equalsCopy(data)) {
                    int address = range.from / 2;
                    while (address < (range.from + range.size) / 2) {
                        Device device = this.inputDevices.get(address);
                        if (device != null) {
                            this.deviceStateWrite(events2, true, address, device.type, data, range.from);
                        }
                        ++address;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean modulesFaultPolling(boolean events2) {
        try {
            StringBuffer sb;
            int i2;
            byte[] data = this.readRAM(this.inputModulesFaultData.from, this.inputModulesFaultData.size);
            if (!this.inputModulesFaultData.equalsCopy(data)) {
                i2 = 1;
                while (i2 < this.inputModulesFaultData.size) {
                    if (this.inputDevices.containsKey(i2)) {
                        sb = new StringBuffer(this.serverName);
                        sb.append(".i");
                        sb.append(i2);
                        sb.append(".modulefault");
                        if (events2) {
                            SystemState.ioWrite(sb.toString(), (data[i2] & 0x10) > 0 ? "1" : "0");
                        } else {
                            SystemState.ioWriteNoEvents(sb.toString(), (data[i2] & 0x10) > 0 ? "1" : "0");
                        }
                    }
                    ++i2;
                }
            }
            if (!this.outputModulesFaultData.equalsCopy(data = this.readRAM(this.outputModulesFaultData.from, this.outputModulesFaultData.size))) {
                i2 = 1;
                while (i2 < this.outputModulesFaultData.size) {
                    if (this.outputDevices.containsKey(i2)) {
                        sb = new StringBuffer(this.serverName);
                        sb.append(".o");
                        sb.append(i2);
                        sb.append(".modulefault");
                        if (events2) {
                            SystemState.ioWrite(sb.toString(), (data[i2] & 0x10) > 0 ? "1" : "0");
                        } else {
                            SystemState.ioWriteNoEvents(sb.toString(), (data[i2] & 0x10) > 0 ? "1" : "0");
                        }
                    }
                    ++i2;
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean virtualPointsPolling(boolean events2) {
        try {
            this.commandPolling();
            byte[] data = this.readRAM(this.virtualData.from, this.virtualData.size);
            if (data != null && data.length == 254) {
                if (!this.virtualData.equalsCopy(data)) {
                    int i2 = 0;
                    while (i2 < data.length) {
                        int v;
                        int j2 = 0;
                        while (j2 < 8) {
                            v = i2 * 8 + j2 + 1;
                            if (v > this.gwvirtuals) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "v", 0, Integer.toString(v), (data[i2 + 1] & 1 << j2) > 0 ? "1" : "0");
                            ++j2;
                        }
                        j2 = 0;
                        while (j2 < 8) {
                            v = i2 * 8 + j2 + 9;
                            if (v > this.gwvirtuals) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "v", 0, Integer.toString(v), (data[i2] & 1 << j2) > 0 ? "1" : "0");
                            ++j2;
                        }
                        i2 += 2;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean registersPolling(boolean events2) {
        try {
            int range = 0;
            while (range < this.registersData.length) {
                this.commandPolling();
                byte[] data = this.readRAM(this.registersData[range].from, this.registersData[range].size);
                if (data != null && data.length == 256) {
                    if (!this.registersData[range].equalsCopy(data)) {
                        int i2 = 0;
                        while (i2 < 128) {
                            int r = i2 + range * 128;
                            if (r > this.gwregisters) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "r", 0, Integer.toString(r), Integer.toString(((data[2 * i2] & 0xFF) << 8) + (data[2 * i2 + 1] & 0xFF)));
                            ++i2;
                        }
                    }
                } else {
                    return false;
                }
                ++range;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean countersPolling(boolean events2) {
        try {
            int range = 0;
            while (range < this.countersData.length) {
                this.commandPolling();
                byte[] data = this.readRAM(this.countersData[range].from, this.countersData[range].size);
                if (data != null && data.length == 256) {
                    if (!this.countersData[range].equalsCopy(data)) {
                        int i2 = 0;
                        while (i2 < 128) {
                            int r = i2 + range * 128;
                            if (r > this.gwcounters) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "c", 0, Integer.toString(r), Integer.toString(((data[2 * i2] & 0xFF) << 8) + (data[2 * i2 + 1] & 0xFF)));
                            ++i2;
                        }
                    }
                } else {
                    return false;
                }
                ++range;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean faultPolling(boolean events2) {
        try {
            byte[] data = this.readRAM(this.gatewayID == 1 ? 0 : 2556, 2);
            if (data != null && data.length == 2) {
                int newBusFault = (data[1] & 2) >> 1;
                int newModuleFault = data[1] & 1;
                if (newBusFault != this.busFault) {
                    this.busFault = newBusFault;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".busfault", Integer.toString(this.busFault));
                }
                if (newModuleFault != this.moduleFault) {
                    this.moduleFault = newModuleFault;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".modulefault", Integer.toString(this.moduleFault));
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean outputPolling(boolean events2) {
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.outputRanges.size()) {
                    return true;
                }
                this.commandPolling();
                MemoryRange range = this.outputRanges.elementAt(i2);
                byte[] data = this.readRAM(range.from, range.size);
                if (data == null) {
                    return false;
                }
                if (!range.equalsCopy(data)) {
                    int address = (range.from - 1024) / 2;
                    while (address < (range.from - 1024 + range.size) / 2) {
                        Device device = this.outputDevices.get(address);
                        if (device != null) {
                            this.deviceStateWrite(events2, false, address, device.type, data, range.from);
                        }
                        ++address;
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean energyPolling() {
        int totalpower = 0;
        try {
            this.commandPolling();
            byte[] data = this.readRAM(this.energyRange.from, this.energyRange.size);
            if (data != null && !this.energyRange.equalsCopy(data)) {
                int i2 = 0;
                while (i2 < this.emDevices.length) {
                    if (this.emDevices[i2]) {
                        boolean changes = false;
                        int value = ((data[16 * i2 + 2] & 0xFF) << 8) + (data[16 * i2 + 3] & 0xFF);
                        totalpower += value;
                        String last = this.ioRead("energy.", i2 + 1, "power.real");
                        if (last == null || Math.abs(value - Integer.parseInt(last)) > this.powerSensivity) {
                            changes = true;
                            this.ioWrite(true, -1, "energy.", i2 + 1, "power.real", Integer.toString(value));
                            SystemState.uiSet(String.valueOf(this.serverName) + ".energy." + (i2 + 1) + ".power", "value", String.valueOf(value) + " W");
                        }
                        value = data[16 * i2 + 4] << 8 | data[16 * i2 + 5] & 0xFF;
                        last = this.ioRead("energy.", i2 + 1, "power.reactive");
                        if (last == null || Math.abs(value - Integer.parseInt(last)) > this.powerSensivity) {
                            changes = true;
                            this.ioWrite(true, -1, "energy.", i2 + 1, "power.reactive", Integer.toString(value));
                        }
                        value = data[16 * i2 + 6] << 8 | data[16 * i2 + 7] & 0xFF;
                        last = this.ioRead("energy.", i2 + 1, "power.apparent");
                        if (last == null || Math.abs(value - Integer.parseInt(last)) > this.powerSensivity) {
                            changes = true;
                            this.ioWrite(true, -1, "energy.", i2 + 1, "power.apparent", Integer.toString(value));
                        }
                        value = ((data[16 * i2 + 10] & 0xFF) << 8) + (data[16 * i2 + 11] & 0xFF);
                        last = this.ioRead("energy.", i2 + 1, "power.realavg");
                        if (last == null || Math.abs(value - Integer.parseInt(last)) > this.powerSensivity) {
                            changes = true;
                            this.ioWrite(true, -1, "energy.", i2 + 1, "power.realavg", Integer.toString(value));
                        }
                        value = data[16 * i2 + 12] << 8 | data[16 * i2 + 13] & 0xFF;
                        last = this.ioRead("energy.", i2 + 1, "power.reactiveavg");
                        if (last == null || Math.abs(value - Integer.parseInt(last)) > this.powerSensivity) {
                            changes = true;
                            this.ioWrite(true, -1, "energy.", i2 + 1, "power.reactiveavg", Integer.toString(value));
                        }
                        if (changes) {
                            value = data[16 * i2 + 8] << 8 | data[16 * i2 + 9] & 0xFF;
                            this.ioWrite(true, -1, "energy.", i2 + 1, "cos", Integer.toString(value));
                            value = data[16 * i2 + 1];
                            int c2 = 0;
                            while (c2 < 8) {
                                this.ioWrite(true, -1, "energy.", i2 + 1, "load." + (c2 + 1), (value & 1 << c2) > 0 ? "1" : "0");
                                ++c2;
                            }
                        }
                    }
                    ++i2;
                }
                if (this.powerDisplayAddress == 0 && Math.abs(totalpower - this.powerValue) > this.powerSensivity) {
                    SystemState.powerSet(totalpower);
                    this.powerValue = totalpower;
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private Date readClock() {
        Calendar cal = Calendar.getInstance();
        try {
            byte[] d2 = this.readRAM(3840, 14);
            cal.clear();
            cal.set(2000 + util.decodeBCD(d2[13]), util.decodeBCD(d2[11]) - 1, util.decodeBCD(d2[9]), util.decodeBCD(d2[1]), util.decodeBCD(d2[3]), util.decodeBCD(d2[5]));
            return cal.getTime();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void writeClock() throws Exception {
        byte[] byArray = new byte[23];
        byArray[1] = 126;
        byArray[2] = 18;
        byArray[4] = 15;
        byArray[6] = 14;
        byte[] command = byArray;
        Calendar cal = Calendar.getInstance();
        int dow = cal.get(7);
        command[8] = util.encodeBCD(cal.get(11));
        command[10] = util.encodeBCD(cal.get(12));
        command[12] = util.encodeBCD(cal.get(13));
        command[14] = util.encodeBCD(dow == 1 ? 7 : dow - 1);
        command[16] = util.encodeBCD(cal.get(5));
        command[18] = util.encodeBCD(cal.get(2) + 1);
        command[20] = util.encodeBCD(cal.get(1) - 2000);
        Domino.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(126);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        throw new IOException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logWriteError(byte[] data) {
        long now = System.currentTimeMillis();
        if (this.commandErrorLogCounter == -1L) {
            if (this.commandErrorLogTimeMillis >= now - 300000L) return;
            this.commandErrorLogTimeMillis = now;
            this.commandErrorLogCounter = 1L;
        } else {
            if (this.commandErrorLogCounter >= 50L) {
                this.commandErrorLogTimeMillis = now;
                this.commandErrorLogCounter = -1L;
                hsyco.errorLog("ioMonitor - Command Error: Too many errors, log disabled for 5 minutes [" + this.serverName + "]");
                return;
            }
            if (this.commandErrorLogTimeMillis < now - 10000L) {
                this.commandErrorLogTimeMillis = now;
                this.commandErrorLogCounter = 1L;
            } else {
                ++this.commandErrorLogCounter;
            }
        }
        hsyco.errorLog("ioMonitor - Command Error: " + util.decodeHex(data) + " [" + this.serverName + "]");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String keypad(String id) {
        String key = id.toLowerCase();
        try {
            String[] sa = key.split("[.]+");
            int address = Integer.parseInt(sa[0]);
            if (!this.outputDevices.containsKey(address)) return "";
            Device device = this.outputDevices.get(address);
            switch (device.type) {
                case 42: 
                case 58: 
                case 153: 
                case 159: 
                case 169: 
                case 175: {
                    if (sa[1].equals("setpoint")) {
                        if (sa[2].equals("temp")) {
                            if (sa.length == 4) {
                                String setpoint = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint");
                                if (setpoint.equals("off") || setpoint.equals("0")) {
                                    setpoint = "man";
                                }
                                int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint));
                                if (sa[3].equals("up")) {
                                    int v = (s / 5 + 1) * 5;
                                    if (v < 100) return "";
                                    if (v > 355) return "";
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp.man", Integer.toString(v));
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "man");
                                    return "";
                                }
                                if (!sa[3].equals("down")) return "";
                                int v = (s / 5 - 1) * 5;
                                if (v < 100) return "";
                                if (v > 355) return "";
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp.man", Integer.toString(v));
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "man");
                                return "";
                            }
                            int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + sa[3]));
                            int v = 0;
                            v = sa[4].equals("up") || sa[4].equals("+") ? (s / 5 + 1) * 5 : (sa[4].equals("down") || sa[4].equals("-") ? (s / 5 - 1) * 5 : Integer.parseInt(sa[4]));
                            if (v < 100) return "";
                            if (v > 355) return "";
                            if ("man".equals(sa[3])) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp.man", Integer.toString(v));
                                return "";
                            }
                            if (!this.checkSetpointsSorted(Integer.parseInt(sa[0]), Integer.parseInt(sa[3]), v)) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + sa[3], Integer.toString(v));
                            return "";
                        }
                        if (!sa[2].equals("mode")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                            return "";
                        }
                        if (sa.length != 3) {
                            if (sa.length != 4) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", sa[3]);
                            return "";
                        }
                        if ("man".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint.mode"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", "off");
                            return "";
                        }
                        if ("auto".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint.mode"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", "man");
                            return "";
                        }
                        if (!"off".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint.mode"))) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", "auto");
                        return "";
                    }
                    if (sa[1].equals("mode")) {
                        if (sa.length != 2) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                            return "";
                        }
                        if ("summer".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "winter");
                            return "";
                        }
                        if (!"winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "summer");
                        return "";
                    }
                    if (sa[1].equals("fan")) {
                        if (sa.length == 2) {
                            String fan = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan");
                            if ("off".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "man");
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "min");
                                return "";
                            }
                            if ("auto".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan.mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "man");
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "off");
                                return "";
                            }
                            if ("min".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "med");
                                return "";
                            }
                            if ("med".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "max");
                                return "";
                            }
                            if (!"max".equals(fan)) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "auto");
                            return "";
                        }
                        if (sa[2].equals("mode")) {
                            if (sa.length != 3) {
                                if (sa.length != 4) return "";
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", sa[3]);
                                return "";
                            }
                            if ("man".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan.mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "auto");
                                return "";
                            }
                            if (!"auto".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan.mode"))) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "man");
                            return "";
                        }
                        if (sa.length != 3) return "";
                        if (sa[2].equals("up") || sa[2].equals("+")) {
                            String fan = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan");
                            if ("off".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "min");
                                return "";
                            }
                            if ("min".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "med");
                                return "";
                            }
                            if (!"med".equals(fan)) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "max");
                            return "";
                        }
                        if (!sa[2].equals("down") && !sa[2].equals("-")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", sa[2]);
                            return "";
                        }
                        String fan = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan");
                        if ("min".equals(fan)) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "off");
                            return "";
                        }
                        if ("med".equals(fan)) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "min");
                            return "";
                        }
                        if (!"max".equals(fan)) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "med");
                        return "";
                    }
                    if (!sa[1].equals("program")) return "";
                    if (sa[2].equals("refresh")) {
                        int day;
                        Calendar cal = Calendar.getInstance();
                        switch (cal.get(7)) {
                            case 3: {
                                day = 2;
                                break;
                            }
                            case 4: {
                                day = 3;
                                break;
                            }
                            case 5: {
                                day = 4;
                                break;
                            }
                            case 6: {
                                day = 5;
                                break;
                            }
                            case 7: {
                                day = 6;
                                break;
                            }
                            case 1: {
                                day = 7;
                                break;
                            }
                            default: {
                                day = 1;
                            }
                        }
                        int period = 2 * cal.get(11) + (cal.get(12) < 30 ? 0 : 1);
                        this.ioStore("o", address, "program.day.memory", Integer.toString(day));
                        this.ioStore("o", address, "program.period.memory", Integer.toString(period));
                        Object[] setpoints = new Double[]{Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.1")) / 10.0, Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2")) / 10.0, Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.3")) / 10.0};
                        Arrays.sort(setpoints);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "bgcolor", "transparent");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "drawaxis", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "origin", Double.toString((Double)setpoints[0] - ((Double)setpoints[2] - (Double)setpoints[0]) / 3.0));
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "valuerange", String.valueOf((Double)setpoints[0] - ((Double)setpoints[2] - (Double)setpoints[0]) / 3.0) + "," + ((Double)setpoints[2] + 0.1));
                        if (device.type != 42 && device.type != 58) {
                            this.dfctProgramDisplayRefresh(true, address, day, period);
                            return "";
                        }
                        this.df8ritProgramDisplayRefresh(true, address, day, period);
                        return "";
                    }
                    if (sa[2].equals("day")) {
                        int day = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.day.memory"));
                        day = day < 7 ? day + 1 : 1;
                        this.ioStore("o", address, "program.day.memory", Integer.toString(day));
                        this.ioStore("o", address, "program.period.memory", "0");
                        if (device.type != 42 && device.type != 58) {
                            this.dfctProgramDisplayRefresh(true, address, day, 0);
                            return "";
                        }
                        this.df8ritProgramDisplayRefresh(true, address, day, 0);
                        return "";
                    }
                    if (sa[2].equals("left")) {
                        int day = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.day.memory"));
                        int period = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.period.memory"));
                        period = period > 0 ? period - 1 : 47;
                        this.ioStore("o", address, "program.period.memory", Integer.toString(period));
                        if (device.type != 42 && device.type != 58) {
                            this.dfctProgramDisplayRefresh(false, address, day, period);
                            return "";
                        }
                        this.df8ritProgramDisplayRefresh(false, address, day, period);
                        return "";
                    }
                    if (sa[2].equals("setpoint")) {
                        boolean winter = "winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + address + ".mode"));
                        int day = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.day.memory"));
                        int period = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.period.memory"));
                        String program = this.ioRead("o", address, String.valueOf(winter ? "program.winter" : "program.summer") + "." + day + ".memory");
                        int setpoint = program.charAt(period) - 48;
                        StringBuffer sb = new StringBuffer(program);
                        sb.setCharAt(period, (char)(48 + (setpoint < 3 ? setpoint + 1 : 0)));
                        program = sb.toString();
                        this.ioStore("o", address, String.valueOf(winter ? "program.winter" : "program.summer") + "." + day + ".memory", program);
                        if (device.type != 42 && device.type != 58) {
                            this.dfctProgramDisplayRefresh(false, address, day, period);
                            return "";
                        }
                        this.df8ritProgramDisplayRefresh(false, address, day, period);
                        return "";
                    }
                    if (sa[2].equals("right")) {
                        int day = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.day.memory"));
                        int period = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.period.memory"));
                        period = period < 47 ? period + 1 : 0;
                        this.ioStore("o", address, "program.period.memory", Integer.toString(period));
                        if (device.type != 42 && device.type != 58) {
                            this.dfctProgramDisplayRefresh(false, address, day, period);
                            return "";
                        }
                        this.dfctProgramDisplayRefresh(false, address, day, period);
                        return "";
                    }
                    if (sa[2].equals("copy")) {
                        boolean winter = "winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + address + ".mode"));
                        int day = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.day.memory"));
                        String program = this.ioRead("o", address, String.valueOf(winter ? "program.winter" : "program.summer") + "." + day + ".memory");
                        day = day < 7 ? day + 1 : 1;
                        this.ioStore("o", address, String.valueOf(winter ? "program.winter" : "program.summer") + "." + day + ".memory", program);
                        this.ioStore("o", address, "program.day.memory", Integer.toString(day));
                        this.ioStore("o", address, "program.period.memory", "0");
                        if (device.type != 42 && device.type != 58) {
                            this.dfctProgramDisplayRefresh(false, address, day, 0);
                            return "";
                        }
                        this.dfctProgramDisplayRefresh(false, address, day, 0);
                        return "";
                    }
                    if (!sa[2].equals("save")) return "";
                    boolean winter = "winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + address + ".mode"));
                    int day = Integer.parseInt(this.ioRead("o", Integer.parseInt(sa[0]), "program.day.memory"));
                    String program = this.ioRead("o", address, String.valueOf(winter ? "program.winter" : "program.summer") + "." + day + ".memory");
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + address + (winter ? ".program.winter." : ".program.summer.") + day, program);
                    return "";
                }
                case 89: 
                case 105: {
                    if (sa[1].equals("setpoint")) {
                        if (sa[2].equals("temp")) {
                            String setpoint = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint");
                            if (!setpoint.equals("comfort") && !setpoint.equals("eco")) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "comfort");
                                setpoint = "comfort";
                            }
                            if (sa.length == 4) {
                                int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint));
                                int v = -1;
                                if (sa[3].equals("up")) {
                                    v = (s / 5 + 1) * 5;
                                } else if (sa[3].equals("down")) {
                                    v = (s / 5 - 1) * 5;
                                }
                                if (v >= 0 && v < 100) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, "100");
                                    return "";
                                }
                                if (v > 355) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, "355");
                                    return "";
                                }
                                if (v == -1) return "";
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, Integer.toString(v));
                                return "";
                            }
                            if (sa[3].equals("1")) {
                                setpoint = "comfort";
                            } else if (sa[3].equals("2")) {
                                setpoint = "eco";
                            } else {
                                if (!sa[3].equals("man")) return "";
                                setpoint = "limit";
                            }
                            int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint));
                            int v = -1;
                            v = sa[4].equals("up") || sa[4].equals("+") ? (s / 5 + 1) * 5 : (sa[4].equals("down") || sa[4].equals("-") ? (s / 5 - 1) * 5 : Integer.parseInt(sa[4]));
                            if (v >= 0 && v < 100) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, "100");
                                return "";
                            }
                            if (v > 355) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, "355");
                                return "";
                            }
                            if (v == -1) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, Integer.toString(v));
                            return "";
                        }
                        if (!sa[2].equals("mode")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                            return "";
                        }
                        if (sa.length != 3) {
                            if (sa.length != 4) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", sa[3]);
                            return "";
                        }
                        if ("eco".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "off");
                            return "";
                        }
                        if ("comfort".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "eco");
                            return "";
                        }
                        if (!"off".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint"))) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "comfort");
                        return "";
                    }
                    if (!sa[1].equals("mode")) return "";
                    if (sa.length != 2) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                        return "";
                    }
                    if ("summer".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "winter");
                        return "";
                    }
                    if (!"winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) return "";
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "summer");
                    return "";
                }
                case 170: 
                case 186: {
                    String vs;
                    int s;
                    if (sa[1].equals("setpoint")) {
                        if (sa[2].equals("temp")) {
                            String setpoint = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint");
                            if (!setpoint.equals("comfort") && !setpoint.equals("eco")) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "comfort");
                                setpoint = "comfort";
                            }
                            if (sa.length == 4) {
                                int s2 = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint));
                                int v = -1;
                                v = sa[3].equals("up") ? (s2 / 5 + 1) * 5 : (sa[3].equals("down") ? (s2 / 5 - 1) * 5 : Integer.parseInt(sa[3]));
                                if (v >= 0 && v < 100) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, "100");
                                    return "";
                                }
                                if (v > 355) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, "355");
                                    return "";
                                }
                                if (v == -1) return "";
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, Integer.toString(v));
                                return "";
                            }
                            if (sa[3].equals("1")) {
                                setpoint = "comfort";
                            } else if (sa[3].equals("2")) {
                                setpoint = "eco";
                            } else {
                                if (!sa[3].equals("man")) return "";
                                setpoint = "limit";
                            }
                            int s3 = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint));
                            int v = -1;
                            v = sa[4].equals("up") || sa[4].equals("+") ? (s3 / 5 + 1) * 5 : (sa[4].equals("down") || sa[4].equals("-") ? (s3 / 5 - 1) * 5 : Integer.parseInt(sa[4]));
                            if (v < 0) return "";
                            if (v >= 355) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint, Integer.toString(v));
                            return "";
                        }
                        if (!sa[2].equals("mode")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                            return "";
                        }
                        if (sa.length != 3) {
                            if (sa.length != 4) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", sa[3]);
                            return "";
                        }
                        if ("eco".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "off");
                            return "";
                        }
                        if ("comfort".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "eco");
                            return "";
                        }
                        if (!"off".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint"))) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "comfort");
                        return "";
                    }
                    if (sa[1].equals("mode")) {
                        if (sa.length != 2) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                            return "";
                        }
                        if ("summer".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "winter");
                            return "";
                        }
                        if (!"winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "summer");
                        return "";
                    }
                    if (sa[1].equals("fan")) {
                        if (sa.length == 2) {
                            String fan = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan");
                            if ("off".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "man");
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "min");
                                return "";
                            }
                            if ("auto".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan.mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "man");
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "off");
                                return "";
                            }
                            if ("min".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "med");
                                return "";
                            }
                            if ("med".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "max");
                                return "";
                            }
                            if (!"max".equals(fan)) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "auto");
                            return "";
                        }
                        if (sa[2].equals("mode")) {
                            if (sa.length != 3) {
                                if (sa.length != 4) return "";
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", sa[3]);
                                return "";
                            }
                            if ("man".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan.mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "auto");
                                return "";
                            }
                            if (!"auto".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan.mode"))) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan.mode", "man");
                            return "";
                        }
                        if (sa.length != 3) return "";
                        if (sa[2].equals("up") || sa[2].equals("+")) {
                            String fan = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan");
                            if ("off".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "min");
                                return "";
                            }
                            if ("min".equals(fan)) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "med");
                                return "";
                            }
                            if (!"med".equals(fan)) return "";
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "max");
                            return "";
                        }
                        if (!sa[2].equals("down") && !sa[2].equals("-")) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", sa[2]);
                            return "";
                        }
                        String fan = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".fan");
                        if ("min".equals(fan)) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "off");
                            return "";
                        }
                        if ("med".equals(fan)) {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "min");
                            return "";
                        }
                        if (!"max".equals(fan)) return "";
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".fan", "med");
                        return "";
                    }
                    if (!sa[1].equals("dewpoint")) return "";
                    if (!sa[2].equals("limit")) return "";
                    if (!sa[3].equals("1")) {
                        if (!sa[3].equals("2")) return "";
                    }
                    int n2 = s = (vs = SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".dewpoint.limit." + sa[3])).equalsIgnoreCase("off") ? 0 : Integer.parseInt(vs);
                    int v = sa[4].equals("up") || sa[4].equals("+") ? (s / 5 + 1) * 5 : (sa[4].equals("down") || sa[4].equals("-") ? (s / 5 - 1) * 5 : (sa[4].equalsIgnoreCase("off") ? 0 : Integer.parseInt(sa[4])));
                    if (v < 0) return "";
                    if (v >= 355) return "";
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".dewpoint.limit." + sa[3], Integer.toString(v));
                    return "";
                }
                case 26: {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0], sa[1]);
                    return "";
                }
                case 90: {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0], sa[1]);
                    return "";
                }
                case 36: 
                case 68: {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                }
            }
            return "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private boolean checkSetpointsSorted(int address, int setpoint, int newvalue) {
        try {
            switch (setpoint) {
                case 1: {
                    return newvalue < Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2"));
                }
                case 2: {
                    return newvalue > Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.1")) && newvalue < Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.3"));
                }
                case 3: {
                    return newvalue > Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2"));
                }
            }
            return false;
        }
        catch (Exception e2) {
            return true;
        }
    }

    private void dfctProgramDisplayRefresh(boolean read, int address, int day, int period) {
        Double[] setpoints = new Double[4];
        Object[] sorted = new Double[3];
        boolean winter = "winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + address + ".mode"));
        setpoints[0] = 0.0;
        sorted[0] = setpoints[1] = Double.valueOf(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.1")) / 10.0);
        sorted[1] = setpoints[2] = Double.valueOf(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2")) / 10.0);
        sorted[2] = setpoints[3] = Double.valueOf(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.3")) / 10.0);
        Arrays.sort(sorted);
        setpoints[0] = (Double)sorted[0] - ((Double)sorted[2] - (Double)sorted[0]) / 4.0;
        if (read) {
            this.readDFCTProgram(false, address, day, winter);
        }
        String program = this.ioRead("o", address, String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory");
        String setpoint = program.charAt(period) == '0' ? TEXT[this.language][1] : Double.toString(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp." + (program.charAt(period) - 48))) / 10.0);
        String time = (period / 2 > 9 ? Integer.valueOf(period / 2) : "0" + period / 2) + (period % 2 == 0 ? ":00" : ":30");
        StringBuffer chartbarcolors = new StringBuffer();
        StringBuffer chartvalues = new StringBuffer();
        int i2 = 0;
        while (i2 < program.length()) {
            if (i2 > 0) {
                chartbarcolors.append(',');
                chartvalues.append(',');
            }
            chartbarcolors.append(period == i2 ? "yellow" : "gray");
            chartvalues.append(setpoints[program.charAt(i2) - 48]);
            ++i2;
        }
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.pointer", "value", String.valueOf(TEXT[this.language][9 + day]) + " " + time + " " + setpoint);
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "values", chartvalues.toString());
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "barcolors", chartbarcolors.toString());
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.setpoint.min", "value", Double.toString(setpoints[1]));
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.setpoint.med", "value", Double.toString(setpoints[2]));
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.setpoint.max", "value", Double.toString(setpoints[3]));
    }

    private void df8ritProgramDisplayRefresh(boolean read, int address, int day, int period) {
        Double[] setpoints = new Double[4];
        Object[] sorted = new Double[3];
        boolean winter = "winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + address + ".mode"));
        setpoints[0] = 0.0;
        sorted[0] = setpoints[1] = Double.valueOf(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.1")) / 10.0);
        sorted[1] = setpoints[2] = Double.valueOf(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2")) / 10.0);
        sorted[2] = setpoints[3] = Double.valueOf(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.3")) / 10.0);
        Arrays.sort(sorted);
        setpoints[0] = (Double)sorted[0] - ((Double)sorted[2] - (Double)sorted[0]) / 4.0;
        if (read) {
            this.readDF8RITProgram(false, address, day, winter);
        }
        String program = this.ioRead("o", address, String.valueOf(winter ? "program.winter." : "program.summer.") + day + ".memory");
        String setpoint = program.charAt(period) == '0' ? TEXT[this.language][1] : Double.toString(Double.parseDouble(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp." + (program.charAt(period) - 48))) / 10.0);
        String time = (period / 2 > 9 ? Integer.valueOf(period / 2) : "0" + period / 2) + (period % 2 == 0 ? ":00" : ":30");
        StringBuffer chartbarcolors = new StringBuffer();
        StringBuffer chartvalues = new StringBuffer();
        int i2 = 0;
        while (i2 < program.length()) {
            if (i2 > 0) {
                chartbarcolors.append(',');
                chartvalues.append(',');
            }
            chartbarcolors.append(period == i2 ? "yellow" : "gray");
            chartvalues.append(setpoints[program.charAt(i2) - 48]);
            ++i2;
        }
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.pointer", "value", String.valueOf(TEXT[this.language][9 + day]) + " " + time + " " + setpoint);
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "values", chartvalues.toString());
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.chart", "barcolors", chartbarcolors.toString());
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.setpoint.min", "value", Double.toString(setpoints[1]));
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.setpoint.med", "value", Double.toString(setpoints[2]));
        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".program.setpoint.max", "value", Double.toString(setpoints[3]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deviceCommand(String deviceName, String portName, String value) throws Exception {
        if (deviceName.equalsIgnoreCase("v0")) {
            int port = Integer.parseInt(portName);
            if (port <= 0 || port > this.gwvirtuals) return;
            if (value.equals("1") || value.equalsIgnoreCase("on")) {
                this.writeVirtual(port, true);
                return;
            } else {
                if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                this.writeVirtual(port, false);
            }
            return;
        }
        if (deviceName.equalsIgnoreCase("r0")) {
            int port = Integer.parseInt(portName);
            if (port < 0 || port > this.gwregisters) return;
            this.writeRegister(port, (int)Double.parseDouble(value));
            return;
        }
        if (deviceName.equalsIgnoreCase("c0")) {
            int port = Integer.parseInt(portName);
            if (port < 0 || port > this.gwcounters) return;
            this.writeCounter(port, (int)Double.parseDouble(value));
            return;
        }
        if (deviceName.equalsIgnoreCase("clock")) {
            if (value.equalsIgnoreCase("read")) {
                Date d2 = this.readClock();
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d2));
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock.delta", Long.toString((d2.getTime() - System.currentTimeMillis()) / 1000L));
                return;
            } else {
                if (!value.equalsIgnoreCase("sync")) return;
                this.writeClock();
                Date d3 = this.readClock();
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d3));
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock.delta", Long.toString((d3.getTime() - System.currentTimeMillis()) / 1000L));
            }
            return;
        }
        int address = Integer.parseInt(deviceName.substring(1));
        if (!this.outputDevices.containsKey(address)) return;
        Device device = this.outputDevices.get(address);
        switch (device.type) {
            case 66: 
            case 69: 
            case 82: 
            case 117: 
            case 130: 
            case 133: 
            case 146: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port >= 5) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(address, 1 << port - 1, 0);
                }
                return;
            }
            case 217: {
                String portNameLowerCase = portName.toLowerCase();
                if (portNameLowerCase.startsWith("led.")) {
                    int port = Integer.parseInt(portName.substring(4));
                    if (port <= 0 || port >= 7) return;
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 1 << port - 1, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 1 << port - 1, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("disable")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 1024, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 1024, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("dim")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 2048, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 2048, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("proximity")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 4096, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 4096, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("backlight")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 8192, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 8192, 0);
                    }
                    return;
                } else {
                    if (!portNameLowerCase.equals("buzzer")) return;
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 16384, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 16384, 0);
                    }
                }
                return;
            }
            case 34: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port >= 3) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(address, 1 << port - 1, 0);
                }
                return;
            }
            case 243: {
                if (portName.equals("2")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 128, 128);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 128, 0);
                    }
                    return;
                }
            }
            case 19: 
            case 35: 
            case 51: 
            case 67: 
            case 83: 
            case 99: {
                if (portName.equals("1")) {
                    int level;
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                    } else if (value.endsWith("%")) {
                        level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                    } else {
                        int index = value.indexOf(47);
                        if (index > 0) {
                            level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                        } else if (value.equalsIgnoreCase("on")) {
                            level = -1;
                            this.writeOutput(address, 127, 124);
                        } else {
                            level = (int)Double.parseDouble(value);
                        }
                    }
                    if (level < 0 || level > 100) return;
                    this.writeOutput(address, 127, level);
                    return;
                } else if (portName.equalsIgnoreCase("ramp")) {
                    if (value.equalsIgnoreCase("save")) {
                        this.writeOutput(address, 127, 127);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        if (level >= 1 && level <= 10) {
                            this.writeOutput(address, 127, level + 100);
                            return;
                        } else if (level >= 12 && level <= 30) {
                            this.writeOutput(address, 127, (level - 10) / 2 + 110);
                            return;
                        } else if (level == 40) {
                            this.writeOutput(address, 127, 121);
                            return;
                        } else if (level == 50) {
                            this.writeOutput(address, 127, 122);
                            return;
                        } else {
                            if (level != 60) return;
                            this.writeOutput(address, 127, 123);
                        }
                    }
                    return;
                } else if (portName.equalsIgnoreCase("setpoint")) {
                    int level = (int)Double.parseDouble(value);
                    if (level < 0 || level > 1023) return;
                    this.writeOutput(address, 65535, 1024 + level);
                    return;
                } else if (portName.equalsIgnoreCase("hysteresis")) {
                    int level = (int)Double.parseDouble(value);
                    if (level < 0 || level > 255) return;
                    this.writeOutput(address, 65535, 256 + level);
                    return;
                } else {
                    int level;
                    if (!portName.equalsIgnoreCase("time") || (level = (int)Double.parseDouble(value)) < 0 || level > 255) return;
                    this.writeOutput(address, 65535, 512 + level);
                }
                return;
            }
            case 211: 
            case 227: {
                if (portName.equals("1")) {
                    int level;
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                    } else if (value.endsWith("%")) {
                        level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                    } else {
                        int index = value.indexOf(47);
                        if (index > 0) {
                            level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                        } else if (value.equalsIgnoreCase("on")) {
                            level = -1;
                            this.writeOutput(address, 127, 124);
                        } else {
                            level = (int)Double.parseDouble(value);
                        }
                    }
                    if (level < 0 || level > 100) return;
                    this.writeOutput(address, 127, level);
                    return;
                } else {
                    if (!portName.equalsIgnoreCase("ramp")) return;
                    if (value.equalsIgnoreCase("save")) {
                        this.writeOutput(address, 127, 127);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        if (level >= 1 && level <= 10) {
                            this.writeOutput(address, 127, level + 100);
                            return;
                        } else if (level >= 12 && level <= 30) {
                            this.writeOutput(address, 127, (level - 10) / 2 + 110);
                            return;
                        } else if (level == 40) {
                            this.writeOutput(address, 127, 121);
                            return;
                        } else if (level == 50) {
                            this.writeOutput(address, 127, 122);
                            return;
                        } else {
                            if (level != 60) return;
                            this.writeOutput(address, 127, 123);
                        }
                    }
                }
                return;
            }
            case 147: {
                if (portName.charAt(0) == '#') {
                    int port = Integer.parseInt(portName.substring(1));
                    int level = (int)Double.parseDouble(value);
                    this.writeOutput(address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                    this.ioStore("o", address, String.valueOf(port) + ".memory", value);
                    this.ioWrite(true, -1, "o", address, Integer.toString(port), value);
                    return;
                } else {
                    int index;
                    int dmxlevel;
                    int level;
                    int port = Integer.parseInt(portName);
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                        dmxlevel = -1;
                    } else if (value.equalsIgnoreCase("on")) {
                        index = Configuration.dmxServersDeviceId.indexOf(String.valueOf(this.serverName) + "." + "o" + address);
                        if (index != -1) {
                            dmxlevel = level = SystemState.dmxMemGet(1000 * index + port);
                            this.ioStore("o", address, String.valueOf(port) + ".memory", Integer.toString(level));
                        } else {
                            String m2 = this.ioRead("o", address, String.valueOf(port) + ".memory");
                            if (m2 == null) {
                                level = 255;
                                dmxlevel = 255;
                                this.ioStore("o", address, String.valueOf(port) + ".memory", "255");
                            } else {
                                dmxlevel = level = (int)Double.parseDouble(m2);
                            }
                        }
                    } else {
                        dmxlevel = level = (int)Double.parseDouble(value);
                        this.ioStore("o", address, String.valueOf(port) + ".memory", Integer.toString(level));
                    }
                    this.writeOutput(address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                    this.ioWrite(true, -1, "o", address, Integer.toString(port), Integer.toString(level));
                    if (port < 1 || port > 64 || (index = Configuration.dmxServersDeviceId.indexOf(String.valueOf(this.serverName) + "." + "o" + address)) == -1) return;
                    SystemState.dmxSet(1000 * index + port, dmxlevel);
                }
                return;
            }
            case 163: 
            case 179: {
                if (portName == null) {
                    if (value.equalsIgnoreCase("refresh")) {
                        if (device.type == 163) {
                            this.readDALIStatus(true, false, address);
                            return;
                        } else {
                            this.readDALI64Status(true, false, address);
                        }
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        this.writeOutput(address, 65535, level & 0xFF);
                    }
                    return;
                } else if ((portName = portName.toLowerCase()).equals("all") || portName.equals("0")) {
                    int level;
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                    } else if (value.equalsIgnoreCase("on")) {
                        String m3 = this.ioRead("o", address, "all.memory");
                        if (m3 == null) {
                            level = 100;
                            this.ioStore("o", address, "all.memory", "100");
                        } else {
                            int index;
                            level = m3.endsWith("%") ? (int)Double.parseDouble(m3.substring(0, m3.length() - 1)) : ((index = m3.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(m3.substring(0, index)) / Double.parseDouble(m3.substring(index + 1))) : (int)Double.parseDouble(m3));
                        }
                    } else if (value.endsWith("%")) {
                        level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                        if (level < 0 || level > 100) {
                            return;
                        }
                        if (level > 0) {
                            this.ioStore("o", address, "all.memory", value);
                        }
                    } else {
                        int index = value.indexOf(47);
                        if (index > 0) {
                            level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", address, "all.memory", value);
                            }
                        } else {
                            level = (int)Double.parseDouble(value);
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", address, "all.memory", value);
                            }
                        }
                    }
                    this.ioWrite(true, 11, "o", address, "all", level == 0 ? "off" : String.valueOf(level) + "%");
                    this.writeOutput(address, 65535, level & 0xFF);
                    return;
                } else if (portName.equals("raw")) {
                    String[] sa = value.split("[.]");
                    int hi = Integer.parseInt(sa[0]);
                    int lo = Integer.parseInt(sa[1]);
                    if (hi >= 0 && hi <= 255 && lo >= 0 && hi <= 255) {
                        try {
                            this.writeOutput(address, 65535, hi * 256 + lo);
                            this.ioWrite(true, -1, "o", address, portName, value);
                            return;
                        }
                        catch (Exception e2) {
                            this.ioWrite(true, -1, "o", address, portName, "error");
                        }
                        return;
                    } else {
                        this.ioWrite(true, -1, "o", address, portName, "error");
                    }
                    return;
                } else if (portName.startsWith("group.")) {
                    int level;
                    int port = Integer.parseInt(portName.substring(6));
                    if (port < 1 || port > 16) return;
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                    } else if (value.equalsIgnoreCase("on")) {
                        String m4 = this.ioRead("o", address, "group." + port + ".memory");
                        if (m4 == null) {
                            level = 100;
                            this.ioStore("o", address, "group." + port + ".memory", "100");
                        } else {
                            level = (int)Double.parseDouble(m4);
                        }
                    } else if (value.endsWith("%")) {
                        level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                        if (level < 0 || level > 100) {
                            return;
                        }
                        if (level > 0) {
                            this.ioStore("o", address, "group." + port + ".memory", value);
                        }
                    } else {
                        int index = value.indexOf(47);
                        if (index > 0) {
                            level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", address, "group." + port + ".memory", value);
                            }
                        } else {
                            level = (int)Double.parseDouble(value);
                            this.ioStore("o", address, "group." + port + ".memory", value);
                        }
                    }
                    if (!this.dfdali64Group.contains(address * 100 + port)) {
                        this.ioWrite(true, 11, "o", address, portName, level == 0 ? "off" : String.valueOf(level) + "%");
                    }
                    this.writeOutput(address, 65535, ((128 + port & 0xFF) << 8) + (level & 0xFF));
                    return;
                } else {
                    int level;
                    int port = Integer.parseInt(portName);
                    if (port < 1 || port > (device.type == 163 ? 32 : 64)) return;
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                    } else if (value.equalsIgnoreCase("on")) {
                        String m5 = this.ioRead("o", address, String.valueOf(port) + ".memory");
                        if (m5 == null) {
                            level = 100;
                            this.ioStore("o", address, String.valueOf(port) + ".memory", "100");
                        } else {
                            level = (int)Double.parseDouble(m5);
                        }
                    } else if (value.endsWith("%")) {
                        level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                        if (level < 0 || level > 100) {
                            return;
                        }
                        if (level > 0) {
                            this.ioStore("o", address, String.valueOf(port) + ".memory", value);
                        }
                    } else {
                        int index = value.indexOf(47);
                        if (index > 0) {
                            level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", address, String.valueOf(port) + ".memory", value);
                            }
                        } else {
                            level = (int)Double.parseDouble(value);
                            if (level < 0 || level > 255) {
                                return;
                            }
                            if (level > 100) {
                                this.writeOutput(address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", address, String.valueOf(port) + ".memory", value);
                            }
                        }
                    }
                    this.ioWrite(true, 11, "o", address, portName, level == 0 ? "off" : String.valueOf(level) + "%");
                    this.writeOutput(address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                }
                return;
            }
            case 52: {
                switch (Integer.parseInt(portName)) {
                    case 1: {
                        if (value.equalsIgnoreCase("stop") || value.equalsIgnoreCase("off") || value.equals("0")) {
                            this.writeOutput(address, 3, 0);
                            return;
                        }
                        if (value.equalsIgnoreCase("up")) {
                            this.writeOutput(address, 3, 1);
                            return;
                        }
                        if (!value.equalsIgnoreCase("down")) return;
                        this.writeOutput(address, 3, 2);
                        return;
                    }
                    case 2: {
                        if (value.equals("1") || value.equalsIgnoreCase("on")) {
                            this.writeOutput(address, 4, 65535);
                            return;
                        }
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 4, 0);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 36: 
            case 68: {
                if (portName.endsWith(".value")) {
                    portName = portName.substring(0, portName.length() - 6);
                }
                switch (Integer.parseInt(portName)) {
                    case 1: {
                        int index;
                        int level;
                        if (value.equalsIgnoreCase("stop") || value.equalsIgnoreCase("off") || value.equals("0")) {
                            this.writeOutput(address, 771, 0);
                            return;
                        }
                        if (value.equalsIgnoreCase("up")) {
                            this.writeOutput(address, 771, 1);
                            return;
                        }
                        if (value.equalsIgnoreCase("down")) {
                            this.writeOutput(address, 771, 2);
                            return;
                        }
                        if (!this.dftpPositionEnabled.get(address - 1) || (level = value.endsWith("%") ? (int)Double.parseDouble(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : (int)Double.parseDouble(value))) < 0 || level > 100) return;
                        this.writeOutput(address, 65535, 0x100 | level);
                        return;
                    }
                    case 2: {
                        int index;
                        int level;
                        if (value.equalsIgnoreCase("stop") || value.equalsIgnoreCase("off") || value.equals("0")) {
                            this.writeOutput(address, 780, 0);
                            return;
                        }
                        if (value.equalsIgnoreCase("up")) {
                            this.writeOutput(address, 780, 4);
                            return;
                        }
                        if (value.equalsIgnoreCase("down")) {
                            this.writeOutput(address, 780, 8);
                            return;
                        }
                        if (!this.dftpPositionEnabled.get(address - 1) || (level = value.endsWith("%") ? (int)Double.parseDouble(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : (int)Double.parseDouble(value))) < 0 || level > 100) return;
                        this.writeOutput(address, 65535, 0x200 | level);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 42: 
            case 58: 
            case 153: 
            case 159: 
            case 169: 
            case 175: {
                String portNameLowerCase = portName.toLowerCase();
                if (portNameLowerCase.equals("mode")) {
                    if (value.equalsIgnoreCase("summer")) {
                        this.writeOutput(address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("winter")) return;
                        this.writeOutput(address, 16384, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan")) {
                    if (value.equalsIgnoreCase("min")) {
                        this.writeOutput(address, 60, 4);
                        return;
                    } else if (value.equalsIgnoreCase("med")) {
                        this.writeOutput(address, 60, 8);
                        return;
                    } else if (value.equalsIgnoreCase("max")) {
                        this.writeOutput(address, 60, 16);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 60, 32);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.mode")) {
                    if (value.equalsIgnoreCase("man")) {
                        this.writeOutput(address, 64, 64);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("auto")) return;
                        this.writeOutput(address, 64, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("setpoint")) {
                    if (value.equalsIgnoreCase("1")) {
                        this.writeOutput(address, 7936, 256);
                        return;
                    } else if (value.equalsIgnoreCase("2")) {
                        this.writeOutput(address, 7936, 512);
                        return;
                    } else if (value.equalsIgnoreCase("3")) {
                        this.writeOutput(address, 7936, 1024);
                        return;
                    } else if (value.equalsIgnoreCase("off") || value.equals("0")) {
                        this.writeOutput(address, 7936, 2048);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("man")) return;
                        this.writeOutput(address, 7936, 4096);
                    }
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.1")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 1, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.2")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 2, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.3")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 3, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.man")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 4, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.mode")) {
                    if (value.equalsIgnoreCase("man")) {
                        this.writeOutput(address, 8192, 8192);
                        return;
                    } else if (value.equalsIgnoreCase("auto")) {
                        this.writeOutput(address, 8192, 0);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 8192, 8192);
                        this.writeOutput(address, 7936, 2048);
                    }
                    return;
                } else {
                    boolean winter;
                    if (!portNameLowerCase.startsWith("program.")) return;
                    if (portNameLowerCase.indexOf("winter") == 8) {
                        winter = true;
                    } else {
                        if (portNameLowerCase.indexOf("summer") != 8) return;
                        winter = false;
                    }
                    if (value.equalsIgnoreCase("refresh")) {
                        if (portNameLowerCase.length() == 14) {
                            int i2 = 1;
                            while (i2 <= 7) {
                                if (device.type == 42 || device.type == 58) {
                                    this.readDF8RITProgram(true, device.address, i2, winter);
                                } else {
                                    this.readDFCTProgram(true, device.address, i2, winter);
                                }
                                ++i2;
                            }
                            return;
                        } else {
                            int day = Integer.parseInt(portNameLowerCase.substring(15));
                            if (device.type == 42 || device.type == 58) {
                                this.readDF8RITProgram(true, device.address, day, winter);
                                return;
                            } else {
                                this.readDFCTProgram(true, device.address, day, winter);
                            }
                        }
                        return;
                    } else if (value.length() == 48) {
                        int day = Integer.parseInt(portNameLowerCase.substring(15));
                        if (day < 1 || day > 7) return;
                        if (device.type == 42 || device.type == 58) {
                            this.writeDF8RITProgram(device.address, day, winter, value);
                            return;
                        } else {
                            this.writeDFCTProgram(device.address, day, winter, value);
                        }
                        return;
                    } else {
                        if (value.length() != 1) return;
                        int day = Integer.parseInt(portNameLowerCase.substring(15, 16));
                        int period = Integer.parseInt(portNameLowerCase.substring(17));
                        int level = Integer.parseInt(value);
                        if (level < 0 || level > 3 || day < 1 || day > 7 || period < 0 || period > 47) return;
                        if (device.type == 42 || device.type == 58) {
                            this.writeDF8RITProgram(device.address, period, day, winter, level);
                            return;
                        } else {
                            this.writeDFCTProgram(device.address, period, day, winter, level);
                        }
                    }
                }
                return;
            }
            case 89: 
            case 105: {
                String portNameLowerCase = portName.toLowerCase();
                if (portNameLowerCase.equals("mode")) {
                    if (value.equalsIgnoreCase("summer")) {
                        this.writeOutput(address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("winter")) return;
                        this.writeOutput(address, 16384, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("setpoint")) {
                    if (value.equalsIgnoreCase("comfort") || value.equalsIgnoreCase("1")) {
                        this.writeOutput(address, 2816, 256);
                        return;
                    } else if (value.equalsIgnoreCase("eco") || value.equalsIgnoreCase("2")) {
                        this.writeOutput(address, 2816, 512);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(address, 2816, 2048);
                    }
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.comfort")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 1, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.eco")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 2, 65535, level);
                    return;
                } else {
                    int level;
                    if (!portNameLowerCase.equals("setpoint.temp.limit") || (level = (int)(Math.round(Double.parseDouble(value)) + 2730L)) < 2830 || level > 3085) return;
                    this.writeOutput(address + 3, 65535, level);
                }
                return;
            }
            case 170: 
            case 186: {
                String portNameLowerCase = portName.toLowerCase();
                if (portNameLowerCase.equals("mode")) {
                    if (value.equalsIgnoreCase("summer")) {
                        this.writeOutput(address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("winter")) return;
                        this.writeOutput(address, 16384, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan")) {
                    if (value.equalsIgnoreCase("min")) {
                        this.writeOutput(address, 60, 4);
                        return;
                    } else if (value.equalsIgnoreCase("med")) {
                        this.writeOutput(address, 60, 8);
                        return;
                    } else if (value.equalsIgnoreCase("max")) {
                        this.writeOutput(address, 60, 16);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 60, 32);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.mode")) {
                    if (value.equalsIgnoreCase("man")) {
                        this.writeOutput(address, 64, 64);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("auto")) return;
                        this.writeOutput(address, 64, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("setpoint")) {
                    if (value.equalsIgnoreCase("comfort") || value.equalsIgnoreCase("1")) {
                        this.writeOutput(address, 2816, 256);
                        return;
                    } else if (value.equalsIgnoreCase("eco") || value.equalsIgnoreCase("2")) {
                        this.writeOutput(address, 2816, 512);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(address, 2816, 2048);
                    }
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.comfort")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 1, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.eco")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 2, 65535, level);
                    return;
                } else if (portNameLowerCase.equals("setpoint.temp.limit")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2830 || level > 3085) return;
                    this.writeOutput(address + 3, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("dewpoint.limit.1")) {
                    int level;
                    int n2 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(address + 4, 65535, level);
                    return;
                } else {
                    int level;
                    if (!portName.equalsIgnoreCase("dewpoint.limit.2")) return;
                    int n3 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(address + 5, 65535, level);
                }
                return;
            }
            case 191: {
                if (portName.equalsIgnoreCase("temp")) {
                    int level;
                    int n4 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("lux")) {
                    int level;
                    int n5 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value);
                    if (level < 0) return;
                    this.writeOutput(address + 1, 65535, level);
                    return;
                } else {
                    int level;
                    if (!portName.equalsIgnoreCase("wind")) return;
                    int n6 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value);
                    if (level < 0) return;
                    this.writeOutput(address + 2, 65535, level);
                }
                return;
            }
            case 232: {
                if (portName.equalsIgnoreCase("dewpoint.limit.1")) {
                    int level;
                    int n7 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(address, 65535, level);
                    return;
                } else {
                    int level;
                    if (!portName.equalsIgnoreCase("dewpoint.limit.2")) return;
                    int n8 = level = value.equalsIgnoreCase("off") ? 0 : (int)Double.parseDouble(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(address + 1, 65535, level);
                }
                return;
            }
            case 73: {
                if (portName.equalsIgnoreCase("ae")) {
                    if (!value.equalsIgnoreCase("reset")) return;
                    this.writeOutput(address, 256, 65535);
                    this.writeOutput(address, 256, 0);
                    return;
                } else if (portName.equalsIgnoreCase("buzzer")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 512, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 512, 0);
                    }
                    return;
                } else {
                    int port = Integer.parseInt(portName);
                    if (port <= 0 || port > 8) return;
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 1 << port - 1, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 1 << port - 1, 0);
                    }
                }
                return;
            }
            case 234: {
                if (portName.equalsIgnoreCase("ae")) {
                    if (!value.equalsIgnoreCase("reset")) return;
                    this.writeOutput(address, 256, 65535);
                    this.writeOutput(address, 256, 0);
                    return;
                } else {
                    int port = Integer.parseInt(portName);
                    if (port <= 0 || port > 8) return;
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 1 << port - 1, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 1 << port - 1, 0);
                    }
                }
                return;
            }
            case 10: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port > 8) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(address, 1 << port - 1, 65535);
                    return;
                }
                if (value.equals("0") || value.equalsIgnoreCase("off")) {
                    this.writeOutput(address, 1 << port - 1, 0);
                    return;
                }
                if (value.equalsIgnoreCase("stop")) {
                    switch (port) {
                        case 1: {
                            this.writeOutput(address, 3, 0);
                            return;
                        }
                        case 3: {
                            this.writeOutput(address, 12, 0);
                            return;
                        }
                        case 5: {
                            this.writeOutput(address, 48, 0);
                            return;
                        }
                        case 7: {
                            this.writeOutput(address, 192, 0);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (value.equalsIgnoreCase("up")) {
                    switch (port) {
                        case 1: {
                            this.writeOutput(address, 3, 85);
                            return;
                        }
                        case 3: {
                            this.writeOutput(address, 12, 85);
                            return;
                        }
                        case 5: {
                            this.writeOutput(address, 48, 85);
                            return;
                        }
                        case 7: {
                            this.writeOutput(address, 192, 85);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (!value.equalsIgnoreCase("down")) return;
                switch (port) {
                    case 1: {
                        this.writeOutput(address, 3, 170);
                        return;
                    }
                    case 3: {
                        this.writeOutput(address, 12, 170);
                        return;
                    }
                    case 5: {
                        this.writeOutput(address, 48, 170);
                        return;
                    }
                    case 7: {
                        this.writeOutput(address, 192, 170);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 26: {
                int index;
                int level;
                if (portName != null || (level = value.endsWith("%") ? (int)Double.parseDouble(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : (int)Double.parseDouble(value))) < 0 || level > 100) return;
                this.writeOutput(address, 127, level);
                return;
            }
            case 74: {
                int port = Integer.parseInt(portName);
                if (port > 0 && port <= 4) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 1 << port - 1, 65535);
                        return;
                    }
                    if (value.equals("0") || value.equalsIgnoreCase("off")) {
                        this.writeOutput(address, 1 << port - 1, 0);
                        return;
                    }
                    if (value.equalsIgnoreCase("stop")) {
                        switch (port) {
                            case 1: {
                                this.writeOutput(address, 3, 0);
                                return;
                            }
                            case 3: {
                                this.writeOutput(address, 12, 0);
                                return;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if (value.equalsIgnoreCase("up")) {
                        switch (port) {
                            case 1: {
                                this.writeOutput(address, 3, 85);
                                return;
                            }
                            case 3: {
                                this.writeOutput(address, 12, 85);
                                return;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                    if (!value.equalsIgnoreCase("down")) return;
                    switch (port) {
                        case 1: {
                            this.writeOutput(address, 3, 170);
                            return;
                        }
                        case 3: {
                            this.writeOutput(address, 12, 170);
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (port <= 4 || port > 8 || !deviceName.toLowerCase().startsWith("v")) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(address, 1 << port - 1, 0);
                }
                return;
            }
            case 90: {
                int index;
                int level;
                if (portName != null || (level = value.endsWith("%") ? (int)Double.parseDouble(value.substring(0, value.length() - 1)) : ((index = value.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1))) : (int)Double.parseDouble(value))) < 0 || level > 100) return;
                this.writeOutput(address, 127, level);
                return;
            }
            case 25: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port >= 5) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(address, 1 << port - 1, 0);
                }
                return;
            }
            case 41: {
                int level = (int)Double.parseDouble(value);
                if (level < 0 || level > 65535) return;
                this.writeOutput(address, 65535, level);
                return;
            }
            case 138: {
                String portNameLowerCase = portName.toLowerCase();
                if (portNameLowerCase.equals("power")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(address, 1, 1);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(address, 1, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.speed.1")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 2, 2);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 2, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.speed.2")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 4, 4);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 4, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.speed.3")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 8, 8);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 8, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.speed.4")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 16, 16);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 16, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("mode")) {
                    if (value.equalsIgnoreCase("auto")) {
                        this.writeOutput(address, 992, 32);
                        return;
                    } else if (value.equalsIgnoreCase("heating")) {
                        this.writeOutput(address, 992, 64);
                        return;
                    } else if (value.equalsIgnoreCase("cooling")) {
                        this.writeOutput(address, 992, 128);
                        return;
                    } else if (value.equalsIgnoreCase("fan")) {
                        this.writeOutput(address, 992, 256);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("dehum")) return;
                        this.writeOutput(address, 992, 512);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.position.1")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 1024, 1024);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 1024, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.position.2")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 2048, 2048);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 2048, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.position.3")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 4096, 4096);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 4096, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.position.4")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 8192, 8192);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 8192, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("fan.swing")) {
                    if (value.equals("1")) {
                        this.writeOutput(address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(address, 16384, 0);
                    }
                    return;
                } else {
                    int level;
                    if (!portNameLowerCase.equals("setpoint.temp") || (level = (int)(Math.round(Double.parseDouble(value)) + 2730L)) < 2830 || level > 3085) return;
                    this.writeOutput(address + 1, 65535, level);
                }
                return;
            }
        }
    }

    /*
     * Opcode count of 14736 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * Unable to fully structure code
     */
    private void deviceStateWrite(boolean events, boolean input, int address, int type, byte[] data, int baseaddress) {
        pointer = input != false ? 2 * address - baseaddress : 1024 + 2 * address - baseaddress;
        setpointvalue = new int[4];
        switch (type) {
            case 65: 
            case 97: 
            case 145: {
                if (input) {
                    i = 0;
                    while (i < 4) {
                        this.ioWrite(events, 1, "i", address, Integer.toString(i + 1), (data[pointer + 1] & 1 << i) > 0 ? "1" : "0");
                        ++i;
                    }
                }
                return;
            }
            case 217: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "5", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "6", (data[pointer + 1] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "slap", (data[pointer + 1] & 64) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "proximity", (data[pointer + 1] & 128) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "led.1", (data[pointer] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "led.2", (data[pointer] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "led.3", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "led.4", (data[pointer] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "led.5", (data[pointer] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "led.6", (data[pointer] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "fault", (data[pointer] & 64) > 0 ? "1" : "0");
                } else {
                    this.ioWrite(events, 1, "o", address, "led.1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "led.2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "led.3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "led.4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "led.5", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "led.6", (data[pointer + 1] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "disable", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "dim", (data[pointer] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "proximity", (data[pointer] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "backlight", (data[pointer] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "buzzer", (data[pointer] & 64) > 0 ? "1" : "0");
                }
                return;
            }
            case 113: {
                if (input) {
                    value = 1;
                    i = 1;
                    while (i < 9) {
                        this.ioWrite(events, 1, "i", address, Integer.toString(i), (data[pointer + 1] & value) > 0 ? "1" : "0");
                        value <<= 1;
                        ++i;
                    }
                    value = 1;
                    i = 9;
                    while (i < 16) {
                        this.ioWrite(events, 1, "i", address, Integer.toString(i), (data[pointer] & value) > 0 ? "1" : "0");
                        value <<= 1;
                        ++i;
                    }
                }
                return;
            }
            case 129: {
                return;
            }
            case 161: {
                return;
            }
            case 34: {
                if (!input) {
                    this.ioWrite(events, 1, "o", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                }
                return;
            }
            case 66: 
            case 82: {
                if (!input) {
                    this.ioWrite(events, 1, "o", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                }
                return;
            }
            case 130: 
            case 146: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                } else {
                    this.ioWrite(events, 1, "o", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                }
                return;
            }
            case 243: {
                if (!input) {
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 128) > 0 ? "1" : "0");
                }
            }
            case 19: 
            case 35: 
            case 51: 
            case 67: 
            case 83: 
            case 99: 
            case 211: 
            case 227: {
                if (!input) {
                    if ((data[pointer] & 128) > 0) {
                        this.ioWrite(events, -1, "o", address, null, "program");
                    } else if ((data[pointer] & 64) > 0) {
                        this.ioWrite(events, -1, "o", address, null, "fault");
                    } else if ((data[pointer] & 32) > 0) {
                        this.ioWrite(events, -1, "o", address, null, "auto");
                    } else {
                        this.ioWrite(events, -1, "o", address, null, "man");
                    }
                    value = data[pointer + 1] & 127;
                    if (value > 0 && value <= 100) {
                        this.ioWrite(events, 11, "o", address, "1", String.valueOf(value) + "%");
                    } else if (value == 0) {
                        this.ioWrite(events, 11, "o", address, "1", "off");
                    }
                }
                return;
            }
            case 147: {
                return;
            }
            case 163: {
                if (input) {
                    this.ioWrite(events, -1, "i", address, "polling", (data[pointer] & 4) > 0 ? "off" : "on");
                    this.ioWrite(events, -1, "i", address, "test", (data[pointer] & 16) > 0 ? "1" : "0");
                    if ((data[pointer] & 8) > 0) {
                        this.ioWrite(events, -1, "i", address, "dali", "nopower");
                    } else if ((data[pointer] & 64) > 0) {
                        this.ioWrite(events, -1, "i", address, "dali", "open");
                    } else if ((data[pointer] & 128) > 0) {
                        this.ioWrite(events, -1, "i", address, "dali", "short");
                    } else {
                        this.ioWrite(events, -1, "i", address, "dali", "on");
                    }
                    value = data[pointer + 1] & 255;
                    switch (value) {
                        case 255: {
                            break;
                        }
                        case 128: {
                            this.ioWrite(events, 11, "i", address, "1", "fault");
                            break;
                        }
                        case 129: {
                            this.ioWrite(events, 11, "i", address, "1", "unknown");
                            break;
                        }
                        case 0: {
                            this.ioWrite(events, 11, "i", address, "1", "off");
                            break;
                        }
                        default: {
                            this.ioWrite(events, 11, "i", address, "1", String.valueOf(Integer.toString(value)) + "%");
                        }
                    }
                }
                return;
            }
            case 179: {
                if (input) {
                    i = 0;
                    while (i < 16) {
                        port = i + 1;
                        if (!this.dfdali64Group.contains(address * 100 + port)) {
                            if ((data[pointer + (i < 8 ? 3 : 2)] & 1 << (i < 8 ? i : i - 8)) > 0) {
                                this.ioWrite(events, 1, "i", address, "group." + port, "1");
                                m = this.ioRead("o", address, "group." + port + ".memory");
                                if (m == null) {
                                    level = 100;
                                    this.ioStore("o", address, "group." + port + ".memory", "100");
                                } else {
                                    level = (int)Double.parseDouble(m);
                                }
                                this.ioWrite(true, 11, "o", address, "group." + port, level == 0 ? "off" : String.valueOf(level) + "%");
                            } else {
                                this.ioWrite(events, 1, "i", address, "group." + port, "0");
                                this.ioWrite(events, 11, "o", address, "group." + port, "off");
                            }
                        }
                        ++i;
                    }
                    this.ioWrite(events, -1, "i", address, "on", (data[pointer] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "polling", (data[pointer] & 4) > 0 ? "off" : "on");
                    this.ioWrite(events, -1, "i", address, "test", (data[pointer] & 16) > 0 ? "1" : "0");
                    if ((data[pointer] & 8) > 0) {
                        this.ioWrite(events, -1, "i", address, "dali", "nopower");
                    } else if ((data[pointer] & 64) > 0) {
                        this.ioWrite(events, -1, "i", address, "dali", "open");
                    } else if ((data[pointer] & 128) > 0) {
                        this.ioWrite(events, -1, "i", address, "dali", "short");
                    } else {
                        this.ioWrite(events, -1, "i", address, "dali", "on");
                    }
                    value = data[pointer + 1] & 255;
                    switch (value) {
                        case 130: 
                        case 131: 
                        case 255: {
                            break;
                        }
                        case 128: {
                            this.ioWrite(events, 11, "i", address, "1", "fault");
                            break;
                        }
                        case 129: {
                            this.ioWrite(events, 11, "i", address, "1", "unknown");
                            break;
                        }
                        case 0: {
                            this.ioWrite(events, 11, "i", address, "1", "off");
                            break;
                        }
                        default: {
                            this.ioWrite(events, 11, "i", address, "1", String.valueOf(Integer.toString(value)) + "%");
                        }
                    }
                }
                return;
            }
            case 195: {
                if (input && (v = this.dfdali64GroupAddress.get(address)) != null) {
                    base_address = v / 100;
                    group = v % 100;
                    level = data[pointer + 1] & 255;
                    switch (level) {
                        case 0: {
                            this.ioWrite(events, 1, "i", base_address, "group." + group, "0");
                            this.ioWrite(true, 11, "o", base_address, "group." + group, "off");
                            break;
                        }
                        case 255: {
                            this.ioWrite(events, 1, "i", base_address, "group." + group, "unknown");
                            this.ioWrite(true, 11, "o", base_address, "group." + group, "unknown");
                            break;
                        }
                        default: {
                            this.ioWrite(events, 1, "i", base_address, "group." + group, "1");
                            this.ioWrite(true, 11, "o", base_address, "group." + group, String.valueOf(level) + "%");
                        }
                    }
                }
                return;
            }
            case 52: {
                if (!input) {
                    switch (data[pointer + 1] & 3) {
                        case 1: {
                            this.ioWrite(events, 2, "o", address, "1", "up");
                            break;
                        }
                        case 2: {
                            this.ioWrite(events, 2, "o", address, "1", "down");
                            break;
                        }
                        case 0: {
                            state = this.ioRead("o", address, "1");
                            if (state == null) {
                                this.ioWrite(events, 2, "o", address, "1", "unknown");
                                break;
                            }
                            if (state.equals("up")) {
                                this.ioWrite(events, 2, "o", address, "1", "offup");
                                break;
                            }
                            if (!state.equals("down")) break;
                            this.ioWrite(events, 2, "o", address, "1", "offdown");
                        }
                    }
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                }
                return;
            }
            case 36: 
            case 68: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                } else if (this.dftpPositionEnabled.get(address - 1)) {
                    i = 1;
                    while (i <= 2) {
                        is = Integer.toString(i);
                        switch ((data[i == 1 ? pointer + 1 : pointer] & 192) >> 6) {
                            case 1: {
                                this.ioWrite(events, 2, "o", address, is, "up");
                                break;
                            }
                            case 2: {
                                this.ioWrite(events, 2, "o", address, is, "down");
                                break;
                            }
                            case 0: {
                                state = this.ioRead("o", address, is);
                                if (state == null) {
                                    this.ioWrite(events, 2, "o", address, is, "unknown");
                                    break;
                                }
                                if (state.equals("up")) {
                                    this.ioWrite(events, 2, "o", address, is, "offup");
                                    break;
                                }
                                if (!state.equals("down")) break;
                                this.ioWrite(events, 2, "o", address, is, "offdown");
                            }
                        }
                        value = data[i == 1 ? pointer + 1 : pointer] & 63;
                        if (value >= 0 && value <= 50) {
                            this.ioWrite(events, -1, "o", address, String.valueOf(is) + ".value", String.valueOf(value * 2) + "%");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + "." + is, "value", Integer.toString(value * 2));
                        }
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i <= 2) {
                        is = Integer.toString(i);
                        switch (data[pointer + 1] & (i == 1 ? 3 : 12)) {
                            case 1: 
                            case 4: {
                                this.ioWrite(events, 2, "o", address, is, "up");
                                break;
                            }
                            case 2: 
                            case 8: {
                                this.ioWrite(events, 2, "o", address, is, "down");
                                break;
                            }
                            case 0: {
                                state = this.ioRead("o", address, is);
                                if (state == null) {
                                    this.ioWrite(events, 2, "o", address, is, "unknown");
                                    break;
                                }
                                if (state.equals("up")) {
                                    this.ioWrite(events, 2, "o", address, is, "offup");
                                    break;
                                }
                                if (!state.equals("down")) break;
                                this.ioWrite(events, 2, "o", address, is, "offdown");
                            }
                        }
                        ++i;
                    }
                }
                return;
            }
            case 21: {
                return;
            }
            case 69: 
            case 133: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                } else {
                    this.ioWrite(events, 1, "v", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "v", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "v", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "v", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                }
                return;
            }
            case 85: {
                return;
            }
            case 117: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                } else {
                    this.ioWrite(events, 1, "o", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                }
                return;
            }
            case 149: {
                return;
            }
            case 165: {
                return;
            }
            case 24: 
            case 40: 
            case 56: {
                value = ((data[pointer] & 255) << 8) + (data[pointer + 1] & 255) - 2730;
                if (this.ioWrite(events, -1, "i", address, "temp", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                return;
            }
            case 136: {
                if (input) {
                    this.ioWrite(events, -1, "i", address, null, Integer.toString(((data[pointer] & 255) << 8) + (data[pointer + 1] & 255)));
                    this.ioWrite(events, -1, "i", address + 1, null, Integer.toString(((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255)));
                }
                return;
            }
            case 248: {
                if (input) {
                    this.ioWrite(events, -1, "i", address, null, Integer.toString(((data[pointer] & 255) << 8) + (data[pointer + 1] & 255)));
                }
                return;
            }
            case 42: 
            case 153: 
            case 159: 
            case 169: 
            case 175: {
                if (!input) ** GOTO lbl663
                if ((data[pointer] & 64) > 0) {
                    if (this.ioWrite(events, -1, "i", address, "mode", "summer")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode", "value", Domino.TEXT[this.language][2]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.summer", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.winter", "visible", "false");
                    }
                } else if (this.ioWrite(events, -1, "i", address, "mode", "winter")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode", "value", Domino.TEXT[this.language][3]);
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.summer", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.winter", "visible", "true");
                }
                switch (data[pointer + 1] & 3) {
                    case 0: {
                        if (!this.ioWrite(events, -1, "i", address, "status", "off")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][1]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "false");
                        break;
                    }
                    case 1: {
                        if (!this.ioWrite(events, -1, "i", address, "status", "heating")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][0]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "false");
                        break;
                    }
                    case 2: {
                        if (!this.ioWrite(events, -1, "i", address, "status", "cooling")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][0]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "true");
                    }
                }
                if ((data[pointer + 1] & 32) != 0) ** GOTO lbl547
                switch (data[pointer + 1] & 28) {
                    case 4: {
                        if (this.ioWrite(events, -1, "i", address, "fan", "min")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][7]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "false");
                            break;
                        }
                        ** GOTO lbl556
                    }
                    case 8: {
                        if (this.ioWrite(events, -1, "i", address, "fan", "med")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][8]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "false");
                            break;
                        }
                        ** GOTO lbl556
                    }
                    case 16: {
                        if (!this.ioWrite(events, -1, "i", address, "fan", "max")) ** GOTO lbl556
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][9]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "true");
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                ** GOTO lbl556
lbl547:
                // 1 sources

                if (this.ioWrite(events, -1, "i", address, "fan", "off")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][1]);
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "false");
                }
lbl556:
                // 7 sources

                if ((data[pointer + 1] & 64) > 0) {
                    this.ioWrite(events, -1, "i", address, "fan.mode", "man");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.mode", "value", Domino.TEXT[this.language][(data[pointer + 1] & 32) == 0 ? 5 : 1]);
                } else if (this.ioWrite(events, -1, "i", address, "fan.mode", "auto")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.mode", "value", Domino.TEXT[this.language][4]);
                }
                switch (data[pointer] & 31) {
                    case 1: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "1")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint", "value", "1");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        break;
                    }
                    case 2: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "2")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint", "value", "2");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        break;
                    }
                    case 4: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "3")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint", "value", "3");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        break;
                    }
                    case 8: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "off")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint", "value", Domino.TEXT[this.language][1]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        break;
                    }
                    case 16: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "man")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint", "value", Domino.TEXT[this.language][5]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "true");
                    }
                }
                if ((data[pointer] & 32) > 0) {
                    if ((data[pointer] & 31) == 8) {
                        if (this.ioWrite(events, -1, "i", address, "setpoint.mode", "off")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][1]);
                        }
                    } else if (this.ioWrite(events, -1, "i", address, "setpoint.mode", "man")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][5]);
                    }
                } else if (this.ioWrite(events, -1, "i", address, "setpoint.mode", "auto")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][4]);
                }
                if ((data[pointer + 1] & 128) > 0) {
                    if (this.ioWrite(events, -1, "i", address, "temp", "fault")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", Domino.TEXT[this.language][6]);
                    }
                } else {
                    value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730;
                    if (this.ioWrite(events, -1, "i", address, "temp", Integer.toString(value))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                    }
                }
                ** GOTO lbl748
lbl663:
                // 1 sources

                if ((data[pointer + 1] & 32) == 0) {
                    switch (data[pointer + 1] & 28) {
                        case 4: {
                            this.ioWrite(events, -1, "o", address, "fan", "min");
                            break;
                        }
                        case 8: {
                            this.ioWrite(events, -1, "o", address, "fan", "med");
                            break;
                        }
                        case 16: {
                            this.ioWrite(events, -1, "o", address, "fan", "max");
                        }
                    }
                } else {
                    this.ioWrite(events, -1, "o", address, "fan", "off");
                }
                if ((data[pointer + 1] & 64) > 0) {
                    this.ioWrite(events, -1, "o", address, "fan.mode", "man");
                } else {
                    this.ioWrite(events, -1, "o", address, "fan.mode", "auto");
                }
                if ((data[pointer] & 32) > 0) {
                    this.ioWrite(events, -1, "o", address, "setpoint.mode", "man");
                } else {
                    this.ioWrite(events, -1, "o", address, "setpoint.mode", "auto");
                }
                if ((data[pointer] & 64) > 0) {
                    this.ioWrite(events, -1, "o", address, "mode", "summer");
                } else {
                    this.ioWrite(events, -1, "o", address, "mode", "winter");
                }
                setpointvalue[0] = value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730;
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.1", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.1", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                setpointvalue[1] = value = ((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255) - 2730;
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.2", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.2", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                setpointvalue[2] = value = ((data[pointer + 6] & 255) << 8) + (data[pointer + 7] & 255) - 2730;
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.3", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.3", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                setpointvalue[3] = value = ((data[pointer + 8] & 255) << 8) + (data[pointer + 9] & 255) - 2730;
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.man", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.man", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                switch (data[pointer] & 31) {
                    case 1: {
                        if (this.ioWrite(events, -1, "o", address, "setpoint", "1")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                        }
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", String.valueOf((double)setpointvalue[0] / 10.0) + " &deg;C");
                        break;
                    }
                    case 2: {
                        if (this.ioWrite(events, -1, "o", address, "setpoint", "2")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                        }
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", String.valueOf((double)setpointvalue[1] / 10.0) + " &deg;C");
                        break;
                    }
                    case 4: {
                        if (this.ioWrite(events, -1, "o", address, "setpoint", "3")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                        }
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", String.valueOf((double)setpointvalue[2] / 10.0) + " &deg;C");
                        break;
                    }
                    case 8: {
                        if (!this.ioWrite(events, -1, "o", address, "setpoint", "off")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", Domino.TEXT[this.language][1]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "false");
                        break;
                    }
                    case 16: {
                        if (this.ioWrite(events, -1, "o", address, "setpoint", "man")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                        }
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", String.valueOf((double)setpointvalue[3] / 10.0) + " &deg;C");
                    }
                }
lbl748:
                // 9 sources

                return;
            }
            case 58: {
                if (input && this.ioWrite(events, -1, "i", address, "temp", Integer.toString(value = ((data[pointer] & 255) << 8) + (data[pointer + 1] & 255) - 2730))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                return;
            }
            case 89: 
            case 105: {
                if (input) {
                    if ((data[pointer] & 64) > 0) {
                        if (this.ioWrite(events, -1, "i", address, "mode", "summer")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode", "value", Domino.TEXT[this.language][2]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.summer", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.winter", "visible", "false");
                        }
                    } else if (this.ioWrite(events, -1, "i", address, "mode", "winter")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode", "value", Domino.TEXT[this.language][3]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.summer", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.winter", "visible", "true");
                    }
                    switch (data[pointer + 1] & 3) {
                        case 0: {
                            if (!this.ioWrite(events, -1, "i", address, "status", "off")) break;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][1]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "false");
                            break;
                        }
                        case 1: {
                            if (!this.ioWrite(events, -1, "i", address, "status", "heating")) break;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][0]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "false");
                            break;
                        }
                        case 2: {
                            if (!this.ioWrite(events, -1, "i", address, "status", "cooling")) break;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][0]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "true");
                        }
                    }
                    value = ((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255) - 2730;
                    if (this.ioWrite(events, -1, "i", address, "setpoint.temp", Integer.toString(value))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.group", "visible", "false");
                    }
                    switch (data[pointer] & 11) {
                        case 1: {
                            if (!this.ioWrite(events, -1, "i", address, "setpoint", "comfort")) break;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][17]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                            break;
                        }
                        case 2: {
                            if (!this.ioWrite(events, -1, "i", address, "setpoint", "eco")) break;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][18]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                            break;
                        }
                        case 8: {
                            if (!this.ioWrite(events, -1, "i", address, "setpoint", "off")) break;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][1]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "false");
                        }
                    }
                    if ((data[pointer + 1] & 128) > 0) {
                        if (this.ioWrite(events, -1, "i", address, "temp", "fault")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", Domino.TEXT[this.language][6]);
                        }
                    } else {
                        value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730;
                        if (this.ioWrite(events, -1, "i", address, "temp", Integer.toString(value))) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                        }
                    }
                } else {
                    if ((data[pointer] & 64) > 0) {
                        this.ioWrite(events, -1, "o", address, "mode", "summer");
                    } else {
                        this.ioWrite(events, -1, "o", address, "mode", "winter");
                    }
                    value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730;
                    if (this.ioWrite(events, -1, "o", address, "setpoint.temp.comfort", Integer.toString(value))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.1", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                    }
                    if (this.ioWrite(events, -1, "o", address, "setpoint.temp.eco", Integer.toString(value = ((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255) - 2730))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.2", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                    }
                    if (this.ioWrite(events, -1, "o", address, "setpoint.temp.limit", Integer.toString(value = ((data[pointer + 6] & 255) << 8) + (data[pointer + 7] & 255) - 2730))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.man", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                    }
                    switch (data[pointer] & 11) {
                        case 1: {
                            this.ioWrite(events, -1, "o", address, "setpoint", "comfort");
                            break;
                        }
                        case 2: {
                            this.ioWrite(events, -1, "o", address, "setpoint", "eco");
                            break;
                        }
                        case 8: {
                            this.ioWrite(events, -1, "o", address, "setpoint", "off");
                        }
                    }
                }
                return;
            }
            case 170: 
            case 186: {
                if (!input) ** GOTO lbl1081
                if ((data[pointer] & 64) > 0) {
                    if (this.ioWrite(events, -1, "i", address, "mode", "summer")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode", "value", Domino.TEXT[this.language][2]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.summer", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.winter", "visible", "false");
                    }
                } else if (this.ioWrite(events, -1, "i", address, "mode", "winter")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode", "value", Domino.TEXT[this.language][3]);
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.summer", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".mode.label.winter", "visible", "true");
                }
                switch (data[pointer + 1] & 3) {
                    case 0: {
                        if (!this.ioWrite(events, -1, "i", address, "status", "off")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][1]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "false");
                        break;
                    }
                    case 1: {
                        if (!this.ioWrite(events, -1, "i", address, "status", "heating")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][0]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "false");
                        break;
                    }
                    case 2: {
                        if (!this.ioWrite(events, -1, "i", address, "status", "cooling")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status", "value", Domino.TEXT[this.language][0]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.heating", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".status.label.cooling", "visible", "true");
                    }
                }
                value = ((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255) - 2730;
                if (this.ioWrite(events, -1, "i", address, "setpoint.temp", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                switch (data[pointer] & 11) {
                    case 1: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "comfort")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][17]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                        break;
                    }
                    case 2: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "eco")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][18]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "true");
                        break;
                    }
                    case 8: {
                        if (!this.ioWrite(events, -1, "i", address, "setpoint", "off")) break;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.mode", "value", Domino.TEXT[this.language][1]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.1", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.2", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.3", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.off", "visible", "true");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.label.man", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp", "visible", "false");
                    }
                }
                if ((data[pointer + 1] & 128) > 0) {
                    if (this.ioWrite(events, -1, "i", address, "temp", "fault")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", Domino.TEXT[this.language][6]);
                    }
                } else {
                    value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730;
                    if (this.ioWrite(events, -1, "i", address, "temp", Integer.toString(value))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                    }
                    if (this.ioWrite(events, -1, "i", address, "humidity", Integer.toString(value = ((data[pointer + 6] & 255) << 8) + (data[pointer + 7] & 255)))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".humidity", "value", String.valueOf(value) + " %");
                    }
                    if (this.ioWrite(events, -1, "i", address, "dewpoint", Integer.toString(value = ((data[pointer + 8] & 255) << 8) + (data[pointer + 9] & 255) - 2730))) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".dewpoint", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                    }
                }
                if (!this.dftz2FanEnabled.get(address - 1)) ** GOTO lbl1138
                if ((data[pointer + 1] & 32) != 0) ** GOTO lbl1063
                switch (data[pointer + 1] & 28) {
                    case 4: {
                        if (this.ioWrite(events, -1, "i", address, "fan", "min")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][7]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "false");
                            break;
                        }
                        ** GOTO lbl1072
                    }
                    case 8: {
                        if (this.ioWrite(events, -1, "i", address, "fan", "med")) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][8]);
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "false");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "true");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "false");
                            break;
                        }
                        ** GOTO lbl1072
                    }
                    case 16: {
                        if (!this.ioWrite(events, -1, "i", address, "fan", "max")) ** GOTO lbl1072
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][9]);
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "false");
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "true");
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                ** GOTO lbl1072
lbl1063:
                // 1 sources

                if (this.ioWrite(events, -1, "i", address, "fan", "off")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan", "value", Domino.TEXT[this.language][1]);
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.min", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.med", "visible", "false");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.label.max", "visible", "false");
                }
lbl1072:
                // 7 sources

                if ((data[pointer + 1] & 64) > 0) {
                    if (this.ioWrite(events, -1, "i", address, "fan.mode", "man")) {
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.mode", "value", Domino.TEXT[this.language][(data[pointer + 1] & 32) == 0 ? 5 : 1]);
                    }
                } else if (this.ioWrite(events, -1, "i", address, "fan.mode", "auto")) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".fan.mode", "value", Domino.TEXT[this.language][4]);
                }
                ** GOTO lbl1138
lbl1081:
                // 1 sources

                if ((data[pointer] & 64) > 0) {
                    this.ioWrite(events, -1, "o", address, "mode", "summer");
                } else {
                    this.ioWrite(events, -1, "o", address, "mode", "winter");
                }
                value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730;
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.comfort", Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.1", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.eco", Integer.toString(value = ((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255) - 2730))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.2", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                if (this.ioWrite(events, -1, "o", address, "setpoint.temp.limit", Integer.toString(value = ((data[pointer + 6] & 255) << 8) + (data[pointer + 7] & 255) - 2730))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".setpoint.temp.man", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                }
                if (this.ioWrite(events, -1, "o", address, "dewpoint.limit.1", (value = ((data[pointer + 8] & 255) << 8) + (data[pointer + 9] & 255) - 2730) == 0 ? "off" : Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".dewpoint.limit.1", "value", value == 0 ? "OFF" : String.valueOf((double)value / 10.0) + " &deg;C");
                }
                if (this.ioWrite(events, -1, "o", address, "dewpoint.limit.2", (value = ((data[pointer + 10] & 255) << 8) + (data[pointer + 11] & 255) - 2730) == 0 ? "off" : Integer.toString(value))) {
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address + ".dewpoint.limit.2", "value", value == 0 ? "OFF" : String.valueOf((double)value / 10.0) + " &deg;C");
                }
                switch (data[pointer] & 11) {
                    case 1: {
                        this.ioWrite(events, -1, "o", address, "setpoint", "comfort");
                        break;
                    }
                    case 2: {
                        this.ioWrite(events, -1, "o", address, "setpoint", "eco");
                        break;
                    }
                    case 8: {
                        this.ioWrite(events, -1, "o", address, "setpoint", "off");
                    }
                }
                if (this.dftz2FanEnabled.get(address - 1)) {
                    if ((data[pointer + 1] & 32) == 0) {
                        switch (data[pointer + 1] & 28) {
                            case 4: {
                                this.ioWrite(events, -1, "o", address, "fan", "min");
                                break;
                            }
                            case 8: {
                                this.ioWrite(events, -1, "o", address, "fan", "med");
                                break;
                            }
                            case 16: {
                                this.ioWrite(events, -1, "o", address, "fan", "max");
                            }
                        }
                    } else {
                        this.ioWrite(events, -1, "o", address, "fan", "off");
                    }
                    if ((data[pointer + 1] & 64) > 0) {
                        this.ioWrite(events, -1, "o", address, "fan.mode", "man");
                    } else {
                        this.ioWrite(events, -1, "o", address, "fan.mode", "auto");
                    }
                }
lbl1138:
                // 7 sources

                return;
            }
            case 249: {
                return;
            }
            case 15: {
                return;
            }
            case 63: {
                return;
            }
            case 191: {
                if (input) {
                    if ((data[pointer + 6] & 64) == 0) {
                        this.ioWrite(events, -1, "i", address, "temp", Integer.toString(((data[pointer] & 255) << 8) + (data[pointer + 1] & 255) - 2730));
                        this.ioWrite(events, -1, "i", address, "lux", Integer.toString(((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255)));
                        this.ioWrite(events, -1, "i", address, "wind", Integer.toString(((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255)));
                        this.ioWrite(events, -1, "i", address, "rain", (data[pointer + 7] & 1) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "night", (data[pointer + 7] & 2) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "temp.limit", (data[pointer + 7] & 4) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "lux.limit", (data[pointer + 7] & 8) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "wind.limit", (data[pointer + 7] & 16) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "light.south", (data[pointer + 7] & 32) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "light.west", (data[pointer + 7] & 64) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "light.east", (data[pointer + 7] & 128) > 0 ? "1" : "0");
                        this.ioWrite(events, -1, "i", address, "fault", "0");
                    } else {
                        this.ioWrite(events, -1, "i", address, "fault", "1");
                    }
                } else {
                    value = ((data[pointer] & 255) << 8) + (data[pointer + 1] & 255);
                    if (value == 0) {
                        this.ioWrite(events, -1, "o", address, "temp", "off");
                    } else {
                        this.ioWrite(events, -1, "o", address, "temp", Integer.toString(value - 2730));
                    }
                    this.ioWrite(events, -1, "o", address, "lux", Integer.toString(((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255)));
                    this.ioWrite(events, -1, "o", address, "wind", Integer.toString(((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255)));
                }
                return;
            }
            case 232: {
                if (input) {
                    this.ioWrite(events, -1, "i", address, "humidity", Integer.toString(((data[pointer] & 255) << 8) + (data[pointer + 1] & 255)));
                    this.ioWrite(events, -1, "i", address, "temp", Integer.toString(((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730));
                    this.ioWrite(events, -1, "i", address, "dewpoint", Integer.toString(((data[pointer + 4] & 255) << 8) + (data[pointer + 5] & 255) - 2730));
                    this.ioWrite(events, -1, "i", address, "dewpoint.limit.1", (data[pointer + 7] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "dewpoint.limit.2", (data[pointer + 7] & 2) > 0 ? "1" : "0");
                } else {
                    value = ((data[pointer] & 255) << 8) + (data[pointer + 1] & 255);
                    this.ioWrite(events, -1, "o", address, "dewpoint.limit.1", value == 0 ? "off" : Integer.toString(value - 2730));
                    value = ((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255);
                    this.ioWrite(events, -1, "o", address, "dewpoint.limit.2", value == 0 ? "off" : Integer.toString(value - 2730));
                }
                return;
            }
            case 121: {
                if (input) {
                    params = this.emDevicesParams.get(address);
                    partialdata = this.emDevicesPartialData.get(address);
                    if (params != null && partialdata != null) {
                        i = 0;
                        while (i < this.inputDevices.get((Object)Integer.valueOf((int)address)).size) {
                            switch (params[i]) {
                                case 100: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v12", Integer.toString(value));
                                    break;
                                }
                                case 102: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v23", Integer.toString(value));
                                    break;
                                }
                                case 104: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v31", Integer.toString(value));
                                    break;
                                }
                                case 106: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "vtm", Integer.toString(value));
                                    break;
                                }
                                case 108: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "i1", Integer.toString(value));
                                    break;
                                }
                                case 110: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "i2", Integer.toString(value));
                                    break;
                                }
                                case 112: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "i3", Integer.toString(value));
                                    break;
                                }
                                case 114: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "itm", Integer.toString(value));
                                    break;
                                }
                                case 116: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "ptot", Integer.toString(value));
                                    if (address != this.powerDisplayAddress || Math.abs(value - this.powerValue) <= this.powerSensivity) break;
                                    this.powerValue = value;
                                    SystemState.powerSet(value);
                                    break;
                                }
                                case 20596: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "ptotk", Integer.toString(value));
                                    if (address != this.powerDisplayAddress || Math.abs((value *= 1000) - this.powerValue) <= this.powerSensivity) break;
                                    this.powerValue = value;
                                    SystemState.powerSet(value);
                                    break;
                                }
                                case 118: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "qtot", Integer.toString(value));
                                    break;
                                }
                                case 20598: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "qtotk", Integer.toString(value));
                                    break;
                                }
                                case 12408: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "pf", Integer.toString(value));
                                    break;
                                }
                                case 122: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "frequency", Integer.toString(value));
                                    break;
                                }
                                case 124: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v1n", Integer.toString(value));
                                    break;
                                }
                                case 126: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v2n", Integer.toString(value));
                                    break;
                                }
                                case 128: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v3n", Integer.toString(value));
                                    break;
                                }
                                case 130: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p1", Integer.toString(value));
                                    break;
                                }
                                case 20610: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p1k", Integer.toString(value));
                                    break;
                                }
                                case 132: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p2", Integer.toString(value));
                                    break;
                                }
                                case 20612: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p2k", Integer.toString(value));
                                    break;
                                }
                                case 134: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p3", Integer.toString(value));
                                    break;
                                }
                                case 20614: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p3k", Integer.toString(value));
                                    break;
                                }
                                case 136: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "q1", Integer.toString(value));
                                    break;
                                }
                                case 20616: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "q1k", Integer.toString(value));
                                    break;
                                }
                                case 138: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "q2", Integer.toString(value));
                                    break;
                                }
                                case 20618: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "q2k", Integer.toString(value));
                                    break;
                                }
                                case 140: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "q3", Integer.toString(value));
                                    break;
                                }
                                case 20620: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "q3k", Integer.toString(value));
                                    break;
                                }
                                case 12430: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "pf1", Integer.toString(value));
                                    break;
                                }
                                case 12432: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "pf2", Integer.toString(value));
                                    break;
                                }
                                case 12434: {
                                    value = (short)(((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255));
                                    this.ioWrite(events, -1, "i", address, "pf3", Integer.toString(value));
                                    break;
                                }
                                case 148: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s1", Integer.toString(value));
                                    break;
                                }
                                case 20628: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s1k", Integer.toString(value));
                                    break;
                                }
                                case 150: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s2", Integer.toString(value));
                                    break;
                                }
                                case 20630: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s2k", Integer.toString(value));
                                    break;
                                }
                                case 152: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s3", Integer.toString(value));
                                    break;
                                }
                                case 20632: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s3k", Integer.toString(value));
                                    break;
                                }
                                case 154: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "stot", Integer.toString(value));
                                    break;
                                }
                                case 20634: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "stotk", Integer.toString(value));
                                    break;
                                }
                                case 24732: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "hours", Integer.toString(value));
                                    break;
                                }
                                case 158: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "temperature", Integer.toString(value));
                                    break;
                                }
                                case 16584: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[0][0] = new Integer(value);
                                    break;
                                }
                                case 4296: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[0][1] = new Integer(value);
                                    break;
                                }
                                case 8394: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[0][2] = new Integer(value);
                                    break;
                                }
                                case 16587: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[1][0] = new Integer(value);
                                    break;
                                }
                                case 4299: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[1][1] = new Integer(value);
                                    break;
                                }
                                case 8397: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[1][2] = new Integer(value);
                                    break;
                                }
                                case 16590: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[2][0] = new Integer(value);
                                    break;
                                }
                                case 4302: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[2][1] = new Integer(value);
                                    break;
                                }
                                case 8400: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[2][2] = new Integer(value);
                                    break;
                                }
                                case 16593: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[3][0] = new Integer(value);
                                    break;
                                }
                                case 4305: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[3][1] = new Integer(value);
                                    break;
                                }
                                case 8403: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[3][2] = new Integer(value);
                                    break;
                                }
                                case 212: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "pm", Integer.toString(value));
                                    break;
                                }
                                case 216: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "qm", Integer.toString(value));
                                }
                            }
                            ++i;
                        }
                    }
                }
                return;
            }
            case 229: {
                if (input) {
                    params = this.emDevicesParams.get(address);
                    partialdata = this.emDevicesPartialData.get(address);
                    if (params != null && partialdata != null) {
                        i = 0;
                        while (i < this.inputDevices.get((Object)Integer.valueOf((int)address)).size) {
                            switch (params[i]) {
                                case 12550: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v12", Integer.toString(value));
                                    break;
                                }
                                case 12552: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v23", Integer.toString(value));
                                    break;
                                }
                                case 12554: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v31", Integer.toString(value));
                                    break;
                                }
                                case 12576: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "vtm", Integer.toString(value));
                                    break;
                                }
                                case 8460: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "i1", Integer.toString(value));
                                    break;
                                }
                                case 8462: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "i2", Integer.toString(value));
                                    break;
                                }
                                case 8464: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "i3", Integer.toString(value));
                                    break;
                                }
                                case 8484: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "itm", Integer.toString(value));
                                    break;
                                }
                                case 4372: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "ptot", Integer.toString(value));
                                    if (address != this.powerDisplayAddress || Math.abs(value - this.powerValue) <= this.powerSensivity) break;
                                    this.powerValue = value;
                                    SystemState.powerSet(value);
                                    break;
                                }
                                case 16660: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "ptotk", Integer.toString(value));
                                    if (address != this.powerDisplayAddress || Math.abs((value *= 1000) - this.powerValue) <= this.powerSensivity) break;
                                    this.powerValue = value;
                                    SystemState.powerSet(value);
                                    break;
                                }
                                case 4374: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "qtot", Integer.toString(value));
                                    break;
                                }
                                case 16662: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "qtotk", Integer.toString(value));
                                    break;
                                }
                                case 4376: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "pf", Integer.toString(value));
                                    break;
                                }
                                case 12562: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "frequency", Integer.toString(value));
                                    break;
                                }
                                case 12544: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v1n", Integer.toString(value));
                                    break;
                                }
                                case 12546: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v2n", Integer.toString(value));
                                    break;
                                }
                                case 12548: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "v3n", Integer.toString(value));
                                    break;
                                }
                                case 4420: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p1", Integer.toString(value));
                                    break;
                                }
                                case 16708: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p1k", Integer.toString(value));
                                    break;
                                }
                                case 4422: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p2", Integer.toString(value));
                                    break;
                                }
                                case 16710: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p2k", Integer.toString(value));
                                    break;
                                }
                                case 4424: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p3", Integer.toString(value));
                                    break;
                                }
                                case 16712: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "p3k", Integer.toString(value));
                                    break;
                                }
                                case 4426: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "q1", Integer.toString(value));
                                    break;
                                }
                                case 16714: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "q1k", Integer.toString(value));
                                    break;
                                }
                                case 4428: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "q2", Integer.toString(value));
                                    break;
                                }
                                case 16716: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "q2k", Integer.toString(value));
                                    break;
                                }
                                case 4430: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "q3", Integer.toString(value));
                                    break;
                                }
                                case 16718: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "q3k", Integer.toString(value));
                                    break;
                                }
                                case 4438: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "pf1", Integer.toString(value));
                                    break;
                                }
                                case 4440: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "pf2", Integer.toString(value));
                                    break;
                                }
                                case 4442: {
                                    value = data[pointer + 2 * i] << 8 | data[pointer + 1 + 2 * i] & 255;
                                    this.ioWrite(events, -1, "i", address, "pf3", Integer.toString(value));
                                    break;
                                }
                                case 4432: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s1", Integer.toString(value));
                                    break;
                                }
                                case 16720: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s1k", Integer.toString(value));
                                    break;
                                }
                                case 4434: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s2", Integer.toString(value));
                                    break;
                                }
                                case 16722: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s2k", Integer.toString(value));
                                    break;
                                }
                                case 4436: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s3", Integer.toString(value));
                                    break;
                                }
                                case 16724: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "s3k", Integer.toString(value));
                                    break;
                                }
                                case 4418: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "stot", Integer.toString(value));
                                    break;
                                }
                                case 16706: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "stotk", Integer.toString(value));
                                    break;
                                }
                                case 8578: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "hours", Integer.toString(value));
                                    break;
                                }
                                case 8582: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    this.ioWrite(events, -1, "i", address, "temperature", Integer.toString(value));
                                    break;
                                }
                                case 24858: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[0][0] = new Integer(value);
                                    break;
                                }
                                case 28954: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[0][1] = new Integer(value);
                                    break;
                                }
                                case 33050: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[0][2] = new Integer(value);
                                    break;
                                }
                                case 24894: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[1][0] = new Integer(value);
                                    break;
                                }
                                case 28990: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[1][1] = new Integer(value);
                                    break;
                                }
                                case 33086: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[1][2] = new Integer(value);
                                    break;
                                }
                                case 24860: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[2][0] = new Integer(value);
                                    break;
                                }
                                case 28956: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[2][1] = new Integer(value);
                                    break;
                                }
                                case 33052: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[2][2] = new Integer(value);
                                    break;
                                }
                                case 24896: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[3][0] = new Integer(value);
                                    break;
                                }
                                case 28992: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[3][1] = new Integer(value);
                                    break;
                                }
                                case 33088: {
                                    value = ((data[pointer + 2 * i] & 255) << 8) + (data[pointer + 1 + 2 * i] & 255);
                                    partialdata[3][2] = new Integer(value);
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    this.ioWrite(events, -1, "o", address, "reset.energy", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "o", address, "reset.hours", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                }
                return;
            }
            case 137: {
                if (!input) {
                    this.ioWrite(events, -1, "o", address, "reset.energy", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "o", address, "reset.hours", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                }
                return;
            }
            case 185: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "5", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "6", (data[pointer + 1] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "7", (data[pointer + 1] & 64) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "8", (data[pointer + 1] & 128) > 0 ? "1" : "0");
                    value = (data[pointer + 2] & 255) << 8 | data[pointer + 3] & 255;
                    this.ioWrite(events, -1, "i", address, "v", Integer.toString(value));
                    value = (data[pointer + 4] & 255) << 8 | data[pointer + 5] & 255;
                    this.ioWrite(events, -1, "i", address, "i", Integer.toString(value));
                    value = data[pointer + 6] << 8 | data[pointer + 7] & 255;
                    this.ioWrite(events, -1, "i", address, "p", Integer.toString(value));
                    value = (data[pointer + 8] & 255) << 8 | data[pointer + 9] & 255;
                    this.ioWrite(events, -1, "i", address, "s", Integer.toString(value));
                    value = data[pointer + 10] << 8 | data[pointer + 11] & 255;
                    this.ioWrite(events, -1, "i", address, "q", Integer.toString(value));
                    value = data[pointer + 12] << 8 | data[pointer + 13] & 255;
                    this.ioWrite(events, -1, "i", address, "pf", Integer.toString(value));
                    lvalue = 65536000L * (long)((data[pointer + 18] & 255) << 8 | data[pointer + 19] & 255) + 1000L * (long)((data[pointer + 16] & 255) << 8 | data[pointer + 17] & 255) + (long)((data[pointer + 14] & 255) << 8 | data[pointer + 15] & 255);
                    this.ioWrite(events, -1, "i", address, "ae", Long.toString(lvalue));
                }
                return;
            }
            case 73: {
                if (!input) {
                    this.ioWrite(events, 1, "o", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "5", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "6", (data[pointer + 1] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "7", (data[pointer + 1] & 64) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "8", (data[pointer + 1] & 128) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "ae", (data[pointer] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "buzzer", (data[pointer] & 2) > 0 ? "1" : "0");
                }
                return;
            }
            case 234: {
                if (input) {
                    this.ioWrite(events, 1, "i", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "5", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "6", (data[pointer + 1] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "7", (data[pointer + 1] & 64) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "i", address, "8", (data[pointer + 1] & 128) > 0 ? "1" : "0");
                    value = (data[pointer + 2] & 255) << 8 | data[pointer + 3] & 255;
                    this.ioWrite(events, -1, "i", address, "v", Integer.toString(value));
                    value = (data[pointer + 4] & 255) << 8 | data[pointer + 5] & 255;
                    this.ioWrite(events, -1, "i", address, "i", Integer.toString(value));
                    value = data[pointer + 6] << 8 | data[pointer + 7] & 255;
                    this.ioWrite(events, -1, "i", address, "p", Integer.toString(value));
                    value = (data[pointer + 8] & 255) << 8 | data[pointer + 9] & 255;
                    this.ioWrite(events, -1, "i", address, "s", Integer.toString(value));
                    value = data[pointer + 10] << 8 | data[pointer + 11] & 255;
                    this.ioWrite(events, -1, "i", address, "q", Integer.toString(value));
                    value = data[pointer + 12] << 8 | data[pointer + 13] & 255;
                    this.ioWrite(events, -1, "i", address, "pf", Integer.toString(value));
                    lvalue = 65536000L * (long)((data[pointer + 18] & 255) << 8 | data[pointer + 19] & 255) + 1000L * (long)((data[pointer + 16] & 255) << 8 | data[pointer + 17] & 255) + (long)((data[pointer + 14] & 255) << 8 | data[pointer + 15] & 255);
                    this.ioWrite(events, -1, "i", address, "ae", Long.toString(lvalue));
                } else {
                    this.ioWrite(events, 1, "o", address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "5", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "6", (data[pointer + 1] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "7", (data[pointer + 1] & 64) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "8", (data[pointer + 1] & 128) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, "ae", (data[pointer] & 1) > 0 ? "1" : "0");
                }
                return;
            }
            case 10: {
                if (!input) ** GOTO lbl1909
                i = 0;
                while (i < 8) {
                    this.ioWrite(events, 1, "i", address, Integer.toString(i + 1), (data[pointer + 1] & 1 << i) > 0 ? "1" : "0");
                    ++i;
                }
                ** GOTO lbl1948
lbl1909:
                // 1 sources

                r = false;
                i = 0;
                while (i < 4) {
                    t = this.getOutputDeviceType(address + i + 1);
                    if (r || t != 26) ** GOTO lbl1940
                    switch (data[pointer + 1] >> 2 * i & 3) {
                        case 1: {
                            this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "up");
                            break;
                        }
                        case 2: {
                            this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "down");
                            break;
                        }
                        case 0: {
                            state = this.ioRead("o", address, Integer.toString(2 * i + 1));
                            if (state == null) {
                                this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "unknown");
                                break;
                            }
                            if (state.equals("up")) {
                                this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "offup");
                                break;
                            }
                            if (!state.equals("down")) ** GOTO lbl1946
                            this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "offdown");
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    ** GOTO lbl1946
lbl1940:
                    // 1 sources

                    if (t != -1 && t != 26) {
                        r = true;
                    }
                    this.ioWrite(events, 1, "o", address, Integer.toString(2 * i + 1), (data[pointer + 1] & 1 << 2 * i) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, Integer.toString(2 * i + 2), (data[pointer + 1] & 2 << 2 * i) > 0 ? "1" : "0");
lbl1946:
                    // 3 sources

                    ++i;
                }
lbl1948:
                // 2 sources

                return;
            }
            case 26: {
                if (!input && (value = data[pointer + 1] & 127) >= 0 && value <= 100) {
                    this.ioWrite(events, -1, "o", address, null, String.valueOf(value) + "%");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address, "value", Integer.toString(value));
                }
                return;
            }
            case 74: {
                if (!input) ** GOTO lbl1971
                i = 0;
                while (i < 4) {
                    this.ioWrite(events, 1, "i", address, Integer.toString(i + 1), (data[pointer + 1] & 1 << i) > 0 ? "1" : "0");
                    ++i;
                }
                i = 4;
                while (i < 8) {
                    this.ioWrite(events, 1, "v", address, Integer.toString(i + 1), (data[pointer + 1] & 1 << i) > 0 ? "1" : "0");
                    ++i;
                }
                ** GOTO lbl2010
lbl1971:
                // 1 sources

                r = false;
                i = 0;
                while (i < 2) {
                    t = this.getOutputDeviceType(address + i + 1);
                    if (r || t != 90) ** GOTO lbl2002
                    switch (data[pointer + 1] >> 2 * i & 3) {
                        case 1: {
                            this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "up");
                            break;
                        }
                        case 2: {
                            this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "down");
                            break;
                        }
                        case 0: {
                            state = this.ioRead("o", address, Integer.toString(2 * i + 1));
                            if (state == null) {
                                this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "unknown");
                                break;
                            }
                            if (state.equals("up")) {
                                this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "offup");
                                break;
                            }
                            if (!state.equals("down")) ** GOTO lbl2008
                            this.ioWrite(events, 2, "o", address, Integer.toString(2 * i + 1), "offdown");
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    ** GOTO lbl2008
lbl2002:
                    // 1 sources

                    if (t != -1 && t != 90) {
                        r = true;
                    }
                    this.ioWrite(events, 1, "o", address, Integer.toString(2 * i + 1), (data[pointer + 1] & 1 << 2 * i) > 0 ? "1" : "0");
                    this.ioWrite(events, 1, "o", address, Integer.toString(2 * i + 2), (data[pointer + 1] & 2 << 2 * i) > 0 ? "1" : "0");
lbl2008:
                    // 3 sources

                    ++i;
                }
lbl2010:
                // 2 sources

                return;
            }
            case 90: {
                if (!input && (value = data[pointer + 1] & 127) >= 0 && value <= 100) {
                    this.ioWrite(events, -1, "o", address, null, String.valueOf(value) + "%");
                    SystemState.uiSet(String.valueOf(this.serverName) + "." + address, "value", Integer.toString(value));
                }
                return;
            }
            case 25: {
                if (input) {
                    i = 0;
                    while (i < 4) {
                        this.ioWrite(events, 1, "i", address, Integer.toString(i + 1), (data[pointer + 1] & 1 << i) > 0 ? "1" : "0");
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < 4) {
                        this.ioWrite(events, 1, "o", address, Integer.toString(i + 1), (data[pointer + 1] & 1 << i) > 0 ? "1" : "0");
                        ++i;
                    }
                }
                return;
            }
            case 41: {
                if (input) {
                    this.ioWrite(events, -1, "i", address, null, Integer.toString(((data[pointer] & 255) << 8) + (data[pointer + 1] & 255)));
                } else {
                    this.ioWrite(events, -1, "o", address, null, Integer.toString(((data[pointer] & 255) << 8) + (data[pointer + 1] & 255)));
                }
                return;
            }
            case 138: {
                if (input) {
                    if ((data[pointer] & 128) > 0) {
                        this.ioWrite(events, -1, "i", address, "power", "fault");
                    } else {
                        this.ioWrite(events, -1, "i", address, "power", (data[pointer + 1] & 1) > 0 ? "on" : "off");
                    }
                    this.ioWrite(events, -1, "i", address, "fan.speed.1", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.speed.2", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.speed.3", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.speed.4", (data[pointer + 1] & 16) > 0 ? "1" : "0");
                    if ((data[pointer + 1] & 32) > 0) {
                        this.ioWrite(events, -1, "i", address, "mode", "auto");
                    } else if ((data[pointer + 1] & 64) > 0) {
                        this.ioWrite(events, -1, "i", address, "mode", "heating");
                    } else if ((data[pointer + 1] & 128) > 0) {
                        this.ioWrite(events, -1, "i", address, "mode", "cooling");
                    } else if ((data[pointer] & 1) > 0) {
                        this.ioWrite(events, -1, "i", address, "mode", "fan");
                    } else if ((data[pointer] & 2) > 0) {
                        this.ioWrite(events, -1, "i", address, "mode", "dehum");
                    }
                    this.ioWrite(events, -1, "i", address, "fan.position.1", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.position.2", (data[pointer] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.position.3", (data[pointer] & 16) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.position.4", (data[pointer] & 32) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "fan.swing", (data[pointer] & 64) > 0 ? "1" : "0");
                    this.ioWrite(events, -1, "i", address, "temp", Integer.toString(((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730));
                } else {
                    this.ioWrite(events, -1, "o", address, "setpoint.temp", Integer.toString(((data[pointer + 2] & 255) << 8) + (data[pointer + 3] & 255) - 2730));
                }
                return;
            }
            case 152: 
            case 168: {
                if (!input) break;
                v = ((data[pointer] & 255) << 8) + (data[pointer + 1] & 255);
                this.ioWrite(events, -1, "i", address, null, Integer.toString(v < 32768 ? v : v - 65536));
            }
        }
    }

    private void ioStore(String prefix, int address, String datapoint, String value) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        if (datapoint != null) {
            sb.append('.');
            sb.append(datapoint);
        }
        this.states.put(sb.toString(), value);
    }

    private boolean ioWrite(boolean events2, int function, String prefix, int address, String datapoint, String value) {
        String name;
        String state;
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        if (datapoint != null) {
            sb.append('.');
            sb.append(datapoint);
        }
        if ((state = this.states.get(name = sb.toString())) == null || !state.equals(value)) {
            this.states.put(name, value);
            if (function != -1) {
                switch (prefix.charAt(0)) {
                    case 'i': {
                        Device device;
                        if (!this.inputdiscovery || (device = this.inputDevices.get(address)) == null) break;
                        SystemState.deviceSet(false, function, name, value, this.decodeDeviceType(device.type));
                        break;
                    }
                    case 'v': {
                        if (!this.virtualdiscovery) break;
                        if (address == 0) {
                            SystemState.deviceSet(false, function, name, value, "DFCP");
                            break;
                        }
                        Device device = this.outputDevices.get(address);
                        if (device == null) break;
                        SystemState.deviceSet(false, function, name, value, this.decodeDeviceType(device.type));
                        break;
                    }
                    case 'o': {
                        Device device;
                        if (!this.outputdiscovery || (device = this.outputDevices.get(address)) == null) break;
                        SystemState.deviceSet(false, function, name, value, this.decodeDeviceType(device.type));
                    }
                }
            }
            if (events2) {
                if (this.synchronousEvents) {
                    SystemState.ioWriteSynchronous(name, value);
                } else {
                    SystemState.ioWrite(name, value);
                }
            } else {
                SystemState.ioWriteNoEvents(name, value);
            }
            return true;
        }
        return false;
    }

    private String ioRead(String prefix, int address, String datapoint) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        sb.append('.');
        sb.append(datapoint);
        String name = sb.toString();
        return this.states.get(name);
    }

    private String decodeDeviceType(int type) {
        switch (type) {
            case 65: {
                return "DF4I";
            }
            case 97: {
                return "DF16I";
            }
            case 113: {
                return "DFCK3";
            }
            case 129: {
                return "DFCS";
            }
            case 145: {
                return "DF8I";
            }
            case 161: {
                return "DFWRX";
            }
            case 34: {
                return "DF2R";
            }
            case 66: {
                return "DF4R";
            }
            case 82: {
                return "DF4RP";
            }
            case 130: 
            case 146: {
                return "DF4RP/I";
            }
            case 19: {
                return "DFDM";
            }
            case 35: {
                return "DFDT";
            }
            case 51: {
                return "DFDI";
            }
            case 67: {
                return "DFDI2";
            }
            case 83: {
                return "DFDI2B";
            }
            case 99: {
                return "DFDIM";
            }
            case 147: {
                return "DFDMX";
            }
            case 243: {
                return "DFDV";
            }
            case 211: 
            case 227: {
                return "DF4DV";
            }
            case 36: {
                return "DFTP";
            }
            case 52: {
                return "DFTR";
            }
            case 68: {
                return "DFTP/I";
            }
            case 21: {
                return "DFIR";
            }
            case 69: {
                return "DF4I/V";
            }
            case 85: {
                return "DFGSM";
            }
            case 117: {
                return "DF4IL";
            }
            case 133: {
                return "DF8IL";
            }
            case 149: {
                return "BRIDGE88";
            }
            case 165: {
                return "DFGSM3";
            }
            case 217: {
                return "DFIGLASS";
            }
            case 56: {
                return " DFIGLASS/TEMP";
            }
            case 24: {
                return "DFTA";
            }
            case 40: {
                return "DFTE";
            }
            case 136: {
                return "DFAI";
            }
            case 138: {
                return "DFMB-C";
            }
            case 248: {
                return "DFLUX";
            }
            case 153: 
            case 169: {
                return "DFCT";
            }
            case 249: {
                return "DFMOD";
            }
            case 89: 
            case 105: {
                return "DFTZ";
            }
            case 170: 
            case 186: {
                return "DFTZ2";
            }
            case 15: {
                return "DFCK";
            }
            case 63: {
                return "DFCL";
            }
            case 159: 
            case 175: {
                return "DFCT";
            }
            case 191: {
                return "DFMETEO";
            }
            case 163: {
                return "DFDALI";
            }
            case 179: 
            case 195: {
                return "DFDALI64";
            }
            case 232: {
                return "DFRHT";
            }
            case 121: 
            case 137: {
                return "DFANA";
            }
            case 229: 
            case 245: {
                return "DFANA-M";
            }
            case 73: 
            case 185: {
                return "DFCC2";
            }
            case 234: 
            case 250: {
                return "DFANA-M/CC";
            }
            case 10: 
            case 26: 
            case 42: 
            case 58: {
                return "DF8RIT";
            }
            case 74: 
            case 90: {
                return "DF4RI/DF4RIR";
            }
            case 25: 
            case 41: {
                return "DFLS";
            }
            case 152: 
            case 168: {
                return "DFAM2";
            }
        }
        return "UNDEFINED:" + type;
    }

    private int inputDeviceSize(int type) {
        switch (type) {
            case 65: {
                return 1;
            }
            case 97: {
                return 1;
            }
            case 113: {
                return 1;
            }
            case 129: {
                return -1;
            }
            case 145: {
                return 1;
            }
            case 161: {
                return -1;
            }
            case 34: {
                return 0;
            }
            case 66: {
                return 0;
            }
            case 82: {
                return 0;
            }
            case 130: 
            case 146: {
                return 1;
            }
            case 19: 
            case 35: 
            case 51: 
            case 67: 
            case 83: 
            case 99: {
                return 0;
            }
            case 147: {
                return 0;
            }
            case 211: 
            case 227: {
                return 0;
            }
            case 243: {
                return 0;
            }
            case 36: {
                return 0;
            }
            case 52: {
                return 0;
            }
            case 68: {
                return 1;
            }
            case 21: {
                return -1;
            }
            case 69: {
                return 4;
            }
            case 85: {
                return -1;
            }
            case 117: {
                return 1;
            }
            case 133: {
                return 1;
            }
            case 149: {
                return -1;
            }
            case 165: {
                return -1;
            }
            case 217: {
                return 1;
            }
            case 56: {
                return 1;
            }
            case 24: {
                return 1;
            }
            case 40: {
                return 1;
            }
            case 136: {
                return 2;
            }
            case 138: {
                return 2;
            }
            case 248: {
                return 1;
            }
            case 153: 
            case 169: {
                return 2;
            }
            case 249: {
                return -1;
            }
            case 15: {
                return -1;
            }
            case 63: {
                return -1;
            }
            case 159: 
            case 175: {
                return 2;
            }
            case 191: {
                return 4;
            }
            case 163: {
                return 1;
            }
            case 179: {
                return 2;
            }
            case 195: {
                return 1;
            }
            case 232: {
                return 4;
            }
            case 89: 
            case 105: {
                return 3;
            }
            case 170: 
            case 186: {
                return 5;
            }
            case 121: {
                return 1;
            }
            case 229: {
                return 1;
            }
            case 185: 
            case 234: {
                return 10;
            }
            case 10: {
                return 1;
            }
            case 26: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 58: {
                return 1;
            }
            case 74: {
                return 1;
            }
            case 90: {
                return 1;
            }
            case 25: 
            case 41: {
                return 1;
            }
            case 152: 
            case 168: {
                return 1;
            }
        }
        return -1;
    }

    private int outputDeviceSize(int type) {
        switch (type) {
            case 65: {
                return 0;
            }
            case 97: {
                return 0;
            }
            case 113: {
                return 0;
            }
            case 129: {
                return -1;
            }
            case 145: {
                return 0;
            }
            case 161: {
                return -1;
            }
            case 34: {
                return 1;
            }
            case 66: {
                return 1;
            }
            case 82: 
            case 130: 
            case 146: {
                return 1;
            }
            case 19: 
            case 35: 
            case 51: 
            case 67: 
            case 83: 
            case 99: {
                return 1;
            }
            case 147: {
                return 1;
            }
            case 211: 
            case 227: {
                return 1;
            }
            case 243: {
                return 1;
            }
            case 36: {
                return 1;
            }
            case 52: {
                return 1;
            }
            case 68: {
                return 1;
            }
            case 21: {
                return -1;
            }
            case 69: {
                return 1;
            }
            case 85: {
                return -1;
            }
            case 117: {
                return 1;
            }
            case 133: {
                return 1;
            }
            case 149: {
                return -1;
            }
            case 165: {
                return -1;
            }
            case 217: {
                return 1;
            }
            case 56: {
                return -1;
            }
            case 24: {
                return -1;
            }
            case 40: {
                return -1;
            }
            case 136: {
                return 0;
            }
            case 138: {
                return 2;
            }
            case 248: {
                return 0;
            }
            case 153: 
            case 169: {
                return 5;
            }
            case 249: {
                return -1;
            }
            case 15: {
                return -1;
            }
            case 63: {
                return -1;
            }
            case 159: 
            case 175: {
                return 5;
            }
            case 191: {
                return 3;
            }
            case 163: 
            case 179: {
                return 1;
            }
            case 232: {
                return 2;
            }
            case 89: 
            case 105: {
                return 4;
            }
            case 170: 
            case 186: {
                return 6;
            }
            case 137: {
                return 1;
            }
            case 229: {
                return 1;
            }
            case 73: 
            case 234: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 26: {
                return 1;
            }
            case 42: 
            case 58: {
                return 5;
            }
            case 74: {
                return 1;
            }
            case 90: {
                return 1;
            }
            case 25: 
            case 41: {
                return 1;
            }
            case 152: 
            case 168: {
                return 0;
            }
        }
        return -1;
    }

    private int getOutputDeviceType(int address) {
        return this.outputDevices.containsKey(address) ? this.outputDevices.get((Object)Integer.valueOf((int)address)).type : -1;
    }

    class Device {
        int address;
        int type;
        int size;
        boolean input;

        Device(int address, int type, int size, boolean input) {
            this.address = address;
            this.type = type;
            this.input = input;
            this.size = size;
        }
    }

    class MemoryRange {
        int from;
        int size;
        byte[] data;
        boolean initialized = false;

        MemoryRange(int from, int size) {
            this.from = from;
            this.size = size;
            this.data = new byte[size];
        }

        boolean equals(byte[] a2) {
            if (this.initialized) {
                return Arrays.equals(this.data, a2);
            }
            return false;
        }

        boolean equalsCopy(byte[] a2) {
            if (this.data.length == a2.length) {
                if (this.initialized) {
                    if (!Arrays.equals(this.data, a2)) {
                        int i2 = 0;
                        while (i2 < this.data.length) {
                            this.data[i2] = a2[i2];
                            ++i2;
                        }
                        return false;
                    }
                    return true;
                }
                int i3 = 0;
                while (i3 < this.data.length) {
                    this.data[i3] = a2[i3];
                    ++i3;
                }
                this.initialized = true;
                return false;
            }
            return false;
        }

        void copy(byte[] a2) {
            if (this.data.length == a2.length) {
                this.initialized = true;
                int i2 = 0;
                while (i2 < this.data.length) {
                    this.data[i2] = a2[i2];
                    ++i2;
                }
            }
        }
    }
}

