/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HTTPServer;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;

class Contatto {
    public static final String[] WebObjects = new String[]{"3button", "button", "buttonicon", "buttonimage", "dimmer", "temp", "tempmini"};
    private static final int UNDEF = -1;
    private static final int LIGHT = 1;
    private static final int AUTOM = 2;
    private static final int DIMMER = 11;
    private String commPort;
    private String commPortMain;
    private String commPortFailover;
    private boolean commFailoverActive = false;
    private String serverName;
    private int language = Configuration.language <= 2 ? Configuration.language : 0;
    private Hashtable<Integer, DeviceFeatures> ids = new Hashtable();
    private Hashtable<String, String> states = new Hashtable();
    private Hashtable<Integer, Device> inputDevices = new Hashtable();
    private Hashtable<Integer, Device> outputDevices = new Hashtable();
    private Hashtable<Integer, int[][]> emDevicesParams = new Hashtable();
    private Hashtable<Integer, Integer[][]> emDevicesPartialData = new Hashtable();
    private int emPowerSensivity = 50;
    private int emPower = -2147483647;
    int emPowerDisplayAddress = 0;
    private byte[][] modhtReaderTag = new byte[128][2];
    private Vector<MemoryRange> inputRanges = new Vector();
    private Vector<MemoryRange> outputRanges = new Vector();
    private MemoryRange virtualData = null;
    private MemoryRange[] registersData = null;
    private MemoryRange[] countersData = null;
    private MemoryRange modulesFaultData = new MemoryRange(59904, 256);
    ArrayBlockingQueue<String> ioqtx = null;
    private boolean startupevents = false;
    private boolean inputdiscovery = false;
    private boolean virtualdiscovery = false;
    private boolean outputdiscovery = true;
    private boolean detectevents = false;
    private boolean disablemodhtpulsereset = false;
    private int gwvirtuals = -1;
    private int gwregisters = -1;
    private int gwcounters = -1;
    private long writeRawMessageTimeMillis = 0L;
    private long commandErrorLogTimeMillis = 0L;
    private long commandErrorLogCounter = 0L;
    private long toolsCommand = 0L;
    private boolean bootMode = false;
    private boolean synchronousEvents;
    private long modulesFaultNextPollingTimestampMillis = 0L;
    private long faultNextPollingTimestampMillis = 0L;
    private int busFault = -1;
    private int moduleFault = -1;
    private static final String[][] TEXT = new String[][]{{"ON", "OFF", "SUMMER", "WINTER", "AUTO", "MAN", "FAULT", "MIN", "MED", "MAX"}, {"ON", "OFF", "ESTATE", "INVERNO", "AUTO", "MAN", "GUASTO", "MIN", "MED", "MAX"}, {"ON", "OFF", "&Eacute;T&Eacute;", "HIVER", "AUTO", "MAN", "FAUTE", "MIN", "MED", "MAX"}};

    Contatto() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void monitor(int ioIndex, ioMonitor me) {
        int ranges;
        String errorlabel = null;
        boolean pflagin = true;
        boolean pflagout = true;
        boolean pflagvirt = true;
        boolean pflagreg = true;
        boolean pflagcnt = true;
        boolean pflagene = true;
        boolean pflagfault = true;
        this.initializeIds();
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        me.dispatcher = false;
        String[] sap = Configuration.ioServersComm.elementAt(ioIndex).trim().split("[ ,;]+");
        this.commPort = this.commPortMain = sap[0];
        this.commPortFailover = sap.length == 2 ? sap[1] : null;
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            block71: {
                errorlabel = null;
                try {
                    String value;
                    String[] sb = sa[i2].split("=");
                    String param = sb[0].trim().toLowerCase();
                    String string = value = sb.length == 1 ? "true" : sb[1].trim();
                    if (param.equals("startupevents")) {
                        this.startupevents = value.equalsIgnoreCase("true");
                        break block71;
                    }
                    if (param.equals("detectevents")) {
                        this.detectevents = value.equalsIgnoreCase("true");
                        break block71;
                    }
                    if (param.equals("toolspassword")) {
                        HTTPServer.registerContattoHook(String.valueOf(this.serverName) + ":" + value, this);
                        break block71;
                    }
                    if (param.equals("inputdiscovery")) {
                        this.inputdiscovery = value.equalsIgnoreCase("true");
                        break block71;
                    }
                    if (param.equals("virtualdiscovery")) {
                        this.virtualdiscovery = value.equalsIgnoreCase("true");
                        break block71;
                    }
                    if (param.equals("outputdiscovery")) {
                        this.outputdiscovery = value.equalsIgnoreCase("true");
                        break block71;
                    }
                    if (param.equals("disablemodhtpulsereset")) {
                        this.disablemodhtpulsereset = value.equalsIgnoreCase("true");
                        break block71;
                    }
                    if (param.equals("virtualpoints")) {
                        try {
                            int v = Integer.parseInt(value);
                            if (v > 0 && v <= 2032) {
                                this.gwvirtuals = v;
                                break block71;
                            }
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        catch (Exception e2) {
                            this.gwvirtuals = value.equalsIgnoreCase("true") ? 2032 : -1;
                        }
                        break block71;
                    }
                    if (param.equals("registers")) {
                        try {
                            int r = Integer.parseInt(value);
                            if (r >= 0 && r <= 1023) {
                                this.gwregisters = r;
                                break block71;
                            }
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        catch (Exception e3) {
                            this.gwregisters = value.equalsIgnoreCase("true") ? 127 : -1;
                        }
                        break block71;
                    }
                    if (param.equals("counters")) {
                        try {
                            int c2 = Integer.parseInt(value);
                            if (c2 >= 0 && c2 <= 1023) {
                                this.gwcounters = c2;
                                break block71;
                            }
                            hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + param + " ignored");
                        }
                        catch (Exception e4) {
                            this.gwcounters = value.equalsIgnoreCase("true") ? 127 : -1;
                        }
                        break block71;
                    }
                    if (param.equals("powerdisplay")) {
                        errorlabel = param;
                        this.emPowerDisplayAddress = Integer.parseInt(value);
                    } else if (param.equals("powersensivity")) {
                        errorlabel = param;
                        int v = Integer.parseInt(value);
                        if (v <= 0) throw new Exception();
                        this.emPowerSensivity = v;
                    } else if (param.equals("language")) {
                        if (value.equalsIgnoreCase("en")) {
                            this.language = 0;
                        } else if (value.equalsIgnoreCase("it")) {
                            this.language = 1;
                        } else if (value.equalsIgnoreCase("fr")) {
                            this.language = 2;
                        }
                    }
                }
                catch (Exception e5) {
                    if (errorlabel == null) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - ignored");
                    }
                    hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - " + errorlabel + " ignored");
                }
            }
            ++i2;
        }
        if (this.inputdiscovery || this.virtualdiscovery || this.outputdiscovery) {
            Configuration.systemtopoDiscovery = true;
        }
        if (this.gwvirtuals != -1) {
            this.virtualData = new MemoryRange(2306, 254);
        }
        if (this.gwregisters != -1) {
            ranges = this.gwregisters / 128;
            this.registersData = new MemoryRange[ranges + 1];
            int r = 0;
            while (r <= ranges) {
                this.registersData[r] = new MemoryRange(4096 + r * 256, 256);
                ++r;
            }
        }
        if (this.gwcounters != -1) {
            ranges = this.gwcounters / 128;
            this.countersData = new MemoryRange[ranges + 1];
            int r = 0;
            while (r <= ranges) {
                this.countersData[r] = new MemoryRange(6144 + r * 256, 256);
                ++r;
            }
        }
        this.synchronousEvents = true;
        if (this.isInBootMode()) {
            this.bootMode = true;
            this.toolsCommand = System.currentTimeMillis() + 300000L;
            hsyco.messageLog("ioMonitor - starting in boot mode [" + this.serverName + "]");
        } else if (!this.modulesDiscovery()) {
            hsyco.messageLog("ioMonitor - failed to initialize [" + this.serverName + "]");
            me.quit = true;
        } else if (this.inputPolling(this.startupevents) && this.outputPolling(this.startupevents) && this.modulesFaultPolling(this.startupevents) && (this.gwvirtuals == -1 || this.virtualPointsPolling(this.startupevents)) && (this.gwregisters == -1 || this.registersPolling(this.startupevents)) && (this.gwcounters == -1 || this.countersPolling(this.startupevents))) {
            SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "online");
            SystemState.ioServersInitializedSet(ioIndex, true);
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e6) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e6);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        } else {
            me.quit = true;
        }
        PluginsWrapper.register(this.serverName, 16, this);
        this.synchronousEvents = false;
        while (!me.quit && this.toolsCommand != -1L) {
            try {
                long t = System.currentTimeMillis();
                if (this.writeRawMessageTimeMillis + 1000L > t) {
                    Thread.sleep(600L);
                } else if (t < me.heartbeat + 20L) {
                    Thread.sleep(100L);
                }
                if (this.toolsCommand > t) {
                    me.heartbeat = t;
                    Thread.sleep(1000L);
                    continue;
                }
                if (this.bootMode) {
                    hsyco.messageLog("ioMonitor - leaving boot mode and restarting [" + this.serverName + "]");
                    me.quit = true;
                    continue;
                }
                this.commandPolling();
                if (this.inputRanges.size() > 0 && (pflagin = this.inputPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.outputRanges.size() > 0 && (pflagout = this.outputPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.gwvirtuals != -1 && (pflagvirt = this.virtualPointsPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.gwregisters != -1 && (pflagreg = this.registersPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.gwcounters != -1 && (pflagcnt = this.countersPolling(true))) {
                    me.heartbeat = t;
                }
                if (this.modulesFaultNextPollingTimestampMillis < t && (pflagfault = this.modulesFaultPolling(true))) {
                    this.modulesFaultNextPollingTimestampMillis = t + 10000L;
                }
                if (this.faultNextPollingTimestampMillis < t && this.faultPolling(true)) {
                    this.faultNextPollingTimestampMillis = t + 10000L;
                }
                if (!Configuration.verboseLog || pflagin && pflagout && pflagvirt && pflagreg && pflagcnt && pflagene && pflagfault) continue;
                StringBuffer sb = new StringBuffer("ioMonitor - Error in thread loop [" + this.serverName + "] -");
                if (!pflagin) {
                    sb.append(" INPUT");
                }
                if (!pflagout) {
                    sb.append(" OUTPUT");
                }
                if (!pflagvirt) {
                    sb.append(" VIRTUAL");
                }
                if (!pflagreg) {
                    sb.append(" REGISTERS");
                }
                if (!pflagcnt) {
                    sb.append(" COUNTERS");
                }
                if (!pflagene) {
                    sb.append(" ENERGY");
                }
                if (!pflagfault) {
                    sb.append(" FAULT");
                }
                hsyco.errorLog(sb.toString());
            }
            catch (Exception e7) {
                hsyco.errorLog("ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e7.getMessage());
                me.quit = true;
            }
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        hsyco.errorLog("ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioWrite(String.valueOf(this.serverName) + ".connection", "offline");
    }

    private synchronized void writeOutput(int channel, int address, int mask, int state) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 121;
        byArray[2] = 6;
        byte[] command = byArray;
        command[3] = (byte)(address & 0xFF);
        command[4] = (byte)(channel & 0xFF);
        command[5] = (byte)((state & 0xFF00) >>> 8);
        command[6] = (byte)(state & 0xFF);
        command[7] = (byte)((mask & 0xFF00) >>> 8);
        command[8] = (byte)(mask & 0xFF);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(121);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        this.logWriteError(command);
        throw new IOException();
    }

    private synchronized void writeVirtual(int address, boolean state) throws Exception {
        byte[] byArray = new byte[8];
        byArray[1] = 120;
        byArray[2] = 3;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF00) >>> 8);
        command[4] = (byte)(address & 0xFF);
        command[5] = (byte)(state ? 1 : 0);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(120);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        this.logWriteError(command);
        throw new IOException();
    }

    private synchronized void writeRegister(int register, int value) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 126;
        byArray[2] = 6;
        byArray[6] = 2;
        byte[] command = byArray;
        if (register <= this.gwregisters) {
            int address = this.registersData[0].from + 2 * register;
            command[4] = (byte)((address & 0xFF00) >>> 8);
            command[5] = (byte)(address & 0xFF);
            command[7] = (byte)((value & 0xFF00) >>> 8);
            command[8] = (byte)(value & 0xFF);
            int i2 = 0;
            while (i2 < 6) {
                Contatto.cksfiller(command);
                util.readCommBytes(this.commPort, 0);
                if (util.writeCommBytes(this.commPort, command) == command.length) {
                    byte[] data = this.read(126);
                    if (data != null && data.length == 1 && data[0] == -1) {
                        return;
                    }
                    this.closeComm();
                }
                if (i2 == 3) {
                    this.failoverSwitch();
                }
                ++i2;
            }
            this.logWriteError(command);
            throw new IOException();
        }
    }

    private synchronized void writeCounter(int register, int value) throws Exception {
        byte[] byArray = new byte[11];
        byArray[1] = 126;
        byArray[2] = 6;
        byArray[6] = 2;
        byte[] command = byArray;
        if (register <= this.gwcounters) {
            int address = this.countersData[0].from + 2 * register;
            command[4] = (byte)((address & 0xFF00) >>> 8);
            command[5] = (byte)(address & 0xFF);
            command[7] = (byte)((value & 0xFF00) >>> 8);
            command[8] = (byte)(value & 0xFF);
            int i2 = 0;
            while (i2 < 6) {
                Contatto.cksfiller(command);
                util.readCommBytes(this.commPort, 0);
                if (util.writeCommBytes(this.commPort, command) == command.length) {
                    byte[] data = this.read(126);
                    if (data != null && data.length == 1 && data[0] == -1) {
                        return;
                    }
                    this.closeComm();
                }
                if (i2 == 3) {
                    this.failoverSwitch();
                }
                ++i2;
            }
            this.logWriteError(command);
            throw new IOException();
        }
    }

    private boolean isInBootMode() {
        byte[] data = this.readId();
        return data != null && data.length == 68 && data[0] == 0 && data[1] == 0;
    }

    private synchronized byte[] readId() {
        byte[] byArray = new byte[7];
        byArray[1] = 112;
        byArray[2] = 2;
        byArray[3] = 73;
        byArray[4] = 68;
        byte[] command = byArray;
        Contatto.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(112);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readRAM(int address, int len) {
        byte[] byArray = new byte[9];
        byArray[1] = 127;
        byArray[2] = 4;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)(len & 0xFF);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(127);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readFLASH(int address, int len) {
        byte[] byArray = new byte[9];
        byArray[1] = 111;
        byArray[2] = 4;
        byte[] command = byArray;
        command[3] = (byte)((address & 0xFF0000) >>> 16);
        command[4] = (byte)((address & 0xFF00) >>> 8);
        command[5] = (byte)(address & 0xFF);
        command[6] = (byte)(len & 0xFF);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(111);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readModuleID(int device, boolean input) {
        byte[] byArray = new byte[8];
        byArray[1] = 96;
        byArray[2] = 3;
        byArray[3] = 95;
        byArray[4] = 1;
        byte[] command = byArray;
        command[5] = input ? (byte)(device & 0x7F) : (byte)(device & 0x7F | 0x80);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(96);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized byte[] readModuleRAM(int device, int address, int size) {
        byte[] byArray = new byte[11];
        byArray[1] = 96;
        byArray[2] = 6;
        byArray[3] = 82;
        byArray[4] = 4;
        byte[] command = byArray;
        command[5] = (byte)(device & 0xFF);
        command[6] = (byte)((address & 0xFF00) >>> 8);
        command[7] = (byte)(address & 0xFF);
        command[8] = (byte)(size & 0xFF);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(96);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized boolean writeModuleRAM(int device, int address, byte[] data) {
        byte[] command = new byte[data.length + 10];
        boolean iofail = true;
        command[1] = 96;
        command[2] = (byte)(data.length + 5);
        command[3] = 83;
        command[4] = (byte)(data.length + 3);
        command[5] = (byte)(device & 0xFF);
        command[6] = (byte)((address & 0xFF00) >>> 8);
        command[7] = (byte)(address & 0xFF);
        int i2 = 0;
        while (i2 < data.length) {
            command[8 + i2] = data[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] ret = this.read(96);
                if (ret != null) {
                    if (ret[ret.length - 1] == -1) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return true;
                    }
                    iofail = false;
                } else {
                    this.closeComm();
                }
            }
            if (i2 == 3 && iofail) {
                this.failoverSwitch();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.logWriteError(command);
        return false;
    }

    private synchronized boolean writeModuleEEPROM(int device, int address, byte[] data) {
        byte[] command = new byte[data.length + 10];
        boolean iofail = true;
        command[1] = 96;
        command[2] = (byte)(data.length + 5);
        command[3] = 81;
        command[4] = (byte)(data.length + 3);
        command[5] = (byte)(device & 0xFF);
        command[6] = (byte)((address & 0xFF00) >>> 8);
        command[7] = (byte)(address & 0xFF);
        int i2 = 0;
        while (i2 < data.length) {
            command[8 + i2] = data[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] ret = this.read(96);
                if (ret != null) {
                    if (ret[ret.length - 1] == -1) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return true;
                    }
                    iofail = false;
                } else {
                    this.closeComm();
                }
            }
            if (i2 == 3 && iofail) {
                this.failoverSwitch();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.logWriteError(command);
        return false;
    }

    private synchronized byte[] readModuleEEPROM(int device, int address, int size) {
        byte[] byArray = new byte[11];
        byArray[1] = 96;
        byArray[2] = 6;
        byArray[3] = 80;
        byArray[4] = 4;
        byte[] command = byArray;
        command[5] = (byte)(device & 0xFF);
        command[6] = (byte)((address & 0xFF00) >>> 8);
        command[7] = (byte)(address & 0xFF);
        command[8] = (byte)(size & 0xFF);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(96);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    private synchronized boolean writeModuleExternalEEPROM(int device, int address, byte[] data) {
        byte[] command = new byte[data.length + 11];
        boolean iofail = true;
        command[0] = 0;
        command[1] = 96;
        command[2] = (byte)(data.length + 6);
        command[3] = 85;
        command[4] = (byte)(data.length + 4);
        command[5] = (byte)(device & 0xFF);
        command[6] = (byte)((address & 0xFF0000) >>> 16);
        command[7] = (byte)((address & 0xFF00) >>> 8);
        command[8] = (byte)(address & 0xFF);
        int i2 = 0;
        while (i2 < data.length) {
            command[9 + i2] = data[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] ret = this.read(96);
                if (ret != null) {
                    if (ret[ret.length - 1] == -1) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return true;
                    }
                    iofail = false;
                } else {
                    this.closeComm();
                }
            }
            if (i2 == 3 && iofail) {
                this.failoverSwitch();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        this.logWriteError(command);
        return false;
    }

    private synchronized byte[] readModuleExternalEEPROM(int device, int address, int size) {
        byte[] byArray = new byte[12];
        byArray[1] = 96;
        byArray[2] = 7;
        byArray[3] = 84;
        byArray[4] = 5;
        byte[] command = byArray;
        command[5] = (byte)(device & 0xFF);
        command[6] = (byte)((address & 0xFF0000) >>> 16);
        command[7] = (byte)((address & 0xFF00) >>> 8);
        command[8] = (byte)(address & 0xFF);
        command[9] = (byte)(size & 0xFF);
        Contatto.cksfiller(command);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(96);
                if (data != null) {
                    return data;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        return null;
    }

    byte[] writeRawMessage(byte[] command) {
        if (command == null) {
            return null;
        }
        if (command.length == 6 && command[1] == 64 && command[2] == 1) {
            byte[] response = new byte[6];
            response[0] = command[0];
            response[1] = 64;
            response[2] = 1;
            switch (command[3]) {
                case 1: {
                    this.toolsCommand = System.currentTimeMillis() + 300000L;
                    response[3] = -1;
                    break;
                }
                case 2: {
                    this.toolsCommand = 0L;
                    response[3] = -1;
                    break;
                }
                case 3: {
                    this.toolsCommand = -1L;
                    response[3] = -1;
                    break;
                }
                default: {
                    response[3] = 0;
                }
            }
            Contatto.cksfiller(response);
            if (Configuration.verboseLog) {
                hsyco.messageLog("ioMonitor - Raw FXP-XT traffic: " + util.decodeHex(command) + " > " + (response == null ? "NULL" : util.decodeHex(response)) + " [" + this.serverName + "]");
            }
            return response;
        }
        if (command.length == 9 && command[1] == 107 && command[2] == 4) {
            this.writeRawMessageTimeMillis = System.currentTimeMillis();
            return this.writeRawMessageSynchronized(command, true);
        }
        this.writeRawMessageTimeMillis = System.currentTimeMillis();
        return this.writeRawMessageSynchronized(command, false);
    }

    private synchronized byte[] writeRawMessageSynchronized(byte[] command, boolean longtimeout) {
        block6: {
            try {
                util.readCommBytes(this.commPort, 0);
                long t = System.currentTimeMillis();
                if (util.writeCommBytes(this.commPort, command) == command.length) {
                    byte[] header;
                    this.writeRawMessageTimeMillis = System.currentTimeMillis();
                    do {
                        if ((header = util.readCommBytes(this.commPort, 3)) == null || header.length != 3) continue;
                        int bodylength = (header[2] == 0 ? 256 : header[2] & 0xFF) + 2;
                        byte[] body = util.readCommBytes(this.commPort, bodylength);
                        byte[] response = Arrays.copyOf(header, header.length + body.length);
                        System.arraycopy(body, 0, response, header.length, body.length);
                        if (Configuration.verboseLog) {
                            hsyco.messageLog("ioMonitor - Raw FXP-XT traffic [" + (System.currentTimeMillis() - t) + "ms]: " + util.decodeHex(command) + " > " + (response == null ? "NULL" : util.decodeHex(response)) + " [" + this.serverName + "]");
                        }
                        return response;
                    } while (System.currentTimeMillis() < this.writeRawMessageTimeMillis + (long)(longtimeout ? 25000 : 5000));
                    if (Configuration.verboseLog) {
                        hsyco.messageLog("ioMonitor - Raw FXP-XT traffic [" + (System.currentTimeMillis() - t) + "ms]: " + util.decodeHex(command) + " > ERROR " + (header == null ? "NULL" : util.decodeHex(header)) + " [" + this.serverName + "]");
                    }
                }
            }
            catch (Exception e2) {
                if (!Configuration.verboseLog) break block6;
                hsyco.messageLog("ioMonitor - Raw FXP-XT traffic: " + util.decodeHex(command) + " > Exception [" + this.serverName + "]");
            }
        }
        return null;
    }

    private void failoverSwitch() {
        if (this.commPortFailover != null) {
            if (this.commFailoverActive) {
                this.commFailoverActive = false;
                this.commPort = this.commPortMain;
                hsyco.errorLog("ioMonitor - failover warning [" + this.serverName + "] - switching to main port");
            } else {
                this.commFailoverActive = true;
                this.commPort = this.commPortFailover;
                hsyco.errorLog("ioMonitor - failover warning [" + this.serverName + "] - switching to failover port");
            }
        }
    }

    private void closeComm() {
        util.closeComm(this.commPort);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean readModulesInfo(boolean input) {
        int length = 1;
        int pagestartaddress = 0;
        try {
            int flashbankoffset;
            byte[] dataE8 = this.readRAM(59392, 0);
            byte[] dataE9 = this.readRAM(59648, 0);
            byte[] data = this.readRAM(53256, 2);
            switch (this.readRAM(53256, 2)[0]) {
                case 1: {
                    flashbankoffset = 0x200000;
                    break;
                }
                default: {
                    flashbankoffset = 0;
                }
            }
            int page = 0;
            while (page < 4) {
                data = this.readFLASH((input ? 291584 : 292608) + flashbankoffset + page * 256, 0);
                int i2 = pagestartaddress;
                while (i2 < 32) {
                    int address = i2 + page * 32;
                    int id = data[i2 * 8] & 0xFF;
                    if (id > 0 && id < 255) {
                        DeviceFeatures features = this.ids.get(id);
                        if (features != null && features.model != null) {
                            int options;
                            int vfail;
                            int ch;
                            if (input) {
                                length = features.inlength == 0 ? data[i2 * 8 + 2] & 0xFF : features.inlength;
                                ch = (dataE8[address * 2 + 1] >>> 6 & 3) + 1;
                                vfail = (dataE8[address * 2 + 1] & 7) + (dataE8[address * 2] & 0xFF);
                            } else {
                                length = features.outlength == 0 ? data[i2 * 8 + 4] & 0xFF : features.outlength;
                                ch = (dataE9[address * 2 + 1] >>> 6 & 3) + 1;
                                vfail = (dataE9[address * 2 + 1] & 7) + (dataE9[address * 2] & 0xFF);
                            }
                            switch (id) {
                                case 97: {
                                    options = 0;
                                    ch = 1;
                                    break;
                                }
                                case 80: {
                                    if (input) {
                                        options = (data[i2 * 8 + 4] & 0xFF) == 2 ? 2 : 0;
                                        break;
                                    }
                                    if (length == 1) {
                                        options = 1;
                                        break;
                                    }
                                    if (address == (data[i2 * 8 + 3] & 0xFF)) {
                                        length = 1;
                                        options = 2;
                                        break;
                                    }
                                    length = 1;
                                    options = 3;
                                    break;
                                }
                                default: {
                                    options = 0;
                                }
                            }
                            if (input) {
                                this.inputDevices.put(address, new Device(address, id, options, input, length, ch, vfail));
                            } else {
                                this.outputDevices.put(address, new Device(address, id, options, input, length, ch, vfail));
                            }
                        } else {
                            length = 1;
                            hsyco.messageLog("ioMonitor - ignored " + (input ? "input" : "output") + " device: " + address + " = ID:" + id + " [" + this.serverName + "]");
                        }
                    } else {
                        length = 1;
                    }
                    pagestartaddress = i2 + length > 32 ? i2 + length - 32 : 0;
                    i2 += length;
                }
                ++page;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean readEnergyMetersInfo(int device) {
        try {
            int size;
            byte[] data = this.readModuleEEPROM(device, 1, 1);
            if (data != null && data.length == 6 && data[0] == -48 && data[2] == (byte)device && (size = data[5]) > 0 && size < 6) {
                int[][] params = new int[5][4];
                int i2 = 0;
                while (i2 < size) {
                    data = this.readModuleEEPROM(device, 16 + i2 * 8, 8);
                    if (data != null && data.length == 13 && data[0] == -48 && data[2] == (byte)device) {
                        int j2 = 0;
                        while (j2 < 4) {
                            params[i2][j2] = ((data[6 + 2 * j2] & 0xFF) << 8) + (data[5 + 2 * j2] & 0xFF);
                            ++j2;
                        }
                    } else {
                        if (Configuration.verboseLog) {
                            hsyco.errorLog("ioMonitor - error reading device configuration: " + device + " [" + this.serverName + "] - " + (data == null ? "NULL" : util.decodeHex(data)));
                        }
                        return false;
                    }
                    ++i2;
                }
                this.emDevicesParams.put(device, params);
                Integer[][] pdata = new Integer[4][3];
                int i3 = 0;
                while (i3 < 4) {
                    int j3 = 0;
                    while (j3 < 3) {
                        pdata[i3][j3] = null;
                        ++j3;
                    }
                    ++i3;
                }
                this.emDevicesPartialData.put(device, pdata);
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private void writeAllEnergyMetersPartialData(boolean events2) {
        Enumeration<Integer> entries = this.emDevicesPartialData.keys();
        while (entries.hasMoreElements()) {
            Integer address = entries.nextElement();
            Integer[][] pdata = this.emDevicesPartialData.get(address);
            if (pdata[0][0] != null && pdata[0][1] != null && pdata[0][2] != null) {
                this.ioWrite(events2, -1, "i", address, "energy.active", Double.toString((double)pdata[0][0].intValue() * 65536.0 + (double)pdata[0][1].intValue() + (double)pdata[0][2].intValue() / 1000.0));
            }
            if (pdata[1][0] != null && pdata[1][1] != null && pdata[1][2] != null) {
                this.ioWrite(events2, -1, "i", address, "energy.activeneg", Double.toString((double)pdata[1][0].intValue() * 65536.0 + (double)pdata[1][1].intValue() + (double)pdata[1][2].intValue() / 1000.0));
            }
            if (pdata[2][0] != null && pdata[2][1] != null && pdata[2][2] != null) {
                this.ioWrite(events2, -1, "i", address, "energy.reactive", Double.toString((double)pdata[2][0].intValue() * 65536.0 + (double)pdata[2][1].intValue() + (double)pdata[2][2].intValue() / 1000.0));
            }
            if (pdata[3][0] == null || pdata[3][1] == null || pdata[3][2] == null) continue;
            this.ioWrite(events2, -1, "i", address, "energy.reactiveneg", Double.toString((double)pdata[3][0].intValue() * 65536.0 + (double)pdata[3][1].intValue() + (double)pdata[3][2].intValue() / 1000.0));
        }
    }

    private boolean readDMXStatus(boolean events2, int device) {
        int address = device + 128;
        try {
            int i2 = 0;
            while (i2 < 4) {
                int mem = 256 + 16 * i2;
                byte[] data = this.readModuleRAM(address, mem, 16);
                if (data != null && data[0] == -46 && data[2] == (byte)address && data[3] == (byte)((mem & 0xFF00) >>> 8) && data[4] == (byte)(mem & 0xFF)) {
                    int x = 0;
                    while (x < 16) {
                        int ch = x + 1 + 16 * i2;
                        int level = data[x + 5] & 0xFF;
                        this.ioStore("o", device, String.valueOf(ch) + ".memory", Integer.toString(level));
                        this.ioWrite(events2, -1, "o", device, Integer.toString(ch), Integer.toString(level));
                        int index = Configuration.dmxServersDeviceId.indexOf(String.valueOf(this.serverName) + "." + "o" + device);
                        if (index != -1) {
                            SystemState.dmxSetInit(1000 * index + ch, level);
                        }
                        ++x;
                    }
                }
                ++i2;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readDALIStatus(boolean events2, boolean init, int device, int channel, int channels) {
        int address = device + 128;
        boolean found = false;
        try {
            int page = 0;
            while (page < (channels == 4 ? 2 : 4)) {
                int mem = 256 + (channels == 4 ? 32 : 64) * (channel - 1) + 16 * page;
                byte[] data = this.readModuleRAM(address, mem, 16);
                if (data != null && data[0] == -46 && data[2] == (byte)address && data[3] == (byte)((mem & 0xFF00) >>> 8) && data[4] == (byte)(mem & 0xFF)) {
                    int x = 0;
                    while (x < 16) {
                        int dalich = x + 1 + 16 * page;
                        int level = data[x + 5] & 0xFF;
                        switch (level) {
                            case 128: {
                                found = true;
                                this.ioWrite(events2, 11, "o", channel, device, Integer.toString(dalich), "fault");
                                break;
                            }
                            case 129: {
                                found = true;
                                this.ioWrite(events2, 11, "o", channel, device, Integer.toString(dalich), "unknown");
                                break;
                            }
                            case 255: {
                                String state = this.ioRead("o", channel, device, Integer.toString(dalich));
                                if (state == null) break;
                                this.ioWrite(events2, 11, "o", channel, device, Integer.toString(dalich), "unknown");
                                break;
                            }
                            default: {
                                found = true;
                                if (level > 0) {
                                    this.ioStore("o", channel, device, String.valueOf(dalich) + ".memory", Integer.toString(level));
                                }
                                this.ioWrite(events2, 11, "o", channel, device, Integer.toString(dalich), level == 0 ? "off" : String.valueOf(level) + "%");
                            }
                        }
                        ++x;
                    }
                }
                ++page;
            }
            if (init && found) {
                this.ioWrite(events2, 11, "o", channel, device, "all", "unknown");
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean readMODHTTags(boolean events2, int address, int reader) {
        try {
            byte[] tagdata = this.readModuleRAM(address, reader == 0 ? 272 : 288, 15);
            if (tagdata != null && tagdata.length == 20) {
                String tagstring = util.decodeHex(Arrays.copyOfRange(tagdata, 5, 20));
                if (!tagstring.equals("000000000000000000000000000000")) {
                    this.ioWrite(events2, -1, "i", address, reader == 0 ? "data.door" : "data.room", tagstring);
                } else {
                    this.ioWrite(events2, -1, "i", address, reader == 0 ? "data.door" : "data.room", "0");
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean ckscheck(int address, int code, int size, byte[] body, byte[] checksum) {
        int cks = (address & 0xFF) + (code & 0xFF) + (size & 0xFF);
        int i2 = 0;
        while (i2 < body.length) {
            cks = cks + (body[i2] & 0xFF) & 0xFFFF;
            ++i2;
        }
        int c2 = ~(((checksum[0] & 0xFF) << 8) + (checksum[1] & 0xFF)) & 0xFFFF;
        return cks == c2;
    }

    private static void cksfiller(byte[] data) {
        int cks = 0;
        int i2 = 0;
        while (i2 < data.length - 2) {
            cks = cks + (data[i2] & 0xFF) & 0xFFFF;
            ++i2;
        }
        data[data.length - 2] = (byte)(~cks >>> 8 & 0xFF);
        data[data.length - 1] = (byte)(~cks & 0xFF);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] read(int command) {
        byte address = 0;
        boolean waitforaddress = true;
        try {
            int i2 = 0;
            while (i2 < 1024) {
                byte[] b2 = util.readCommBytes(this.commPort, 1);
                if (b2 != null && b2.length == 1) {
                    if (waitforaddress) {
                        address = b2[0];
                        waitforaddress = false;
                    } else {
                        if ((byte)(command & 0xFF) == b2[0]) break;
                        address = b2[0];
                        waitforaddress = true;
                    }
                } else {
                    return null;
                }
                ++i2;
            }
            byte[] sizeheader = util.readCommBytes(this.commPort, 1);
            int size = sizeheader[0] == 0 ? 256 : sizeheader[0] & 0xFF;
            byte[] body = util.readCommBytes(this.commPort, size);
            byte[] checksum = util.readCommBytes(this.commPort, 2);
            if (this.ckscheck(address, command, sizeheader[0], body, checksum)) {
                return body;
            }
            return null;
        }
        catch (Exception e2) {
            return null;
        }
    }

    private boolean modulesDiscovery() {
        byte[] a2;
        Device device;
        int key;
        int maxInputAddress = 0;
        int maxOutputAddress = 0;
        int maxInputChannels = 0;
        int maxOutputChannels = 0;
        if (!this.readModulesInfo(true) || !this.readModulesInfo(false)) {
            return false;
        }
        Enumeration<Integer> e2 = this.inputDevices.keys();
        while (e2.hasMoreElements()) {
            key = e2.nextElement();
            device = this.inputDevices.get(key);
            hsyco.messageLog("ioMonitor - detected input device: " + device.address + "/" + device.length + " = " + device.model + " [" + this.serverName + "]");
            if (this.detectevents) {
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.input." + device.address + "." + device.length, device.model.toLowerCase());
            }
            if (device.address + device.length - 1 > maxInputAddress) {
                maxInputAddress = device.address + device.length - 1;
            }
            if (device.id == 129 && (a2 = this.readModuleID(device.address, false)) != null && a2.length == 5) {
                int n2 = device.channels = (a2[3] & 0xF) >= 6 ? 2 : 4;
            }
            if (device.channels <= maxInputChannels) continue;
            maxInputChannels = device.channels;
        }
        if (maxInputAddress > 0) {
            int i2 = 0;
            while (i2 < maxInputChannels) {
                this.inputRanges.add(new MemoryRange(256 * i2 + 2, 2 * maxInputAddress, i2 + 1));
                ++i2;
            }
        }
        e2 = this.outputDevices.keys();
        while (e2.hasMoreElements()) {
            key = e2.nextElement();
            device = this.outputDevices.get(key);
            hsyco.messageLog("ioMonitor - detected output device: " + device.address + "/" + device.length + " = " + device.model + " [" + this.serverName + "]");
            if (this.detectevents) {
                SystemState.ioWriteForced(String.valueOf(this.serverName) + ".detected.output." + device.address + "." + device.length, device.model.toLowerCase());
            }
            if (device.address + device.length - 1 > maxOutputAddress) {
                maxOutputAddress = device.address + device.length - 1;
            }
            if (device.id == 97) {
                this.readDMXStatus(this.startupevents, device.address);
            } else if (device.id == 129) {
                a2 = this.readModuleID(device.address, false);
                if (a2 != null && a2.length == 5) {
                    device.channels = (a2[3] & 0xF) >= 6 ? 2 : 4;
                }
                int ch = 1;
                while (ch <= device.channels) {
                    this.readDALIStatus(this.startupevents, true, device.address, ch, device.channels);
                    ++ch;
                }
            } else if (!(device.id != 132 && device.id != 246 || this.readEnergyMetersInfo(device.address))) {
                hsyco.errorLog("ioMonitor - error reading device configuration: " + device.address + "/" + device.length + " = " + device.model + " [" + this.serverName + "]");
            }
            if (device.channels <= maxOutputChannels) continue;
            maxOutputChannels = device.channels;
        }
        if (maxOutputAddress > 0) {
            int i3 = 0;
            while (i3 < maxOutputChannels) {
                this.outputRanges.add(new MemoryRange(256 * i3 + 1026, 2 * maxOutputAddress, i3 + 1));
                ++i3;
            }
        }
        return true;
    }

    private void commandPolling() {
        int counter = 0;
        try {
            String item;
            while (counter++ < 10 && (item = this.ioqtx.poll()) != null) {
                int equalidx;
                int pointidx = item.indexOf(46);
                if (pointidx == -1) {
                    equalidx = item.indexOf(61);
                    this.deviceCommand(item.substring(0, equalidx), null, item.substring(equalidx + 1));
                    continue;
                }
                equalidx = item.indexOf(61, pointidx);
                this.deviceCommand(item.substring(0, pointidx), item.substring(pointidx + 1, equalidx), item.substring(equalidx + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean inputPolling(boolean events2) {
        byte[][] data = new byte[4][];
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.inputRanges.size()) {
                    this.writeAllEnergyMetersPartialData(events2);
                    return true;
                }
                this.commandPolling();
                MemoryRange range = this.inputRanges.elementAt(i2);
                data[range.channel - 1] = this.readRAM(range.from, range.size);
                if (data[range.channel - 1] == null) {
                    return false;
                }
                if (!range.equalsCopy(data[range.channel - 1])) {
                    Enumeration<Integer> e2 = this.inputDevices.keys();
                    while (e2.hasMoreElements()) {
                        int key = e2.nextElement();
                        Device device = this.inputDevices.get(key);
                        if (device.channels < range.channel) continue;
                        this.deviceStateWrite(events2, true, device, range.channel, data[range.channel - 1]);
                    }
                }
                ++i2;
            }
        }
        catch (Exception e3) {
            return false;
        }
    }

    private boolean modulesFaultPolling(boolean events2) {
        try {
            byte[] data = this.readRAM(this.modulesFaultData.from, this.modulesFaultData.size);
            if (!this.modulesFaultData.equalsCopy(data)) {
                StringBuffer sb;
                int i2 = 1;
                while (i2 < this.modulesFaultData.size / 2) {
                    if (this.inputDevices.containsKey(i2)) {
                        sb = new StringBuffer(this.serverName);
                        sb.append(".i");
                        sb.append(i2);
                        sb.append(".modulefault");
                        if (events2) {
                            SystemState.ioWrite(sb.toString(), (data[i2] & 0x10) > 0 ? "1" : "0");
                        } else {
                            SystemState.ioWriteNoEvents(sb.toString(), (data[i2] & 0x10) > 0 ? "1" : "0");
                        }
                    }
                    ++i2;
                }
                i2 = 1;
                while (i2 < this.modulesFaultData.size / 2) {
                    if (this.outputDevices.containsKey(i2)) {
                        sb = new StringBuffer(this.serverName);
                        sb.append(".o");
                        sb.append(i2);
                        sb.append(".modulefault");
                        if (events2) {
                            SystemState.ioWrite(sb.toString(), (data[i2 + this.modulesFaultData.size / 2] & 0x10) > 0 ? "1" : "0");
                        } else {
                            SystemState.ioWriteNoEvents(sb.toString(), (data[i2 + this.modulesFaultData.size / 2] & 0x10) > 0 ? "1" : "0");
                        }
                    }
                    ++i2;
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean virtualPointsPolling(boolean events2) {
        try {
            this.commandPolling();
            byte[] data = this.readRAM(this.virtualData.from, this.virtualData.size);
            if (data != null && data.length == 254) {
                if (!this.virtualData.equalsCopy(data)) {
                    int i2 = 0;
                    while (i2 < data.length) {
                        int v;
                        int j2 = 0;
                        while (j2 < 8) {
                            v = i2 * 8 + j2 + 1;
                            if (v > this.gwvirtuals) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "v", 0, Integer.toString(v), (data[i2 + 1] & 1 << j2) > 0 ? "1" : "0");
                            ++j2;
                        }
                        j2 = 0;
                        while (j2 < 8) {
                            v = i2 * 8 + j2 + 9;
                            if (v > this.gwvirtuals) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "v", 0, Integer.toString(v), (data[i2] & 1 << j2) > 0 ? "1" : "0");
                            ++j2;
                        }
                        i2 += 2;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean registersPolling(boolean events2) {
        try {
            int range = 0;
            while (range < this.registersData.length) {
                this.commandPolling();
                byte[] data = this.readRAM(this.registersData[range].from, this.registersData[range].size);
                if (data != null && data.length == 256) {
                    if (!this.registersData[range].equalsCopy(data)) {
                        int i2 = 0;
                        while (i2 < 128) {
                            int r = i2 + range * 128;
                            if (r > this.gwregisters) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "r", 0, Integer.toString(r), Integer.toString(((data[2 * i2] & 0xFF) << 8) + (data[2 * i2 + 1] & 0xFF)));
                            ++i2;
                        }
                    }
                } else {
                    return false;
                }
                ++range;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean countersPolling(boolean events2) {
        try {
            int range = 0;
            while (range < this.countersData.length) {
                this.commandPolling();
                byte[] data = this.readRAM(this.countersData[range].from, this.countersData[range].size);
                if (data != null && data.length == 256) {
                    if (!this.countersData[range].equalsCopy(data)) {
                        int i2 = 0;
                        while (i2 < 128) {
                            int r = i2 + range * 128;
                            if (r > this.gwcounters) {
                                return true;
                            }
                            this.ioWrite(events2, 1, "c", 0, Integer.toString(r), Integer.toString(((data[2 * i2] & 0xFF) << 8) + (data[2 * i2 + 1] & 0xFF)));
                            ++i2;
                        }
                    }
                } else {
                    return false;
                }
                ++range;
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean faultPolling(boolean events2) {
        try {
            byte[] data = this.readRAM(2556, 2);
            if (data != null && data.length == 2) {
                int newBusFault = (data[1] & 2) >> 1;
                int newModuleFault = data[1] & 1;
                if (newBusFault != this.busFault) {
                    this.busFault = newBusFault;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".busfault", Integer.toString(this.busFault));
                }
                if (newModuleFault != this.moduleFault) {
                    this.moduleFault = newModuleFault;
                    SystemState.ioWrite(String.valueOf(this.serverName) + ".modulefault", Integer.toString(this.moduleFault));
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean outputPolling(boolean events2) {
        byte[][] data = new byte[4][];
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.outputRanges.size()) {
                    return true;
                }
                this.commandPolling();
                MemoryRange range = this.outputRanges.elementAt(i2);
                data[range.channel - 1] = this.readRAM(range.from, range.size);
                if (data[range.channel - 1] == null) {
                    return false;
                }
                if (!range.equalsCopy(data[range.channel - 1])) {
                    Enumeration<Integer> e2 = this.outputDevices.keys();
                    while (e2.hasMoreElements()) {
                        int key = e2.nextElement();
                        Device device = this.outputDevices.get(key);
                        if (device.channels < range.channel) continue;
                        this.deviceStateWrite(events2, false, device, range.channel, data[range.channel - 1]);
                    }
                }
                ++i2;
            }
        }
        catch (Exception e3) {
            return false;
        }
    }

    private Date readClock() {
        Calendar cal = Calendar.getInstance();
        try {
            byte[] d2 = this.readRAM(3840, 14);
            cal.clear();
            cal.set(2000 + util.decodeBCD(d2[13]), util.decodeBCD(d2[11]) - 1, util.decodeBCD(d2[9]), util.decodeBCD(d2[1]), util.decodeBCD(d2[3]), util.decodeBCD(d2[5]));
            return cal.getTime();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private void writeClock() throws Exception {
        byte[] byArray = new byte[23];
        byArray[1] = 126;
        byArray[2] = 18;
        byArray[4] = 15;
        byArray[6] = 14;
        byte[] command = byArray;
        Calendar cal = Calendar.getInstance();
        command[8] = util.encodeBCD(cal.get(11));
        command[10] = util.encodeBCD(cal.get(12));
        command[12] = util.encodeBCD(cal.get(13));
        command[14] = util.encodeBCD(cal.get(7) - 1);
        command[16] = util.encodeBCD(cal.get(5));
        command[18] = util.encodeBCD(cal.get(2) + 1);
        command[20] = util.encodeBCD(cal.get(1) - 2000);
        int i2 = 0;
        while (i2 < 6) {
            Contatto.cksfiller(command);
            util.readCommBytes(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, command) == command.length) {
                byte[] data = this.read(126);
                if (data != null && data.length == 1 && data[0] == -1) {
                    return;
                }
                this.closeComm();
            }
            if (i2 == 3) {
                this.failoverSwitch();
            }
            ++i2;
        }
        throw new IOException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logWriteError(byte[] data) {
        long now = System.currentTimeMillis();
        if (this.commandErrorLogCounter == -1L) {
            if (this.commandErrorLogTimeMillis >= now - 300000L) return;
            this.commandErrorLogTimeMillis = now;
            this.commandErrorLogCounter = 1L;
        } else {
            if (this.commandErrorLogCounter >= 50L) {
                this.commandErrorLogTimeMillis = now;
                this.commandErrorLogCounter = -1L;
                hsyco.errorLog("ioMonitor - Command Error: Too many errors, log disabled for 5 minutes [" + this.serverName + "]");
                return;
            }
            if (this.commandErrorLogTimeMillis < now - 10000L) {
                this.commandErrorLogTimeMillis = now;
                this.commandErrorLogCounter = 1L;
            } else {
                ++this.commandErrorLogCounter;
            }
        }
        hsyco.errorLog("ioMonitor - Command Error: " + util.decodeHex(data) + " [" + this.serverName + "]");
    }

    public String keypad(String id) {
        String key = id.toLowerCase();
        try {
            String[] sa = key.split("[.]+");
            int address = Integer.parseInt(sa[0]);
            if (this.outputDevices.containsKey(address)) {
                Device device = this.outputDevices.get(address);
                if (device.model.equals("CLIMA2")) {
                    if (sa[1].equals("setpoint")) {
                        if (sa[2].equals("temp")) {
                            int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp"));
                            if (sa[3].equals("up") || sa[3].equals("+")) {
                                int v = (s / 5 + 1) * 5;
                                if (v >= 0 && v <= 400) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp", Integer.toString(v));
                                }
                            } else if (sa[3].equals("down") || sa[3].equals("-")) {
                                int v = (s / 5 - 1) * 5;
                                if (v >= 0 && v <= 400) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp", Integer.toString(v));
                                }
                            } else {
                                int v = Integer.parseInt(sa[3]);
                                if (v >= 0 && v <= 400) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp", Integer.toString(v));
                                }
                            }
                        } else if (sa[2].equals("mode")) {
                            if (sa.length == 3) {
                                if ("on".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0]))) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0], "off");
                                } else if ("off".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0]))) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0], "on");
                                }
                            } else if (sa.length == 4) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0], sa[3]);
                            }
                        }
                    } else if (sa[1].equals("mode")) {
                        if (sa.length == 2) {
                            if ("summer".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "winter");
                            } else if ("winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "summer");
                            }
                        } else {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                        }
                    } else if (sa[1].equals("on") || sa[1].equals("off")) {
                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0], sa[1]);
                    }
                } else if (device.model.equals("MODCL")) {
                    if (sa[1].equals("setpoint")) {
                        if (sa[2].equals("temp")) {
                            if (sa.length == 4) {
                                int v;
                                String setpoint = SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint");
                                if (setpoint.equals("off") || setpoint.equals("0")) {
                                    setpoint = "man";
                                }
                                int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + setpoint));
                                if (sa[3].equals("up")) {
                                    int v2 = (s / 5 + 1) * 5;
                                    if (v2 >= 100 && v2 <= 355) {
                                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp.man", Integer.toString(v2));
                                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "man");
                                    }
                                } else if (sa[3].equals("down") && (v = (s / 5 - 1) * 5) >= 100 && v <= 355) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp.man", Integer.toString(v));
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint", "man");
                                }
                            } else {
                                int s = Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + sa[3]));
                                int v = 0;
                                v = sa[4].equals("up") || sa[4].equals("+") ? (s / 5 + 1) * 5 : (sa[4].equals("down") || sa[4].equals("-") ? (s / 5 - 1) * 5 : Integer.parseInt(sa[4]));
                                if (v >= 100 && v <= 355) {
                                    if ("man".equals(sa[3])) {
                                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp.man", Integer.toString(v));
                                    } else if (this.checkSetpointsSorted(Integer.parseInt(sa[0]), Integer.parseInt(sa[3]), v)) {
                                        SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.temp." + sa[3], Integer.toString(v));
                                    }
                                }
                            }
                        } else if (sa[2].equals("mode")) {
                            if (sa.length == 3) {
                                if ("man".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint.mode"))) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", "off");
                                } else if ("auto".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint.mode"))) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", "man");
                                } else if ("off".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".setpoint.mode"))) {
                                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", "auto");
                                }
                            } else if (sa.length == 4) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".setpoint.mode", sa[3]);
                            }
                        } else {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                        }
                    } else if (sa[1].equals("mode")) {
                        if (sa.length == 2) {
                            if ("summer".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "winter");
                            } else if ("winter".equals(SystemState.ioGet(String.valueOf(this.serverName) + ".i" + sa[0] + ".mode"))) {
                                SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + ".mode", "summer");
                            }
                        } else {
                            SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                        }
                    }
                } else if (device.model.equals("MOD4TP") && sa.length == 3) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".o" + sa[0] + "." + sa[1], sa[2]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private boolean checkSetpointsSorted(int address, int setpoint, int newvalue) {
        try {
            switch (setpoint) {
                case 1: {
                    return newvalue < Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2"));
                }
                case 2: {
                    return newvalue > Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.1")) && newvalue < Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.3"));
                }
                case 3: {
                    return newvalue > Integer.parseInt(SystemState.ioGet(String.valueOf(this.serverName) + ".o" + address + ".setpoint.temp.2"));
                }
            }
            return false;
        }
        catch (Exception e2) {
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deviceCommand(String deviceName, String portName, String value) throws Exception {
        Device device;
        if (deviceName.equalsIgnoreCase("v0")) {
            int port = Integer.parseInt(portName);
            if (port <= 0 || port > this.gwvirtuals) return;
            if (value.equals("1") || value.equalsIgnoreCase("on")) {
                this.writeVirtual(port, true);
                return;
            } else {
                if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                this.writeVirtual(port, false);
            }
            return;
        }
        if (deviceName.equalsIgnoreCase("r0")) {
            int port = Integer.parseInt(portName);
            if (port < 0 || port > this.gwregisters) return;
            this.writeRegister(port, Integer.parseInt(value));
            return;
        }
        if (deviceName.equalsIgnoreCase("c0")) {
            int port = Integer.parseInt(portName);
            if (port < 0 || port > this.gwcounters) return;
            this.writeCounter(port, Integer.parseInt(value));
            return;
        }
        if (deviceName.equalsIgnoreCase("clock")) {
            if (value.equalsIgnoreCase("read")) {
                Date d2 = this.readClock();
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d2));
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock.delta", Long.toString((d2.getTime() - System.currentTimeMillis()) / 1000L));
                return;
            } else {
                if (!value.equalsIgnoreCase("sync")) return;
                this.writeClock();
                Date d3 = this.readClock();
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(d3));
                SystemState.ioWrite(String.valueOf(this.serverName) + ".clock.delta", Long.toString((d3.getTime() - System.currentTimeMillis()) / 1000L));
            }
            return;
        }
        int address = Integer.parseInt(deviceName.substring(1));
        if (this.inputDevices.containsKey(address)) {
            device = this.inputDevices.get(address);
            switch (device.id) {
                case 248: {
                    if (!portName.equalsIgnoreCase("write")) break;
                    if (value.length() != 30) return;
                    byte[] bytea = new byte[16];
                    int i2 = 0;
                    while (i2 < 15) {
                        bytea[i2] = (byte)Integer.parseInt(value.substring(i2 * 2, (i2 + 1) * 2), 16);
                        ++i2;
                    }
                    if (this.writeModuleRAM(address, 288, bytea)) {
                        this.ioWrite(true, -1, "o", device.address, "write", value.toUpperCase());
                        return;
                    } else {
                        this.ioWrite(true, -1, "o", device.address, "write", "error");
                    }
                    return;
                }
            }
        }
        if (!this.outputDevices.containsKey(address)) return;
        device = this.outputDevices.get(address);
        switch (device.id) {
            case 34: {
                if (portName.equalsIgnoreCase("temp")) {
                    int level;
                    int n2 = level = value.equalsIgnoreCase("off") ? 0 : Integer.parseInt(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(1, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("lux")) {
                    int level;
                    int n3 = level = value.equalsIgnoreCase("off") ? 0 : Integer.parseInt(value);
                    if (level < 0) return;
                    this.writeOutput(2, address, 65535, level);
                    return;
                } else {
                    int level;
                    if (!portName.equalsIgnoreCase("wind")) return;
                    int n4 = level = value.equalsIgnoreCase("off") ? 0 : Integer.parseInt(value);
                    if (level < 0) return;
                    this.writeOutput(3, address, 65535, level);
                }
                return;
            }
            case 35: {
                if (portName.equalsIgnoreCase("dewpoint.1")) {
                    int level = Integer.parseInt(value) + 2730;
                    if (level < 0) return;
                    this.writeOutput(1, address, 65535, level);
                    return;
                } else {
                    int level;
                    if (!portName.equalsIgnoreCase("dewpoint.2") || (level = Integer.parseInt(value) + 2730) < 0) return;
                    this.writeOutput(2, address, 65535, level);
                }
                return;
            }
            case 40: 
            case 41: 
            case 42: 
            case 89: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port >= 9) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(1, address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(1, address, 1 << port - 1, 0);
                }
                return;
            }
            case 43: 
            case 44: {
                if (value.endsWith("%")) {
                    int level = 255 * (int)Double.parseDouble(value.substring(0, value.length() - 1)) / 100;
                    if (level < 0 || level > 255) return;
                    this.writeOutput(1, address, 255, level);
                    return;
                } else {
                    int index = value.indexOf(47);
                    if (index > 0) {
                        int level = (int)(255.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                        if (level < 0 || level > 255) return;
                        this.writeOutput(1, address, 255, level);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        if (level < 0 || level > 255) return;
                        this.writeOutput(1, address, 255, level);
                    }
                }
                return;
            }
            case 49: {
                if (portName.equalsIgnoreCase("setpoint")) {
                    int level = (int)Double.parseDouble(value);
                    if (level < 0 || level > 1000) return;
                    this.writeOutput(1, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("preset")) {
                    int level = (int)Double.parseDouble(value);
                    if (level < 0 || level > 100) return;
                    this.writeOutput(2, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("delay")) {
                    int level = (int)Double.parseDouble(value);
                    if (level < 0 || level > 65535) return;
                    this.writeOutput(3, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("mode")) {
                    if (value.equalsIgnoreCase("auto")) {
                        this.writeOutput(4, address, 1, 1);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("man")) return;
                        this.writeOutput(4, address, 1, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("in.reset")) {
                    if (value.equals("1")) {
                        this.writeOutput(4, address, 2, 2);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(4, address, 2, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("mode.reset")) {
                    if (value.equals("1")) {
                        this.writeOutput(4, address, 4, 4);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(4, address, 4, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("full.reset")) {
                    if (value.equals("1")) {
                        this.writeOutput(4, address, 8, 8);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(4, address, 8, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("v")) {
                    if (value.equals("1")) {
                        this.writeOutput(4, address, 16, 16);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(4, address, 16, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("in.disable")) {
                    if (value.equals("1")) {
                        this.writeOutput(4, address, 32, 32);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(4, address, 32, 0);
                    }
                    return;
                } else {
                    if (!portName.equalsIgnoreCase("presence")) return;
                    if (value.equals("1")) {
                        this.writeOutput(4, address, 64, 64);
                        return;
                    } else {
                        if (!value.equals("0")) return;
                        this.writeOutput(4, address, 64, 0);
                    }
                }
                return;
            }
            case 80: {
                int port = Integer.parseInt(portName);
                switch (device.options) {
                    case 1: {
                        if (port < 1 || port > 4) return;
                        if (value.equals("1") || value.equalsIgnoreCase("on")) {
                            this.writeOutput(1, address, 1 << port - 1, 65535);
                            return;
                        }
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 1 << port - 1, 0);
                        return;
                    }
                    case 2: {
                        if (SystemState.deviceFunctionGet(String.valueOf(this.serverName) + ".o" + address + ".1") == 1) {
                            if (port < 1 || port > 4) return;
                            if (value.equals("1") || value.equalsIgnoreCase("on")) {
                                this.writeOutput(1, address, 1 << port - 1, 65535);
                                return;
                            }
                            if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                            this.writeOutput(1, address, 1 << port - 1, 0);
                            return;
                        }
                        if (port != 1) return;
                        if (value.equalsIgnoreCase("stop") || value.equalsIgnoreCase("off") || value.equals("0")) {
                            this.writeOutput(1, address, 255, 0);
                            return;
                        }
                        if (value.equalsIgnoreCase("up")) {
                            this.writeOutput(1, address, 255, 0);
                            this.writeOutput(1, address, 255, 1);
                            return;
                        }
                        if (value.equalsIgnoreCase("down")) {
                            this.writeOutput(1, address, 255, 0);
                            this.writeOutput(1, address, 255, 2);
                            return;
                        }
                        int level = (int)Double.parseDouble(value);
                        if (level <= 0 || level >= 251) return;
                        this.writeOutput(1, address, 255, level);
                        return;
                    }
                    case 3: {
                        if (SystemState.deviceFunctionGet(String.valueOf(this.serverName) + ".o" + address + ".3") == 1) {
                            if (port < 3 || port > 4) return;
                            if (value.equals("1") || value.equalsIgnoreCase("on")) {
                                this.writeOutput(1, address, 1 << port - 1, 65535);
                                return;
                            }
                            if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                            this.writeOutput(1, address, 1 << port - 1, 0);
                            return;
                        }
                        if (port != 1) return;
                        if (value.equalsIgnoreCase("stop") || value.equalsIgnoreCase("off") || value.equals("0")) {
                            this.writeOutput(1, address, 255, 0);
                            return;
                        }
                        if (value.equalsIgnoreCase("up")) {
                            this.writeOutput(1, address, 255, 0);
                            this.writeOutput(1, address, 255, 1);
                            return;
                        }
                        if (value.equalsIgnoreCase("down")) {
                            this.writeOutput(1, address, 255, 0);
                            this.writeOutput(1, address, 255, 2);
                            return;
                        }
                        int level = (int)Double.parseDouble(value);
                        if (level <= 0 || level >= 251) return;
                        this.writeOutput(1, address, 255, level);
                    }
                }
                return;
            }
            case 81: 
            case 83: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port >= 5) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(1, address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(1, address, 1 << port - 1, 0);
                }
                return;
            }
            case 82: {
                int port = Integer.parseInt(portName);
                if (port <= 0 || port >= 3) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(1, address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(1, address, 1 << port - 1, 0);
                }
                return;
            }
            case 84: 
            case 85: 
            case 90: {
                if (value.equalsIgnoreCase("off")) {
                    this.writeOutput(1, address, 255, 133);
                    return;
                } else if (value.equalsIgnoreCase("on")) {
                    this.writeOutput(1, address, 255, 134);
                    return;
                } else if (value.endsWith("%")) {
                    int level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                    if (level < 0 || level > 100) return;
                    this.writeOutput(1, address, 255, level);
                    return;
                } else {
                    int index = value.indexOf(47);
                    if (index > 0) {
                        int level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                        if (level < 0 || level > 100) return;
                        this.writeOutput(1, address, 255, level);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        if (level < 0 || level > 255) return;
                        this.writeOutput(1, address, 255, level);
                    }
                }
                return;
            }
            case 97: {
                if (portName.charAt(0) == '#') {
                    int port = Integer.parseInt(portName.substring(1));
                    int level = (int)Double.parseDouble(value);
                    this.writeOutput(1, address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                    this.ioStore("o", address, String.valueOf(port) + ".memory", value);
                    this.ioWrite(true, -1, "o", address, Integer.toString(port), value);
                    return;
                } else {
                    int index;
                    int dmxlevel;
                    int level;
                    int port = Integer.parseInt(portName);
                    if (value.equalsIgnoreCase("off")) {
                        level = 0;
                        dmxlevel = -1;
                    } else if (value.equalsIgnoreCase("on")) {
                        index = Configuration.dmxServersDeviceId.indexOf(String.valueOf(this.serverName) + "." + "o" + address);
                        if (index != -1) {
                            dmxlevel = level = SystemState.dmxMemGet(1000 * index + port);
                            this.ioStore("o", address, String.valueOf(port) + ".memory", Integer.toString(level));
                        } else {
                            String m2 = this.ioRead("o", address, String.valueOf(port) + ".memory");
                            if (m2 == null) {
                                level = 255;
                                dmxlevel = 255;
                                this.ioStore("o", address, String.valueOf(port) + ".memory", "255");
                            } else {
                                dmxlevel = level = (int)Double.parseDouble(m2);
                            }
                        }
                    } else {
                        dmxlevel = level = (int)Double.parseDouble(value);
                        this.ioStore("o", address, String.valueOf(port) + ".memory", Integer.toString(level));
                    }
                    this.writeOutput(1, address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                    this.ioWrite(true, -1, "o", address, Integer.toString(port), Integer.toString(level));
                    if (port < 1 || port > 64 || (index = Configuration.dmxServersDeviceId.indexOf(String.valueOf(this.serverName) + "." + "o" + address)) == -1) return;
                    SystemState.dmxSet(1000 * index + port, dmxlevel);
                }
                return;
            }
            case 98: {
                if (value.equalsIgnoreCase("off")) {
                    this.writeOutput(3, address, 255, 133);
                    return;
                } else if (value.equalsIgnoreCase("on")) {
                    this.writeOutput(3, address, 255, 134);
                    return;
                } else if (value.endsWith("%")) {
                    int level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                    if (level < 0 || level > 100) return;
                    this.writeOutput(3, address, 255, level);
                    return;
                } else {
                    int index = value.indexOf(47);
                    if (index > 0) {
                        int level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                        if (level < 0 || level > 100) return;
                        this.writeOutput(3, address, 255, level);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        if (level < 0 || level > 255) return;
                        this.writeOutput(3, address, 255, level);
                    }
                }
                return;
            }
            case 129: {
                int index;
                int n5 = index = portName == null ? -1 : portName.indexOf(46);
                if (index == -1) {
                    int channel = Integer.parseInt(portName);
                    if (channel < 1 || channel > device.channels) return;
                    if (value.equalsIgnoreCase("refresh")) {
                        this.readDALIStatus(true, false, address, channel, device.channels);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        this.writeOutput(channel, address, 65535, level & 0xFF);
                    }
                    return;
                } else {
                    int channel = Integer.parseInt(portName.substring(0, index));
                    if (channel < 1 || channel > 4) return;
                    if ((portName = portName.substring(index + 1).toLowerCase()).equals("all") || portName.equals("0")) {
                        int level;
                        if (value.equalsIgnoreCase("off")) {
                            level = 0;
                        } else if (value.equalsIgnoreCase("on")) {
                            String m3 = this.ioRead("o", channel, address, "all.memory");
                            if (m3 == null) {
                                level = 100;
                                this.ioStore("o", channel, address, "all.memory", "100");
                            } else {
                                level = m3.endsWith("%") ? (int)Double.parseDouble(m3.substring(0, m3.length() - 1)) : ((index = m3.indexOf(47)) > 0 ? (int)(100.0 * Double.parseDouble(m3.substring(0, index)) / Double.parseDouble(m3.substring(index + 1))) : (int)Double.parseDouble(m3));
                            }
                        } else if (value.endsWith("%")) {
                            level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", channel, address, "all.memory", value);
                            }
                        } else {
                            index = value.indexOf(47);
                            if (index > 0) {
                                level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                                if (level < 0 || level > 100) {
                                    return;
                                }
                                if (level > 0) {
                                    this.ioStore("o", channel, address, "all.memory", value);
                                }
                            } else {
                                level = (int)Double.parseDouble(value);
                                if (level < 0 || level > 100) {
                                    return;
                                }
                                if (level > 0) {
                                    this.ioStore("o", channel, address, "all.memory", value);
                                }
                            }
                        }
                        this.ioWrite(true, 11, "o", channel, address, "all", level == 0 ? "off" : String.valueOf(level) + "%");
                        this.writeOutput(channel, address, 65535, level & 0xFF);
                        return;
                    } else if (portName.startsWith("group.")) {
                        int level;
                        int port = Integer.parseInt(portName.substring(6));
                        if (port < 1 || port > 16) return;
                        if (value.equalsIgnoreCase("off")) {
                            level = 0;
                        } else if (value.equalsIgnoreCase("on")) {
                            String m4 = this.ioRead("o", channel, address, "group." + port + ".memory");
                            if (m4 == null) {
                                level = 100;
                                this.ioStore("o", channel, address, "group." + port + ".memory", "100");
                            } else {
                                level = (int)Double.parseDouble(m4);
                            }
                        } else if (value.endsWith("%")) {
                            level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", channel, address, "group." + port + ".memory", value);
                            }
                        } else {
                            index = value.indexOf(47);
                            if (index > 0) {
                                level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                                if (level < 0 || level > 100) {
                                    return;
                                }
                                if (level > 0) {
                                    this.ioStore("o", channel, address, "group." + port + ".memory", value);
                                }
                            } else {
                                level = (int)Double.parseDouble(value);
                                this.ioStore("o", channel, address, "group." + port + ".memory", value);
                            }
                        }
                        this.ioWrite(true, -1, "o", channel, address, portName, level == 0 ? "off" : String.valueOf(level) + "%");
                        this.writeOutput(channel, address, 65535, ((128 + port & 0xFF) << 8) + (level & 0xFF));
                        return;
                    } else {
                        int level;
                        int port = Integer.parseInt(portName);
                        if (port < 1 || port > (device.channels == 2 ? 64 : 32)) return;
                        if (value.equalsIgnoreCase("off")) {
                            level = 0;
                        } else if (value.equalsIgnoreCase("on")) {
                            String m5 = this.ioRead("o", channel, address, String.valueOf(port) + ".memory");
                            if (m5 == null) {
                                level = 100;
                                this.ioStore("o", channel, address, String.valueOf(port) + ".memory", "100");
                            } else {
                                level = (int)Double.parseDouble(m5);
                            }
                        } else if (value.endsWith("%")) {
                            level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                            if (level < 0 || level > 100) {
                                return;
                            }
                            if (level > 0) {
                                this.ioStore("o", channel, address, String.valueOf(port) + ".memory", value);
                            }
                        } else {
                            index = value.indexOf(47);
                            if (index > 0) {
                                level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                                if (level < 0 || level > 100) {
                                    return;
                                }
                                if (level > 0) {
                                    this.ioStore("o", channel, address, String.valueOf(port) + ".memory", value);
                                }
                            } else {
                                level = (int)Double.parseDouble(value);
                                if (level < 0 || level > 255) {
                                    return;
                                }
                                if (level > 100) {
                                    this.writeOutput(channel, address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                                    return;
                                }
                                if (level > 0) {
                                    this.ioStore("o", channel, address, String.valueOf(port) + ".memory", value);
                                }
                            }
                        }
                        this.ioWrite(true, 11, "o", channel, address, portName, level == 0 ? "off" : String.valueOf(level) + "%");
                        this.writeOutput(channel, address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                    }
                }
                return;
            }
            case 131: {
                int level;
                int port = Integer.parseInt(portName);
                if (port < 0 || port > 8) return;
                if (value.equalsIgnoreCase("off")) {
                    level = 0;
                } else if (value.equalsIgnoreCase("on")) {
                    String m6 = this.ioRead("o", port, address, "memory");
                    if (m6 == null) {
                        level = 100;
                        this.ioStore("o", port, address, "memory", "100");
                    } else {
                        level = (int)Double.parseDouble(m6);
                    }
                } else if (value.endsWith("%")) {
                    level = (int)Double.parseDouble(value.substring(0, value.length() - 1));
                    if (level < 0 || level > 100) {
                        return;
                    }
                    if (level > 0) {
                        this.ioStore("o", port, address, "memory", Integer.toString(level));
                    }
                } else {
                    int index = value.indexOf(47);
                    if (index > 0) {
                        level = (int)(100.0 * Double.parseDouble(value.substring(0, index)) / Double.parseDouble(value.substring(index + 1)));
                        if (level < 0 || level > 100) {
                            return;
                        }
                        if (level > 0) {
                            this.ioStore("o", port, address, "memory", Integer.toString(level));
                        }
                    } else {
                        level = (int)Double.parseDouble(value);
                        if (level < 0 || level > 255) {
                            return;
                        }
                        if (level > 100) {
                            this.writeOutput(1, address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                            return;
                        }
                        if (level > 0) {
                            this.ioStore("o", port, address, "memory", Integer.toString(level));
                        }
                    }
                }
                this.writeOutput(1, address, 65535, ((port & 0xFF) << 8) + (level & 0xFF));
                return;
            }
            case 130: {
                if (portName == null) return;
                String[] sa = portName.split("[.]");
                if (sa.length == 1) {
                    int port = Integer.parseInt(portName);
                    if (port < 1 || port > 4) return;
                    if (value.equalsIgnoreCase("stop") || value.equalsIgnoreCase("off")) {
                        this.writeOutput(port, address, 65535, 16);
                        return;
                    } else if (value.equalsIgnoreCase("up")) {
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 0);
                        this.writeOutput(port, address, 65535, 1);
                        return;
                    } else if (value.equalsIgnoreCase("up1")) {
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 17);
                        return;
                    } else if (value.equalsIgnoreCase("down")) {
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 2);
                        return;
                    } else if (value.equalsIgnoreCase("down1")) {
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 16);
                        this.writeOutput(port, address, 65535, 18);
                        return;
                    } else {
                        int level = (int)Double.parseDouble(value);
                        if (level < 0 || level > 100) return;
                        this.writeOutput(port, address, 65535, 256 + level);
                    }
                    return;
                } else {
                    if (sa.length != 2) return;
                    if (sa[0].equalsIgnoreCase("position") || sa[0].equalsIgnoreCase("shutter")) {
                        int level;
                        int port = Integer.parseInt(sa[1]);
                        if (port < 1 || port > 4 || (level = (int)Double.parseDouble(value)) < 0 || level > 100) return;
                        this.writeOutput(port, address, 65535, 256 + level);
                        return;
                    } else if (sa[0].equalsIgnoreCase("slats")) {
                        int level;
                        int port = Integer.parseInt(sa[1]);
                        if (port < 1 || port > 4 || (level = (int)Double.parseDouble(value)) < 0 || level > 100) return;
                        this.writeOutput(port, address, 65535, 512 + level);
                        return;
                    } else {
                        int port;
                        if (!sa[0].equalsIgnoreCase("calibration") || (port = Integer.parseInt(sa[1])) < 1 || port > 4 || !value.equals("1")) return;
                        this.writeOutput(port, address, 65535, 43605);
                    }
                }
                return;
            }
            case 145: 
            case 146: {
                String portNameLowerCase = portName.toLowerCase();
                if (portNameLowerCase.startsWith("led.")) {
                    int port = Integer.parseInt(portName.substring(4));
                    if (port <= 0 || port >= 7) return;
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(1, address, 1 << port - 1, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 1 << port - 1, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("disable")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(1, address, 1024, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 1024, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("dim")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(1, address, 2048, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 2048, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("proximity")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(1, address, 4096, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 4096, 0);
                    }
                    return;
                } else if (portNameLowerCase.equals("backlight")) {
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(1, address, 8192, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 8192, 0);
                    }
                    return;
                } else {
                    if (!portNameLowerCase.equals("buzzer")) return;
                    if (value.equals("1") || value.equalsIgnoreCase("on")) {
                        this.writeOutput(1, address, 16384, 65535);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 16384, 0);
                    }
                }
                return;
            }
            case 241: {
                int setpointaddress;
                boolean winter;
                String[] sa;
                if (portName == null) return;
                if (portName.equalsIgnoreCase("ev.enable")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 1, 1);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 1, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("aux.enable")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 2, 2);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 2, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("panic.reset")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 4, 4);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 4, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("busy")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 8, 8);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 8, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("ev")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 16, 16);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 16, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("aux")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 32, 32);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 32, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("dnd.reset")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 64, 64);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 64, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("service.reset")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 128, 128);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 128, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("booked")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 256, 256);
                        Thread.sleep(200L);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 256, 0);
                        Thread.sleep(200L);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("mode")) {
                    if (value.equalsIgnoreCase("summer")) {
                        this.writeOutput(1, address, 512, 512);
                        Thread.sleep(200L);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("winter")) return;
                        this.writeOutput(1, address, 512, 0);
                        Thread.sleep(200L);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("fan")) {
                    if (value.equalsIgnoreCase("off") || value.equals("0")) {
                        this.writeOutput(1, address, 3072, 1024);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("auto")) return;
                        this.writeOutput(1, address, 3072, 2048);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("comfort")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 4096, 4096);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 4096, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("3")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 8192, 8192);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 8192, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("fan.heating.min")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 16384, 0);
                    }
                    return;
                }
                if (portName.equalsIgnoreCase("fan.cooling.min")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 32768, 32768);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 32768, 0);
                    }
                    return;
                }
                if (portName.toLowerCase().startsWith("tag.")) {
                    int tag = Integer.parseInt(portName.substring(4));
                    if (tag < 1 || tag > 5) return;
                    if (value.equalsIgnoreCase("read")) {
                        String data = this.modEEPROMRead(address, 48 + 16 * tag, 12, false);
                        if (data == null) return;
                        this.ioWrite(true, -1, "i", device.address, "tag." + tag, data);
                        return;
                    } else {
                        if (value.length() != 24) return;
                        if (this.modEEPROMWrite(address, 48 + 16 * tag, value, false)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toUpperCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                    return;
                }
                if (portName.toLowerCase().startsWith("mask")) {
                    if (value.equalsIgnoreCase("read")) {
                        String data = this.modEEPROMRead(address, 48, 12, false);
                        if (data == null) return;
                        this.ioWrite(true, -1, "i", device.address, "mask", data);
                        return;
                    } else {
                        if (value.length() != 24) return;
                        if (this.modEEPROMWrite(address, 48, value, false)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toUpperCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                    return;
                }
                if (portName.toLowerCase().startsWith("setpoint.delta")) {
                    String[] sa2 = portName.trim().split("[.]");
                    switch (sa2.length) {
                        case 2: {
                            if (!value.equalsIgnoreCase("read")) return;
                            byte[] data = this.readModuleEEPROM(address, 30, 2);
                            if (data != null && data.length == 7) {
                                this.ioWrite(true, -1, "i", device.address, "setpoint.delta.winter.low", Integer.toString((data[6] & 0xFF) / 10));
                                this.ioWrite(true, -1, "i", device.address, "setpoint.delta.winter.high", Integer.toString((data[5] & 0xFF) / 10));
                            }
                            if ((data = this.readModuleEEPROM(address, 46, 2)) == null || data.length != 7) return;
                            this.ioWrite(true, -1, "i", device.address, "setpoint.delta.summer.low", Integer.toString((data[6] & 0xFF) / 10));
                            this.ioWrite(true, -1, "i", device.address, "setpoint.delta.summer.high", Integer.toString((data[5] & 0xFF) / 10));
                            return;
                        }
                        case 4: {
                            int setpointaddress2;
                            int level = Integer.parseInt(value);
                            if (level < 1 || level > 9) return;
                            if ("summer".equalsIgnoreCase(sa2[2])) {
                                if ("low".equalsIgnoreCase(sa2[3])) {
                                    setpointaddress2 = 47;
                                } else {
                                    if (!"high".equalsIgnoreCase(sa2[3])) return;
                                    setpointaddress2 = 46;
                                }
                            } else {
                                if (!"winter".equalsIgnoreCase(sa2[2])) return;
                                if ("low".equalsIgnoreCase(sa2[3])) {
                                    setpointaddress2 = 31;
                                } else {
                                    if (!"high".equalsIgnoreCase(sa2[3])) return;
                                    setpointaddress2 = 30;
                                }
                            }
                            byte[] data = new byte[]{(byte)(level * 10 & 0xFF)};
                            if (this.writeModuleEEPROM(device.address, setpointaddress2, data)) {
                                this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), Integer.toString(level));
                                return;
                            }
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (!portName.toLowerCase().startsWith("setpoint.") || (sa = portName.trim().split("[.]")).length != 3) return;
                if ("summer".equalsIgnoreCase(sa[1])) {
                    winter = false;
                    setpointaddress = 32;
                } else {
                    if (!"winter".equalsIgnoreCase(sa[1])) return;
                    winter = true;
                    setpointaddress = 16;
                }
                try {
                    int setpointnumber = Integer.parseInt(sa[2]);
                    switch (setpointnumber) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            setpointaddress += 4;
                            break;
                        }
                        case 3: {
                            setpointaddress += 6;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    if (value.equalsIgnoreCase("read")) {
                        byte[] data = this.readModuleEEPROM(address, setpointaddress, 2);
                        if (data == null || data.length != 7) return;
                        this.ioWrite(true, -1, "i", device.address, "setpoint." + (winter ? "winter" : "summer") + "." + setpointnumber, Integer.toString(((data[5] & 0xFF) << 8) + (data[6] & 0xFF) - 2730));
                        return;
                    } else {
                        int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                        if (level < 2730 || level > 3130) return;
                        byte[] data = new byte[]{(byte)((level & 0xFF00) >>> 8), (byte)(level & 0xFF)};
                        if (this.writeModuleEEPROM(device.address, setpointaddress, data)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value);
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            case 243: {
                if (portName == null) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 4096, 0);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 4096, 4096);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("mode")) {
                    if (value.equalsIgnoreCase("summer")) {
                        this.writeOutput(1, address, 32768, 32768);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("winter")) return;
                        this.writeOutput(1, address, 32768, 0);
                    }
                    return;
                } else if (portName.equals("setpoint")) {
                    if (value.equalsIgnoreCase("1")) {
                        this.writeOutput(1, address, 16384, 0);
                        this.writeOutput(1, address, 15872, 2048);
                        Thread.sleep(1000L);
                        this.writeOutput(1, address, 15872, 0);
                        return;
                    } else if (value.equalsIgnoreCase("2")) {
                        this.writeOutput(1, address, 16384, 0);
                        this.writeOutput(1, address, 15872, 1024);
                        Thread.sleep(1000L);
                        this.writeOutput(1, address, 15872, 0);
                        return;
                    } else if (value.equalsIgnoreCase("3")) {
                        this.writeOutput(1, address, 16384, 0);
                        this.writeOutput(1, address, 15872, 512);
                        Thread.sleep(1000L);
                        this.writeOutput(1, address, 15872, 0);
                        return;
                    } else if (value.equalsIgnoreCase("off") || value.equals("0")) {
                        this.writeOutput(1, address, 15872, 4096);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("man")) return;
                        this.writeOutput(1, address, 16384, 16384);
                        this.writeOutput(1, address, 15872, 8192);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.temp.man")) {
                    int level = (int)Math.round(Double.parseDouble(value));
                    if (level < 0 || level > 400) return;
                    this.writeOutput(1, address, 511, level);
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.temp.1")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2730 || level > 3130) return;
                    this.writeOutput(4, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.temp.2")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2730 || level > 3130) return;
                    this.writeOutput(3, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.temp.3")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2730 || level > 3130) return;
                    this.writeOutput(2, address, 65535, level);
                    return;
                } else {
                    if (!portName.equals("setpoint.mode")) return;
                    if (value.equalsIgnoreCase("man")) {
                        this.writeOutput(1, address, 16384, 16384);
                        this.writeOutput(1, address, 15872, 8192);
                        return;
                    } else if (value.equalsIgnoreCase("auto")) {
                        this.writeOutput(1, address, 16384, 0);
                        this.writeOutput(1, address, 15872, 0);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 15872, 4096);
                    }
                }
                return;
            }
            case 244: {
                if (portName == null) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 4096, 0);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 4096, 4096);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("mode")) {
                    if (value.equalsIgnoreCase("summer")) {
                        this.writeOutput(1, address, 32768, 32768);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("winter")) return;
                        this.writeOutput(1, address, 32768, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.temp")) {
                    int level = (int)(Math.round(Double.parseDouble(value)) + 2730L);
                    if (level < 2730 || level > 3130) return;
                    this.writeOutput(2, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.delta.neg")) {
                    int level = (int)Math.round(Double.parseDouble(value));
                    if (level < 0 || level > 127) return;
                    this.writeOutput(3, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("setpoint.delta.pos")) {
                    int level = (int)Math.round(Double.parseDouble(value));
                    if (level < 0 || level > 127) return;
                    this.writeOutput(4, address, 65535, level);
                    return;
                } else if (portName.equalsIgnoreCase("led.1")) {
                    if (value.equalsIgnoreCase("r") || value.equalsIgnoreCase("red")) {
                        this.writeOutput(1, address, 17, 1);
                        return;
                    } else if (value.equalsIgnoreCase("g") || value.equalsIgnoreCase("green")) {
                        this.writeOutput(1, address, 17, 16);
                        return;
                    } else if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yellow")) {
                        this.writeOutput(1, address, 17, 17);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 17, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("led.2")) {
                    if (value.equalsIgnoreCase("r") || value.equalsIgnoreCase("red")) {
                        this.writeOutput(1, address, 34, 2);
                        return;
                    } else if (value.equalsIgnoreCase("g") || value.equalsIgnoreCase("green")) {
                        this.writeOutput(1, address, 34, 32);
                        return;
                    } else if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yellow")) {
                        this.writeOutput(1, address, 34, 34);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 34, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("led.3")) {
                    if (value.equalsIgnoreCase("r") || value.equalsIgnoreCase("red")) {
                        this.writeOutput(1, address, 68, 4);
                        return;
                    } else if (value.equalsIgnoreCase("g") || value.equalsIgnoreCase("green")) {
                        this.writeOutput(1, address, 68, 64);
                        return;
                    } else if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yellow")) {
                        this.writeOutput(1, address, 68, 68);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 68, 0);
                    }
                    return;
                } else {
                    if (!portName.equalsIgnoreCase("led.4")) return;
                    if (value.equalsIgnoreCase("r") || value.equalsIgnoreCase("red")) {
                        this.writeOutput(1, address, 136, 8);
                        return;
                    } else if (value.equalsIgnoreCase("g") || value.equalsIgnoreCase("green")) {
                        this.writeOutput(1, address, 136, 128);
                        return;
                    } else if (value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yellow")) {
                        this.writeOutput(1, address, 136, 136);
                        return;
                    } else {
                        if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                        this.writeOutput(1, address, 136, 0);
                    }
                }
                return;
            }
            case 245: {
                if (portName == null) return;
                if (portName.equalsIgnoreCase("relay")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 1, 1);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 1, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("relay.forced")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 2, 2);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 2, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("block")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 16, 16);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 16, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("access.granted.code")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 1024, 1024);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 1024, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("access.granted.total.limit")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 2048, 2048);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 2048, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("access.granted.daily.limit")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 4096, 4096);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 4096, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("access.granted.time")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 8192, 8192);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 8192, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("access.granted.day")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 16384, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("access.granted.expired")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 32768, 32768);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 32768, 0);
                    }
                    return;
                } else if (portName.toLowerCase().startsWith("site.")) {
                    int site = Integer.parseInt(portName.substring(5));
                    if (site < 1 || site > 4) return;
                    if (value.equalsIgnoreCase("read")) {
                        String data = this.modEEPROMRead(address, 48 + 16 * site, 8, false);
                        if (data == null) return;
                        this.ioWrite(true, -1, "i", device.address, "site." + site, data);
                        return;
                    } else {
                        if (value.length() != 16) return;
                        if (this.modEEPROMWrite(address, 48 + 16 * site, value, false)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toUpperCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                    return;
                } else if (portName.toLowerCase().startsWith("mask")) {
                    if (value.equalsIgnoreCase("read")) {
                        String data = this.modEEPROMRead(address, 48, 8, false);
                        if (data == null) return;
                        this.ioWrite(true, -1, "i", device.address, "mask", data);
                        return;
                    } else {
                        if (value.length() != 16) return;
                        if (this.modEEPROMWrite(address, 48, value, false)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toUpperCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                    return;
                } else if (portName.toLowerCase().startsWith("user.")) {
                    int tag = Integer.parseInt(portName.substring(5));
                    if (tag < 1 || tag > 2000) return;
                    if (value.equalsIgnoreCase("read")) {
                        String data2;
                        String data1 = this.modEEPROMRead(address, 16 * (tag - 1), 8, true);
                        if (data1 == null || (data2 = this.modEEPROMRead(address, 16 * (tag - 1) + 8, 8, true)) == null) return;
                        this.ioWrite(true, -1, "i", device.address, "user." + tag, String.valueOf(data1) + data2);
                        return;
                    } else if (value.equalsIgnoreCase("reset")) {
                        if (this.modEEPROMWrite(address, 16 * (tag - 1) + 8, "0000", true)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toLowerCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                        return;
                    } else {
                        if (value.length() != 16) return;
                        if (this.modEEPROMWrite(address, 16 * (tag - 1), value, true)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toUpperCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                    return;
                } else if (portName.equalsIgnoreCase("users") && value.equalsIgnoreCase("erase")) {
                    if (this.modEEPROMWrite(address, 0xFFFFFF, "AA55C33CAA55C33C", true)) {
                        int i3 = 1;
                        while (i3 <= 2000) {
                            this.ioWrite(false, -1, "i", device.address, "users." + i3, null);
                            this.ioWrite(false, -1, "o", device.address, "users." + i3, null);
                            ++i3;
                        }
                        this.ioWrite(true, -1, "o", device.address, "users.erase.progress", "0");
                        return;
                    } else {
                        this.ioWrite(true, -1, "o", device.address, "users.erase.progress", "error");
                    }
                    return;
                } else {
                    if (!portName.equalsIgnoreCase("users.erase.progress") || !value.equalsIgnoreCase("read")) return;
                    byte[] data = this.readModuleRAM(address, 87, 2);
                    if (data != null && data.length == 7) {
                        int pointer = ((data[5] & 0xFF) << 8) + (data[6] & 0xFF);
                        this.ioWrite(true, -1, "o", device.address, "users.erase.progress", Integer.toString(pointer / 16));
                        return;
                    } else {
                        this.ioWrite(true, -1, "o", device.address, "users.erase.progress", "error");
                    }
                }
                return;
            }
            case 132: 
            case 246: {
                int port = portName.equalsIgnoreCase("reset.energy") ? 1 : (portName.equalsIgnoreCase("reset.hours") ? 2 : Integer.parseInt(portName));
                if (port <= 0 || port >= 3) return;
                if (value.equals("1") || value.equalsIgnoreCase("on")) {
                    this.writeOutput(1, address, 1 << port - 1, 65535);
                    return;
                } else {
                    if (!value.equals("0") && !value.equalsIgnoreCase("off")) return;
                    this.writeOutput(1, address, 1 << port - 1, 0);
                }
                return;
            }
            case 247: {
                if (portName == null) return;
                if (portName.equalsIgnoreCase("relay")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(1, address, 1, 1);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(1, address, 1, 0);
                    }
                    return;
                } else if (portName.equalsIgnoreCase("lock.all")) {
                    if (value.equalsIgnoreCase("on") || value.equals("1")) {
                        this.writeOutput(4, address, 16384, 16384);
                        return;
                    } else {
                        if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                        this.writeOutput(4, address, 16384, 0);
                    }
                    return;
                } else if (portName.toLowerCase().startsWith("lock.")) {
                    int pin = Integer.parseInt(portName.substring(5));
                    if (pin >= 1 && pin <= 16) {
                        int mask = 1 << pin - 1;
                        if (value.equalsIgnoreCase("on") || value.equals("1")) {
                            this.writeOutput(3, address, mask, mask);
                            return;
                        } else {
                            if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                            this.writeOutput(3, address, mask, 0);
                        }
                        return;
                    } else {
                        if (pin < 17 || pin > 30) return;
                        int mask = 1 << pin - 17;
                        if (value.equalsIgnoreCase("on") || value.equals("1")) {
                            this.writeOutput(4, address, mask, mask);
                            return;
                        } else {
                            if (!value.equalsIgnoreCase("off") && !value.equals("0")) return;
                            this.writeOutput(4, address, mask, 0);
                        }
                    }
                    return;
                } else {
                    int pin;
                    if (!portName.toLowerCase().startsWith("pin.") || (pin = Integer.parseInt(portName.substring(4))) < 1 || pin > 30) return;
                    if (value.equalsIgnoreCase("read")) {
                        String data = this.modEEPROMRead(address, 8 + 8 * pin, 8, false);
                        if (data == null) return;
                        this.ioWrite(true, -1, "i", device.address, "pin." + pin, data);
                        return;
                    } else {
                        if (value.length() != 16) return;
                        if (this.modEEPROMWrite(address, 8 + 8 * pin, value, false)) {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), value.toUpperCase());
                            return;
                        } else {
                            this.ioWrite(true, -1, "o", device.address, portName.toLowerCase(), "error");
                        }
                    }
                }
                return;
            }
        }
    }

    /*
     * Opcode count of 13526 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deviceStateWrite(boolean events2, boolean input, Device device, int channel, byte[] data) {
        int pointer = 2 * (device.address - 1);
        switch (device.id) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (!input) return;
                int i2 = 0;
                while (i2 < 8) {
                    this.ioWrite(events2, 1, "i", device.address, Integer.toString(i2 + 1), (data[pointer + 1] & 1 << i2) > 0 ? "1" : "0");
                    ++i2;
                }
                return;
            }
            case 20: 
            case 22: {
                if (!input) return;
                int i3 = 0;
                while (i3 < 8) {
                    this.ioWrite(events2, 1, "i", device.address, Integer.toString(8 * (channel - 1) + i3 + 1), (data[pointer + 1] & 1 << i3) > 0 ? "1" : "0");
                    ++i3;
                }
                return;
            }
            case 9: 
            case 13: 
            case 33: {
                if (!input) return;
                StringBuffer sb = new StringBuffer(this.serverName);
                sb.append(".i");
                sb.append(device.address);
                sb.append('.');
                sb.append(channel);
                String name = sb.toString();
                String state = SystemState.ioGet(name);
                int value = ((data[pointer] & 0xF) << 8) + (data[pointer + 1] & 0xFF);
                if (state == null) {
                    this.ioWrite(name, events2, -1, "i", device.address, Integer.toString(value));
                    return;
                }
                try {
                    int oldvalue = Integer.parseInt(state);
                    if (Math.abs(oldvalue - value) <= 1) return;
                    this.ioWrite(name, events2, -1, "i", device.address, Integer.toString(value));
                    return;
                }
                catch (Exception e2) {
                    this.ioWrite(name, events2, -1, "i", device.address, Integer.toString(value));
                }
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                if (!input) return;
                this.ioWrite(events2, -1, "i", device.address, Integer.toString(channel), Integer.toString(data[pointer + 1] & 0xFF));
                return;
            }
            case 12: {
                if (!input) return;
                this.ioWrite(events2, -1, "i", device.address, Integer.toString(channel), Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                return;
            }
            case 15: 
            case 18: {
                if (!input) return;
                int i4 = 0;
                while (i4 < 4) {
                    this.ioWrite(events2, 1, "i", device.address, Integer.toString(i4 + 1), (data[pointer + 1] & 1 << i4) > 0 ? "1" : "0");
                    ++i4;
                }
                return;
            }
            case 34: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            this.ioWrite(events2, -1, "i", device.address, "temp", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730));
                            return;
                        }
                        case 2: {
                            this.ioWrite(events2, -1, "i", device.address, "lux", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                            return;
                        }
                        case 3: {
                            this.ioWrite(events2, -1, "i", device.address, "wind", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                            return;
                        }
                        case 4: {
                            if ((data[pointer] & 0x40) == 0) {
                                this.ioWrite(events2, -1, "i", device.address, "rain", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "night", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "temp.limit", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "lux.limit", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "wind.limit", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "light.south", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "light.west", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "light.east", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                                this.ioWrite(events2, -1, "i", device.address, "fault", "0");
                                return;
                            }
                            this.ioWrite(events2, -1, "i", device.address, "fault", "1");
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    switch (channel) {
                        case 1: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            if (value == 0) {
                                this.ioWrite(events2, -1, "o", device.address, "temp", "off");
                                return;
                            }
                            this.ioWrite(events2, -1, "o", device.address, "temp", Integer.toString(value - 2730));
                            return;
                        }
                        case 2: {
                            this.ioWrite(events2, -1, "o", device.address, "lux", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                            return;
                        }
                        case 3: {
                            this.ioWrite(events2, -1, "o", device.address, "wind", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                        }
                    }
                }
                return;
            }
            case 35: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            this.ioWrite(events2, -1, "i", device.address, "rh", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                            return;
                        }
                        case 2: {
                            this.ioWrite(events2, -1, "i", device.address, "temp", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730));
                            return;
                        }
                        case 3: {
                            this.ioWrite(events2, -1, "i", device.address, "dewpoint", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730));
                            return;
                        }
                        case 4: {
                            this.ioWrite(events2, -1, "i", device.address, "dewpoint.1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "dewpoint.2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    switch (channel) {
                        case 1: {
                            this.ioWrite(events2, -1, "o", device.address, "dewpoint.1", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730));
                            return;
                        }
                        case 2: {
                            this.ioWrite(events2, -1, "o", device.address, "dewpoint.2", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730));
                        }
                    }
                }
                return;
            }
            case 40: 
            case 41: 
            case 42: {
                if (input) return;
                int i5 = 0;
                while (i5 < 8) {
                    this.ioWrite(events2, 1, "o", device.address, Integer.toString(i5 + 1), (data[pointer + 1] & 1 << i5) > 0 ? "1" : "0");
                    ++i5;
                }
                return;
            }
            case 43: 
            case 44: {
                if (input) return;
                int value = data[pointer + 1] & 0xFF;
                this.ioWrite(events2, 11, "o", device.address, null, String.valueOf(value) + "/255");
                return;
            }
            case 49: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            StringBuffer sb = new StringBuffer(this.serverName);
                            sb.append(".i");
                            sb.append(device.address);
                            sb.append(".lux");
                            String name = sb.toString();
                            String state = SystemState.ioGet(name);
                            int value = ((data[pointer] & 0xF) << 8) + (data[pointer + 1] & 0xFF);
                            if (state == null) {
                                this.ioWrite(name, events2, -1, "i", device.address, Integer.toString(value));
                                return;
                            }
                            try {
                                int oldvalue = Integer.parseInt(state);
                                if (Math.abs(oldvalue - value) <= 1) return;
                                this.ioWrite(name, events2, -1, "i", device.address, Integer.toString(value));
                                return;
                            }
                            catch (Exception e3) {
                                this.ioWrite(name, events2, -1, "i", device.address, Integer.toString(value));
                            }
                            return;
                        }
                        case 2: {
                            this.ioWrite(events2, -1, "i", device.address, "level", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                            return;
                        }
                        case 4: {
                            this.ioWrite(events2, -1, "i", device.address, "mode", (data[pointer + 1] & 1) > 0 ? "auto" : "man");
                            this.ioWrite(events2, -1, "i", device.address, "in", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "in1", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "in2", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                        }
                        default: {
                            return;
                        }
                    }
                }
                switch (channel) {
                    case 1: {
                        this.ioWrite(events2, -1, "o", device.address, "setpoint", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                        return;
                    }
                    case 2: {
                        this.ioWrite(events2, -1, "o", device.address, "preset", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                        return;
                    }
                    case 3: {
                        this.ioWrite(events2, -1, "o", device.address, "delay", Integer.toString(((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF)));
                        return;
                    }
                    case 4: {
                        this.ioWrite(events2, -1, "o", device.address, "mode", (data[pointer + 1] & 1) > 0 ? "auto" : "man");
                        this.ioWrite(events2, -1, "o", device.address, "in.reset", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "mode.reset", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "full.reset", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "v", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "in.disable", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "presence", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                    }
                }
                return;
            }
            case 80: {
                if (!input) return;
                int i6 = 0;
                while (i6 < 4) {
                    this.ioWrite(events2, 1, "i", device.address, Integer.toString(i6 + 1), (data[pointer + 1] & 1 << i6) > 0 ? "1" : "0");
                    ++i6;
                }
                if (device.options == 2) {
                    String state;
                    if (SystemState.deviceFunctionGet(String.valueOf(this.serverName) + ".o" + device.address + ".1") == 1) {
                        this.ioWrite(events2, 1, "o", device.address, "1", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                        this.ioWrite(events2, 1, "o", device.address, "2", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                    } else {
                        switch (data[pointer + 1] & 0x30) {
                            case 16: {
                                this.ioWrite(events2, 2, "o", device.address, "1", "up");
                                break;
                            }
                            case 32: {
                                this.ioWrite(events2, 2, "o", device.address, "1", "down");
                                break;
                            }
                            default: {
                                state = this.ioRead("o", device.address, "1");
                                if (state == null) {
                                    this.ioWrite(events2, 2, "o", device.address, "1", "unknown");
                                    break;
                                }
                                if (state.equals("up")) {
                                    this.ioWrite(events2, 2, "o", device.address, "1", "offup");
                                    break;
                                }
                                if (!state.equals("down")) break;
                                this.ioWrite(events2, 2, "o", device.address, "1", "offdown");
                            }
                        }
                    }
                    if (SystemState.deviceFunctionGet(String.valueOf(this.serverName) + ".o" + (device.address + 1) + ".3") == 1) {
                        this.ioWrite(events2, 1, "o", device.address + 1, "3", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                        this.ioWrite(events2, 1, "o", device.address + 1, "4", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                        return;
                    } else {
                        switch (data[pointer + 1] & 0xC0) {
                            case 64: {
                                this.ioWrite(events2, 2, "o", device.address + 1, "1", "up");
                                return;
                            }
                            case 128: {
                                this.ioWrite(events2, 2, "o", device.address + 1, "1", "down");
                                return;
                            }
                            default: {
                                state = this.ioRead("o", device.address + 1, "1");
                                if (state == null) {
                                    this.ioWrite(events2, 2, "o", device.address + 1, "1", "unknown");
                                    return;
                                }
                                if (state.equals("up")) {
                                    this.ioWrite(events2, 2, "o", device.address + 1, "1", "offup");
                                    return;
                                }
                                if (!state.equals("down")) return;
                                this.ioWrite(events2, 2, "o", device.address + 1, "1", "offdown");
                                return;
                            }
                        }
                    }
                } else {
                    this.ioWrite(events2, 1, "o", device.address, "1", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "2", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "3", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "4", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                }
                return;
            }
            case 81: 
            case 83: {
                if (input) {
                    int i7 = 0;
                    while (i7 < 4) {
                        this.ioWrite(events2, 1, "i", device.address, Integer.toString(i7 + 1), (data[pointer + 1] & 1 << i7) > 0 ? "1" : "0");
                        ++i7;
                    }
                    return;
                } else {
                    int i8 = 0;
                    while (i8 < 4) {
                        this.ioWrite(events2, 1, "o", device.address, Integer.toString(i8 + 1), (data[pointer + 1] & 1 << i8) > 0 ? "1" : "0");
                        ++i8;
                    }
                }
                return;
            }
            case 82: {
                if (input) {
                    int i9 = 0;
                    while (i9 < 2) {
                        this.ioWrite(events2, 1, "i", device.address, Integer.toString(i9 + 1), (data[pointer + 1] & 1 << i9) > 0 ? "1" : "0");
                        ++i9;
                    }
                    return;
                } else {
                    int i10 = 0;
                    while (i10 < 2) {
                        this.ioWrite(events2, 1, "o", device.address, Integer.toString(i10 + 1), (data[pointer + 1] & 1 << i10) > 0 ? "1" : "0");
                        ++i10;
                    }
                }
                return;
            }
            case 84: 
            case 85: 
            case 90: {
                if (!input) return;
                int value = data[pointer + 1] & 0x7F;
                if (value > 0 && value <= 100) {
                    this.ioWrite(events2, 11, "o", device.address, null, String.valueOf(value) + "%");
                    this.ioWrite(events2, 11, "i", device.address, null, String.valueOf(value) + "%");
                    return;
                } else {
                    if (value != 0) return;
                    this.ioWrite(events2, 11, "o", device.address, null, "off");
                    this.ioWrite(events2, 11, "i", device.address, null, "off");
                }
                return;
            }
            case 89: {
                if (input) {
                    int i11 = 0;
                    while (i11 < 8) {
                        this.ioWrite(events2, 1, "i", device.address, Integer.toString(i11 + 1), (data[pointer + 1] & 1 << i11) > 0 ? "1" : "0");
                        ++i11;
                    }
                    return;
                } else {
                    int i12 = 0;
                    while (i12 < 8) {
                        this.ioWrite(events2, 1, "o", device.address, Integer.toString(i12 + 1), (data[pointer + 1] & 1 << i12) > 0 ? "1" : "0");
                        ++i12;
                    }
                }
                return;
            }
            case 98: {
                if (input) return;
                switch (channel) {
                    case 1: {
                        int value = data[pointer + 1] & 0x7F;
                        if (value > 0 && value <= 100) {
                            this.ioWrite(events2, 11, "o", device.address, null, String.valueOf(value) + "%");
                            return;
                        }
                        if (value != 0) return;
                        this.ioWrite(events2, 11, "o", device.address, null, "off");
                        return;
                    }
                    case 3: {
                        this.ioWrite(events2, -1, "o", device.address, "noline", (data[pointer] & 0x10) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "overcurrent", (data[pointer] & 0x20) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "overvoltage", (data[pointer] & 0x40) > 0 ? "1" : "0");
                        this.ioWrite(events2, -1, "o", device.address, "overtemperature", (data[pointer] & 0x80) > 0 ? "1" : "0");
                    }
                }
                return;
            }
            case 129: {
                if (!input) return;
                this.ioWrite(events2, -1, "i", channel, device.address, "polling", (data[pointer] & 4) > 0 ? "off" : "on");
                this.ioWrite(events2, -1, "i", channel, device.address, "test", (data[pointer] & 0x10) > 0 ? "1" : "0");
                if ((data[pointer] & 8) > 0) {
                    this.ioWrite(events2, -1, "i", channel, device.address, "dali", "nopower");
                } else if ((data[pointer] & 0x40) > 0) {
                    this.ioWrite(events2, -1, "i", channel, device.address, "dali", "open");
                } else if ((data[pointer] & 0x80) > 0) {
                    this.ioWrite(events2, -1, "i", channel, device.address, "dali", "short");
                } else {
                    this.ioWrite(events2, -1, "i", channel, device.address, "dali", "on");
                }
                int value = data[pointer + 1] & 0xFF;
                switch (value) {
                    case 255: {
                        String state = this.ioRead("i", channel, device.address, "1");
                        if (state == null) return;
                        this.ioWrite(events2, 11, "i", channel, device.address, "1", "unknown");
                        return;
                    }
                    case 128: {
                        this.ioWrite(events2, 11, "i", channel, device.address, "1", "fault");
                        return;
                    }
                    case 129: {
                        this.ioWrite(events2, 11, "i", channel, device.address, "1", "unknown");
                        return;
                    }
                    case 0: {
                        this.ioWrite(events2, 11, "i", channel, device.address, "1", "off");
                        return;
                    }
                    default: {
                        if (value > 100) return;
                        this.ioWrite(events2, 11, "i", channel, device.address, "1", String.valueOf(value) + "%");
                    }
                }
                return;
            }
            case 131: {
                if (!input) return;
                int offset = 0;
                while (offset <= 2) {
                    if (offset == 2) {
                        channel += 4;
                    }
                    this.ioWrite(events2, -1, "i", channel, device.address, "polling", (data[pointer + offset] & 4) > 0 ? "off" : "on");
                    this.ioWrite(events2, -1, "i", channel, device.address, "test", (data[pointer + offset] & 0x10) > 0 ? "1" : "0");
                    if ((data[pointer + offset] & 0x20) > 0) {
                        this.ioWrite(events2, -1, "i", channel, device.address, "dali", "fault");
                    } else if ((data[pointer + offset] & 0x40) > 0) {
                        this.ioWrite(events2, -1, "i", channel, device.address, "dali", "open");
                    } else if ((data[pointer + offset] & 0x80) > 0) {
                        this.ioWrite(events2, -1, "i", channel, device.address, "dali", "short");
                    } else {
                        this.ioWrite(events2, -1, "i", channel, device.address, "dali", "on");
                    }
                    int value = data[pointer + 1 + offset] & 0xFF;
                    if (value > 0 && value <= 100) {
                        this.ioWrite(events2, 11, "o", device.address, Integer.toString(channel), String.valueOf(value) + "%");
                    } else if (value == 0) {
                        this.ioWrite(events2, 11, "o", device.address, Integer.toString(channel), "off");
                    }
                    offset += 2;
                }
                return;
            }
            case 130: {
                if (!input) return;
                String ps = Integer.toString(data[pointer + 1] & 0xFF);
                this.ioWrite(events2, 1, "i", device.address, Integer.toString(channel * 2 - 1), (data[pointer] & 1) > 0 ? "1" : "0");
                this.ioWrite(events2, 1, "i", device.address, Integer.toString(channel * 2), (data[pointer] & 2) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "calibration." + channel, (data[pointer] & 0x80) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "position." + channel, ps);
                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + "." + channel, "value", ps);
                switch (data[pointer] >> 4 & 3) {
                    case 1: {
                        this.ioWrite(events2, 2, "o", device.address, Integer.toString(channel), "up");
                        return;
                    }
                    case 2: {
                        this.ioWrite(events2, 2, "o", device.address, Integer.toString(channel), "down");
                        return;
                    }
                    case 0: {
                        String state = this.ioRead("o", device.address, Integer.toString(channel));
                        if (state == null) {
                            this.ioWrite(events2, 2, "o", device.address, Integer.toString(channel), "unknown");
                            return;
                        }
                        if (state.equals("up")) {
                            this.ioWrite(events2, 2, "o", device.address, Integer.toString(channel), "offup");
                            return;
                        }
                        if (!state.equals("down")) return;
                        this.ioWrite(events2, 2, "o", device.address, Integer.toString(channel), "offdown");
                    }
                }
                return;
            }
            case 145: 
            case 146: {
                if (input) {
                    this.ioWrite(events2, 1, "i", device.address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "5", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "6", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "proximity", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "led.1", (data[pointer] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "led.2", (data[pointer] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "led.3", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "led.4", (data[pointer] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "led.5", (data[pointer] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "i", device.address, "led.6", (data[pointer] & 0x20) > 0 ? "1" : "0");
                    return;
                } else {
                    this.ioWrite(events2, 1, "o", device.address, "led.1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "led.2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "led.3", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "led.4", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "led.5", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "led.6", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "disable", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "dim", (data[pointer] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "proximity", (data[pointer] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "backlight", (data[pointer] & 0x20) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "buzzer", (data[pointer] & 0x40) > 0 ? "1" : "0");
                }
                return;
            }
            case 241: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            this.ioWrite(events2, -1, "i", device.address, "door", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "window", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "panic", (data[pointer + 1] & 4) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "busy", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "1", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "2", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "dnd", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "service", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "booked", (data[pointer] & 1) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "mode", (data[pointer] & 2) > 0 ? "summer" : "winter");
                            switch (data[pointer] & 0x7C) {
                                case 4: {
                                    this.ioWrite(events2, -1, "i", device.address, "fan", "off");
                                    break;
                                }
                                case 8: {
                                    this.ioWrite(events2, -1, "i", device.address, "fan", "auto");
                                    break;
                                }
                                case 16: {
                                    this.ioWrite(events2, -1, "i", device.address, "fan", "min");
                                    break;
                                }
                                case 32: {
                                    this.ioWrite(events2, -1, "i", device.address, "fan", "med");
                                    break;
                                }
                                case 64: {
                                    this.ioWrite(events2, -1, "i", device.address, "fan", "max");
                                }
                            }
                            this.ioWrite(events2, -1, "i", device.address, "fan.status", (data[pointer] & 0x80) > 0 ? "1" : "0");
                            return;
                        }
                        case 2: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                            this.ioWrite(events2, -1, "i", device.address, "temp", Integer.toString(value));
                            return;
                        }
                        case 3: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                            this.ioWrite(events2, -1, "i", device.address, "setpoint.temp", Integer.toString(value));
                            return;
                        }
                        case 4: {
                            byte roomtag;
                            byte doortag = (byte)(data[pointer + 1] & 0xF);
                            if (this.modhtReaderTag[device.address][0] != doortag) {
                                this.modhtReaderTag[device.address][0] = doortag;
                                this.ioWrite(events2, -1, "i", device.address, "tag.door", Integer.toString(doortag));
                                if (doortag != 0) {
                                    this.readMODHTTags(events2, device.address, 0);
                                } else {
                                    this.ioWrite(events2, -1, "i", device.address, "data.door", "0");
                                }
                            }
                            if (this.modhtReaderTag[device.address][1] != (roomtag = (byte)((data[pointer + 1] & 0xF0) >> 4))) {
                                this.modhtReaderTag[device.address][1] = roomtag;
                                this.ioWrite(events2, -1, "i", device.address, "tag.room", Integer.toString(roomtag));
                                if (roomtag != 0) {
                                    this.readMODHTTags(events2, device.address, 1);
                                } else {
                                    this.ioWrite(events2, -1, "i", device.address, "data.room", "0");
                                }
                            }
                            this.ioWrite(events2, -1, "i", device.address, "pcam.error", (data[pointer] & 1) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "tpr.error", (data[pointer] & 2) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "3", (data[pointer] & 0x20) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "ev", (data[pointer] & 0x40) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "aux", (data[pointer] & 0x80) > 0 ? "1" : "0");
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (channel != 1) return;
                this.ioWrite(events2, -1, "o", device.address, "ev.enable", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "aux.enable", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                if ((data[pointer + 1] & 4) > 0) {
                    this.ioWrite(events2, -1, "o", device.address, "panic.reset", "1");
                    if (!this.disablemodhtpulsereset) {
                        try {
                            this.writeOutput(1, device.address, 4, 0);
                        }
                        catch (Exception doortag) {}
                    }
                } else {
                    this.ioWrite(events2, -1, "o", device.address, "panic.reset", "0");
                }
                this.ioWrite(events2, -1, "o", device.address, "busy", (data[pointer + 1] & 8) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "ev", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "aux", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                if ((data[pointer + 1] & 0x40) > 0) {
                    this.ioWrite(events2, -1, "o", device.address, "dnd.reset", "0");
                    if (!this.disablemodhtpulsereset) {
                        try {
                            this.writeOutput(1, device.address, 64, 0);
                        }
                        catch (Exception doortag) {}
                    }
                } else {
                    this.ioWrite(events2, -1, "o", device.address, "dnd.reset", "0");
                }
                if ((data[pointer + 1] & 0x80) > 0) {
                    this.ioWrite(events2, -1, "o", device.address, "service.reset", "0");
                    if (!this.disablemodhtpulsereset) {
                        try {
                            this.writeOutput(1, device.address, 128, 0);
                        }
                        catch (Exception doortag) {}
                    }
                } else {
                    this.ioWrite(events2, -1, "o", device.address, "service.reset", "0");
                }
                if ((data[pointer] & 0xC) > 0 && !this.disablemodhtpulsereset) {
                    try {
                        this.writeOutput(1, device.address, 3072, 0);
                    }
                    catch (Exception doortag) {
                        // empty catch block
                    }
                }
                this.ioWrite(events2, -1, "o", device.address, "comfort", (data[pointer] & 0x10) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "3", (data[pointer] & 0x20) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "fan.heating.min", (data[pointer] & 0x40) > 0 ? "1" : "0");
                this.ioWrite(events2, -1, "o", device.address, "fan.cooling.min", (data[pointer] & 0x80) > 0 ? "1" : "0");
                return;
            }
            case 243: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            if ((data[pointer] & 0x80) > 0) {
                                if (this.ioWrite(events2, -1, "i", device.address, "mode", "summer")) {
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode", "value", TEXT[this.language][2]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.summer", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.winter", "visible", "false");
                                }
                            } else if (this.ioWrite(events2, -1, "i", device.address, "mode", "winter")) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode", "value", TEXT[this.language][3]);
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.summer", "visible", "false");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.winter", "visible", "true");
                            }
                            if ((data[pointer] & 0x10) == 0) {
                                if (this.ioWrite(events2, -1, "i", device.address, null, "on")) {
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.on", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "false");
                                }
                            } else if (this.ioWrite(events2, -1, "i", device.address, null, "off")) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.mode", "value", TEXT[this.language][1]);
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "false");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.on", "visible", "false");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "true");
                            }
                            switch (data[pointer + 1] & 0x18) {
                                case 0: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "status", "off")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status", "value", TEXT[this.language][1]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.off", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.heating", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.cooling", "visible", "false");
                                    break;
                                }
                                case 8: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "status", "heating")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status", "value", TEXT[this.language][0]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.off", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.heating", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.cooling", "visible", "false");
                                    break;
                                }
                                case 16: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "status", "cooling")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status", "value", TEXT[this.language][0]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.off", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.heating", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.cooling", "visible", "true");
                                }
                            }
                            switch (data[pointer + 1] & 7) {
                                case 0: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "off")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][1]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.group", "visible", "true");
                                    break;
                                }
                                case 1: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "min")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][7]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.group", "visible", "true");
                                    break;
                                }
                                case 2: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "med")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][8]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.group", "visible", "true");
                                    break;
                                }
                                case 4: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "max")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][9]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.group", "visible", "true");
                                }
                            }
                            if ((data[pointer + 1] & 0x20) > 0) {
                                if (this.ioWrite(events2, -1, "i", device.address, "temp", "fault")) {
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".temp", "value", TEXT[this.language][6]);
                                    this.ioStore("i", device.address, "temp.fault", "1");
                                }
                            } else {
                                this.ioStore("i", device.address, "temp.fault", "0");
                            }
                            switch (data[pointer] & 0x3E) {
                                case 8: {
                                    if (this.ioWrite(events2, -1, "i", device.address, "setpoint", "1")) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint", "value", "1");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.1", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.2", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.3", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.man", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                                    }
                                    try {
                                        String v = this.ioRead("o", device.address, "setpoint.temp.1");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)Integer.parseInt(v) / 10.0) + " &deg;C");
                                    }
                                    catch (Exception v) {}
                                    break;
                                }
                                case 4: {
                                    if (this.ioWrite(events2, -1, "i", device.address, "setpoint", "2")) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint", "value", "2");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.1", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.2", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.3", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.man", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                                    }
                                    try {
                                        String v = this.ioRead("o", device.address, "setpoint.temp.2");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)Integer.parseInt(v) / 10.0) + " &deg;C");
                                    }
                                    catch (Exception v) {}
                                    break;
                                }
                                case 2: {
                                    if (this.ioWrite(events2, -1, "i", device.address, "setpoint", "3")) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint", "value", "3");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.1", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.2", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.3", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.man", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                                    }
                                    try {
                                        String v = this.ioRead("o", device.address, "setpoint.temp.3");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)Integer.parseInt(v) / 10.0) + " &deg;C");
                                    }
                                    catch (Exception v) {}
                                    break;
                                }
                                case 16: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "setpoint", "off")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint", "value", TEXT[this.language][1]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.1", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.2", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.3", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.man", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "false");
                                    break;
                                }
                                case 32: {
                                    if (this.ioWrite(events2, -1, "i", device.address, "setpoint", "man")) {
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint", "value", TEXT[this.language][5]);
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.1", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.2", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.3", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "false");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.man", "visible", "true");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                                    }
                                    try {
                                        String v = this.ioRead("o", device.address, "setpoint.temp.man");
                                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)Integer.parseInt(v) / 10.0) + " &deg;C");
                                        break;
                                    }
                                    catch (Exception v) {
                                        // empty catch block
                                    }
                                }
                            }
                            if ((data[pointer] & 0x40) > 0) {
                                if ((data[pointer] & 0x3E) == 16) {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "setpoint.mode", "off")) return;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.mode", "value", TEXT[this.language][1]);
                                    return;
                                }
                                if (!this.ioWrite(events2, -1, "i", device.address, "setpoint.mode", "man")) return;
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.mode", "value", TEXT[this.language][5]);
                                return;
                            }
                            if (!this.ioWrite(events2, -1, "i", device.address, "setpoint.mode", "auto")) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.mode", "value", TEXT[this.language][4]);
                            return;
                        }
                        case 2: {
                            int value;
                            if ("1".equals(this.ioRead("i", device.address, "temp.fault")) || !this.ioWrite(events2, -1, "i", device.address, "temp", Integer.toString(value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730))) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".temp", "visible", "true");
                        }
                        default: {
                            return;
                        }
                    }
                }
                switch (channel) {
                    case 1: {
                        int value = ((data[pointer] & 1) << 8) + (data[pointer + 1] & 0xFF);
                        if (this.ioWrite(events2, -1, "o", device.address, "setpoint.temp.man", Integer.toString(value))) {
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp.man", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            try {
                                if ("man".equals(this.ioRead("i", device.address, "setpoint"))) {
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                                }
                            }
                            catch (Exception v) {
                                // empty catch block
                            }
                        }
                        if ((data[pointer] & 0x80) > 0) {
                            this.ioWrite(events2, -1, "o", device.address, "mode", "summer");
                        } else {
                            this.ioWrite(events2, -1, "o", device.address, "mode", "winter");
                        }
                        if ((data[pointer] & 0x10) > 0) {
                            this.ioWrite(events2, -1, "o", device.address, null, "off");
                            this.ioWrite(events2, -1, "o", device.address, "setpoint.mode", "off");
                            return;
                        }
                        this.ioWrite(events2, -1, "o", device.address, null, "on");
                        if ((data[pointer] & 0x40) > 0) {
                            this.ioWrite(events2, -1, "o", device.address, "setpoint.mode", "man");
                            return;
                        }
                        this.ioWrite(events2, -1, "o", device.address, "setpoint.mode", "auto");
                        return;
                    }
                    case 2: {
                        int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                        if (!this.ioWrite(events2, -1, "o", device.address, "setpoint.temp.3", Integer.toString(value))) return;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp.3", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                        try {
                            if (!"3".equals(this.ioRead("i", device.address, "setpoint"))) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            return;
                        }
                        catch (Exception v) {}
                        return;
                    }
                    case 3: {
                        int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                        if (!this.ioWrite(events2, -1, "o", device.address, "setpoint.temp.2", Integer.toString(value))) return;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp.2", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                        try {
                            if (!"2".equals(this.ioRead("i", device.address, "setpoint"))) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            return;
                        }
                        catch (Exception v) {}
                        return;
                    }
                    case 4: {
                        int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                        if (!this.ioWrite(events2, -1, "o", device.address, "setpoint.temp.1", Integer.toString(value))) return;
                        SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp.1", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                        try {
                            if (!"1".equals(this.ioRead("i", device.address, "setpoint"))) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            return;
                        }
                        catch (Exception v) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            case 244: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            int i13 = 0;
                            while (i13 < 5) {
                                this.ioWrite(events2, 1, "i", device.address, Integer.toString(i13 + 1), (data[pointer + 1] & 1 << i13) > 0 ? "1" : "0");
                                ++i13;
                            }
                            if ((data[pointer] & 0x80) > 0) {
                                if (this.ioWrite(events2, -1, "i", device.address, "mode", "summer")) {
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode", "value", TEXT[this.language][2]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.summer", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.winter", "visible", "false");
                                }
                            } else if (this.ioWrite(events2, -1, "i", device.address, "mode", "winter")) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode", "value", TEXT[this.language][3]);
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.summer", "visible", "false");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".mode.label.winter", "visible", "true");
                            }
                            if ((data[pointer] & 0x10) == 0) {
                                if (this.ioWrite(events2, -1, "i", device.address, null, "on")) {
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.mode", "value", TEXT[this.language][0]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.on", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "false");
                                }
                            } else if (this.ioWrite(events2, -1, "i", device.address, null, "off")) {
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.mode", "value", TEXT[this.language][1]);
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "false");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.on", "visible", "false");
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.label.off", "visible", "true");
                            }
                            switch (data[pointer] & 3) {
                                case 0: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "status", "off")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status", "value", TEXT[this.language][1]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.off", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.heating", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.cooling", "visible", "false");
                                    break;
                                }
                                case 1: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "status", "heating")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status", "value", TEXT[this.language][0]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.off", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.heating", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.cooling", "visible", "false");
                                    break;
                                }
                                case 2: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "status", "cooling")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status", "value", TEXT[this.language][0]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.off", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.heating", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".status.label.cooling", "visible", "true");
                                }
                            }
                            switch (data[pointer + 1] & 0xE0) {
                                case 0: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "off")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][1]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    break;
                                }
                                case 32: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "min")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][7]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    break;
                                }
                                case 64: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "med")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][8]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                    break;
                                }
                                case 128: {
                                    if (!this.ioWrite(events2, -1, "i", device.address, "fan", "max")) break;
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan", "value", TEXT[this.language][9]);
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.min", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.med", "visible", "false");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.label.max", "visible", "true");
                                    SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".fan.button", "visible", "false");
                                }
                            }
                            if ((data[pointer] & 4) > 0) {
                                if (!this.ioWrite(events2, -1, "i", device.address, "temp", "fault")) return;
                                SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".temp", "value", TEXT[this.language][6]);
                                this.ioStore("i", device.address, "temp.fault", "1");
                                return;
                            }
                            this.ioStore("i", device.address, "temp.fault", "0");
                            return;
                        }
                        case 2: {
                            int value;
                            if ("1".equals(this.ioRead("i", device.address, "temp.fault")) || !this.ioWrite(events2, -1, "i", device.address, "temp", Integer.toString(value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730))) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".temp", "visible", "true");
                            return;
                        }
                        case 3: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                            if (!this.ioWrite(events2, -1, "i", device.address, "setpoint.temp", Integer.toString(value))) return;
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "value", String.valueOf((double)value / 10.0) + " &deg;C");
                            SystemState.uiSet(String.valueOf(this.serverName) + "." + device.address + ".setpoint.temp", "visible", "true");
                            return;
                        }
                        case 4: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "i", device.address, "knob", Integer.toString(value));
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    switch (channel) {
                        case 1: {
                            int i14 = 0;
                            while (i14 < 4) {
                                switch ((data[pointer + 1] & 17 << i14) >> i14) {
                                    case 1: {
                                        this.ioWrite(events2, -1, "o", device.address, "led." + (i14 + 1), "red");
                                        break;
                                    }
                                    case 16: {
                                        this.ioWrite(events2, -1, "o", device.address, "led." + (i14 + 1), "green");
                                        break;
                                    }
                                    case 17: {
                                        this.ioWrite(events2, -1, "o", device.address, "led." + (i14 + 1), "yellow");
                                        break;
                                    }
                                    default: {
                                        this.ioWrite(events2, -1, "o", device.address, "led." + (i14 + 1), "off");
                                    }
                                }
                                ++i14;
                            }
                            if ((data[pointer] & 0x80) > 0) {
                                this.ioWrite(events2, -1, "o", device.address, "mode", "summer");
                            } else {
                                this.ioWrite(events2, -1, "o", device.address, "mode", "winter");
                            }
                            if ((data[pointer] & 0x10) > 0) {
                                this.ioWrite(events2, -1, "o", device.address, null, "off");
                                return;
                            }
                            this.ioWrite(events2, -1, "o", device.address, null, "on");
                            return;
                        }
                        case 2: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF) - 2730;
                            this.ioWrite(events2, -1, "o", device.address, "setpoint.temp", Integer.toString(value));
                            return;
                        }
                        case 3: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "o", device.address, "setpoint.delta.neg", Integer.toString(value));
                            return;
                        }
                        case 4: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "o", device.address, "setpoint.delta.pos", Integer.toString(value));
                        }
                    }
                }
                return;
            }
            case 245: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            this.ioWrite(events2, -1, "i", device.address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "blocked", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "tpr.error", (data[pointer + 1] & 0x20) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "access.granted.1", (data[pointer + 1] & 0x40) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "access.granted.2", (data[pointer + 1] & 0x80) > 0 ? "1" : "0");
                            switch ((data[pointer] & 0xFE) >> 1) {
                                case 1: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "site");
                                    return;
                                }
                                case 2: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "code");
                                    return;
                                }
                                case 4: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "total.limit");
                                    return;
                                }
                                case 8: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "daily.limit");
                                    return;
                                }
                                case 16: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "time");
                                    return;
                                }
                                case 32: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "day");
                                    return;
                                }
                                case 64: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "expired");
                                    return;
                                }
                            }
                            this.ioWrite(events2, -1, "i", device.address, "access.denied", "0");
                            return;
                        }
                        case 2: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "i", device.address, "denied.code", Integer.toString(value));
                            return;
                        }
                        case 3: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "i", device.address, "granted.2.code", Integer.toString(value));
                            return;
                        }
                        case 4: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "i", device.address, "granted.1.code", Integer.toString(value));
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    if (channel != 1) return;
                    if ((data[pointer + 1] & 1) > 0) {
                        this.ioWrite(events2, 1, "o", device.address, "relay", "1");
                        try {
                            this.writeOutput(1, device.address, 1, 0);
                        }
                        catch (Exception i14) {}
                    } else {
                        this.ioWrite(events2, 1, "o", device.address, "relay", "0");
                    }
                    this.ioWrite(events2, 1, "o", device.address, "relay.forced", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events2, 1, "o", device.address, "block", (data[pointer + 1] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "access.granted.code", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "access.granted.total.limit", (data[pointer] & 8) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "access.granted.daily.limit", (data[pointer] & 0x10) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "access.granted.time", (data[pointer] & 0x20) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "access.granted.day", (data[pointer] & 0x40) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "access.granted.expired", (data[pointer] & 0x80) > 0 ? "1" : "0");
                }
                return;
            }
            case 132: {
                if (input) {
                    int[][] params = this.emDevicesParams.get(device.address);
                    Integer[][] partialdata = this.emDevicesPartialData.get(device.address);
                    if (params == null || partialdata == null) return;
                    int i15 = 0;
                    while (i15 < device.length) {
                        switch (params[i15][channel - 1]) {
                            case 4358: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v12", Integer.toString(value));
                                break;
                            }
                            case 4360: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v23", Integer.toString(value));
                                break;
                            }
                            case 4362: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v31", Integer.toString(value));
                                break;
                            }
                            case 4384: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "vtm", Integer.toString(value));
                                break;
                            }
                            case 4364: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "i1", Integer.toString(value));
                                break;
                            }
                            case 4366: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "i2", Integer.toString(value));
                                break;
                            }
                            case 4368: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "i3", Integer.toString(value));
                                break;
                            }
                            case 4388: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "itm", Integer.toString(value));
                                break;
                            }
                            case 276: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "ptot", Integer.toString(value));
                                if (device.address != this.emPowerDisplayAddress || Math.abs(value - this.emPower) <= this.emPowerSensivity) break;
                                this.emPower = value;
                                SystemState.powerSet(value);
                                break;
                            }
                            case 20756: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "ptotk", Integer.toString(value));
                                if (device.address != this.emPowerDisplayAddress || Math.abs((value *= 1000) - this.emPower) <= this.emPowerSensivity) break;
                                this.emPower = value;
                                SystemState.powerSet(value);
                                break;
                            }
                            case 278: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "qtot", Integer.toString(value));
                                break;
                            }
                            case 20758: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "qtotk", Integer.toString(value));
                                break;
                            }
                            case 12568: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf", Integer.toString(value));
                                break;
                            }
                            case 4370: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "frequency", Integer.toString(value));
                                break;
                            }
                            case 4352: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v1n", Integer.toString(value));
                                break;
                            }
                            case 4354: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v2n", Integer.toString(value));
                                break;
                            }
                            case 4356: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v3n", Integer.toString(value));
                                break;
                            }
                            case 324: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p1", Integer.toString(value));
                                break;
                            }
                            case 20804: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p1k", Integer.toString(value));
                                break;
                            }
                            case 326: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p2", Integer.toString(value));
                                break;
                            }
                            case 20806: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p2k", Integer.toString(value));
                                break;
                            }
                            case 328: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p3", Integer.toString(value));
                                break;
                            }
                            case 20808: {
                                int value = data[pointer + 2 * i15] << 8 | data[pointer + 1 + 2 * i15] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p3k", Integer.toString(value));
                                break;
                            }
                            case 330: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q1", Integer.toString(value));
                                break;
                            }
                            case 20810: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q1k", Integer.toString(value));
                                break;
                            }
                            case 332: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q2", Integer.toString(value));
                                break;
                            }
                            case 20812: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q2k", Integer.toString(value));
                                break;
                            }
                            case 334: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q3", Integer.toString(value));
                                break;
                            }
                            case 20814: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q3k", Integer.toString(value));
                                break;
                            }
                            case 12630: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf1", Integer.toString(value));
                                break;
                            }
                            case 12632: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf2", Integer.toString(value));
                                break;
                            }
                            case 12634: {
                                int value = (short)(((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf3", Integer.toString(value));
                                break;
                            }
                            case 336: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s1", Integer.toString(value));
                                break;
                            }
                            case 20816: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s1k", Integer.toString(value));
                                break;
                            }
                            case 338: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s2", Integer.toString(value));
                                break;
                            }
                            case 20818: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s2k", Integer.toString(value));
                                break;
                            }
                            case 340: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s3", Integer.toString(value));
                                break;
                            }
                            case 20820: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s3k", Integer.toString(value));
                                break;
                            }
                            case 322: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "stot", Integer.toString(value));
                                break;
                            }
                            case 20802: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "stotk", Integer.toString(value));
                                break;
                            }
                            case 24962: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "hours", Integer.toString(value));
                                break;
                            }
                            case 24966: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "temperature", Integer.toString(value));
                                break;
                            }
                            case 16666: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[0][0] = new Integer(value);
                                break;
                            }
                            case 28954: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[0][1] = new Integer(value);
                                break;
                            }
                            case 33050: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[0][2] = new Integer(value);
                                break;
                            }
                            case 16702: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[1][0] = new Integer(value);
                                break;
                            }
                            case 28990: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[1][1] = new Integer(value);
                                break;
                            }
                            case 33086: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[1][2] = new Integer(value);
                                break;
                            }
                            case 16668: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[2][0] = new Integer(value);
                                break;
                            }
                            case 28956: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[2][1] = new Integer(value);
                                break;
                            }
                            case 33052: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[2][2] = new Integer(value);
                                break;
                            }
                            case 16704: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[3][0] = new Integer(value);
                                break;
                            }
                            case 28992: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[3][1] = new Integer(value);
                                break;
                            }
                            case 33088: {
                                int value = ((data[pointer + 2 * i15] & 0xFF) << 8) + (data[pointer + 1 + 2 * i15] & 0xFF);
                                partialdata[3][2] = new Integer(value);
                            }
                        }
                        ++i15;
                    }
                    return;
                } else {
                    this.ioWrite(events2, -1, "o", device.address, "reset.energy", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "reset.hours", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                }
                return;
            }
            case 246: {
                if (input) {
                    int[][] params = this.emDevicesParams.get(device.address);
                    Integer[][] partialdata = this.emDevicesPartialData.get(device.address);
                    if (params == null || partialdata == null) return;
                    int i16 = 0;
                    while (i16 < device.length) {
                        switch (params[i16][channel - 1]) {
                            case 100: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v12", Integer.toString(value));
                                break;
                            }
                            case 102: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v23", Integer.toString(value));
                                break;
                            }
                            case 104: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v31", Integer.toString(value));
                                break;
                            }
                            case 106: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "vtm", Integer.toString(value));
                                break;
                            }
                            case 108: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "i1", Integer.toString(value));
                                break;
                            }
                            case 110: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "i2", Integer.toString(value));
                                break;
                            }
                            case 112: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "i3", Integer.toString(value));
                                break;
                            }
                            case 114: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "itm", Integer.toString(value));
                                break;
                            }
                            case 116: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "ptot", Integer.toString(value));
                                if (device.address != this.emPowerDisplayAddress || Math.abs(value - this.emPower) <= this.emPowerSensivity) break;
                                this.emPower = value;
                                SystemState.powerSet(value);
                                break;
                            }
                            case 20596: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "ptotk", Integer.toString(value));
                                if (device.address != this.emPowerDisplayAddress || Math.abs((value *= 1000) - this.emPower) <= this.emPowerSensivity) break;
                                this.emPower = value;
                                SystemState.powerSet(value);
                                break;
                            }
                            case 118: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "qtot", Integer.toString(value));
                                break;
                            }
                            case 20598: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "qtotk", Integer.toString(value));
                                break;
                            }
                            case 12408: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf", Integer.toString(value));
                                break;
                            }
                            case 122: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "frequency", Integer.toString(value));
                                break;
                            }
                            case 124: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v1n", Integer.toString(value));
                                break;
                            }
                            case 126: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v2n", Integer.toString(value));
                                break;
                            }
                            case 128: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "v3n", Integer.toString(value));
                                break;
                            }
                            case 130: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p1", Integer.toString(value));
                                break;
                            }
                            case 20610: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p1k", Integer.toString(value));
                                break;
                            }
                            case 132: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p2", Integer.toString(value));
                                break;
                            }
                            case 20612: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p2k", Integer.toString(value));
                                break;
                            }
                            case 134: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p3", Integer.toString(value));
                                break;
                            }
                            case 20614: {
                                int value = data[pointer + 2 * i16] << 8 | data[pointer + 1 + 2 * i16] & 0xFF;
                                this.ioWrite(events2, -1, "i", device.address, "p3k", Integer.toString(value));
                                break;
                            }
                            case 136: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q1", Integer.toString(value));
                                break;
                            }
                            case 20616: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q1k", Integer.toString(value));
                                break;
                            }
                            case 138: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q2", Integer.toString(value));
                                break;
                            }
                            case 20618: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q2k", Integer.toString(value));
                                break;
                            }
                            case 140: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q3", Integer.toString(value));
                                break;
                            }
                            case 20620: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "q3k", Integer.toString(value));
                                break;
                            }
                            case 12430: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf1", Integer.toString(value));
                                break;
                            }
                            case 12432: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf2", Integer.toString(value));
                                break;
                            }
                            case 12434: {
                                int value = (short)(((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF));
                                this.ioWrite(events2, -1, "i", device.address, "pf3", Integer.toString(value));
                                break;
                            }
                            case 148: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s1", Integer.toString(value));
                                break;
                            }
                            case 20628: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s1k", Integer.toString(value));
                                break;
                            }
                            case 150: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s2", Integer.toString(value));
                                break;
                            }
                            case 20630: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s2k", Integer.toString(value));
                                break;
                            }
                            case 152: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s3", Integer.toString(value));
                                break;
                            }
                            case 20632: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "s3k", Integer.toString(value));
                                break;
                            }
                            case 154: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "stot", Integer.toString(value));
                                break;
                            }
                            case 20634: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "stotk", Integer.toString(value));
                                break;
                            }
                            case 24732: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "hours", Integer.toString(value));
                                break;
                            }
                            case 158: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "temperature", Integer.toString(value));
                                break;
                            }
                            case 16584: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[0][0] = new Integer(value);
                                break;
                            }
                            case 4296: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[0][1] = new Integer(value);
                                break;
                            }
                            case 8394: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[0][2] = new Integer(value);
                                break;
                            }
                            case 16587: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[1][0] = new Integer(value);
                                break;
                            }
                            case 4299: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[1][1] = new Integer(value);
                                break;
                            }
                            case 8397: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[1][2] = new Integer(value);
                                break;
                            }
                            case 16590: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[2][0] = new Integer(value);
                                break;
                            }
                            case 4302: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[2][1] = new Integer(value);
                                break;
                            }
                            case 8400: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[2][2] = new Integer(value);
                                break;
                            }
                            case 16593: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[3][0] = new Integer(value);
                                break;
                            }
                            case 4305: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[3][1] = new Integer(value);
                                break;
                            }
                            case 8403: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                partialdata[3][2] = new Integer(value);
                                break;
                            }
                            case 212: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "pm", Integer.toString(value));
                                break;
                            }
                            case 216: {
                                int value = ((data[pointer + 2 * i16] & 0xFF) << 8) + (data[pointer + 1 + 2 * i16] & 0xFF);
                                this.ioWrite(events2, -1, "i", device.address, "qm", Integer.toString(value));
                            }
                        }
                        ++i16;
                    }
                    return;
                } else {
                    this.ioWrite(events2, -1, "o", device.address, "reset.energy", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "o", device.address, "reset.hours", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                }
                return;
            }
            case 247: {
                if (input) {
                    switch (channel) {
                        case 1: {
                            this.ioWrite(events2, -1, "i", device.address, "1", (data[pointer + 1] & 1) > 0 ? "1" : "0");
                            this.ioWrite(events2, -1, "i", device.address, "2", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                            switch (data[pointer] & 0xF) {
                                case 1: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "site");
                                    return;
                                }
                                case 2: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "code");
                                    return;
                                }
                                case 4: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "time");
                                    return;
                                }
                                case 8: {
                                    this.ioWrite(events2, -1, "i", device.address, "access.denied", "day");
                                    return;
                                }
                            }
                            this.ioWrite(events2, -1, "i", device.address, "access.denied", "0");
                            return;
                        }
                        case 2: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            this.ioWrite(events2, -1, "i", device.address, "pin", Integer.toString(value));
                            return;
                        }
                        case 3: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            int i17 = 0;
                            while (i17 < 16) {
                                this.ioWrite(events2, -1, "i", device.address, "access.granted." + (i17 + 1), (value & 1 << i17) > 0 ? "1" : "0");
                                ++i17;
                            }
                            return;
                        }
                        case 4: {
                            int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                            int i18 = 0;
                            while (i18 < 14) {
                                this.ioWrite(events2, -1, "i", device.address, "access.granted." + (i18 + 17), (value & 1 << i18) > 0 ? "1" : "0");
                                ++i18;
                            }
                        }
                        default: {
                            return;
                        }
                    }
                }
                switch (channel) {
                    case 1: {
                        if ((data[pointer + 1] & 1) > 0) {
                            this.ioWrite(events2, -1, "o", device.address, "relay", "1");
                            try {
                                this.writeOutput(1, device.address, 1, 0);
                                return;
                            }
                            catch (Exception i18) {}
                            return;
                        }
                        this.ioWrite(events2, -1, "o", device.address, "relay", "0");
                        return;
                    }
                    case 3: {
                        int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                        int i19 = 0;
                        while (i19 < 16) {
                            this.ioWrite(events2, -1, "o", device.address, "lock." + (i19 + 1), (value & 1 << i19) > 0 ? "1" : "0");
                            ++i19;
                        }
                        return;
                    }
                    case 4: {
                        int value = ((data[pointer] & 0xFF) << 8) + (data[pointer + 1] & 0xFF);
                        int i20 = 0;
                        while (i20 < 14) {
                            this.ioWrite(events2, -1, "o", device.address, "lock." + (i20 + 17), (value & 1 << i20) > 0 ? "1" : "0");
                            ++i20;
                        }
                        this.ioWrite(events2, -1, "o", device.address, "lock.all", (value & 0x4000) > 0 ? "1" : "0");
                    }
                }
                return;
            }
            case 248: {
                if (!input || channel != 1) return;
                if ((data[pointer] & 0x80) == 0) {
                    this.ioWrite(events2, -1, "i", device.address, "reader.error", "0");
                    this.ioWrite(events2, -1, "i", device.address, "tag.error", (data[pointer] & 1) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "i", device.address, "request.error", (data[pointer] & 2) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "i", device.address, "data.error", (data[pointer] & 4) > 0 ? "1" : "0");
                    this.ioWrite(events2, -1, "i", device.address, "unknown.error", (data[pointer] & 8) > 0 ? "1" : "0");
                    String tagstatus = Integer.toString(data[pointer + 1] & 3);
                    if (tagstatus.equals(this.ioRead("i", device.address, "tag.status"))) return;
                    this.ioStore("i", device.address, "tag.status", tagstatus);
                    if ((data[pointer + 1] & 3) != 0) {
                        byte[] tagdata = this.readModuleRAM(device.address, 256, 15);
                        if (tagdata != null && tagdata.length == 20) {
                            this.ioWrite(events2, -1, "i", device.address, "data", util.decodeHex(Arrays.copyOfRange(tagdata, 5, 20)));
                        } else {
                            this.ioWrite(events2, -1, "i", device.address, "data", "0");
                        }
                    } else {
                        this.ioWrite(events2, -1, "i", device.address, "data", "0");
                    }
                    this.ioWrite(events2, -1, "i", device.address, "data.write", (data[pointer + 1] & 2) > 0 ? "1" : "0");
                    return;
                } else {
                    this.ioWrite(events2, -1, "i", device.address, "reader.error", "1");
                }
                return;
            }
            case 133: {
                if ((!input || channel != 1) && channel != 2) return;
                int value = data[pointer] << 8 | data[pointer + 1] & 0xFF;
                this.ioWrite(events2, -1, "i", device.address, Integer.toString(channel), Integer.toString(value));
                return;
            }
        }
    }

    private boolean modEEPROMWrite(int address, int eepromaddress, String hex, boolean external) {
        int size = hex.length() / 2;
        if (size > 0) {
            byte[] bytea = new byte[size];
            int i2 = 0;
            while (i2 < size) {
                bytea[i2] = (byte)Integer.parseInt(hex.substring(i2 * 2, (i2 + 1) * 2), 16);
                ++i2;
            }
            return external ? this.writeModuleExternalEEPROM(address, eepromaddress, bytea) : this.writeModuleEEPROM(address, eepromaddress, bytea);
        }
        return false;
    }

    private String modEEPROMRead(int address, int eepromaddress, int size, boolean external) {
        if (external) {
            byte[] data = this.readModuleExternalEEPROM(address, eepromaddress, size);
            if (data != null && data.length == size + 6) {
                return util.decodeHex(Arrays.copyOfRange(data, 6, size + 6));
            }
            return null;
        }
        byte[] data = this.readModuleEEPROM(address, eepromaddress, size);
        if (data != null && data.length == size + 5) {
            return util.decodeHex(Arrays.copyOfRange(data, 5, size + 5));
        }
        return null;
    }

    private void ioStore(String prefix, int address, String datapoint, String value) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        if (datapoint != null) {
            sb.append('.');
            sb.append(datapoint);
        }
        this.states.put(sb.toString(), value);
    }

    private void ioStore(String prefix, int channel, int address, String datapoint, String value) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        sb.append('.');
        sb.append(channel);
        if (datapoint != null) {
            sb.append('.');
            sb.append(datapoint);
        }
        this.states.put(sb.toString(), value);
    }

    private boolean ioWrite(boolean events2, int function, String prefix, int address, String datapoint, String value) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        if (datapoint != null) {
            sb.append('.');
            sb.append(datapoint);
        }
        String name = sb.toString();
        return this.ioWrite(name, events2, function, prefix, address, value);
    }

    private boolean ioWrite(boolean events2, int function, String prefix, int channel, int address, String datapoint, String value) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        sb.append('.');
        sb.append(channel);
        if (datapoint != null) {
            sb.append('.');
            sb.append(datapoint);
        }
        String name = sb.toString();
        return this.ioWrite(name, events2, function, prefix, address, value);
    }

    private boolean ioWrite(String name, boolean events2, int function, String prefix, int address, String value) {
        String state = this.states.get(name);
        if (value == null) {
            this.states.remove(name);
            SystemState.ioWriteNoEvents(name, value);
            return true;
        }
        if (state == null || !state.equals(value)) {
            this.states.put(name, value);
            if (function != -1) {
                switch (prefix.charAt(0)) {
                    case 'i': {
                        Device device;
                        if (!this.inputdiscovery || (device = this.inputDevices.get(address)) == null) break;
                        SystemState.deviceSet(false, function, name, value, device.model);
                        break;
                    }
                    case 'v': {
                        if (!this.virtualdiscovery) break;
                        if (address == 0) {
                            SystemState.deviceSet(false, function, name, value, "MCPXT");
                            break;
                        }
                        Device device = this.outputDevices.get(address);
                        if (device == null) break;
                        SystemState.deviceSet(false, function, name, value, device.model);
                        break;
                    }
                    case 'o': {
                        Device device;
                        if (!this.outputdiscovery || (device = this.outputDevices.get(address)) == null) break;
                        SystemState.deviceSet(false, function, name, value, device.model);
                    }
                }
            }
            if (events2) {
                if (this.synchronousEvents) {
                    SystemState.ioWriteSynchronous(name, value);
                } else {
                    SystemState.ioWrite(name, value);
                }
            } else {
                SystemState.ioWriteNoEvents(name, value);
            }
            return true;
        }
        return false;
    }

    private String ioRead(String prefix, int address, String datapoint) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        sb.append('.');
        sb.append(datapoint);
        String name = sb.toString();
        return this.states.get(name);
    }

    private String ioRead(String prefix, int channel, int address, String datapoint) {
        StringBuffer sb = new StringBuffer(this.serverName);
        sb.append('.');
        sb.append(prefix);
        sb.append(address);
        sb.append('.');
        sb.append(channel);
        sb.append('.');
        sb.append(datapoint);
        String name = sb.toString();
        return this.states.get(name);
    }

    private void initializeIds() {
        this.ids.put(1, new DeviceFeatures("MOD8I/A", 0, 0));
        this.ids.put(2, new DeviceFeatures("MOD32I/A", 1, 0));
        this.ids.put(3, new DeviceFeatures("MOD8INP2/A", 0, 0));
        this.ids.put(4, new DeviceFeatures("MOD8INP2/C", 0, 0));
        this.ids.put(5, new DeviceFeatures("MOAN/I", 0, 0));
        this.ids.put(6, new DeviceFeatures("MOAN/I4", 1, 0));
        this.ids.put(7, new DeviceFeatures("MI420", 0, 0));
        this.ids.put(8, new DeviceFeatures("MI420-X4", 1, 0));
        this.ids.put(9, new DeviceFeatures("MOD4AM12/V/I", 0, 0));
        this.ids.put(10, new DeviceFeatures("MOD2PT", 1, 0));
        this.ids.put(12, new DeviceFeatures("MODCNT", 0, 0));
        this.ids.put(13, new DeviceFeatures("MODNTC", 0, 0));
        this.ids.put(15, new DeviceFeatures("MOD4I/A", 0, 0));
        this.ids.put(18, new DeviceFeatures("MOD4I/S", 0, 0));
        this.ids.put(20, new DeviceFeatures("MOD32IN", 1, 0));
        this.ids.put(22, new DeviceFeatures("MOD32IL", 1, 0));
        this.ids.put(33, new DeviceFeatures("MODLUX", 0, 0));
        this.ids.put(34, new DeviceFeatures("MODMETEO", 0, 0));
        this.ids.put(35, new DeviceFeatures("MODRHT", 0, 0));
        this.ids.put(40, new DeviceFeatures("MOD8R", 0, 0));
        this.ids.put(41, new DeviceFeatures("MODPNP", 0, 0));
        this.ids.put(42, new DeviceFeatures("MODREL", 0, 0));
        this.ids.put(43, new DeviceFeatures("MOAN/U", 0, 0));
        this.ids.put(44, new DeviceFeatures("MO420", 0, 0));
        this.ids.put(49, new DeviceFeatures("MODLC", 0, 0));
        this.ids.put(80, new DeviceFeatures("MOD4-4S", 0, 0));
        this.ids.put(81, new DeviceFeatures("MOD4-4R", 0, 0));
        this.ids.put(82, new DeviceFeatures("MOD2-2R", 0, 0));
        this.ids.put(83, new DeviceFeatures("MOD4-4", 0, 0));
        this.ids.put(84, new DeviceFeatures("MOD2DM", 1, 1));
        this.ids.put(85, new DeviceFeatures("MOD2DV", 1, 1));
        this.ids.put(89, new DeviceFeatures("MOD8IL", 0, 0));
        this.ids.put(90, new DeviceFeatures("MOD4DV", 1, 1));
        this.ids.put(97, new DeviceFeatures("MODDMX", 0, 0));
        this.ids.put(98, new DeviceFeatures("MODDI", 0, 0));
        this.ids.put(129, new DeviceFeatures("MODDALI", 0, 0));
        this.ids.put(130, new DeviceFeatures("MOD4TP", 1, 1));
        this.ids.put(131, new DeviceFeatures("MODDALI8", 2, 1));
        this.ids.put(132, new DeviceFeatures("MODANAM", 0, 0));
        this.ids.put(133, new DeviceFeatures("MODAM2", 0, 0));
        this.ids.put(145, new DeviceFeatures("MODIGLASS", 1, 1));
        this.ids.put(146, new DeviceFeatures("MODIGLASS3", 1, 1));
        this.ids.put(241, new DeviceFeatures("MODHT", 0, 0));
        this.ids.put(243, new DeviceFeatures("MODCL", 0, 0));
        this.ids.put(244, new DeviceFeatures("CLIMA2", 0, 0));
        this.ids.put(245, new DeviceFeatures("MODCA", 0, 0));
        this.ids.put(246, new DeviceFeatures("MODANA", 0, 0));
        this.ids.put(247, new DeviceFeatures("MODKB", 0, 0));
        this.ids.put(248, new DeviceFeatures("MODPQ5", 0, 0));
    }

    class Device {
        int address;
        int id;
        int options;
        boolean input;
        int length;
        int channels;
        int vfail;
        String model;
        int rangeid = -1;

        Device(int address, int id, int options, boolean input, int length, int channels, int vfail) {
            this.address = address;
            this.id = id;
            this.options = options;
            this.input = input;
            this.length = length;
            this.channels = channels;
            this.vfail = vfail;
            this.model = ((DeviceFeatures)((Contatto)Contatto.this).ids.get((Object)Integer.valueOf((int)id))).model;
        }

        Device(int address, int id, boolean input, int length, int channels, int vfail) {
            this.address = address;
            this.id = id;
            this.options = 0;
            this.input = input;
            this.length = length;
            this.channels = channels;
            this.vfail = vfail;
            this.model = ((DeviceFeatures)((Contatto)Contatto.this).ids.get((Object)Integer.valueOf((int)id))).model;
        }
    }

    class DeviceFeatures {
        String model;
        int inlength;
        int outlength;

        DeviceFeatures(String model, int inlength, int outlength) {
            this.model = model;
            this.inlength = inlength;
            this.outlength = outlength;
        }
    }

    class MemoryRange {
        int from;
        int size;
        byte[] data;
        boolean initialized = false;
        int channel;

        MemoryRange(int from, int size) {
            this.from = from;
            this.size = size;
            this.channel = 0;
            this.data = new byte[size];
        }

        MemoryRange(int from, int size, int channel) {
            this.from = from;
            this.size = size;
            this.channel = channel;
            this.data = new byte[size];
        }

        boolean equals(byte[] a2) {
            if (this.initialized) {
                return Arrays.equals(this.data, a2);
            }
            return false;
        }

        boolean equalsCopy(byte[] a2) {
            if (this.data.length == a2.length) {
                if (this.initialized) {
                    if (!Arrays.equals(this.data, a2)) {
                        int i2 = 0;
                        while (i2 < this.data.length) {
                            this.data[i2] = a2[i2];
                            ++i2;
                        }
                        return false;
                    }
                    return true;
                }
                int i3 = 0;
                while (i3 < this.data.length) {
                    this.data[i3] = a2[i3];
                    ++i3;
                }
                this.initialized = true;
                return false;
            }
            return false;
        }

        void copy(byte[] a2) {
            if (this.data.length == a2.length) {
                this.initialized = true;
                int i2 = 0;
                while (i2 < this.data.length) {
                    this.data[i2] = a2[i2];
                    ++i2;
                }
            }
        }
    }
}

