/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.userBase;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class CSX75 {
    public static final String[] WebObjects = new String[]{"csx75"};
    private String serverName;
    private String commPort;
    private ArrayBlockingQueue<String> ioqtx;
    private int language;
    private DateFormat dateFormat;
    private Vector<String> logs;
    private boolean guiSupport = true;
    private boolean genEvents = false;
    private boolean genLogs = false;
    private long pollinterval = 3000L;
    private byte[] pin = null;
    private int logSize = 20;
    private int maxZone = 168;
    private static final String[][] LOG_STRINGS = new String[][]{{"Tamper - ", "Manomissione - ", "Sabotage - "}, {"Tamper restore - ", "Manomissione ripristinata - ", "Sabotage restauree - "}, {"Trouble - ", "Problema - ", "Probleme - "}, {"Trouble restore - ", "Problema ripristinato", "Probleme restauree - "}, {"Bypass - ", "Esclusione - ", "Exclusion - "}, {"Bypass restore - ", "Esclusione disattivata - ", "Exclusion d\ufffdsactivee - "}, {"Inhibited - ", "Inibizione - ", "Inhibition - "}, {"Inhibited restore - ", "Inibizione disattivata - ", "Inhibition d\ufffdsactivee - "}, {"Low battery - ", "Batteria scarica - ", "Batterie basse - "}, {"Low battery restore - ", "Batteria ripristinata - ", "Batterie retablie - "}, {"Loss of supervision - ", "Perdita supervisione - ", "Manque surveillance - "}, {"Loss of supervision restore - ", "Supervisione ripristinata - ", "Surveillance restauree - "}, {"Alarm - Partition ", "Allarme - Area ", "Alarme - Zone "}, {"Alarm restore - Partition ", "Allarme ripristinato - Area ", "Alarme restauree - Zone "}, {"Login user: %U - Partition ", "Login utente: %U - Area ", "Login utilisateur: %U - Zone "}, {"Fire trouble - Partition ", "Problema incendio - Area ", "Probleme incendie - Zone "}, {"Fire trouble restore - Partition ", "Problema incendio ripristinato - Area ", "Probl\ufffdme incendie restauree - Zone "}, {"Fire - Partition ", "Incendio - Area ", "Incendie - Zone "}, {"Fire restore - Partition ", "Incendio ripristinato - Area ", "Incendie restauree - Zone "}, {"TLM fault - Partition ", "TLM guasto - Area ", "TLM echec - Zone "}, {"TLM fault restore - Partition ", "TLM ripristinato - Area ", "TLM restauree - Zone "}, {"Disarmed - Partition ", "Disinserito - Area ", "Desarmer - Zone "}, {"Armed (away) - Partition ", "Inserito (totale) - Area ", "Armee (total) - Zone "}, {"Armed (stay) - Partition ", "Inserito (perimetrale) - Area ", "Armee (perimetre) - Zone "}, {"Tamper - Partition ", "Manomissione - Area ", "Sabotage - Zone "}, {"Tamper restore - Partition ", "Manomissione ripristinata - Area ", "Sabotage restauree - Zone "}, {"Cancel - Partition ", "Annulla - Area ", "Annuler - Zone "}, {"Exit error - Partition ", "Errore uscita - Area ", "Erreur sortie - Zone "}, {"Re-exit - Partition ", "Riavvio uscita - Area ", "Redemarrer sortie - Zone "}, {"Fail to communicate", "Comunicazione mancata", "Communication \ufffdchec"}, {"Communication restore", "Ripristino comunicazione", "Communication restauree"}, {"Fuse fault", "Fusibile guasto", "Fusible echec"}, {"Fuse fault restore", "Fusibile ripristinato", "Fusible restauree"}, {"Panel tamper", "Manomissione pannello", "Sabotage panneau"}, {"Panel tamper restore", "Manomissione pannello ripristinata", "Sabotage panneau restauree"}, {"Siren tamper", "Manomissione sirena", "Sabotage sirene"}, {"Siren tamper restore", "Manomissione sirena ripristinata", "Sabotage sirene restauree"}, {"Low battery", "Batteria scarica", "Batterie basse"}, {"Low battery restore", "Batteria ripristinata", "Batterie retablie"}, {"AC fail", "AC guasto", "AC echec"}, {"AC fail restore", "AC ripristinato", "AC restauree"}, {"Expander tamper", "Manomissione espansore", "Sabotage extenseur"}, {"Expander tamper restore", "Manomissione espansore ripristinata", "Sabotage extenseur restauree"}, {"Expander AC fail", "AC espansore guasto", "AC extenseur echec"}, {"Expander AC fail restore", "AC espansore ripristinato", "AC extenseur restauree"}, {"Expander low battery", "Batteria espansore scarica", "Batterie extenseuer basse"}, {"Expander low battery restore", "Batteria espansore ripristinata", "Batterie extenseuer restauree"}, {"Expander failure", "Espansore guasto", "Extenseuer echec"}, {"Expander failure restore", "Espansore ripristinato", "Extenseuer restauree"}, {"Bus line fault", "Linea bus guasta", "Ligne de bus echec"}, {"Bus line fault restore", "Linea bus ripristinata", "Ligne de bus restauree"}, {"Walk test mode on", "Walk test attivato", "Walk test active"}, {"Walk test mode off", "Walk test disattivato", "Walk test desactive"}};
    private byte[] interface_config_req;
    private byte[] system_status_req;
    private byte[] clock_req_2;
    private byte[] set_clock_req;
    private byte[] zone_status_req;
    private byte[] zone_name_req;
    private byte[] partition_status_req;
    private byte[] primary_keypad_func;
    private byte[] secondary_keypad_func;
    private byte[] zone_bypass_toggle;
    private byte[] send_x10_msg;
    private byte[] positive_acknowledge;
    private byte[] getCS507_request;
    private byte[] setCS507_output;
    private byte[] setCS507_holidays;
    private byte[] setCS507_user;
    private byte[] setCS507_program;
    private HashMap<Integer, Partition> partitions;
    private HashMap<Integer, Zone> zones;
    private HashMap<Integer, User> users;
    private String firmware;
    private byte panelID;
    private byte commFail;
    private byte fuseFault;
    private byte panelTamper;
    private byte sirenTamper;
    private byte acFail;
    private byte expanderTamper;
    private byte expanderAcFail;
    private byte expanderBatteryLow;
    private byte batteryLow;
    private byte expanderFault;
    private int pinDigits;
    private byte buzzer;
    private byte siren;
    private byte steadySiren;
    private byte busLineFault;
    private byte acPower;
    private byte batteryLowMem;
    private byte powerUpDelay;
    private byte walkTest;
    private byte sysTimeLoss;
    private byte[] keypadPin;
    private byte keypadPinIndex;
    private byte sysArmed;
    private long logTime;
    private long pinInputTime;
    private boolean initStatus;
    private HashMap<Integer, Vector<String>> zoneSessions;

    public CSX75() {
        byte[] byArray = new byte[5];
        byArray[0] = 126;
        byArray[1] = 1;
        byArray[2] = 33;
        this.interface_config_req = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[0] = 126;
        byArray2[1] = 1;
        byArray2[2] = 40;
        this.system_status_req = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 126;
        byArray3[1] = 4;
        byArray3[2] = 48;
        byArray3[3] = 8;
        byArray3[4] = -112;
        byArray3[5] = 111;
        this.clock_req_2 = byArray3;
        byte[] byArray4 = new byte[11];
        byArray4[0] = 126;
        byArray4[1] = 7;
        byArray4[2] = 59;
        this.set_clock_req = byArray4;
        byte[] byArray5 = new byte[6];
        byArray5[0] = 126;
        byArray5[1] = 2;
        byArray5[2] = 36;
        this.zone_status_req = byArray5;
        byte[] byArray6 = new byte[6];
        byArray6[0] = 126;
        byArray6[1] = 2;
        byArray6[2] = 35;
        this.zone_name_req = byArray6;
        byte[] byArray7 = new byte[6];
        byArray7[0] = 126;
        byArray7[1] = 2;
        byArray7[2] = 38;
        this.partition_status_req = byArray7;
        byte[] byArray8 = new byte[10];
        byArray8[0] = 126;
        byArray8[1] = 6;
        byArray8[2] = 60;
        this.primary_keypad_func = byArray8;
        byte[] byArray9 = new byte[7];
        byArray9[0] = 126;
        byArray9[1] = 3;
        byArray9[2] = 62;
        this.secondary_keypad_func = byArray9;
        byte[] byArray10 = new byte[6];
        byArray10[0] = 126;
        byArray10[1] = 2;
        byArray10[2] = 63;
        this.zone_bypass_toggle = byArray10;
        byte[] byArray11 = new byte[8];
        byArray11[0] = 126;
        byArray11[1] = 4;
        byArray11[2] = 41;
        this.send_x10_msg = byArray11;
        byte[] byArray12 = new byte[5];
        byArray12[0] = 126;
        byArray12[1] = 1;
        byArray12[2] = 29;
        this.positive_acknowledge = byArray12;
        byte[] byArray13 = new byte[8];
        byArray13[0] = 126;
        byArray13[1] = 4;
        byArray13[2] = 48;
        byArray13[4] = -128;
        this.getCS507_request = byArray13;
        byte[] byArray14 = new byte[17];
        byArray14[0] = 126;
        byArray14[1] = 13;
        byArray14[2] = 49;
        byArray14[4] = -96;
        byArray14[6] = 6;
        this.setCS507_output = byArray14;
        byte[] byArray15 = new byte[17];
        byArray15[0] = 126;
        byArray15[1] = 13;
        byArray15[2] = 49;
        byArray15[4] = -96;
        byArray15[6] = 7;
        this.setCS507_holidays = byArray15;
        byte[] byArray16 = new byte[17];
        byArray16[0] = 126;
        byArray16[1] = 13;
        byArray16[2] = 49;
        byArray16[4] = -96;
        this.setCS507_user = byArray16;
        byte[] byArray17 = new byte[17];
        byArray17[0] = 126;
        byArray17[1] = 13;
        byArray17[2] = 49;
        byArray17[4] = -96;
        byArray17[6] = 4;
        this.setCS507_program = byArray17;
        this.partitions = new HashMap();
        this.zones = new HashMap();
        this.users = new HashMap();
        this.commFail = (byte)119;
        this.fuseFault = (byte)119;
        this.panelTamper = (byte)119;
        this.sirenTamper = (byte)119;
        this.acFail = (byte)119;
        this.expanderTamper = (byte)119;
        this.expanderAcFail = (byte)119;
        this.expanderBatteryLow = (byte)119;
        this.batteryLow = (byte)119;
        this.expanderFault = (byte)119;
        this.buzzer = (byte)119;
        this.siren = (byte)119;
        this.steadySiren = (byte)119;
        this.busLineFault = (byte)119;
        this.acPower = (byte)119;
        this.batteryLowMem = (byte)119;
        this.powerUpDelay = (byte)119;
        this.walkTest = (byte)119;
        this.sysTimeLoss = (byte)119;
        this.keypadPin = null;
        this.keypadPinIndex = 0;
        this.sysArmed = (byte)119;
        this.initStatus = true;
        this.zoneSessions = new HashMap();
    }

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        this.commPort = Configuration.ioServersComm.elementAt(ioIndex);
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        hsyco.messageLog("ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollinterval = itvl * 1000;
                    }
                    catch (Exception e2) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("pin")) {
                    try {
                        if (value.length() != 4 && value.length() != 6) {
                            throw new Exception();
                        }
                        byte[] pinTemp = new byte[value.length()];
                        int c2 = 0;
                        while (c2 < value.length()) {
                            byte d2;
                            pinTemp[c2] = d2 = Byte.parseByte("" + value.charAt(c2));
                            ++c2;
                        }
                        this.pin = pinTemp;
                    }
                    catch (Exception e3) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - pin ignored");
                    }
                } else if (param.equalsIgnoreCase("logsize")) {
                    try {
                        int l2 = Integer.parseInt(value);
                        if (l2 < 0) {
                            throw new Exception();
                        }
                        this.logSize = l2;
                    }
                    catch (Exception e4) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - logsize ignored");
                    }
                } else if (param.equalsIgnoreCase("maxzone")) {
                    try {
                        int m2 = Integer.parseInt(value);
                        if (m2 <= 0) {
                            throw new Exception();
                        }
                        this.maxZone = m2;
                    }
                    catch (Exception e5) {
                        hsyco.errorLog("ioMonitor - ioServersOption format error [" + this.serverName + "] - maxzone ignored");
                    }
                }
            }
            ++i2;
        }
        switch (Configuration.language) {
            case 1: {
                this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ITALIAN);
                this.language = 1;
                break;
            }
            case 2: {
                this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.FRENCH);
                this.language = 2;
                break;
            }
            default: {
                this.dateFormat = new SimpleDateFormat("dd MMM HH:mm:ss", Locale.ENGLISH);
                this.language = 0;
            }
        }
        this.loadLogs();
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 30, this);
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "panel", "false");
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init(me);
            this.initStatus = false;
            this.polling(me, false);
            this.genLogs = true;
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
            this.securityLog("Online");
            try {
                userCode.IOStartupEvent(ioIndex);
            }
            catch (Exception e6) {
                hsyco.errorLog("ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e6);
            }
            if (ioIndex > 0) {
                events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
            } else {
                events.eventsExec("IOSTART", 0, 0, null);
            }
            events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
            if (this.guiSupport) {
                this.updateZonesList();
            }
            this.genEvents = true;
            String cmd = null;
            while (!me.quit) {
                cmd = this.ioqtx.poll(this.pollinterval, TimeUnit.MILLISECONDS);
                if (cmd != null) {
                    do {
                        if (!this.processCommand(cmd)) continue;
                        me.heartbeat = System.currentTimeMillis();
                    } while ((cmd = this.ioqtx.poll()) != null);
                }
                this.polling(me, true);
                this.uiUpdate();
            }
        }
        catch (InterruptedException ie) {
            Logger.log(Logger.Mode.EVENT, "ioMonitor - killing process - " + ie.getMessage() + " [" + this.serverName + "]");
        }
        catch (Exception e7) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception - " + e7 + " [" + this.serverName + "]");
            Logger.log(Logger.Mode.ERROR, "ioMonitor - quit [" + this.serverName + "]");
        }
        SystemState.ioServersInitializedSet(ioIndex, false);
        if (SystemState.ioGet(String.valueOf(this.serverName) + ".connection") == null || !SystemState.ioGet(String.valueOf(this.serverName) + ".connection").equals("offline")) {
            this.ioWrite(true, "connection", "offline");
            this.securityLog("Offline");
        }
    }

    private void loadLogs() {
        try {
            StringBuilder sb = new StringBuilder();
            this.logs = new Vector(this.logSize);
            String persistentlog = SystemState.varGet("__hsyco__csx75." + this.serverName + ".log!");
            if (persistentlog != null) {
                int i2 = 0;
                while (i2 < persistentlog.length()) {
                    char c2 = persistentlog.charAt(i2);
                    if (c2 != ';') {
                        sb.append(c2);
                    } else if (i2 + 1 < persistentlog.length() && persistentlog.charAt(i2 + 1) == ';') {
                        sb.append(c2);
                        ++i2;
                    } else {
                        this.logs.add(sb.toString());
                        if (this.logs.size() >= this.logSize) break;
                        sb = new StringBuilder();
                    }
                    ++i2;
                }
                if (this.logs.size() < this.logSize && sb.length() > 0) {
                    this.logs.add(sb.toString());
                }
            }
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "Error loading saved logs [" + this.serverName + "]");
        }
    }

    private void saveLogs() {
        StringBuilder persistentlog = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            String line = this.logs.get(i2).replace(";", ";;");
            if (line.length() > 0) {
                if (persistentlog.length() > 0) {
                    persistentlog.append(';');
                }
                persistentlog.append(line);
            }
            ++i2;
        }
        SystemState.varSet("__hsyco__csx75." + this.serverName + ".log!", persistentlog.toString());
    }

    private void updateZonesList() {
        StringBuilder values = new StringBuilder();
        StringBuilder labels = new StringBuilder();
        ArrayList<Zone> set = new ArrayList<Zone>(this.zones.values());
        Collections.sort(set, new Comparator<Zone>(){

            @Override
            public int compare(Zone z1, Zone z2) {
                return z1.name.toLowerCase().compareTo(z2.name.toLowerCase());
            }
        });
        for (Zone z : set) {
            values.append(",").append(z.index);
            labels.append(",").append(z.getListLabel());
        }
        if (values.length() > 1) {
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "values", values.substring(1));
            userBase.uiSet(String.valueOf(this.serverName) + ".zones.list", "labels", labels.substring(1));
        }
    }

    private void init(ioMonitor me) throws Exception {
        try {
            if (!this.processResponse(this.send(this.interface_config_req))) {
                throw new Exception("interface configuartion request fail");
            }
            me.heartbeat = System.currentTimeMillis();
            if (!this.processResponse(this.send(this.system_status_req))) {
                throw new Exception("system status request fail");
            }
            me.heartbeat = System.currentTimeMillis();
            Logger.log(Logger.Mode.EVENT, "ioMonitor - Connection established - Panel ID: " + this.panelID + ", Firmware version: " + this.firmware + " [" + this.serverName + "]");
            int i2 = 0;
            while (i2 < this.maxZone) {
                this.zone_status_req[3] = (byte)i2;
                if (!this.processResponse(this.send(this.zone_status_req))) {
                    throw new Exception("zone status request fail - check maxzone option");
                }
                me.heartbeat = System.currentTimeMillis();
                ++i2;
            }
            boolean gotZoneNames = this.loadIniFile();
            if (!gotZoneNames) {
                for (int i3 : this.zones.keySet()) {
                    this.zone_name_req[3] = (byte)(i3 - 1);
                    if (!this.processResponse(this.send(this.zone_name_req))) {
                        throw new Exception("zone name request fail");
                    }
                    me.heartbeat = System.currentTimeMillis();
                }
            }
        }
        catch (Exception e2) {
            throw new Exception("Initialization error: " + e2.getLocalizedMessage());
        }
    }

    protected String getIniFile() {
        return "csx75.ini";
    }

    private boolean loadIniFile() {
        String iniFile = this.getIniFile();
        Logger.log(Logger.Mode.EVENT, "ioMonitor - loading '" + iniFile + "' [" + this.serverName + "]");
        BufferedReader br = null;
        try {
            String line;
            File f2 = new File(iniFile);
            try {
                br = new BufferedReader(new FileReader(f2));
            }
            catch (FileNotFoundException e2) {
                Logger.log(Logger.Mode.EVENT, "ioMonitor - file '" + iniFile + "' not found [" + this.serverName + "]");
                try {
                    br.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            int l2 = 1;
            boolean gotZoneNames = false;
            while ((line = br.readLine()) != null) {
                try {
                    String name;
                    int idx;
                    String[] id_name;
                    line = line.trim();
                    if (line.startsWith(String.valueOf(this.serverName) + ".user.")) {
                        id_name = line.split("=");
                        idx = Integer.parseInt(id_name[0].trim().replace(String.valueOf(this.serverName) + ".user.", ""));
                        name = id_name[1].trim();
                        this.users.put(idx, new User(idx, name));
                    } else if (line.startsWith(String.valueOf(this.serverName) + ".z.")) {
                        id_name = line.split("=");
                        idx = Integer.parseInt(id_name[0].trim().replace(String.valueOf(this.serverName) + ".z.", ""));
                        name = id_name[1].trim();
                        Zone z = this.zones.get(idx);
                        if (z != null) {
                            z.setName(name);
                        }
                        gotZoneNames = true;
                    }
                }
                catch (Exception e3) {
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - error in '" + iniFile + "', line " + l2 + ": " + e3.getMessage() + " [" + this.serverName + "]");
                }
                ++l2;
            }
            boolean bl = gotZoneNames;
            return bl;
        }
        catch (Exception e4) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - error loading '" + iniFile + "' [" + this.serverName + "]");
            return false;
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    public String keypad(String session, String userId, String id) {
        if (this.guiSupport) {
            String param;
            String name;
            block21: {
                String zoneId;
                block20: {
                    block19: {
                        Logger.log(Logger.Mode.VERBOSE, "keypad - processing command: " + id + " [" + this.serverName + "]");
                        try {
                            int val_idx = id.lastIndexOf(46);
                            name = id.substring(0, val_idx);
                            param = id.substring(val_idx + 1);
                            if (!name.equals("digit")) break block19;
                            this.pinInputTime = System.currentTimeMillis();
                            if (param.equals("x")) {
                                if (this.keypadPin != null && this.keypadPinIndex >= 0) {
                                    this.keypadPinIndex = (byte)(this.keypadPinIndex - 1);
                                }
                            } else {
                                byte d2 = Byte.parseByte(param);
                                if (this.keypadPin == null) {
                                    this.keypadPin = new byte[this.pinDigits];
                                    this.keypadPinIndex = 0;
                                    this.keypadPin[0] = d2;
                                } else if (this.keypadPinIndex < this.pinDigits - 1) {
                                    this.keypadPinIndex = (byte)(this.keypadPinIndex + 1);
                                    this.keypadPin[this.keypadPinIndex] = d2;
                                }
                            }
                            this.uiSet("digit", param);
                            return "";
                        }
                        catch (Exception e2) {
                            Logger.log(Logger.Mode.ERROR, "keypad - error processing command: " + id + " [" + this.serverName + "] - " + e2.getLocalizedMessage());
                            return null;
                        }
                    }
                    if (!name.equals("zones.list")) break block20;
                    Zone z = this.zones.get(Integer.parseInt(param));
                    if (z != null) {
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.cont", "visible", "true");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value", Integer.toString(z.index));
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.name", "value", z.name);
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.open.label", "visible", z.open == 1 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.alarm.label", "visible", z.alarmMem == 1 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.bypassed.label", "visible", z.bypassed == 1 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.tamper.label", "visible", z.tamper == 1 ? "true" : "false");
                        userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.warning.label", "visible", z.trouble == 1 || z.batteryLow == 1 || z.supervisionLoss == 1 ? "true" : "false");
                        Vector<String> s = this.zoneSessions.get(z.index);
                        if (s == null) {
                            s = new Vector();
                        }
                        s.add(session);
                        this.zoneSessions.put(z.index, s);
                    }
                    return "";
                }
                if (!name.equals("zone.sel")) break block21;
                if (param.equals("close")) {
                    int idx;
                    Vector<String> s;
                    String currId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value", "");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.cont", "visible", "false");
                    userBase.uiSet(session, String.valueOf(this.serverName) + ".zone.sel.name", "value", "--");
                    if (currId != null && (s = this.zoneSessions.get(idx = Integer.parseInt(currId))) != null) {
                        s.remove(session);
                        if (s.isEmpty()) {
                            this.zoneSessions.remove(idx);
                        }
                    }
                } else if (param.equals("bypass") && (zoneId = userBase.uiGet(session, String.valueOf(this.serverName) + ".zone.sel.id", "value")) != null && !zoneId.equals("")) {
                    SystemState.ioSet(String.valueOf(this.serverName) + ".z" + zoneId + ".bypassed", "toggle");
                }
                return "";
            }
            SystemState.ioSet(String.valueOf(this.serverName) + ".kpd." + name, param);
        }
        return "";
    }

    private void polling(ioMonitor me, boolean checkCommands) throws InterruptedException {
        String cmd;
        if (this.processResponse(this.send(this.system_status_req))) {
            me.heartbeat = System.currentTimeMillis();
        }
        while (checkCommands && !me.quit && (cmd = this.ioqtx.poll()) != null) {
            if (!this.processCommand(cmd)) continue;
            me.heartbeat = System.currentTimeMillis();
        }
        if (me.quit) {
            return;
        }
        for (int i2 : this.zones.keySet()) {
            this.zone_status_req[3] = (byte)(i2 - 1);
            if (this.processResponse(this.send(this.zone_status_req))) {
                me.heartbeat = System.currentTimeMillis();
            }
            while (checkCommands && !me.quit && (cmd = this.ioqtx.poll()) != null) {
                if (!this.processCommand(cmd)) continue;
                me.heartbeat = System.currentTimeMillis();
            }
            if (!me.quit) continue;
            return;
        }
        for (int i2 : this.partitions.keySet()) {
            this.partition_status_req[3] = (byte)(i2 - 1);
            if (this.processResponse(this.send(this.partition_status_req))) {
                me.heartbeat = System.currentTimeMillis();
            }
            while (checkCommands && !me.quit && (cmd = this.ioqtx.poll()) != null) {
                if (!this.processCommand(cmd)) continue;
                me.heartbeat = System.currentTimeMillis();
            }
            if (!me.quit) continue;
            return;
        }
    }

    private boolean processCommand(String cmd) throws InterruptedException {
        Logger.log(Logger.Mode.EVENT, "commandExecutor - processing command: " + cmd + " [" + this.serverName + "]");
        cmd = cmd.toLowerCase();
        boolean keypad = false;
        try {
            String[] id_val = cmd.split("=");
            String id = id_val[0];
            String val = id_val[1];
            if (id.startsWith("kpd.")) {
                keypad = true;
                id = id.substring(4);
            }
            if (id.equals("command") || id.equals("clock")) {
                boolean bl = this.commandExecutor(cmd, Cmd.SYSTEM, 0, id, val, keypad);
                return bl;
            }
            int dot = id.indexOf(46);
            if (dot == -1) {
                boolean bl = this.commandExecutor(cmd, Cmd.GLOBAL, 0, id, val, keypad);
                return bl;
            }
            String prefix = id.substring(0, dot);
            String func = id.substring(dot + 1);
            if (prefix.startsWith("p")) {
                int p = Integer.parseInt(prefix.replace("p", ""));
                boolean bl = this.commandExecutor(cmd, Cmd.PARTITION, p, func, val, keypad);
                return bl;
            }
            if (prefix.startsWith("z")) {
                int z = Integer.parseInt(prefix.replace("z", ""));
                boolean bl = this.commandExecutor(cmd, Cmd.ZONE, z, func, val, keypad);
                return bl;
            }
            if (prefix.startsWith("cs507")) {
                int dot1 = func.indexOf(46);
                String addrStr = func.substring(0, dot1);
                int addr = Integer.parseInt(addrStr);
                func = func.substring(dot1 + 1);
                boolean bl = this.commandExecutor(cmd, Cmd.CS507, addr, func, val, keypad);
                return bl;
            }
            if (prefix.startsWith("x10")) {
                boolean bl = this.commandExecutor(cmd, Cmd.X10, 0, func, val, keypad);
                return bl;
            }
            boolean bl = this.commandExecutor(cmd, Cmd.GLOBAL, 0, id, val, keypad);
            return bl;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - Error executing command '" + cmd + "': " + e2.getMessage() + " [" + this.serverName + "]");
            return true;
        }
        finally {
            if (keypad) {
                this.keypadPin = null;
                this.keypadPinIndex = 0;
                this.uiSet("digit", "clear");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean commandExecutor(String cmd, Cmd type, int index, String function, String val, boolean keypad) throws Exception {
        block64: {
            block65: {
                block69: {
                    block73: {
                        block74: {
                            block75: {
                                block66: {
                                    block67: {
                                        block72: {
                                            block71: {
                                                block70: {
                                                    block68: {
                                                        block63: {
                                                            command = null;
                                                            if (type != Cmd.SYSTEM) break block63;
                                                            if (function.equals("command") && val.equals("restart")) {
                                                                throw new InterruptedException("restart command");
                                                            }
                                                            if (function.equals("clock")) {
                                                                if (val.equals("read")) {
                                                                    return this.processResponse(this.send(this.clock_req_2));
                                                                }
                                                                if (val.contains("/")) {
                                                                    dwt = val.split("-");
                                                                    date = dwt[0];
                                                                    weekDay = Byte.parseByte(dwt[1]);
                                                                    time = dwt[2];
                                                                    ymd = date.split("/");
                                                                    year = Byte.parseByte(ymd[0]);
                                                                    month = Byte.parseByte(ymd[1]);
                                                                    day = Byte.parseByte(ymd[2]);
                                                                    hm = time.split(":");
                                                                    hour = Byte.parseByte(hm[0]);
                                                                    min = Byte.parseByte(hm[1]);
                                                                } else {
                                                                    dt = val.split(" ");
                                                                    date = dt[0];
                                                                    time = dt[1];
                                                                    ymd = date.split("-");
                                                                    tempYear = Integer.parseInt(ymd[0]);
                                                                    tempMonth = Integer.parseInt(ymd[1]);
                                                                    tempDay = Integer.parseInt(ymd[2]);
                                                                    cal = new GregorianCalendar();
                                                                    cal.set(1, tempYear);
                                                                    cal.set(2, tempMonth - 1);
                                                                    cal.set(5, tempDay);
                                                                    year = (byte)(tempYear % 100);
                                                                    month = (byte)tempMonth;
                                                                    day = (byte)tempDay;
                                                                    weekDay = (byte)cal.get(7);
                                                                    hm = time.split(":");
                                                                    hour = Byte.parseByte(hm[0]);
                                                                    min = Byte.parseByte(hm[1]);
                                                                }
                                                                this.set_clock_req[3] = year;
                                                                this.set_clock_req[4] = month;
                                                                this.set_clock_req[5] = day;
                                                                this.set_clock_req[6] = hour;
                                                                this.set_clock_req[7] = min;
                                                                this.set_clock_req[8] = weekDay;
                                                                return this.processResponse(this.send(this.set_clock_req));
                                                            }
                                                            break block64;
                                                        }
                                                        if (type != Cmd.GLOBAL && type != Cmd.PARTITION) break block65;
                                                        if (!function.equals("armed")) break block66;
                                                        partByte = 7;
                                                        v0 = pinTemp = keypad != false ? this.keypadPin : this.pin;
                                                        if (pinTemp == null || keypad && this.keypadPinIndex != this.pinDigits - 1) break block67;
                                                        command = this.primary_keypad_func;
                                                        command[3] = (byte)(pinTemp[0] | pinTemp[1] << 4);
                                                        command[4] = (byte)(pinTemp[2] | pinTemp[3] << 4);
                                                        command[5] = pinTemp.length > 4 ? (byte)(pinTemp[4] | pinTemp[5] << 4) : 0;
                                                        if (!val.equals("0")) break block68;
                                                        command[6] = 1;
                                                        break block69;
                                                    }
                                                    if (!val.equals("away")) break block70;
                                                    if (type == Cmd.PARTITION && Partition.access$0(this.partitions.get(index)) == 1) {
                                                        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - system armed - command not allowed: " + cmd + " [" + this.serverName + "]");
                                                        return true;
                                                    }
                                                    if (type == Cmd.GLOBAL) {
                                                        for (Partition p : this.partitions.values()) {
                                                            if (Partition.access$0(p) != 1) continue;
                                                            Logger.log(Logger.Mode.VERBOSE, "commandExecutor - system armed - command not allowed: " + cmd + " [" + this.serverName + "]");
                                                            return true;
                                                        }
                                                    }
                                                    command[6] = 2;
                                                    break block69;
                                                }
                                                if (!val.equals("stay")) break block71;
                                                if (type == Cmd.PARTITION && Partition.access$0(this.partitions.get(index)) == 1) {
                                                    Logger.log(Logger.Mode.VERBOSE, "commandExecutor - system armed - command not allowed: " + cmd + " [" + this.serverName + "]");
                                                    return true;
                                                }
                                                if (type == Cmd.GLOBAL) {
                                                    for (Partition p : this.partitions.values()) {
                                                        if (Partition.access$0(p) != 1) continue;
                                                        Logger.log(Logger.Mode.VERBOSE, "commandExecutor - system armed - command not allowed: " + cmd + " [" + this.serverName + "]");
                                                        return true;
                                                    }
                                                }
                                                command[6] = 3;
                                                break block69;
                                            }
                                            if (!val.equals("auto")) break block72;
                                            if (type == Cmd.PARTITION && Partition.access$0(this.partitions.get(index)) == 1) {
                                                Logger.log(Logger.Mode.VERBOSE, "commandExecutor - system armed - command not allowed: " + cmd + " [" + this.serverName + "]");
                                                return true;
                                            }
                                            if (type == Cmd.GLOBAL) {
                                                for (Partition p : this.partitions.values()) {
                                                    if (Partition.access$0(p) != 1) continue;
                                                    Logger.log(Logger.Mode.VERBOSE, "commandExecutor - system armed - command not allowed: " + cmd + " [" + this.serverName + "]");
                                                    return true;
                                                }
                                            }
                                            command[6] = 5;
                                            break block69;
                                        }
                                        throw new Exception("invalid value");
                                    }
                                    Logger.log(Logger.Mode.EVENT, "commandExecutor - PIN not set - command not allowed: " + cmd + " [" + this.serverName + "]");
                                    return true;
                                }
                                if (!function.equals("cancel")) break block73;
                                partByte = 7;
                                v1 = pinTemp = keypad != false ? this.keypadPin : this.pin;
                                if (pinTemp == null || keypad && this.keypadPinIndex != this.pinDigits - 1) break block74;
                                command = this.primary_keypad_func;
                                command[3] = (byte)(pinTemp[0] | pinTemp[1] << 4);
                                command[4] = (byte)(pinTemp[2] | pinTemp[3] << 4);
                                command[5] = pinTemp.length > 4 ? (byte)(pinTemp[4] | pinTemp[5] << 4) : 0;
                                if (!val.equals("1")) break block75;
                                command[6] = 4;
                                break block69;
                            }
                            throw new Exception("invalid value");
                        }
                        Logger.log(Logger.Mode.EVENT, "commandExecutor - PIN not set - command not allowed: " + cmd + " [" + this.serverName + "]");
                        return true;
                    }
                    if (!function.equals("walk.test")) ** GOTO lbl136
                    partByte = 7;
                    v2 = pinTemp = keypad != false ? this.keypadPin : this.pin;
                    if (pinTemp == null || keypad && this.keypadPinIndex != this.pinDigits - 1) ** GOTO lbl134
                    command = this.primary_keypad_func;
                    command[3] = (byte)(pinTemp[0] | pinTemp[1] << 4);
                    command[4] = (byte)(pinTemp[2] | pinTemp[3] << 4);
                    command[5] = pinTemp.length > 4 ? (byte)(pinTemp[4] | pinTemp[5] << 4) : 0;
                    if (val.equals("1")) {
                        command[6] = 6;
                    } else if (val.equals("0")) {
                        command[6] = 7;
                    } else {
                        throw new Exception("invalid value");
lbl134:
                        // 1 sources

                        Logger.log(Logger.Mode.EVENT, "commandExecutor - PIN not set - command not allowed: " + cmd + " [" + this.serverName + "]");
                        return true;
lbl136:
                        // 1 sources

                        if (function.equals("chime.mode") && val.equals("toggle")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 1;
                        } else if (function.equals("panic") && val.equals("fire")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 4;
                        } else if (function.equals("panic") && val.equals("medical")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 5;
                        } else if (function.equals("panic") && val.equals("police")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 6;
                        } else if (function.equals("smoke") && val.equals("reset")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 7;
                        } else if (function.equals("exit.silent") && val.equals("1")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 10;
                        } else if (function.equals("test") && val.equals("1")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 11;
                        } else if (function.equals("aux1") && val.equals("1")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 13;
                        } else if (function.equals("aux2") && val.equals("1")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 14;
                        } else if (function.equals("buzzer") && val.equals("1")) {
                            partByte = 4;
                            command = this.secondary_keypad_func;
                            command[3] = 15;
                        } else {
                            throw new Exception("invalid function");
                        }
                    }
                }
                if (type == Cmd.GLOBAL) {
                    command[partByte] = -1;
                } else {
                    if (this.partitions.get(index) == null) {
                        throw new Exception("invalid index");
                    }
                    command[partByte] = (byte)(1 << index - 1);
                }
                break block64;
            }
            if (type != Cmd.ZONE) ** GOTO lbl204
            if (function.equals("bypassed") && val.equals("toggle")) {
                if (this.zones.get(index) == null) {
                    throw new Exception("invalid index");
                }
                command = this.zone_bypass_toggle;
                command[3] = (byte)(index - 1);
            } else {
                throw new Exception("invalid function");
lbl204:
                // 1 sources

                if (type == Cmd.CS507) {
                    if (function.startsWith("out")) {
                        output_num = Integer.parseInt(function.replace("out", ""));
                        if (val.equals("read")) {
                            return this.getCS507Output(index, output_num);
                        }
                        prms = val.split(",");
                        event = Integer.parseInt(prms[0]);
                        zone_user = Integer.parseInt(prms[1]);
                        duration = Integer.parseInt(prms[2]);
                        f1 = prms[3].equals("1");
                        f2 = prms[4].equals("1");
                        f3 = prms[5].equals("1");
                        f4 = prms[6].equals("1");
                        f5 = prms[7].equals("1");
                        f6 = prms[8].equals("1");
                        f7 = prms[9].equals("1");
                        f8 = prms[10].equals("1");
                        a1 = prms[11].equals("1");
                        a2 = prms[12].equals("1");
                        a3 = prms[13].equals("1");
                        a4 = prms[14].equals("1");
                        a5 = prms[15].equals("1");
                        a6 = prms[16].equals("1");
                        a7 = prms[17].equals("1");
                        a8 = prms[18].equals("1");
                        p1 = prms[19].equals("1");
                        p2 = prms[20].equals("1");
                        p3 = prms[21].equals("1");
                        p4 = prms[22].equals("1");
                        p5 = prms[23].equals("1");
                        p6 = prms[24].equals("1");
                        p7 = prms[25].equals("1");
                        p8 = prms[26].equals("1");
                        X10homeAddr = prms[27].charAt(0);
                        X10unitAddr = Integer.parseInt(prms[27].substring(1));
                        return this.setCS507Output(index, output_num, event, zone_user, duration, f1, f2, f3, f4, f5, f6, f7, f8, a1, a2, a3, a4, a5, a6, a7, a8, p1, p2, p3, p4, p5, p6, p7, p8, X10homeAddr, X10unitAddr);
                    }
                    if (function.startsWith("prog")) {
                        prog_num = Integer.parseInt(function.replace("prog", ""));
                        if (val.equals("read")) {
                            return this.getCS507Program(index, prog_num);
                        }
                        prms = val.split(",");
                        start = prms[0].split(":");
                        start_h = Integer.parseInt(start[0]);
                        start_m = Integer.parseInt(start[1]);
                        end = prms[1].split(":");
                        end_h = Integer.parseInt(end[0]);
                        end_m = Integer.parseInt(end[1]);
                        sun = prms[2].equals("1");
                        mon = prms[3].equals("1");
                        tue = prms[4].equals("1");
                        wed = prms[5].equals("1");
                        thu = prms[6].equals("1");
                        fri = prms[7].equals("1");
                        sat = prms[8].equals("1");
                        holidays = prms[9].equals("1");
                        return this.setCS507Program(index, prog_num, start_h, start_m, end_h, end_m, sun, mon, tue, wed, thu, fri, sat, holidays);
                    }
                    if (function.startsWith("holidays")) {
                        month = Integer.parseInt(function.replace("holidays.", ""));
                        if (val.equals("read")) {
                            return this.getCS507Holidays(index, month);
                        }
                        prms = val.split(",");
                        d1 = Integer.parseInt(prms[0]);
                        d2 = Integer.parseInt(prms[1]);
                        d3 = Integer.parseInt(prms[2]);
                        d4 = Integer.parseInt(prms[3]);
                        d5 = Integer.parseInt(prms[4]);
                        d6 = Integer.parseInt(prms[5]);
                        d7 = Integer.parseInt(prms[6]);
                        d8 = Integer.parseInt(prms[7]);
                        return this.setCS507Holidays(index, month, d1, d2, d3, d4, d5, d6, d7, d8);
                    }
                    if (function.startsWith("user")) {
                        user = Integer.parseInt(function.replace("user", ""));
                        if (val.equals("read")) {
                            return this.getCS507UserEnable(index, user);
                        }
                        prms = val.split(",");
                        e1 = prms[0].equals("1");
                        e2 = prms[1].equals("1");
                        e3 = prms[2].equals("1");
                        e4 = prms[3].equals("1");
                        e5 = prms[4].equals("1");
                        e6 = prms[5].equals("1");
                        e7 = prms[6].equals("1");
                        e8 = prms[7].equals("1");
                        return this.setCS507UserEnable(index, user, e1, e2, e3, e4, e5, e6, e7, e8);
                    }
                    throw new Exception("invalid function");
                }
                if (type == Cmd.X10) {
                    try {
                        house = (byte)(function.charAt(0) - 97);
                        u = function.substring(2);
                        try {
                            unit = (byte)(Integer.parseInt(u) - 1);
                            code = val.equals("on") ? 40 : (val.equals("off") ? 56 : (val.equals("dim") ? 72 : (val.equals("bright") ? 88 : (int)Byte.parseByte(val, 16))));
                        }
                        catch (NumberFormatException e) {
                            unit = 0;
                            if (u.equals("all")) {
                                if (val.equals("off")) {
                                    code = 8;
                                }
                                throw new Exception("invalid X10 command: " + function);
                            }
                            if (u.equals("lights")) {
                                if (val.equals("on")) {
                                    code = 24;
                                }
                                if (val.equals("off")) {
                                    code = 104;
                                }
                                throw new Exception("invalid X10 command: " + function);
                            }
                            throw new Exception("invalid X10 command: " + function);
                        }
                        command = this.send_x10_msg;
                        command[3] = house;
                        command[4] = unit;
                        command[5] = code;
                    }
                    catch (Exception e) {
                        throw new Exception("invalid X10 command: " + function, e);
                    }
                }
            }
        }
        return this.processResponse(this.send(command));
    }

    public synchronized boolean getCS507Output(int moduleAddr, int output_num) {
        this.getCS507_request[3] = (byte)moduleAddr;
        this.getCS507_request[5] = (byte)((output_num - 1) * 7);
        byte[] resp = this.send(this.getCS507_request);
        if (resp == null) {
            return false;
        }
        if ((resp[2] & 0x3F) != 16 || resp[3] != this.getCS507_request[3] || resp[5] != this.getCS507_request[5]) {
            Logger.log(Logger.Mode.ERROR, "getCS507Output - response error [" + this.serverName + "]");
            return false;
        }
        byte event = resp[7];
        byte zone_user = resp[8];
        byte duration = resp[9];
        boolean f1 = (resp[10] & 1) == 1;
        boolean f2 = (resp[10] & 2) == 2;
        boolean f3 = (resp[10] & 4) == 4;
        boolean f4 = (resp[10] & 8) == 8;
        boolean f5 = (resp[10] & 0x10) == 16;
        boolean f6 = (resp[10] & 0x20) == 32;
        boolean f7 = (resp[10] & 0x40) == 64;
        boolean f8 = (resp[10] & 0x80) == 128;
        boolean a1 = (resp[11] & 1) == 1;
        boolean a2 = (resp[11] & 2) == 2;
        boolean a3 = (resp[11] & 4) == 4;
        boolean a4 = (resp[11] & 8) == 8;
        boolean a5 = (resp[11] & 0x10) == 16;
        boolean a6 = (resp[11] & 0x20) == 32;
        boolean a7 = (resp[11] & 0x40) == 64;
        boolean a8 = (resp[11] & 0x80) == 128;
        boolean p1 = (resp[12] & 1) == 1;
        boolean p2 = (resp[12] & 2) == 2;
        boolean p3 = (resp[12] & 4) == 4;
        boolean p4 = (resp[12] & 8) == 8;
        boolean p5 = (resp[12] & 0x10) == 16;
        boolean p6 = (resp[12] & 0x20) == 32;
        boolean p7 = (resp[12] & 0x40) == 64;
        boolean p8 = (resp[12] & 0x80) == 128;
        char X10homeAddr = (char)((resp[13] >>> 4 & 0xF) + 65);
        int X10unitAddr = (resp[13] & 0xF) + 1;
        StringBuffer event_value = new StringBuffer();
        event_value.append(event).append(",");
        event_value.append(zone_user).append(",");
        event_value.append(duration).append(",");
        event_value.append(f1 ? "1" : "0").append(",");
        event_value.append(f2 ? "1" : "0").append(",");
        event_value.append(f3 ? "1" : "0").append(",");
        event_value.append(f4 ? "1" : "0").append(",");
        event_value.append(f5 ? "1" : "0").append(",");
        event_value.append(f6 ? "1" : "0").append(",");
        event_value.append(f7 ? "1" : "0").append(",");
        event_value.append(f8 ? "1" : "0").append(",");
        event_value.append(a1 ? "1" : "0").append(",");
        event_value.append(a2 ? "1" : "0").append(",");
        event_value.append(a3 ? "1" : "0").append(",");
        event_value.append(a4 ? "1" : "0").append(",");
        event_value.append(a5 ? "1" : "0").append(",");
        event_value.append(a6 ? "1" : "0").append(",");
        event_value.append(a7 ? "1" : "0").append(",");
        event_value.append(a8 ? "1" : "0").append(",");
        event_value.append(p1 ? "1" : "0").append(",");
        event_value.append(p2 ? "1" : "0").append(",");
        event_value.append(p3 ? "1" : "0").append(",");
        event_value.append(p4 ? "1" : "0").append(",");
        event_value.append(p5 ? "1" : "0").append(",");
        event_value.append(p6 ? "1" : "0").append(",");
        event_value.append(p7 ? "1" : "0").append(",");
        event_value.append(p8 ? "1" : "0").append(",");
        event_value.append(X10homeAddr).append(X10unitAddr);
        this.ioWriteForced(this.genEvents, "cs507." + moduleAddr + ".out" + output_num, event_value.toString());
        return true;
    }

    public synchronized boolean setCS507Output(int moduleAddr, int output_num, int event, int zone_user, int duration, boolean f1, boolean f2, boolean f3, boolean f4, boolean f5, boolean f6, boolean f7, boolean f8, boolean a1, boolean a2, boolean a3, boolean a4, boolean a5, boolean a6, boolean a7, boolean a8, boolean p1, boolean p2, boolean p3, boolean p4, boolean p5, boolean p6, boolean p7, boolean p8, char X10homeAddr, int X10unitAddr) {
        this.setCS507_output[3] = (byte)moduleAddr;
        this.setCS507_output[5] = (byte)((output_num - 1) * 7);
        this.setCS507_output[7] = (byte)event;
        this.setCS507_output[8] = (byte)zone_user;
        this.setCS507_output[9] = (byte)duration;
        int b2 = 0;
        if (f1) {
            b2 = (byte)(b2 + 1);
        }
        if (f2) {
            b2 = (byte)(b2 + 2);
        }
        if (f3) {
            b2 = (byte)(b2 + 4);
        }
        if (f4) {
            b2 = (byte)(b2 + 8);
        }
        if (f5) {
            b2 = (byte)(b2 + 16);
        }
        if (f6) {
            b2 = (byte)(b2 + 32);
        }
        if (f7) {
            b2 = (byte)(b2 + 64);
        }
        if (f8) {
            b2 = (byte)(b2 + 128);
        }
        this.setCS507_output[10] = b2;
        b2 = 0;
        if (a1) {
            b2 = (byte)(b2 + 1);
        }
        if (a2) {
            b2 = (byte)(b2 + 2);
        }
        if (a3) {
            b2 = (byte)(b2 + 4);
        }
        if (a4) {
            b2 = (byte)(b2 + 8);
        }
        if (a5) {
            b2 = (byte)(b2 + 16);
        }
        if (a6) {
            b2 = (byte)(b2 + 32);
        }
        if (a7) {
            b2 = (byte)(b2 + 64);
        }
        if (a8) {
            b2 = (byte)(b2 + 128);
        }
        this.setCS507_output[11] = b2;
        b2 = 0;
        if (p1) {
            b2 = (byte)(b2 + 1);
        }
        if (p2) {
            b2 = (byte)(b2 + 2);
        }
        if (p3) {
            b2 = (byte)(b2 + 4);
        }
        if (p4) {
            b2 = (byte)(b2 + 8);
        }
        if (p5) {
            b2 = (byte)(b2 + 16);
        }
        if (p6) {
            b2 = (byte)(b2 + 32);
        }
        if (p7) {
            b2 = (byte)(b2 + 64);
        }
        if (p8) {
            b2 = (byte)(b2 + 128);
        }
        this.setCS507_output[12] = b2;
        int home = Character.toUpperCase(X10homeAddr) - 65;
        this.setCS507_output[13] = (byte)(((home & 0xF) << 4) + (X10unitAddr - 1 & 0xF));
        return this.processResponse(this.send(this.setCS507_output));
    }

    public synchronized boolean getCS507Program(int moduleAddr, int prog_num) {
        this.getCS507_request[3] = (byte)moduleAddr;
        this.getCS507_request[5] = (byte)(56 + 5 * (prog_num - 1));
        byte[] resp = this.send(this.getCS507_request);
        if (resp == null) {
            return false;
        }
        if ((resp[2] & 0x3F) != 16 || resp[3] != this.getCS507_request[3] || resp[5] != this.getCS507_request[5]) {
            Logger.log(Logger.Mode.ERROR, "getCS507Program - response error [" + this.serverName + "]");
            return false;
        }
        byte start_h = resp[7];
        byte start_m = resp[8];
        byte end_h = resp[9];
        byte end_m = resp[10];
        boolean sun = (resp[11] & 1) == 1;
        boolean mon = (resp[11] & 2) == 2;
        boolean tue = (resp[11] & 4) == 4;
        boolean wed = (resp[11] & 8) == 8;
        boolean thu = (resp[11] & 0x10) == 16;
        boolean fri = (resp[11] & 0x20) == 32;
        boolean sat = (resp[11] & 0x40) == 64;
        boolean holidays = (resp[11] & 0x80) == 128;
        StringBuffer event_value = new StringBuffer();
        String start_h_str = start_h < 10 ? "0" + start_h : "" + start_h;
        String start_m_str = start_m < 10 ? "0" + start_m : "" + start_m;
        String end_h_str = end_h < 10 ? "0" + end_h : "" + end_h;
        String end_m_str = end_m < 10 ? "0" + end_m : "" + end_m;
        event_value.append(start_h_str).append(":").append(start_m_str).append(",");
        event_value.append(end_h_str).append(":").append(end_m_str).append(",");
        event_value.append(sun ? "1" : "0").append(",");
        event_value.append(mon ? "1" : "0").append(",");
        event_value.append(tue ? "1" : "0").append(",");
        event_value.append(wed ? "1" : "0").append(",");
        event_value.append(thu ? "1" : "0").append(",");
        event_value.append(fri ? "1" : "0").append(",");
        event_value.append(sat ? "1" : "0").append(",");
        event_value.append(holidays ? "1" : "0");
        this.ioWriteForced(this.genEvents, "cs507." + moduleAddr + ".prog" + prog_num, event_value.toString());
        return true;
    }

    public synchronized boolean setCS507Program(int moduleAddr, int prog_num, int start_h, int start_m, int end_h, int end_m, boolean sun, boolean mon, boolean tue, boolean wed, boolean thu, boolean fri, boolean sat, boolean holidays) {
        this.setCS507_program[3] = (byte)moduleAddr;
        this.setCS507_program[5] = (byte)(56 + 5 * (prog_num - 1));
        this.setCS507_program[7] = (byte)start_h;
        this.setCS507_program[8] = (byte)start_m;
        this.setCS507_program[9] = (byte)end_h;
        this.setCS507_program[10] = (byte)end_m;
        int b2 = 0;
        if (sun) {
            b2 = (byte)(b2 + 1);
        }
        if (mon) {
            b2 = (byte)(b2 + 2);
        }
        if (tue) {
            b2 = (byte)(b2 + 4);
        }
        if (wed) {
            b2 = (byte)(b2 + 8);
        }
        if (thu) {
            b2 = (byte)(b2 + 16);
        }
        if (fri) {
            b2 = (byte)(b2 + 32);
        }
        if (sat) {
            b2 = (byte)(b2 + 64);
        }
        if (holidays) {
            b2 = (byte)(b2 + 128);
        }
        this.setCS507_program[11] = b2;
        return this.processResponse(this.send(this.setCS507_program));
    }

    public synchronized boolean getCS507Holidays(int moduleAddr, int month) {
        this.getCS507_request[3] = (byte)moduleAddr;
        this.getCS507_request[5] = (byte)(96 + (month - 1 << 3));
        byte[] resp = this.send(this.getCS507_request);
        if (resp == null) {
            return false;
        }
        if ((resp[2] & 0x3F) != 16 || resp[3] != this.getCS507_request[3] || resp[5] != this.getCS507_request[5]) {
            Logger.log(Logger.Mode.ERROR, "getCS507Holidays - response error [" + this.serverName + "]");
            return false;
        }
        byte d1 = resp[7];
        byte d2 = resp[8];
        byte d3 = resp[9];
        byte d4 = resp[10];
        byte d5 = resp[11];
        byte d6 = resp[12];
        byte d7 = resp[13];
        byte d8 = resp[14];
        this.ioWriteForced(this.genEvents, "cs507." + moduleAddr + ".holidays." + month, String.valueOf(d1) + "," + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + "," + d7 + "," + d8);
        return true;
    }

    public synchronized boolean setCS507Holidays(int moduleAddr, int month, int d1, int d2, int d3, int d4, int d5, int d6, int d7, int d8) {
        this.setCS507_holidays[3] = (byte)moduleAddr;
        this.setCS507_holidays[5] = (byte)(96 + (month - 1 << 3));
        this.setCS507_holidays[7] = (byte)d1;
        this.setCS507_holidays[8] = (byte)d2;
        this.setCS507_holidays[9] = (byte)d3;
        this.setCS507_holidays[10] = (byte)d4;
        this.setCS507_holidays[11] = (byte)d5;
        this.setCS507_holidays[12] = (byte)d6;
        this.setCS507_holidays[13] = (byte)d7;
        this.setCS507_holidays[14] = (byte)d8;
        return this.processResponse(this.send(this.setCS507_holidays));
    }

    public synchronized boolean getCS507UserEnable(int moduleAddr, int user2) {
        this.getCS507_request[3] = (byte)moduleAddr;
        int cu = 192 + user2 - 1;
        this.getCS507_request[4] = (byte)(128 + (cu >>> 8 & 0xF));
        this.getCS507_request[5] = (byte)(cu & 0xFF);
        byte[] resp = this.send(this.getCS507_request);
        if (resp == null) {
            return false;
        }
        if ((resp[2] & 0x3F) != 16 || resp[3] != this.getCS507_request[3] || resp[5] != this.getCS507_request[5]) {
            Logger.log(Logger.Mode.ERROR, "setCS507EnableCode - response error [" + this.serverName + "]");
            return false;
        }
        String e1 = (resp[7] & 1) == 1 ? "1" : "0";
        String e2 = (resp[7] & 2) == 2 ? "1" : "0";
        String e3 = (resp[7] & 4) == 4 ? "1" : "0";
        String e4 = (resp[7] & 8) == 8 ? "1" : "0";
        String e5 = (resp[7] & 0x10) == 16 ? "1" : "0";
        String e6 = (resp[7] & 0x20) == 32 ? "1" : "0";
        String e7 = (resp[7] & 0x40) == 64 ? "1" : "0";
        String e8 = (resp[7] & 0x80) == 128 ? "1" : "0";
        this.ioWriteForced(this.genEvents, "cs507." + moduleAddr + ".user" + user2, String.valueOf(e1) + "," + e2 + "," + e3 + "," + e4 + "," + e5 + "," + e6 + "," + e7 + "," + e8);
        return true;
    }

    public synchronized boolean setCS507UserEnable(int moduleAddr, int user2, boolean e1, boolean e2, boolean e3, boolean e4, boolean e5, boolean e6, boolean e7, boolean e8) {
        this.setCS507_user[3] = (byte)moduleAddr;
        int cu = 192 + user2 - 1;
        this.setCS507_user[4] = (byte)(160 + (cu >>> 8 & 0xF));
        this.setCS507_user[5] = (byte)(cu & 0xFF);
        int b2 = 0;
        if (e1) {
            b2 = (byte)(b2 + 1);
        }
        if (e2) {
            b2 = (byte)(b2 + 2);
        }
        if (e3) {
            b2 = (byte)(b2 + 4);
        }
        if (e4) {
            b2 = (byte)(b2 + 8);
        }
        if (e5) {
            b2 = (byte)(b2 + 16);
        }
        if (e6) {
            b2 = (byte)(b2 + 32);
        }
        if (e7) {
            b2 = (byte)(b2 + 64);
        }
        if (e8) {
            b2 = (byte)(b2 + 128);
        }
        this.setCS507_user[7] = b2;
        return this.processResponse(this.send(this.setCS507_user));
    }

    private boolean processResponse(byte[] resp) {
        if (resp == null) {
            return false;
        }
        if ((resp[2] >>> 7 & 1) == 1) {
            Logger.log(Logger.Mode.VERBOSE, "ioMonitor - sending acknowledge [" + this.serverName + "]");
            util.readComm(this.commPort, 0);
            if (util.writeCommBytes(this.commPort, this.positive_acknowledge) != this.positive_acknowledge.length) {
                Logger.log(Logger.Mode.ERROR, "ioMonitor - error sending acknowledge [" + this.serverName + "]");
            }
        }
        if ((resp[2] & 0x3F) == 1) {
            StringBuffer fwv = new StringBuffer();
            int i2 = 3;
            while (i2 <= 6) {
                fwv.append((char)resp[i2]);
                ++i2;
            }
            this.firmware = fwv.toString();
        } else if ((resp[2] & 0x3F) == 8) {
            if (this.initStatus) {
                this.panelID = resp[3];
                if ((resp[7] & 1) == 1) {
                    this.pinDigits = 6;
                    if (this.guiSupport) {
                        userBase.uiSet(String.valueOf(this.serverName) + ".pin.digits.6", "visible", "true");
                        userBase.uiSet(String.valueOf(this.serverName) + ".pin.digits.4", "visible", "false");
                    }
                } else {
                    this.pinDigits = 4;
                    if (this.guiSupport) {
                        userBase.uiSet(String.valueOf(this.serverName) + ".pin.digits.4", "visible", "true");
                        userBase.uiSet(String.valueOf(this.serverName) + ".pin.digits.6", "visible", "false");
                    }
                }
                int i3 = 0;
                while (i3 < 8) {
                    if ((resp[12] >>> i3 & 1) == 1) {
                        int idx = i3 + 1;
                        this.partitions.put(idx, new Partition(idx));
                    }
                    ++i3;
                }
            } else {
                byte val = (byte)(resp[5] >>> 2 & 1);
                if (this.commFail != val) {
                    this.commFail = val;
                    this.ioWrite(this.genEvents, "comm.fail", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[29][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[30][this.language]);
                    }
                }
                if (this.fuseFault != (val = (byte)(resp[5] >>> 3 & 1))) {
                    this.fuseFault = val;
                    this.ioWrite(this.genEvents, "fuse.fault", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[31][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[32][this.language]);
                    }
                }
                if (this.panelTamper != (val = (byte)(resp[5] >>> 4 & 1))) {
                    this.panelTamper = val;
                    this.ioWrite(this.genEvents, "panel.tamper", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[33][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[34][this.language]);
                    }
                }
                if (this.sirenTamper != (val = (byte)(resp[5] >>> 5 & 1))) {
                    this.sirenTamper = val;
                    this.ioWrite(this.genEvents, "siren.tamper", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[35][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[36][this.language]);
                    }
                }
                if (this.batteryLow != (val = (byte)(resp[5] >>> 6 & 1))) {
                    this.batteryLow = val;
                    this.ioWrite(this.genEvents, "battery.low", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[37][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[38][this.language]);
                    }
                }
                if (this.acFail != (val = (byte)(resp[5] >>> 7 & 1))) {
                    this.acFail = val;
                    this.ioWrite(this.genEvents, "ac.fail", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[39][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[40][this.language]);
                    }
                }
                if (this.expanderTamper != (val = (byte)(resp[6] & 1))) {
                    this.expanderTamper = val;
                    this.ioWrite(this.genEvents, "expander.tamper", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[41][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[42][this.language]);
                    }
                }
                if (this.expanderAcFail != (val = (byte)(resp[6] >>> 1 & 1))) {
                    this.expanderAcFail = val;
                    this.ioWrite(this.genEvents, "expander.ac.fail", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[43][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[44][this.language]);
                    }
                }
                if (this.expanderBatteryLow != (val = (byte)(resp[6] >>> 2 & 1))) {
                    this.expanderBatteryLow = val;
                    this.ioWrite(this.genEvents, "expander.battery.low", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[45][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[46][this.language]);
                    }
                }
                if (this.expanderFault != (val = (byte)(resp[6] >>> 3 & 1 | resp[6] >>> 4 & 1 | resp[6] >>> 5 & 1 | resp[6] >>> 6 & 1))) {
                    this.expanderFault = val;
                    this.ioWrite(this.genEvents, "expander.fault", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[47][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[48][this.language]);
                    }
                }
                if (this.buzzer != (val = (byte)(resp[7] >>> 3 & 1))) {
                    this.buzzer = val;
                    this.ioWrite(this.genEvents, "buzzer", val);
                }
                if (this.siren != (val = (byte)(resp[7] >>> 4 & 1))) {
                    this.siren = val;
                    this.ioWrite(this.genEvents, "siren", val);
                }
                if (this.steadySiren != (val = (byte)(resp[7] >>> 5 & 1))) {
                    this.steadySiren = val;
                    this.ioWrite(this.genEvents, "steady.siren", val);
                }
                if (this.busLineFault != (val = (byte)(resp[7] >>> 6 & 1))) {
                    this.busLineFault = val;
                    this.ioWrite(this.genEvents, "bus.fault", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[49][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[50][this.language]);
                    }
                }
                if (this.acPower != (val = (byte)(resp[8] >>> 1 & 1))) {
                    this.acPower = val;
                    this.ioWrite(this.genEvents, "ac.power", val);
                }
                if (this.batteryLowMem != (val = (byte)(resp[8] >>> 2 & 1))) {
                    this.batteryLowMem = val;
                    this.ioWrite(this.genEvents, "battery.low.mem", val);
                }
                if (this.powerUpDelay != (val = (byte)(resp[9] >>> 1 & 1))) {
                    this.powerUpDelay = val;
                    this.ioWrite(this.genEvents, "powerup.delay", val);
                }
                if (this.walkTest != (val = (byte)(resp[9] >>> 2 & 1))) {
                    this.walkTest = val;
                    this.ioWrite(this.genEvents, "walk.test", val);
                    if (val == 1) {
                        this.securityLog(LOG_STRINGS[51][this.language]);
                    } else {
                        this.securityLog(LOG_STRINGS[52][this.language]);
                    }
                }
                if (this.sysTimeLoss != (val = (byte)(resp[9] >>> 3 & 1))) {
                    this.sysTimeLoss = val;
                    this.ioWrite(this.genEvents, "time.loss", val);
                }
            }
        } else if ((resp[2] & 0x3F) == 4) {
            int num = (resp[3] & 0xFF) + 1;
            if (this.initStatus) {
                Zone z = new Zone(num);
                boolean active = false;
                int i4 = 0;
                while (i4 < 8) {
                    Partition p;
                    if ((resp[4] >>> i4 & 1) == 1 && (p = this.partitions.get(i4 + 1)) != null) {
                        active = true;
                        p.zones.add(z);
                        z.partitions.add(p);
                    }
                    ++i4;
                }
                if (active) {
                    this.zones.put(num, z);
                }
            } else {
                Zone z = this.zones.get(num);
                z.setCondition(resp[8], resp[9]);
            }
        } else if ((resp[2] & 0x3F) == 3) {
            int num = (resp[3] & 0xFF) + 1;
            StringBuffer name = new StringBuffer();
            int i5 = 4;
            while (i5 <= 19) {
                name.append((char)resp[i5]);
                ++i5;
            }
            this.zones.get(num).setName(name.toString());
        } else if ((resp[2] & 0x3F) == 6) {
            int num = (resp[3] & 0xFF) + 1;
            Partition p = this.partitions.get(num);
            p.setLastUser(resp[8]);
            p.setCondition(resp[4], resp[5], resp[6], resp[7], resp[9], resp[10]);
        } else if ((resp[2] & 0x3F) != 25) {
            if ((resp[2] & 0x3F) == 16) {
                int min = resp[12] & 0xFF;
                int hour = resp[11] & 0xFF;
                int year = (resp[10] & 0xFF) + 2000;
                int day = resp[9] & 0xFF;
                int month = resp[8] >>> 4 & 0xF;
                String val = String.valueOf(year) + "-" + (month < 10 ? "0" + month : Integer.valueOf(month)) + "-" + (day < 10 ? "0" + day : Integer.valueOf(day)) + " " + (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (min < 10 ? "0" + min : Integer.valueOf(min)) + ":00";
                this.ioWrite(this.genEvents, "clock", val);
            } else {
                if ((resp[2] & 0x3F) == 28) {
                    Logger.log(Logger.Mode.ERROR, "ioMonitor - command/request failed [" + this.serverName + "]");
                    return false;
                }
                if ((resp[2] & 0x3F) == 29) {
                    Logger.log(Logger.Mode.VERBOSE, "ioMonitor - positive acknowledge received [" + this.serverName + "]");
                    return true;
                }
                if ((resp[2] & 0x3F) == 30) {
                    Logger.log(Logger.Mode.ERROR, "ioMonitor - negative acknowledge received [" + this.serverName + "]");
                    return false;
                }
                if ((resp[2] & 0x3F) == 31) {
                    Logger.log(Logger.Mode.EVENT, "ioMonitor - message rejected (disabled feature) [" + this.serverName + "]");
                    return false;
                }
                Logger.log(Logger.Mode.ERROR, "ioMonitor - unknown message: " + Integer.toHexString(resp[2] & 0x1F) + " [" + this.serverName + "]");
                return false;
            }
        }
        return true;
    }

    private void ioWrite(boolean event, String name, byte value) {
        this.ioWrite(event, name, "" + (value & 0xFF));
    }

    private void ioWrite(boolean event, String name, String value) {
        name = String.valueOf(this.serverName) + "." + name;
        if (event) {
            SystemState.ioWrite(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
        if (this.guiSupport) {
            this.uiSet(name, value);
        }
    }

    private void ioWriteForced(boolean event, String name, String value) {
        name = String.valueOf(this.serverName) + "." + name;
        if (event) {
            SystemState.ioWriteForced(name, value);
        } else {
            SystemState.ioWriteNoEvents(name, value);
        }
    }

    private void securityLog(String msg) {
        if (this.genLogs) {
            Logger.log(Logger.Mode.SECURITY, String.valueOf(this.serverName) + " - " + msg);
            this.uiSet("log", msg);
        }
    }

    private synchronized byte[] send(byte[] data) {
        this.addChecksum(data);
        data = this.byteStuff(data);
        util.readComm(this.commPort, 0);
        if (util.writeCommBytes(this.commPort, data) != data.length) {
            Logger.log(Logger.Mode.VERBOSE, "write comm error [" + this.serverName + "]");
            return null;
        }
        byte[] resp = util.readCommBytes(this.commPort, 2);
        if (resp == null || resp.length == 0) {
            Logger.log(Logger.Mode.VERBOSE, "read comm error 1: no response [" + this.serverName + "]");
            return null;
        }
        if (resp.length != 2) {
            Logger.log(Logger.Mode.VERBOSE, "read comm error 1: response length error [" + this.serverName + "]");
            return null;
        }
        if (resp[0] != 126) {
            Logger.log(Logger.Mode.VERBOSE, "read comm error 1: response error (" + Integer.toHexString(resp[0] & 0xFF) + ") [" + this.serverName + "]");
            return null;
        }
        int len = resp[1] & 0xFF;
        resp = new byte[len + 4];
        resp[0] = 126;
        resp[1] = (byte)len;
        int i2 = 0;
        while (i2 < len + 2) {
            byte[] b2 = util.readCommBytes(this.commPort, 1);
            if (b2 == null) {
                Logger.log(Logger.Mode.VERBOSE, "read comm error 2: no response [" + this.serverName + "]");
                return null;
            }
            if (b2.length < 1) {
                Logger.log(Logger.Mode.VERBOSE, "read comm error 2: response length error [" + this.serverName + "]");
                return null;
            }
            if (b2[0] == 125) {
                b2 = util.readCommBytes(this.commPort, 1);
                if (b2 == null) {
                    Logger.log(Logger.Mode.VERBOSE, "read comm error 3: no response [" + this.serverName + "]");
                    return null;
                }
                if (b2.length < 1) {
                    Logger.log(Logger.Mode.VERBOSE, "read comm error 3: response length error [" + this.serverName + "]");
                    return null;
                }
                resp[i2 + 2] = (byte)(b2[0] ^ 0x20);
            } else {
                resp[i2 + 2] = b2[0];
            }
            ++i2;
        }
        if (!this.controlChecksum(resp)) {
            Logger.log(Logger.Mode.VERBOSE, "checksum error [" + this.serverName + "]");
            return null;
        }
        return resp;
    }

    private byte[] byteStuff(byte[] data) {
        Vector<Byte> v = new Vector<Byte>();
        v.add(data[0]);
        int i2 = 1;
        while (i2 < data.length) {
            if (data[i2] == 125) {
                v.add((byte)125);
                v.add((byte)93);
            } else if (data[i2] == 126) {
                v.add((byte)125);
                v.add((byte)94);
            } else {
                v.add(data[i2]);
            }
            ++i2;
        }
        byte[] ret = new byte[v.size()];
        int i3 = 0;
        while (i3 < ret.length) {
            ret[i3] = (Byte)v.get(i3);
            ++i3;
        }
        return ret;
    }

    private void addChecksum(byte[] data) {
        int sum1 = 0;
        byte sum2 = 0;
        int i2 = 1;
        while (i2 < data.length - 2) {
            if (255 - (sum1 & 0xFF) < (data[i2] & 0xFF)) {
                sum1 = (byte)(sum1 + 1);
            }
            if (((sum1 = (int)((byte)(sum1 + data[i2]))) & 0xFF) == 255) {
                sum1 = 0;
            }
            if (255 - (sum2 & 0xFF) < (sum1 & 0xFF)) {
                sum2 = (byte)(sum2 + 1);
            }
            if (((sum2 = (byte)(sum2 + sum1)) & 0xFF) == 255) {
                sum2 = 0;
            }
            ++i2;
        }
        data[data.length - 2] = sum1;
        data[data.length - 1] = sum2;
    }

    private boolean controlChecksum(byte[] data) {
        byte sum1 = 0;
        byte sum2 = 0;
        int i2 = 1;
        while (i2 < data.length - 2) {
            if (255 - (sum1 & 0xFF) < (data[i2] & 0xFF)) {
                sum1 = (byte)(sum1 + 1);
            }
            if (((sum1 = (byte)(sum1 + data[i2])) & 0xFF) == 255) {
                sum1 = 0;
            }
            if (255 - (sum2 & 0xFF) < (sum1 & 0xFF)) {
                sum2 = (byte)(sum2 + 1);
            }
            if (((sum2 = (byte)(sum2 + sum1)) & 0xFF) == 255) {
                sum2 = 0;
            }
            ++i2;
        }
        return data[data.length - 2] == sum1 && data[data.length - 1] == sum2;
    }

    private void uiUpdate() {
        if (!this.guiSupport) {
            return;
        }
        if (this.logTime != -1L && System.currentTimeMillis() > this.logTime + 5000L) {
            this.logTime = -1L;
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", "");
        }
        if (this.pinInputTime != -1L && System.currentTimeMillis() > this.pinInputTime + 10000L) {
            this.pinInputTime = -1L;
            this.keypadPin = null;
            this.keypadPinIndex = 0;
            this.uiSet("digit", "clear");
        }
    }

    private void uiSet(String name, String value) {
        if (!this.guiSupport) {
            return;
        }
        if (name.equals("digit")) {
            if (value.equals("clear")) {
                int i2 = 0;
                while (i2 < 6) {
                    userBase.uiSet(String.valueOf(this.serverName) + ".pin." + i2, "value", "_");
                    ++i2;
                }
            } else if (value.equals("x")) {
                userBase.uiSet(String.valueOf(this.serverName) + ".pin." + (this.keypadPinIndex + 1), "value", "_");
            } else {
                userBase.uiSet(String.valueOf(this.serverName) + ".pin." + this.keypadPinIndex, "value", "*");
            }
        } else if (name.equals("log")) {
            this.logTime = System.currentTimeMillis();
            value = value.toUpperCase();
            String logEntry = "<div style=\"padding:3px\">" + this.dateFormat.format(this.logTime).toUpperCase() + "<br />" + value + "</div>";
            while (this.logs.size() >= this.logSize) {
                this.logs.remove(this.logSize - 1);
            }
            this.logs.add(0, logEntry);
            StringBuilder text = new StringBuilder();
            int i3 = 0;
            while (i3 < this.logs.size()) {
                text.append(this.logs.get(i3));
                ++i3;
            }
            userBase.uiSet(String.valueOf(this.serverName) + ".log", "value", text.toString());
            userBase.uiSet(String.valueOf(this.serverName) + ".log0", "value", value);
            i3 = 0;
            while (i3 < this.logs.size() && i3 < 20) {
                userBase.uiSet(String.valueOf(this.serverName) + ".log" + (i3 + 1), "value", this.logs.get(i3));
                ++i3;
            }
            this.saveLogs();
        } else if (name.endsWith("connection")) {
            if (value.equals("online")) {
                userBase.uiSet(String.valueOf(name) + ".label", "visible", "false");
            } else {
                userBase.uiSet(String.valueOf(name) + ".label", "visible", "true");
            }
        } else if (name.endsWith("name") || name.endsWith("last.user")) {
            userBase.uiSet(name, "value", value);
        } else if (name.endsWith("armed")) {
            if (value.equals("0")) {
                userBase.uiSet(String.valueOf(name) + ".0.label", "visible", "true");
                userBase.uiSet(String.valueOf(name) + ".1.label", "visible", "false");
                userBase.uiSet(String.valueOf(name) + ".away.label", "visible", "false");
                userBase.uiSet(String.valueOf(name) + ".stay.label", "visible", "false");
            } else if (value.equals("1")) {
                userBase.uiSet(String.valueOf(name) + ".1.label", "visible", "true");
                userBase.uiSet(String.valueOf(name) + ".0.label", "visible", "false");
            } else if (value.equals("away")) {
                userBase.uiSet(String.valueOf(name) + ".away.label", "visible", "true");
                userBase.uiSet(String.valueOf(name) + ".0.label", "visible", "false");
                userBase.uiSet(String.valueOf(name) + ".stay.label", "visible", "false");
            } else if (value.equals("stay")) {
                userBase.uiSet(String.valueOf(name) + ".stay.label", "visible", "true");
                userBase.uiSet(String.valueOf(name) + ".0.label", "visible", "false");
                userBase.uiSet(String.valueOf(name) + ".away.label", "visible", "false");
            }
        } else if (value.equals("1")) {
            userBase.uiSet(String.valueOf(name) + ".1.label", "visible", "true");
            userBase.uiSet(String.valueOf(name) + ".0.label", "visible", "false");
        } else if (value.equals("0")) {
            userBase.uiSet(String.valueOf(name) + ".1.label", "visible", "false");
            userBase.uiSet(String.valueOf(name) + ".0.label", "visible", "true");
        }
    }

    private static enum Cmd {
        GLOBAL,
        PARTITION,
        ZONE,
        CS507,
        SYSTEM,
        X10;

    }

    private static class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(msg);
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(msg);
                    break;
                }
                case SECURITY: {
                    hsyco.securityLog(msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR,
            SECURITY;

        }
    }

    private class Partition {
        private final int index;
        private byte lastUser = (byte)119;
        private byte fireTrouble = (byte)119;
        private byte fire = (byte)119;
        private byte buzzer = (byte)119;
        private byte tlmFault = (byte)119;
        private byte armed = (byte)119;
        private byte instant = (byte)119;
        private byte prevAlarm = (byte)119;
        private byte siren = (byte)119;
        private byte steadySiren = (byte)119;
        private byte alarmMem = (byte)119;
        private byte tamper = (byte)119;
        private byte silentExit = (byte)119;
        private byte entryguard = (byte)119;
        private byte chimeMode = (byte)119;
        private byte entry = (byte)119;
        private byte delayExpiration = (byte)119;
        private byte exit1 = (byte)119;
        private byte exit2 = (byte)119;
        private byte exitError = (byte)119;
        private byte nightMode = (byte)119;
        private byte reExit = (byte)119;
        private byte forceArm = (byte)119;
        private byte armReady = (byte)119;
        private byte forceArmReady = (byte)119;
        private byte chime = (byte)119;
        private byte errorBeep = (byte)119;
        private byte tone = (byte)119;
        private byte entry1 = (byte)119;
        private byte phone1alarm = (byte)119;
        private byte phone2alarm = (byte)119;
        private byte phone3alarm = (byte)119;
        private byte keyswitchArmed = (byte)119;
        private Vector<Zone> zones = new Vector();

        public Partition(int index) {
            this.index = index;
        }

        public void setLastUser(byte user2) {
            if (this.lastUser != user2) {
                this.lastUser = user2;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".last.user", user2);
                User u = (User)CSX75.this.users.get(user2 & 0xFF);
                if (u == null) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[14][CSX75.this.language].replace("%U", "" + user2)) + this.index);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[14][CSX75.this.language].replace("%U", u.name)) + this.index);
                }
            }
        }

        public void setCondition(byte cond1, byte cond2, byte cond3, byte cond4, byte cond5, byte cond6) {
            byte val = (byte)(cond1 >>> 1 & 1);
            if (this.fireTrouble != val) {
                this.fireTrouble = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".fire.trouble", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[15][CSX75.this.language]) + this.index);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[16][CSX75.this.language]) + this.index);
                }
            }
            if (this.fire != (val = (byte)(cond1 >>> 2 & 1))) {
                this.fire = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".fire", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[17][CSX75.this.language]) + this.index);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[18][CSX75.this.language]) + this.index);
                }
            }
            if (this.buzzer != (val = (byte)(cond1 >>> 3 & 1))) {
                this.buzzer = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".buzzer", val);
            }
            if (this.tlmFault != (val = (byte)(cond1 >>> 4 & 1))) {
                this.tlmFault = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".tlm.fault", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[19][CSX75.this.language]) + this.index);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[20][CSX75.this.language]) + this.index);
                }
            }
            val = (byte)(cond1 >>> 6 & 1);
            byte val1 = (byte)(cond3 >>> 2 & 1);
            if (this.armed != val || this.entryguard != val1) {
                this.armed = val;
                this.entryguard = val1;
                if (this.armed == 0) {
                    CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".armed", "0");
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[21][CSX75.this.language]) + this.index);
                    boolean a2 = false;
                    for (Partition p : CSX75.this.partitions.values()) {
                        if (p.armed == 0) continue;
                        a2 = true;
                        break;
                    }
                    if (!a2 && CSX75.this.sysArmed != 0) {
                        CSX75.this.sysArmed = (byte)0;
                        CSX75.this.ioWrite(CSX75.this.genEvents, "armed", "0");
                    }
                } else {
                    if (this.entryguard == 0) {
                        CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".armed", "away");
                        CSX75.this.securityLog(String.valueOf(LOG_STRINGS[22][CSX75.this.language]) + this.index);
                    } else {
                        CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".armed", "stay");
                        CSX75.this.securityLog(String.valueOf(LOG_STRINGS[23][CSX75.this.language]) + this.index);
                    }
                    if (CSX75.this.sysArmed != 1) {
                        CSX75.this.sysArmed = (byte)1;
                        CSX75.this.ioWrite(CSX75.this.genEvents, "armed", "1");
                    }
                }
            }
            if (this.instant != (val = (byte)(cond1 >>> 7 & 1))) {
                this.instant = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".instant", val);
            }
            if (this.prevAlarm != (val = (byte)(cond2 & 1))) {
                this.prevAlarm = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".alarm", val);
                if (val == 1) {
                    CSX75.this.ioWrite(CSX75.this.genEvents, "alarm", "1");
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[12][CSX75.this.language]) + this.index);
                } else {
                    boolean alrm = false;
                    for (Partition p : CSX75.this.partitions.values()) {
                        if (p.prevAlarm == 0) continue;
                        alrm = true;
                        break;
                    }
                    if (!alrm) {
                        CSX75.this.ioWrite(CSX75.this.genEvents, "alarm", "0");
                    }
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[13][CSX75.this.language]) + this.index);
                }
            }
            if (this.siren != (val = (byte)(cond2 >>> 1 & 1))) {
                this.siren = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".siren", val);
            }
            if (this.steadySiren != (val = (byte)(cond2 >>> 2 & 1))) {
                this.steadySiren = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".steady.siren", val);
            }
            if (this.alarmMem != (val = (byte)(cond2 >>> 3 & 1))) {
                this.alarmMem = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".alarm.mem", val);
            }
            if (this.tamper != (val = (byte)(cond2 >>> 4 & 1))) {
                this.tamper = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".tamper", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[24][CSX75.this.language]) + this.index);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[25][CSX75.this.language]) + this.index);
                }
            }
            if (this.tamper != (val = (byte)(cond2 >>> 5 & 1))) {
                this.tamper = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".cancel", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[26][CSX75.this.language]) + this.index);
                }
            }
            if (this.silentExit != (val = (byte)(cond3 >>> 1 & 1))) {
                this.silentExit = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".exit.silent", val);
            }
            if (this.chimeMode != (val = (byte)(cond3 >>> 3 & 1))) {
                this.chimeMode = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".chime.mode", val);
            }
            if (this.entry != (val = (byte)(cond3 >>> 4 & 1))) {
                this.entry = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".entry", val);
            }
            if (this.delayExpiration != (val = (byte)(cond3 >>> 5 & 1))) {
                this.delayExpiration = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".delay.exp", val);
            }
            if (this.exit1 != (val = (byte)(cond3 >>> 6 & 1))) {
                this.exit1 = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".exit.1", val);
            }
            if (this.exit2 != (val = (byte)(cond3 >>> 7 & 1))) {
                this.exit2 = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".exit.2", val);
            }
            if (this.exitError != (val = (byte)(cond4 >>> 4 & 1))) {
                this.exitError = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".exit.error", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[27][CSX75.this.language]) + this.index);
                }
            }
            if (this.nightMode != (val = (byte)(cond4 >>> 7 & 1))) {
                this.nightMode = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".night.mode", val);
            }
            if (this.reExit != (val = (byte)(cond5 & 1))) {
                this.reExit = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".reexit", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[28][CSX75.this.language]) + this.index);
                }
            }
            if (this.forceArm != (val = (byte)(cond5 >>> 1 & 1))) {
                this.forceArm = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".force.arm", val);
            }
            if (this.armReady != (val = (byte)(cond5 >>> 2 & 1))) {
                this.armReady = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".arm.ready", val);
            }
            if (this.forceArmReady != (val = (byte)(cond5 >>> 3 & 1))) {
                this.forceArmReady = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".force.arm.ready", val);
            }
            if (this.chime != (val = (byte)(cond5 >>> 5 & 1))) {
                this.chime = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".chime", val);
            }
            if (this.errorBeep != (val = (byte)(cond5 >>> 5 & 1))) {
                this.errorBeep = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".error.beep", val);
            }
            if (this.tone != (val = (byte)(cond5 >>> 5 & 1))) {
                this.tone = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".tone", val);
            }
            if (this.entry1 != (val = (byte)(cond6 & 1))) {
                this.entry1 = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".entry.1", val);
            }
            if (this.phone1alarm != (val = (byte)(cond6 >>> 2 & 1))) {
                this.phone1alarm = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".phone.1.alarm", val);
            }
            if (this.phone2alarm != (val = (byte)(cond6 >>> 3 & 1))) {
                this.phone2alarm = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".phone.2.alarm", val);
            }
            if (this.phone3alarm != (val = (byte)(cond6 >>> 4 & 1))) {
                this.phone3alarm = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".phone.3.alarm", val);
            }
            if (this.keyswitchArmed != (val = (byte)(cond6 >>> 6 & 1))) {
                this.keyswitchArmed = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "p" + this.index + ".keyswitch.armed", val);
            }
        }

        static /* synthetic */ byte access$0(Partition partition) {
            return partition.armed;
        }
    }

    private class User {
        private final String name;

        public User(int index, String name) {
            this.name = name;
            CSX75.this.ioWrite(CSX75.this.genEvents, "user" + index + ".name", name);
        }
    }

    private class Zone {
        private final int index;
        private String name;
        private byte open = (byte)119;
        private byte tamper = (byte)119;
        private byte trouble = (byte)119;
        private byte bypassed = (byte)119;
        private byte inhibited = (byte)119;
        private byte batteryLow = (byte)119;
        private byte supervisionLoss = (byte)119;
        private byte alarmMem = (byte)119;
        private byte bypassMem = (byte)119;
        public Vector<Partition> partitions = new Vector();

        public Zone(int index) {
            this.index = index;
            this.name = "Zone " + index;
        }

        public String getListLabel() {
            StringBuilder imgs = new StringBuilder();
            if (this.open == 1) {
                imgs.append("<img src=\"/$skin$/pic/csx75/cs-dooropen.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.alarmMem == 1) {
                imgs.append("<img src=\"/$skin$/pic/csx75/cs-alarm.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.bypassed == 1) {
                imgs.append("<img src=\"/$skin$/pic/csx75/cs-block.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.tamper == 1) {
                imgs.append("<img src=\"/$skin$/pic/csx75/cs-scissors.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            if (this.trouble == 1 || this.batteryLow == 1 || this.supervisionLoss == 1) {
                imgs.append("<img src=\"/$skin$/pic/csx75/cs-alert.png\" alt=\"\" width=\"20\" height=\"20\" style=\"vertical-align:-4px;\">");
            }
            String row = "<table cellpadding=\"0\" cellspacing=\"0\" style=\"table-layout:fixed; width:100%\"><tr>";
            row = String.valueOf(row) + "<td><div style=\"max-width:100%; text-overflow:ellipsis; overflow:hidden; white-space:nowrap; padding-right:10px\">" + this.name + "</div></td>";
            row = String.valueOf(row) + "<td style=\"text-align:right; width:100px; padding-right:5px\">" + imgs.toString() + "</td>";
            row = String.valueOf(row) + "</tr></table>";
            return row;
        }

        public void setName(String name) {
            this.name = name;
            CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".name", this.name);
        }

        public void setCondition(byte cond1, byte cond2) {
            Vector s;
            byte val = (byte)(cond1 & 1);
            if (this.open != val) {
                this.open = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".open", val);
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.open.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.tamper != (val = (byte)(cond1 >>> 1 & 1))) {
                this.tamper = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".tamper", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[0][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[1][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                }
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.teamper.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.trouble != (val = (byte)(cond1 >>> 2 & 1))) {
                this.trouble = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".trouble", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[2][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[3][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                }
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.warning.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.bypassed != (val = (byte)(cond1 >>> 3 & 1))) {
                this.bypassed = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".bypassed", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[4][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[5][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                }
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.bypassed.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.inhibited != (val = (byte)(cond1 >>> 4 & 1))) {
                this.inhibited = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".inhibited", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[6][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[7][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                }
            }
            if (this.batteryLow != (val = (byte)(cond1 >>> 5 & 1))) {
                this.batteryLow = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".battery.low", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[8][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[9][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                }
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.warning.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.supervisionLoss != (val = (byte)(cond1 >>> 6 & 1))) {
                this.supervisionLoss = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".supervision.loss", val);
                if (val == 1) {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[10][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                } else {
                    CSX75.this.securityLog(String.valueOf(LOG_STRINGS[11][CSX75.this.language]) + "[" + this.index + "] " + this.name);
                }
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.warning.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.alarmMem != (val = (byte)(cond2 & 1))) {
                this.alarmMem = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".alarm.mem", val);
                if (CSX75.this.guiSupport) {
                    s = (Vector)CSX75.this.zoneSessions.get(this.index);
                    if (s != null) {
                        for (String session : s) {
                            userBase.uiSet(session, String.valueOf(CSX75.this.serverName) + ".zone.sel.alarm.label", "visible", val == 1 ? "true" : "false");
                        }
                    }
                    CSX75.this.updateZonesList();
                }
            }
            if (this.bypassMem != (val = (byte)(cond2 >>> 1 & 1))) {
                this.bypassMem = val;
                CSX75.this.ioWrite(CSX75.this.genEvents, "z" + this.index + ".bypass.mem", val);
            }
        }
    }
}

