/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.PluginsWrapper;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.ioMonitor;
import com.hsyco.user;
import com.hsyco.userCode;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Airzone {
    public static final String[] WebObjects = new String[]{"airzone"};
    private static final String[] ZONE = new String[]{"ZONE", "ZONA", "ZONE"};
    private String serverName;
    private String commPort;
    private int controllerAddr;
    private ArrayBlockingQueue<String> ioqtx;
    private int language;
    private boolean guiSupport = true;
    private long pollInterval = 20000L;
    private long version = 1L;
    private boolean genEvents = false;
    private int[] zones;
    private byte sysPower = (byte)-1;
    private int sysMode = -1;
    private byte sysFanSpeed = (byte)-1;
    private byte tempUnit = (byte)-1;
    private int[] setPoint;
    private int[] remoteTemp;
    private int[] localTemp;
    private byte[] modeEco;
    private byte[] modeControl;
    private byte[] power;
    private byte[] hold;
    private byte[] fanSpeed;
    private byte[] fancoilPower;
    private byte[] sleep;
    private byte[] mode;
    private byte[] timeProg;
    private byte[] confMaster;
    private byte[] confMotorReg;
    private byte[] confMotorContr_ac;
    private byte[] confHeatingFloor;
    private byte[] confAntifreeze;
    private byte[] confAngleHeat;
    private byte[] confAngleCool;
    private byte[] confMinAirDamper;
    private byte[] confProbe;
    private byte[] confEcoInput;
    private byte[] confLFOffInput;
    private byte[] statusOutlet;
    private byte[] statusMotor;
    private byte[] statusRequest;
    private byte[] statusHeatFloor;
    private byte[] statusModuleType;
    private byte[] statusACC;
    private byte[] statusEcoInput;
    private byte[] statusOnOffInput;
    private byte[] statusFanSpeed;
    private byte[] statusPropOpening;
    private byte[] statusThermostatConn;
    private byte[] statusAntifreeze;
    private byte[] errMotConn;
    private byte[] errMotBlock;
    private byte[] errProbeOpen;
    private byte[] errProbeShort;
    private byte[] errConfig;
    private byte[] errComm;
    private byte[] err;

    void monitor(int ioIndex, ioMonitor me) {
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.serverName = Configuration.ioServersName.elementAt(ioIndex);
        String comm = Configuration.ioServersComm.elementAt(ioIndex);
        try {
            this.commPort = comm.split("/")[0];
            this.controllerAddr = Integer.parseInt(comm.split("/")[1]);
        }
        catch (Exception e2) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersComm format error [" + this.serverName + "]: Modbus address not set or not a number");
            return;
        }
        this.ioqtx = Configuration.ioQueueTx.elementAt(ioIndex);
        Logger.log(Logger.Mode.LOG, "ioMonitor - started [" + this.serverName + "]");
        String[] sa = Configuration.ioServersOptions.elementAt(ioIndex).split(",");
        int i2 = 0;
        while (i2 < sa.length) {
            String[] sb = sa[i2].split("=");
            if (sb.length >= 1) {
                String value;
                String param = sb[0].trim().toLowerCase();
                String string = value = sb.length == 1 ? "true" : sb[1].trim().toLowerCase();
                if (param.equalsIgnoreCase("gui")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.guiSupport = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.guiSupport = false;
                    } else {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - gui ignored");
                    }
                } else if (param.equalsIgnoreCase("pollinterval")) {
                    try {
                        int itvl = Integer.parseInt(value);
                        if (itvl < 1) {
                            throw new Exception();
                        }
                        this.pollInterval = itvl * 1000;
                    }
                    catch (Exception e3) {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - pollinterval ignored");
                    }
                } else if (param.equalsIgnoreCase("startupevents")) {
                    if (value.equalsIgnoreCase("true")) {
                        this.genEvents = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        this.genEvents = false;
                    } else {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - startupevents ignored");
                    }
                } else if (param.equalsIgnoreCase("version")) {
                    try {
                        int vr = Integer.parseInt(value);
                        if (vr != 1 && vr != 2) {
                            throw new Exception();
                        }
                        this.version = vr;
                    }
                    catch (Exception e4) {
                        Logger.log(Logger.Mode.ERROR, "ioMonitor - ioServersOption format error [" + this.serverName + "] - version ignored");
                    }
                }
            }
            ++i2;
        }
        switch (Configuration.language) {
            case 1: {
                this.language = 1;
                break;
            }
            case 2: {
                this.language = 2;
                break;
            }
            default: {
                this.language = 0;
            }
        }
        try {
            userCode.IOStartupEvent(ioIndex);
        }
        catch (Exception e5) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception in user event call: IOStartupEvent(" + ioIndex + ") - " + e5);
        }
        if (ioIndex > 0) {
            events.eventsExec("IOSTART" + ioIndex, 0, 0, null);
        } else {
            events.eventsExec("IOSTART", 0, 0, null);
        }
        events.eventsExec("IOSTART" + this.serverName, 0, 0, null);
        if (this.guiSupport) {
            PluginsWrapper.register(this.serverName, 21, this);
            if (this.version == 1L) {
                user.uiSet(String.valueOf(this.serverName) + ".version.label.1", "visible", "true");
                user.uiSet(String.valueOf(this.serverName) + ".version.label.2", "visible", "false");
            } else {
                user.uiSet(String.valueOf(this.serverName) + ".version.label.1", "visible", "false");
                user.uiSet(String.valueOf(this.serverName) + ".version.label.2", "visible", "true");
            }
        }
        try {
            me.heartbeat = System.currentTimeMillis();
            this.init();
            if (!this.polling()) {
                throw new Exception("polling error");
            }
            this.genEvents = true;
            SystemState.ioServersInitializedSet(ioIndex, true);
            this.ioWrite(true, "connection", "online");
        }
        catch (Exception e6) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Initializzation error - " + e6.getLocalizedMessage() + "[" + this.serverName + "]");
            me.quit = true;
        }
        String cmd = null;
        me.heartbeat = System.currentTimeMillis();
        try {
            while (!me.quit) {
                boolean ok = true;
                cmd = this.ioqtx.poll(this.pollInterval, TimeUnit.MILLISECONDS);
                if (cmd != null) {
                    do {
                        if (this.processCommand(cmd)) continue;
                        ok = false;
                    } while ((cmd = this.ioqtx.poll()) != null);
                }
                if (!this.polling()) {
                    ok = false;
                }
                if (!ok) continue;
                me.heartbeat = System.currentTimeMillis();
            }
        }
        catch (Exception e7) {
            Logger.log(Logger.Mode.ERROR, "ioMonitor - Exception in thread loop [" + this.serverName + "] - " + e7);
        }
        Logger.log(Logger.Mode.ERROR, "ioMonitor - quit [" + this.serverName + "]");
        SystemState.ioServersInitializedSet(ioIndex, false);
        this.ioWrite(true, "connection", "offline");
    }

    private void init() throws Exception {
        if (!this.getActiveZones()) {
            throw new Exception("zones detection error");
        }
        this.initStatusVars();
        if (this.version == 2L) {
            int[] nArray = this.zones;
            int n2 = this.zones.length;
            int n3 = 0;
            while (n3 < n2) {
                StringBuilder name;
                int z = nArray[n3];
                byte[] resp = user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | 0xE, 6);
                if (resp != null && resp.length == 14 && resp[0] == 3 && resp[1] == 12) {
                    name = new StringBuilder();
                    int i2 = 2;
                    while (i2 < resp.length) {
                        if (resp[i2] == 0) break;
                        name.append((char)(resp[i2] & 0xFF));
                        ++i2;
                    }
                } else {
                    throw new Exception("zone " + z + " name response error");
                }
                this.ioWrite(this.genEvents, "z" + z + ".name", name.toString());
                ++n3;
            }
        } else {
            int[] nArray = this.zones;
            int n4 = this.zones.length;
            int n5 = 0;
            while (n5 < n4) {
                int z = nArray[n5];
                this.ioWrite(this.genEvents, "z" + z + ".name", String.valueOf(ZONE[this.language]) + " " + z);
                ++n5;
            }
        }
    }

    private boolean polling() {
        boolean ok = true;
        int func = 0;
        if (!this.processResponse(func, 0, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, func, 1))) {
            ok = false;
        }
        if (!this.processResponse(func = 3, 0, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, func, 1))) {
            ok = false;
        }
        int[] nArray = this.zones;
        int n2 = this.zones.length;
        int n3 = 0;
        while (n3 < n2) {
            func = 3;
            int z = nArray[n3];
            if (!this.processResponse(func, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            if (!this.processResponse(func = 8, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            if (!this.processResponse(func = 10, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            if (!this.processResponse(func = 0, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            if (!this.processResponse(func = 4, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            if (!this.processResponse(func = 9, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            if (!this.processResponse(func = 13, z, user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, z << 8 | func, 1))) {
                ok = false;
            }
            ++n3;
        }
        this.checkSysStatus();
        return ok;
    }

    public String keypad(String id) {
        Logger.log(Logger.Mode.VERBOSE, "keypad - id: " + id + " [" + this.serverName + "]");
        int val_idx = id.lastIndexOf(46);
        String name = id.substring(0, val_idx);
        String value = id.substring(val_idx + 1);
        SystemState.ioSet(String.valueOf(this.serverName) + "." + name, value);
        return "";
    }

    private void initStatusVars() {
        int maxZ = this.getMax(this.zones);
        this.setPoint = new int[maxZ];
        this.remoteTemp = new int[maxZ];
        this.localTemp = new int[maxZ];
        this.modeEco = new byte[maxZ];
        this.modeControl = new byte[maxZ];
        this.power = new byte[maxZ];
        this.hold = new byte[maxZ];
        this.fanSpeed = new byte[maxZ];
        this.fancoilPower = new byte[maxZ];
        this.sleep = new byte[maxZ];
        this.mode = new byte[maxZ];
        this.timeProg = new byte[maxZ];
        this.confMaster = new byte[maxZ];
        this.confMotorReg = new byte[maxZ];
        this.confMotorContr_ac = new byte[maxZ];
        this.confHeatingFloor = new byte[maxZ];
        this.confAntifreeze = new byte[maxZ];
        this.confAngleHeat = new byte[maxZ];
        this.confAngleCool = new byte[maxZ];
        this.confMinAirDamper = new byte[maxZ];
        this.confProbe = new byte[maxZ];
        this.confEcoInput = new byte[maxZ];
        this.confLFOffInput = new byte[maxZ];
        this.statusOutlet = new byte[maxZ];
        this.statusMotor = new byte[maxZ];
        this.statusRequest = new byte[maxZ];
        this.statusHeatFloor = new byte[maxZ];
        this.statusModuleType = new byte[maxZ];
        this.statusACC = new byte[maxZ];
        this.statusEcoInput = new byte[maxZ];
        this.statusOnOffInput = new byte[maxZ];
        this.statusFanSpeed = new byte[maxZ];
        this.statusPropOpening = new byte[maxZ];
        this.statusThermostatConn = new byte[maxZ];
        this.statusAntifreeze = new byte[maxZ];
        this.errMotConn = new byte[maxZ];
        this.errMotBlock = new byte[maxZ];
        this.errProbeOpen = new byte[maxZ];
        this.errProbeShort = new byte[maxZ];
        this.errConfig = new byte[maxZ];
        this.errComm = new byte[maxZ];
        this.err = new byte[maxZ];
        int z = 0;
        while (z < maxZ) {
            this.setPoint[z] = -1;
            this.remoteTemp[z] = -1;
            this.localTemp[z] = -1;
            this.modeEco[z] = -1;
            this.modeControl[z] = -1;
            this.power[z] = -1;
            this.hold[z] = -1;
            this.fanSpeed[z] = -1;
            this.fancoilPower[z] = -1;
            this.sleep[z] = -1;
            this.mode[z] = -1;
            this.timeProg[z] = -1;
            this.confMaster[z] = -1;
            this.confMotorReg[z] = -1;
            this.confMotorContr_ac[z] = -1;
            this.confHeatingFloor[z] = -1;
            this.confAntifreeze[z] = -1;
            this.confAngleHeat[z] = -1;
            this.confAngleCool[z] = -1;
            this.confMinAirDamper[z] = -1;
            this.confProbe[z] = -1;
            this.confEcoInput[z] = -1;
            this.confLFOffInput[z] = -1;
            this.statusOutlet[z] = -1;
            this.statusMotor[z] = -1;
            this.statusRequest[z] = -1;
            this.statusHeatFloor[z] = -1;
            this.statusModuleType[z] = -1;
            this.statusACC[z] = -1;
            this.statusEcoInput[z] = -1;
            this.statusOnOffInput[z] = -1;
            this.statusFanSpeed[z] = -1;
            this.statusPropOpening[z] = -1;
            this.statusThermostatConn[z] = -1;
            this.statusAntifreeze[z] = -1;
            this.errMotConn[z] = -1;
            this.errMotBlock[z] = -1;
            this.errProbeOpen[z] = -1;
            this.errProbeShort[z] = -1;
            this.errConfig[z] = -1;
            this.errComm[z] = -1;
            this.err[z] = -1;
            ++z;
        }
    }

    private int getMax(int[] arr) {
        int max = 0;
        int[] nArray = arr;
        int n2 = arr.length;
        int n3 = 0;
        while (n3 < n2) {
            int e2 = nArray[n3];
            if (e2 > max) {
                max = e2;
            }
            ++n3;
        }
        return max;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processCommand(String cmd) {
        Logger.log(Logger.Mode.VERBOSE, "Processing command: " + cmd + " [" + this.serverName + "]");
        cmd = cmd.toLowerCase();
        try {
            String[] ev_val = cmd.split("=");
            String val = ev_val[1];
            if (val.equals("on")) {
                val = "1";
            } else if (val.equals("off")) {
                val = "0";
            }
            String ev = ev_val[0];
            int z = 0;
            String func = ev.split("\\.")[0];
            if (!func.startsWith("z")) {
                func = ev;
                return this.commandExecutor(cmd, func, z, val);
            }
            try {
                z = Integer.parseInt(func.substring(1));
                if (z < 1) return true;
                if (z > 32) {
                    return true;
                }
                func = ev.replace("z" + z + ".", "");
                return this.commandExecutor(cmd, func, z, val);
            }
            catch (Exception e2) {
                return true;
            }
        }
        catch (Exception e3) {
            return true;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean commandExecutor(String cmd, String func, int z, String val) {
        try {
            v = new byte[2];
            resp = null;
            andMask = new byte[2];
            orMask = new byte[2];
            if (z != 0) ** GOTO lbl111
            if (func.equals("time")) {
                f = 4;
                if (val.equals("0")) {
                    valInt = 0;
                } else {
                    dhm = val.split(":");
                    if (dhm.length != 3) {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    d = Byte.parseByte(dhm[0]);
                    h = Byte.parseByte(dhm[1]);
                    m = Byte.parseByte(dhm[2]);
                    if (d < 0 || d > 7 || h < 0 || h > 23 || m < 0 || m > 59) {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    valInt = (d & 7 | (h & 31) << 3 | (m & 63) << 8) & 16383;
                }
                v[0] = (byte)(valInt >>> 8 & 255);
                v[1] = (byte)(valInt & 255);
                resp = user.modbusWriteMultipleRegisters(this.commPort, this.controllerAddr, f, v);
            } else if (func.equals("mode")) {
                f = 0;
                andMask[0] = 0;
                andMask[1] = -2;
                if (val.equals("stop")) {
                    orMask[0] = 0;
                    orMask[1] = 0;
                } else if (val.equals("cold")) {
                    orMask[0] = 1;
                    orMask[1] = 0;
                } else if (val.equals("heatpump")) {
                    if (this.version == 1L) {
                        orMask[0] = 2;
                        orMask[1] = 0;
                    } else {
                        orMask[0] = 4;
                        orMask[1] = 0;
                    }
                } else if (val.equals("ventilation")) {
                    orMask[0] = 3;
                    orMask[1] = 0;
                } else if (val.equals("heatingfloor")) {
                    if (this.version == 1L) {
                        orMask[0] = 4;
                        orMask[1] = 0;
                    } else {
                        orMask[0] = 2;
                        orMask[1] = 0;
                    }
                } else if (val.equals("combheating")) {
                    orMask[0] = 2;
                    orMask[1] = 1;
                } else if (val.equals("dehumid") && this.version == 2L) {
                    orMask[0] = 6;
                    orMask[1] = 0;
                } else {
                    throw new Exception("Invalid command: " + cmd);
                }
                resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, f, andMask, orMask);
            } else if (func.equals("mode.fanspeed")) {
                f = 0;
                andMask[0] = -1;
                andMask[1] = -7;
                if (val.equals("auto") || val.equals("flip") && this.sysFanSpeed == 3) {
                    orMask[1] = 0;
                } else if (val.equals("1") || val.equals("flip") && this.sysFanSpeed == 0) {
                    orMask[1] = 2;
                } else if (val.equals("2") || val.equals("flip") && this.sysFanSpeed == 1) {
                    orMask[1] = 4;
                } else if (val.equals("3") || val.equals("flip") && this.sysFanSpeed == 2) {
                    orMask[1] = 6;
                } else {
                    throw new Exception("Invalid command: " + cmd);
                }
                resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, f, andMask, orMask);
            } else if (func.equals("temp.unit")) {
                f = 3;
                andMask[0] = -1;
                andMask[1] = -17;
                if (val.equals("c")) {
                    orMask[1] = 0;
                } else if (val.equals("f")) {
                    orMask[1] = -1;
                } else {
                    throw new Exception("Invalid command: " + cmd);
                }
                resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, f, andMask, orMask);
            } else {
                ret = true;
                var14_44 = this.zones;
                var13_42 = this.zones.length;
                var12_40 = 0;
                while (var12_40 < var13_42) {
                    zone = var14_44[var12_40];
                    if (!this.commandExecutor(cmd, func, zone, val)) {
                        ret = false;
                    }
                    ++var12_40;
                }
                return ret;
lbl111:
                // 1 sources

                if (func.equals("setpoint.temp")) {
                    f = 3;
                    valInt = val.equals("up") ? (this.tempUnit == 0 ? this.setPoint[z - 1] + 5 : this.setPoint[z - 1] + 1) : (val.equals("down") ? (this.tempUnit == 0 ? this.setPoint[z - 1] - 5 : this.setPoint[z - 1] - 1) : Integer.parseInt(val));
                    v[0] = (byte)(valInt >>> 8 & 255);
                    v[1] = (byte)(valInt & 255);
                    resp = user.modbusWriteMultipleRegisters(this.commPort, this.controllerAddr, z << 8 | f, v);
                } else if (this.version == 1L && func.equals("mode.eco")) {
                    f = 0;
                    andMask[0] = -2;
                    andMask[1] = -1;
                    if (val.equals("0") || val.equals("flip") && this.modeEco[z - 1] != 0) {
                        orMask[0] = 0;
                    } else if (val.equals("1") || val.equals("flip") && this.modeEco[z - 1] != 1) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("mode.control")) {
                    f = 0;
                    andMask[0] = -3;
                    andMask[1] = -1;
                    if (val.equals("manual") || val.equals("flip") && this.modeControl[z - 1] != 0) {
                        orMask[0] = 0;
                    } else if (val.equals("automatic") || val.equals("flip") && this.modeControl[z - 1] != 1) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("power")) {
                    f = 0;
                    andMask[0] = -5;
                    andMask[1] = -1;
                    if (val.equals("0") || val.equals("flip") && this.power[z - 1] != 0 && z != 0) {
                        orMask[0] = 0;
                    } else if (val.equals("1") || val.equals("flip") && this.power[z - 1] != 1 && z != 0) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("mode.hold")) {
                    f = 0;
                    andMask[0] = -9;
                    andMask[1] = -1;
                    if (val.equals("0")) {
                        orMask[0] = 0;
                    } else if (val.equals("1")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("mode.fanspeed")) {
                    f = 0;
                    andMask[0] = -49;
                    andMask[1] = -1;
                    if (val.equals("auto") || val.equals("flip") && this.fanSpeed[z - 1] == 3) {
                        orMask[0] = 0;
                    } else if (val.equals("1") || val.equals("flip") && this.fanSpeed[z - 1] == 0) {
                        orMask[0] = 16;
                    } else if (val.equals("2") || val.equals("flip") && this.fanSpeed[z - 1] == 1) {
                        orMask[0] = 32;
                    } else if (val.equals("3") || val.equals("flip") && this.fanSpeed[z - 1] == 2) {
                        orMask[0] = 48;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 2L && func.equals("mode.sleep")) {
                    f = 0;
                    andMask[0] = 63;
                    andMask[1] = -1;
                    if (val.equals("off") || val.equals("flip") && this.sleep[z - 1] == 3) {
                        orMask[0] = 0;
                    } else if (val.equals("30") || val.equals("flip") && this.sleep[z - 1] == 0) {
                        orMask[0] = 64;
                    } else if (val.equals("60") || val.equals("flip") && this.sleep[z - 1] == 1) {
                        orMask[0] = -128;
                    } else if (val.equals("90") || val.equals("flip") && this.sleep[z - 1] == 2) {
                        orMask[0] = -64;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 1L && func.equals("mode.fancoilpower")) {
                    f = 0;
                    andMask[0] = -65;
                    andMask[1] = -1;
                    if (val.equals("0")) {
                        orMask[0] = 0;
                    } else if (val.equals("1")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("mode")) {
                    f = 0;
                    andMask[0] = -1;
                    andMask[1] = -8;
                    if (val.equals("stop")) {
                        orMask[1] = 0;
                    } else if (val.equals("cold")) {
                        orMask[1] = 1;
                    } else if (val.equals("heatpump")) {
                        orMask[1] = this.version == 1L ? 2 : 4;
                    } else if (val.equals("ventilation")) {
                        orMask[1] = 3;
                    } else if (val.equals("heatingfloor")) {
                        orMask[1] = this.version == 1L ? 4 : 2;
                    } else if (val.equals("combheating")) {
                        orMask[1] = 5;
                    } else if (val.equals("dehumid") && this.version == 2L) {
                        orMask[1] = 6;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("config.master")) {
                    f = 4;
                    andMask[0] = -2;
                    andMask[1] = -1;
                    if (val.equals("0")) {
                        orMask[0] = 0;
                    } else if (val.equals("1")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 1L && func.equals("config.motregulationtype")) {
                    f = 4;
                    andMask[0] = -3;
                    andMask[1] = -1;
                    if (val.equals("on/off")) {
                        orMask[0] = 0;
                    } else if (val.equals("proportional")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 1L && func.equals("config.motcontrolled")) {
                    f = 4;
                    andMask[0] = -5;
                    andMask[1] = -1;
                    if (val.equals("0")) {
                        orMask[0] = 0;
                    } else if (val.equals("1")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 2L && func.equals("config.ac")) {
                    f = 4;
                    andMask[0] = -5;
                    andMask[1] = -1;
                    if (val.equals("0")) {
                        orMask[0] = 0;
                    } else if (val.equals("1")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("config.heatingfloorctrl")) {
                    f = 4;
                    andMask[0] = -9;
                    andMask[1] = -1;
                    if (val.equals("0")) {
                        orMask[0] = 0;
                    } else if (val.equals("1")) {
                        orMask[0] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("config.angle.heating")) {
                    f = 4;
                    andMask[0] = -97;
                    andMask[1] = -1;
                    if (val.equals("90")) {
                        orMask[0] = 0;
                    } else if (val.equals("50")) {
                        orMask[0] = 32;
                    } else if (val.equals("45")) {
                        orMask[0] = 64;
                    } else if (val.equals("40")) {
                        orMask[0] = 96;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("config.angle.cooling")) {
                    f = 4;
                    andMask[0] = 127;
                    andMask[1] = -2;
                    if (val.equals("90")) {
                        orMask[0] = 0;
                        orMask[1] = 0;
                    } else if (val.equals("50")) {
                        orMask[0] = -128;
                        orMask[1] = 0;
                    } else if (val.equals("45")) {
                        orMask[0] = 0;
                        orMask[1] = 1;
                    } else if (val.equals("40")) {
                        orMask[0] = -128;
                        orMask[1] = 1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("config.minairdamper")) {
                    f = 4;
                    andMask[0] = -1;
                    andMask[1] = -3;
                    if (val.equals("0")) {
                        orMask[1] = 0;
                    } else if (val.equals("1")) {
                        orMask[1] = -1;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (func.equals("config.probe")) {
                    f = 4;
                    andMask[0] = -1;
                    andMask[1] = -13;
                    if (val.equals("0")) {
                        orMask[1] = 0;
                    } else if (val.equals("remote")) {
                        orMask[1] = 4;
                    } else if (val.equals("floor")) {
                        orMask[1] = 8;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 1L && func.equals("config.ecoinput")) {
                    f = 4;
                    andMask[0] = -1;
                    andMask[1] = -49;
                    if (val.equals("disabled")) {
                        orMask[1] = 0;
                    } else if (val.equals("open")) {
                        orMask[1] = 16;
                    } else if (val.equals("closed")) {
                        orMask[1] = 32;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                } else if (this.version == 1L && func.equals("config.forcedoffinput")) {
                    f = 4;
                    andMask[0] = -1;
                    andMask[1] = 63;
                    if (val.equals("disabled")) {
                        orMask[1] = 0;
                    } else if (val.equals("open")) {
                        orMask[1] = 64;
                    } else if (val.equals("closed")) {
                        orMask[1] = -128;
                    } else {
                        throw new Exception("Invalid command: " + cmd);
                    }
                    resp = user.modbusWriteMaskRegister(this.commPort, this.controllerAddr, z << 8 | f, andMask, orMask);
                }
            }
            if (resp == null || resp[0] != 16 && resp[0] != 22) {
                Logger.log(Logger.Mode.ERROR, "commandExecutor - response error [" + this.serverName + "]");
                return false;
            }
        }
        catch (Exception e) {
            Logger.log(Logger.Mode.ERROR, "commandExecutor - error - " + e.getLocalizedMessage() + " [" + this.serverName + "]");
            return false;
        }
        return true;
    }

    private boolean processResponse(int func, int z, byte[] resp) {
        if (resp != null && resp.length == 4 && resp[0] == 3 && resp[1] == 2) {
            byte unit;
            if (z != 0) {
                if (func == 3) {
                    int v = ((resp[2] & 0xFF) << 8) + (resp[3] & 0xFF);
                    if (this.setPoint[z - 1] != v) {
                        this.setPoint[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".setpoint.temp", Integer.toString(v));
                    }
                } else if (func == 8) {
                    int v = ((resp[2] & 0xFF) << 8) + (resp[3] & 0xFF);
                    if (this.remoteTemp[z - 1] != v) {
                        this.remoteTemp[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".remotetemp", Integer.toString(v));
                        if (this.confProbe[z - 1] == 1) {
                            this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(v));
                        }
                    }
                } else if (func == 10) {
                    int v = ((resp[2] & 0xFF) << 8) + (resp[3] & 0xFF);
                    if (this.localTemp[z - 1] != v) {
                        this.localTemp[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".localtemp", Integer.toString(v));
                        if (this.confProbe[z - 1] == 0 || this.confProbe[z - 1] == 2) {
                            this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(v));
                        }
                    }
                } else if (func == 0) {
                    byte pr;
                    byte md;
                    byte fs;
                    byte hld;
                    byte pow;
                    byte contr;
                    byte eco = (byte)(resp[3] & 1);
                    if (this.version == 1L && this.modeEco[z - 1] != eco) {
                        this.modeEco[z - 1] = eco;
                        this.ioWrite(this.genEvents, "z" + z + ".mode.eco", Byte.toString(eco));
                    }
                    if (this.modeControl[z - 1] != (contr = (byte)(resp[3] >>> 1 & 1))) {
                        this.modeControl[z - 1] = contr;
                        if (contr == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode.control", "manual");
                        } else if (contr == 1) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode.control", "automatic");
                        }
                    }
                    if (this.power[z - 1] != (pow = (byte)(resp[3] >>> 2 & 1))) {
                        this.power[z - 1] = pow;
                        this.ioWrite(this.genEvents, "z" + z + ".power", Byte.toString(pow));
                    }
                    if (this.hold[z - 1] != (hld = (byte)(resp[3] >>> 3 & 1))) {
                        this.hold[z - 1] = hld;
                        this.ioWrite(this.genEvents, "z" + z + ".mode.hold", Byte.toString(hld));
                    }
                    if (this.fanSpeed[z - 1] != (fs = (byte)((resp[3] >>> 4 & 1) + (resp[3] >>> 5 & 1) * 2))) {
                        this.fanSpeed[z - 1] = fs;
                        if (fs == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode.fanspeed", "auto");
                        } else {
                            this.ioWrite(this.genEvents, "z" + z + ".mode.fanspeed", Byte.toString(fs));
                        }
                    }
                    if (this.version == 1L) {
                        byte fcPow = (byte)(resp[3] >>> 6 & 1);
                        if (this.fancoilPower[z - 1] != fcPow) {
                            this.fancoilPower[z - 1] = fcPow;
                            this.ioWrite(this.genEvents, "z" + z + ".mode.fancoilpower", Byte.toString(fcPow));
                        }
                    } else {
                        byte sl = (byte)((resp[3] >>> 6 & 1) + (resp[3] >>> 7 & 1) * 2);
                        if (this.sleep[z - 1] != sl) {
                            this.sleep[z - 1] = sl;
                            if (sl == 0) {
                                this.ioWrite(this.genEvents, "z" + z + ".mode.sleep", "off");
                            } else if (sl == 1) {
                                this.ioWrite(this.genEvents, "z" + z + ".mode.sleep", "30");
                            } else if (sl == 2) {
                                this.ioWrite(this.genEvents, "z" + z + ".mode.sleep", "60");
                            } else if (sl == 3) {
                                this.ioWrite(this.genEvents, "z" + z + ".mode.sleep", "90");
                            }
                        }
                    }
                    if (this.mode[z - 1] != (md = (byte)(resp[2] & 1 + (resp[2] >>> 1 & 1) * 2 + (resp[2] >>> 2 & 1) * 4))) {
                        this.mode[z - 1] = md;
                        if (md == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode", "stop");
                        } else if (md == 1) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode", "cold");
                        } else if (md == 2) {
                            if (this.version == 1L) {
                                this.ioWrite(this.genEvents, "z" + z + ".mode", "heatpump");
                            } else {
                                this.ioWrite(this.genEvents, "z" + z + ".mode", "heatingfloor");
                            }
                        } else if (md == 3) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode", "ventilation");
                        } else if (md == 4) {
                            if (this.version == 1L) {
                                this.ioWrite(this.genEvents, "z" + z + ".mode", "heatingfloor");
                            } else {
                                this.ioWrite(this.genEvents, "z" + z + ".mode", "heatpump");
                            }
                        } else if (md == 5) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode", "combheating");
                        } else if (md == 6) {
                            this.ioWrite(this.genEvents, "z" + z + ".mode", "dehumid");
                        }
                    }
                    if (this.version == 2L && this.timeProg[z - 1] != (pr = (byte)(resp[3] >>> 7 & 1))) {
                        this.timeProg[z - 1] = pr;
                        this.ioWrite(this.genEvents, "z" + z + ".mode.prog", Byte.toString(pr));
                    }
                } else if (func == 4) {
                    byte v = (byte)(resp[3] & 1);
                    if (this.confMaster[z - 1] != v) {
                        this.confMaster[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".config.master", Byte.toString(v));
                    }
                    if (this.version == 1L && this.confMotorReg[z - 1] != (v = (byte)(resp[3] >>> 1 & 1))) {
                        this.confMotorReg[z - 1] = v;
                        if (v == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.motregulationtype", "on/off");
                        } else {
                            this.ioWrite(this.genEvents, "z" + z + ".config.motregulationtype", "proportional");
                        }
                    }
                    if (this.confMotorContr_ac[z - 1] != (v = (byte)(resp[3] >>> 2 & 1))) {
                        this.confMotorContr_ac[z - 1] = v;
                        if (this.version == 1L) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.motcontrolled", Byte.toString(v));
                        } else {
                            this.ioWrite(this.genEvents, "z" + z + ".config.ac", Byte.toString(v));
                        }
                    }
                    if (this.confHeatingFloor[z - 1] != (v = (byte)(resp[3] >>> 3 & 1))) {
                        this.confHeatingFloor[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".config.heatingfloorctrl", Byte.toString(v));
                    }
                    if (this.version == 2L && this.confAntifreeze[z - 1] != (v = (byte)(resp[3] >>> 4 & 1))) {
                        this.confAntifreeze[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".config.antifreeze", Byte.toString(v));
                    }
                    if (this.confAngleHeat[z - 1] != (v = (byte)((resp[3] >>> 5 & 1) + (resp[3] >>> 6 & 1) * 2))) {
                        this.confAngleHeat[z - 1] = v;
                        if (v == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.heating", "90");
                        } else if (v == 1) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.heating", "50");
                        } else if (v == 2) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.heating", "45");
                        } else if (v == 3) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.heating", "40");
                        }
                    }
                    if (this.confAngleCool[z - 1] != (v = (byte)((resp[3] >>> 7 & 1) + (resp[2] & 1) * 2))) {
                        this.confAngleCool[z - 1] = v;
                        if (v == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.cooling", "90");
                        } else if (v == 1) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.cooling", "50");
                        } else if (v == 2) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.cooling", "45");
                        } else if (v == 3) {
                            this.ioWrite(this.genEvents, "z" + z + ".config.angle.cooling", "40");
                        }
                    }
                    if (this.version == 1L && this.confMinAirDamper[z - 1] != (v = (byte)(resp[2] >>> 1 & 1))) {
                        this.confMinAirDamper[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".config.minairdamper", Byte.toString(v));
                    }
                    if (this.version == 1L) {
                        v = (byte)((resp[2] >>> 2 & 1) + (resp[2] >>> 3 & 1) * 2);
                        if (this.confProbe[z - 1] != v) {
                            this.confProbe[z - 1] = v;
                            if (v == 0) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.probe", "off");
                                this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(this.localTemp[z - 1]));
                            } else if (v == 1) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.probe", "remote");
                                this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(this.remoteTemp[z - 1]));
                            } else if (v == 2) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.probe", "floor");
                                this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(this.localTemp[z - 1]));
                            }
                        }
                    } else {
                        v = (byte)(resp[2] >>> 2 & 1);
                        if (this.confProbe[z - 1] != v) {
                            this.confProbe[z - 1] = v;
                            this.ioWrite(this.genEvents, "z" + z + ".config.probe", Byte.toString(v));
                        }
                        if (v == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(this.localTemp[z - 1]));
                        } else if (v == 1) {
                            this.ioWrite(this.genEvents, "z" + z + ".temp", Integer.toString(this.remoteTemp[z - 1]));
                        }
                    }
                    if (this.version == 1L) {
                        v = (byte)((resp[2] >>> 4 & 1) + (resp[2] >>> 5 & 1) * 2);
                        if (this.confEcoInput[z - 1] != v) {
                            this.confEcoInput[z - 1] = v;
                            if (v == 0) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.ecoinput", "disabled");
                            } else if (v == 1) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.ecoinput", "open");
                            } else if (v == 2) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.ecoinput", "closed");
                            }
                        }
                        if (this.confLFOffInput[z - 1] != (v = (byte)((resp[2] >>> 6 & 1) + (resp[2] >>> 7 & 1) * 2))) {
                            this.confLFOffInput[z - 1] = v;
                            if (v == 0) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.forcedoffinput", "disabled");
                            } else if (v == 1) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.forcedoffinput", "open");
                            } else if (v == 2) {
                                this.ioWrite(this.genEvents, "z" + z + ".config.forcedoffinput", "closed");
                            }
                        }
                    }
                } else if (func == 9) {
                    byte v = (byte)(resp[3] & 1);
                    if (this.statusOutlet[z - 1] != v) {
                        this.statusOutlet[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.outlet", Byte.toString(v));
                    }
                    if (this.statusMotor[z - 1] != (v = (byte)(resp[3] >>> 1 & 1))) {
                        this.statusMotor[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.motor", Byte.toString(v));
                    }
                    if (this.statusHeatFloor[z - 1] != (v = (byte)(resp[3] >>> 5 & 1))) {
                        this.statusHeatFloor[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.heatingfloor", Byte.toString(v));
                    }
                    if (this.statusModuleType[z - 1] != (v = (byte)(resp[3] >>> 6 & 1))) {
                        this.statusModuleType[z - 1] = v;
                        if (v == 0) {
                            this.ioWrite(this.genEvents, "z" + z + ".status.moduletype", "outlet");
                        } else {
                            this.ioWrite(this.genEvents, "z" + z + ".status.moduletype", "fancoil");
                        }
                    }
                    if (this.version == 1L) {
                        v = (byte)(resp[2] & 1);
                        if (this.statusEcoInput[z - 1] != v) {
                            this.statusEcoInput[z - 1] = v;
                            this.ioWrite(this.genEvents, "z" + z + ".status.ecoinput", Byte.toString(v));
                        }
                        if (this.statusOnOffInput[z - 1] != (v = (byte)(resp[2] >>> 1 & 1))) {
                            this.statusOnOffInput[z - 1] = v;
                            this.ioWrite(this.genEvents, "z" + z + ".status.onoffinput", Byte.toString(v));
                        }
                    }
                    if (this.statusFanSpeed[z - 1] != (v = (byte)((resp[2] >>> 2 & 1) + (resp[2] >>> 3 & 1) * 2))) {
                        this.statusFanSpeed[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.fanspeed", Byte.toString(v));
                    }
                    if (this.statusPropOpening[z - 1] != (v = (byte)((resp[2] >>> 4 & 1) + (resp[2] >>> 5 & 1) * 2))) {
                        this.statusPropOpening[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.propopening", Integer.toString(v + 1));
                    }
                    if (this.statusThermostatConn[z - 1] != (v = (byte)(resp[2] >>> 6 & 1))) {
                        this.statusThermostatConn[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.thermconnection", Byte.toString(v));
                    }
                    if (this.version == 2L && this.statusAntifreeze[z - 1] != (v = (byte)(resp[2] >>> 7 & 1))) {
                        this.statusAntifreeze[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".status.antifreeze", Byte.toString(v));
                    }
                } else if (func == 13) {
                    byte v = (byte)(resp[3] >>> 2 & 1);
                    if (this.errMotConn[z - 1] != v) {
                        this.errMotConn[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error.motconnection", Byte.toString(v));
                    }
                    if (this.errMotBlock[z - 1] != (v = (byte)(resp[3] >>> 3 & 1))) {
                        this.errMotBlock[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error.motblock", Byte.toString(v));
                    }
                    if (this.errProbeOpen[z - 1] != (v = (byte)(resp[3] >>> 4 & 1))) {
                        this.errProbeOpen[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error.probeopen", Byte.toString(v));
                    }
                    if (this.errProbeShort[z - 1] != (v = (byte)(resp[3] >>> 5 & 1))) {
                        this.errProbeShort[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error.probeshort", Byte.toString(v));
                    }
                    if (this.errConfig[z - 1] != (v = (byte)(resp[3] >>> 6 & 1))) {
                        this.errConfig[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error.config", Byte.toString(v));
                    }
                    if (this.version == 2L && this.errComm[z - 1] != (v = (byte)(resp[3] >>> 7 & 1))) {
                        this.errComm[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error.comm", Byte.toString(v));
                    }
                    if (this.err[z - 1] != (v = (byte)(resp[3] & 0xFC))) {
                        this.err[z - 1] = v;
                        this.ioWrite(this.genEvents, "z" + z + ".error", v == 0 ? "0" : "1");
                    }
                }
            } else if (func == 0) {
                int wm = ((resp[2] & 1) << 8) + (resp[3] & 0xFF);
                byte fs = (byte)(resp[2] >>> 1 & 3);
                if (this.sysMode != wm) {
                    this.sysMode = wm;
                    if (wm == 0) {
                        this.ioWrite(this.genEvents, "mode", "stop");
                    } else if (wm == 1) {
                        this.ioWrite(this.genEvents, "mode", "cold");
                    } else if (wm == 2) {
                        if (this.version == 1L) {
                            this.ioWrite(this.genEvents, "mode", "heatpump");
                        } else {
                            this.ioWrite(this.genEvents, "mode", "heatingfloor");
                        }
                    } else if (wm == 3) {
                        this.ioWrite(this.genEvents, "mode", "ventilation");
                    } else if (wm == 4) {
                        if (this.version == 1L) {
                            this.ioWrite(this.genEvents, "mode", "heatingfloor");
                        } else {
                            this.ioWrite(this.genEvents, "mode", "heatpump");
                        }
                    } else if (wm == 6) {
                        this.ioWrite(this.genEvents, "mode", "dehumid");
                    } else if (wm == 258) {
                        this.ioWrite(this.genEvents, "mode", "combheating");
                    }
                }
                if (this.sysFanSpeed != fs) {
                    this.sysFanSpeed = fs;
                    if (fs == 0) {
                        this.ioWrite(this.genEvents, "mode.fanspeed", "auto");
                    } else {
                        this.ioWrite(this.genEvents, "mode.fanspeed", Byte.toString(fs));
                    }
                }
            } else if (func == 3 && this.tempUnit != (unit = (byte)(resp[2] >>> 4 & 1))) {
                this.tempUnit = unit;
                if (unit == 0) {
                    this.ioWrite(this.genEvents, "temp.unit", "c");
                } else if (unit == 1) {
                    this.ioWrite(this.genEvents, "temp.unit", "f");
                }
            }
            return true;
        }
        Logger.log(Logger.Mode.ERROR, "ioMonitor - response error for zone " + z + " - function: " + func + " [" + this.serverName + "]");
        return false;
    }

    private void checkSysStatus() {
        byte systemPow = 0;
        int[] nArray = this.zones;
        int n2 = this.zones.length;
        int n3 = 0;
        while (n3 < n2) {
            int zone = nArray[n3];
            if (this.power[zone - 1] == 1) {
                systemPow = 1;
            }
            ++n3;
        }
        if (this.sysPower != systemPow) {
            this.sysPower = systemPow;
            this.ioWrite(this.genEvents, "power", Byte.toString(systemPow));
        }
    }

    private boolean getActiveZones() {
        int b2;
        int zoneBits;
        int z = 0;
        int[] zns = new int[32];
        byte[] rsp = user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, 9, 1);
        if (rsp != null && rsp.length == 4 && rsp[0] == 3 && rsp[1] == 2) {
            zoneBits = (rsp[2] & 0xFF) << 8 | rsp[3] & 0xFF;
            b2 = 0;
            while (b2 < 16) {
                if ((zoneBits >>> b2 & 1) == 1) {
                    zns[b2] = 1;
                    ++z;
                } else {
                    zns[b2] = 0;
                }
                ++b2;
            }
        } else {
            return false;
        }
        rsp = user.modbusReadHoldingRegisters(this.commPort, this.controllerAddr, 10, 1);
        if (rsp != null && rsp.length == 4 && rsp[0] == 3 && rsp[1] == 2) {
            zoneBits = (rsp[2] & 0xFF) << 8 | rsp[3] & 0xFF;
            b2 = 0;
            while (b2 < 16) {
                if ((zoneBits >>> b2 & 1) == 1) {
                    zns[b2 + 16] = 1;
                    ++z;
                } else {
                    zns[b2 + 16] = 0;
                }
                ++b2;
            }
        } else {
            return false;
        }
        this.zones = new int[z];
        int a2 = 0;
        int i2 = 0;
        while (i2 < zns.length) {
            if (zns[i2] == 1) {
                this.zones[a2++] = i2 + 1;
            }
            ++i2;
        }
        int zn = 0;
        while (zn < this.zones.length) {
            Logger.log(Logger.Mode.EVENT, "ioMonitor - detected active zone " + this.zones[zn] + " on controller with modbus address " + this.controllerAddr + " [" + this.serverName + "]");
            ++zn;
        }
        return true;
    }

    private void ioWrite(boolean event, String name, String value) {
        if (event) {
            SystemState.ioWrite(String.valueOf(this.serverName) + "." + name, value);
        } else {
            SystemState.ioWriteNoEvents(String.valueOf(this.serverName) + "." + name, value);
        }
        if (this.guiSupport) {
            this.uiSet(String.valueOf(this.serverName) + "." + name, value);
        }
    }

    private void uiSet(String name, String value) {
        if (name.endsWith(".localtemp") || name.endsWith(".remotetemp") || name.endsWith(".setpoint.temp") || name.endsWith(".temp")) {
            if (this.tempUnit == 0) {
                value = String.valueOf(Float.toString(Float.parseFloat(value) / 10.0f)) + " &deg;C";
            } else if (this.tempUnit == 1) {
                value = String.valueOf(Integer.toString(Integer.parseInt(value))) + " &deg;F";
            }
            user.uiSet(name, "value", value);
        } else if (name.endsWith(".connection")) {
            if (value.equals("online")) {
                user.uiSet(String.valueOf(name) + ".label.online", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.offline", "visible", "false");
            } else {
                user.uiSet(String.valueOf(name) + ".label.online", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.offline", "visible", "true");
            }
        } else if (name.endsWith(".status.motor")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "false");
            } else {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "true");
            }
        } else if (name.endsWith(".power")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "false");
                try {
                    int z = Integer.parseInt(name.replace(String.valueOf(this.serverName) + ".z", "").replace(".power", ""));
                    if (this.modeControl[z - 1] == 0) {
                        user.uiSet(name.replace(".power", ".setpoint.temp"), "visible", "true");
                    }
                }
                catch (Exception z) {}
            } else {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "true");
                user.uiSet(name.replace(".power", ".setpoint.temp"), "visible", "false");
            }
        } else if (name.endsWith(".mode.eco")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "false");
            } else {
                user.uiSet(String.valueOf(name) + ".label.on", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.off", "visible", "true");
            }
        } else if (name.endsWith(".mode.sleep")) {
            user.uiSet(name, "value", value.toUpperCase());
        } else if (name.endsWith(".mode.fanspeed")) {
            user.uiSet(String.valueOf(name) + ".label.auto", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.1", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.2", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.3", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
        } else if (name.endsWith(".mode")) {
            user.uiSet(String.valueOf(name) + ".label.stop", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.cold", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.heatpump", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.ventilation", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.heatingfloor", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.combheating", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label.dehumid", "visible", "false");
            user.uiSet(String.valueOf(name) + ".label." + value, "visible", "true");
            user.uiSet(String.valueOf(name) + ".stop", "color", "gr");
            user.uiSet(String.valueOf(name) + ".cold", "color", "gr");
            user.uiSet(String.valueOf(name) + ".heatpump", "color", "gr");
            user.uiSet(String.valueOf(name) + ".ventilation", "color", "gr");
            user.uiSet(String.valueOf(name) + ".heatingfloor", "color", "gr");
            user.uiSet(String.valueOf(name) + ".combheating", "color", "gr");
            user.uiSet(String.valueOf(name) + ".dehumid", "color", "gr");
            user.uiSet(String.valueOf(name) + "." + value, "color", "b");
        } else if (name.endsWith(".mode.control")) {
            if (value.equals("manual")) {
                user.uiSet(String.valueOf(name) + ".label.manual", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.automatic", "visible", "false");
                int z = Integer.parseInt(name.replace(String.valueOf(this.serverName) + ".z", "").replace(".mode.control", ""));
                if (this.power[z - 1] == 1) {
                    user.uiSet(name.replace(".mode.control", ".setpoint.temp"), "visible", "true");
                }
            } else if (value.equals("automatic")) {
                user.uiSet(String.valueOf(name) + ".label.manual", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.automatic", "visible", "true");
                user.uiSet(name.replace(".mode.control", ".setpoint.temp"), "visible", "false");
            }
        } else if (name.endsWith(".config.master")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.1", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.0", "visible", "false");
            } else {
                user.uiSet(String.valueOf(name) + ".label.1", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.0", "visible", "true");
            }
        } else if (name.endsWith(".error")) {
            if (value.equals("1")) {
                user.uiSet(String.valueOf(name) + ".label.1", "visible", "true");
                user.uiSet(String.valueOf(name) + ".label.0", "visible", "false");
            } else {
                user.uiSet(String.valueOf(name) + ".label.1", "visible", "false");
                user.uiSet(String.valueOf(name) + ".label.0", "visible", "true");
            }
        } else if (name.endsWith(".name")) {
            user.uiSet(name, "value", value);
        }
    }

    private static class Logger {
        private Logger() {
        }

        static void log(Mode m2, String msg) {
            switch (m2) {
                case LOG: {
                    hsyco.messageLog(msg);
                    break;
                }
                case EVENT: {
                    if (!Configuration.eventsLog && !Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case VERBOSE: {
                    if (!Configuration.verboseLog) break;
                    hsyco.messageLog(msg);
                    break;
                }
                case ERROR: {
                    hsyco.errorLog(msg);
                }
            }
        }

        private static enum Mode {
            LOG,
            EVENT,
            VERBOSE,
            ERROR;

        }
    }
}

