/*
 * Decompiled with CFR 0.152.
 */
package com.hsyco;

import com.hsyco.Configuration;
import com.hsyco.HsycoFile;
import com.hsyco.SystemState;
import com.hsyco.events;
import com.hsyco.hsyco;
import com.hsyco.userCode;
import com.hsyco.util;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class Access {
    public static final int DENY = -1;
    public static final int AUTHENTICATE = -2;
    public static final int AUTHORIZED = -5;
    public static final int PUK = -3;
    public static final int PIN = -4;
    public static final String cookieExpirationDate = "Thu, 31-Dec-2039 23:59:59 GMT";
    public static String urlKey;
    private static final Executor exec;
    private static Object Monitor;
    private static Properties ap;
    private static long accessFileLastModified;
    private static boolean keysFileNotFound;
    private static Properties accessKeys;
    private static HashSet<String> accessMasterKeys;
    private static Properties accessAuthenticationKeys;
    private static Vector<Long> trustedNetLow;
    private static Vector<Long> trustedNetHigh;
    private static long keyTrustedNetValidityMillis;
    private static long keyNotTrustedNetValidityMillis;
    private static long keyInactivityMillis;
    private static int keyInactivityMode;
    private static Vector<String> userID;
    private static Vector<Boolean> userAdmin;
    private static Vector<String> userPIN;
    private static Vector<String> userPUK;
    private static Vector<Long> userLastAccessMillis;
    private static Vector<Long> userLastActivityMillis;
    private static Vector<Integer> userFailures;
    private static Vector<InetAddress> userIP;
    private static Vector<String> userDirs;
    private static HashSet<String> administratorPaths;
    private static long lastAuthenticationFailureTimeMillis;

    static {
        exec = Executors.newCachedThreadPool();
        Monitor = new Object();
        ap = new Properties();
        accessFileLastModified = 0L;
        keysFileNotFound = true;
        accessKeys = new Properties();
        accessMasterKeys = new HashSet();
        accessAuthenticationKeys = new Properties();
        trustedNetLow = new Vector();
        trustedNetHigh = new Vector();
        userID = new Vector();
        userAdmin = new Vector();
        userPIN = new Vector();
        userPUK = new Vector();
        userLastAccessMillis = new Vector();
        userLastActivityMillis = new Vector();
        userFailures = new Vector();
        userIP = new Vector();
        userDirs = new Vector();
        administratorPaths = new HashSet();
        lastAuthenticationFailureTimeMillis = 0L;
    }

    Access() {
    }

    private static String pinMask(String pin) {
        try {
            int len = pin.length();
            if (len > 2) {
                return String.valueOf(pin.charAt(0)) + "***" + pin.charAt(len - 1);
            }
            return "*****";
        }
        catch (Exception e2) {
            return "*****";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean keyCheck(String key, String list) {
        try {
            String[] sa;
            String[] stringArray = sa = list.split(",");
            int n2 = sa.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                String s = stringArray[n3];
                if (s.trim().equals(key)) {
                    return true;
                }
                ++n3;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean initialize() {
        try {
            String[] sr = Configuration.trustedNet.split(",");
            int i2 = 0;
            while (i2 < sr.length) {
                long longhigh;
                String[] sa = sr[i2].trim().split("-");
                InetAddress low = InetAddress.getByName(sa[0].trim());
                long longlow = ((long)(low.getAddress()[0] & 0xFF) << 24) + ((long)(low.getAddress()[1] & 0xFF) << 16) + ((long)(low.getAddress()[2] & 0xFF) << 8) + (long)(low.getAddress()[3] & 0xFF);
                if (sa.length > 1) {
                    InetAddress high = InetAddress.getByName(sa[1].trim());
                    longhigh = ((long)(high.getAddress()[0] & 0xFF) << 24) + ((long)(high.getAddress()[1] & 0xFF) << 16) + ((long)(high.getAddress()[2] & 0xFF) << 8) + (long)(high.getAddress()[3] & 0xFF);
                    if (longlow > longhigh) {
                        hsyco.errorLog("HSYCO error reading configuration file: trustedNet is incorrect [" + Configuration.trustedNet + "]");
                        return false;
                    }
                } else {
                    longhigh = longlow;
                }
                trustedNetLow.add(longlow);
                trustedNetHigh.add(longhigh);
                ++i2;
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("HSYCO error reading configuration file: trustedNet parameter is missing or incorrect [" + Configuration.trustedNet + "]");
            return false;
        }
        keyTrustedNetValidityMillis = Configuration.keyTrustedNetValidityMillis > 0L ? Configuration.keyTrustedNetValidityMillis : 86400000L;
        keyNotTrustedNetValidityMillis = Configuration.keyNotTrustedNetValidityMillis > 0L ? Configuration.keyNotTrustedNetValidityMillis : 3600000L;
        keyInactivityMillis = Configuration.keyInactivityMillis;
        keyInactivityMode = Configuration.keyInactivityMode;
        if (Access.accessFileCheckLoad(true) != 1) {
            hsyco.errorLog("HSYCO error reading access.ini file");
            return false;
        }
        if (urlKey != null && urlKey.length() > 7) {
            Access.reloadKeys();
        }
        administratorPaths.add("bacnetutil");
        administratorPaths.add("knxutil");
        administratorPaths.add("manager");
        administratorPaths.add("manager_settings");
        administratorPaths.add("wiring");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadKeys() {
        Object object = Monitor;
        synchronized (object) {
            try {
                accessKeys.clear();
                accessMasterKeys.clear();
                if (new File("keys.data").lastModified() != 0L) {
                    keysFileNotFound = false;
                    accessKeys.load(new FileInputStream(new File("keys.data")));
                } else {
                    keysFileNotFound = true;
                    hsyco.messageLog("HSYCO keys.data file not found: authentication keys cleared");
                }
            }
            catch (Exception e2) {
                hsyco.errorLog("HSYCO error reading keys.data file");
                return;
            }
            if (Configuration.haMode == -1 && Configuration.haClientSessionsFailover) {
                File f2 = new File("keys.master.data");
                try {
                    if (f2.canRead()) {
                        Properties mk = new Properties();
                        mk.load(new FileInputStream(f2));
                        accessKeys.putAll((Map<?, ?>)mk);
                        Enumeration<Object> ke = mk.keys();
                        while (ke.hasMoreElements()) {
                            accessMasterKeys.add((String)ke.nextElement());
                        }
                    }
                }
                catch (Exception e3) {
                    hsyco.errorLog("HSYCO error reading keys.master.data file");
                }
            }
        }
    }

    static void housekeeping() {
        long timeLimit = System.currentTimeMillis() - 180000L;
        Set<Map.Entry<Object, Object>> auth = accessAuthenticationKeys.entrySet();
        Iterator<Map.Entry<Object, Object>> itr = auth.iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> key = itr.next();
            if (Long.parseLong((String)key.getValue()) >= timeLimit) continue;
            itr.remove();
        }
        if (new File("keys.data").lastModified() == 0L) {
            if (!keysFileNotFound) {
                Access.reloadKeys();
                SystemState.haFilesChangeNotify();
            }
        } else {
            keysFileNotFound = false;
        }
    }

    private static void saveKeys() throws Exception {
        if (!accessMasterKeys.isEmpty()) {
            Properties p = new Properties();
            Enumeration<Object> ke = accessKeys.keys();
            while (ke.hasMoreElements()) {
                String key = (String)ke.nextElement();
                String value = accessKeys.getProperty(key);
                if (accessMasterKeys.contains(key)) continue;
                p.setProperty(key, value);
            }
            util.safePropertiesStore(p, "keys.data");
        } else {
            util.safePropertiesStore(accessKeys, "keys.data");
        }
        SystemState.haFilesChangeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int accessFileCheckLoad(boolean forced) {
        File accessFile = new File("access.ini");
        long t = accessFile.lastModified();
        if (t == 0L) {
            return -1;
        }
        if (!forced && t == accessFileLastModified) {
            return 0;
        }
        accessFileLastModified = t;
        Object object = Monitor;
        synchronized (object) {
            try {
                ap.clear();
                userID.clear();
                userAdmin.clear();
                userPIN.clear();
                userPUK.clear();
                userLastAccessMillis.clear();
                userLastActivityMillis.clear();
                userFailures.clear();
                userIP.clear();
                userDirs.clear();
                ap.load(new FileInputStream(accessFile));
                ap.remove("urlkey");
            }
            catch (Exception e2) {
                urlKey = null;
                return -1;
            }
            try {
                Enumeration<?> e3 = ap.propertyNames();
                while (e3.hasMoreElements()) {
                    String key = e3.nextElement().toString();
                    boolean isAdmin = key.startsWith("*");
                    if (isAdmin) {
                        userID.add(key.substring(1));
                        userAdmin.add(true);
                    } else {
                        userID.add(key);
                        userAdmin.add(false);
                    }
                    String[] sa = ap.getProperty(key, "").split(",");
                    switch (sa.length) {
                        case 1: {
                            userPIN.add("!!" + sa[0].trim());
                            userPUK.add(null);
                            userLastAccessMillis.add(0L);
                            userLastActivityMillis.add(System.currentTimeMillis());
                            userFailures.add(0);
                            userIP.add(null);
                            userDirs.add(null);
                            break;
                        }
                        case 2: {
                            userPIN.add("!!" + sa[0].trim());
                            userPUK.add(null);
                            userLastAccessMillis.add(0L);
                            userLastActivityMillis.add(System.currentTimeMillis());
                            userFailures.add(0);
                            userIP.add(null);
                            userDirs.add(sa[1].trim());
                            break;
                        }
                        case 5: {
                            userPIN.add(sa[0].trim());
                            userPUK.add(sa[1].trim());
                            userLastAccessMillis.add(Long.parseLong(sa[2].trim()));
                            userLastActivityMillis.add(System.currentTimeMillis());
                            userFailures.add(Integer.parseInt(sa[3].trim()));
                            userIP.add(InetAddress.getByName(sa[4].trim()));
                            userDirs.add(null);
                            break;
                        }
                        case 6: {
                            userPIN.add(sa[0].trim());
                            userPUK.add(sa[1].trim());
                            userLastAccessMillis.add(Long.parseLong(sa[3].trim()));
                            userLastActivityMillis.add(System.currentTimeMillis());
                            userFailures.add(Integer.parseInt(sa[4].trim()));
                            userIP.add(InetAddress.getByName(sa[5].trim()));
                            userDirs.add(sa[2].trim());
                        }
                    }
                }
                SystemState.haFilesChangeNotify();
                return 1;
            }
            catch (Exception e4) {
                hsyco.errorLog("HSYCO error reading access.ini file: format error");
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkPinPageRequest(String querykey, String keycookie, String path, InetAddress addr, boolean secureServer) {
        int r;
        block12: {
            block9: {
                block11: {
                    block10: {
                        try {
                            SystemState.locationClientSetIP(addr);
                            if (querykey.length() <= 0 && addr.isLoopbackAddress()) break block9;
                            if (querykey.length() >= 8) break block10;
                            hsyco.errorLog("SECURITY ALERT: CHECKPINPAGEREQ FAILED - REASON: TOO SHORT - IP: " + addr.getHostAddress() + " URLKEY: " + querykey);
                            return -1;
                        }
                        catch (Exception e2) {
                            hsyco.errorLog("SECURITY ALERT: CHECKPINPAGEREQ FAILED - REASON: GENERIC EXCEPTION - IP: " + addr.getHostAddress());
                            return -1;
                        }
                    }
                    if (urlKey != null) break block11;
                    hsyco.errorLog("SECURITY ALERT: CHECKPINPAGEREQ FAILED - REASON: URLKEY NOT CONFIGURED - IP: " + addr.getHostAddress() + " URLKEY: " + querykey);
                    return -1;
                }
                if (Access.keyCheck(querykey, urlKey)) break block9;
                hsyco.errorLog("SECURITY ALERT: CHECKPINPAGEREQ FAILED - REASON: NOT FOUND - IP: " + addr.getHostAddress() + " URLKEY: " + querykey);
                return -1;
            }
            if (keycookie != null && keycookie.length() != 0) break block12;
            return -3;
        }
        Object object = Monitor;
        synchronized (object) {
            r = Access.checkKey(keycookie, false, path, addr, secureServer, 0);
        }
        return r == -1 ? -3 : r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prepareAuthentication() {
        String key = Access.key();
        Object object = Monitor;
        synchronized (object) {
            accessAuthenticationKeys.setProperty(key, Long.toString(System.currentTimeMillis()));
        }
        return "U" + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkFilesRequest(String keycookie, String path, InetAddress addr, boolean secureServer, int activityType) {
        Object object = Monitor;
        synchronized (object) {
            return Access.checkKey(keycookie, false, path, addr, secureServer, activityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkFilesAuthenticationRequest(String keycookie, InetAddress addr) {
        String ts;
        block7: {
            try {
                Object object = Monitor;
                synchronized (object) {
                    ts = accessAuthenticationKeys.getProperty(keycookie.substring(1));
                }
                if (ts != null) break block7;
                hsyco.errorLog("SECURITY ALERT: CHECKFILESAUTH FAILED - REASON: NOT FOUND - IP: " + addr.getHostAddress() + " KEY: " + keycookie.substring(0, 6) + "...");
                return -1;
            }
            catch (Exception e2) {
                return -1;
            }
        }
        if (System.currentTimeMillis() - 180000L > Long.parseLong(ts)) {
            return -1;
        }
        return -5;
    }

    public static boolean checkKeyPresence(String key) {
        block3: {
            try {
                if (!Character.isUpperCase(key.charAt(0))) break block3;
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return accessKeys.containsKey(Access.keyHash(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logoutRequest(String keycookie, boolean reset, InetAddress clientaddr) {
        try {
            String hKey = Access.keyHash(keycookie);
            Object object = Monitor;
            synchronized (object) {
                String ts = accessKeys.getProperty(hKey);
                String[] sa = ts.split(",");
                final String a2 = clientaddr.getHostAddress();
                final String s = new String(keycookie);
                final String u = userID.elementAt(userPIN.indexOf(sa[0]));
                final boolean r = reset;
                if (reset) {
                    Access.removeKey(keycookie);
                    hsyco.messageLog("SECURITY ALERT: USER RESET - IP: " + clientaddr.getHostAddress() + " USER: " + u);
                } else {
                    if (sa.length == 5) {
                        accessKeys.setProperty(hKey, String.valueOf(sa[0]) + ",0" + "," + sa[2] + "," + sa[3] + "," + sa[4]);
                    } else {
                        accessKeys.setProperty(hKey, String.valueOf(sa[0]) + ",0" + "," + sa[2] + "," + sa[3]);
                    }
                    Access.saveKeys();
                    hsyco.messageLog("SECURITY ALERT: USER LOGOUT - IP: " + clientaddr.getHostAddress() + " USER: " + u);
                }
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            userCode.logoutEvent(a2, s, u, r);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        events.eventsExec("LOGOUT" + u, 0, 0, null, s);
                    }
                };
                exec.execute(task);
            }
        }
        catch (Exception e2) {
            hsyco.errorLog("SECURITY ALERT: USER LOGOUT FAILED - REASON: GENERIC EXCEPTION - IP: " + clientaddr.getHostAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String checkAuthenticationRequest(String puk, String pin, String keycookie, InetAddress clientaddr, boolean secureServer) {
        try {
            long clientTrustedIp = Access.checkTrustedIP(clientaddr);
            if (puk == null) {
                Object object = Monitor;
                synchronized (object) {
                    int mode = Access.checkKey(keycookie, true, null, clientaddr, secureServer, 0);
                    String hPin = Access.hash(pin);
                    int pinIndex = userPIN.indexOf(hPin);
                    if (pinIndex == -1) {
                        if (userPIN.indexOf("!!" + pin) >= 0 && clientTrustedIp == 0L) {
                            return "puk";
                        }
                        hsyco.errorLog("SECURITY ALERT: CHECKAUTHREQ FAILED - REASON: PIN NOT FOUND - IP: " + clientaddr.getHostAddress() + " PIN: " + Access.pinMask(pin));
                        return "puk";
                    }
                    if (mode != -5 && pinIndex != mode) {
                        return "puk";
                    }
                    return Access.updateUserLogin(keycookie, pinIndex, clientaddr);
                }
            }
            if (lastAuthenticationFailureTimeMillis > System.currentTimeMillis() - 30000L) {
                Thread.sleep(1000L + (long)(Math.random() * 1000.0));
            }
            Object object = Monitor;
            synchronized (object) {
                String hPin;
                int pinIndex;
                if (Character.isUpperCase(keycookie.charAt(0))) {
                    int mode = Access.checkAuthenticationKey(keycookie.substring(1));
                    if (mode == -1) {
                        lastAuthenticationFailureTimeMillis = System.currentTimeMillis();
                        return null;
                    }
                } else {
                    int mode = Access.checkKey(keycookie, true, null, clientaddr, secureServer, 0);
                    if (mode == -1) {
                        lastAuthenticationFailureTimeMillis = System.currentTimeMillis();
                        return null;
                    }
                }
                if ((pinIndex = userPIN.indexOf(hPin = Access.hash(pin))) == -1) {
                    pinIndex = userPIN.indexOf("!!" + pin);
                    if (pinIndex == -1) {
                        hsyco.errorLog("SECURITY ALERT: CHECKAUTHREQ FAILED - REASON: PIN NOT FOUND - IP: " + clientaddr.getHostAddress() + " PIN: " + Access.pinMask(pin));
                        lastAuthenticationFailureTimeMillis = System.currentTimeMillis();
                        return null;
                    }
                    if (puk.length() == 14 && clientTrustedIp == 0L) {
                        String hPuk = Access.hash(puk);
                        return Access.updateUserKeys(keycookie, pinIndex, hPin, hPuk, clientaddr);
                    }
                    hsyco.errorLog("SECURITY ALERT: CHECKAUTHREQ FAILED - REASON: NEW USER AUTH ERROR - IP: " + clientaddr.getHostAddress() + " PIN: " + Access.pinMask(pin));
                    lastAuthenticationFailureTimeMillis = System.currentTimeMillis();
                    return null;
                }
                String hPuk = Access.hash(puk);
                if (hPuk.equals(userPUK.elementAt(pinIndex))) {
                    return Access.updateUserLogin(keycookie, pinIndex, clientaddr);
                }
                hsyco.errorLog("SECURITY ALERT: CHECKAUTHREQ FAILED - REASON: PIN/PUK AUTH FAILED - IP: " + clientaddr.getHostAddress() + " HPIN: " + hPin.substring(0, 6) + "...");
                Access.updateUserFailures(pinIndex, clientaddr);
                lastAuthenticationFailureTimeMillis = System.currentTimeMillis();
                return null;
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUsers(String key) {
        if (key != null) {
            Object object = Monitor;
            synchronized (object) {
                try {
                    int pinRequestIndex = userPIN.indexOf(accessKeys.getProperty(Access.keyHash(key)).split(",")[0]);
                    if (!userAdmin.elementAt(pinRequestIndex).booleanValue()) {
                        return "null";
                    }
                }
                catch (Exception e2) {
                    return "null";
                }
            }
        }
        StringBuffer dirs = new StringBuffer("\"dirs\":[");
        Vector<String> fset = new Vector<String>();
        Access.indexFileSearch(null, fset);
        if (fset.size() <= 0) {
            return null;
        }
        Collections.sort(fset);
        Iterator<String> e3 = fset.iterator();
        while (e3.hasNext()) {
            dirs.append('\"');
            dirs.append(e3.next());
            dirs.append("\",");
        }
        dirs.deleteCharAt(dirs.length() - 1);
        dirs.append(']');
        Vector<Integer> sort = new Vector<Integer>();
        int i2 = 0;
        while (i2 < userID.size()) {
            int j2 = 0;
            String value = userID.get(i2);
            boolean added = false;
            while (!added) {
                if (j2 >= sort.size() || value.compareTo(userID.get((Integer)sort.get(j2))) <= 0) {
                    sort.add(j2, i2);
                    added = true;
                    continue;
                }
                ++j2;
            }
            ++i2;
        }
        StringBuffer users = new StringBuffer("\"users\":{");
        Object j2 = Monitor;
        synchronized (j2) {
            int j3 = 0;
            while (j3 < sort.size()) {
                int i3 = (Integer)sort.elementAt(j3);
                if (!userPIN.elementAt(i3).startsWith("!!")) {
                    block25: {
                        boolean disabled = userPIN.elementAt(i3).charAt(0) == '#';
                        users.append('\"');
                        users.append(userID.elementAt(i3));
                        users.append("\":[");
                        users.append(userAdmin.elementAt(i3) != false ? "1," : "0,");
                        users.append(disabled ? "1," : "0,");
                        String udirs = userDirs.elementAt(i3);
                        if (udirs == null) {
                            users.append("null,");
                        } else {
                            String[] su = udirs.split(" ");
                            users.append("[");
                            int k2 = 0;
                            while (true) {
                                if (k2 >= su.length) {
                                    if (users.charAt(users.length() - 1) != '[') break;
                                    users.deleteCharAt(users.length() - 1);
                                    users.append("null,");
                                    break block25;
                                }
                                int idx = fset.indexOf(su[k2]);
                                if (idx >= 0) {
                                    users.append(idx);
                                    users.append(',');
                                }
                                ++k2;
                            }
                            users.deleteCharAt(users.length() - 1);
                            users.append("],");
                        }
                    }
                    users.append('\"');
                    users.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(userLastAccessMillis.elementAt(i3))));
                    users.append("\",");
                    users.append(userFailures.elementAt(i3));
                    users.append(',');
                    users.append('\"');
                    users.append(userIP.elementAt(i3).getHostAddress());
                    users.append("\"],");
                }
                ++j3;
            }
        }
        if (users.charAt(users.length() - 1) == ',') {
            users.deleteCharAt(users.length() - 1);
        }
        users.append("}");
        StringBuffer sb = new StringBuffer("{");
        sb.append(dirs);
        sb.append(",\r\n");
        sb.append(users);
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAdmin(String key) {
        try {
            Object object = Monitor;
            synchronized (object) {
                int pinRequestIndex = userPIN.indexOf(accessKeys.getProperty(Access.keyHash(key)).split(",")[0]);
                return userAdmin.elementAt(pinRequestIndex);
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAdminUser(String id) {
        try {
            Object object = Monitor;
            synchronized (object) {
                return userAdmin.elementAt(userID.indexOf(id));
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectName(String key) {
        try {
            Object object = Monitor;
            synchronized (object) {
                return accessKeys.getProperty(Access.keyHash(key)).split(",")[4];
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserId(String key) {
        try {
            Object object = Monitor;
            synchronized (object) {
                int pinRequestIndex = userPIN.indexOf(accessKeys.getProperty(Access.keyHash(key)).split(",")[0]);
                return userID.elementAt(pinRequestIndex);
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getUserPinSHA1(String key) {
        try {
            Object object = Monitor;
            synchronized (object) {
                int i2 = userPIN.indexOf(accessKeys.getProperty(Access.keyHash(key)).split(",")[0]);
                return userPIN.elementAt(i2);
            }
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String newUser(String id, boolean admin, String pin, String puk, boolean enabled, String[] pages) {
        if (!(id.matches("[0-9a-zA-Z]{4,16}") && pin.matches("[0-9]{5,5}") && puk.matches("[0-9]{14,14}"))) {
            return "error";
        }
        if (userID.indexOf(id) >= 0) {
            return "dupname";
        }
        if (userPIN.indexOf(Access.hash(pin)) >= 0) {
            return "duppin";
        }
        if (userPIN.indexOf("#" + Access.hash(pin)) >= 0) {
            return "duppin";
        }
        try {
            boolean pdef = false;
            StringBuffer sb = new StringBuffer();
            if (!enabled) {
                sb.append('#');
            }
            sb.append(Access.hash(pin));
            sb.append(',');
            sb.append(Access.hash(puk));
            if (pages != null) {
                int i2 = 0;
                while (i2 < pages.length) {
                    if (pages[i2].length() > 0) {
                        if (pdef) {
                            sb.append(' ');
                        } else {
                            pdef = true;
                            sb.append(',');
                        }
                        sb.append(pages[i2]);
                    }
                    ++i2;
                }
            }
            sb.append(",0,0,0.0.0.0");
            Object object = Monitor;
            synchronized (object) {
                ap.remove(id);
                ap.remove("*" + id);
                ap.setProperty(admin ? "*" + id : id, sb.toString());
                util.safePropertiesStore(ap, "access.ini");
            }
            return Access.accessFileCheckLoad(true) != -1 ? "ack" : "error";
        }
        catch (Exception e2) {
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateUser(String id, boolean admin, String pin, String puk, boolean enabled, String[] pages) {
        boolean pinChange = pin.length() > 0 || puk.length() > 0;
        int uidx = userID.indexOf(id);
        if (!(!pinChange || pin.matches("[0-9]{5,5}") && puk.matches("[0-9]{14,14}"))) {
            return "error";
        }
        if (uidx < 0) {
            return "error";
        }
        if (pinChange) {
            int upinx = userPIN.indexOf(Access.hash(pin));
            if (upinx >= 0 && upinx != uidx) {
                return "duppin";
            }
            upinx = userPIN.indexOf("#" + Access.hash(pin));
            if (upinx >= 0 && upinx != uidx) {
                return "duppin";
            }
        }
        try {
            boolean pdef = false;
            StringBuffer sb = new StringBuffer();
            if (!enabled) {
                sb.append('#');
            }
            if (pinChange) {
                sb.append(Access.hash(pin));
                sb.append(',');
                sb.append(Access.hash(puk));
            } else {
                String hpin = userPIN.elementAt(uidx);
                if (hpin.charAt(0) == '#') {
                    hpin = hpin.substring(1);
                }
                sb.append(hpin);
                sb.append(',');
                sb.append(userPUK.elementAt(uidx));
            }
            if (pages != null) {
                int i2 = 0;
                while (i2 < pages.length) {
                    if (pages[i2].length() > 0) {
                        if (pdef) {
                            sb.append(' ');
                        } else {
                            pdef = true;
                            sb.append(',');
                        }
                        sb.append(pages[i2]);
                    }
                    ++i2;
                }
            }
            sb.append(',');
            sb.append(userLastAccessMillis.elementAt(uidx));
            sb.append(',');
            sb.append(userFailures.elementAt(uidx));
            sb.append(',');
            sb.append(userIP.elementAt(uidx).getHostAddress());
            Object object = Monitor;
            synchronized (object) {
                ap.remove(id);
                ap.remove("*" + id);
                ap.setProperty(admin ? "*" + id : id, sb.toString());
                util.safePropertiesStore(ap, "access.ini");
            }
            return Access.accessFileCheckLoad(true) != -1 ? "ack" : "error";
        }
        catch (Exception e2) {
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String deleteUser(String id) {
        try {
            Object object = Monitor;
            synchronized (object) {
                ap.remove(id);
                ap.remove("*" + id);
                util.safePropertiesStore(ap, "access.ini");
            }
            return Access.accessFileCheckLoad(true) != -1 ? "ack" : "error";
        }
        catch (Exception e2) {
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String modifyUserPuk(String id, String oldPuk, String newPuk) {
        Object object = Monitor;
        synchronized (object) {
            try {
                int uidx = userID.indexOf(id);
                if (newPuk.length() == 14 && userPUK.elementAt(uidx).equals(Access.hash(oldPuk))) {
                    String hpuk = Access.hash(newPuk);
                    userPUK.set(uidx, hpuk);
                    String k2 = userAdmin.elementAt(uidx) != false ? "*" + id : id;
                    String[] s = ap.getProperty(k2).split(",");
                    s[1] = hpuk;
                    StringBuffer sb = new StringBuffer();
                    int i2 = 0;
                    while (i2 < s.length) {
                        if (i2 > 0) {
                            sb.append(',');
                        }
                        sb.append(s[i2]);
                        ++i2;
                    }
                    ap.setProperty(k2, sb.toString());
                    util.safePropertiesStore(ap, "access.ini");
                    return Access.accessFileCheckLoad(true) != -1 ? "ack" : "error";
                }
                return "error";
            }
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Exception e2) {
                    return "error";
                }
            }
        }
    }

    private static void indexFileSearch(File dir, Vector<String> s) {
        try {
            String item;
            String name;
            File f2;
            if (dir != null) {
                f2 = dir;
            } else {
                f2 = new File("www");
                JarFile jar = new JarFile(new File("hsyco.jar"), false, 1);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (!entry.endsWith("/index.hsm")) continue;
                    s.add(entry.substring(4, entry.length() - 10));
                }
                jar.close();
                Vector<File> plugindirs = HsycoFile.getPluginsWwwDirs();
                int i2 = 0;
                while (plugindirs != null && i2 < plugindirs.size()) {
                    File pf = plugindirs.elementAt(i2);
                    String p = pf.getPath();
                    String[] pa = p.split("/");
                    if (pa[pa.length - 2].equals("www")) {
                        s.add(pa[pa.length - 1]);
                    }
                    ++i2;
                }
            }
            if (f2.isDirectory()) {
                File[] fa = f2.listFiles();
                int i3 = 0;
                while (i3 < fa.length) {
                    Access.indexFileSearch(fa[i3], s);
                    ++i3;
                }
            } else if (f2.isFile() && (name = f2.getName()).equalsIgnoreCase("index.hsm") && !s.contains(item = f2.getParent().substring(4))) {
                s.add(item);
            }
        }
        catch (Exception e2) {
            return;
        }
    }

    private static String hash(String message) {
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(message.getBytes());
            int i2 = 0;
            while (i2 < digest.length) {
                sb.append(Integer.toHexString(digest[i2] & 0xFF));
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String key() {
        StringBuffer sb = new StringBuffer();
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[64];
        random.nextBytes(bytes);
        int i2 = 0;
        while (i2 < bytes.length) {
            sb.append(Integer.toHexString(bytes[i2] & 0xFF));
            ++i2;
        }
        return sb.toString();
    }

    private static String keyHash(String key) {
        StringBuffer sbo = new StringBuffer();
        StringBuffer[] sba = new StringBuffer[8];
        int i2 = 0;
        while (i2 < sba.length) {
            sba[i2] = new StringBuffer();
            ++i2;
        }
        try {
            i2 = 0;
            while (i2 < key.length()) {
                sba[i2 % 8].append(key.charAt(i2));
                ++i2;
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            int i3 = 0;
            while (i3 < 8) {
                byte[] digest = md.digest(sba[i3].toString().getBytes());
                int j2 = 0;
                while (j2 < digest.length) {
                    sbo.append(Integer.toHexString(digest[j2] & 0xFF));
                    ++j2;
                }
                ++i3;
            }
            return sbo.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int checkKey(String key, boolean checksCount, String path, InetAddress addr, boolean secureServer, int activityType) {
        try {
            long kv;
            int pinIndex;
            int trusted;
            if (Character.isUpperCase(key.charAt(0))) {
                return -1;
            }
            String hKey = Access.keyHash(key);
            String ts = accessKeys.getProperty(hKey);
            if (ts == null) {
                hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: NOT FOUND - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "..." + " PATH: " + path);
                return -1;
            }
            String[] sa = ts.split(",");
            long t = Long.parseLong(sa[1]);
            int f2 = Integer.parseInt(sa[3]);
            int n2 = trusted = Access.checkTrustedIP(addr) == 0L ? 1 : 0;
            if (f2 > 2) {
                Access.removeKey(key);
                hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: TOO MANY RETRIES - IP: " + addr.getHostAddress() + " KEY: " + key);
                return -1;
            }
            if (checksCount) {
                ++f2;
                if (sa.length == 5) {
                    accessKeys.setProperty(hKey, String.valueOf(sa[0]) + "," + sa[1] + "," + trusted + "," + Integer.toString(f2) + "," + sa[4]);
                } else {
                    accessKeys.setProperty(hKey, String.valueOf(sa[0]) + "," + sa[1] + "," + trusted + "," + Integer.toString(f2));
                }
                Access.saveKeys();
            }
            if ((pinIndex = userPIN.indexOf(sa[0])) == -1) {
                pinIndex = userPIN.indexOf("#" + sa[0]);
                if (pinIndex == -1) {
                    Access.removeKey(key);
                    hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: NO PIN FOUND - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "...");
                    return -2;
                }
                hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: PIN IS DISABLED - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "...");
                return -2;
            }
            long l2 = kv = trusted == 1 || Access.isTrustedUserId(userID.elementAt(pinIndex)) ? keyTrustedNetValidityMillis : keyNotTrustedNetValidityMillis;
            if (t > 0L && System.currentTimeMillis() - kv < t) {
                if (activityType > 0 && Access.isInactive(pinIndex, activityType)) {
                    return pinIndex;
                }
                if (path == null) {
                    String udirs = userDirs.elementAt(pinIndex);
                    if (udirs == null || sa.length != 5) {
                        return -5;
                    }
                    String[] su = udirs.split(" ");
                    int i2 = 0;
                    while (i2 < su.length) {
                        if (su[i2].equals(sa[4])) {
                            return -5;
                        }
                        ++i2;
                    }
                    hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: ACCESS PATH MISMATCH - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "...");
                    return -1;
                }
                StringBuffer sb = new StringBuffer();
                int i3 = 0;
                while (i3 < path.length()) {
                    char ch = path.charAt(i3);
                    if (ch != '/') {
                        sb.append(ch);
                    }
                    ++i3;
                }
                String tpath = sb.toString();
                String udirs = userDirs.elementAt(pinIndex);
                if (udirs == null) {
                    if (!userAdmin.elementAt(pinIndex).booleanValue() && administratorPaths.contains(tpath)) {
                        hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: UNAUTHORIZED REQUEST OF ADMINISTRATION PAGES - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "...");
                        return -1;
                    }
                    accessKeys.setProperty(hKey, String.valueOf(sa[0]) + "," + sa[1] + "," + trusted + "," + Integer.toString(f2) + "," + tpath);
                    Access.saveKeys();
                    return -5;
                }
                String[] su = udirs.split(" ");
                int i4 = 0;
                while (i4 < su.length) {
                    if (su[i4].equals(tpath)) {
                        accessKeys.setProperty(hKey, String.valueOf(sa[0]) + "," + sa[1] + "," + trusted + "," + Integer.toString(f2) + "," + tpath);
                        Access.saveKeys();
                        return -5;
                    }
                    ++i4;
                }
                hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: ACCESS PATH MISMATCH - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "...");
                return -1;
            }
            return pinIndex;
        }
        catch (Exception e2) {
            hsyco.errorLog("SECURITY ALERT: CHECKKEY FAILED - REASON: GENERIC EXCEPTION - IP: " + addr.getHostAddress() + " KEY: " + key.substring(0, 6) + "...");
            return -1;
        }
    }

    private static boolean isInactive(int pinIndex, int activityType) {
        if (keyInactivityMode != 0) {
            long t = System.currentTimeMillis();
            if (t - userLastActivityMillis.elementAt(pinIndex) > keyInactivityMillis) {
                return true;
            }
            if (activityType >= keyInactivityMode) {
                userLastActivityMillis.setElementAt(t, pinIndex);
            }
            return false;
        }
        return false;
    }

    private static void removeKey(String key) {
        try {
            accessKeys.remove(Access.keyHash(key));
            Access.saveKeys();
            SystemState.uiClear(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int checkAuthenticationKey(String key) {
        String ts;
        block4: {
            try {
                ts = accessAuthenticationKeys.getProperty(key);
                if (ts != null) break block4;
                return -1;
            }
            catch (Exception e2) {
                return -1;
            }
        }
        if (System.currentTimeMillis() - 180000L > Long.parseLong(ts)) {
            accessAuthenticationKeys.remove(key);
            return -1;
        }
        return -3;
    }

    static boolean isAuthenticationKey(String key) {
        try {
            if (key != null && key.charAt(0) == 'U') {
                return key != null && accessAuthenticationKeys.containsKey(key.substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTrustedIP(InetAddress clientaddr) {
        return Access.checkTrustedIP(clientaddr) == 0L;
    }

    protected static long checkTrustedIP(InetAddress clientaddr) {
        if (clientaddr.isLoopbackAddress() && Configuration.trustedNetLocal) {
            return 0L;
        }
        long clientip = ((long)(clientaddr.getAddress()[0] & 0xFF) << 24) + ((long)(clientaddr.getAddress()[1] & 0xFF) << 16) + ((long)(clientaddr.getAddress()[2] & 0xFF) << 8) + (long)(clientaddr.getAddress()[3] & 0xFF);
        int i2 = 0;
        while (i2 < trustedNetLow.size()) {
            if (clientip >= trustedNetLow.elementAt(i2) && clientip <= trustedNetHigh.elementAt(i2)) {
                return 0L;
            }
            ++i2;
        }
        return clientip;
    }

    public static boolean isTrustedUserId(String userId) {
        return Configuration.trustedUsers.contains(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String updateUserKeys(String oldkey, int pinIndex, String hPin, String hPuk, InetAddress clientaddr) throws Exception {
        String path = null;
        Object object = Monitor;
        synchronized (object) {
            String k2;
            try {
                String holdkey = Access.keyHash(oldkey);
                String ts = accessKeys.getProperty(holdkey);
                String[] sa = ts.split(",");
                if (sa.length == 5) {
                    path = sa[4];
                }
                accessKeys.remove(holdkey);
                Access.saveKeys();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long millis = System.currentTimeMillis();
            String key = Access.key();
            String hkey = Access.keyHash(key);
            userPIN.setElementAt(hPin, pinIndex);
            userPUK.setElementAt(hPuk, pinIndex);
            userLastAccessMillis.setElementAt(millis, pinIndex);
            userFailures.setElementAt(0, pinIndex);
            userIP.setElementAt(clientaddr, pinIndex);
            hsyco.messageLog("SECURITY ALERT: USER LOGIN - IP: " + clientaddr.getHostAddress() + " USER: " + userID.elementAt(pinIndex) + " KEY: " + key.substring(0, 6) + "..." + " OKEY: " + oldkey.substring(0, 6) + "...");
            if (path == null) {
                accessKeys.setProperty(hkey, String.valueOf(hPin) + "," + Long.toString(millis) + (Access.checkTrustedIP(clientaddr) == 0L ? ",1,0" : ",0,0"));
            } else {
                accessKeys.setProperty(hkey, String.valueOf(hPin) + "," + Long.toString(millis) + (Access.checkTrustedIP(clientaddr) == 0L ? ",1,0," : ",0,0,") + path);
            }
            Access.saveKeys();
            String string = k2 = userAdmin.elementAt(pinIndex) != false ? "*" + userID.elementAt(pinIndex) : userID.elementAt(pinIndex);
            if (userDirs.elementAt(pinIndex) == null) {
                ap.setProperty(k2, String.valueOf(hPin) + "," + hPuk + "," + millis + ",0," + clientaddr.getHostAddress());
            } else {
                ap.setProperty(k2, String.valueOf(hPin) + "," + hPuk + "," + userDirs.elementAt(pinIndex) + "," + millis + ",0," + clientaddr.getHostAddress());
            }
            util.safePropertiesStore(ap, "access.ini");
            accessFileLastModified = new File("access.ini").lastModified();
            final String a2 = clientaddr.getHostAddress();
            final String s = new String(key);
            final String u = userID.elementAt(pinIndex);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        userCode.loginEvent(a2, s, u);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    events.eventsExec("LOGIN" + u, 0, 0, null, s);
                }
            };
            exec.execute(task);
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUserFailures(int pinIndex, InetAddress clientaddr) throws Exception {
        Object object = Monitor;
        synchronized (object) {
            String k2;
            long millis = System.currentTimeMillis();
            int failures = userFailures.elementAt(pinIndex) + 1;
            userLastAccessMillis.setElementAt(millis, pinIndex);
            userFailures.setElementAt(failures, pinIndex);
            userIP.setElementAt(clientaddr, pinIndex);
            String string = k2 = userAdmin.elementAt(pinIndex) != false ? "*" + userID.elementAt(pinIndex) : userID.elementAt(pinIndex);
            if (userDirs.elementAt(pinIndex) == null) {
                ap.setProperty(k2, String.valueOf(userPIN.elementAt(pinIndex)) + "," + userPUK.elementAt(pinIndex) + "," + millis + "," + failures + "," + clientaddr.getHostAddress());
            } else {
                ap.setProperty(k2, String.valueOf(userPIN.elementAt(pinIndex)) + "," + userPUK.elementAt(pinIndex) + "," + userDirs.elementAt(pinIndex) + "," + millis + "," + failures + "," + clientaddr.getHostAddress());
            }
            util.safePropertiesStore(ap, "access.ini");
            accessFileLastModified = new File("access.ini").lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String updateUserLogin(String oldkey, int pinIndex, InetAddress clientaddr) throws Exception {
        String path = null;
        Object object = Monitor;
        synchronized (object) {
            String k2;
            try {
                String holdkey = Access.keyHash(oldkey);
                String ts = accessKeys.getProperty(holdkey);
                String[] sa = ts.split(",");
                if (sa.length == 5) {
                    path = sa[4];
                }
                accessKeys.remove(holdkey);
                Access.saveKeys();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long millis = System.currentTimeMillis();
            String key = Access.key();
            String hkey = Access.keyHash(key);
            String hpin = userPIN.elementAt(pinIndex);
            if (path == null) {
                accessKeys.setProperty(hkey, String.valueOf(hpin) + "," + Long.toString(millis) + (Access.checkTrustedIP(clientaddr) == 0L ? ",1,0" : ",0,0"));
            } else {
                accessKeys.setProperty(hkey, String.valueOf(hpin) + "," + Long.toString(millis) + (Access.checkTrustedIP(clientaddr) == 0L ? ",1,0," : ",0,0,") + path);
            }
            Access.saveKeys();
            userLastAccessMillis.setElementAt(millis, pinIndex);
            userLastActivityMillis.setElementAt(millis, pinIndex);
            userFailures.setElementAt(0, pinIndex);
            userIP.setElementAt(clientaddr, pinIndex);
            hsyco.messageLog("SECURITY ALERT: USER LOGIN - IP: " + clientaddr.getHostAddress() + " USER: " + userID.elementAt(pinIndex) + " KEY: " + key.substring(0, 6) + "..." + " OKEY: " + oldkey.substring(0, 6) + "...");
            String string = k2 = userAdmin.elementAt(pinIndex) != false ? "*" + userID.elementAt(pinIndex) : userID.elementAt(pinIndex);
            if (userDirs.elementAt(pinIndex) == null) {
                ap.setProperty(k2, String.valueOf(hpin) + "," + userPUK.elementAt(pinIndex) + "," + millis + ",0," + clientaddr.getHostAddress());
            } else {
                ap.setProperty(k2, String.valueOf(hpin) + "," + userPUK.elementAt(pinIndex) + "," + userDirs.elementAt(pinIndex) + "," + millis + ",0," + clientaddr.getHostAddress());
            }
            util.safePropertiesStore(ap, "access.ini");
            accessFileLastModified = new File("access.ini").lastModified();
            final String a2 = clientaddr.getHostAddress();
            final String s = new String(key);
            final String u = userID.elementAt(pinIndex);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        userCode.loginEvent(a2, s, u);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    events.eventsExec("LOGIN" + u, 0, 0, null, s);
                }
            };
            exec.execute(task);
            return key;
        }
    }
}

