/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.ServerHostKeyVerifier;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.cipher.BlockCipher;
import ch.ethz.ssh2.crypto.cipher.BlockCipherFactory;
import ch.ethz.ssh2.crypto.dh.DhExchange;
import ch.ethz.ssh2.crypto.dh.DhGroupExchange;
import ch.ethz.ssh2.crypto.digest.MAC;
import ch.ethz.ssh2.packets.PacketKexDHInit;
import ch.ethz.ssh2.packets.PacketKexDHReply;
import ch.ethz.ssh2.packets.PacketKexDhGexGroup;
import ch.ethz.ssh2.packets.PacketKexDhGexInit;
import ch.ethz.ssh2.packets.PacketKexDhGexReply;
import ch.ethz.ssh2.packets.PacketKexDhGexRequest;
import ch.ethz.ssh2.packets.PacketKexDhGexRequestOld;
import ch.ethz.ssh2.packets.PacketKexInit;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import ch.ethz.ssh2.transport.ClientServerHello;
import ch.ethz.ssh2.transport.KexManager;
import ch.ethz.ssh2.transport.KexState;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.security.SecureRandom;

public class ClientKexManager
extends KexManager {
    ServerHostKeyVerifier verifier;
    final String hostname;
    final int port;

    public ClientKexManager(TransportManager tm, ClientServerHello csh, CryptoWishList initialCwl, String hostname, int port, ServerHostKeyVerifier keyVerifier, SecureRandom rnd) {
        super(tm, csh, initialCwl, rnd);
        this.hostname = hostname;
        this.port = port;
        this.verifier = keyVerifier;
    }

    protected boolean verifySignature(byte[] sig, byte[] hostkey) throws IOException {
        if (this.kxs.np.server_host_key_algo.equals("ssh-rsa")) {
            RSASignature rs = RSASHA1Verify.decodeSSHRSASignature(sig);
            RSAPublicKey rpk = RSASHA1Verify.decodeSSHRSAPublicKey(hostkey);
            log.debug("Verifying ssh-rsa signature");
            return RSASHA1Verify.verifySignature(this.kxs.H, rs, rpk);
        }
        if (this.kxs.np.server_host_key_algo.equals("ssh-dss")) {
            DSASignature ds = DSASHA1Verify.decodeSSHDSASignature(sig);
            DSAPublicKey dpk = DSASHA1Verify.decodeSSHDSAPublicKey(hostkey);
            log.debug("Verifying ssh-dss signature");
            return DSASHA1Verify.verifySignature(this.kxs.H, ds, dpk);
        }
        throw new IOException("Unknown server host key algorithm '" + this.kxs.np.server_host_key_algo + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            Object object = this.accessLock;
            synchronized (object) {
                this.connectionClosed = true;
                this.accessLock.notifyAll();
                return;
            }
        }
        if (this.kxs == null && msg[0] != 20) {
            throw new IOException("Unexpected KEX message (type " + msg[0] + ")");
        }
        if (this.ignore_next_kex_packet) {
            this.ignore_next_kex_packet = false;
            return;
        }
        if (msg[0] == 20) {
            PacketKexInit kip;
            if (this.kxs != null && this.kxs.state != 0) {
                throw new IOException("Unexpected SSH_MSG_KEXINIT message during on-going kex exchange!");
            }
            if (this.kxs == null) {
                this.kxs = new KexState();
                this.kxs.dhgexParameters = this.nextKEXdhgexParameters;
                this.kxs.localKEX = kip = new PacketKexInit(this.nextKEXcryptoWishList, this.rnd);
                this.tm.sendKexMessage(kip.getPayload());
            }
            this.kxs.remoteKEX = kip = new PacketKexInit(msg, 0, msglen);
            this.kxs.np = this.mergeKexParameters(this.kxs.localKEX.getKexParameters(), this.kxs.remoteKEX.getKexParameters());
            if (this.kxs.np == null) {
                throw new IOException("Cannot negotiate, proposals do not match.");
            }
            if (this.kxs.remoteKEX.isFirst_kex_packet_follows() && !this.kxs.np.guessOK) {
                this.ignore_next_kex_packet = true;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1")) {
                if (this.kxs.dhgexParameters.getMin_group_len() == 0) {
                    PacketKexDhGexRequestOld dhgexreq = new PacketKexDhGexRequestOld(this.kxs.dhgexParameters);
                    this.tm.sendKexMessage(dhgexreq.getPayload());
                } else {
                    PacketKexDhGexRequest dhgexreq = new PacketKexDhGexRequest(this.kxs.dhgexParameters);
                    this.tm.sendKexMessage(dhgexreq.getPayload());
                }
                this.kxs.state = 1;
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1")) {
                this.sendKexDhInit("SHA1", 1);
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1")) {
                this.sendKexDhInit("SHA1", 14);
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha256")) {
                this.sendKexDhInit("SHA2-256", 14);
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group16-sha512")) {
                this.sendKexDhInit("SHA2-512", 16);
                return;
            }
            if (this.kxs.np.kex_algo.equals("diffie-hellman-group18-sha512")) {
                this.sendKexDhInit("SHA2-512", 18);
                return;
            }
            throw new IllegalStateException("Unkown KEX method!");
        }
        if (msg[0] == 21) {
            MAC mac;
            BlockCipher cbc;
            if (this.km == null) {
                throw new IOException("Peer sent SSH_MSG_NEWKEYS, but I have no key material ready!");
            }
            try {
                cbc = BlockCipherFactory.createCipher(this.kxs.np.enc_algo_server_to_client, false, this.km.enc_key_server_to_client, this.km.initial_iv_server_to_client);
                mac = new MAC(this.kxs.np.mac_algo_server_to_client, this.km.integrity_key_server_to_client);
            }
            catch (IllegalArgumentException e1) {
                throw new IOException("Fatal error during MAC startup!");
            }
            this.tm.changeRecvCipher(cbc, mac);
            ConnectionInfo sci = new ConnectionInfo();
            ++this.kexCount;
            sci.keyExchangeAlgorithm = this.kxs.np.kex_algo;
            sci.keyExchangeCounter = this.kexCount;
            sci.clientToServerCryptoAlgorithm = this.kxs.np.enc_algo_client_to_server;
            sci.serverToClientCryptoAlgorithm = this.kxs.np.enc_algo_server_to_client;
            sci.clientToServerMACAlgorithm = this.kxs.np.mac_algo_client_to_server;
            sci.serverToClientMACAlgorithm = this.kxs.np.mac_algo_server_to_client;
            sci.serverHostKeyAlgorithm = this.kxs.np.server_host_key_algo;
            sci.serverHostKey = this.kxs.remote_hostkey;
            Object object = this.accessLock;
            synchronized (object) {
                this.lastConnInfo = sci;
                this.accessLock.notifyAll();
            }
            this.kxs = null;
            return;
        }
        if (this.kxs == null || this.kxs.state == 0) {
            throw new IOException("Unexpected Kex submessage!");
        }
        if (this.kxs.np.kex_algo.equals("diffie-hellman-group-exchange-sha1")) {
            if (this.kxs.state == 1) {
                PacketKexDhGexGroup dhgexgrp = new PacketKexDhGexGroup(msg, 0, msglen);
                this.kxs.dhgx = new DhGroupExchange(dhgexgrp.getP(), dhgexgrp.getG());
                this.kxs.dhgx.init(this.rnd);
                PacketKexDhGexInit dhgexinit = new PacketKexDhGexInit(this.kxs.dhgx.getE());
                this.tm.sendKexMessage(dhgexinit.getPayload());
                this.kxs.state = 2;
                return;
            }
            if (this.kxs.state == 2) {
                PacketKexDhGexReply dhgexrpl = new PacketKexDhGexReply(msg, 0, msglen);
                this.kxs.remote_hostkey = dhgexrpl.getHostKey();
                if (this.verifier != null) {
                    boolean vres = false;
                    try {
                        vres = this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.remote_hostkey);
                    }
                    catch (Exception e2) {
                        throw new IOException("The server hostkey was not accepted by the verifier callback.", e2);
                    }
                    if (!vres) {
                        throw new IOException("The server hostkey was not accepted by the verifier callback");
                    }
                }
                this.kxs.dhgx.setF(dhgexrpl.getF());
                try {
                    this.kxs.H = this.kxs.dhgx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), dhgexrpl.getHostKey(), this.kxs.dhgexParameters);
                }
                catch (IllegalArgumentException e3) {
                    throw new IOException("KEX error.", e3);
                }
                boolean res = this.verifySignature(dhgexrpl.getSignature(), this.kxs.remote_hostkey);
                if (!res) {
                    throw new IOException("Hostkey signature sent by remote is wrong!");
                }
                this.kxs.K = this.kxs.dhgx.getK();
                this.finishKex(true);
                this.kxs.state = -1;
                return;
            }
            throw new IllegalStateException("Illegal State in KEX Exchange!");
        }
        if ((this.kxs.np.kex_algo.equals("diffie-hellman-group1-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha1") || this.kxs.np.kex_algo.equals("diffie-hellman-group14-sha256") || this.kxs.np.kex_algo.equals("diffie-hellman-group16-sha512") || this.kxs.np.kex_algo.equals("diffie-hellman-group18-sha512")) && this.kxs.state == 1) {
            PacketKexDHReply dhr = new PacketKexDHReply(msg, 0, msglen);
            this.kxs.remote_hostkey = dhr.getHostKey();
            if (this.verifier != null) {
                boolean vres = false;
                try {
                    vres = this.verifier.verifyServerHostKey(this.hostname, this.port, this.kxs.np.server_host_key_algo, this.kxs.remote_hostkey);
                }
                catch (Exception e4) {
                    throw new IOException("The server hostkey was not accepted by the verifier callback.", e4);
                }
                if (!vres) {
                    throw new IOException("The server hostkey was not accepted by the verifier callback");
                }
            }
            this.kxs.dhx.setF(dhr.getF());
            try {
                this.kxs.H = this.kxs.dhx.calculateH(this.csh.getClientString(), this.csh.getServerString(), this.kxs.localKEX.getPayload(), this.kxs.remoteKEX.getPayload(), dhr.getHostKey());
            }
            catch (IllegalArgumentException e5) {
                throw new IOException("KEX error.", e5);
            }
            boolean res = this.verifySignature(dhr.getSignature(), this.kxs.remote_hostkey);
            if (!res) {
                throw new IOException("Hostkey signature sent by remote is wrong!");
            }
            this.kxs.K = this.kxs.dhx.getK();
            this.finishKex(true);
            this.kxs.state = -1;
            return;
        }
        throw new IllegalStateException("Unkown KEX method! (" + this.kxs.np.kex_algo + ")");
    }

    private void sendKexDhInit(String hash, int group) throws IOException {
        this.kxs.dhx = new DhExchange(hash);
        this.kxs.dhx.clientInit(group, this.rnd);
        PacketKexDHInit kp = new PacketKexDHInit(this.kxs.dhx.getE());
        this.tm.sendKexMessage(kp.getPayload());
        this.kxs.state = 1;
    }
}

