/*
 * Decompiled with CFR 0.152.
 */
package cc.sferalabs.libs.iono_pi;

import cc.sferalabs.libs.iono_pi.DigitalInputListener;
import cc.sferalabs.libs.iono_pi.IonoPi;
import cc.sferalabs.libs.iono_pi.onewire.OneWireBusDevice;
import cc.sferalabs.libs.iono_pi.wiegand.WiegandListener;
import java.io.IOException;
import java.util.Scanner;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (Scanner in = new Scanner(System.in);){
            IonoPi.init();
            System.out.println("\n== Iono Pi Utility ==\n\nCommands:\n   led on           Turn on the green LED\n   led off          Turn off the green LED\n   o <n> open       Open relay output o<n> (<n>=1..4)\n   o <n> close      Close relay output o<n> (<n>=1..4)\n   oc <n> open      Open open collector oc<n> (<n>=1..3)\n   oc <n> close     Close open collector oc<n> (<n>=1..3)\n   di <n>           Print the state (\"high\" or \"low\") of digital input di<n> (<n>=1..6)\n   di <n> <t>       Print the state of digital input di<n> now and on every change\n                    for <t> seconds\n   ai <n>           Print the voltage value (V) read from analog input ai<n> (<n>=1..4)\n   1wire bus        Print IDs and temperature values (\u00b0C) read from all the 1-Wire\n                    devices on the bus\n   1wire ttl <n>    Print temperature (\u00b0C) and humidity (%) values read from the\n                    MaxDetect 1-Wire sensor on TTL<n> (<n>=1..4)\n   wiegand <n> <t>  Print number of bits and value read from Wiegand interface <n> (<n>=1|2)\n                    whenever data is available for <t> seconds\n   quit             You can guess it...\n");
            boolean run = true;
            block65: while (run) {
                System.out.print("\n> ");
                String line = in.nextLine().trim().toLowerCase();
                String[] parts = line.split("\\s+");
                try {
                    block17 : switch (parts[0]) {
                        case "": {
                            break;
                        }
                        case "led": {
                            boolean on = parts[1].equals("on");
                            IonoPi.LED.set(on);
                            break;
                        }
                        case "o": {
                            boolean rel_closed = parts[2].startsWith("c");
                            int n2 = Integer.parseInt(parts[1]);
                            switch (n2) {
                                case 1: {
                                    IonoPi.Output.O1.set(rel_closed);
                                    break block17;
                                }
                                case 2: {
                                    IonoPi.Output.O2.set(rel_closed);
                                    break block17;
                                }
                                case 3: {
                                    IonoPi.Output.O3.set(rel_closed);
                                    break block17;
                                }
                                case 4: {
                                    IonoPi.Output.O4.set(rel_closed);
                                    break block17;
                                }
                            }
                            throw new Exception("<n>=1..4");
                        }
                        case "oc": {
                            boolean oc_closed = parts[2].startsWith("c");
                            int n2 = Integer.parseInt(parts[1]);
                            switch (n2) {
                                case 1: {
                                    IonoPi.Output.OC1.set(oc_closed);
                                    break block17;
                                }
                                case 2: {
                                    IonoPi.Output.OC2.set(oc_closed);
                                    break block17;
                                }
                                case 3: {
                                    IonoPi.Output.OC3.set(oc_closed);
                                    break block17;
                                }
                            }
                            throw new Exception("<n>=1..3");
                        }
                        case "di": {
                            int n2 = Integer.parseInt(parts[1]);
                            int t = parts.length > 2 ? Integer.parseInt(parts[2]) : -1;
                            switch (n2) {
                                case 1: {
                                    if (t <= 0) {
                                        System.out.println(IonoPi.DigitalInput.DI1.isHigh() ? "high" : "low");
                                        break block17;
                                    }
                                    Main.monitorDigitalInput(IonoPi.DigitalInput.DI1, t);
                                    break block17;
                                }
                                case 2: {
                                    if (t <= 0) {
                                        System.out.println(IonoPi.DigitalInput.DI2.isHigh() ? "high" : "low");
                                        break block17;
                                    }
                                    Main.monitorDigitalInput(IonoPi.DigitalInput.DI2, t);
                                    break block17;
                                }
                                case 3: {
                                    if (t <= 0) {
                                        System.out.println(IonoPi.DigitalInput.DI3.isHigh() ? "high" : "low");
                                        break block17;
                                    }
                                    Main.monitorDigitalInput(IonoPi.DigitalInput.DI3, t);
                                    break block17;
                                }
                                case 4: {
                                    if (t <= 0) {
                                        System.out.println(IonoPi.DigitalInput.DI4.isHigh() ? "high" : "low");
                                        break block17;
                                    }
                                    Main.monitorDigitalInput(IonoPi.DigitalInput.DI4, t);
                                    break block17;
                                }
                                case 5: {
                                    if (t <= 0) {
                                        System.out.println(IonoPi.DigitalInput.DI5.isHigh() ? "high" : "low");
                                        break block17;
                                    }
                                    Main.monitorDigitalInput(IonoPi.DigitalInput.DI5, t);
                                    break block17;
                                }
                                case 6: {
                                    if (t <= 0) {
                                        System.out.println(IonoPi.DigitalInput.DI6.isHigh() ? "high" : "low");
                                        break block17;
                                    }
                                    Main.monitorDigitalInput(IonoPi.DigitalInput.DI6, t);
                                    break block17;
                                }
                            }
                            throw new Exception("<n>=1..6");
                        }
                        case "ai": {
                            int n2 = Integer.parseInt(parts[1]);
                            switch (n2) {
                                case 1: {
                                    System.out.println(IonoPi.AnalogInput.AI1.readVoltage());
                                    break block17;
                                }
                                case 2: {
                                    System.out.println(IonoPi.AnalogInput.AI2.readVoltage());
                                    break block17;
                                }
                                case 3: {
                                    System.out.println(IonoPi.AnalogInput.AI3.readVoltage());
                                    break block17;
                                }
                                case 4: {
                                    System.out.println(IonoPi.AnalogInput.AI4.readVoltage());
                                    break block17;
                                }
                            }
                            throw new Exception("<n>=1..4");
                        }
                        case "1wire": {
                            int n2;
                            if (parts[1].equals("bus")) {
                                for (OneWireBusDevice d2 : IonoPi.OneWire.getBusDevices()) {
                                    System.out.println("ID: " + d2.getId() + " - val: " + (double)d2.readTemperature(3) / 1000.0);
                                }
                                continue block65;
                            }
                            if (parts[1].equals("ttl")) {
                                n2 = Integer.parseInt(parts[2]);
                                if (n2 < 1 || n2 > 4) {
                                    throw new Exception("<n>=1..4");
                                }
                                IonoPi.DigitalIO ttl = IonoPi.DigitalIO.values()[n2 - 1];
                                int[] t_rh = IonoPi.OneWire.maxDetectRead(ttl, 3);
                                System.out.println(t_rh == null ? "N/A" : "T: " + (double)t_rh[0] / 10.0 + "\u00b0C - RH: " + (double)t_rh[1] / 10.0 + "%");
                                break;
                            }
                            throw new Exception("max or bus");
                        }
                        case "wiegand": {
                            int n2 = Integer.parseInt(parts[1]);
                            int t = Integer.parseInt(parts[2]);
                            switch (n2) {
                                case 1: {
                                    Main.monitorWiegand(IonoPi.Wiegand.W1, t);
                                    break block17;
                                }
                                case 2: {
                                    Main.monitorWiegand(IonoPi.Wiegand.W2, t);
                                    break block17;
                                }
                            }
                            throw new Exception("<n>=1|2");
                        }
                        case "quit": {
                            run = false;
                            break;
                        }
                        default: {
                            throw new Exception("unknown command");
                        }
                    }
                }
                catch (Exception e2) {
                    System.out.println("Command error: " + e2.getMessage());
                }
            }
        }
        finally {
            IonoPi.shutdown();
        }
    }

    private static void monitorWiegand(final IonoPi.Wiegand wg, int t) throws Exception {
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Monitoring...");
                try {
                    wg.monitor(new WiegandListener(){

                        @Override
                        public boolean onData(IonoPi.Wiegand wInterface, int count, long data) {
                            System.out.println("Bits: " + count + " - Data: " + data);
                            return true;
                        }
                    });
                }
                catch (IOException e2) {
                    System.out.println("Error: " + e2.getMessage());
                }
                System.out.println("Done!");
            }
        });
        th.start();
        try {
            Thread.sleep(t * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        wg.stop();
        th.join();
    }

    private static void monitorDigitalInput(IonoPi.DigitalInput di, int t) {
        di.setListener(new DigitalInputListener(){

            @Override
            public void onChange(IonoPi.DigitalInput input, boolean high) {
                System.out.println(high ? "high" : "low");
            }
        });
        System.out.println("Monitoring...");
        try {
            Thread.sleep(t * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Done!");
        di.setListener(null);
    }
}

