/*
 * Decompiled with CFR 0.152.
 */
package cc.sferalabs.libs.iono_pi;

import cc.sferalabs.libs.iono_pi.DigitalInputListener;
import cc.sferalabs.libs.iono_pi.Led;
import cc.sferalabs.libs.iono_pi.jni.IonoPiJNI;
import cc.sferalabs.libs.iono_pi.jni.WiegandListenerJNIWrapper;
import cc.sferalabs.libs.iono_pi.onewire.OneWire;
import cc.sferalabs.libs.iono_pi.wiegand.WiegandListener;
import java.io.IOException;
import java.util.Objects;

public abstract class IonoPi {
    public static final Led LED = new Led();
    public static final OneWire OneWire = new OneWire();

    public static void init() throws Exception {
        IonoPiJNI.init();
    }

    public static void shutdown() {
        Wiegand.W1.stop();
        Wiegand.W2.stop();
        for (DigitalInput di : DigitalInput.values()) {
            di.setListener(null);
        }
    }

    public static enum Wiegand {
        W1(1),
        W2(2);

        private final int wInterface;

        private Wiegand(int wInterface) {
            this.wInterface = wInterface;
        }

        public void monitor(WiegandListener listener) throws IOException, NullPointerException {
            Objects.requireNonNull(listener, "listener must not be null");
            if (!IonoPiJNI.ionoPiWiegandMonitor(this.wInterface, new WiegandListenerJNIWrapper(listener))) {
                throw new IOException("Wiegand error");
            }
        }

        public void stop() {
            IonoPiJNI.ionoPiWiegandStop(this.wInterface);
        }
    }

    public static enum AnalogInput {
        AI1(64),
        AI2(0),
        AI3(128),
        AI4(192);

        public final int pin;

        private AnalogInput(int pin) {
            this.pin = pin;
        }

        public int read() throws IOException {
            int val = IonoPiJNI.ionoPiAnalogRead(this.pin);
            if (val < 0) {
                throw new IOException("read error");
            }
            return val;
        }

        public float readVoltage() throws IOException {
            float val = IonoPiJNI.ionoPiVoltageRead(this.pin);
            if (val < 0.0f) {
                throw new IOException("read error");
            }
            return val;
        }
    }

    public static enum DigitalIO {
        TTL1(7),
        TTL2(25),
        TTL3(28),
        TTL4(29);

        public final int pin;

        private DigitalIO(int pin) {
            this.pin = pin;
        }

        public boolean isHigh() {
            IonoPiJNI.ionoPiPinMode(this.pin, 0);
            return IonoPiJNI.ionoPiDigitalRead(this.pin) == 1;
        }

        public void set(boolean high) {
            IonoPiJNI.ionoPiPinMode(this.pin, 1);
            IonoPiJNI.ionoPiDigitalWrite(this.pin, high ? 1 : 0);
        }
    }

    public static enum DigitalInput {
        DI1(27),
        DI2(24),
        DI3(23),
        DI4(26),
        DI5(22),
        DI6(21);

        public final int pin;

        private DigitalInput(int pin) {
            this.pin = pin;
        }

        public boolean isHigh() {
            return IonoPiJNI.ionoPiDigitalRead(this.pin) == 1;
        }

        public void setDebounce(int millis) {
            IonoPiJNI.ionoPiSetDigitalDebounce(this.pin, millis);
        }

        public void setListener(DigitalInputListener listener) {
            IonoPiJNI.ionoPiSetDigitalInputListener(this, 3, listener);
        }
    }

    public static enum Output {
        O1(0),
        O2(2),
        O3(3),
        O4(4),
        OC1(1),
        OC2(6),
        OC3(5);

        private final int pin;

        private Output(int pin) {
            this.pin = pin;
        }

        public void set(boolean closed) {
            IonoPiJNI.ionoPiDigitalWrite(this.pin, closed ? 1 : 0);
        }

        public boolean isClosed() {
            return IonoPiJNI.ionoPiDigitalRead(this.pin) == 1;
        }
    }
}

