var ListValues = {};
var ListLabels = {};
var ListFilter = {};

function uiEvent(id, attr, value) {
	if (id == "wolf8.keylist") {
		var type = id.split(".")[0];
		var filter = false;
		if (attr == "values") {
			filter = true;
			ListValues[type] = value;
		} else if (attr == "labels") {
			filter = true;
			ListLabels[type] = value;
		}

		if (filter && ListFilter[type]) {
			doFilter(type);
			return null;
		}
	}

	return value;
}

function userCommand(name, param) {
	if (name == "wolf8.search") {
		var type = name.split(".")[0];
		ListFilter[type] = param.trim();
		if (ListFilter[type]) {
			doFilter(type);
		} else {
			uiSet("wolf8.keylist", "values", ListValues[type]);
			uiSet("wolf8.keylist", "labels", ListLabels[type]);
		}
		return null;
	}
}

function doFilter(type) {
	var vals = ListValues[type].split(",");
	var labs = ListLabels[type].split(",");
	if (vals.length != labs.length) {
		return;
	}
	var valsF = "";
	var labsF = "";
	for (var i = 0; i < labs.length; i++) {
		var ll = labs[i].toLowerCase();
        if (ll.includes(ListFilter[type].toLowerCase())) {
			valsF += "," + vals[i];
			labsF += "," + labs[i];
		}
	}
	uiSet("wolf8.keylist", "values", valsF.substring(1));
	uiSet("wolf8.keylist", "labels", labsF.substring(1));
}
