ace.define('ace/snippets/javascript',['require','exports','module'], function(require, exports, module) {
var s = {
	// scopes
	events:[],
	actions:[],
	js:[]
};

exports.snippetText = s;


var a = s.js;
a.push({
	title:"function StartupEvent()",
	subTitle:"Javascript, Events",
	docHTML:"<p>Executed when the interface is first loaded.\nIt's a good place to set up the interface and set variables, for example.\n</p>",
	content:"function StartupEvent() {\n\t${1:// body...} \n}"
});
a.push({
	title:"function userCommand(name, param)",
	subTitle:"Javascript, Events",
	docHTML:"<p>Called by user clicks on user buttons: <a href=\"/3.9/index.php/User\" title=\"User\">User</a>, <a href=\"/3.9/index.php/UserMini\" class=\"mw-redirect\" title=\"UserMini\">UserMini</a>, <a href=\"/3.9/index.php/UserMicro\" class=\"mw-redirect\" title=\"UserMicro\">UserMicro</a>, <a href=\"/3.9/index.php/UserRGB\" class=\"mw-redirect\" title=\"UserRGB\">UserRGB</a> or <a href=\"/3.9/index.php/UserImage\" title=\"UserImage\">UserImage</a> objects.\n</p><p>If you want to navigate to a specific page when the button is pressed (it would be like pressing a <a href=\"/3.9/index.php/Link\" title=\"Link\">Link object</a>), return a string starting with \"page:\" followed by the page name; in this case, userCommand() will be called again when that popup or page is closed, with \"/close\" appended to param.\n</p><p>You can also use \"page:back\" or \"page:forward\" to move back and forth along the pages' navigation history. Use \"page:close\" to close a popup.\n</p><p>When the interface is loaded inside the HSYCO App (<a href=\"/3.9/index.php/HSYCO_App_for_iOS_Devices\" title=\"HSYCO App for iOS Devices\">iOS</a> or <a href=\"/3.9/index.php/HSYCO_App_for_Android_Devices\" title=\"HSYCO App for Android Devices\">Android</a>), you can send a specific command to the app by returning a string that starts with \"app:\" followed by the command; the commands currently supported are \"speech\", which enables the speech recognition, and \"codescan\" which enables qr/bar code scanning.\n</p><p>Use \"copy:<text>\" to copy a text in the clipboard.\nIn the HSYCO App you can also use \"share:<text>\" to open a popup with various options. This will behave like \"copy\" on browser.\n</p><p><b>Parameters:</b>\n</p><ul><li>name: string - the name field of the user object</li>\n<li>param: string - the param of the user object</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>null: proceed to send the request to server as it is</li>\n<li>\"\": assume the event was resolved. Don't send the request to the server</li>\n<li>\"page:page name\": navigate to the specified page</li>\n<li>\"page:back\": navigate to the previous page</li>\n<li>\"page:forward\": navigate to the next page</li>\n<li>\"page:close\": if the user button that generated the call has an open popup linked to it, close it</li>\n<li>\"error\": error. Don't send the request to the server</li>\n<li>\"copy:<text>\": tells the browser or <a href=\"/3.9/index.php/HSYCO_App\" title=\"HSYCO App\">HSYCO App</a> to copy the text in the clipboard. On browser it will display a confirm popup with the text to be copied.</li>\n<li>\"share:<text>\": tells the <a href=\"/3.9/index.php/HSYCO_App\" title=\"HSYCO App\">HSYCO App</a> to show a share popup with various options (copy, send through email, save to files etc.). On browser it will behave like copy.</li>\n<li>an object, to specify new name and param values to be sent to the server</li></ul><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>{name:\"new name\", param:\"new param\"}</pre></div>",
	content:"function userCommand(name, param) {\n\t${1:// body...} \n}"
});
a.push({
	title:"function userSubmit(name, param)",
	subTitle:"Javascript, Events",
	docHTML:"<p>Called on every submit request (from <a href=\"/3.9/index.php/Submit\" title=\"Submit\">Submit</a> objects).\nParameters and return values are the same as the userCommand function.\n</p>",
	content:"function userSubmit(name, param) {\n\t${1:// body...} \n}"
});
a.push({
	title:"function uiEvent(id, attr, value)",
	subTitle:"Javascript, Events",
	docHTML:"<p>Executed on every UISet received from the server, intercepts a UISet and allows to change it, prevent its execution or execute any other custom code (e.g. set variables).\n</p><p><b>Parameters:</b>\n</p><ul><li>id: string - id of the ui object</li>\n<li>attr: string - attribute name</li>\n<li>value: string - new value being set</li></ul><p><br>\n<b>Returns:</b>\n</p><ul><li>null: discard the UISet</li>\n<li><string>: set a new value for the UISet. To keep the UISet as it is, return the initial value</li></ul>",
	content:"function uiEvent(id, attr, value) {\n\t${1:// body...} \n}"
});
a.push({
	title:"function pageOpenEvent(name)",
	subTitle:"Javascript, Events",
	docHTML:"<p>Called when a page is opened.\n</p><p><b>Parameters:</b>\n</p><ul><li>name: string - the page's id</li></ul><p><b>Returns:</b>\n</p><ul><li>false: don't open the page. A <i>pageOpenEvent</i> is called on the previous page, as if it was reopened.</li>\n<li>null: proceed to open the page</li></ul><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>// page open event\nfunction pageOpenEvent(name) {\n\tconsole.log(\"opening \"+name);\n\tif (name ==\"wconfig\") {\n\t\tconsole.log(\"nope 1\");\n\t\treturn false;\n\t}\n}</pre></div>",
	content:"function pageOpenEvent(name) {\n\t${1:// body...} \n}"
});
a.push({
	title:"function pageCloseEvent(name)",
	subTitle:"Javascript, Events",
	docHTML:"<p>Called when a page is closed.\n</p><p><b>Parameters:</b>\n</p><ul><li>name: string - the page's id</li></ul><p><b>Returns:</b>\n</p><ul><li>false: don't close the page</li>\n<li>null: proceed to close the page</li></ul><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>// page close event\nfunction pageCloseEvent(name) {\n\tconsole.log(\"closing \"+name);\n\tif (name ==\"sconfig\") {\n\t\tconsole.log(\"nope 2\");\n\t\treturn false;\n\t}\n}</pre></div>",
	content:"function pageCloseEvent(name) {\n\t${1:// body...} \n}"
});
a.push({
	title:"function pageBackEvent(name)",
	subTitle:"Javascript, Events",
	docHTML:"<p>Called when a page back is requested.\n</p><p><b>Parameters:</b>\n</p><ul><li>name: string - the page's id</li></ul><p><b>Returns:</b>\n</p><ul><li>false: don't close the page</li>\n<li>null: proceed to close the page</li></ul><div class=\"mw-highlight mw-content-ltr\" dir=\"ltr\"><pre>// page back event\nfunction pageBackEvent(name) {\n\tconsole.log(\"backing from \"+name);\n\tif (name ==\"sconfig\") {\n\t\tconsole.log(\"nope 3\");\n\t\treturn false;\n\t}\n}</pre></div>",
	content:"function pageBackEvent(name) {\n\t${1:// body...} \n}"
});
a.push({
	title:"varSet(name,value)",
	subTitle:"Javascript, Functions",
	docHTML:"<p>Sets the value of a variable. If the name begins with <b>!</b>, the variable will be stored in the browser's cache, so that it'll available even after reloading the page or closing and reopening the browser.\n</p>",
	content:"varSet(${1:name},${2:value})"
});
a.push({
	title:"varGet(name)",
	subTitle:"Javascript, Functions",
	docHTML:"<p>Gets the value of a variable previously set with varSet.\n</p>",
	content:"varGet(${1:name})"
});
a.push({
	title:"uiSet(id,attr,value)",
	subTitle:"Javascript, Functions",
	docHTML:"<p>Sets a UI Attribute. See <a href=\"/3.9/index.php/Project\" title=\"Project\">Project</a>, <a href=\"/3.9/index.php/Page\" class=\"mw-redirect\" title=\"Page\">Page</a> or <a href=\"/3.9/index.php/UI_Objects\" title=\"UI Objects\">UI Objects</a> list of attributes.\n</p>",
	content:"uiSet(${1:id},${2:attr},${3:value})"
});
a.push({
	title:"webLog(string)",
	subTitle:"Javascript, Functions",
	docHTML:"<p>Adds a line to the daily log file, viewable from the Manager's <a href=\"/3.9/index.php/Log_Viewer\" title=\"Log Viewer\">Log Viewer</a>.\n</p>",
	content:"webLog(${1:string})"
});



// js

a.push({
	title:"fun",
	tabTrigger:"fun",
	content:"function ${1?:function_name}(${2:argument}) {\n\t${3:// body...}\n}"
});
a.push({
	title:"if",
	tabTrigger:"if",
	content:"if (${1:true}) {\n\t${0}\n}"
});
a.push({
	title:"ife",
	tabTrigger:"ife",
	content:"if (${1:true}) {\n\t${2}\n} else {\n\t${0}\n}"
});
a.push({
	title:"ter",
	tabTrigger:"ter",
	content:"${1:/* condition */} ? ${2:a} : ${3:b}"
});
a.push({
	title:"switch",
	tabTrigger:"switch",
	content:"switch (${1:expression}) {\n\tcase '${3:case}':\n\t\t${4:// code}\n\t\tbreak;\n\t${5}\n\tdefault:\n\t\t${2:// code}\n}"
});
a.push({
	title:"case",
	tabTrigger:"case",
	content:"case '${1:case}':\n\t${2:// code}\n\tbreak;\n${3}"
});
a.push({
	title:"wh",
	tabTrigger:"wh",
	content:"while (${1:/* condition */}) {\n\t${0:/* code */}\n}"
});
a.push({
	title:"try",
	tabTrigger:"try",
	content:"try {\n\t${0:/* code */}\n} catch (e) {}"
});
a.push({
	title:"do",
	tabTrigger:"do",
	content:"do {\n\t${2:/* code */}\n} while (${1:/* condition */});"
});
a.push({
	title:"setTimeout",
	tabTrigger:"setTimeout",
	content:"setTimeout(function() {${3:$TM_SELECTED_TEXT}}, ${1:10});"
});
a.push({
	title:"gett",
	tabTrigger:"gett",
	content:"getElementsBy${1:TagName}('${2}')${3}"
});
a.push({
	title:"get",
	tabTrigger:"get",
	content:"getElementBy${1:Id}('${2}')${3}"
});
a.push({
	title:"cl",
	tabTrigger:"cl",
	content:"console.log(${1});"
});
a.push({
	title:"ret",
	tabTrigger:"ret",
	content:"return ${1:result}"
});
a.push({
	title:"fori",
	tabTrigger:"fori",
	content:"for (var ${1:prop} in ${2:Things}) {\n\t${0:$2[$1]}\n}"
});
a.push({
	title:"jsonp",
	tabTrigger:"jsonp",
	content:"JSON.parse(${1:jstr});"
});
a.push({
	title:"jsons",
	tabTrigger:"jsons",
	content:"JSON.stringify(${1:object});"
});
a.push({
	title:"for-",
	tabTrigger:"for-",
	content:"for (var ${1:i} = ${2:Things}.length; ${1:i}--; ) {\n\t${0:${2:Things}[${1:i}];}\n}"
});
a.push({
	title:"for",
	tabTrigger:"for",
	content:"for (var ${1:i} = 0; $1 < ${2:Things}.length; $1++) {\n\t${3:$2[$1]}$0\n}"
});
a.push({
	title:"forr",
	tabTrigger:"forr",
	content:"for (var ${1:i} = ${2:Things}.length - 1; $1 >= 0; $1--) {\n\t${3:$2[$1]}$0\n}"
});



exports.scope = 'javascript';
});