/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreenUpMeasure {
    public static byte[] readVIF1p(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20480, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeVIF1p(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("I1", 10L * GreenUpMeasure.toLong(data, 0));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayVIF1p(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = GreenUpMeasure.decodeVIF1p(data);
            values.put("I1", GreenUpMeasure.toIntegerString(decoded.get("I1"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readVIF3p(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20480, 6);
        bb.put(data, 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeVIF3p(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("I1", 10L * GreenUpMeasure.toLong(data, 0));
            values.put("I2", 10L * GreenUpMeasure.toLong(data, 4));
            values.put("I3", 10L * GreenUpMeasure.toLong(data, 8));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayVIF3p(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = GreenUpMeasure.decodeVIF3p(data);
            values.put("I1", GreenUpMeasure.toIntegerString(decoded.get("I1"), 4, 3, false));
            values.put("I2", GreenUpMeasure.toIntegerString(decoded.get("I2"), 4, 3, false));
            values.put("I3", GreenUpMeasure.toIntegerString(decoded.get("I3"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower1p(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20538, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Long> decodePower1p(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("P", GreenUpMeasure.toLong(data, 0) / 100L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayPower1p(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = GreenUpMeasure.decodePower1p(data);
            values.put("P", GreenUpMeasure.toIntegerString(decoded.get("P"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower3p(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(16);
        byte[][] data = new byte[][]{user.modbusReadInputRegisters(gateway, unitid, 20538, 2), user.modbusReadInputRegisters(gateway, unitid, 20551, 6)};
        bb.put(data[0], 2, 4);
        bb.put(data[1], 2, 12);
        return bb.array();
    }

    public static Hashtable<String, Long> decodePower3p(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("P", GreenUpMeasure.toLong(data, 0) / 100L);
            values.put("P1", GreenUpMeasure.toLong(data, 4) / 100L);
            values.put("P2", GreenUpMeasure.toLong(data, 8) / 100L);
            values.put("P3", GreenUpMeasure.toLong(data, 12) / 100L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayPower3p(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = GreenUpMeasure.decodePower3p(data);
            values.put("P", GreenUpMeasure.toIntegerString(decoded.get("P"), 4, 3, false));
            values.put("P1", GreenUpMeasure.toIntegerString(decoded.get("P1"), 4, 3, false));
            values.put("P2", GreenUpMeasure.toIntegerString(decoded.get("P2"), 4, 3, false));
            values.put("P3", GreenUpMeasure.toIntegerString(decoded.get("P3"), 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyPos(String gateway, int unitid) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(4);
        byte[] data = user.modbusReadInputRegisters(gateway, unitid, 20592, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", GreenUpMeasure.toLong(data, 0));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Hashtable<String, Long> decoded = GreenUpMeasure.decodeEnergyPos(data);
            values.put("Ea", Long.toString(decoded.get("Ea")));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    private static long toLong(byte[] data, int index) {
        return GreenUpMeasure.decodeInteger(data, index, 4, false).longValue();
    }

    private static String toIntegerString(Long val, int digits, int decimals, boolean signed) {
        if (val == null) {
            return "";
        }
        if (signed && val == Integer.MIN_VALUE) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val.longValue() / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val.longValue() / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

